/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import org.bridj.BridJ;
import org.bridj.CallIO;
import org.bridj.CallIO$NativeObjectHandler;
import org.bridj.CallIO$Utils;
import org.bridj.DyncallStructs;
import org.bridj.LastError;
import org.bridj.NativeConstants$ValueType;
import org.bridj.NativeObject;
import org.bridj.Platform;
import org.bridj.Pointer;
import org.bridj.SizeT;
import org.bridj.StructIO;
import org.bridj.StructObject;
import org.bridj.TimeT;
import org.bridj.ValuedEnum;
import org.bridj.ann.CLong;
import org.bridj.ann.Constructor;
import org.bridj.ann.Convention;
import org.bridj.ann.Convention$Style;
import org.bridj.ann.DisableDirect;
import org.bridj.ann.Ptr;
import org.bridj.ann.SetsLastError;
import org.bridj.ann.Virtual;
import org.bridj.util.AnnotationUtils;
import org.bridj.util.Utils;

public class MethodCallInfo {
    List callIOs;
    private Class declaringClass;
    long nativeClass;
    int returnValueType;
    int[] paramsValueTypes;
    Method method;
    String methodName;
    String symbolName;
    private long forwardedPointer;
    String dcSignature;
    String javaSignature;
    String asmSignature;
    Object javaCallback;
    boolean isGenericCallback;
    boolean isObjCBlock;
    int virtualIndex = -1;
    int virtualTableOffset = 0;
    private int dcCallingConvention = 0;
    boolean isVarArgs;
    boolean isStatic;
    boolean isCPlusPlus;
    boolean direct;
    boolean startsWithThis;
    boolean bNeedsThisPointer;
    boolean throwsLastError;
    boolean setsLastError;
    boolean hasCC;

    public MethodCallInfo(Method method) {
        this(method, method);
    }

    static boolean derivesFrom(Class clazz, String string) {
        while (clazz != null) {
            if (clazz.getName().equals(string)) {
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    public MethodCallInfo(Type type, Type[] typeArray, boolean bl2) {
        this(type, new Annotation[0], typeArray, new Annotation[typeArray.length][], bl2);
    }

    public MethodCallInfo(Type type, Annotation[] annotationArray, Type[] typeArray, Annotation[][] annotationArray2, boolean bl2) {
        this.init(null, Utils.getClass(type), type, annotationArray, Utils.getClasses(typeArray), typeArray, annotationArray2, bl2, false, true);
    }

    public MethodCallInfo(Method method, Method method2) {
        List<Class<?>> list2;
        this.setMethod(method);
        this.setDeclaringClass(method.getDeclaringClass());
        this.symbolName = this.methodName;
        int n2 = method.getModifiers();
        this.isStatic = Modifier.isStatic(n2);
        this.isVarArgs = method.isVarArgs();
        boolean bl2 = Modifier.isNative(n2);
        boolean bl3 = AnnotationUtils.isAnnotationPresent(Virtual.class, method2, new Annotation[0]);
        boolean bl4 = AnnotationUtils.getInheritableAnnotation(DisableDirect.class, method2, new Annotation[0]) == null && BridJ.isDirectModeEnabled();
        this.isCPlusPlus = !this.isStatic && MethodCallInfo.derivesFrom(method.getDeclaringClass(), "org.bridj.cpp.CPPObject");
        this.isObjCBlock = !this.isStatic && MethodCallInfo.derivesFrom(method.getDeclaringClass(), "org.bridj.objc.ObjCBlock");
        this.init(method, method.getReturnType(), method.getGenericReturnType(), method.getAnnotations(), method.getParameterTypes(), method.getGenericParameterTypes(), method.getParameterAnnotations(), bl2, bl3, bl4);
        Convention convention = (Convention)AnnotationUtils.getInheritableAnnotation(Convention.class, method2, new Annotation[0]);
        if (convention != null) {
            this.setCallingConvention(convention.value());
        }
        if (!(list2 = Arrays.asList(method2.getExceptionTypes())).isEmpty()) {
            this.direct = false;
            if (list2.contains(LastError.class)) {
                this.throwsLastError = true;
                this.setsLastError = true;
            }
        }
        if (AnnotationUtils.getInheritableAnnotation(SetsLastError.class, method2, new Annotation[0]) != null) {
            this.direct = false;
            this.setsLastError = true;
        }
    }

    protected void init(AnnotatedElement annotatedElement, Class clazz, Type type, Annotation[] annotationArray, Class[] classArray, Type[] typeArray, Annotation[][] annotationArray2, boolean bl2, boolean bl3, boolean bl4) {
        assert (clazz != null);
        assert (type != null);
        assert (classArray != null);
        assert (typeArray != null);
        assert (annotationArray != null);
        assert (classArray.length == typeArray.length);
        assert (annotationArray2.length == typeArray.length);
        int n2 = typeArray.length;
        this.paramsValueTypes = new int[n2];
        this.direct = bl4;
        StringBuilder stringBuilder = new StringBuilder(64);
        StringBuilder stringBuilder2 = new StringBuilder(64);
        StringBuilder stringBuilder3 = new StringBuilder(16);
        stringBuilder.append('(');
        stringBuilder2.append('(');
        if (bl2) {
            stringBuilder3.append('p').append('p');
        }
        if (BridJ.debug) {
            BridJ.info("Analyzing " + (this.declaringClass == null ? "anonymous method" : this.declaringClass.getName() + "." + this.methodName));
        }
        if (this.isObjCBlock) {
            this.appendToSignature(0, NativeConstants$ValueType.ePointerValue, Pointer.class, (Type)((Object)Pointer.class), null, stringBuilder3, null);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            Type type2 = typeArray[i2];
            Class clazz2 = classArray[i2];
            NativeConstants$ValueType nativeConstants$ValueType = this.getValueType(i2, n2, clazz2, type2, null, annotationArray2[i2]);
            if (BridJ.veryVerbose) {
                BridJ.info("\tparam " + (Object)((Object)nativeConstants$ValueType));
            }
            this.paramsValueTypes[i2] = nativeConstants$ValueType.ordinal();
            this.appendToSignature(i2, nativeConstants$ValueType, clazz2, type2, stringBuilder, stringBuilder3, stringBuilder2);
        }
        stringBuilder.append(')');
        stringBuilder2.append(')');
        stringBuilder3.append(')');
        NativeConstants$ValueType nativeConstants$ValueType = this.getValueType(-1, n2, clazz, type, annotatedElement, annotationArray);
        if (BridJ.veryVerbose) {
            BridJ.info("\treturns " + (Object)((Object)nativeConstants$ValueType));
        }
        this.appendToSignature(-1, nativeConstants$ValueType, clazz, type, stringBuilder, stringBuilder3, stringBuilder2);
        this.returnValueType = nativeConstants$ValueType.ordinal();
        this.javaSignature = stringBuilder.toString();
        this.asmSignature = stringBuilder2.toString();
        this.dcSignature = stringBuilder3.toString();
        boolean bl5 = this.isCPlusPlus = this.isCPlusPlus || bl3;
        if (this.isCPlusPlus && !this.isStatic) {
            if (!this.startsWithThis) {
                this.direct = false;
            }
            this.bNeedsThisPointer = true;
            if (Platform.isWindows() && !Platform.is64Bits()) {
                this.setDcCallingConvention(5);
            }
        }
        if (n2 > Platform.getMaxDirectMappingArgCount()) {
            this.direct = false;
        }
        if (BridJ.veryVerbose) {
            BridJ.info("\t-> direct " + this.direct);
            BridJ.info("\t-> javaSignature " + this.javaSignature);
            BridJ.info("\t-> callIOs " + this.callIOs);
            BridJ.info("\t-> asmSignature " + this.asmSignature);
            BridJ.info("\t-> dcSignature " + this.dcSignature);
        }
        if (BridJ.veryVerbose) {
            BridJ.info((this.direct ? "[mappable as direct] " : "[not mappable as direct] ") + this.method);
        }
    }

    public boolean hasCallingConvention() {
        return this.hasCC;
    }

    public void setCallingConvention(Convention$Style convention$Style) {
        if (convention$Style == null) {
            return;
        }
        if (!Platform.isWindows() || Platform.is64Bits()) {
            return;
        }
        switch (convention$Style) {
            case FastCall: {
                this.direct = false;
                this.setDcCallingConvention(Platform.isWindows() ? 3 : 0);
                break;
            }
            case Pascal: 
            case StdCall: {
                this.direct = false;
                this.setDcCallingConvention(2);
                break;
            }
            case ThisCall: {
                this.direct = false;
                this.setDcCallingConvention(Platform.isWindows() ? 5 : 0);
            }
        }
        if (BridJ.veryVerbose) {
            BridJ.info("Setting CC " + (Object)((Object)convention$Style) + " (-> " + this.dcCallingConvention + ") for " + this.methodName);
        }
    }

    void addCallIO(CallIO callIO) {
        if (this.callIOs == null) {
            this.callIOs = new ArrayList();
        }
        assert (callIO != null);
        this.callIOs.add(callIO);
    }

    public CallIO[] getCallIOs() {
        if (this.callIOs == null) {
            return new CallIO[0];
        }
        return this.callIOs.toArray(new CallIO[this.callIOs.size()]);
    }

    public void prependCallbackCC() {
        char c2 = MethodCallInfo.getDcCallbackConvention(this.getDcCallingConvention());
        if (c2 == '\u0000') {
            return;
        }
        this.dcSignature = String.valueOf('_') + String.valueOf(c2) + this.dcSignature;
    }

    public String getDcSignature() {
        return this.dcSignature;
    }

    public String getJavaSignature() {
        return this.javaSignature;
    }

    public String getASMSignature() {
        return this.asmSignature;
    }

    boolean getBoolAnnotation(Class clazz, AnnotatedElement annotatedElement, Annotation ... annotationArray) {
        Annotation annotation = AnnotationUtils.getAnnotation(clazz, annotatedElement, annotationArray);
        return annotation != null;
    }

    public NativeConstants$ValueType getValueType(int n2, int n3, Class clazz, Type type, AnnotatedElement annotatedElement, Annotation ... annotationArray) {
        boolean bl2 = AnnotationUtils.isAnnotationPresent(Ptr.class, annotatedElement, annotationArray);
        boolean bl3 = AnnotationUtils.isAnnotationPresent(CLong.class, annotatedElement, annotationArray);
        Constructor constructor = (Constructor)AnnotationUtils.getAnnotation(Constructor.class, annotatedElement, annotationArray);
        if (bl2 || constructor != null || bl3) {
            if (clazz != Long.class && clazz != Long.TYPE) {
                throw new RuntimeException("Annotation should only be used on a long parameter, not on a " + clazz.getName());
            }
            if (bl2) {
                if (!Platform.is64Bits()) {
                    this.direct = false;
                }
            } else if (bl3) {
                if (Platform.CLONG_SIZE != 8) {
                    this.direct = false;
                }
            } else if (constructor != null) {
                this.isCPlusPlus = true;
                this.startsWithThis = true;
                if (n2 != 0) {
                    throw new RuntimeException("Annotation " + Constructor.class.getName() + " cannot have more than one (long) argument");
                }
            }
            return bl3 ? NativeConstants$ValueType.eCLongValue : NativeConstants$ValueType.eSizeTValue;
        }
        if (clazz == null || clazz.equals(Void.TYPE)) {
            return NativeConstants$ValueType.eVoidValue;
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return NativeConstants$ValueType.eIntValue;
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return !bl2 || Platform.is64Bits() ? NativeConstants$ValueType.eLongValue : NativeConstants$ValueType.eIntValue;
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return NativeConstants$ValueType.eShortValue;
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return NativeConstants$ValueType.eByteValue;
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return NativeConstants$ValueType.eBooleanValue;
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            this.usesFloats();
            return NativeConstants$ValueType.eFloatValue;
        }
        if (clazz == Character.TYPE || clazz == Character.TYPE) {
            if (Platform.WCHAR_T_SIZE != 2) {
                this.direct = false;
            }
            return NativeConstants$ValueType.eWCharValue;
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            this.usesFloats();
            return NativeConstants$ValueType.eDoubleValue;
        }
        if (clazz == org.bridj.CLong.class) {
            this.direct = false;
            return NativeConstants$ValueType.eCLongObjectValue;
        }
        if (clazz == SizeT.class) {
            this.direct = false;
            return NativeConstants$ValueType.eSizeTObjectValue;
        }
        if (clazz == TimeT.class) {
            this.direct = false;
            return NativeConstants$ValueType.eTimeTObjectValue;
        }
        if (Pointer.class.isAssignableFrom(clazz)) {
            this.direct = false;
            CallIO callIO = CallIO$Utils.createPointerCallIO(clazz, type);
            if (BridJ.veryVerbose) {
                BridJ.info("CallIO : " + callIO);
            }
            this.addCallIO(callIO);
            return NativeConstants$ValueType.ePointerValue;
        }
        if (clazz.isArray() && n2 == n3 - 1) {
            this.direct = false;
            return NativeConstants$ValueType.eEllipsis;
        }
        if (ValuedEnum.class.isAssignableFrom(clazz)) {
            this.direct = false;
            CallIO callIO = CallIO$Utils.createValuedEnumCallIO(Utils.getClass(Utils.getUniqueParameterizedTypeParameter(type)));
            if (BridJ.veryVerbose) {
                BridJ.info("CallIO : " + callIO);
            }
            this.addCallIO(callIO);
            return NativeConstants$ValueType.eIntFlagSet;
        }
        if (NativeObject.class.isAssignableFrom(clazz)) {
            Pointer pointer = null;
            if (StructObject.class.isAssignableFrom(clazz)) {
                StructIO structIO = StructIO.getInstance(clazz, type);
                try {
                    pointer = DyncallStructs.buildDCstruct(structIO.desc);
                }
                catch (Throwable throwable) {
                    BridJ.error("Unable to create low-level struct metadata for " + Utils.toString(type) + " : won't be able to use it as a by-value function argument.", throwable);
                }
            }
            this.addCallIO(new CallIO$NativeObjectHandler(clazz, type, pointer));
            this.direct = false;
            return NativeConstants$ValueType.eNativeObjectValue;
        }
        throw new NoSuchElementException("No " + NativeConstants$ValueType.class.getSimpleName() + " for class " + clazz.getName());
    }

    void usesFloats() {
    }

    public void appendToSignature(int n2, NativeConstants$ValueType nativeConstants$ValueType, Class clazz, Type type, StringBuilder stringBuilder, StringBuilder stringBuilder2, StringBuilder stringBuilder3) {
        ParameterizedType parameterizedType;
        Type[] typeArray;
        String string;
        char c2;
        String string2 = null;
        switch (nativeConstants$ValueType) {
            case eVoidValue: {
                c2 = 'v';
                string = "V";
                break;
            }
            case eIntValue: {
                c2 = 'i';
                string = "I";
                break;
            }
            case eLongValue: {
                c2 = 'l';
                string = "J";
                break;
            }
            case eCLongValue: {
                string = "J";
                c2 = 'j';
                if (Platform.CLONG_SIZE == 8) break;
                this.direct = false;
                break;
            }
            case eSizeTValue: {
                string = "J";
                if (Platform.SIZE_T_SIZE == 8) {
                    c2 = 'l';
                    break;
                }
                c2 = 'i';
                this.direct = false;
                break;
            }
            case eShortValue: {
                c2 = 's';
                string = "S";
                break;
            }
            case eDoubleValue: {
                c2 = 'd';
                string = "D";
                break;
            }
            case eFloatValue: {
                c2 = 'f';
                string = "F";
                break;
            }
            case eByteValue: {
                c2 = 'c';
                string = "B";
                break;
            }
            case eBooleanValue: {
                c2 = 'B';
                string = "Z";
                break;
            }
            case eWCharValue: {
                switch (Platform.WCHAR_T_SIZE) {
                    case 1: {
                        c2 = 'c';
                        this.direct = false;
                        break;
                    }
                    case 2: {
                        c2 = 's';
                        break;
                    }
                    case 4: {
                        c2 = 'i';
                        this.direct = false;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unhandled sizeof(wchar_t) in GetJavaTypeSignature: " + Platform.WCHAR_T_SIZE);
                    }
                }
                string = "C";
                break;
            }
            case eIntFlagSet: {
                c2 = 'i';
                string = "L" + clazz.getName().replace('.', '/') + ";";
                this.direct = false;
                break;
            }
            case eCLongObjectValue: {
                c2 = 'p';
                string = "Lorg/bridj/CLong;";
                this.direct = false;
                break;
            }
            case eSizeTObjectValue: {
                c2 = 'p';
                string = "Lorg/bridj/SizeT;";
                this.direct = false;
                break;
            }
            case eTimeTObjectValue: {
                c2 = 'p';
                string = "Lorg/bridj/TimeT;";
                this.direct = false;
                break;
            }
            case ePointerValue: {
                c2 = 'p';
                string = "L" + clazz.getName().replace('.', '/') + ";";
                this.direct = false;
                break;
            }
            case eNativeObjectValue: {
                c2 = 'T';
                string = "L" + clazz.getName().replace('.', '/') + ";";
                this.direct = false;
                break;
            }
            case eEllipsis: {
                string = "[Ljava/lang/Object;";
                c2 = '?';
                break;
            }
            default: {
                this.direct = false;
                throw new RuntimeException("Unhandled " + NativeConstants$ValueType.class.getSimpleName() + ": " + (Object)((Object)nativeConstants$ValueType));
            }
        }
        if (type instanceof ParameterizedType && n2 < 0 && (typeArray = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()) != null && typeArray.length == 1) {
            Type type2 = typeArray[0];
            if (type2 instanceof ParameterizedType) {
                type2 = ((ParameterizedType)type2).getRawType();
            }
            if (type2 instanceof Class) {
                Class clazz2 = (Class)type2;
                if (string.endsWith(";")) {
                    string2 = string.substring(0, string.length() - 1) + "<*L" + clazz2.getName().replace('.', '/') + ";>";
                }
            }
        }
        if (stringBuilder != null) {
            stringBuilder.append(string);
        }
        if (string2 == null) {
            string2 = string;
        }
        if (stringBuilder3 != null) {
            stringBuilder3.append(string2);
        }
        if (stringBuilder2 != null) {
            stringBuilder2.append(c2);
        }
    }

    public void setMethod(Method method) {
        this.method = method;
        if (method != null) {
            this.methodName = method.getName();
        }
        if (this.declaringClass == null) {
            this.setDeclaringClass(method.getDeclaringClass());
        }
    }

    public void setJavaSignature(String string) {
        this.javaSignature = string;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setDeclaringClass(Class clazz) {
        this.declaringClass = clazz;
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    public void setForwardedPointer(long l2) {
        this.forwardedPointer = l2;
    }

    public long getForwardedPointer() {
        return this.forwardedPointer;
    }

    public void setVirtualIndex(int n2) {
        this.virtualIndex = n2;
        if (BridJ.veryVerbose) {
            BridJ.info("\t-> virtualIndex " + n2);
        }
    }

    public int getVirtualIndex() {
        return this.virtualIndex;
    }

    public String getSymbolName() {
        return this.symbolName;
    }

    public void setSymbolName(String string) {
        this.symbolName = string;
    }

    static char getDcCallbackConvention(int n2) {
        switch (n2) {
            case 2: {
                return 's';
            }
            case 3: {
                return 'F';
            }
            case 4: {
                return 'f';
            }
            case 5: {
                return '+';
            }
        }
        return '\u0000';
    }

    public void setDcCallingConvention(int n2) {
        this.hasCC = true;
        this.dcCallingConvention = n2;
    }

    public int getDcCallingConvention() {
        return this.dcCallingConvention;
    }

    public Object getJavaCallback() {
        return this.javaCallback;
    }

    public void setJavaCallback(Object object) {
        this.javaCallback = object;
    }

    public void setGenericCallback(boolean bl2) {
        this.isGenericCallback = bl2;
    }

    public boolean isGenericCallback() {
        return this.isGenericCallback;
    }

    public void setNativeClass(long l2) {
        this.nativeClass = l2;
    }
}

