/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.bridj.BridJ;
import org.bridj.StructFieldDescription;
import org.bridj.ann.Alignment;
import org.bridj.ann.Array;
import org.bridj.ann.Bits;
import org.bridj.ann.CLong;
import org.bridj.ann.Field;
import org.bridj.ann.Ptr;
import org.bridj.ann.Union;
import org.bridj.util.AnnotationUtils;

class StructFieldDeclaration {
    final StructFieldDescription desc = new StructFieldDescription();
    Method setter;
    long index = -1L;
    long unionWith = -1L;
    Class valueClass;
    Class declaringClass;

    StructFieldDeclaration() {
    }

    public String toString() {
        return this.desc.name + " (index = " + this.index + (this.unionWith < 0L ? "" : ", unionWith = " + this.unionWith) + ", desc = " + this.desc + ")";
    }

    protected static boolean acceptFieldGetter(Member member, boolean bl2) {
        if (member instanceof Method && ((Method)member).getParameterTypes().length != (bl2 ? 0 : 1)) {
            return false;
        }
        if (((AnnotatedElement)((Object)member)).getAnnotation(Field.class) == null) {
            return false;
        }
        int n2 = member.getModifiers();
        return !Modifier.isStatic(n2);
    }

    protected static List listFields(Class clazz) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Method method : clazz.getMethods()) {
            if (!StructFieldDeclaration.acceptFieldGetter(method, true)) continue;
            StructFieldDeclaration object2 = StructFieldDeclaration.fromGetter(method);
            try {
                object = clazz.getMethod(method.getName(), object2.valueClass);
                if (StructFieldDeclaration.acceptFieldGetter((Member)object, false)) {
                    object2.setter = object;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object2 == null) continue;
            arrayList.add(object2);
        }
        int n2 = 0;
        for (java.lang.reflect.Field field : clazz.getFields()) {
            if (!StructFieldDeclaration.acceptFieldGetter(field, true) || (object = StructFieldDeclaration.fromField(field)) == null) continue;
            arrayList.add(object);
            ++n2;
        }
        if (n2 > 0 && BridJ.warnStructFields) {
            BridJ.warning("Struct " + clazz.getName() + " has " + n2 + " struct fields implemented as Java fields, which won't give the best performance and might require counter-intuitive calls to BridJ.readFromNative / .writeToNative. Please consider using JNAerator to generate your struct instead, or use BRIDJ_WARN_STRUCT_FIELDS=0 or -Dbridj.warnStructFields=false to mute this warning.");
        }
        return arrayList;
    }

    protected static StructFieldDeclaration fromField(java.lang.reflect.Field field) {
        StructFieldDeclaration structFieldDeclaration = StructFieldDeclaration.fromMember(field);
        structFieldDeclaration.desc.field = field;
        structFieldDeclaration.desc.valueType = field.getGenericType();
        structFieldDeclaration.valueClass = field.getType();
        return structFieldDeclaration;
    }

    protected static StructFieldDeclaration fromGetter(Method method) {
        StructFieldDeclaration structFieldDeclaration = StructFieldDeclaration.fromMember(method);
        structFieldDeclaration.desc.getter = method;
        structFieldDeclaration.desc.valueType = method.getGenericReturnType();
        structFieldDeclaration.valueClass = method.getReturnType();
        return structFieldDeclaration;
    }

    private static StructFieldDeclaration fromMember(Member member) {
        StructFieldDeclaration structFieldDeclaration = new StructFieldDeclaration();
        structFieldDeclaration.declaringClass = member.getDeclaringClass();
        String string = member.getName();
        if (string.matches("get[A-Z].*")) {
            string = Character.toLowerCase(string.charAt(3)) + string.substring(4);
        }
        structFieldDeclaration.desc.name = string;
        AnnotatedElement annotatedElement = (AnnotatedElement)((Object)member);
        Field field = annotatedElement.getAnnotation(Field.class);
        Bits bits = annotatedElement.getAnnotation(Bits.class);
        Alignment alignment = annotatedElement.getAnnotation(Alignment.class);
        Array array = annotatedElement.getAnnotation(Array.class);
        if (field != null) {
            structFieldDeclaration.index = field.value();
            structFieldDeclaration.unionWith = field.unionWith();
        }
        if (structFieldDeclaration.unionWith < 0L && structFieldDeclaration.declaringClass.getAnnotation(Union.class) != null) {
            structFieldDeclaration.unionWith = 0L;
        }
        if (bits != null) {
            structFieldDeclaration.desc.bitLength = bits.value();
        }
        if (alignment != null) {
            structFieldDeclaration.desc.alignment = alignment.value();
        }
        if (array != null) {
            long l2 = 1L;
            for (long l3 : array.value()) {
                l2 *= l3;
            }
            structFieldDeclaration.desc.arrayLength = l2;
            structFieldDeclaration.desc.isArray = true;
        }
        structFieldDeclaration.desc.isCLong = AnnotationUtils.isAnnotationPresent(CLong.class, annotatedElement, new Annotation[0]);
        structFieldDeclaration.desc.isSizeT = AnnotationUtils.isAnnotationPresent(Ptr.class, annotatedElement, new Annotation[0]);
        return structFieldDeclaration;
    }
}

