/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.demangling;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.bridj.BridJ;
import org.bridj.NativeLibrary;
import org.bridj.Platform;
import org.bridj.ann.Convention$Style;
import org.bridj.demangling.Demangler;
import org.bridj.demangling.Demangler$DemanglingException;
import org.bridj.demangling.Demangler$MemberRef;

public class Demangler$Symbol {
    final String symbol;
    long address;
    Demangler$MemberRef ref;
    boolean refParsed;
    final NativeLibrary library;
    private Convention$Style style;

    public Demangler$Symbol(String string, NativeLibrary nativeLibrary) {
        this.symbol = string;
        this.library = nativeLibrary;
    }

    public NativeLibrary getLibrary() {
        return this.library;
    }

    public Demangler$MemberRef getRef() {
        return this.ref;
    }

    public Convention$Style getStyle() {
        return this.style;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String toString() {
        return this.symbol + (this.ref == null ? "" : " (" + this.ref + ")");
    }

    public long getAddress() {
        if (this.address == 0L) {
            this.address = this.library.getSymbolAddress(this.symbol);
        }
        return this.address;
    }

    public void setAddress(long l2) {
        this.address = l2;
    }

    public Convention$Style getInferredCallingConvention() {
        if (this.style == null) {
            if (this.symbol.matches("_.*?@\\d+")) {
                this.style = Convention$Style.StdCall;
            } else if (this.symbol.matches("@.*?@\\d+")) {
                this.style = Convention$Style.FastCall;
            } else if (Platform.isWindows() && this.symbol.contains("@")) {
                try {
                    Demangler$MemberRef demangler$MemberRef = this.getParsedRef();
                    if (demangler$MemberRef != null) {
                        this.style = demangler$MemberRef.callingConvention;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return this.style;
    }

    public boolean matches(Method method) {
        if (!this.symbol.contains(Demangler.getMethodName(method))) {
            return false;
        }
        this.parse();
        try {
            if (this.ref != null) {
                boolean bl2 = this.ref.matches(method);
                if (!bl2 && BridJ.debug) {
                    BridJ.debug("Symbol " + this.symbol + " was a good candidate but expected demangled signature " + this.ref + " did not match the method " + method);
                }
                return bl2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public Demangler$MemberRef getParsedRef() {
        this.parse();
        return this.ref;
    }

    synchronized void parse() {
        if (!this.refParsed) {
            block4: {
                try {
                    this.ref = this.library.parseSymbol(this.symbol);
                }
                catch (Demangler$DemanglingException demangler$DemanglingException) {
                    if (BridJ.debug) {
                        demangler$DemanglingException.printStackTrace();
                    }
                    if (!BridJ.verbose) break block4;
                    BridJ.warning("Symbol parsing failed : " + demangler$DemanglingException.getMessage());
                }
            }
            this.refParsed = true;
        }
    }

    public String getName() {
        return this.symbol;
    }

    public boolean matchesVirtualTable(Class clazz) {
        if (!this.symbol.contains(clazz.getSimpleName())) {
            return false;
        }
        this.parse();
        try {
            if (this.ref != null) {
                return this.ref.matchesVirtualTable(clazz);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public boolean matchesConstructor(Type type, Constructor constructor) {
        if (!this.symbol.contains(Demangler.getClassName(type))) {
            return false;
        }
        this.parse();
        try {
            if (this.ref != null) {
                return this.ref.matchesConstructor(type, constructor);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public boolean matchesDestructor(Class clazz) {
        if (!this.symbol.contains(clazz.getSimpleName())) {
            return false;
        }
        this.parse();
        try {
            if (this.ref != null) {
                return this.ref.matchesDestructor(clazz);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public boolean isVirtualTable() {
        return false;
    }
}

