/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import org.bridj.ann.Forwardable;

public class AnnotationUtils {
    public static Annotation getInheritableAnnotation(Class clazz, AnnotatedElement annotatedElement, Annotation ... annotationArray) {
        return AnnotationUtils.getAnnotation(clazz, true, annotatedElement, annotationArray);
    }

    public static Annotation getAnnotation(Class clazz, AnnotatedElement annotatedElement, Annotation ... annotationArray) {
        return AnnotationUtils.getAnnotation(clazz, false, annotatedElement, annotationArray);
    }

    private static boolean isForwardable(Class clazz) {
        return clazz.isAnnotationPresent(Forwardable.class);
    }

    public static boolean isAnnotationPresent(Class clazz, Annotation ... annotationArray) {
        return AnnotationUtils.isAnnotationPresent(clazz, AnnotationUtils.isForwardable(clazz), annotationArray);
    }

    private static boolean isAnnotationPresent(Class clazz, boolean bl2, Annotation ... annotationArray) {
        for (Annotation annotation : annotationArray) {
            if (clazz.isInstance(annotation)) {
                return true;
            }
            if (!bl2 || !annotation.annotationType().isAnnotationPresent(clazz)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnnotationPresent(Class clazz, AnnotatedElement annotatedElement, Annotation ... annotationArray) {
        boolean bl2 = AnnotationUtils.isForwardable(clazz);
        if (annotatedElement != null && (bl2 ? AnnotationUtils.isAnnotationPresent(clazz, true, annotatedElement.getAnnotations()) : annotatedElement.isAnnotationPresent(clazz))) {
            return true;
        }
        if (annotationArray != null) {
            return AnnotationUtils.isAnnotationPresent(clazz, bl2, annotationArray);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static Annotation getAnnotation(Class clazz, boolean bl2, AnnotatedElement annotatedElement, Annotation ... annotationArray) {
        if (annotationArray != null) {
            for (Annotation annotation : annotationArray) {
                if (!clazz.isInstance(annotation)) continue;
                return (Annotation)clazz.cast(annotation);
            }
        }
        if (annotatedElement == null) {
            return null;
        }
        Object t2 = annotatedElement.getAnnotation(clazz);
        if (t2 != null) {
            return t2;
        }
        if (bl2) {
            if (annotatedElement instanceof Member) {
                return AnnotationUtils.getAnnotation(clazz, bl2, ((Member)((Object)annotatedElement)).getDeclaringClass(), new Annotation[0]);
            }
            if (annotatedElement instanceof Class) {
                void var7_14;
                Class clazz2 = (Class)annotatedElement;
                Class<?> clazz3 = clazz2.getDeclaringClass();
                Class clazz4 = clazz2.getSuperclass();
                while (var7_14 != null) {
                    Annotation annotation = AnnotationUtils.getAnnotation(clazz, true, (AnnotatedElement)var7_14, new Annotation[0]);
                    if (annotation != null) {
                        return annotation;
                    }
                    Class clazz5 = var7_14.getSuperclass();
                }
                if (clazz3 != null) {
                    return AnnotationUtils.getAnnotation(clazz, bl2, clazz3, new Annotation[0]);
                }
            }
        }
        return null;
    }
}

