/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WebKit;
import org.eclipse.swt.browser.WebUIDelegate$1;
import org.eclipse.swt.browser.WebUIDelegate$2;
import org.eclipse.swt.browser.WebUIDelegate$3;
import org.eclipse.swt.browser.WebUIDelegate$4;
import org.eclipse.swt.browser.WebUIDelegate$5;
import org.eclipse.swt.browser.WebUIDelegate$6;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IPropertyBag;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.ole.win32.VARIANT;
import org.eclipse.swt.internal.webkit.IWebDataSource;
import org.eclipse.swt.internal.webkit.IWebFrame;
import org.eclipse.swt.internal.webkit.IWebFramePrivate;
import org.eclipse.swt.internal.webkit.IWebOpenPanelResultListener;
import org.eclipse.swt.internal.webkit.IWebURLRequest;
import org.eclipse.swt.internal.webkit.IWebView;
import org.eclipse.swt.internal.webkit.WebKit_win32;
import org.eclipse.swt.internal.win32.DOCINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PRINTDLG;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

class WebUIDelegate {
    COMObject iWebUIDelegate;
    int refCount = 0;
    String lastHoveredLinkURL;
    Browser browser;
    Point size;
    Point location;
    boolean menuBar = true;
    boolean toolBar = true;
    boolean statusBar = true;
    boolean prompt = true;

    WebUIDelegate(Browser browser) {
        this.createCOMInterfaces();
        this.browser = browser;
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    int canTakeFocus(int n2, int n3, int n4) {
        OS.MoveMemory(n4, new int[]{1}, 4);
        return 0;
    }

    int contextMenuItemsForElement(int n2, int n3, int n4, int n5) {
        Point point = this.browser.getDisplay().getCursorLocation();
        Event event = new Event();
        event.x = point.x;
        event.y = point.y;
        this.browser.notifyListeners(35, event);
        if (event.doit) {
            Menu menu = this.browser.getMenu();
            if (menu != null && !menu.isDisposed()) {
                if (event.x != point.x || event.y != point.y) {
                    menu.setLocation(event.x, event.y);
                }
                menu.setVisible(true);
            } else {
                OS.MoveMemory(n5, new int[]{n4}, C.PTR_SIZEOF);
                return 0;
            }
        }
        OS.MoveMemory(n5, new int[]{0}, C.PTR_SIZEOF);
        return 0;
    }

    void createCOMInterfaces() {
        this.iWebUIDelegate = new WebUIDelegate$1(this, new int[]{2, 0, 0, 3, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 4, 4, 2, 3, 4, 4, 3, 3, 3, 3, 5, 3, 1, 3, 2, 2, 2, 2, 3, 2, 3, 1, 1, 0, 0, 1, 1, 2, 2, 2, 2, 3, 5, 2, 2, 3, 1, 2, 2, 4, 10, 3});
    }

    int createWebViewWithRequest(int n2, int n3, int n4) {
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        windowEvent.required = true;
        OpenWindowListener[] openWindowListenerArray = this.browser.webBrowser.openWindowListeners;
        for (int i2 = 0; i2 < openWindowListenerArray.length; ++i2) {
            openWindowListenerArray[i2].open(windowEvent);
        }
        IWebView iWebView = null;
        Widget widget = null;
        if (windowEvent.browser != null && windowEvent.browser.webBrowser instanceof WebKit) {
            widget = windowEvent.browser;
        }
        if (widget != null && !widget.isDisposed()) {
            iWebView = ((WebKit)((Browser)widget).webBrowser).webView;
            OS.MoveMemory(n4, new int[]{iWebView.getAddress()}, OS.PTR_SIZEOF);
            if (n3 != 0) {
                IWebURLRequest iWebURLRequest = new IWebURLRequest(n3);
                int[] nArray = new int[1];
                int n5 = iWebURLRequest.URL(nArray);
                if (n5 != 0 || nArray[0] == 0) {
                    return 0;
                }
                String string = WebKit.extractBSTR(nArray[0]);
                COM.SysFreeString(nArray[0]);
                if (string.length() != 0) {
                    nArray[0] = 0;
                    n5 = iWebView.mainFrame(nArray);
                    if (n5 != 0 || nArray[0] == 0) {
                        return 0;
                    }
                    IWebFrame iWebFrame = new IWebFrame(nArray[0]);
                    iWebFrame.loadRequest(iWebURLRequest.getAddress());
                    iWebFrame.Release();
                }
            }
            return 0;
        }
        return -2147467263;
    }

    protected void disposeCOMInterfaces() {
        if (this.iWebUIDelegate != null) {
            this.iWebUIDelegate.dispose();
            this.iWebUIDelegate = null;
        }
    }

    int getAddress() {
        return this.iWebUIDelegate.getAddress();
    }

    int mouseDidMoveOverElement(int n2, int n3, int n4) {
        int n5;
        int n6;
        if (n3 == 0) {
            return 0;
        }
        IPropertyBag iPropertyBag = new IPropertyBag(n3);
        int n7 = WebKit.createBSTR("WebElementLinkURLKey");
        int n8 = iPropertyBag.Read(n7, n6 = OS.HeapAlloc(n5 = OS.GetProcessHeap(), 8, VARIANT.sizeof), null);
        if (n8 != 0 || n6 == 0) {
            return 0;
        }
        String string = null;
        VARIANT vARIANT = new VARIANT();
        COM.MoveMemory(vARIANT, n6, VARIANT.sizeof);
        if (vARIANT.vt == 8) {
            string = WebKit.extractBSTR(vARIANT.lVal);
        }
        OS.HeapFree(n5, 0, n6);
        StatusTextListener[] statusTextListenerArray = this.browser.webBrowser.statusTextListeners;
        if (string == null || string.length() == 0) {
            if (this.lastHoveredLinkURL == null) {
                return 0;
            }
            this.lastHoveredLinkURL = null;
            StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
            statusTextEvent.display = this.browser.getDisplay();
            statusTextEvent.widget = this.browser;
            statusTextEvent.text = "";
            for (int i2 = 0; i2 < statusTextListenerArray.length; ++i2) {
                statusTextListenerArray[i2].changed(statusTextEvent);
            }
            return 0;
        }
        if (string.equals(this.lastHoveredLinkURL)) {
            return 0;
        }
        this.lastHoveredLinkURL = string;
        StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
        statusTextEvent.display = this.browser.getDisplay();
        statusTextEvent.widget = this.browser;
        statusTextEvent.text = string;
        for (int i3 = 0; i3 < statusTextListenerArray.length; ++i3) {
            statusTextListenerArray[i3].changed(statusTextEvent);
        }
        return 0;
    }

    int printFrame(int n2, int n3) {
        int n4;
        Object object;
        IWebFrame iWebFrame = new IWebFrame(n3);
        PRINTDLG pRINTDLG = new PRINTDLG();
        pRINTDLG.lStructSize = PRINTDLG.sizeof;
        pRINTDLG.Flags = 256;
        Display display = this.browser.getDisplay();
        display.sendPreExternalEventDispatchEvent();
        boolean bl2 = OS.PrintDlg(pRINTDLG);
        display.sendPostExternalEventDispatchEvent();
        if (!bl2) {
            return 0;
        }
        int n5 = pRINTDLG.hDC;
        int[] nArray = new int[1];
        int n6 = iWebFrame.QueryInterface(WebKit_win32.IID_IWebFramePrivate, nArray);
        if (n6 != 0 || nArray[0] == 0) {
            return 0;
        }
        IWebFramePrivate iWebFramePrivate = new IWebFramePrivate(nArray[0]);
        iWebFramePrivate.setInPrintingMode(1, n5);
        int[] nArray2 = new int[1];
        n6 = iWebFramePrivate.getPrintedPageCount(n5, nArray2);
        if (n6 != 0 || nArray2[0] == 0) {
            iWebFramePrivate.Release();
            return 0;
        }
        int n7 = nArray2[0];
        String string = null;
        nArray[0] = 0;
        n6 = iWebFrame.dataSource(nArray);
        if (n6 == 0 && nArray[0] != 0) {
            object = new IWebDataSource(nArray[0]);
            nArray[0] = 0;
            n6 = ((IWebDataSource)object).pageTitle(nArray);
            ((IUnknown)object).Release();
            if (n6 == 0 && nArray[0] != 0) {
                string = WebKit.extractBSTR(nArray[0]);
                COM.SysFreeString(nArray[0]);
            }
        }
        object = new DOCINFO();
        ((DOCINFO)object).cbSize = DOCINFO.sizeof;
        int n8 = OS.GetProcessHeap();
        int n9 = 0;
        if (string != null && string.length() != 0) {
            TCHAR tCHAR = new TCHAR(0, string, true);
            n4 = tCHAR.length() * TCHAR.sizeof;
            n9 = OS.HeapAlloc(n8, 8, n4);
            OS.MoveMemory(n9, tCHAR, n4);
            ((DOCINFO)object).lpszDocName = n9;
        }
        int n10 = OS.StartDoc(n5, (DOCINFO)object);
        if (n9 != 0) {
            OS.HeapFree(n8, 0, n9);
        }
        if (n10 >= 0) {
            for (n4 = 0; n4 < n7; ++n4) {
                OS.StartPage(n5);
                iWebFramePrivate.spoolPages(n5, n4, n4, null);
                OS.EndPage(n5);
            }
            iWebFramePrivate.setInPrintingMode(0, n5);
            OS.EndDoc(n5);
        }
        iWebFramePrivate.Release();
        return 0;
    }

    int QueryInterface(int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            return -2147024809;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, n2, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown)) {
            COM.MoveMemory(n3, new int[]{this.iWebUIDelegate.getAddress()}, OS.PTR_SIZEOF);
            new IUnknown(this.iWebUIDelegate.getAddress()).AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, WebKit_win32.IID_IWebUIDelegate)) {
            COM.MoveMemory(n3, new int[]{this.iWebUIDelegate.getAddress()}, OS.PTR_SIZEOF);
            new IUnknown(this.iWebUIDelegate.getAddress()).AddRef();
            return 0;
        }
        COM.MoveMemory(n3, new int[]{0}, OS.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int runBeforeUnloadConfirmPanelWithMessage(int n2, int n3, int n4, int n5) {
        if (!this.prompt) {
            return 0;
        }
        Shell shell = this.browser.getShell();
        String string = WebKit.extractBSTR(n3);
        StringBuffer stringBuffer = new StringBuffer(Compatibility.getMessage("SWT_OnBeforeUnload_Message1"));
        stringBuffer.append("\n\n");
        stringBuffer.append(string);
        stringBuffer.append("\n\n");
        stringBuffer.append(Compatibility.getMessage("SWT_OnBeforeUnload_Message2"));
        MessageBox messageBox = new MessageBox(shell, 292);
        messageBox.setMessage(stringBuffer.toString());
        int[] nArray = new int[]{messageBox.open() == 32 ? 1 : 0};
        OS.MoveMemory(n5, nArray, 4);
        return 0;
    }

    int runJavaScriptAlertPanelWithMessage(int n2, int n3) {
        String string = WebKit.extractBSTR(n3);
        this.showAlertMessage("Javascript", string);
        return 0;
    }

    int runJavaScriptConfirmPanelWithMessage(int n2, int n3, int n4) {
        String string = WebKit.extractBSTR(n3);
        int[] nArray = new int[]{this.showConfirmPanel("Javascript", string) == 32 ? 1 : 0};
        OS.MoveMemory(n4, nArray, 4);
        return 0;
    }

    int runJavaScriptTextInputPanelWithPrompt(int n2, int n3, int n4, int n5) {
        String string = WebKit.extractBSTR(n3);
        String string2 = WebKit.extractBSTR(n4);
        String string3 = this.showTextPrompter("Javascript", string, string2);
        int[] nArray = new int[1];
        if (string3 != null) {
            nArray[0] = WebKit.createBSTR(string3);
        }
        OS.MoveMemory(n5, nArray, C.PTR_SIZEOF);
        return 0;
    }

    int runOpenPanelForFileButtonWithResultListener(int n2, int n3) {
        Shell shell = this.browser.getShell();
        FileDialog fileDialog = new FileDialog(shell, 0);
        String string = fileDialog.open();
        IWebOpenPanelResultListener iWebOpenPanelResultListener = new IWebOpenPanelResultListener(n3);
        if (string == null) {
            iWebOpenPanelResultListener.cancel();
        } else {
            iWebOpenPanelResultListener.chooseFilename(WebKit.createBSTR(string));
        }
        return 0;
    }

    int setFrame(int n2, int n3) {
        RECT rECT = new RECT();
        COM.MoveMemory(rECT, n3, RECT.sizeof);
        this.location = DPIUtil.autoScaleUp(this.browser.getDisplay().map((Control)this.browser, null, DPIUtil.autoScaleDown(new Point(rECT.left, rECT.top))));
        int n4 = rECT.right - rECT.left;
        int n5 = rECT.bottom - rECT.top;
        if (n5 < 0 || n4 < 0 || n4 == 0 && n5 == 0) {
            return 0;
        }
        this.size = new Point(n4, n5);
        return 0;
    }

    int setMenuBarVisible(int n2, int n3) {
        this.menuBar = n3 == 1;
        return 0;
    }

    int setStatusBarVisible(int n2, int n3) {
        this.statusBar = n3 == 1;
        return 0;
    }

    int setStatusText(int n2, int n3) {
        String string = WebKit.extractBSTR(n3);
        if (string.length() == 0) {
            return 0;
        }
        StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
        statusTextEvent.display = this.browser.getDisplay();
        statusTextEvent.widget = this.browser;
        statusTextEvent.text = string;
        StatusTextListener[] statusTextListenerArray = this.browser.webBrowser.statusTextListeners;
        for (int i2 = 0; i2 < statusTextListenerArray.length; ++i2) {
            statusTextListenerArray[i2].changed(statusTextEvent);
        }
        return 0;
    }

    int setToolbarsVisible(int n2, int n3) {
        this.toolBar = n3 == 1;
        return 0;
    }

    void showAlertMessage(String string, String string2) {
        Shell shell = this.browser.getShell();
        Shell shell2 = new Shell(shell, 67680);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 20;
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 10;
        shell2.setLayout(gridLayout);
        shell2.setText(string);
        Label label = new Label(shell2, 0);
        Image image = shell2.getDisplay().getSystemImage(8);
        label.setImage(image);
        label = new Label(shell2, 64);
        label.setText(string2);
        Monitor monitor = shell.getMonitor();
        int n2 = monitor.getBounds().width * 2 / 3;
        int n3 = label.computeSize((int)-1, (int)-1).x;
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = Math.min(n3, n2);
        label.setLayoutData(gridData);
        Button button = new Button(shell2, 8);
        button.setText(SWT.getMessage("SWT_OK"));
        n3 = button.computeSize((int)-1, (int)-1).x;
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 0x1000000;
        gridData2.verticalAlignment = 0x1000000;
        gridData2.horizontalSpan = 2;
        gridData2.widthHint = Math.max(n3, 75);
        button.setLayoutData(gridData2);
        button.addSelectionListener(new WebUIDelegate$2(this, shell2));
        shell2.setDefaultButton(button);
        shell2.pack();
        Rectangle rectangle = shell.getBounds();
        Rectangle rectangle2 = shell2.getBounds();
        int n4 = shell.getLocation().x + (rectangle.width - rectangle2.width) / 2;
        int n5 = shell.getLocation().y + (rectangle.height - rectangle2.height) / 2;
        shell2.setLocation(n4, n5);
        shell2.open();
        Display display = this.browser.getDisplay();
        while (!shell2.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    int showConfirmPanel(String string, String string2) {
        Shell shell = this.browser.getShell();
        Shell shell2 = new Shell(shell, 67680);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 20;
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 10;
        shell2.setLayout(gridLayout);
        shell2.setText(string);
        Label label = new Label(shell2, 0);
        Image image = shell2.getDisplay().getSystemImage(4);
        label.setImage(image);
        label.setLayoutData(new GridData());
        label = new Label(shell2, 64);
        label.setText(string2);
        Monitor monitor = shell.getMonitor();
        int n2 = monitor.getBounds().width * 2 / 3;
        int n3 = label.computeSize((int)-1, (int)-1).x;
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = Math.min(n3, n2);
        label.setLayoutData(gridData);
        Composite composite = new Composite(shell2, 0);
        gridData = new GridData(0x1000000, 0x1000000, true, true, 2, 1);
        composite.setLayoutData(gridData);
        composite.setLayout(new GridLayout(2, true));
        Button button = new Button(composite, 8);
        button.setText(SWT.getMessage("SWT_OK"));
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 0x1000000;
        gridData2.verticalAlignment = 0x1000000;
        button.setLayoutData(gridData2);
        Button button2 = new Button(composite, 8);
        button2.setText(SWT.getMessage("SWT_Cancel"));
        button2.setLayoutData(gridData2);
        n3 = button2.computeSize((int)-1, (int)-1).x;
        gridData2.widthHint = Math.max(n3, 75);
        int[] nArray = new int[1];
        button.addSelectionListener(new WebUIDelegate$3(this, nArray, shell2));
        button2.addSelectionListener(new WebUIDelegate$4(this, nArray, shell2));
        shell2.setDefaultButton(button);
        shell2.pack();
        Rectangle rectangle = shell.getBounds();
        Rectangle rectangle2 = shell2.getBounds();
        int n4 = shell.getLocation().x + (rectangle.width - rectangle2.width) / 2;
        int n5 = shell.getLocation().y + (rectangle.height - rectangle2.height) / 2;
        shell2.setLocation(n4, n5);
        shell2.open();
        Display display = this.browser.getDisplay();
        while (!shell2.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return nArray[0];
    }

    String showTextPrompter(String string, String string2, String string3) {
        Shell shell = this.browser.getShell();
        Shell shell2 = new Shell(shell, 67680);
        shell2.setLayout(new GridLayout());
        shell2.setText(string);
        Label label = new Label(shell2, 0);
        label.setLayoutData(new GridData(768));
        label.setText(string2);
        Text text = new Text(shell2, 2052);
        GridData gridData = new GridData(768);
        gridData.widthHint = 300;
        text.setLayoutData(gridData);
        text.setText(string3);
        Composite composite = new Composite(shell2, 0);
        composite.setLayout(new GridLayout(2, true));
        composite.setLayoutData(new GridData(64));
        Button button = new Button(composite, 8);
        button.setText(SWT.getMessage("SWT_OK"));
        button.setLayoutData(new GridData(768));
        String[] stringArray = new String[1];
        button.addSelectionListener(new WebUIDelegate$5(this, stringArray, text, shell2));
        Button button2 = new Button(composite, 8);
        button2.setText(SWT.getMessage("SWT_Cancel"));
        button2.setLayoutData(new GridData(768));
        button2.addSelectionListener(new WebUIDelegate$6(this, shell2));
        shell2.setDefaultButton(button);
        shell2.pack();
        Rectangle rectangle = shell.getBounds();
        Rectangle rectangle2 = shell2.getBounds();
        int n2 = shell.getLocation().x + (rectangle.width - rectangle2.width) / 2;
        int n3 = shell.getLocation().y + (rectangle.height - rectangle2.height) / 2;
        shell2.setLocation(n2, n3);
        shell2.open();
        Display display = this.browser.getDisplay();
        while (!shell2.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return stringArray[0];
    }

    int takeFocus(int n2, int n3) {
        int n4 = n3 == 0 ? 8 : 16;
        ((WebKit)this.browser.webBrowser).traverseOut = true;
        this.browser.traverse(n4);
        return 0;
    }

    int webViewClose(int n2) {
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        CloseWindowListener[] closeWindowListenerArray = this.browser.webBrowser.closeWindowListeners;
        for (int i2 = 0; i2 < closeWindowListenerArray.length; ++i2) {
            closeWindowListenerArray[i2].close(windowEvent);
        }
        this.browser.dispose();
        return 0;
    }

    int webViewFrame(int n2, int n3) {
        RECT rECT = new RECT();
        OS.MoveMemory(n3, rECT, RECT.sizeof);
        return 0;
    }

    int webViewShow(int n2) {
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        if (this.location != null) {
            windowEvent.location = this.location;
        }
        if (this.size != null) {
            windowEvent.size = this.size;
        }
        windowEvent.addressBar = this.toolBar;
        windowEvent.menuBar = this.menuBar;
        windowEvent.statusBar = this.statusBar;
        windowEvent.toolBar = this.toolBar;
        VisibilityWindowListener[] visibilityWindowListenerArray = this.browser.webBrowser.visibilityWindowListeners;
        for (int i2 = 0; i2 < visibilityWindowListenerArray.length; ++i2) {
            visibilityWindowListenerArray[i2].show(windowEvent);
        }
        this.location = null;
        this.size = null;
        return 0;
    }
}

