/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.PopupList$1;
import org.eclipse.swt.custom.PopupList$2;
import org.eclipse.swt.custom.PopupList$3;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class PopupList {
    Shell shell;
    List list;
    int minimumWidth;

    public PopupList(Shell shell) {
        this(shell, 0);
    }

    public PopupList(Shell shell, int n2) {
        int n3 = 516;
        if ((n2 & 0x100) != 0) {
            n3 |= 0x100;
        }
        this.shell = new Shell(shell, PopupList.checkStyle(n2));
        this.list = new List(this.shell, n3);
        this.shell.addListener(27, event -> this.shell.setVisible(false));
        this.shell.addControlListener(new PopupList$1(this));
        this.list.addMouseListener(new PopupList$2(this));
        this.list.addKeyListener(new PopupList$3(this));
    }

    private static int checkStyle(int n2) {
        int n3 = 0x6000000;
        return n2 & n3;
    }

    public Font getFont() {
        return this.list.getFont();
    }

    public String[] getItems() {
        return this.list.getItems();
    }

    public int getMinimumWidth() {
        return this.minimumWidth;
    }

    public String open(Rectangle rectangle) {
        Point point = this.list.computeSize(rectangle.width, -1, false);
        Rectangle rectangle2 = this.shell.getDisplay().getBounds();
        int n2 = rectangle2.height - (rectangle.y + rectangle.height) - 30;
        int n3 = rectangle.y - 30;
        int n4 = 0;
        if (n3 > n2 && point.y > n2) {
            point.y = point.y > n3 ? n3 : (point.y += 2);
            n4 = rectangle.y - point.y;
        } else {
            point.y = point.y > n2 ? n2 : (point.y += 2);
            n4 = rectangle.y + rectangle.height;
        }
        point.x = rectangle.width;
        if (point.x < this.minimumWidth) {
            point.x = this.minimumWidth;
        }
        int n5 = rectangle.x + rectangle.width - point.x;
        this.shell.setBounds(n5, n4, point.x, point.y);
        this.shell.open();
        this.list.setFocus();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed() && this.shell.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        String string = null;
        if (!this.shell.isDisposed()) {
            String[] stringArray = this.list.getSelection();
            this.shell.dispose();
            if (stringArray.length != 0) {
                string = stringArray[0];
            }
        }
        return string;
    }

    public void select(String string) {
        String[] stringArray = this.list.getItems();
        if (string != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (!stringArray[i2].startsWith(string)) continue;
                int n2 = this.list.indexOf(stringArray[i2]);
                this.list.select(n2);
                break;
            }
        }
    }

    public void setFont(Font font) {
        this.list.setFont(font);
    }

    public void setItems(String[] stringArray) {
        this.list.setItems(stringArray);
    }

    public void setMinimumWidth(int n2) {
        if (n2 < 0) {
            SWT.error(5);
        }
        this.minimumWidth = n2;
    }
}

