/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.DefaultContent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.StyledTextEvent;
import org.eclipse.swt.custom.StyledTextPrintOptions;
import org.eclipse.swt.custom.StyledTextRenderer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;

class StyledText$Printing
implements Runnable {
    static final int LEFT = 0;
    static final int CENTER = 1;
    static final int RIGHT = 2;
    Printer printer;
    StyledTextRenderer printerRenderer;
    StyledTextPrintOptions printOptions;
    Rectangle clientArea;
    FontData fontData;
    Font printerFont;
    Map resources;
    int tabLength;
    GC gc;
    int pageWidth;
    int startPage;
    int endPage;
    int scope;
    int startLine;
    int endLine;
    boolean singleLine;
    Point selection = null;
    boolean mirrored;
    int lineSpacing;
    int printMargin;

    StyledText$Printing(StyledText styledText, Printer printer, StyledTextPrintOptions styledTextPrintOptions) {
        this.printer = printer;
        this.printOptions = styledTextPrintOptions;
        this.mirrored = (styledText.getStyle() & 0x8000000) != 0;
        this.singleLine = styledText.isSingleLine();
        this.startPage = 1;
        this.endPage = Integer.MAX_VALUE;
        PrinterData printerData = printer.getPrinterData();
        this.scope = printerData.scope;
        if (this.scope == 1) {
            this.startPage = printerData.startPage;
            this.endPage = printerData.endPage;
            if (this.endPage < this.startPage) {
                int n2 = this.endPage;
                this.endPage = this.startPage;
                this.startPage = n2;
            }
        } else if (this.scope == 2) {
            this.selection = styledText.getSelectionRange();
        }
        this.printerRenderer = new StyledTextRenderer(printer, null);
        this.printerRenderer.setContent(this.copyContent(styledText.getContent()));
        this.cacheLineData(styledText);
    }

    void cacheLineData(StyledText styledText) {
        StyleRange[] styleRangeArray;
        Object object;
        StyledTextRenderer styledTextRenderer = styledText.renderer;
        styledTextRenderer.copyInto(this.printerRenderer);
        this.fontData = styledText.getFont().getFontData()[0];
        this.tabLength = styledText.tabLength;
        int n2 = this.printerRenderer.lineCount;
        if (styledText.isListening(3001) || styledText.isListening(3007) || styledText.isListening(3002)) {
            object = this.printerRenderer.content;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = object.getLine(i2);
                int n3 = object.getOffsetAtLine(i2);
                StyledTextEvent styledTextEvent = styledText.getLineBackgroundData(n3, string);
                if (styledTextEvent != null && styledTextEvent.lineBackground != null) {
                    this.printerRenderer.setLineBackground(i2, 1, styledTextEvent.lineBackground);
                }
                if ((styledTextEvent = styledText.getBidiSegments(n3, string)) != null) {
                    this.printerRenderer.setLineSegments(i2, 1, styledTextEvent.segments);
                    this.printerRenderer.setLineSegmentChars(i2, 1, styledTextEvent.segmentsChars);
                }
                if ((styledTextEvent = styledText.getLineStyleData(n3, string)) == null) continue;
                this.printerRenderer.setLineIndent(i2, 1, styledTextEvent.indent);
                this.printerRenderer.setLineAlignment(i2, 1, styledTextEvent.alignment);
                this.printerRenderer.setLineJustify(i2, 1, styledTextEvent.justify);
                this.printerRenderer.setLineBullet(i2, 1, styledTextEvent.bullet);
                styleRangeArray = styledTextEvent.styles;
                if (styleRangeArray == null || styleRangeArray.length <= 0) continue;
                this.printerRenderer.setStyleRanges(styledTextEvent.ranges, styleRangeArray);
            }
        }
        object = styledText.getDisplay().getDPI();
        Point point = this.printer.getDPI();
        this.resources = new HashMap();
        for (int i3 = 0; i3 < n2; ++i3) {
            int n4;
            Color color = this.printerRenderer.getLineBackground(i3, null);
            if (color != null) {
                if (this.printOptions.printLineBackground) {
                    Color color2 = (Color)this.resources.get(color);
                    if (color2 == null) {
                        color2 = new Color((Device)this.printer, color.getRGB());
                        this.resources.put(color, color2);
                    }
                    this.printerRenderer.setLineBackground(i3, 1, color2);
                } else {
                    this.printerRenderer.setLineBackground(i3, 1, null);
                }
            }
            if ((n4 = this.printerRenderer.getLineIndent(i3, 0)) == 0) continue;
            this.printerRenderer.setLineIndent(i3, 1, n4 * point.x / ((Point)object).x);
        }
        StyleRange[] styleRangeArray2 = this.printerRenderer.styles;
        for (int i4 = 0; i4 < this.printerRenderer.styleCount; ++i4) {
            Object object2;
            Resource resource;
            StyleRange styleRange = styleRangeArray2[i4];
            styleRangeArray = styleRange.font;
            if (styleRange.font != null) {
                resource = (Font)this.resources.get(styleRangeArray);
                if (resource == null) {
                    resource = new Font((Device)this.printer, styleRangeArray.getFontData());
                    this.resources.put(styleRangeArray, resource);
                }
                styleRange.font = resource;
            }
            if ((resource = styleRange.foreground) != null) {
                object2 = (Color)this.resources.get(resource);
                if (this.printOptions.printTextForeground) {
                    if (object2 == null) {
                        object2 = new Color((Device)this.printer, ((Color)resource).getRGB());
                        this.resources.put(resource, object2);
                    }
                    styleRange.foreground = object2;
                } else {
                    styleRange.foreground = null;
                }
            }
            if ((resource = styleRange.background) != null) {
                object2 = (Color)this.resources.get(resource);
                if (this.printOptions.printTextBackground) {
                    if (object2 == null) {
                        object2 = new Color((Device)this.printer, ((Color)resource).getRGB());
                        this.resources.put(resource, object2);
                    }
                    styleRange.background = object2;
                } else {
                    styleRange.background = null;
                }
            }
            if (!this.printOptions.printTextFontStyle) {
                styleRange.fontStyle = 0;
            }
            styleRange.rise = styleRange.rise * point.y / ((Point)object).y;
            object2 = styleRange.metrics;
            if (object2 == null) continue;
            ((GlyphMetrics)object2).ascent = ((GlyphMetrics)object2).ascent * point.y / ((Point)object).y;
            ((GlyphMetrics)object2).descent = ((GlyphMetrics)object2).descent * point.y / ((Point)object).y;
            ((GlyphMetrics)object2).width = ((GlyphMetrics)object2).width * point.x / ((Point)object).x;
        }
        this.lineSpacing = styledText.lineSpacing * point.y / ((Point)object).y;
        if (this.printOptions.printLineNumbers) {
            this.printMargin = 3 * point.x / ((Point)object).x;
        }
    }

    StyledTextContent copyContent(StyledTextContent styledTextContent) {
        DefaultContent defaultContent = new DefaultContent();
        int n2 = 0;
        for (int i2 = 0; i2 < styledTextContent.getLineCount(); ++i2) {
            int n3 = i2 < styledTextContent.getLineCount() - 1 ? styledTextContent.getOffsetAtLine(i2 + 1) : styledTextContent.getCharCount();
            defaultContent.replaceTextRange(n2, 0, styledTextContent.getTextRange(n2, n3 - n2));
            n2 = n3;
        }
        return defaultContent;
    }

    void dispose() {
        if (this.gc != null) {
            this.gc.dispose();
            this.gc = null;
        }
        if (this.resources != null) {
            for (Resource resource : this.resources.values()) {
                resource.dispose();
            }
            this.resources = null;
        }
        if (this.printerFont != null) {
            this.printerFont.dispose();
            this.printerFont = null;
        }
        if (this.printerRenderer != null) {
            this.printerRenderer.dispose();
            this.printerRenderer = null;
        }
    }

    void init() {
        Rectangle rectangle = this.printer.computeTrim(0, 0, 0, 0);
        Point point = this.printer.getDPI();
        this.printerFont = new Font((Device)this.printer, this.fontData.getName(), this.fontData.getHeight(), 0);
        this.clientArea = this.printer.getClientArea();
        this.pageWidth = this.clientArea.width;
        this.clientArea.x = point.x + rectangle.x;
        this.clientArea.y = point.y + rectangle.y;
        this.clientArea.width -= this.clientArea.x + rectangle.width;
        this.clientArea.height -= this.clientArea.y + rectangle.height;
        int n2 = this.mirrored ? 0x4000000 : 0x2000000;
        this.gc = new GC(this.printer, n2);
        this.gc.setFont(this.printerFont);
        this.printerRenderer.setFont(this.printerFont, this.tabLength);
        int n3 = this.printerRenderer.getLineHeight();
        if (this.printOptions.header != null) {
            this.clientArea.y += n3 * 2;
            this.clientArea.height -= n3 * 2;
        }
        if (this.printOptions.footer != null) {
            this.clientArea.height -= n3 * 2;
        }
        StyledTextContent styledTextContent = this.printerRenderer.content;
        this.startLine = 0;
        int n4 = this.endLine = this.singleLine ? 0 : styledTextContent.getLineCount() - 1;
        if (this.scope == 1) {
            int n5 = this.clientArea.height / n3;
            this.startLine = (this.startPage - 1) * n5;
        } else if (this.scope == 2) {
            this.startLine = styledTextContent.getLineAtOffset(this.selection.x);
            this.endLine = this.selection.y > 0 ? styledTextContent.getLineAtOffset(this.selection.x + this.selection.y - 1) : this.startLine - 1;
        }
    }

    void print() {
        int n2;
        int n3;
        Object object;
        int n4;
        Color color = this.gc.getBackground();
        Color color2 = this.gc.getForeground();
        int n5 = this.clientArea.y;
        int n6 = this.clientArea.x;
        int n7 = this.clientArea.width;
        int n8 = this.startPage;
        int n9 = this.clientArea.y + this.clientArea.height;
        int n10 = this.gc.getStyle() & 0x6000000;
        TextLayout textLayout = null;
        if (this.printOptions.printLineNumbers || this.printOptions.header != null || this.printOptions.footer != null) {
            textLayout = new TextLayout(this.printer);
            textLayout.setFont(this.printerFont);
        }
        if (this.printOptions.printLineNumbers) {
            n4 = 0;
            int n11 = this.endLine - this.startLine + 1;
            object = this.printOptions.lineLabels;
            if (object != null) {
                for (n3 = this.startLine; n3 < Math.min(n11, ((String[])object).length); ++n3) {
                    if (object[n3] == null) continue;
                    textLayout.setText(object[n3]);
                    n2 = textLayout.getBounds().width;
                    n4 = Math.max(n4, n2);
                }
            } else {
                StringBuffer stringBuffer = new StringBuffer("0");
                while ((n11 /= 10) > 0) {
                    stringBuffer.append("0");
                }
                textLayout.setText(stringBuffer.toString());
                n4 = textLayout.getBounds().width;
            }
            if ((n4 += this.printMargin) > n7) {
                n4 = n7;
            }
            n6 += n4;
            n7 -= n4;
        }
        for (n4 = this.startLine; n4 <= this.endLine && n8 <= this.endPage; ++n4) {
            if (n5 == this.clientArea.y) {
                this.printer.startPage();
                this.printDecoration(n8, true, textLayout);
            }
            TextLayout textLayout2 = this.printerRenderer.getTextLayout(n4, n10, n7, this.lineSpacing);
            object = this.printerRenderer.getLineBackground(n4, color);
            n3 = n5 + textLayout2.getBounds().height;
            if (n3 <= n9) {
                this.printLine(n6, n5, this.gc, color2, (Color)object, textLayout2, textLayout, n4);
                n5 = n3;
            } else {
                n2 = textLayout2.getLineCount();
                while (n3 > n9 && n2 > 0) {
                    n3 -= textLayout2.getLineBounds((int)(--n2)).height + textLayout2.getSpacing();
                }
                if (n2 == 0) {
                    this.printDecoration(n8, false, textLayout);
                    this.printer.endPage();
                    if (++n8 <= this.endPage) {
                        this.printer.startPage();
                        this.printDecoration(n8, true, textLayout);
                        n5 = this.clientArea.y;
                        this.printLine(n6, n5, this.gc, color2, (Color)object, textLayout2, textLayout, n4);
                        n5 += textLayout2.getBounds().height;
                    }
                } else {
                    int n12 = n3 - n5;
                    this.gc.setClipping(this.clientArea.x, n5, this.clientArea.width, n12);
                    this.printLine(n6, n5, this.gc, color2, (Color)object, textLayout2, textLayout, n4);
                    this.gc.setClipping((Rectangle)null);
                    this.printDecoration(n8, false, textLayout);
                    this.printer.endPage();
                    if (++n8 <= this.endPage) {
                        this.printer.startPage();
                        this.printDecoration(n8, true, textLayout);
                        n5 = this.clientArea.y - n12;
                        int n13 = textLayout2.getBounds().height;
                        this.gc.setClipping(this.clientArea.x, this.clientArea.y, this.clientArea.width, n13 - n12);
                        this.printLine(n6, n5, this.gc, color2, (Color)object, textLayout2, textLayout, n4);
                        this.gc.setClipping((Rectangle)null);
                        n5 += n13;
                    }
                }
            }
            this.printerRenderer.disposeTextLayout(textLayout2);
        }
        if (n8 <= this.endPage && n5 > this.clientArea.y) {
            this.printDecoration(n8, false, textLayout);
            this.printer.endPage();
        }
        if (textLayout != null) {
            textLayout.dispose();
        }
    }

    void printDecoration(int n2, boolean bl2, TextLayout textLayout) {
        String string;
        String string2 = string = bl2 ? this.printOptions.header : this.printOptions.footer;
        if (string == null) {
            return;
        }
        int n3 = 0;
        for (int i2 = 0; i2 < 3; ++i2) {
            String string3;
            int n4 = string.indexOf("\t", n3);
            if (n4 == -1) {
                string3 = string.substring(n3);
                this.printDecorationSegment(string3, i2, n2, bl2, textLayout);
                break;
            }
            string3 = string.substring(n3, n4);
            this.printDecorationSegment(string3, i2, n2, bl2, textLayout);
            n3 = n4 + "\t".length();
        }
    }

    void printDecorationSegment(String string, int n2, int n3, boolean bl2, TextLayout textLayout) {
        int n4;
        int n5 = string.indexOf("<page>");
        if (n5 != -1) {
            n4 = "<page>".length();
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, n5));
            stringBuffer.append(n3);
            stringBuffer.append(string.substring(n5 + n4));
            string = stringBuffer.toString();
        }
        if (string.length() > 0) {
            textLayout.setText(string);
            n4 = textLayout.getBounds().width;
            int n6 = this.printerRenderer.getLineHeight();
            int n7 = 0;
            if (n2 == 0) {
                n7 = this.clientArea.x;
            } else if (n2 == 1) {
                n7 = (this.pageWidth - n4) / 2;
            } else if (n2 == 2) {
                n7 = this.clientArea.x + this.clientArea.width - n4;
            }
            int n8 = bl2 ? this.clientArea.y - n6 * 2 : this.clientArea.y + this.clientArea.height + n6;
            textLayout.draw(this.gc, n7, n8);
        }
    }

    void printLine(int n2, int n3, GC gC, Color color, Color color2, TextLayout textLayout, TextLayout textLayout2, int n4) {
        Object object;
        if (color2 != null) {
            object = textLayout.getBounds();
            gC.setBackground(color2);
            gC.fillRectangle(n2, n3, ((Rectangle)object).width, ((Rectangle)object).height);
        }
        if (this.printOptions.printLineNumbers) {
            object = textLayout.getLineMetrics(0);
            textLayout2.setAscent(((FontMetrics)object).getAscent() + ((FontMetrics)object).getLeading());
            textLayout2.setDescent(((FontMetrics)object).getDescent());
            String[] stringArray = this.printOptions.lineLabels;
            if (stringArray != null) {
                if (0 <= n4 && n4 < stringArray.length && stringArray[n4] != null) {
                    textLayout2.setText(stringArray[n4]);
                } else {
                    textLayout2.setText("");
                }
            } else {
                textLayout2.setText(String.valueOf(n4));
            }
            int n5 = n2 - this.printMargin - textLayout2.getBounds().width;
            textLayout2.draw(gC, n5, n3);
            textLayout2.setAscent(-1);
            textLayout2.setDescent(-1);
        }
        gC.setForeground(color);
        textLayout.draw(gC, n2, n3);
    }

    @Override
    public void run() {
        String string = this.printOptions.jobName;
        if (string == null) {
            string = "Printing";
        }
        if (this.printer.startJob(string)) {
            this.init();
            this.print();
            this.dispose();
            this.printer.endJob();
        }
    }
}

