/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.OS;

public abstract class ByteArrayTransfer
extends Transfer {
    @Override
    public TransferData[] getSupportedTypes() {
        int[] nArray = this.getTypeIds();
        TransferData[] transferDataArray = new TransferData[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            transferDataArray[i2] = new TransferData();
            transferDataArray[i2].type = nArray[i2];
            transferDataArray[i2].formatetc = new FORMATETC();
            transferDataArray[i2].formatetc.cfFormat = nArray[i2];
            transferDataArray[i2].formatetc.dwAspect = 1;
            transferDataArray[i2].formatetc.lindex = -1;
            transferDataArray[i2].formatetc.tymed = 1;
        }
        return transferDataArray;
    }

    @Override
    public boolean isSupportedType(TransferData transferData) {
        if (transferData == null) {
            return false;
        }
        int[] nArray = this.getTypeIds();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            FORMATETC fORMATETC = transferData.formatetc;
            if (fORMATETC.cfFormat != nArray[i2] || (fORMATETC.dwAspect & 1) != 1 || (fORMATETC.tymed & 1) != 1) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void javaToNative(Object object, TransferData transferData) {
        if (!this.checkByteArray(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        byte[] byArray = (byte[])object;
        int n2 = byArray.length;
        int n3 = OS.GlobalAlloc(64, n2);
        OS.MoveMemory(n3, byArray, n2);
        transferData.stgmedium = new STGMEDIUM();
        transferData.stgmedium.tymed = 1;
        transferData.stgmedium.unionField = n3;
        transferData.stgmedium.pUnkForRelease = 0;
        transferData.result = 0;
    }

    @Override
    protected Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pIDataObject == 0) {
            return null;
        }
        IDataObject iDataObject = new IDataObject(transferData.pIDataObject);
        iDataObject.AddRef();
        FORMATETC fORMATETC = transferData.formatetc;
        STGMEDIUM sTGMEDIUM = new STGMEDIUM();
        sTGMEDIUM.tymed = 1;
        transferData.result = this.getData(iDataObject, fORMATETC, sTGMEDIUM);
        iDataObject.Release();
        if (transferData.result != 0) {
            return null;
        }
        int n2 = sTGMEDIUM.unionField;
        int n3 = OS.GlobalSize(n2);
        byte[] byArray = new byte[n3];
        int n4 = OS.GlobalLock(n2);
        OS.MoveMemory(byArray, n4, n3);
        OS.GlobalUnlock(n2);
        OS.GlobalFree(n2);
        return byArray;
    }

    boolean checkByteArray(Object object) {
        return object != null && object instanceof byte[] && ((byte[])object).length > 0;
    }
}

