/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.Clipboard$1;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.OleEnumFORMATETC;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.IEnumFORMATETC;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Display;

public class Clipboard {
    private static final int RETRY_LIMIT = 10;
    private Display display;
    private COMObject iDataObject;
    private int refCount;
    private Transfer[] transferAgents = new Transfer[0];
    private Object[] data = new Object[0];
    private int CFSTR_PREFERREDDROPEFFECT;

    public Clipboard(Display display) {
        this.checkSubclass();
        if (display == null && (display = Display.getCurrent()) == null) {
            display = Display.getDefault();
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = display;
        TCHAR tCHAR = new TCHAR(0, "Preferred DropEffect", true);
        this.CFSTR_PREFERREDDROPEFFECT = OS.RegisterClipboardFormat(tCHAR);
        this.createCOMInterfaces();
        this.AddRef();
    }

    protected void checkSubclass() {
        String string = this.getClass().getName();
        String string2 = Clipboard.class.getName();
        if (!string2.equals(string)) {
            DND.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            DND.error(24);
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        if (display.isDisposed()) {
            DND.error(24);
        }
    }

    public void clearContents() {
        this.clearContents(1);
    }

    public void clearContents(int n2) {
        this.checkWidget();
        if ((n2 & 1) != 0 && COM.OleIsCurrentClipboard(this.iDataObject.getAddress()) == 0) {
            COM.OleSetClipboard(0);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        if (COM.OleIsCurrentClipboard(this.iDataObject.getAddress()) == 0) {
            COM.OleFlushClipboard();
        }
        this.Release();
        this.display = null;
    }

    public Object getContents(Transfer transfer) {
        return this.getContents(transfer, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getContents(Transfer transfer, int n2) {
        Object object;
        this.checkWidget();
        if (transfer == null) {
            DND.error(4);
        }
        if ((n2 & 1) == 0) {
            return null;
        }
        int[] nArray = new int[1];
        int n3 = 0;
        int n4 = COM.OleGetClipboard(nArray);
        while (n4 != 0 && n3++ < 10) {
            try {
                Thread.sleep(50L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            object = new MSG();
            OS.PeekMessage((MSG)object, 0, 0, 0, 2);
            n4 = COM.OleGetClipboard(nArray);
        }
        if (n4 != 0) {
            return null;
        }
        object = new IDataObject(nArray[0]);
        try {
            TransferData[] transferDataArray = transfer.getSupportedTypes();
            for (int i2 = 0; i2 < transferDataArray.length; ++i2) {
                if (((IDataObject)object).QueryGetData(transferDataArray[i2].formatetc) != 0) continue;
                TransferData transferData = transferDataArray[i2];
                transferData.pIDataObject = nArray[0];
                Object object2 = transfer.nativeToJava(transferData);
                return object2;
            }
        }
        finally {
            ((IUnknown)object).Release();
        }
        return null;
    }

    public boolean isDisposed() {
        return this.display == null;
    }

    public void setContents(Object[] objectArray, Transfer[] transferArray) {
        this.setContents(objectArray, transferArray, 1);
    }

    public void setContents(Object[] objectArray, Transfer[] transferArray, int n2) {
        int n3;
        this.checkWidget();
        if (objectArray == null || transferArray == null || objectArray.length != transferArray.length || objectArray.length == 0) {
            DND.error(5);
        }
        for (n3 = 0; n3 < objectArray.length; ++n3) {
            if (objectArray[n3] != null && transferArray[n3] != null && transferArray[n3].validate(objectArray[n3])) continue;
            DND.error(5);
        }
        if ((n2 & 1) == 0) {
            return;
        }
        this.data = objectArray;
        this.transferAgents = transferArray;
        n3 = COM.OleSetClipboard(this.iDataObject.getAddress());
        int n4 = 0;
        while (n3 != 0 && n4++ < 10) {
            try {
                Thread.sleep(50L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            MSG mSG = new MSG();
            OS.PeekMessage(mSG, 0, 0, 0, 2);
            n3 = COM.OleSetClipboard(this.iDataObject.getAddress());
        }
        if (n3 != 0) {
            DND.error(2002);
        }
    }

    private int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    private void createCOMInterfaces() {
        this.iDataObject = new Clipboard$1(this, new int[]{2, 0, 0, 2, 2, 1, 2, 3, 2, 4, 1, 1});
    }

    private void disposeCOMInterfaces() {
        if (this.iDataObject != null) {
            this.iDataObject.dispose();
        }
        this.iDataObject = null;
    }

    private int EnumFormatEtc(int n2, int n3) {
        Object[] objectArray;
        if (n2 == 2) {
            return -2147467263;
        }
        TransferData[] transferDataArray = new TransferData[]{};
        for (int i2 = 0; i2 < this.transferAgents.length; ++i2) {
            objectArray = this.transferAgents[i2].getSupportedTypes();
            TransferData[] transferDataArray2 = new TransferData[transferDataArray.length + objectArray.length];
            System.arraycopy(transferDataArray, 0, transferDataArray2, 0, transferDataArray.length);
            System.arraycopy(objectArray, 0, transferDataArray2, transferDataArray.length, objectArray.length);
            transferDataArray = transferDataArray2;
        }
        OleEnumFORMATETC oleEnumFORMATETC = new OleEnumFORMATETC();
        oleEnumFORMATETC.AddRef();
        objectArray = new FORMATETC[transferDataArray.length + 1];
        for (int i3 = 0; i3 < transferDataArray.length; ++i3) {
            objectArray[i3] = transferDataArray[i3].formatetc;
        }
        FORMATETC fORMATETC = new FORMATETC();
        fORMATETC.cfFormat = this.CFSTR_PREFERREDDROPEFFECT;
        fORMATETC.dwAspect = 1;
        fORMATETC.lindex = -1;
        fORMATETC.tymed = 1;
        objectArray[objectArray.length - 1] = fORMATETC;
        oleEnumFORMATETC.setFormats((FORMATETC[])objectArray);
        OS.MoveMemory(n3, new int[]{oleEnumFORMATETC.getAddress()}, OS.PTR_SIZEOF);
        return 0;
    }

    private int GetData(int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            return -2147024809;
        }
        if (this.QueryGetData(n2) != 0) {
            return -2147221404;
        }
        TransferData transferData = new TransferData();
        transferData.formatetc = new FORMATETC();
        COM.MoveMemory(transferData.formatetc, n2, FORMATETC.sizeof);
        transferData.type = transferData.formatetc.cfFormat;
        transferData.stgmedium = new STGMEDIUM();
        transferData.result = -2147467259;
        if (transferData.type == this.CFSTR_PREFERREDDROPEFFECT) {
            STGMEDIUM sTGMEDIUM = new STGMEDIUM();
            sTGMEDIUM.tymed = 1;
            sTGMEDIUM.unionField = OS.GlobalAlloc(64, 4);
            OS.MoveMemory(sTGMEDIUM.unionField, new int[]{1}, 4);
            sTGMEDIUM.pUnkForRelease = 0;
            COM.MoveMemory(n3, sTGMEDIUM, STGMEDIUM.sizeof);
            return 0;
        }
        int n4 = -1;
        for (int i2 = 0; i2 < this.transferAgents.length; ++i2) {
            if (!this.transferAgents[i2].isSupportedType(transferData)) continue;
            n4 = i2;
            break;
        }
        if (n4 == -1) {
            return -2147221404;
        }
        this.transferAgents[n4].javaToNative(this.data[n4], transferData);
        COM.MoveMemory(n3, transferData.stgmedium, STGMEDIUM.sizeof);
        return transferData.result;
    }

    private int QueryGetData(int n2) {
        if (this.transferAgents == null) {
            return -2147467259;
        }
        TransferData transferData = new TransferData();
        transferData.formatetc = new FORMATETC();
        COM.MoveMemory(transferData.formatetc, n2, FORMATETC.sizeof);
        transferData.type = transferData.formatetc.cfFormat;
        if (transferData.type == this.CFSTR_PREFERREDDROPEFFECT) {
            return 0;
        }
        for (int i2 = 0; i2 < this.transferAgents.length; ++i2) {
            if (!this.transferAgents[i2].isSupportedType(transferData)) continue;
            return 0;
        }
        return -2147221404;
    }

    private int QueryInterface(int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            return -2147024809;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, n2, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown) || COM.IsEqualGUID(gUID, COM.IIDIDataObject)) {
            OS.MoveMemory(n3, new int[]{this.iDataObject.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        OS.MoveMemory(n3, new int[]{0}, OS.PTR_SIZEOF);
        return -2147467262;
    }

    private int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.data = new Object[0];
            this.transferAgents = new Transfer[0];
            this.disposeCOMInterfaces();
            if (COM.FreeUnusedLibraries) {
                COM.CoFreeUnusedLibraries();
            }
        }
        return this.refCount;
    }

    public TransferData[] getAvailableTypes() {
        return this.getAvailableTypes(1);
    }

    public TransferData[] getAvailableTypes(int n2) {
        this.checkWidget();
        if ((n2 & 1) == 0) {
            return new TransferData[0];
        }
        FORMATETC[] fORMATETCArray = this._getAvailableTypes();
        TransferData[] transferDataArray = new TransferData[fORMATETCArray.length];
        for (int i2 = 0; i2 < fORMATETCArray.length; ++i2) {
            transferDataArray[i2] = new TransferData();
            transferDataArray[i2].type = fORMATETCArray[i2].cfFormat;
            transferDataArray[i2].formatetc = fORMATETCArray[i2];
        }
        return transferDataArray;
    }

    public String[] getAvailableTypeNames() {
        this.checkWidget();
        FORMATETC[] fORMATETCArray = this._getAvailableTypes();
        String[] stringArray = new String[fORMATETCArray.length];
        int n2 = 128;
        block19: for (int i2 = 0; i2 < fORMATETCArray.length; ++i2) {
            TCHAR tCHAR = new TCHAR(0, n2);
            int n3 = OS.GetClipboardFormatName(fORMATETCArray[i2].cfFormat, tCHAR, n2);
            if (n3 != 0) {
                stringArray[i2] = tCHAR.toString(0, n3);
                continue;
            }
            switch (fORMATETCArray[i2].cfFormat) {
                case 15: {
                    stringArray[i2] = "CF_HDROP";
                    continue block19;
                }
                case 1: {
                    stringArray[i2] = "CF_TEXT";
                    continue block19;
                }
                case 2: {
                    stringArray[i2] = "CF_BITMAP";
                    continue block19;
                }
                case 3: {
                    stringArray[i2] = "CF_METAFILEPICT";
                    continue block19;
                }
                case 4: {
                    stringArray[i2] = "CF_SYLK";
                    continue block19;
                }
                case 5: {
                    stringArray[i2] = "CF_DIF";
                    continue block19;
                }
                case 6: {
                    stringArray[i2] = "CF_TIFF";
                    continue block19;
                }
                case 7: {
                    stringArray[i2] = "CF_OEMTEXT";
                    continue block19;
                }
                case 8: {
                    stringArray[i2] = "CF_DIB";
                    continue block19;
                }
                case 9: {
                    stringArray[i2] = "CF_PALETTE";
                    continue block19;
                }
                case 10: {
                    stringArray[i2] = "CF_PENDATA";
                    continue block19;
                }
                case 11: {
                    stringArray[i2] = "CF_RIFF";
                    continue block19;
                }
                case 12: {
                    stringArray[i2] = "CF_WAVE";
                    continue block19;
                }
                case 13: {
                    stringArray[i2] = "CF_UNICODETEXT";
                    continue block19;
                }
                case 14: {
                    stringArray[i2] = "CF_ENHMETAFILE";
                    continue block19;
                }
                case 16: {
                    stringArray[i2] = "CF_LOCALE";
                    continue block19;
                }
                case 17: {
                    stringArray[i2] = "CF_MAX";
                    continue block19;
                }
                default: {
                    stringArray[i2] = "UNKNOWN";
                }
            }
        }
        return stringArray;
    }

    private FORMATETC[] _getAvailableTypes() {
        FORMATETC[] fORMATETCArray = new FORMATETC[]{};
        int[] nArray = new int[1];
        if (COM.OleGetClipboard(nArray) != 0) {
            return fORMATETCArray;
        }
        IDataObject iDataObject = new IDataObject(nArray[0]);
        int[] nArray2 = new int[1];
        int n2 = iDataObject.EnumFormatEtc(1, nArray2);
        iDataObject.Release();
        if (n2 != 0) {
            return fORMATETCArray;
        }
        IEnumFORMATETC iEnumFORMATETC = new IEnumFORMATETC(nArray2[0]);
        int n3 = OS.GlobalAlloc(64, FORMATETC.sizeof);
        int[] nArray3 = new int[1];
        iEnumFORMATETC.Reset();
        while (iEnumFORMATETC.Next(1, n3, nArray3) == 0 && nArray3[0] == 1) {
            FORMATETC fORMATETC = new FORMATETC();
            COM.MoveMemory(fORMATETC, n3, FORMATETC.sizeof);
            FORMATETC[] fORMATETCArray2 = new FORMATETC[fORMATETCArray.length + 1];
            System.arraycopy(fORMATETCArray, 0, fORMATETCArray2, 0, fORMATETCArray.length);
            fORMATETCArray2[fORMATETCArray.length] = fORMATETC;
            fORMATETCArray = fORMATETCArray2;
        }
        OS.GlobalFree(n3);
        iEnumFORMATETC.Release();
        return fORMATETCArray;
    }

    static /* synthetic */ int access$000(Clipboard clipboard, int n2, int n3) {
        return clipboard.QueryInterface(n2, n3);
    }

    static /* synthetic */ int access$100(Clipboard clipboard) {
        return clipboard.AddRef();
    }

    static /* synthetic */ int access$200(Clipboard clipboard) {
        return clipboard.Release();
    }

    static /* synthetic */ int access$300(Clipboard clipboard, int n2, int n3) {
        return clipboard.GetData(n2, n3);
    }

    static /* synthetic */ int access$400(Clipboard clipboard, int n2) {
        return clipboard.QueryGetData(n2);
    }

    static /* synthetic */ int access$500(Clipboard clipboard, int n2, int n3) {
        return clipboard.EnumFormatEtc(n2, n3);
    }
}

