/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.DIBSECTION;
import org.eclipse.swt.internal.win32.OS;

public class ImageTransfer
extends ByteArrayTransfer {
    private static ImageTransfer _instance = new ImageTransfer();
    private static final String CF_DIB = "CF_DIB";
    private static final int CF_DIBID = 8;

    private ImageTransfer() {
    }

    public static ImageTransfer getInstance() {
        return _instance;
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        int n2;
        int n3;
        ImageData imageData;
        if (!this.checkImage(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        if ((imageData = (ImageData)object) == null) {
            SWT.error(4);
        }
        int n4 = imageData.data.length;
        int n5 = imageData.height;
        int n6 = imageData.bytesPerLine;
        BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
        bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
        bITMAPINFOHEADER.biSizeImage = n4;
        bITMAPINFOHEADER.biWidth = imageData.width;
        bITMAPINFOHEADER.biHeight = n5;
        bITMAPINFOHEADER.biPlanes = 1;
        bITMAPINFOHEADER.biBitCount = (short)imageData.depth;
        bITMAPINFOHEADER.biCompression = 0;
        int n7 = 0;
        if (bITMAPINFOHEADER.biBitCount <= 8) {
            n7 += (1 << bITMAPINFOHEADER.biBitCount) * 4;
        }
        byte[] byArray = new byte[BITMAPINFOHEADER.sizeof + n7];
        OS.MoveMemory(byArray, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
        RGB[] rGBArray = imageData.palette.getRGBs();
        if (rGBArray != null && n7 > 0) {
            n3 = BITMAPINFOHEADER.sizeof;
            for (n2 = 0; n2 < rGBArray.length; ++n2) {
                byArray[n3] = (byte)rGBArray[n2].blue;
                byArray[n3 + 1] = (byte)rGBArray[n2].green;
                byArray[n3 + 2] = (byte)rGBArray[n2].red;
                byArray[n3 + 3] = 0;
                n3 += 4;
            }
        }
        n3 = OS.GlobalAlloc(64, BITMAPINFOHEADER.sizeof + n7 + n4);
        OS.MoveMemory(n3, byArray, byArray.length);
        n2 = n3 + BITMAPINFOHEADER.sizeof + n7;
        if (n5 <= 0) {
            OS.MoveMemory(n2, imageData.data, n4);
        } else {
            int n8 = 0;
            n2 += n6 * (n5 - 1);
            byte[] byArray2 = new byte[n6];
            for (int i2 = 0; i2 < n5; ++i2) {
                System.arraycopy(imageData.data, n8, byArray2, 0, n6);
                OS.MoveMemory(n2, byArray2, n6);
                n8 += n6;
                n2 -= n6;
            }
        }
        transferData.stgmedium = new STGMEDIUM();
        transferData.stgmedium.tymed = 1;
        transferData.stgmedium.unionField = n3;
        transferData.stgmedium.pUnkForRelease = 0;
        transferData.result = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pIDataObject == 0) {
            return null;
        }
        IDataObject iDataObject = new IDataObject(transferData.pIDataObject);
        iDataObject.AddRef();
        FORMATETC fORMATETC = new FORMATETC();
        fORMATETC.cfFormat = 8;
        fORMATETC.ptd = 0;
        fORMATETC.dwAspect = 1;
        fORMATETC.lindex = -1;
        fORMATETC.tymed = 1;
        STGMEDIUM sTGMEDIUM = new STGMEDIUM();
        sTGMEDIUM.tymed = 1;
        transferData.result = this.getData(iDataObject, fORMATETC, sTGMEDIUM);
        if (transferData.result != 0) {
            return null;
        }
        int n2 = sTGMEDIUM.unionField;
        iDataObject.Release();
        try {
            ImageData imageData;
            int n3 = OS.GlobalLock(n2);
            if (n3 == 0) {
                Object var7_7 = null;
                return var7_7;
            }
            try {
                Object object;
                BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
                OS.MoveMemory(bITMAPINFOHEADER, n3, BITMAPINFOHEADER.sizeof);
                int[] nArray = new int[1];
                int n4 = OS.CreateDIBSection(0, n3, 0, nArray, 0, 0);
                if (n4 == 0) {
                    SWT.error(2);
                }
                int n5 = n3 + bITMAPINFOHEADER.biSize;
                if (bITMAPINFOHEADER.biBitCount <= 8) {
                    n5 += (bITMAPINFOHEADER.biClrUsed == 0 ? 1 << bITMAPINFOHEADER.biBitCount : bITMAPINFOHEADER.biClrUsed) * 4;
                } else if (bITMAPINFOHEADER.biCompression == 3) {
                    n5 += 12;
                }
                if (bITMAPINFOHEADER.biHeight < 0) {
                    OS.MoveMemory(nArray[0], n5, bITMAPINFOHEADER.biSizeImage);
                } else {
                    object = new DIBSECTION();
                    OS.GetObject(n4, DIBSECTION.sizeof, (DIBSECTION)object);
                    int n6 = ((DIBSECTION)object).biHeight;
                    int n7 = ((DIBSECTION)object).biSizeImage / n6;
                    int n8 = nArray[0];
                    int n9 = n5 + n7 * (n6 - 1);
                    for (int i2 = 0; i2 < n6; ++i2) {
                        OS.MoveMemory(n8, n9, n7);
                        n8 += n7;
                        n9 -= n7;
                    }
                }
                object = Image.win32_new(null, 0, n4);
                ImageData imageData2 = ((Image)object).getImageData(DPIUtil.getDeviceZoom());
                OS.DeleteObject(n4);
                ((Resource)object).dispose();
                imageData = imageData2;
            }
            catch (Throwable throwable) {
                OS.GlobalUnlock(n2);
                throw throwable;
            }
            OS.GlobalUnlock(n2);
            return imageData;
        }
        finally {
            OS.GlobalFree(n2);
        }
    }

    @Override
    protected int[] getTypeIds() {
        return new int[]{8};
    }

    @Override
    protected String[] getTypeNames() {
        return new String[]{CF_DIB};
    }

    boolean checkImage(Object object) {
        return object != null && object instanceof ImageData;
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkImage(object);
    }
}

