/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.win32.OS;

public final class Color
extends Resource {
    public int handle;
    int alpha = 255;

    Color(Device device) {
        super(device);
    }

    public Color(Device device, int n2, int n3, int n4) {
        super(device);
        this.init(n2, n3, n4, 255);
        this.init();
    }

    public Color(Device device, int n2, int n3, int n4, int n5) {
        super(device);
        this.init(n2, n3, n4, n5);
        this.init();
    }

    public Color(Device device, RGB rGB) {
        super(device);
        if (rGB == null) {
            SWT.error(4);
        }
        this.init(rGB.red, rGB.green, rGB.blue, 255);
        this.init();
    }

    public Color(Device device, RGBA rGBA) {
        super(device);
        if (rGBA == null) {
            SWT.error(4);
        }
        this.init(rGBA.rgb.red, rGBA.rgb.green, rGBA.rgb.blue, rGBA.alpha);
        this.init();
    }

    public Color(Device device, RGB rGB, int n2) {
        super(device);
        if (rGB == null) {
            SWT.error(4);
        }
        this.init(rGB.red, rGB.green, rGB.blue, n2);
        this.init();
    }

    @Override
    void destroy() {
        int n2;
        int[] nArray;
        int n3 = this.device.hPalette;
        if (n3 != 0 && (nArray = this.device.colorRefCount)[n2 = OS.GetNearestPaletteIndex(n3, this.handle)] > 0) {
            int n4 = n2;
            nArray[n4] = nArray[n4] - 1;
        }
        this.handle = -1;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Color)) {
            return false;
        }
        Color color = (Color)object;
        return this.device == color.device && (this.handle & 0xFFFFFF) == (color.handle & 0xFFFFFF) && this.alpha == color.alpha;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public int getBlue() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (this.handle & 0xFF0000) >> 16;
    }

    public int getGreen() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (this.handle & 0xFF00) >> 8;
    }

    public int getRed() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle & 0xFF;
    }

    public RGB getRGB() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGB(this.handle & 0xFF, (this.handle & 0xFF00) >> 8, (this.handle & 0xFF0000) >> 16);
    }

    public RGBA getRGBA() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGBA(this.handle & 0xFF, (this.handle & 0xFF00) >> 8, (this.handle & 0xFF0000) >> 16, this.alpha);
    }

    public int hashCode() {
        return this.handle ^ this.alpha;
    }

    void init(int n2, int n3, int n4, int n5) {
        int n6;
        if (n2 > 255 || n2 < 0 || n3 > 255 || n3 < 0 || n4 > 255 || n4 < 0 || n5 > 255 || n5 < 0) {
            SWT.error(5);
        }
        this.handle = n2 & 0xFF | (n3 & 0xFF) << 8 | (n4 & 0xFF) << 16;
        this.alpha = n5;
        int n7 = this.device.hPalette;
        if (n7 == 0) {
            return;
        }
        int[] nArray = this.device.colorRefCount;
        int n8 = OS.GetNearestPaletteIndex(n7, this.handle);
        byte[] byArray = new byte[4];
        OS.GetPaletteEntries(n7, n8, 1, byArray);
        if (byArray[0] == (byte)n2 && byArray[1] == (byte)n3 && byArray[2] == (byte)n4) {
            int n9 = n8;
            nArray[n9] = nArray[n9] + 1;
            return;
        }
        for (n6 = 0; n6 < nArray.length; ++n6) {
            if (nArray[n6] != 0) continue;
            n8 = n6;
            break;
        }
        if (n6 == nArray.length) {
            this.handle = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16;
        } else {
            byArray = new byte[]{(byte)(n2 & 0xFF), (byte)(n3 & 0xFF), (byte)(n4 & 0xFF), 0};
            OS.SetPaletteEntries(n7, n8, 1, byArray);
        }
        int n10 = n8;
        nArray[n10] = nArray[n10] + 1;
    }

    @Override
    public boolean isDisposed() {
        return this.handle == -1;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Color {*DISPOSED*}";
        }
        return "Color {" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + ", " + this.getAlpha() + "}";
    }

    public static Color win32_new(Device device, int n2) {
        return Color.win32_new(device, n2, 255);
    }

    public static Color win32_new(Device device, int n2, int n3) {
        Color color = new Color(device);
        color.handle = n2;
        color.alpha = n3;
        return color;
    }
}

