/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.GdiplusStartupInput;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;

public abstract class Device
implements Drawable {
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    Object trackingLock;
    public int hPalette = 0;
    int[] colorRefCount;
    Font systemFont;
    int nFonts = 256;
    LOGFONT[] logFonts;
    TEXTMETRIC metrics;
    int[] pixels;
    int[] scripts;
    int[] gdipToken;
    int fontCollection;
    String[] loadedFonts;
    boolean disposed;
    boolean enableAutoScaling = true;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;

    static synchronized Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device(DeviceData deviceData) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (deviceData != null) {
                this.debug = deviceData.debug;
                this.tracking = deviceData.tracking;
            }
            if (this.tracking) {
                this.errors = new Error[128];
                this.objects = new Object[128];
                this.trackingLock = new Object();
            }
            this.create(deviceData);
            this.init();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void addFont(String string) {
        int n2;
        if (this.loadedFonts == null) {
            this.loadedFonts = new String[4];
        }
        int n3 = this.loadedFonts.length;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!string.equals(this.loadedFonts[n2])) continue;
            return;
        }
        for (n2 = 0; n2 < n3 && this.loadedFonts[n2] != null; ++n2) {
        }
        if (n2 == n3) {
            String[] stringArray = new String[n3 + 4];
            System.arraycopy(this.loadedFonts, 0, stringArray, 0, n3);
            this.loadedFonts = stringArray;
        }
        this.loadedFonts[n2] = string;
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkGDIP() {
        if (this.gdipToken != null) {
            return;
        }
        int n2 = 0;
        if (!OS.IsWinCE) {
            n2 = OS.SetErrorMode(1);
        }
        try {
            int[] nArray = new int[1];
            GdiplusStartupInput gdiplusStartupInput = new GdiplusStartupInput();
            gdiplusStartupInput.GdiplusVersion = 1;
            if (Gdip.GdiplusStartup(nArray, gdiplusStartupInput, 0) == 0) {
                this.gdipToken = nArray;
                if (this.loadedFonts != null) {
                    String string;
                    this.fontCollection = Gdip.PrivateFontCollection_new();
                    if (this.fontCollection == 0) {
                        SWT.error(2);
                    }
                    for (int i2 = 0; i2 < this.loadedFonts.length && (string = this.loadedFonts[i2]) != null; ++i2) {
                        int n3 = string.length();
                        char[] cArray = new char[n3 + 1];
                        string.getChars(0, n3, cArray, 0);
                        Gdip.PrivateFontCollection_AddFontFile(this.fontCollection, cArray);
                    }
                    this.loadedFonts = null;
                }
            }
        }
        catch (Throwable throwable) {
            SWT.error(16, throwable, " [GDI+ is required]");
        }
        finally {
            if (!OS.IsWinCE) {
                OS.SetErrorMode(n2);
            }
        }
    }

    protected void create(DeviceData deviceData) {
    }

    int computePixels(float f2) {
        int n2 = this.internal_new_GC(null);
        int n3 = -((int)(0.5f + f2 * (float)OS.GetDeviceCaps(n2, 90) / 72.0f));
        this.internal_dispose_GC(n2, null);
        return n3;
    }

    float computePoints(LOGFONT lOGFONT, int n2) {
        int n3 = this.internal_new_GC(null);
        int n4 = OS.GetDeviceCaps(n3, 90);
        int n5 = 0;
        if (lOGFONT.lfHeight > 0) {
            int n6 = OS.SelectObject(n3, n2);
            TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
            OS.GetTextMetrics(n3, tEXTMETRIC);
            OS.SelectObject(n3, n6);
            n5 = lOGFONT.lfHeight - tEXTMETRIC.tmInternalLeading;
        } else {
            n5 = -lOGFONT.lfHeight;
        }
        this.internal_dispose_GC(n3, null);
        return (float)n5 * 72.0f / (float)n4;
    }

    protected void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.checkDevice();
            this.release();
            this.destroy();
            this.disposed = true;
            if (this.tracking) {
                Object object = this.trackingLock;
                synchronized (object) {
                    this.printErrors();
                    this.objects = null;
                    this.errors = null;
                    this.trackingLock = null;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            for (int i2 = 0; i2 < this.objects.length; ++i2) {
                if (this.objects[i2] != object) continue;
                this.objects[i2] = null;
                this.errors[i2] = null;
                return;
            }
        }
    }

    int EnumFontFamProc(int n2, int n3, int n4, int n5) {
        boolean bl2;
        boolean bl3 = (n4 & 1) == 0;
        boolean bl4 = bl2 = n5 == 1;
        if (bl3 == bl2) {
            Object object;
            if (this.nFonts == this.logFonts.length) {
                object = new LOGFONT[this.logFonts.length + 128];
                System.arraycopy(this.logFonts, 0, object, 0, this.nFonts);
                this.logFonts = object;
                int[] nArray = new int[((LOGFONT[])object).length];
                System.arraycopy(this.pixels, 0, nArray, 0, this.nFonts);
                this.pixels = nArray;
            }
            if ((object = this.logFonts[this.nFonts]) == null) {
                object = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
            }
            OS.MoveMemory((LOGFONT)object, n2, LOGFONT.sizeof);
            this.logFonts[this.nFonts] = object;
            if (object.lfHeight > 0) {
                OS.MoveMemory(this.metrics, n3, TEXTMETRIC.sizeof);
                this.pixels[this.nFonts] = object.lfHeight - this.metrics.tmInternalLeading;
            } else {
                this.pixels[this.nFonts] = -object.lfHeight;
            }
            ++this.nFonts;
        }
        return 1;
    }

    public Rectangle getBounds() {
        this.checkDevice();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    private Rectangle getBoundsInPixels() {
        int n2 = this.internal_new_GC(null);
        int n3 = OS.GetDeviceCaps(n2, 8);
        int n4 = OS.GetDeviceCaps(n2, 10);
        this.internal_dispose_GC(n2, null);
        return new Rectangle(0, 0, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceData getDeviceData() {
        this.checkDevice();
        DeviceData deviceData = new DeviceData();
        deviceData.debug = this.debug;
        deviceData.tracking = this.tracking;
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                int n2;
                int n3 = 0;
                int n4 = this.objects.length;
                for (n2 = 0; n2 < n4; ++n2) {
                    if (this.objects[n2] == null) continue;
                    ++n3;
                }
                n2 = 0;
                deviceData.objects = new Object[n3];
                deviceData.errors = new Error[n3];
                for (int i2 = 0; i2 < n4; ++i2) {
                    if (this.objects[i2] == null) continue;
                    deviceData.objects[n2] = this.objects[i2];
                    deviceData.errors[n2] = this.errors[i2];
                    ++n2;
                }
            }
        } else {
            deviceData.objects = new Object[0];
            deviceData.errors = new Error[0];
        }
        return deviceData;
    }

    public Rectangle getClientArea() {
        return this.getBounds();
    }

    public int getDepth() {
        this.checkDevice();
        int n2 = this.internal_new_GC(null);
        int n3 = OS.GetDeviceCaps(n2, 12);
        int n4 = OS.GetDeviceCaps(n2, 14);
        this.internal_dispose_GC(n2, null);
        return n3 * n4;
    }

    public Point getDPI() {
        this.checkDevice();
        int n2 = this.internal_new_GC(null);
        int n3 = OS.GetDeviceCaps(n2, 88);
        int n4 = OS.GetDeviceCaps(n2, 90);
        this.internal_dispose_GC(n2, null);
        return DPIUtil.autoScaleDown(new Point(n3, n4));
    }

    int _getDPIx() {
        int n2 = this.internal_new_GC(null);
        int n3 = OS.GetDeviceCaps(n2, 88);
        this.internal_dispose_GC(n2, null);
        return n3;
    }

    public FontData[] getFontList(String string, boolean bl2) {
        int n2;
        int n3;
        this.checkDevice();
        Callback callback = new Callback(this, "EnumFontFamProc", 4);
        int n4 = callback.getAddress();
        if (n4 == 0) {
            SWT.error(3);
        }
        this.metrics = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        this.pixels = new int[this.nFonts];
        this.logFonts = new LOGFONT[this.nFonts];
        for (n3 = 0; n3 < this.logFonts.length; ++n3) {
            this.logFonts[n3] = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
        }
        this.nFonts = 0;
        n3 = 0;
        int n5 = this.internal_new_GC(null);
        if (string == null) {
            OS.EnumFontFamilies(n5, null, n4, bl2 ? 1 : 0);
            n3 = this.nFonts;
            for (n2 = 0; n2 < n3; ++n2) {
                LOGFONT lOGFONT = this.logFonts[n2];
                if (OS.IsUnicode) {
                    OS.EnumFontFamiliesW(n5, ((LOGFONTW)lOGFONT).lfFaceName, n4, bl2 ? 1 : 0);
                    continue;
                }
                OS.EnumFontFamiliesA(n5, ((LOGFONTA)lOGFONT).lfFaceName, n4, bl2 ? 1 : 0);
            }
        } else {
            TCHAR tCHAR = new TCHAR(0, string, true);
            OS.EnumFontFamilies(n5, tCHAR, n4, bl2 ? 1 : 0);
        }
        n2 = OS.GetDeviceCaps(n5, 90);
        this.internal_dispose_GC(n5, null);
        int n6 = 0;
        FontData[] fontDataArray = new FontData[this.nFonts - n3];
        for (int i2 = n3; i2 < this.nFonts; ++i2) {
            int n7;
            FontData fontData = FontData.win32_new(this.logFonts[i2], (float)this.pixels[i2] * 72.0f / (float)n2);
            for (n7 = 0; n7 < n6 && !fontData.equals(fontDataArray[n7]); ++n7) {
            }
            if (n7 != n6) continue;
            fontDataArray[n6++] = fontData;
        }
        if (n6 != fontDataArray.length) {
            FontData[] fontDataArray2 = new FontData[n6];
            System.arraycopy(fontDataArray, 0, fontDataArray2, 0, n6);
            fontDataArray = fontDataArray2;
        }
        callback.dispose();
        this.logFonts = null;
        this.pixels = null;
        this.metrics = null;
        return fontDataArray;
    }

    String getLastError() {
        int n2 = OS.GetLastError();
        if (n2 == 0) {
            return "";
        }
        return " [GetLastError=0x" + Integer.toHexString(n2) + "]";
    }

    String getLastErrorText() {
        int n2 = OS.GetLastError();
        if (n2 == 0) {
            return "";
        }
        int n3 = 4864;
        int[] nArray = new int[1];
        int n4 = OS.FormatMessage(n3, 0, n2, 1024, nArray, 0, 0);
        if (n4 == 0) {
            return " [GetLastError=0x" + Integer.toHexString(n2) + "]";
        }
        TCHAR tCHAR = new TCHAR(0, n4);
        OS.MoveMemory(tCHAR, nArray[0], n4 * TCHAR.sizeof);
        if (nArray[0] != 0) {
            OS.LocalFree(nArray[0]);
        }
        return tCHAR.toString(0, n4);
    }

    public Color getSystemColor(int n2) {
        this.checkDevice();
        int n3 = 0;
        int n4 = 255;
        switch (n2) {
            case 37: {
                n4 = 0;
            }
            case 1: {
                n3 = 0xFFFFFF;
                break;
            }
            case 2: {
                n3 = 0;
                break;
            }
            case 3: {
                n3 = 255;
                break;
            }
            case 4: {
                n3 = 128;
                break;
            }
            case 5: {
                n3 = 65280;
                break;
            }
            case 6: {
                n3 = 32768;
                break;
            }
            case 7: {
                n3 = 65535;
                break;
            }
            case 8: {
                n3 = 32896;
                break;
            }
            case 9: {
                n3 = 0xFF0000;
                break;
            }
            case 10: {
                n3 = 0x800000;
                break;
            }
            case 11: {
                n3 = 0xFF00FF;
                break;
            }
            case 12: {
                n3 = 0x800080;
                break;
            }
            case 13: {
                n3 = 0xFFFF00;
                break;
            }
            case 14: {
                n3 = 0x808000;
                break;
            }
            case 15: {
                n3 = 0xC0C0C0;
                break;
            }
            case 16: {
                n3 = 0x808080;
            }
        }
        return Color.win32_new(this, n3, n4);
    }

    public Font getSystemFont() {
        this.checkDevice();
        int n2 = OS.GetStockObject(13);
        return Font.win32_new(this, n2);
    }

    public boolean getWarnings() {
        this.checkDevice();
        return false;
    }

    protected void init() {
        if (this.debug && !OS.IsWinCE) {
            OS.GdiSetBatchLimit(1);
        }
        this.systemFont = this.getSystemFont();
        if (!OS.IsWinCE) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.ScriptGetProperties(nArray, nArray2);
            this.scripts = new int[nArray2[0]];
            OS.MoveMemory(this.scripts, nArray[0], this.scripts.length * OS.PTR_SIZEOF);
        }
        int n2 = this.internal_new_GC(null);
        int n3 = OS.GetDeviceCaps(n2, 38);
        int n4 = OS.GetDeviceCaps(n2, 12);
        int n5 = OS.GetDeviceCaps(n2, 14);
        if ((n3 & 0x100) == 0 || (n4 *= n5) != 8) {
            this.internal_dispose_GC(n2, null);
            return;
        }
        int n6 = OS.GetDeviceCaps(n2, 106);
        int n7 = OS.GetDeviceCaps(n2, 104);
        if (OS.IsWinCE && n6 == 0 && n7 >= 20) {
            n6 = 20;
        }
        this.colorRefCount = new int[n7];
        byte[] byArray = new byte[4 + 4 * n7];
        byArray[0] = 0;
        byArray[1] = 3;
        byArray[2] = 0;
        byArray[3] = 1;
        byte[] byArray2 = new byte[4 * n7];
        OS.GetSystemPaletteEntries(n2, 0, n7, byArray2);
        System.arraycopy(byArray2, 0, byArray, 4, 4 * n7);
        for (int i2 = 0; i2 < n6 / 2; ++i2) {
            this.colorRefCount[i2] = 1;
            this.colorRefCount[n7 - 1 - i2] = 1;
        }
        this.internal_dispose_GC(n2, null);
        this.hPalette = OS.CreatePalette(byArray);
    }

    @Override
    public abstract int internal_new_GC(GCData var1);

    @Override
    public abstract void internal_dispose_GC(int var1, GCData var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.disposed;
        }
    }

    public boolean loadFont(String string) {
        this.checkDevice();
        if (string == null) {
            SWT.error(4);
        }
        if (OS.IsWinNT && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            boolean bl2;
            TCHAR tCHAR = new TCHAR(0, string, true);
            boolean bl3 = bl2 = OS.AddFontResourceEx(tCHAR, 16, 0) != 0;
            if (bl2) {
                if (this.gdipToken != null) {
                    if (this.fontCollection == 0) {
                        this.fontCollection = Gdip.PrivateFontCollection_new();
                        if (this.fontCollection == 0) {
                            SWT.error(2);
                        }
                    }
                    int n2 = string.length();
                    char[] cArray = new char[n2 + 1];
                    string.getChars(0, n2, cArray, 0);
                    Gdip.PrivateFontCollection_AddFontFile(this.fontCollection, cArray);
                } else {
                    this.addFont(string);
                }
            }
            return bl2;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void new_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            for (int i2 = 0; i2 < this.objects.length; ++i2) {
                if (this.objects[i2] != null) continue;
                this.objects[i2] = object;
                this.errors[i2] = new Error();
                return;
            }
            Object[] objectArray = new Object[this.objects.length + 128];
            System.arraycopy(this.objects, 0, objectArray, 0, this.objects.length);
            objectArray[this.objects.length] = object;
            this.objects = objectArray;
            Error[] errorArray = new Error[this.errors.length + 128];
            System.arraycopy(this.errors, 0, errorArray, 0, this.errors.length);
            errorArray[this.errors.length] = new Error();
            this.errors = errorArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printErrors() {
        if (!DEBUG) {
            return;
        }
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                if (this.objects == null || this.errors == null) {
                    return;
                }
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                int n12 = 0;
                for (int i2 = 0; i2 < this.objects.length; ++i2) {
                    Object object2 = this.objects[i2];
                    if (object2 == null) continue;
                    ++n2;
                    if (object2 instanceof Color) {
                        ++n3;
                    }
                    if (object2 instanceof Cursor) {
                        ++n4;
                    }
                    if (object2 instanceof Font) {
                        ++n5;
                    }
                    if (object2 instanceof GC) {
                        ++n6;
                    }
                    if (object2 instanceof Image) {
                        ++n7;
                    }
                    if (object2 instanceof Path) {
                        ++n8;
                    }
                    if (object2 instanceof Pattern) {
                        ++n9;
                    }
                    if (object2 instanceof Region) {
                        ++n10;
                    }
                    if (object2 instanceof TextLayout) {
                        ++n11;
                    }
                    if (!(object2 instanceof Transform)) continue;
                    ++n12;
                }
                if (n2 != 0) {
                    String string = "Summary: ";
                    if (n3 != 0) {
                        string = string + n3 + " Color(s), ";
                    }
                    if (n4 != 0) {
                        string = string + n4 + " Cursor(s), ";
                    }
                    if (n5 != 0) {
                        string = string + n5 + " Font(s), ";
                    }
                    if (n6 != 0) {
                        string = string + n6 + " GC(s), ";
                    }
                    if (n7 != 0) {
                        string = string + n7 + " Image(s), ";
                    }
                    if (n8 != 0) {
                        string = string + n8 + " Path(s), ";
                    }
                    if (n9 != 0) {
                        string = string + n9 + " Pattern(s), ";
                    }
                    if (n10 != 0) {
                        string = string + n10 + " Region(s), ";
                    }
                    if (n11 != 0) {
                        string = string + n11 + " TextLayout(s), ";
                    }
                    if (n12 != 0) {
                        string = string + n12 + " Transforms(s), ";
                    }
                    if (string.length() != 0) {
                        string = string.substring(0, string.length() - 2);
                        System.err.println(string);
                    }
                    for (int i3 = 0; i3 < this.errors.length; ++i3) {
                        if (this.errors[i3] == null) continue;
                        this.errors[i3].printStackTrace(System.err);
                    }
                }
            }
        }
    }

    protected void release() {
        if (this.gdipToken != null) {
            if (this.fontCollection != 0) {
                Gdip.PrivateFontCollection_delete(this.fontCollection);
            }
            this.fontCollection = 0;
            Gdip.GdiplusShutdown(this.gdipToken[0]);
        }
        this.gdipToken = null;
        this.scripts = null;
        if (this.hPalette != 0) {
            OS.DeleteObject(this.hPalette);
        }
        this.hPalette = 0;
        this.colorRefCount = null;
        this.logFonts = null;
        this.nFonts = 0;
    }

    public void setWarnings(boolean bl2) {
        this.checkDevice();
    }

    boolean getEnableAutoScaling() {
        return this.enableAutoScaling;
    }

    void setEnableAutoScaling(boolean bl2) {
        this.enableAutoScaling = bl2;
    }

    protected int getDeviceZoom() {
        return DPIUtil.mapDPIToZoom(this._getDPIx());
    }

    static {
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

