/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

public class LineAttributes {
    public float width;
    public int style;
    public int cap;
    public int join;
    public float[] dash;
    public float dashOffset;
    public float miterLimit;

    public LineAttributes(float f2) {
        this(f2, 1, 1, 1, null, 0.0f, 10.0f);
    }

    public LineAttributes(float f2, int n2, int n3) {
        this(f2, n2, n3, 1, null, 0.0f, 10.0f);
    }

    public LineAttributes(float f2, int n2, int n3, int n4, float[] fArray, float f3, float f4) {
        this.width = f2;
        this.cap = n2;
        this.join = n3;
        this.style = n4;
        this.dash = fArray;
        this.dashOffset = f3;
        this.miterLimit = f4;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LineAttributes)) {
            return false;
        }
        LineAttributes lineAttributes = (LineAttributes)object;
        if (lineAttributes.width != this.width) {
            return false;
        }
        if (lineAttributes.cap != this.cap) {
            return false;
        }
        if (lineAttributes.join != this.join) {
            return false;
        }
        if (lineAttributes.style != this.style) {
            return false;
        }
        if (lineAttributes.dashOffset != this.dashOffset) {
            return false;
        }
        if (lineAttributes.miterLimit != this.miterLimit) {
            return false;
        }
        if (lineAttributes.dash != null && this.dash != null) {
            if (lineAttributes.dash.length != this.dash.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.dash.length; ++i2) {
                if (lineAttributes.dash[i2] == this.dash[i2]) continue;
                return false;
            }
        } else if (lineAttributes.dash != null || this.dash != null) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = Float.floatToIntBits(this.width);
        n2 = 31 * n2 + this.cap;
        n2 = 31 * n2 + this.join;
        n2 = 31 * n2 + this.style;
        n2 = 31 * n2 + Float.floatToIntBits(this.dashOffset);
        n2 = 31 * n2 + Float.floatToIntBits(this.miterLimit);
        if (this.dash != null) {
            for (int i2 = 0; i2 < this.dash.length; ++i2) {
                n2 = 31 * n2 + Float.floatToIntBits(this.dash[i2]);
            }
        }
        return n2;
    }
}

