/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.win32.GCP_RESULTS;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Control;

public class BidiUtil {
    public static final int KEYBOARD_NON_BIDI = 0;
    public static final int KEYBOARD_BIDI = 1;
    static int isBidiPlatform = -1;
    public static final int CLASSIN = 1;
    public static final int LINKBEFORE = 2;
    public static final int LINKAFTER = 4;
    static Map languageMap = new HashMap();
    static Map oldProcMap = new HashMap();
    static final String CLASS_NAME = "org.eclipse.swt.internal.BidiUtil";
    static Callback callback;
    static final int GCP_REORDER = 2;
    static final int GCP_GLYPHSHAPE = 16;
    static final int GCP_LIGATE = 32;
    static final int GCP_CLASSIN = 524288;
    static final byte GCPCLASS_ARABIC = 2;
    static final byte GCPCLASS_HEBREW = 2;
    static final byte GCPCLASS_LOCALNUMBER = 4;
    static final byte GCPCLASS_LATINNUMBER = 5;
    static final int GCPGLYPH_LINKBEFORE = 32768;
    static final int GCPGLYPH_LINKAFTER = 16384;
    static final int ETO_CLIPPED = 4;
    static final int ETO_GLYPH_INDEX = 16;
    static final int LANG_ARABIC = 1;
    static final int LANG_HEBREW = 13;
    static final int LANG_FARSI = 41;
    static final String CD_PG_HEBREW = "1255";
    static final String CD_PG_ARABIC = "1256";
    static final int HKL_NEXT = 1;
    static final int HKL_PREV = 0;
    public static final int CLASS_HEBREW = 2;
    public static final int CLASS_ARABIC = 2;
    public static final int CLASS_LOCALNUMBER = 4;
    public static final int CLASS_LATINNUMBER = 5;
    public static final int REORDER = 2;
    public static final int LIGATE = 32;
    public static final int GLYPHSHAPE = 16;

    public static void addLanguageListener(int n2, Runnable runnable) {
        languageMap.put(new LONG(n2), runnable);
        BidiUtil.subclass(n2);
    }

    public static void addLanguageListener(Control control, Runnable runnable) {
        BidiUtil.addLanguageListener(control.handle, runnable);
    }

    static int EnumSystemLanguageGroupsProc(int n2, int n3, int n4, int n5, int n6) {
        if (n2 == 12) {
            isBidiPlatform = 1;
            return 0;
        }
        if (n2 == 13) {
            isBidiPlatform = 1;
            return 0;
        }
        return 1;
    }

    public static void drawGlyphs(GC gC, char[] cArray, int[] nArray, int n2, int n3) {
        int n4 = nArray.length;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10) && OS.GetLayout(gC.handle) != 0) {
            BidiUtil.reverse(nArray);
            int n5 = n4 - 1;
            nArray[n5] = nArray[n5] - 1;
            BidiUtil.reverse(cArray);
        }
        int n6 = OS.SetBkMode(gC.handle, 1);
        OS.ExtTextOutW(gC.handle, n2, n3, 16, null, cArray, cArray.length, nArray);
        OS.SetBkMode(gC.handle, n6);
    }

    public static char[] getRenderInfo(GC gC, String string, int[] nArray, byte[] byArray, int[] nArray2, int n2, int[] nArray3) {
        int n3 = OS.GetFontLanguageInfo(gC.handle);
        int n4 = OS.GetProcessHeap();
        int[] nArray4 = new int[8];
        int n5 = OS.GetTextCharset(gC.handle);
        boolean bl2 = false;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            bl2 = OS.GetLayout(gC.handle) != 0;
        }
        OS.TranslateCharsetInfo(n5, nArray4, 1);
        TCHAR tCHAR = new TCHAR(nArray4[1], string, false);
        int n6 = tCHAR.length();
        boolean bl3 = (n2 & 2) == 2;
        boolean bl4 = (n2 & 4) == 4;
        GCP_RESULTS gCP_RESULTS = new GCP_RESULTS();
        gCP_RESULTS.lStructSize = GCP_RESULTS.sizeof;
        gCP_RESULTS.nGlyphs = n6;
        int n7 = gCP_RESULTS.lpOrder = OS.HeapAlloc(n4, 8, n6 * 4);
        int n8 = gCP_RESULTS.lpDx = OS.HeapAlloc(n4, 8, n6 * 4);
        int n9 = gCP_RESULTS.lpClass = OS.HeapAlloc(n4, 8, n6);
        int n10 = gCP_RESULTS.lpGlyphs = OS.HeapAlloc(n4, 8, n6 * 2);
        int n11 = 0;
        int n12 = 0;
        n11 |= 2;
        if ((n3 & 0x20) == 32) {
            n11 |= 0x20;
            n12 |= 0;
        }
        if ((n3 & 0x10) == 16) {
            n11 |= 0x10;
            if (bl3) {
                n12 |= 0x8000;
            }
            if (bl4) {
                n12 |= 0x4000;
            }
        }
        byte[] byArray2 = bl3 || bl4 ? new byte[]{(byte)n12, (byte)(n12 >> 8)} : new byte[]{(byte)n12};
        OS.MoveMemory(gCP_RESULTS.lpGlyphs, byArray2, byArray2.length);
        if ((n2 & 1) == 1) {
            n11 |= 0x80000;
            OS.MoveMemory(gCP_RESULTS.lpClass, byArray, byArray.length);
        }
        char[] cArray = new char[gCP_RESULTS.nGlyphs];
        int n13 = 0;
        for (int i2 = 0; i2 < nArray3.length - 1; ++i2) {
            Object[] objectArray;
            int n14;
            int n15 = nArray3[i2];
            gCP_RESULTS.nGlyphs = n14 = nArray3[i2 + 1] - nArray3[i2];
            TCHAR tCHAR2 = new TCHAR(nArray4[1], string.substring(n15, n15 + n14), false);
            OS.GetCharacterPlacement(gC.handle, tCHAR2, tCHAR2.length(), 0, gCP_RESULTS, n11);
            if (nArray2 != null) {
                objectArray = new int[gCP_RESULTS.nGlyphs];
                OS.MoveMemory(objectArray, gCP_RESULTS.lpDx, objectArray.length * 4);
                if (bl2) {
                    BidiUtil.reverse(objectArray);
                }
                System.arraycopy(objectArray, 0, nArray2, n13, objectArray.length);
            }
            if (nArray != null) {
                objectArray = new int[n14];
                OS.MoveMemory(objectArray, gCP_RESULTS.lpOrder, objectArray.length * 4);
                BidiUtil.translateOrder(objectArray, n13, bl2);
                System.arraycopy(objectArray, 0, nArray, n15, n14);
            }
            if (byArray != null) {
                objectArray = new byte[n14];
                OS.MoveMemory((byte[])objectArray, gCP_RESULTS.lpClass, objectArray.length);
                System.arraycopy(objectArray, 0, byArray, n15, n14);
            }
            objectArray = new char[gCP_RESULTS.nGlyphs];
            OS.MoveMemory((char[])objectArray, gCP_RESULTS.lpGlyphs, objectArray.length * 2);
            if (bl2) {
                BidiUtil.reverse((char[])objectArray);
            }
            System.arraycopy(objectArray, 0, cArray, n13, objectArray.length);
            n13 += objectArray.length;
            gCP_RESULTS.lpOrder += n14 * 4;
            gCP_RESULTS.lpDx += n14 * 4;
            gCP_RESULTS.lpClass += n14;
            gCP_RESULTS.lpGlyphs += objectArray.length * 2;
        }
        OS.HeapFree(n4, 0, n10);
        OS.HeapFree(n4, 0, n9);
        OS.HeapFree(n4, 0, n8);
        OS.HeapFree(n4, 0, n7);
        return cArray;
    }

    public static void getOrderInfo(GC gC, String string, int[] nArray, byte[] byArray, int n2, int[] nArray2) {
        int n3 = OS.GetFontLanguageInfo(gC.handle);
        int n4 = OS.GetProcessHeap();
        int[] nArray3 = new int[8];
        int n5 = OS.GetTextCharset(gC.handle);
        OS.TranslateCharsetInfo(n5, nArray3, 1);
        TCHAR tCHAR = new TCHAR(nArray3[1], string, false);
        int n6 = tCHAR.length();
        boolean bl2 = false;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            bl2 = OS.GetLayout(gC.handle) != 0;
        }
        GCP_RESULTS gCP_RESULTS = new GCP_RESULTS();
        gCP_RESULTS.lStructSize = GCP_RESULTS.sizeof;
        gCP_RESULTS.nGlyphs = n6;
        int n7 = gCP_RESULTS.lpOrder = OS.HeapAlloc(n4, 8, n6 * 4);
        int n8 = gCP_RESULTS.lpClass = OS.HeapAlloc(n4, 8, n6);
        int n9 = 0;
        n9 |= 2;
        if ((n3 & 0x20) == 32) {
            n9 |= 0x20;
        }
        if ((n3 & 0x10) == 16) {
            n9 |= 0x10;
        }
        if ((n2 & 1) == 1) {
            n9 |= 0x80000;
            OS.MoveMemory(gCP_RESULTS.lpClass, byArray, byArray.length);
        }
        int n10 = 0;
        for (int i2 = 0; i2 < nArray2.length - 1; ++i2) {
            Object[] objectArray;
            int n11;
            int n12 = nArray2[i2];
            gCP_RESULTS.nGlyphs = n11 = nArray2[i2 + 1] - nArray2[i2];
            TCHAR tCHAR2 = new TCHAR(nArray3[1], string.substring(n12, n12 + n11), false);
            OS.GetCharacterPlacement(gC.handle, tCHAR2, tCHAR2.length(), 0, gCP_RESULTS, n9);
            if (nArray != null) {
                objectArray = new int[n11];
                OS.MoveMemory(objectArray, gCP_RESULTS.lpOrder, objectArray.length * 4);
                BidiUtil.translateOrder(objectArray, n10, bl2);
                System.arraycopy(objectArray, 0, nArray, n12, n11);
            }
            if (byArray != null) {
                objectArray = new byte[n11];
                OS.MoveMemory((byte[])objectArray, gCP_RESULTS.lpClass, objectArray.length);
                System.arraycopy(objectArray, 0, byArray, n12, n11);
            }
            n10 += gCP_RESULTS.nGlyphs;
            gCP_RESULTS.lpOrder += n11 * 4;
            gCP_RESULTS.lpClass += n11;
        }
        OS.HeapFree(n4, 0, n8);
        OS.HeapFree(n4, 0, n7);
    }

    public static int getFontBidiAttributes(GC gC) {
        int n2 = 0;
        int n3 = OS.GetFontLanguageInfo(gC.handle);
        if ((n3 & 2) != 0) {
            n2 |= 2;
        }
        if ((n3 & 0x20) != 0) {
            n2 |= 0x20;
        }
        if ((n3 & 0x10) != 0) {
            n2 |= 0x10;
        }
        return n2;
    }

    public static int getKeyboardLanguage() {
        int n2 = OS.GetKeyboardLayout(0);
        return BidiUtil.isBidiLang(n2) ? 1 : 0;
    }

    static int[] getKeyboardLanguageList() {
        int n2 = 10;
        int[] nArray = new int[n2];
        int n3 = OS.GetKeyboardLayoutList(n2, nArray);
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    static boolean isBidiLang(int n2) {
        short s2 = OS.PRIMARYLANGID(OS.LOWORD(n2));
        return s2 == 1 || s2 == 13 || s2 == 41;
    }

    public static boolean isBidiPlatform() {
        if (OS.IsWinCE) {
            return false;
        }
        if (isBidiPlatform != -1) {
            return isBidiPlatform == 1;
        }
        isBidiPlatform = 0;
        if (!BidiUtil.isKeyboardBidi()) {
            return false;
        }
        Callback callback = null;
        try {
            callback = new Callback(Class.forName(CLASS_NAME), "EnumSystemLanguageGroupsProc", 5);
            int n2 = callback.getAddress();
            if (n2 == 0) {
                SWT.error(3);
            }
            OS.EnumSystemLanguageGroups(n2, 1, 0);
            callback.dispose();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (isBidiPlatform == 1) {
            return true;
        }
        String string = String.valueOf(OS.GetACP());
        if (CD_PG_ARABIC.equals(string) || CD_PG_HEBREW.equals(string)) {
            isBidiPlatform = 1;
        }
        return isBidiPlatform == 1;
    }

    public static boolean isKeyboardBidi() {
        int[] nArray = BidiUtil.getKeyboardLanguageList();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (!BidiUtil.isBidiLang(nArray[i2])) continue;
            return true;
        }
        return false;
    }

    public static void removeLanguageListener(int n2) {
        languageMap.remove(new LONG(n2));
        BidiUtil.unsubclass(n2);
    }

    public static void removeLanguageListener(Control control) {
        BidiUtil.removeLanguageListener(control.handle);
    }

    public static int resolveTextDirection(String string) {
        if (string == null) {
            return 0;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return 0;
        }
        char[] cArray = new char[]{' ', ' ', '1'};
        char[] cArray2 = new char[]{'\u202b', 'a', ' '};
        char[] cArray3 = new char[]{'\u05d0', ' ', ' '};
        GCP_RESULTS gCP_RESULTS = new GCP_RESULTS();
        gCP_RESULTS.lStructSize = GCP_RESULTS.sizeof;
        int n3 = gCP_RESULTS.nGlyphs = cArray2.length;
        int n4 = OS.GetProcessHeap();
        int n5 = gCP_RESULTS.lpOrder = OS.HeapAlloc(n4, 8, n3 * 4);
        int n6 = OS.GetDC(0);
        int[] nArray = new int[1];
        int n7 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2;
            cArray[0] = c2 = string.charAt(i2);
            OS.GetCharacterPlacementW(n6, cArray, cArray.length, 0, gCP_RESULTS, 2);
            OS.MoveMemory(nArray, gCP_RESULTS.lpOrder, 4);
            if (nArray[0] == 2) {
                n7 = 0x4000000;
                break;
            }
            cArray2[2] = c2;
            OS.GetCharacterPlacementW(n6, cArray2, cArray2.length, 0, gCP_RESULTS, 2);
            OS.MoveMemory(nArray, gCP_RESULTS.lpOrder + 4, 4);
            if (nArray[0] != 1) continue;
            cArray3[2] = c2;
            OS.GetCharacterPlacementW(n6, cArray3, cArray3.length, 0, gCP_RESULTS, 2);
            OS.MoveMemory(nArray, gCP_RESULTS.lpOrder, 4);
            if (nArray[0] != 0) continue;
            n7 = 0x2000000;
            break;
        }
        OS.ReleaseDC(0, n6);
        OS.HeapFree(n4, 0, n5);
        return n7;
    }

    public static void setKeyboardLanguage(int n2) {
        if (n2 == BidiUtil.getKeyboardLanguage()) {
            return;
        }
        boolean bl2 = n2 == 1;
        int[] nArray = BidiUtil.getKeyboardLanguageList();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (bl2 != BidiUtil.isBidiLang(nArray[i2])) continue;
            OS.ActivateKeyboardLayout(nArray[i2], 0);
            return;
        }
    }

    public static boolean setOrientation(int n2, int n3) {
        if (OS.IsWinCE) {
            return false;
        }
        if (OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return false;
        }
        int n4 = OS.GetWindowLong(n2, -20);
        n4 = (n3 & 0x4000000) != 0 ? (n4 |= 0x400000) : (n4 &= 0xFFBFFFFF);
        OS.SetWindowLong(n2, -20, n4);
        return true;
    }

    public static boolean setOrientation(Control control, int n2) {
        return BidiUtil.setOrientation(control.handle, n2);
    }

    static void subclass(int n2) {
        LONG lONG = new LONG(n2);
        if (oldProcMap.get(lONG) == null) {
            int n3 = OS.GetWindowLongPtr(n2, -4);
            oldProcMap.put(lONG, new LONG(n3));
            OS.SetWindowLongPtr(n2, -4, callback.getAddress());
        }
    }

    static void reverse(char[] cArray) {
        int n2 = cArray.length;
        for (int i2 = 0; i2 <= (n2 - 1) / 2; ++i2) {
            char c2 = cArray[i2];
            cArray[i2] = cArray[n2 - 1 - i2];
            cArray[n2 - 1 - i2] = c2;
        }
    }

    static void reverse(int[] nArray) {
        int n2 = nArray.length;
        for (int i2 = 0; i2 <= (n2 - 1) / 2; ++i2) {
            int n3 = nArray[i2];
            nArray[i2] = nArray[n2 - 1 - i2];
            nArray[n2 - 1 - i2] = n3;
        }
    }

    static void translateOrder(int[] nArray, int n2, boolean bl2) {
        int n3;
        int n4 = 0;
        int n5 = nArray.length;
        if (bl2) {
            for (n3 = 0; n3 < n5; ++n3) {
                n4 = Math.max(n4, nArray[n3]);
            }
        }
        n3 = 0;
        while (n3 < n5) {
            if (bl2) {
                nArray[n3] = n4 - nArray[n3];
            }
            int n6 = n3++;
            nArray[n6] = nArray[n6] + n2;
        }
    }

    static void unsubclass(int n2) {
        LONG lONG = new LONG(n2);
        if (languageMap.get(lONG) == null) {
            LONG lONG2 = (LONG)oldProcMap.remove(lONG);
            if (lONG2 == null) {
                return;
            }
            OS.SetWindowLongPtr(n2, -4, lONG2.value);
        }
    }

    static int windowProc(int n2, int n3, int n4, int n5) {
        Object object;
        LONG lONG = new LONG(n2);
        switch (n3) {
            case 81: {
                object = (Runnable)languageMap.get(lONG);
                if (object == null) break;
                object.run();
            }
        }
        object = (LONG)oldProcMap.get(lONG);
        return OS.CallWindowProc(((LONG)object).value, n2, n3, n4, n5);
    }

    static {
        try {
            callback = new Callback(Class.forName(CLASS_NAME), "windowProc", 4);
            if (callback.getAddress() == 0) {
                SWT.error(3);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

