/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageFileNameProvider;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil$AutoScaleMethod;

public class DPIUtil {
    private static final int DPI_ZOOM_100 = 96;
    private static int deviceZoom = 100;
    private static int nativeDeviceZoom = 100;
    private static DPIUtil$AutoScaleMethod autoScaleMethodSetting = DPIUtil$AutoScaleMethod.AUTO;
    private static DPIUtil$AutoScaleMethod autoScaleMethod = DPIUtil$AutoScaleMethod.NEAREST;
    private static final String SWT_AUTOSCALE = "swt.autoScale";
    private static final String SWT_AUTOSCALE_METHOD = "swt.autoScale.method";

    public static ImageData autoScaleDown(Device device, ImageData imageData) {
        if (deviceZoom == 100 || imageData == null || device != null && !device.isAutoScalable()) {
            return imageData;
        }
        float f2 = 1.0f / DPIUtil.getScalingFactor();
        return DPIUtil.autoScaleImageData(device, imageData, f2);
    }

    public static int[] autoScaleDown(int[] nArray) {
        if (deviceZoom == 100 || nArray == null) {
            return nArray;
        }
        float f2 = DPIUtil.getScalingFactor();
        int[] nArray2 = new int[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray2[i2] = Math.round((float)nArray[i2] / f2);
        }
        return nArray2;
    }

    public static int[] autoScaleDown(Drawable drawable, int[] nArray) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return nArray;
        }
        return DPIUtil.autoScaleDown(nArray);
    }

    public static float[] autoScaleDown(float[] fArray) {
        if (deviceZoom == 100 || fArray == null) {
            return fArray;
        }
        float f2 = DPIUtil.getScalingFactor();
        float[] fArray2 = new float[fArray.length];
        for (int i2 = 0; i2 < fArray2.length; ++i2) {
            fArray2[i2] = fArray[i2] / f2;
        }
        return fArray2;
    }

    public static float[] autoScaleDown(Drawable drawable, float[] fArray) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return fArray;
        }
        return DPIUtil.autoScaleDown(fArray);
    }

    public static int autoScaleDown(int n2) {
        if (deviceZoom == 100 || n2 == -1) {
            return n2;
        }
        float f2 = DPIUtil.getScalingFactor();
        return Math.round((float)n2 / f2);
    }

    public static int autoScaleDown(Drawable drawable, int n2) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return n2;
        }
        return DPIUtil.autoScaleDown(n2);
    }

    public static float autoScaleDown(float f2) {
        if (deviceZoom == 100 || f2 == -1.0f) {
            return f2;
        }
        float f3 = DPIUtil.getScalingFactor();
        return f2 / f3;
    }

    public static float autoScaleDown(Drawable drawable, float f2) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return f2;
        }
        return DPIUtil.autoScaleDown(f2);
    }

    public static Point autoScaleDown(Point point) {
        if (deviceZoom == 100 || point == null) {
            return point;
        }
        float f2 = DPIUtil.getScalingFactor();
        Point point2 = new Point(0, 0);
        point2.x = Math.round((float)point.x / f2);
        point2.y = Math.round((float)point.y / f2);
        return point2;
    }

    public static Point autoScaleDown(Drawable drawable, Point point) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return point;
        }
        return DPIUtil.autoScaleDown(point);
    }

    public static Rectangle autoScaleDown(Rectangle rectangle) {
        if (deviceZoom == 100 || rectangle == null) {
            return rectangle;
        }
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        Point point = DPIUtil.autoScaleDown(new Point(rectangle.x, rectangle.y));
        Point point2 = DPIUtil.autoScaleDown(new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height));
        rectangle2.x = point.x;
        rectangle2.y = point.y;
        rectangle2.width = point2.x - point.x;
        rectangle2.height = point2.y - point.y;
        return rectangle2;
    }

    public static Rectangle autoScaleDown(Drawable drawable, Rectangle rectangle) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return rectangle;
        }
        return DPIUtil.autoScaleDown(rectangle);
    }

    public static ImageData autoScaleImageData(Device device, ImageData imageData, int n2, int n3) {
        if (imageData == null || n2 == n3 || device != null && !device.isAutoScalable()) {
            return imageData;
        }
        float f2 = (float)n2 / (float)n3;
        return DPIUtil.autoScaleImageData(device, imageData, f2);
    }

    private static ImageData autoScaleImageData(Device device, ImageData imageData, float f2) {
        int n3 = imageData.width;
        int n4 = imageData.height;
        int n5 = Math.round((float)n3 * f2);
        int n6 = Math.round((float)n4 * f2);
        switch (autoScaleMethod) {
            case SMOOTH: {
                Image image = new Image(device, n2 -> imageData);
                ImageData imageData2 = new ImageData(n5, n6, 24, new PaletteData(255, 65280, 0xFF0000));
                imageData2.alphaData = new byte[n5 * n6];
                Image image2 = new Image(device, n2 -> imageData2);
                GC gC = new GC(image2);
                gC.setAntialias(1);
                gC.drawImage(image, 0, 0, DPIUtil.autoScaleDown(n3), DPIUtil.autoScaleDown(n4), 0, 0, Math.round(DPIUtil.autoScaleDown((float)n3 * f2)), Math.round(DPIUtil.autoScaleDown((float)n4 * f2)));
                gC.dispose();
                image.dispose();
                ImageData imageData3 = image2.getImageData(DPIUtil.getDeviceZoom());
                image2.dispose();
                return imageData3;
            }
        }
        return imageData.scaledTo(n5, n6);
    }

    public static Rectangle autoScaleBounds(Rectangle rectangle, int n2, int n3) {
        if (deviceZoom == 100 || rectangle == null || n2 == n3) {
            return rectangle;
        }
        float f2 = (float)n2 / (float)n3;
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        rectangle2.x = Math.round((float)rectangle.x * f2);
        rectangle2.y = Math.round((float)rectangle.y * f2);
        rectangle2.width = Math.round((float)rectangle.width * f2);
        rectangle2.height = Math.round((float)rectangle.height * f2);
        return rectangle2;
    }

    public static ImageData autoScaleUp(Device device, ImageData imageData) {
        if (deviceZoom == 100 || imageData == null || device != null && !device.isAutoScalable()) {
            return imageData;
        }
        float f2 = DPIUtil.getScalingFactor();
        return DPIUtil.autoScaleImageData(device, imageData, f2);
    }

    public static int[] autoScaleUp(int[] nArray) {
        if (deviceZoom == 100 || nArray == null) {
            return nArray;
        }
        float f2 = DPIUtil.getScalingFactor();
        int[] nArray2 = new int[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray2[i2] = Math.round((float)nArray[i2] * f2);
        }
        return nArray2;
    }

    public static int[] autoScaleUp(Drawable drawable, int[] nArray) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return nArray;
        }
        return DPIUtil.autoScaleUp(nArray);
    }

    public static int autoScaleUp(int n2) {
        if (deviceZoom == 100 || n2 == -1) {
            return n2;
        }
        float f2 = DPIUtil.getScalingFactor();
        return Math.round((float)n2 * f2);
    }

    public static int autoScaleUpUsingNativeDPI(int n2) {
        if (nativeDeviceZoom == 100 || n2 == -1) {
            return n2;
        }
        float f2 = (float)nativeDeviceZoom / 100.0f;
        return Math.round((float)n2 * f2);
    }

    public static int autoScaleUp(Drawable drawable, int n2) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return n2;
        }
        return DPIUtil.autoScaleUp(n2);
    }

    public static float autoScaleUp(float f2) {
        if (deviceZoom == 100 || f2 == -1.0f) {
            return f2;
        }
        float f3 = DPIUtil.getScalingFactor();
        return f2 * f3;
    }

    public static float autoScaleUp(Drawable drawable, float f2) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return f2;
        }
        return DPIUtil.autoScaleUp(f2);
    }

    public static Point autoScaleUp(Point point) {
        if (deviceZoom == 100 || point == null) {
            return point;
        }
        float f2 = DPIUtil.getScalingFactor();
        Point point2 = new Point(0, 0);
        point2.x = Math.round((float)point.x * f2);
        point2.y = Math.round((float)point.y * f2);
        return point2;
    }

    public static Point autoScaleUp(Drawable drawable, Point point) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return point;
        }
        return DPIUtil.autoScaleUp(point);
    }

    public static Rectangle autoScaleUp(Rectangle rectangle) {
        if (deviceZoom == 100 || rectangle == null) {
            return rectangle;
        }
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        Point point = DPIUtil.autoScaleUp(new Point(rectangle.x, rectangle.y));
        Point point2 = DPIUtil.autoScaleUp(new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height));
        rectangle2.x = point.x;
        rectangle2.y = point.y;
        rectangle2.width = point2.x - point.x;
        rectangle2.height = point2.y - point.y;
        return rectangle2;
    }

    public static Rectangle autoScaleUp(Drawable drawable, Rectangle rectangle) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return rectangle;
        }
        return DPIUtil.autoScaleUp(rectangle);
    }

    private static float getScalingFactor() {
        return (float)deviceZoom / 100.0f;
    }

    public static int mapDPIToZoom(int n2) {
        double d2 = (double)n2 * 100.0 / 96.0;
        int n3 = (int)Math.round(d2);
        return n3;
    }

    public static ImageData validateAndGetImageDataAtZoom(ImageDataProvider imageDataProvider, int n2, boolean[] blArray) {
        ImageData imageData;
        if (imageDataProvider == null) {
            SWT.error(4);
        }
        boolean bl2 = blArray[0] = (imageData = imageDataProvider.getImageData(n2)) != null;
        if (n2 != 100 && !blArray[0]) {
            imageData = imageDataProvider.getImageData(100);
        }
        if (imageData == null) {
            SWT.error(5, null, ": ImageDataProvider [" + imageDataProvider + "] returns null ImageData at 100% zoom.");
        }
        return imageData;
    }

    public static String validateAndGetImagePathAtZoom(ImageFileNameProvider imageFileNameProvider, int n2, boolean[] blArray) {
        String string;
        if (imageFileNameProvider == null) {
            SWT.error(4);
        }
        boolean bl2 = blArray[0] = (string = imageFileNameProvider.getImagePath(n2)) != null;
        if (n2 != 100 && !blArray[0]) {
            string = imageFileNameProvider.getImagePath(100);
        }
        if (string == null) {
            SWT.error(5, null, ": ImageFileNameProvider [" + imageFileNameProvider + "] returns null filename at 100% zoom.");
        }
        return string;
    }

    public static int getDeviceZoom() {
        return deviceZoom;
    }

    public static void setDeviceZoom(int n2) {
        nativeDeviceZoom = n2;
        int n3 = 0;
        String string = System.getProperty(SWT_AUTOSCALE);
        if (string != null) {
            if ("false".equalsIgnoreCase(string)) {
                n3 = 100;
            } else if ("quarter".equalsIgnoreCase(string)) {
                n3 = Math.round((float)n2 / 25.0f) * 25;
            } else if ("exact".equalsIgnoreCase(string)) {
                n3 = n2;
            } else {
                try {
                    int n4 = Integer.parseInt(string);
                    n3 = Math.max(Math.min(n4, 1600), 25);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (n3 == 0) {
            n3 = Math.max((n2 + 25) / 100 * 100, 100);
            if (!"integer".equalsIgnoreCase(string)) {
                n3 = Math.min(n3, 200);
            }
        }
        deviceZoom = n3;
        System.setProperty("org.eclipse.swt.internal.deviceZoom", Integer.toString(n3));
        if (n3 != 100 && autoScaleMethodSetting == DPIUtil$AutoScaleMethod.AUTO) {
            autoScaleMethod = n3 / 100 * 100 == n3 || !"gtk".equals(SWT.getPlatform()) ? DPIUtil$AutoScaleMethod.NEAREST : DPIUtil$AutoScaleMethod.SMOOTH;
        }
    }

    static {
        String string = System.getProperty(SWT_AUTOSCALE_METHOD);
        if (string != null) {
            if (DPIUtil$AutoScaleMethod.NEAREST.name().equalsIgnoreCase(string)) {
                autoScaleMethod = autoScaleMethodSetting = DPIUtil$AutoScaleMethod.NEAREST;
            } else if (DPIUtil$AutoScaleMethod.SMOOTH.name().equalsIgnoreCase(string)) {
                autoScaleMethod = autoScaleMethodSetting = DPIUtil$AutoScaleMethod.SMOOTH;
            }
        }
    }
}

