/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.image.JPEGVariableSizeSegment;
import org.eclipse.swt.internal.image.LEDataInputStream;

final class JPEGScanHeader
extends JPEGVariableSizeSegment {
    public int[][] componentParameters;

    public JPEGScanHeader(byte[] byArray) {
        super(byArray);
    }

    public JPEGScanHeader(LEDataInputStream lEDataInputStream) {
        super(lEDataInputStream);
        this.initializeComponentParameters();
    }

    public int getApproxBitPositionHigh() {
        return this.reference[2 * this.getNumberOfImageComponents() + 7] >> 4;
    }

    public int getApproxBitPositionLow() {
        return this.reference[2 * this.getNumberOfImageComponents() + 7] & 0xF;
    }

    public int getEndOfSpectralSelection() {
        return this.reference[2 * this.getNumberOfImageComponents() + 6];
    }

    public int getNumberOfImageComponents() {
        return this.reference[4];
    }

    public int getStartOfSpectralSelection() {
        return this.reference[2 * this.getNumberOfImageComponents() + 5];
    }

    void initializeComponentParameters() {
        int n2 = this.getNumberOfImageComponents();
        this.componentParameters = new int[0][];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = 5 + i2 * 2;
            int n4 = this.reference[n3] & 0xFF;
            int n5 = (this.reference[n3 + 1] & 0xFF) >> 4;
            int n6 = this.reference[n3 + 1] & 0xF;
            if (this.componentParameters.length <= n4) {
                int[][] nArrayArray = new int[n4 + 1][];
                System.arraycopy(this.componentParameters, 0, nArrayArray, 0, this.componentParameters.length);
                this.componentParameters = nArrayArray;
            }
            this.componentParameters[n4] = new int[]{n5, n6};
        }
    }

    public void initializeContents() {
        int n2 = this.getNumberOfImageComponents();
        int[][] nArray = this.componentParameters;
        if (n2 == 0 || n2 != nArray.length) {
            SWT.error(40);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2 * 2 + 5;
            int[] nArray2 = nArray[i2];
            this.reference[n3] = (byte)(i2 + 1);
            this.reference[n3 + 1] = (byte)(nArray2[0] * 16 + nArray2[1]);
        }
    }

    public void setEndOfSpectralSelection(int n2) {
        this.reference[2 * this.getNumberOfImageComponents() + 6] = (byte)n2;
    }

    public void setNumberOfImageComponents(int n2) {
        this.reference[4] = (byte)(n2 & 0xFF);
    }

    public void setStartOfSpectralSelection(int n2) {
        this.reference[2 * this.getNumberOfImageComponents() + 5] = (byte)n2;
    }

    @Override
    public int signature() {
        return 65498;
    }

    public boolean verifyProgressiveScan() {
        int n2 = this.getStartOfSpectralSelection();
        int n3 = this.getEndOfSpectralSelection();
        int n4 = this.getApproxBitPositionLow();
        int n5 = this.getApproxBitPositionHigh();
        int n6 = this.getNumberOfImageComponents();
        if ((n2 == 0 && n3 == 0 || n2 <= n3 && n3 <= 63) && n4 <= 13 && n5 <= 13 && (n5 == 0 || n5 == n4 + 1)) {
            return n2 == 0 || n2 > 0 && n6 == 1;
        }
        return false;
    }

    public boolean isACProgressiveScan() {
        return this.getStartOfSpectralSelection() != 0 && this.getEndOfSpectralSelection() != 0;
    }

    public boolean isDCProgressiveScan() {
        return this.getStartOfSpectralSelection() == 0 && this.getEndOfSpectralSelection() == 0;
    }

    public boolean isFirstScan() {
        return this.getApproxBitPositionHigh() == 0;
    }
}

