/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.image.FileFormat;
import org.eclipse.swt.internal.image.LEDataInputStream;

public final class OS2BMPFileFormat
extends FileFormat {
    static final int BMPFileHeaderSize = 14;
    static final int BMPHeaderFixedSize = 12;
    int width;
    int height;
    int bitCount;

    @Override
    boolean isFileFormat(LEDataInputStream lEDataInputStream) {
        try {
            byte[] byArray = new byte[18];
            lEDataInputStream.read(byArray);
            lEDataInputStream.unread(byArray);
            int n2 = byArray[14] & 0xFF | (byArray[15] & 0xFF) << 8 | (byArray[16] & 0xFF) << 16 | (byArray[17] & 0xFF) << 24;
            return byArray[0] == 66 && byArray[1] == 77 && n2 == 12;
        }
        catch (Exception exception) {
            return false;
        }
    }

    byte[] loadData(byte[] byArray) {
        int n2 = (this.width * this.bitCount + 7) / 8;
        n2 = (n2 + 3) / 4 * 4;
        byte[] byArray2 = this.loadData(byArray, n2);
        this.flipScanLines(byArray2, n2, this.height);
        return byArray2;
    }

    byte[] loadData(byte[] byArray, int n2) {
        int n3 = this.height * n2;
        byte[] byArray2 = new byte[n3];
        try {
            if (this.inputStream.read(byArray2) != n3) {
                SWT.error(40);
            }
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        return byArray2;
    }

    int[] loadFileHeader() {
        int[] nArray = new int[5];
        try {
            nArray[0] = this.inputStream.readShort();
            nArray[1] = this.inputStream.readInt();
            nArray[2] = this.inputStream.readShort();
            nArray[3] = this.inputStream.readShort();
            nArray[4] = this.inputStream.readInt();
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        if (nArray[0] != 19778) {
            SWT.error(40);
        }
        return nArray;
    }

    @Override
    ImageData[] loadFromByteStream() {
        int[] nArray = this.loadFileHeader();
        byte[] byArray = new byte[12];
        try {
            this.inputStream.read(byArray);
        }
        catch (Exception exception) {
            SWT.error(39, exception);
        }
        this.width = byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8;
        this.height = byArray[6] & 0xFF | (byArray[7] & 0xFF) << 8;
        this.bitCount = byArray[10] & 0xFF | (byArray[11] & 0xFF) << 8;
        PaletteData paletteData = this.loadPalette(byArray);
        if (this.inputStream.getPosition() < nArray[4]) {
            try {
                this.inputStream.skip(nArray[4] - this.inputStream.getPosition());
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
            }
        }
        byte[] byArray2 = this.loadData(byArray);
        int n2 = 7;
        return new ImageData[]{ImageData.internal_new(this.width, this.height, this.bitCount, paletteData, 4, byArray2, 0, null, null, -1, -1, n2, 0, 0, 0, 0)};
    }

    PaletteData loadPalette(byte[] byArray) {
        if (this.bitCount <= 8) {
            int n2 = 1 << this.bitCount;
            byte[] byArray2 = new byte[n2 * 3];
            try {
                if (this.inputStream.read(byArray2) != byArray2.length) {
                    SWT.error(40);
                }
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
            }
            return this.paletteFromBytes(byArray2, n2);
        }
        if (this.bitCount == 16) {
            return new PaletteData(31744, 992, 31);
        }
        if (this.bitCount == 24) {
            return new PaletteData(255, 65280, 0xFF0000);
        }
        return new PaletteData(65280, 0xFF0000, -16777216);
    }

    PaletteData paletteFromBytes(byte[] byArray, int n2) {
        int n3 = 0;
        RGB[] rGBArray = new RGB[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            rGBArray[i2] = new RGB(byArray[n3 + 2] & 0xFF, byArray[n3 + 1] & 0xFF, byArray[n3] & 0xFF);
            n3 += 3;
        }
        return new PaletteData(rGBArray);
    }

    static byte[] paletteToBytes(PaletteData paletteData) {
        int n2 = paletteData.colors == null ? 0 : (paletteData.colors.length < 256 ? paletteData.colors.length : 256);
        byte[] byArray = new byte[n2 * 3];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            RGB rGB = paletteData.colors[i2];
            byArray[n3] = (byte)rGB.blue;
            byArray[n3 + 1] = (byte)rGB.green;
            byArray[n3 + 2] = (byte)rGB.red;
            n3 += 3;
        }
        return byArray;
    }

    int unloadData(ImageData imageData, OutputStream outputStream) {
        int n2 = 0;
        try {
            int n3 = (imageData.width * imageData.depth + 7) / 8;
            n2 = (n3 + 3) / 4 * 4;
            int n4 = 32678 / n2;
            byte[] byArray = new byte[n4 * n2];
            byte[] byArray2 = imageData.data;
            int n5 = imageData.bytesPerLine;
            int n6 = n5 * (imageData.height - 1);
            if (imageData.depth == 16) {
                for (int i2 = 0; i2 < imageData.height; i2 += n4) {
                    int n7 = imageData.height - i2;
                    if (n4 < n7) {
                        n7 = n4;
                    }
                    int n8 = 0;
                    for (int i3 = 0; i3 < n7; ++i3) {
                        for (int i4 = 0; i4 < n3; i4 += 2) {
                            byArray[n8 + i4 + 1] = byArray2[n6 + i4 + 1];
                            byArray[n8 + i4] = byArray2[n6 + i4];
                        }
                        n8 += n2;
                        n6 -= n5;
                    }
                    outputStream.write(byArray, 0, n8);
                }
            } else {
                for (int i5 = 0; i5 < imageData.height; i5 += n4) {
                    int n9 = imageData.height - i5;
                    int n10 = n9 < n4 ? n9 : n4;
                    int n11 = 0;
                    for (int i6 = 0; i6 < n10; ++i6) {
                        System.arraycopy(byArray2, n6, byArray, n11, n3);
                        n11 += n2;
                        n6 -= n5;
                    }
                    outputStream.write(byArray, 0, n11);
                }
            }
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        return n2 * imageData.height;
    }

    @Override
    void unloadIntoByteStream(ImageLoader imageLoader) {
        byte[] byArray;
        int n2;
        ImageData imageData = imageLoader.data[0];
        if (imageData.depth != 1 && imageData.depth != 4 && imageData.depth != 8 && imageData.depth != 16 && imageData.depth != 24 && imageData.depth != 32) {
            SWT.error(38);
        }
        PaletteData paletteData = imageData.palette;
        if (imageData.depth == 16 || imageData.depth == 24 || imageData.depth == 32) {
            if (!paletteData.isDirect) {
                SWT.error(40);
            }
            n2 = 0;
            byArray = null;
        } else {
            if (paletteData.isDirect) {
                SWT.error(40);
            }
            n2 = paletteData.colors.length;
            byArray = OS2BMPFileFormat.paletteToBytes(paletteData);
        }
        int n3 = 26;
        int[] nArray = new int[]{19778, 0, 0, 0, n3};
        if (byArray != null) {
            nArray[4] = nArray[4] + byArray.length;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.unloadData(imageData, byteArrayOutputStream);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        nArray[1] = nArray[4] + byArray2.length;
        try {
            this.outputStream.writeShort(nArray[0]);
            this.outputStream.writeInt(nArray[1]);
            this.outputStream.writeShort(nArray[2]);
            this.outputStream.writeShort(nArray[3]);
            this.outputStream.writeInt(nArray[4]);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        try {
            this.outputStream.writeInt(12);
            this.outputStream.writeShort(imageData.width);
            this.outputStream.writeShort(imageData.height);
            this.outputStream.writeShort(1);
            this.outputStream.writeShort((short)imageData.depth);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        if (n2 > 0) {
            try {
                this.outputStream.write(byArray);
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
            }
        }
        try {
            this.outputStream.write(byArray2);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
    }

    void flipScanLines(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        int n5 = (n3 - 1) * n2;
        for (int i2 = 0; i2 < n3 / 2; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                byte by2 = byArray[i3 + n4];
                byArray[i3 + n4] = byArray[i3 + n5];
                byArray[i3 + n5] = by2;
            }
            n4 += n2;
            n5 -= n2;
        }
    }
}

