/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.win32.DEVMODE;
import org.eclipse.swt.internal.win32.DEVMODEA;
import org.eclipse.swt.internal.win32.DEVMODEW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PRINTDLG;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PrintDialog
extends Dialog {
    static final TCHAR DialogClass = new TCHAR(0, OS.IsWinCE ? "Dialog" : "#32770", true);
    PrinterData printerData = new PrinterData();

    public PrintDialog(Shell shell) {
        this(shell, 32768);
    }

    public PrintDialog(Shell shell, int n2) {
        super(shell, PrintDialog.checkStyle(shell, n2));
        this.checkSubclass();
    }

    static int checkBits(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = n3 | n4 | n5 | n6 | n7 | n8;
        if ((n2 & n9) == 0) {
            n2 |= n3;
        }
        if ((n2 & n3) != 0) {
            n2 = n2 & ~n9 | n3;
        }
        if ((n2 & n4) != 0) {
            n2 = n2 & ~n9 | n4;
        }
        if ((n2 & n5) != 0) {
            n2 = n2 & ~n9 | n5;
        }
        if ((n2 & n6) != 0) {
            n2 = n2 & ~n9 | n6;
        }
        if ((n2 & n7) != 0) {
            n2 = n2 & ~n9 | n7;
        }
        if ((n2 & n8) != 0) {
            n2 = n2 & ~n9 | n8;
        }
        return n2;
    }

    static int checkStyle(Shell shell, int n2) {
        int n3 = 229376;
        if ((n2 & 0x10000000) != 0 && ((n2 &= 0xEFFFFFFF) & n3) == 0) {
            n2 |= shell == null ? 65536 : 32768;
        }
        if ((n2 & n3) == 0) {
            n2 |= 0x10000;
        }
        if (((n2 &= 0xF7FFFFFF) & 0x6000000) == 0 && shell != null) {
            if ((shell.getStyle() & 0x2000000) != 0) {
                n2 |= 0x2000000;
            }
            if ((shell.getStyle() & 0x4000000) != 0) {
                n2 |= 0x4000000;
            }
        }
        return PrintDialog.checkBits(n2, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    public void setPrinterData(PrinterData printerData) {
        if (printerData == null) {
            printerData = new PrinterData();
        }
        this.printerData = printerData;
    }

    public PrinterData getPrinterData() {
        return this.printerData;
    }

    public int getScope() {
        return this.printerData.scope;
    }

    public void setScope(int n2) {
        this.printerData.scope = n2;
    }

    public int getStartPage() {
        return this.printerData.startPage;
    }

    public void setStartPage(int n2) {
        this.printerData.startPage = n2;
    }

    public int getEndPage() {
        return this.printerData.endPage;
    }

    public void setEndPage(int n2) {
        this.printerData.endPage = n2;
    }

    public boolean getPrintToFile() {
        return this.printerData.printToFile;
    }

    public void setPrintToFile(boolean bl2) {
        this.printerData.printToFile = bl2;
    }

    @Override
    protected void checkSubclass() {
        String string = this.getClass().getName();
        String string2 = PrintDialog.class.getName();
        if (!string2.equals(string)) {
            SWT.error(43);
        }
    }

    public PrinterData open() {
        int n2;
        int n3;
        int n4;
        Object object;
        int n5;
        int n6;
        int n7;
        Shell shell = this.getParent();
        int n8 = this.getStyle();
        int n9 = shell.handle;
        int n10 = shell.handle;
        boolean bl2 = false;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10) && (n7 = n8 & 0x6000000) != (n6 = shell.getStyle() & 0x6000000)) {
            n5 = 0x100000;
            if (n7 == 0x4000000) {
                n5 |= 0x400000;
            }
            n9 = OS.CreateWindowEx(n5, DialogClass, null, 0, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, n10, 0, OS.GetModuleHandle(null), null);
            bl2 = OS.IsWindowEnabled(n10);
            if (bl2) {
                OS.EnableWindow(n10, false);
            }
        }
        PrinterData printerData = null;
        PRINTDLG pRINTDLG = new PRINTDLG();
        pRINTDLG.lStructSize = PRINTDLG.sizeof;
        pRINTDLG.hwndOwner = n9;
        n5 = 0;
        if (this.printerData.name != null) {
            object = Printer.getPrinterList();
            if (((PrinterData[])object).length > 0) {
                for (int i2 = 0; i2 < ((PrinterData[])object).length; ++i2) {
                    if (!((PrinterData)object[i2]).name.equals(this.printerData.name)) continue;
                    n5 = 1;
                    break;
                }
            }
            if (n5 != 0) {
                TCHAR tCHAR = new TCHAR(0, this.printerData.name, true);
                n4 = tCHAR.length() * TCHAR.sizeof;
                short[] sArray = new short[4];
                int n11 = sArray.length * 2;
                sArray[1] = (short)sArray.length;
                n3 = OS.GlobalAlloc(66, n11 + n4);
                n2 = OS.GlobalLock(n3);
                OS.MoveMemory(n2, sArray, n11);
                OS.MoveMemory(n2 + n11, tCHAR, n4);
                OS.GlobalUnlock(n3);
                pRINTDLG.hDevNames = n3;
            }
        }
        object = shell.getDisplay();
        if (n5 == 0) {
            pRINTDLG.Flags = 1024;
            ((Display)object).sendPreExternalEventDispatchEvent();
            n5 = OS.PrintDlg(pRINTDLG) ? 1 : 0;
            ((Display)object).sendPostExternalEventDispatchEvent();
            if (n5 != 0 && pRINTDLG.hDevNames != 0) {
                OS.GlobalFree(pRINTDLG.hDevNames);
                pRINTDLG.hDevNames = 0;
            }
        }
        if (n5 != 0) {
            int n12;
            byte[] byArray = this.printerData.otherData;
            if (byArray != null && byArray.length != 0) {
                n4 = OS.GlobalAlloc(66, byArray.length);
                int n13 = OS.GlobalLock(n4);
                OS.MoveMemory(n13, byArray, byArray.length);
                OS.GlobalUnlock(n4);
                if (pRINTDLG.hDevMode != 0) {
                    OS.GlobalFree(pRINTDLG.hDevMode);
                }
                pRINTDLG.hDevMode = n4;
            }
            if ((n4 = pRINTDLG.hDevMode) == 0) {
                pRINTDLG.hDevMode = n4 = OS.GlobalAlloc(66, DEVMODE.sizeof);
            }
            int n14 = OS.GlobalLock(n4);
            DEVMODE dEVMODE = OS.IsUnicode ? new DEVMODEW() : new DEVMODEA();
            OS.MoveMemory(dEVMODE, n14, OS.IsUnicode ? OS.DEVMODEW_sizeof() : OS.DEVMODEA_sizeof());
            if (this.printerData.name != null) {
                n3 = Math.min(this.printerData.name.length(), 31);
                if (OS.IsUnicode) {
                    for (n2 = 0; n2 < n3; ++n2) {
                        dEVMODE.dmDeviceName[n2] = this.printerData.name.charAt(n2);
                    }
                } else {
                    byte[] byArray2 = this.printerData.name.getBytes();
                    for (int i3 = 0; i3 < n3; ++i3) {
                        ((DEVMODEA)dEVMODE).dmDeviceName[i3] = byArray2[i3];
                    }
                }
            }
            dEVMODE.dmFields |= 1;
            dEVMODE.dmOrientation = (short)(this.printerData.orientation == 1 ? 1 : 2);
            if (this.printerData.copyCount != 1) {
                dEVMODE.dmFields |= 0x100;
                dEVMODE.dmCopies = (short)this.printerData.copyCount;
            }
            if (this.printerData.collate) {
                dEVMODE.dmFields |= 0x8000;
                dEVMODE.dmCollate = 1;
            }
            if (this.printerData.duplex != -1) {
                dEVMODE.dmFields |= 0x1000;
                switch (this.printerData.duplex) {
                    case 2: {
                        dEVMODE.dmDuplex = (short)3;
                        break;
                    }
                    case 1: {
                        dEVMODE.dmDuplex = (short)2;
                        break;
                    }
                    default: {
                        dEVMODE.dmDuplex = 1;
                    }
                }
            }
            OS.MoveMemory(n14, dEVMODE, OS.IsUnicode ? OS.DEVMODEW_sizeof() : OS.DEVMODEA_sizeof());
            OS.GlobalUnlock(n4);
            pRINTDLG.Flags = 262144;
            if (this.printerData.printToFile) {
                pRINTDLG.Flags |= 0x20;
            }
            switch (this.printerData.scope) {
                case 1: {
                    pRINTDLG.Flags |= 2;
                    break;
                }
                case 2: {
                    pRINTDLG.Flags |= 1;
                    break;
                }
                default: {
                    pRINTDLG.Flags |= 0;
                }
            }
            pRINTDLG.nMinPage = 1;
            pRINTDLG.nMaxPage = (short)-1;
            pRINTDLG.nFromPage = (short)Math.min(65535, Math.max(1, this.printerData.startPage));
            pRINTDLG.nToPage = (short)Math.min(65535, Math.max(1, this.printerData.endPage));
            Shell[] shellArray = ((Display)object).getShells();
            if ((this.getStyle() & 0x30000) != 0) {
                for (int i4 = 0; i4 < shellArray.length; ++i4) {
                    if (shellArray[i4].isEnabled() && shellArray[i4] != shell) {
                        shellArray[i4].setEnabled(false);
                        continue;
                    }
                    shellArray[i4] = null;
                }
            }
            String string = "org.eclipse.swt.internal.win32.runMessagesInIdle";
            Object object2 = ((Display)object).getData(string);
            ((Display)object).setData(string, Boolean.TRUE);
            ((Display)object).sendPreExternalEventDispatchEvent();
            n5 = OS.PrintDlg(pRINTDLG) ? 1 : 0;
            ((Display)object).sendPostExternalEventDispatchEvent();
            ((Display)object).setData(string, object2);
            if ((this.getStyle() & 0x30000) != 0) {
                for (n12 = 0; n12 < shellArray.length; ++n12) {
                    if (shellArray[n12] == null || shellArray[n12].isDisposed()) continue;
                    shellArray[n12].setEnabled(true);
                }
            }
            if (n5 != 0) {
                short s2;
                n4 = pRINTDLG.hDevNames;
                n12 = OS.GlobalSize(n4) / TCHAR.sizeof * TCHAR.sizeof;
                n14 = OS.GlobalLock(n4);
                short[] sArray = new short[4];
                OS.MoveMemory(sArray, n14, 2 * sArray.length);
                TCHAR tCHAR = new TCHAR(0, n12);
                OS.MoveMemory(tCHAR, n14, n12);
                OS.GlobalUnlock(n4);
                short s3 = sArray[0];
                int n15 = 0;
                while (s3 + n15 < n12 && tCHAR.tcharAt(s3 + n15) != 0) {
                    ++n15;
                }
                String string2 = tCHAR.toString(s3, n15);
                short s4 = sArray[1];
                n15 = 0;
                while (s4 + n15 < n12 && tCHAR.tcharAt(s4 + n15) != 0) {
                    ++n15;
                }
                String string3 = tCHAR.toString(s4, n15);
                printerData = new PrinterData(string2, string3);
                if ((pRINTDLG.Flags & 2) != 0) {
                    printerData.scope = 1;
                    printerData.startPage = pRINTDLG.nFromPage & 0xFFFF;
                    printerData.endPage = pRINTDLG.nToPage & 0xFFFF;
                } else if ((pRINTDLG.Flags & 1) != 0) {
                    printerData.scope = 2;
                }
                boolean bl3 = printerData.printToFile = (pRINTDLG.Flags & 0x20) != 0;
                if (printerData.printToFile) {
                    printerData.fileName = this.printerData.fileName;
                }
                printerData.copyCount = pRINTDLG.nCopies;
                printerData.collate = (pRINTDLG.Flags & 0x10) != 0;
                n4 = pRINTDLG.hDevMode;
                n12 = OS.GlobalSize(n4);
                n14 = OS.GlobalLock(n4);
                printerData.otherData = new byte[n12];
                OS.MoveMemory(printerData.otherData, n14, n12);
                dEVMODE = OS.IsUnicode ? new DEVMODEW() : new DEVMODEA();
                OS.MoveMemory(dEVMODE, n14, OS.IsUnicode ? OS.DEVMODEW_sizeof() : OS.DEVMODEA_sizeof());
                if ((dEVMODE.dmFields & 1) != 0) {
                    s2 = dEVMODE.dmOrientation;
                    int n16 = printerData.orientation = s2 == 2 ? 2 : 1;
                }
                if ((dEVMODE.dmFields & 0x1000) != 0) {
                    s2 = dEVMODE.dmDuplex;
                    printerData.duplex = s2 == 1 ? 0 : (s2 == 3 ? 2 : 1);
                }
                OS.GlobalUnlock(n4);
                this.printerData = printerData;
            }
        }
        if (pRINTDLG.hDevNames != 0) {
            OS.GlobalFree(pRINTDLG.hDevNames);
            pRINTDLG.hDevNames = 0;
        }
        if (pRINTDLG.hDevMode != 0) {
            OS.GlobalFree(pRINTDLG.hDevMode);
            pRINTDLG.hDevMode = 0;
        }
        if (n10 != n9) {
            if (bl2) {
                OS.EnableWindow(n10, true);
            }
            OS.SetActiveWindow(n10);
            OS.DestroyWindow(n9);
        }
        return printerData;
    }
}

