/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.regex.Matcher;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.COMBOBOXINFO;
import org.eclipse.swt.internal.win32.GUITHREADINFO;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MONITORINFO;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    boolean noSelection;
    boolean ignoreDefaultSelection;
    boolean ignoreCharacter;
    boolean ignoreModify;
    boolean ignoreResize;
    boolean lockText;
    int scrollWidth;
    int visibleCount;
    int cbtHook;
    String[] items = new String[0];
    int[] segments;
    int clearSegmentsCount = 0;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    static final int VISIBLE_COUNT = 5;
    public static final int LIMIT = OS.IsWinNT ? Integer.MAX_VALUE : Short.MAX_VALUE;
    static final int CBID_LIST = 1000;
    static final int CBID_EDIT = 1001;
    static int EditProc;
    static int ListProc;
    static final int ComboProc;
    static final TCHAR ComboClass;

    public Combo(Composite composite, int n2) {
        super(composite, Combo.checkStyle(n2));
        this.style |= 0x100;
    }

    public void add(String string) {
        TCHAR tCHAR;
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n2 = OS.SendMessage(this.handle, 323, 0, tCHAR = new TCHAR(this.getCodePage(), string, true))) == -1) {
            this.error(14);
        }
        if (n2 == -2) {
            this.error(14);
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(tCHAR, true);
        }
    }

    public void add(String string, int n2) {
        TCHAR tCHAR;
        int n3;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n4 = OS.SendMessage(this.handle, 326, 0, 0);
        if (0 > n2 || n2 > n4) {
            this.error(6);
        }
        if ((n3 = OS.SendMessage(this.handle, 330, n2, tCHAR = new TCHAR(this.getCodePage(), string, true))) == -2 || n3 == -1) {
            this.error(14);
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(tCHAR, true);
        }
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSegmentListener(SegmentListener segmentListener) {
        this.checkWidget();
        if (segmentListener == null) {
            this.error(4);
        }
        this.addListener(49, new TypedListener(segmentListener));
        int n2 = -1;
        if (!this.noSelection) {
            n2 = OS.SendMessage(this.handle, 327, 0, 0);
        }
        this.clearSegments(true);
        this.applyEditSegments();
        this.applyListSegments();
        if (n2 != -1) {
            OS.SendMessage(this.handle, 334, n2, 0);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    void applyEditSegments() {
        int n2;
        int n3;
        if (--this.clearSegmentsCount != 0) {
            return;
        }
        if (!this.hooks(49) && !this.filters(49) && (this.state & 0x400000) == 0) {
            return;
        }
        int n4 = OS.GetDlgItem(this.handle, 1001);
        int n5 = OS.GetWindowTextLength(n4);
        int n6 = this.getCodePage();
        TCHAR tCHAR = new TCHAR(n6, n5 + 1);
        if (n5 > 0) {
            OS.GetWindowText(n4, tCHAR, n5 + 1);
        }
        String string = tCHAR.toString(0, n5);
        this.segments = null;
        Event event = this.getSegments(string);
        if (event == null || event.segments == null) {
            return;
        }
        this.segments = event.segments;
        int n7 = this.segments.length;
        if (n7 == 0) {
            return;
        }
        char[] cArray = event.segmentsChars;
        int n8 = OS.SendMessage(n4, 213, 0, 0) & Integer.MAX_VALUE;
        OS.SendMessage(n4, 197, n8 + Math.min(n7, LIMIT - n8), 0);
        char[] cArray2 = new char[(n5 += n7) + 1];
        int n9 = 0;
        int n10 = 0;
        int n11 = n3 = this.getOrientation() == 0x4000000 ? 8207 : 8206;
        while (n9 < n5) {
            if (n10 < n7 && n9 - n10 == this.segments[n10]) {
                n2 = cArray != null && cArray.length > n10 ? cArray[n10] : n3;
                cArray2[n9++] = n2;
                ++n10;
                continue;
            }
            if (string == null) continue;
            cArray2[n9] = string.charAt(n9++ - n10);
        }
        while (n10 < n7) {
            this.segments[n10] = n9 - n10;
            n2 = cArray != null && cArray.length > n10 ? cArray[n10] : n3;
            cArray2[n9++] = n2;
            ++n10;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(n4, 176, nArray, nArray2);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            nArray[0] = this.mbcsToWcsPos(nArray[0]);
            nArray2[0] = this.mbcsToWcsPos(nArray2[0]);
        }
        boolean bl2 = this.ignoreCharacter;
        boolean bl3 = this.ignoreModify;
        this.ignoreModify = true;
        this.ignoreCharacter = true;
        cArray2[n5] = '\u0000';
        tCHAR = new TCHAR(n6, cArray2, false);
        OS.SendMessage(n4, 177, 0, -1);
        int n12 = OS.SendMessage(n4, 198, 0, 0);
        OS.SendMessage(n4, 194, n12, tCHAR);
        nArray[0] = this.translateOffset(nArray[0]);
        nArray2[0] = this.translateOffset(nArray2[0]);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            nArray[0] = this.wcsToMbcsPos(nArray[0]);
            nArray2[0] = this.wcsToMbcsPos(nArray2[0]);
        }
        if (cArray != null && cArray.length > 0) {
            int n13 = this.state & 0x400000;
            if (cArray[0] == '\u202b') {
                super.updateTextDirection(0x4000000);
            } else if (cArray[0] == '\u202a') {
                super.updateTextDirection(0x2000000);
            }
            this.state |= n13;
        }
        OS.SendMessage(n4, 177, nArray[0], nArray2[0]);
        this.ignoreCharacter = bl2;
        this.ignoreModify = bl3;
    }

    void applyListSegments() {
        boolean bl2;
        int n2 = OS.SendMessage(this.handle, 326, 0, 0);
        if (n2 == -1) {
            return;
        }
        boolean bl3 = bl2 = this.items.length != n2;
        if (bl2) {
            this.items = new String[n2];
        }
        int n3 = this.items.length;
        int n4 = -1;
        int n5 = this.getCodePage();
        if (!this.noSelection) {
            n4 = OS.SendMessage(this.handle, 327, 0, 0);
        }
        while (n3-- > 0) {
            String string;
            TCHAR tCHAR = null;
            if (bl2) {
                int n6 = OS.SendMessage(this.handle, 329, n3, 0);
                if (n6 == -1) {
                    this.error(1);
                }
                if (OS.SendMessage(this.handle, 328, n3, tCHAR = new TCHAR(n5, n6 + 1)) == -1) {
                    return;
                }
                this.items[n3] = string = tCHAR.toString(0, n6);
            } else {
                string = this.items[n3];
            }
            if (OS.SendMessage(this.handle, 324, n3, 0) == -1) {
                return;
            }
            if (tCHAR == null) {
                tCHAR = new TCHAR(n5, string, true);
            }
            if (OS.SendMessage(this.handle, 330, n3, tCHAR) != -1) continue;
            return;
        }
        if (n4 != -1) {
            OS.SendMessage(this.handle, 334, n4, 0);
        }
    }

    @Override
    int callWindowProc(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            return 0;
        }
        if (n2 == this.handle) {
            switch (n3) {
                case 5: {
                    this.ignoreResize = true;
                    boolean bl2 = this.lockText;
                    if ((this.style & 8) == 0) {
                        this.lockText = true;
                    }
                    int n6 = OS.CallWindowProc(ComboProc, n2, n3, n4, n5);
                    if ((this.style & 8) == 0) {
                        this.lockText = bl2;
                    }
                    this.ignoreResize = false;
                    return n6;
                }
            }
            return OS.CallWindowProc(ComboProc, n2, n3, n4, n5);
        }
        int n7 = OS.GetDlgItem(this.handle, 1001);
        if (n2 == n7) {
            if (this.lockText && n3 == 12) {
                int n8 = OS.GetProcessHeap();
                int n9 = OS.GetWindowTextLength(this.handle);
                TCHAR tCHAR = new TCHAR(this.getCodePage(), n9 + 1);
                OS.GetWindowText(this.handle, tCHAR, n9 + 1);
                int n10 = tCHAR.length() * TCHAR.sizeof;
                int n11 = OS.HeapAlloc(n8, 8, n10);
                OS.MoveMemory(n11, tCHAR, n10);
                int n12 = OS.CallWindowProc(EditProc, n7, n3, n4, n11);
                OS.HeapFree(n8, 0, n11);
                return n12;
            }
            return OS.CallWindowProc(EditProc, n2, n3, n4, n5);
        }
        int n13 = OS.GetDlgItem(this.handle, 1000);
        if (n2 == n13) {
            return OS.CallWindowProc(ListProc, n2, n3, n4, n5);
        }
        return OS.DefWindowProc(n2, n3, n4, n5);
    }

    int CBTProc(int n2, int n3, int n4) {
        if (n2 == 3) {
            TCHAR tCHAR = new TCHAR(0, 128);
            OS.GetClassName(n3, tCHAR, tCHAR.length());
            String string = tCHAR.toString(0, tCHAR.strlen());
            if (string.equals("Edit") || string.equals("EDIT")) {
                int n5 = OS.GetWindowLong(n3, -16);
                OS.SetWindowLong(n3, -16, n5 & 0xFFFFFEFF);
            }
        }
        return OS.CallNextHookEx(this.cbtHook, n2, n3, n4);
    }

    @Override
    boolean checkHandle(int n2) {
        return n2 == this.handle || n2 == OS.GetDlgItem(this.handle, 1001) || n2 == OS.GetDlgItem(this.handle, 1000);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int n2) {
        n2 &= 0xFFFFF7FF;
        n2 &= 0xFFFFFCFF;
        if (((n2 = Combo.checkBits(n2, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return n2 & 0xFFFFFFF7;
        }
        return n2;
    }

    void clearSegments(boolean bl2) {
        if (this.clearSegmentsCount++ != 0) {
            return;
        }
        if (this.segments == null) {
            return;
        }
        int n2 = this.segments.length;
        if (n2 == 0) {
            return;
        }
        int n3 = OS.GetDlgItem(this.handle, 1001);
        int n4 = OS.SendMessage(n3, 213, 0, 0) & Integer.MAX_VALUE;
        if (n4 < LIMIT) {
            OS.SendMessage(n3, 197, Math.max(1, n4 - n2), 0);
        }
        if (!bl2) {
            this.segments = null;
            return;
        }
        boolean bl3 = this.ignoreCharacter;
        boolean bl4 = this.ignoreModify;
        this.ignoreModify = true;
        this.ignoreCharacter = true;
        int n5 = OS.GetWindowTextLength(n3);
        int n6 = this.getCodePage();
        TCHAR tCHAR = new TCHAR(n6, n5 + 1);
        if (n5 > 0) {
            OS.GetWindowText(n3, tCHAR, n5 + 1);
        }
        tCHAR = this.deprocessText(tCHAR, 0, -1, true);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(n3, 176, nArray, nArray2);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            nArray[0] = this.mbcsToWcsPos(nArray[0]);
            nArray2[0] = this.mbcsToWcsPos(nArray2[0]);
        }
        nArray[0] = this.untranslateOffset(nArray[0]);
        nArray2[0] = this.untranslateOffset(nArray2[0]);
        this.segments = null;
        OS.SendMessage(n3, 177, 0, -1);
        int n7 = OS.SendMessage(n3, 198, 0, 0);
        OS.SendMessage(n3, 194, n7, tCHAR);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            nArray[0] = this.wcsToMbcsPos(nArray[0]);
            nArray2[0] = this.wcsToMbcsPos(nArray2[0]);
        }
        OS.SendMessage(n3, 177, nArray[0], nArray2[0]);
        this.ignoreCharacter = bl3;
        this.ignoreModify = bl4;
    }

    public void clearSelection() {
        this.checkWidget();
        OS.SendMessage(this.handle, 322, 0, -1);
    }

    @Override
    Point computeSizeInPixels(int n2, int n3, boolean bl2) {
        int n4;
        int n5;
        int n6;
        this.checkWidget();
        int n7 = 0;
        int n8 = 0;
        if (n2 == -1) {
            n6 = 0;
            n5 = OS.GetDC(this.handle);
            n4 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n4 != 0) {
                n6 = OS.SelectObject(n5, n4);
            }
            int n9 = OS.SendMessage(this.handle, 326, 0, 0);
            RECT rECT = new RECT();
            int n10 = 3072;
            if ((this.style & 8) == 0) {
                n10 |= 0x2000;
            }
            int n11 = OS.GetWindowTextLength(this.handle);
            int n12 = this.getCodePage();
            TCHAR tCHAR = new TCHAR(n12, n11 + 1);
            OS.GetWindowText(this.handle, tCHAR, n11 + 1);
            OS.DrawText(n5, tCHAR, n11, rECT, n10);
            n7 = Math.max(n7, rECT.right - rECT.left);
            if ((this.style & 0x100) != 0) {
                n7 = Math.max(n7, this.scrollWidth);
            } else {
                for (int i2 = 0; i2 < n9; ++i2) {
                    int n13;
                    n11 = OS.SendMessage(this.handle, 329, i2, 0);
                    if (n11 == -1) continue;
                    if (n11 + 1 > tCHAR.length()) {
                        tCHAR = new TCHAR(n12, n11 + 1);
                    }
                    if ((n13 = OS.SendMessage(this.handle, 328, i2, tCHAR)) == -1) continue;
                    OS.DrawText(n5, tCHAR, n11, rECT, n10);
                    n7 = Math.max(n7, rECT.right - rECT.left);
                }
            }
            if (n4 != 0) {
                OS.SelectObject(n5, n6);
            }
            OS.ReleaseDC(this.handle, n5);
        }
        if (n3 == -1 && (this.style & 0x40) != 0) {
            n4 = OS.SendMessage(this.handle, 326, 0, 0);
            n6 = OS.SendMessage(this.handle, 340, 0, 0);
            n8 = n4 * n6;
        }
        if (n7 == 0) {
            n7 = 64;
        }
        if (n8 == 0) {
            n8 = 64;
        }
        if (n2 != -1) {
            n7 = n2;
        }
        if (n3 != -1) {
            n8 = n3;
        }
        if ((this.style & 8) != 0) {
            n7 += 8;
        } else {
            n4 = OS.GetDlgItem(this.handle, 1001);
            if (n4 != 0) {
                n6 = OS.SendMessage(n4, 212, 0, 0);
                n5 = OS.LOWORD(n6) + OS.HIWORD(n6);
                n7 += n5 + 3;
            }
        }
        COMBOBOXINFO cOMBOBOXINFO = new COMBOBOXINFO();
        cOMBOBOXINFO.cbSize = COMBOBOXINFO.sizeof;
        if ((this.style & 0x40) == 0 && !OS.IsWinCE && OS.GetComboBoxInfo(this.handle, cOMBOBOXINFO)) {
            n7 += cOMBOBOXINFO.itemLeft + (cOMBOBOXINFO.buttonRight - cOMBOBOXINFO.buttonLeft);
            n8 = cOMBOBOXINFO.buttonBottom - cOMBOBOXINFO.buttonTop + cOMBOBOXINFO.buttonTop * 2;
        } else {
            n6 = OS.GetSystemMetrics(45);
            n7 += OS.GetSystemMetrics(2) + n6 * 2;
            n5 = OS.SendMessage(this.handle, 340, -1, 0);
            n8 = (this.style & 4) != 0 ? n5 + 6 : (n8 += n5 + 10);
        }
        if ((this.style & 0x40) != 0 && (this.style & 0x100) != 0) {
            n8 += OS.GetSystemMetrics(3);
        }
        return new Point(n7, n8);
    }

    public void copy() {
        this.checkWidget();
        OS.SendMessage(this.handle, 769, 0, 0);
    }

    @Override
    void createHandle() {
        int n2;
        int n3;
        int n4;
        if (OS.IsWinCE || (this.style & 0x48) != 0) {
            super.createHandle();
        } else {
            n4 = OS.GetCurrentThreadId();
            Callback callback = new Callback(this, "CBTProc", 3);
            n3 = callback.getAddress();
            if (n3 == 0) {
                this.error(3);
            }
            this.cbtHook = OS.SetWindowsHookEx(5, n3, 0, n4);
            super.createHandle();
            if (this.cbtHook != 0) {
                OS.UnhookWindowsHookEx(this.cbtHook);
            }
            this.cbtHook = 0;
            callback.dispose();
        }
        this.state &= 0xFFFFFEFD;
        n4 = OS.GetDlgItem(this.handle, 1001);
        if (n4 != 0 && EditProc == 0) {
            EditProc = OS.GetWindowLongPtr(n4, -4);
        }
        if ((n2 = OS.GetDlgItem(this.handle, 1000)) != 0 && ListProc == 0) {
            ListProc = OS.GetWindowLongPtr(n2, -4);
        }
        if ((this.style & 0x40) != 0) {
            n3 = 52;
            this.SetWindowPos(this.handle, 0, 0, 0, 16383, 16383, n3);
            this.SetWindowPos(this.handle, 0, 0, 0, 0, 0, n3);
        }
    }

    @Override
    void createWidget() {
        int n2;
        super.createWidget();
        this.visibleCount = 5;
        if ((this.style & 0x40) == 0 && (n2 = OS.SendMessage(this.handle, 340, 0, 0)) != -1 && n2 != 0) {
            int n3 = 0;
            if (OS.IsWinCE || OS.WIN32_VERSION < OS.VERSION(4, 10)) {
                RECT rECT = new RECT();
                OS.SystemParametersInfo(48, 0, rECT, 0);
                n3 = (rECT.bottom - rECT.top) / 3;
            } else {
                int n4 = OS.MonitorFromWindow(this.handle, 2);
                MONITORINFO mONITORINFO = new MONITORINFO();
                mONITORINFO.cbSize = MONITORINFO.sizeof;
                OS.GetMonitorInfo(n4, mONITORINFO);
                n3 = (mONITORINFO.rcWork_bottom - mONITORINFO.rcWork_top) / 3;
            }
            this.visibleCount = Math.max(this.visibleCount, n3 / n2);
        }
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        OS.SendMessage(this.handle, 768, 0, 0);
    }

    @Override
    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    TCHAR deprocessText(TCHAR tCHAR, int n2, int n3, boolean bl2) {
        char[] cArray;
        if (tCHAR == null || this.segments == null) {
            return tCHAR;
        }
        int n4 = tCHAR.length();
        if (n4 == 0) {
            return tCHAR;
        }
        int n5 = this.segments.length;
        if (n5 == 0) {
            return tCHAR;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (OS.IsUnicode) {
            cArray = tCHAR.chars;
            if (tCHAR.chars[n4 - 1] == '\u0000') {
                --n4;
            }
        } else {
            cArray = new char[n4];
            n4 = OS.MultiByteToWideChar(this.getCodePage(), 1, tCHAR.bytes, n4, cArray, n4);
        }
        if (n3 == -1) {
            n3 = n4;
        }
        if (n3 > this.segments[0] && n2 <= this.segments[n5 - 1]) {
            int n6 = 0;
            while (n2 - n6 > this.segments[n6]) {
                ++n6;
            }
            int n7 = n6;
            for (int i2 = n2; i2 < n3; ++i2) {
                if (n7 < n5 && i2 - n7 == this.segments[n7]) {
                    ++n7;
                    continue;
                }
                cArray[i2 - n7 + n6] = cArray[i2];
            }
            n4 = n3 - n2 - n7 + n6;
        }
        if (n2 != 0 || n3 != n4) {
            char[] cArray2 = new char[n4];
            System.arraycopy(cArray, n2, cArray2, 0, n4);
            return new TCHAR(this.getCodePage(), cArray2, bl2);
        }
        return tCHAR;
    }

    @Override
    void deregister() {
        int n2;
        super.deregister();
        int n3 = OS.GetDlgItem(this.handle, 1001);
        if (n3 != 0) {
            this.display.removeControl(n3);
        }
        if ((n2 = OS.GetDlgItem(this.handle, 1000)) != 0) {
            this.display.removeControl(n2);
        }
    }

    public void deselect(int n2) {
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 327, 0, 0);
        if (n2 != n3) {
            return;
        }
        OS.SendMessage(this.handle, 334, -1, 0);
        this.sendEvent(24);
        this.clearSegments(false);
        --this.clearSegmentsCount;
    }

    public void deselectAll() {
        this.checkWidget();
        OS.SendMessage(this.handle, 334, -1, 0);
        this.sendEvent(24);
        this.clearSegments(false);
        --this.clearSegmentsCount;
    }

    @Override
    boolean dragDetect(int n2, int n3, int n4, boolean bl2, boolean[] blArray, boolean[] blArray2) {
        int n5;
        if (bl2 && (this.style & 8) == 0 && (n5 = OS.GetDlgItem(this.handle, 1001)) != 0) {
            int n6;
            int n7;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.SendMessage(this.handle, 320, nArray, nArray2);
            if (nArray[0] != nArray2[0] && nArray[0] <= (n7 = OS.LOWORD(OS.SendMessage(n5, 215, 0, n6 = OS.MAKELPARAM(n3, n4)))) && n7 < nArray2[0] && super.dragDetect(n2, n3, n4, bl2, blArray, blArray2)) {
                if (blArray2 != null) {
                    blArray2[0] = true;
                }
                return true;
            }
            return false;
        }
        return super.dragDetect(n2, n3, n4, bl2, blArray, blArray2);
    }

    public Point getCaretLocation() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getCaretLocationInPixels());
    }

    Point getCaretLocationInPixels() {
        int n2 = this.translateOffset(this.getCaretPosition());
        int n3 = OS.GetDlgItem(this.handle, 1001);
        int n4 = OS.SendMessage(n3, 214, n2, 0);
        if (n4 == -1) {
            n4 = 0;
            if (n2 >= OS.GetWindowTextLength(n3)) {
                int n5 = this.getCodePage();
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                OS.SendMessage(n3, 176, nArray, nArray2);
                OS.SendMessage(n3, 177, n2, n2);
                this.ignoreModify = true;
                this.ignoreCharacter = true;
                OS.SendMessage(n3, 194, 0, new TCHAR(n5, " ", true));
                n4 = OS.SendMessage(n3, 214, n2, 0);
                OS.SendMessage(n3, 177, n2, n2 + 1);
                OS.SendMessage(n3, 194, 0, new TCHAR(n5, "", true));
                this.ignoreModify = false;
                this.ignoreCharacter = false;
                OS.SendMessage(n3, 177, nArray[0], nArray[0]);
                OS.SendMessage(n3, 177, nArray[0], nArray2[0]);
            }
        }
        POINT pOINT = new POINT();
        pOINT.x = OS.GET_X_LPARAM(n4);
        pOINT.y = OS.GET_Y_LPARAM(n4);
        OS.MapWindowPoints(n3, this.handle, pOINT, 1);
        return new Point(pOINT.x, pOINT.y);
    }

    public int getCaretPosition() {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n2 = OS.GetDlgItem(this.handle, 1001);
        OS.SendMessage(n2, 176, nArray, nArray2);
        int n3 = nArray[0];
        if (nArray[0] != nArray2[0] && !OS.IsWinCE) {
            POINT pOINT;
            int n4 = OS.GetWindowThreadProcessId(n2, null);
            GUITHREADINFO gUITHREADINFO = new GUITHREADINFO();
            gUITHREADINFO.cbSize = GUITHREADINFO.sizeof;
            if (OS.GetGUIThreadInfo(n4, gUITHREADINFO) && (gUITHREADINFO.hwndCaret == n2 || gUITHREADINFO.hwndCaret == 0) && OS.GetCaretPos(pOINT = new POINT())) {
                int n5 = OS.SendMessage(n2, 214, nArray2[0], 0);
                if (n5 == -1) {
                    int n6 = OS.SendMessage(n2, 214, nArray[0], 0);
                    int n7 = OS.GET_X_LPARAM(n6);
                    if (pOINT.x > n7) {
                        n3 = nArray2[0];
                    }
                } else {
                    int n8 = OS.GET_X_LPARAM(n5);
                    if (pOINT.x >= n8) {
                        n3 = nArray2[0];
                    }
                }
            }
        }
        if (!OS.IsUnicode && OS.IsDBLocale) {
            n3 = this.mbcsToWcsPos(n3);
        }
        return this.untranslateOffset(n3);
    }

    public String getItem(int n2) {
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 329, n2, 0);
        if (n3 != -1) {
            if (this.hooks(49) || this.filters(49) || (this.state & 0x400000) != 0) {
                return this.items[n2];
            }
            TCHAR tCHAR = new TCHAR(this.getCodePage(), n3 + 1);
            int n4 = OS.SendMessage(this.handle, 328, n2, tCHAR);
            if (n4 != -1) {
                return tCHAR.toString(0, n3);
            }
        }
        int n5 = OS.SendMessage(this.handle, 326, 0, 0);
        if (0 <= n2 && n2 < n5) {
            this.error(8);
        }
        this.error(6);
        return "";
    }

    public int getItemCount() {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 326, 0, 0);
        if (n2 == -1) {
            this.error(36);
        }
        return n2;
    }

    public int getItemHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getItemHeightInPixels());
    }

    int getItemHeightInPixels() {
        int n2 = OS.SendMessage(this.handle, 340, 0, 0);
        if (n2 == -1) {
            this.error(11);
        }
        return n2;
    }

    public String[] getItems() {
        this.checkWidget();
        int n2 = this.getItemCount();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = this.getItem(i2);
        }
        return stringArray;
    }

    public boolean getListVisible() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return OS.SendMessage(this.handle, 343, 0, 0) != 0;
        }
        return true;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public void setListVisible(boolean bl2) {
        this.checkWidget();
        OS.SendMessage(this.handle, 335, bl2 ? 1 : 0, 0);
    }

    @Override
    public int getOrientation() {
        return super.getOrientation();
    }

    Event getSegments(String string) {
        int n2;
        Event event = null;
        if (this.hooks(49) || this.filters(49)) {
            event = new Event();
            event.text = string;
            this.sendEvent(49, event);
            if (event != null && event.segments != null) {
                int n3;
                int n4 = event.segments.length;
                int n5 = n3 = string == null ? 0 : string.length();
                for (n2 = 1; n2 < n4; ++n2) {
                    if (event.segments[n2] >= event.segments[n2 - 1] && event.segments[n2] <= n3) continue;
                    SWT.error(5);
                }
            }
        }
        if ((this.state & 0x400000) != 0) {
            n2 = BidiUtil.resolveTextDirection(string);
            if (n2 == 0) {
                n2 = (this.style & 0x4000000) != 0 ? 0x4000000 : 0x2000000;
            }
            int[] nArray = null;
            char[] cArray = null;
            if (event == null) {
                event = new Event();
            } else {
                nArray = event.segments;
                cArray = event.segmentsChars;
            }
            int n6 = nArray == null ? 0 : nArray.length;
            event.segments = new int[n6 + 1];
            event.segmentsChars = new char[n6 + 1];
            if (nArray != null) {
                System.arraycopy(nArray, 0, event.segments, 1, n6);
            }
            if (cArray != null) {
                System.arraycopy(cArray, 0, event.segmentsChars, 1, n6);
            }
            event.segments[0] = 0;
            event.segmentsChars[0] = n2 == 0x4000000 ? 8235 : 8234;
        }
        return event;
    }

    String getSegmentsText(String string, Event event) {
        int n2;
        int n3;
        if (string == null || event == null) {
            return string;
        }
        int[] nArray = event.segments;
        if (nArray == null) {
            return string;
        }
        int n4 = nArray.length;
        if (n4 == 0) {
            return string;
        }
        char[] cArray = event.segmentsChars;
        int n5 = string.length();
        char[] cArray2 = new char[n5];
        string.getChars(0, n5, cArray2, 0);
        char[] cArray3 = new char[n5 + n4];
        int n6 = 0;
        int n7 = 0;
        int n8 = n3 = this.getOrientation() == 0x4000000 ? 8207 : 8206;
        while (n6 < n5) {
            if (n7 < n4 && n6 == nArray[n7]) {
                n2 = cArray != null && cArray.length > n7 ? cArray[n7] : n3;
                cArray3[n6 + n7++] = n2;
                continue;
            }
            cArray3[n6 + n7] = cArray2[n6++];
        }
        while (n7 < n4) {
            nArray[n7] = n6;
            n2 = cArray != null && cArray.length > n7 ? cArray[n7] : n3;
            cArray3[n6 + n7++] = n2;
        }
        return new String(cArray3, 0, cArray3.length);
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0 && (this.style & 8) != 0) {
            return new Point(0, OS.GetWindowTextLength(this.handle));
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(this.handle, 320, nArray, nArray2);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            nArray[0] = this.mbcsToWcsPos(nArray[0]);
            nArray2[0] = this.mbcsToWcsPos(nArray2[0]);
        }
        return new Point(this.untranslateOffset(nArray[0]), this.untranslateOffset(nArray2[0]));
    }

    public int getSelectionIndex() {
        this.checkWidget();
        if (this.noSelection) {
            return -1;
        }
        return OS.SendMessage(this.handle, 327, 0, 0);
    }

    public String getText() {
        this.checkWidget();
        int n2 = OS.GetWindowTextLength(this.handle);
        if (n2 == 0) {
            return "";
        }
        TCHAR tCHAR = new TCHAR(this.getCodePage(), n2 + 1);
        OS.GetWindowText(this.handle, tCHAR, n2 + 1);
        if (this.segments != null) {
            tCHAR = this.deprocessText(tCHAR, 0, -1, false);
            return tCHAR.toString();
        }
        return tCHAR.toString(0, n2);
    }

    public int getTextHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getTextHeightInPixels());
    }

    int getTextHeightInPixels() {
        COMBOBOXINFO cOMBOBOXINFO = new COMBOBOXINFO();
        cOMBOBOXINFO.cbSize = COMBOBOXINFO.sizeof;
        if ((this.style & 0x40) == 0 && !OS.IsWinCE && OS.GetComboBoxInfo(this.handle, cOMBOBOXINFO)) {
            return cOMBOBOXINFO.buttonBottom - cOMBOBOXINFO.buttonTop + cOMBOBOXINFO.buttonTop * 2;
        }
        int n2 = OS.SendMessage(this.handle, 340, -1, 0);
        if (n2 == -1) {
            this.error(11);
        }
        return (this.style & 4) != 0 ? n2 + 6 : n2 + 10;
    }

    public int getTextLimit() {
        this.checkWidget();
        int n2 = OS.GetDlgItem(this.handle, 1001);
        if (n2 == 0) {
            return LIMIT;
        }
        int n3 = OS.SendMessage(n2, 213, 0, 0) & Integer.MAX_VALUE;
        if (this.segments != null && n3 < LIMIT) {
            n3 = Math.max(1, n3 - this.segments.length);
        }
        return n3;
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleCount;
    }

    @Override
    boolean hasFocus() {
        int n2 = OS.GetFocus();
        if (n2 == this.handle) {
            return true;
        }
        if (n2 == 0) {
            return false;
        }
        int n3 = OS.GetDlgItem(this.handle, 1001);
        if (n2 == n3) {
            return true;
        }
        int n4 = OS.GetDlgItem(this.handle, 1000);
        return n2 == n4;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n2) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.length() == 0) {
            int n3 = this.getItemCount();
            for (int i2 = n2; i2 < n3; ++i2) {
                if (!string.equals(this.getItem(i2))) continue;
                return i2;
            }
            return -1;
        }
        int n4 = OS.SendMessage(this.handle, 326, 0, 0);
        if (0 > n2 || n2 >= n4) {
            return -1;
        }
        int n5 = n2 - 1;
        int n6 = 0;
        TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
        do {
            if ((n5 = OS.SendMessage(this.handle, 344, n6 = n5, tCHAR)) != -1 && n5 > n6) continue;
            return -1;
        } while (!string.equals(this.getItem(n5)));
        return n5;
    }

    int mbcsToWcsPos(int n2) {
        if (n2 <= 0) {
            return 0;
        }
        if (OS.IsUnicode) {
            return n2;
        }
        int n3 = OS.GetDlgItem(this.handle, 1001);
        if (n3 == 0) {
            return n2;
        }
        int n4 = OS.GetWindowTextLengthA(n3);
        if (n4 == 0) {
            return 0;
        }
        if (n2 >= n4) {
            return n4;
        }
        byte[] byArray = new byte[n4 + 1];
        OS.GetWindowTextA(n3, byArray, n4 + 1);
        return OS.MultiByteToWideChar(this.getCodePage(), 1, byArray, n2, null, 0);
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        OS.SendMessage(this.handle, 770, 0, 0);
    }

    @Override
    void register() {
        int n2;
        super.register();
        int n3 = OS.GetDlgItem(this.handle, 1001);
        if (n3 != 0) {
            this.display.addControl(n3, this);
        }
        if ((n2 = OS.GetDlgItem(this.handle, 1000)) != 0) {
            this.display.addControl(n2, this);
        }
    }

    public void remove(int n2) {
        this.checkWidget();
        this.remove(n2, true);
    }

    void remove(int n2, boolean bl2) {
        int n3;
        int n4;
        int n5;
        TCHAR tCHAR = null;
        if ((this.style & 0x100) != 0) {
            n5 = OS.SendMessage(this.handle, 329, n2, 0);
            if (n5 == -1) {
                n4 = OS.SendMessage(this.handle, 326, 0, 0);
                if (0 <= n2 && n2 < n4) {
                    this.error(15);
                }
                this.error(6);
            }
            if ((n4 = OS.SendMessage(this.handle, 328, n2, tCHAR = new TCHAR(this.getCodePage(), n5 + 1))) == -1) {
                n3 = OS.SendMessage(this.handle, 326, 0, 0);
                if (0 <= n2 && n2 < n3) {
                    this.error(15);
                }
                this.error(6);
            }
        }
        n5 = OS.GetWindowTextLength(this.handle);
        n4 = OS.SendMessage(this.handle, 324, n2, 0);
        if (n4 == -1) {
            n3 = OS.SendMessage(this.handle, 326, 0, 0);
            if (0 <= n2 && n2 < n3) {
                this.error(15);
            }
            this.error(6);
        } else if (n4 == 0) {
            OS.SendMessage(this.handle, 331, 0, 0);
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(tCHAR, true);
        }
        if (bl2 && n5 != OS.GetWindowTextLength(this.handle)) {
            this.sendEvent(24);
            if (this.isDisposed()) {
                return;
            }
        }
    }

    public void remove(int n2, int n3) {
        this.checkWidget();
        if (n2 > n3) {
            return;
        }
        int n4 = OS.SendMessage(this.handle, 326, 0, 0);
        if (0 > n2 || n2 > n3 || n3 >= n4) {
            this.error(6);
        }
        int n5 = OS.GetWindowTextLength(this.handle);
        RECT rECT = null;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if ((this.style & 0x100) != 0) {
            rECT = new RECT();
            n6 = OS.GetDC(this.handle);
            n8 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n8 != 0) {
                n7 = OS.SelectObject(n6, n8);
            }
        }
        int n10 = this.getCodePage();
        int n11 = 3104;
        for (int i2 = n2; i2 <= n3; ++i2) {
            int n12;
            int n13;
            TCHAR tCHAR = null;
            if ((this.style & 0x100) != 0 && ((n13 = OS.SendMessage(this.handle, 329, n2, 0)) == -1 || (n12 = OS.SendMessage(this.handle, 328, n2, tCHAR = new TCHAR(n10, n13 + 1))) == -1)) break;
            n13 = OS.SendMessage(this.handle, 324, n2, 0);
            if (n13 == -1) {
                this.error(15);
            } else if (n13 == 0) {
                OS.SendMessage(this.handle, 331, 0, 0);
            }
            if ((this.style & 0x100) == 0) continue;
            OS.DrawText(n6, tCHAR, -1, rECT, n11);
            n9 = Math.max(n9, rECT.right - rECT.left);
        }
        if ((this.style & 0x100) != 0) {
            if (n8 != 0) {
                OS.SelectObject(n6, n7);
            }
            OS.ReleaseDC(this.handle, n6);
            this.setScrollWidth(n9, false);
        }
        if (n5 != OS.GetWindowTextLength(this.handle)) {
            this.sendEvent(24);
            if (this.isDisposed()) {
                return;
            }
        }
    }

    public void remove(String string) {
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n2 = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(n2);
    }

    public void removeAll() {
        this.checkWidget();
        OS.SendMessage(this.handle, 331, 0, 0);
        this.sendEvent(24);
        if (this.isDisposed()) {
            return;
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(0);
        }
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSegmentListener(SegmentListener segmentListener) {
        this.checkWidget();
        if (segmentListener == null) {
            this.error(4);
        }
        this.eventTable.unhook(49, segmentListener);
        int n2 = -1;
        if (!this.noSelection) {
            n2 = OS.SendMessage(this.handle, 327, 0, 0);
        }
        this.clearSegments(true);
        this.applyEditSegments();
        this.applyListSegments();
        if (n2 != -1) {
            OS.SendMessage(this.handle, 334, n2, 0);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    @Override
    boolean sendKeyEvent(int n2, int n3, int n4, int n5, Event event) {
        Object object;
        Object object2;
        if (!super.sendKeyEvent(n2, n3, n4, n5, event)) {
            return false;
        }
        if ((this.style & 8) != 0) {
            return true;
        }
        if (n2 != 1) {
            return true;
        }
        if (n3 != 258 && n3 != 256 && n3 != 646) {
            return true;
        }
        if (event.character == '\u0000') {
            return true;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return true;
        }
        char c2 = event.character;
        int n6 = event.stateMask;
        switch (n3) {
            case 258: {
                if (c2 != '\b' && c2 != '\u007f' && c2 != '\r' && c2 != '\t' && c2 != '\n') break;
            }
            case 256: {
                if ((n6 & 0x70000) == 0) break;
                return false;
            }
        }
        if (OS.GetKeyState(1) < 0 && OS.GetDlgItem(this.handle, 1001) == OS.GetCapture()) {
            return true;
        }
        String string = "";
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n7 = OS.GetDlgItem(this.handle, 1001);
        if (n7 == 0) {
            return true;
        }
        OS.SendMessage(n7, 176, nArray, nArray2);
        switch (c2) {
            case '\b': {
                if (nArray[0] != nArray2[0]) break;
                if (nArray[0] == 0) {
                    return true;
                }
                nArray[0] = nArray[0] - 1;
                if (!OS.IsUnicode && OS.IsDBLocale) {
                    object2 = new int[1];
                    object = new int[1];
                    OS.SendMessage(n7, 177, nArray[0], nArray2[0]);
                    OS.SendMessage(n7, 176, (int[])object2, object);
                    if (nArray[0] != object2[0]) {
                        nArray[0] = nArray[0] - 1;
                    }
                }
                nArray[0] = Math.max(nArray[0], 0);
                break;
            }
            case '\u007f': {
                if (nArray[0] != nArray2[0]) break;
                int n8 = OS.GetWindowTextLength(n7);
                if (nArray[0] == n8) {
                    return true;
                }
                nArray2[0] = nArray2[0] + 1;
                if (!OS.IsUnicode && OS.IsDBLocale) {
                    object = new int[1];
                    int[] nArray3 = new int[1];
                    OS.SendMessage(n7, 177, nArray[0], nArray2[0]);
                    OS.SendMessage(n7, 176, object, nArray3);
                    if (nArray2[0] != nArray3[0]) {
                        nArray2[0] = nArray2[0] + 1;
                    }
                }
                nArray2[0] = Math.min(nArray2[0], n8);
                break;
            }
            case '\r': {
                return true;
            }
            default: {
                if (c2 != '\t' && c2 < ' ') {
                    return true;
                }
                string = new String(new char[]{c2});
            }
        }
        if ((object2 = this.verifyText(string, nArray[0], nArray2[0], event)) == null) {
            return false;
        }
        if (object2 == string) {
            return true;
        }
        object = new TCHAR(this.getCodePage(), (String)object2, true);
        OS.SendMessage(n7, 177, nArray[0], nArray2[0]);
        OS.SendMessage(n7, 194, 0, (TCHAR)object);
        return false;
    }

    public void select(int n2) {
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 326, 0, 0);
        if (0 <= n2 && n2 < n3) {
            int n4 = OS.SendMessage(this.handle, 327, 0, 0);
            if (!OS.IsWinCE && OS.WIN32_VERSION < OS.VERSION(6, 2) && this.getListVisible() && (this.style & 8) != 0 && n3 == 1 && n4 == -1) {
                OS.SendMessage(this.handle, 256, 40, 0);
                this.sendEvent(24);
                return;
            }
            int n5 = OS.SendMessage(this.handle, 334, n2, 0);
            if (n5 != -1 && n5 != n4) {
                if (!OS.IsWinCE && OS.WIN32_VERSION < OS.VERSION(6, 2) && this.getListVisible() && (this.style & 8) != 0) {
                    int n6 = 38;
                    int n7 = 40;
                    if (n2 == 0) {
                        n6 = 40;
                        n7 = 38;
                    }
                    OS.SendMessage(this.handle, 256, n6, 0);
                    OS.SendMessage(this.handle, 256, n7, 0);
                }
                this.sendEvent(24);
            }
        }
    }

    @Override
    void setBackgroundImage(int n2) {
        int n3;
        super.setBackgroundImage(n2);
        int n4 = OS.GetDlgItem(this.handle, 1001);
        if (n4 != 0) {
            OS.InvalidateRect(n4, null, true);
        }
        if ((n3 = OS.GetDlgItem(this.handle, 1000)) != 0) {
            OS.InvalidateRect(n3, null, true);
        }
    }

    @Override
    void setBackgroundPixel(int n2) {
        int n3;
        super.setBackgroundPixel(n2);
        int n4 = OS.GetDlgItem(this.handle, 1001);
        if (n4 != 0) {
            OS.InvalidateRect(n4, null, true);
        }
        if ((n3 = OS.GetDlgItem(this.handle, 1000)) != 0) {
            OS.InvalidateRect(n3, null, true);
        }
    }

    @Override
    void setBoundsInPixels(int n2, int n3, int n4, int n5, int n6) {
        if ((this.style & 4) != 0) {
            int n7 = this.getItemCount() == 0 ? 5 : this.visibleCount;
            n5 = this.getTextHeightInPixels() + this.getItemHeightInPixels() * n7 + 2;
            RECT rECT = new RECT();
            OS.GetWindowRect(this.handle, rECT);
            if (rECT.right - rECT.left != 0 && OS.SendMessage(this.handle, 338, 0, rECT) != 0) {
                int n8 = rECT.right - rECT.left;
                int n9 = rECT.bottom - rECT.top;
                if (n8 == n4 && n9 == n5) {
                    n6 |= 1;
                }
            }
            this.SetWindowPos(this.handle, 0, n2, n3, n4, n5, n6);
        } else {
            super.setBoundsInPixels(n2, n3, n4, n5, n6);
        }
    }

    @Override
    public void setFont(Font font) {
        this.checkWidget();
        boolean bl2 = this.lockText;
        if ((this.style & 8) == 0) {
            this.lockText = true;
        }
        super.setFont(font);
        if ((this.style & 8) == 0) {
            this.lockText = bl2;
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth();
        }
    }

    @Override
    void setForegroundPixel(int n2) {
        int n3;
        super.setForegroundPixel(n2);
        int n4 = OS.GetDlgItem(this.handle, 1001);
        if (n4 != 0) {
            OS.InvalidateRect(n4, null, true);
        }
        if ((n3 = OS.GetDlgItem(this.handle, 1000)) != 0) {
            OS.InvalidateRect(n3, null, true);
        }
    }

    public void setItem(int n2, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n3 = this.getSelectionIndex();
        this.remove(n2, false);
        if (this.isDisposed()) {
            return;
        }
        this.add(string, n2);
        if (n3 != -1) {
            this.select(n3);
        }
    }

    public void setItems(String ... stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2] != null) continue;
            this.error(5);
        }
        RECT rECT = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if ((this.style & 0x100) != 0) {
            rECT = new RECT();
            n2 = OS.GetDC(this.handle);
            n4 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n4 != 0) {
                n3 = OS.SelectObject(n2, n4);
            }
            this.setScrollWidth(0);
        }
        OS.SendMessage(this.handle, 331, 0, 0);
        int n6 = this.getCodePage();
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            String string = stringArray[i3];
            TCHAR tCHAR = new TCHAR(n6, string, true);
            int n7 = OS.SendMessage(this.handle, 323, 0, tCHAR);
            if (n7 == -1) {
                this.error(14);
            }
            if (n7 == -2) {
                this.error(14);
            }
            if ((this.style & 0x100) == 0) continue;
            int n8 = 3104;
            OS.DrawText(n2, tCHAR, -1, rECT, n8);
            n5 = Math.max(n5, rECT.right - rECT.left);
        }
        if ((this.style & 0x100) != 0) {
            if (n4 != 0) {
                OS.SelectObject(n2, n3);
            }
            OS.ReleaseDC(this.handle, n2);
            this.setScrollWidth(n5 + 3);
        }
        this.sendEvent(24);
    }

    @Override
    public void setOrientation(int n2) {
        super.setOrientation(n2);
    }

    void setScrollWidth() {
        int n2 = 0;
        RECT rECT = new RECT();
        int n3 = 0;
        int n4 = OS.GetDC(this.handle);
        int n5 = OS.SendMessage(this.handle, 49, 0, 0);
        if (n5 != 0) {
            n3 = OS.SelectObject(n4, n5);
        }
        int n6 = this.getCodePage();
        int n7 = OS.SendMessage(this.handle, 326, 0, 0);
        int n8 = 3104;
        for (int i2 = 0; i2 < n7; ++i2) {
            TCHAR tCHAR;
            int n9;
            int n10 = OS.SendMessage(this.handle, 329, i2, 0);
            if (n10 == -1 || (n9 = OS.SendMessage(this.handle, 328, i2, tCHAR = new TCHAR(n6, n10 + 1))) == -1) continue;
            OS.DrawText(n4, tCHAR, -1, rECT, n8);
            n2 = Math.max(n2, rECT.right - rECT.left);
        }
        if (n5 != 0) {
            OS.SelectObject(n4, n3);
        }
        OS.ReleaseDC(this.handle, n4);
        this.setScrollWidth(n2 + 3);
    }

    void setScrollWidth(int n2) {
        int n3;
        this.scrollWidth = n2;
        if ((this.style & 0x40) != 0) {
            OS.SendMessage(this.handle, 350, n2, 0);
            return;
        }
        boolean bl2 = false;
        int n4 = OS.SendMessage(this.handle, 326, 0, 0);
        if (n4 > 3) {
            n3 = 0;
            if (OS.IsWinCE || OS.WIN32_VERSION < OS.VERSION(4, 10)) {
                RECT rECT = new RECT();
                OS.SystemParametersInfo(48, 0, rECT, 0);
                n3 = (rECT.right - rECT.left) / 4;
            } else {
                int n5 = OS.MonitorFromWindow(this.handle, 2);
                MONITORINFO mONITORINFO = new MONITORINFO();
                mONITORINFO.cbSize = MONITORINFO.sizeof;
                OS.GetMonitorInfo(n5, mONITORINFO);
                n3 = (mONITORINFO.rcWork_right - mONITORINFO.rcWork_left) / 4;
            }
            bl2 = n2 > n3;
        }
        n3 = this.lockText;
        if ((this.style & 8) == 0) {
            this.lockText = true;
        }
        if (bl2) {
            OS.SendMessage(this.handle, 352, 0, 0);
            OS.SendMessage(this.handle, 350, n2, 0);
        } else {
            OS.SendMessage(this.handle, 352, n2 += OS.GetSystemMetrics(3), 0);
            OS.SendMessage(this.handle, 350, 0, 0);
        }
        if ((this.style & 8) == 0) {
            this.lockText = n3;
        }
    }

    void setScrollWidth(TCHAR tCHAR, boolean bl2) {
        RECT rECT = new RECT();
        int n2 = 0;
        int n3 = OS.GetDC(this.handle);
        int n4 = OS.SendMessage(this.handle, 49, 0, 0);
        if (n4 != 0) {
            n2 = OS.SelectObject(n3, n4);
        }
        int n5 = 3104;
        OS.DrawText(n3, tCHAR, -1, rECT, n5);
        if (n4 != 0) {
            OS.SelectObject(n3, n2);
        }
        OS.ReleaseDC(this.handle, n3);
        this.setScrollWidth(rECT.right - rECT.left, bl2);
    }

    void setScrollWidth(int n2, boolean bl2) {
        if (bl2) {
            if (n2 <= this.scrollWidth) {
                return;
            }
            this.setScrollWidth(n2 + 3);
        } else {
            if (n2 < this.scrollWidth) {
                return;
            }
            this.setScrollWidth();
        }
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int n2 = this.translateOffset(point.x);
        int n3 = this.translateOffset(point.y);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            n2 = this.wcsToMbcsPos(n2);
            n3 = this.wcsToMbcsPos(n3);
        }
        int n4 = OS.MAKELPARAM(n2, n3);
        OS.SendMessage(this.handle, 322, 0, n4);
    }

    public void setText(String string) {
        TCHAR tCHAR;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            int n2 = this.indexOf(string);
            if (n2 != -1) {
                this.select(n2);
            }
            return;
        }
        this.clearSegments(false);
        int n3 = LIMIT;
        int n4 = OS.GetDlgItem(this.handle, 1001);
        if (n4 != 0) {
            n3 = OS.SendMessage(n4, 213, 0, 0) & Integer.MAX_VALUE;
        }
        if (string.length() > n3) {
            string = string.substring(0, n3);
        }
        if (OS.SetWindowText(this.handle, tCHAR = new TCHAR(this.getCodePage(), string, true))) {
            this.applyEditSegments();
            this.sendEvent(24);
        }
    }

    public void setTextLimit(int n2) {
        this.checkWidget();
        if (n2 == 0) {
            this.error(7);
        }
        if (this.segments != null && n2 > 0) {
            OS.SendMessage(this.handle, 321, n2 + Math.min(this.segments.length, LIMIT - n2), 0);
        } else {
            OS.SendMessage(this.handle, 321, n2, 0);
        }
    }

    @Override
    void setToolTipText(Shell shell, String string) {
        int n2 = OS.GetDlgItem(this.handle, 1001);
        int n3 = OS.GetDlgItem(this.handle, 1000);
        if (n2 != 0) {
            shell.setToolTipText(n2, string);
        }
        if (n3 != 0) {
            shell.setToolTipText(n3, string);
        }
        shell.setToolTipText(this.handle, string);
    }

    public void setVisibleItemCount(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        this.visibleCount = n2;
        this.updateDropDownHeight();
    }

    @Override
    void subclass() {
        int n2;
        super.subclass();
        int n3 = this.display.windowProc;
        int n4 = OS.GetDlgItem(this.handle, 1001);
        if (n4 != 0) {
            OS.SetWindowLongPtr(n4, -4, n3);
        }
        if ((n2 = OS.GetDlgItem(this.handle, 1000)) != 0) {
            OS.SetWindowLongPtr(n2, -4, n3);
        }
    }

    int translateOffset(int n2) {
        if (this.segments == null) {
            return n2;
        }
        int n3 = this.segments.length;
        for (int i2 = 0; i2 < n3 && n2 - i2 >= this.segments[i2]; ++i2) {
            ++n2;
        }
        return n2;
    }

    @Override
    boolean translateTraversal(MSG mSG) {
        switch (mSG.wParam) {
            case 13: 
            case 27: {
                if ((this.style & 4) == 0 || OS.SendMessage(this.handle, 343, 0, 0) == 0) break;
                return false;
            }
        }
        return super.translateTraversal(mSG);
    }

    @Override
    boolean traverseEscape() {
        if ((this.style & 4) != 0 && OS.SendMessage(this.handle, 343, 0, 0) != 0) {
            OS.SendMessage(this.handle, 335, 0, 0);
            return true;
        }
        return super.traverseEscape();
    }

    @Override
    boolean traverseReturn() {
        if ((this.style & 4) != 0 && OS.SendMessage(this.handle, 343, 0, 0) != 0) {
            OS.SendMessage(this.handle, 335, 0, 0);
            return true;
        }
        return super.traverseReturn();
    }

    @Override
    void unsubclass() {
        int n2;
        super.unsubclass();
        int n3 = OS.GetDlgItem(this.handle, 1001);
        if (n3 != 0 && EditProc != 0) {
            OS.SetWindowLongPtr(n3, -4, EditProc);
        }
        if ((n2 = OS.GetDlgItem(this.handle, 1000)) != 0 && ListProc != 0) {
            OS.SetWindowLongPtr(n2, -4, ListProc);
        }
    }

    int untranslateOffset(int n2) {
        if (this.segments == null) {
            return n2;
        }
        int n3 = this.segments.length;
        for (int i2 = 0; i2 < n3 && n2 > this.segments[i2]; --n2, ++i2) {
        }
        return n2;
    }

    void updateDropDownHeight() {
        if ((this.style & 4) != 0) {
            RECT rECT = new RECT();
            OS.SendMessage(this.handle, 338, 0, rECT);
            int n2 = this.getItemCount() == 0 ? 5 : this.visibleCount;
            int n3 = this.getTextHeightInPixels() + this.getItemHeightInPixels() * n2 + 2;
            if (n3 != rECT.bottom - rECT.top) {
                this.forceResize();
                OS.GetWindowRect(this.handle, rECT);
                int n4 = 54;
                this.SetWindowPos(this.handle, 0, 0, 0, rECT.right - rECT.left, n3, n4);
            }
        }
    }

    @Override
    boolean updateTextDirection(int n2) {
        if (super.updateTextDirection(n2)) {
            if (n2 == 0x6000000 && !OS.IsUnicode) {
                this.state &= 0xFFBFFFFF;
                return false;
            }
            this.clearSegments(true);
            this.applyEditSegments();
            this.applyListSegments();
            return true;
        }
        return false;
    }

    @Override
    void updateOrientation() {
        int n2;
        int n3 = OS.GetWindowLong(this.handle, -20);
        n3 = (this.style & 0x4000000) != 0 ? (n3 |= 0x400000) : (n3 &= 0xFFBFFFFF);
        OS.SetWindowLong(this.handle, -20, n3 &= 0xFFFFDFFF);
        int n4 = 0;
        int n5 = 0;
        COMBOBOXINFO cOMBOBOXINFO = new COMBOBOXINFO();
        cOMBOBOXINFO.cbSize = COMBOBOXINFO.sizeof;
        if (OS.GetComboBoxInfo(this.handle, cOMBOBOXINFO)) {
            n4 = cOMBOBOXINFO.hwndItem;
            n5 = cOMBOBOXINFO.hwndList;
        }
        if (n4 != 0) {
            n2 = OS.GetWindowLong(n4, -20);
            int n6 = OS.GetWindowLong(n4, -16);
            if ((this.style & 0x4000000) != 0) {
                n2 |= 0x3000;
                n6 |= 2;
            } else {
                n2 &= 0xFFFFCFFF;
                n6 &= 0xFFFFFFFD;
            }
            OS.SetWindowLong(n4, -20, n2);
            OS.SetWindowLong(n4, -16, n6);
            RECT rECT = new RECT();
            OS.GetWindowRect(n4, rECT);
            int n7 = rECT.right - rECT.left;
            int n8 = rECT.bottom - rECT.top;
            OS.GetWindowRect(this.handle, rECT);
            int n9 = rECT.right - rECT.left;
            int n10 = rECT.bottom - rECT.top;
            int n11 = 22;
            this.SetWindowPos(n4, 0, 0, 0, n7 - 1, n8 - 1, n11);
            this.SetWindowPos(this.handle, 0, 0, 0, n9 - 1, n10 - 1, n11);
            this.SetWindowPos(n4, 0, 0, 0, n7, n8, n11);
            this.SetWindowPos(this.handle, 0, 0, 0, n9, n10, n11);
            OS.InvalidateRect(this.handle, null, true);
        }
        if (n5 != 0) {
            n2 = OS.GetWindowLong(n5, -20);
            n2 = (this.style & 0x4000000) != 0 ? (n2 |= 0x400000) : (n2 &= 0xFFBFFFFF);
            OS.SetWindowLong(n5, -20, n2);
        }
    }

    String verifyText(String string, int n2, int n3, Event event) {
        Event event2 = new Event();
        event2.text = string;
        event2.start = n2;
        event2.end = n3;
        if (event != null) {
            event2.character = event.character;
            event2.keyCode = event.keyCode;
            event2.stateMask = event.stateMask;
        }
        if (!OS.IsUnicode && OS.IsDBLocale) {
            event2.start = this.mbcsToWcsPos(n2);
            event2.end = this.mbcsToWcsPos(n3);
        }
        event2.start = this.untranslateOffset(event2.start);
        event2.end = this.untranslateOffset(event2.end);
        this.sendEvent(25, event2);
        if (!event2.doit || this.isDisposed()) {
            return null;
        }
        return event2.text;
    }

    int wcsToMbcsPos(int n2) {
        if (n2 <= 0) {
            return 0;
        }
        if (OS.IsUnicode) {
            return n2;
        }
        int n3 = OS.GetDlgItem(this.handle, 1001);
        if (n3 == 0) {
            return n2;
        }
        int n4 = OS.GetWindowTextLengthA(n3);
        if (n4 == 0) {
            return 0;
        }
        byte[] byArray = new byte[n4 + 1];
        OS.GetWindowTextA(n3, byArray, n4 + 1);
        int n5 = 0;
        for (int i2 = 0; n5 < n4 && n2 != i2; ++i2) {
            if (!OS.IsDBCSLeadByte(byArray[n5++])) continue;
            ++n5;
        }
        return n5;
    }

    @Override
    int widgetExtStyle() {
        return super.widgetExtStyle() & 0xFFEFFFFF;
    }

    @Override
    int widgetStyle() {
        int n2 = super.widgetStyle() | 0x40 | 0x400 | 0x100000 | 0x200000;
        if ((this.style & 0x40) != 0) {
            return n2 | 1;
        }
        if ((this.style & 8) != 0) {
            return n2 | 3;
        }
        return n2 | 2;
    }

    @Override
    TCHAR windowClass() {
        return ComboClass;
    }

    @Override
    int windowProc() {
        return ComboProc;
    }

    @Override
    int windowProc(int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        if (this.handle == 0) {
            return 0;
        }
        if (n2 != this.handle) {
            n7 = OS.GetDlgItem(this.handle, 1001);
            n6 = OS.GetDlgItem(this.handle, 1000);
            if (n7 != 0 && n2 == n7 || n6 != 0 && n2 == n6) {
                LRESULT lRESULT = null;
                boolean bl2 = false;
                boolean bl3 = false;
                switch (n3) {
                    case 258: {
                        bl2 = (this.hooks(49) || this.filters(49) || (this.state & 0x400000) != 0) && !this.ignoreCharacter && OS.GetKeyState(17) >= 0 && OS.GetKeyState(18) >= 0;
                        lRESULT = this.wmChar(n2, n4, n5);
                        break;
                    }
                    case 646: {
                        lRESULT = this.wmIMEChar(n2, n4, n5);
                        break;
                    }
                    case 256: {
                        bl2 = n4 == 46 && (this.hooks(49) || this.filters(49) || (this.state & 0x400000) != 0);
                        lRESULT = this.wmKeyDown(n2, n4, n5);
                        break;
                    }
                    case 257: {
                        lRESULT = this.wmKeyUp(n2, n4, n5);
                        break;
                    }
                    case 262: {
                        lRESULT = this.wmSysChar(n2, n4, n5);
                        break;
                    }
                    case 260: {
                        lRESULT = this.wmSysKeyDown(n2, n4, n5);
                        break;
                    }
                    case 261: {
                        lRESULT = this.wmSysKeyUp(n2, n4, n5);
                        break;
                    }
                    case 533: {
                        lRESULT = this.wmCaptureChanged(n2, n4, n5);
                        break;
                    }
                    case 515: {
                        lRESULT = this.wmLButtonDblClk(n2, n4, n5);
                        break;
                    }
                    case 513: {
                        lRESULT = this.wmLButtonDown(n2, n4, n5);
                        break;
                    }
                    case 514: {
                        lRESULT = this.wmLButtonUp(n2, n4, n5);
                        break;
                    }
                    case 521: {
                        lRESULT = this.wmMButtonDblClk(n2, n4, n5);
                        break;
                    }
                    case 519: {
                        lRESULT = this.wmMButtonDown(n2, n4, n5);
                        break;
                    }
                    case 520: {
                        lRESULT = this.wmMButtonUp(n2, n4, n5);
                        break;
                    }
                    case 673: {
                        lRESULT = this.wmMouseHover(n2, n4, n5);
                        break;
                    }
                    case 675: {
                        lRESULT = this.wmMouseLeave(n2, n4, n5);
                        break;
                    }
                    case 512: {
                        lRESULT = this.wmMouseMove(n2, n4, n5);
                        break;
                    }
                    case 518: {
                        lRESULT = this.wmRButtonDblClk(n2, n4, n5);
                        break;
                    }
                    case 516: {
                        lRESULT = this.wmRButtonDown(n2, n4, n5);
                        break;
                    }
                    case 517: {
                        lRESULT = this.wmRButtonUp(n2, n4, n5);
                        break;
                    }
                    case 525: {
                        lRESULT = this.wmXButtonDblClk(n2, n4, n5);
                        break;
                    }
                    case 523: {
                        lRESULT = this.wmXButtonDown(n2, n4, n5);
                        break;
                    }
                    case 524: {
                        lRESULT = this.wmXButtonUp(n2, n4, n5);
                        break;
                    }
                    case 15: {
                        lRESULT = this.wmPaint(n2, n4, n5);
                        break;
                    }
                    case 123: {
                        lRESULT = this.wmContextMenu(n2, n4, n5);
                        break;
                    }
                    case 198: {
                        if (!this.hooks(49) && !this.filters(49) && (this.state & 0x400000) == 0) break;
                        return 0;
                    }
                    case 199: 
                    case 772: {
                        if (this.hooks(49) || this.filters(49) || (this.state & 0x400000) != 0) {
                            return 0;
                        }
                    }
                    case 768: 
                    case 769: 
                    case 770: 
                    case 771: {
                        bl2 = this.hooks(49) || this.filters(49) || (this.state & 0x400000) != 0;
                    }
                    case 12: {
                        if (n2 != n7) break;
                        lRESULT = this.wmClipboard(n2, n3, n4, n5);
                    }
                }
                if (lRESULT != null) {
                    return lRESULT.value;
                }
                if (bl2) {
                    if (this.getDrawing() && OS.IsWindowVisible(n7)) {
                        bl3 = true;
                        OS.DefWindowProc(n7, 11, 0, 0);
                    }
                    this.clearSegments(true);
                    int n8 = this.callWindowProc(n2, n3, n4, n5);
                    this.applyEditSegments();
                    if (bl3) {
                        OS.DefWindowProc(n7, 11, 1, 0);
                        OS.InvalidateRect(n7, null, true);
                    }
                    return n8;
                }
                return this.callWindowProc(n2, n3, n4, n5);
            }
        }
        switch (n3) {
            case 334: {
                Object object;
                n7 = -1;
                n6 = n4;
                if ((this.style & 8) != 0 && (this.hooks(25) || this.filters(25))) {
                    object = this.getText();
                    String string = null;
                    if (n4 == -1) {
                        string = "";
                    } else if (0 <= n4 && n4 < this.getItemCount()) {
                        string = this.getItem(n4);
                    }
                    if (string != null && !string.equals(object)) {
                        int n9 = OS.GetWindowTextLength(this.handle);
                        object = string;
                        if ((string = this.verifyText(string, 0, n9, null)) == null) {
                            return 0;
                        }
                        if (!string.equals(object) && (n6 = this.indexOf(string)) != -1 && n6 != n4) {
                            return this.callWindowProc(this.handle, 334, n6, n5);
                        }
                    }
                }
                if (!this.hooks(49) && !this.filters(49) && (this.state & 0x400000) == 0 || (n7 = super.windowProc(n2, n3, n4, n5)) == -1 || n7 == -2) break;
                object = this.getSegments(this.items[n6]);
                int[] nArray = this.segments = object != null ? ((Event)object).segments : null;
                if (((Event)object).segmentsChars != null) {
                    int n10 = this.state & 0x400000;
                    if (((Event)object).segmentsChars[0] == '\u202b') {
                        super.updateTextDirection(0x4000000);
                    } else if (((Event)object).segmentsChars[0] == '\u202a') {
                        super.updateTextDirection(0x2000000);
                    }
                    this.state |= n10;
                }
                return n7;
            }
            case 323: 
            case 330: 
            case 344: {
                int n11;
                if (n5 == 0 || !this.hooks(49) && !this.filters(49) && (this.state & 0x400000) == 0) break;
                n7 = -1;
                n6 = OS.IsUnicode ? OS.wcslen(n5) : OS.strlen(n5);
                TCHAR tCHAR = new TCHAR(this.getCodePage(), n6);
                OS.MoveMemory(tCHAR, n5, tCHAR.length() * TCHAR.sizeof);
                String string = tCHAR.toString(0, n6);
                Event event = this.getSegments(string);
                if (event != null && event.segments != null) {
                    tCHAR = new TCHAR(this.getCodePage(), this.getSegmentsText(string, event), true);
                    n11 = OS.GetProcessHeap();
                    n6 = tCHAR.length() * TCHAR.sizeof;
                    int n12 = OS.HeapAlloc(n11, 8, n6);
                    OS.MoveMemory(n12, tCHAR, n6);
                    n7 = super.windowProc(n2, n3, n4, n12);
                    OS.HeapFree(n11, 0, n12);
                }
                if (n3 == 323 || n3 == 330) {
                    n11 = n3 == 323 ? this.items.length : n4;
                    String[] stringArray = new String[this.items.length + 1];
                    System.arraycopy(this.items, 0, stringArray, 0, n11);
                    stringArray[n11] = string;
                    System.arraycopy(this.items, n11, stringArray, n11 + 1, this.items.length - n11);
                    this.items = stringArray;
                }
                if (n7 == -1 || n7 == -2) break;
                return n7;
            }
            case 324: {
                if (!this.hooks(49) && !this.filters(49) && (this.state & 0x400000) == 0) break;
                n7 = super.windowProc(n2, n3, n4, n5);
                if (n7 != -1 && n7 != -2) {
                    n6 = n4;
                    if (this.items.length == 1) {
                        this.items = new String[0];
                    } else if (this.items.length > 1) {
                        String[] stringArray = new String[this.items.length - 1];
                        System.arraycopy(this.items, 0, stringArray, 0, n6);
                        System.arraycopy(this.items, n6 + 1, stringArray, n6, this.items.length - n6 - 1);
                        this.items = stringArray;
                    }
                    if (!this.noSelection && (n6 = OS.SendMessage(this.handle, 327, 0, 0)) == n4) {
                        this.clearSegments(false);
                        this.applyEditSegments();
                    }
                }
                return n7;
            }
            case 331: {
                if (!this.hooks(49) && !this.filters(49) && (this.state & 0x400000) == 0) break;
                if (this.items.length > 0) {
                    this.items = new String[0];
                }
                this.clearSegments(false);
                this.applyEditSegments();
            }
        }
        return super.windowProc(n2, n3, n4, n5);
    }

    @Override
    LRESULT WM_CTLCOLOR(int n2, int n3) {
        return this.wmColorChild(n2, n3);
    }

    @Override
    LRESULT WM_GETDLGCODE(int n2, int n3) {
        int n4 = this.callWindowProc(this.handle, 135, n2, n3);
        return new LRESULT(n4 | 1);
    }

    @Override
    LRESULT WM_KILLFOCUS(int n2, int n3) {
        if ((this.style & 8) != 0) {
            return super.WM_KILLFOCUS(n2, n3);
        }
        return null;
    }

    @Override
    LRESULT WM_LBUTTONDOWN(int n2, int n3) {
        int n4;
        int n5 = OS.SendMessage(this.handle, 327, 0, 0);
        LRESULT lRESULT = super.WM_LBUTTONDOWN(n2, n3);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        if ((this.style & 8) == 0 && n5 != (n4 = OS.SendMessage(this.handle, 327, 0, 0))) {
            this.sendEvent(24);
            if (this.isDisposed()) {
                return LRESULT.ZERO;
            }
            this.sendSelectionEvent(13, null, true);
            if (this.isDisposed()) {
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_SETFOCUS(int n2, int n3) {
        return null;
    }

    @Override
    LRESULT WM_SIZE(int n2, int n3) {
        if (this.ignoreResize) {
            return null;
        }
        if ((this.style & 0x40) != 0) {
            LRESULT lRESULT = super.WM_SIZE(n2, n3);
            if (OS.IsWindowVisible(this.handle)) {
                if (OS.IsWinCE) {
                    int n4;
                    int n5 = OS.GetDlgItem(this.handle, 1001);
                    if (n5 != 0) {
                        OS.InvalidateRect(n5, null, true);
                    }
                    if ((n4 = OS.GetDlgItem(this.handle, 1000)) != 0) {
                        OS.InvalidateRect(n4, null, true);
                    }
                } else {
                    int n6 = 133;
                    OS.RedrawWindow(this.handle, null, 0, n6);
                }
            }
            return lRESULT;
        }
        boolean bl2 = this.lockText;
        if ((this.style & 8) == 0) {
            this.lockText = true;
        }
        LRESULT lRESULT = super.WM_SIZE(n2, n3);
        if ((this.style & 8) == 0) {
            this.lockText = bl2;
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(this.scrollWidth);
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_UPDATEUISTATE(int n2, int n3) {
        LRESULT lRESULT = super.WM_UPDATEUISTATE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        OS.InvalidateRect(this.handle, null, true);
        return lRESULT;
    }

    @Override
    LRESULT WM_WINDOWPOSCHANGING(int n2, int n3) {
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGING(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.IsWinCE) {
            return lRESULT;
        }
        if (!this.getDrawing()) {
            return lRESULT;
        }
        if (!OS.IsWindowVisible(this.handle)) {
            return lRESULT;
        }
        if (this.ignoreResize) {
            WINDOWPOS wINDOWPOS = new WINDOWPOS();
            OS.MoveMemory(wINDOWPOS, n3, WINDOWPOS.sizeof);
            if ((wINDOWPOS.flags & 1) == 0) {
                wINDOWPOS.flags |= 8;
                OS.MoveMemory(n3, wINDOWPOS, WINDOWPOS.sizeof);
                OS.InvalidateRect(this.handle, null, true);
                RECT rECT = new RECT();
                OS.GetWindowRect(this.handle, rECT);
                int n4 = rECT.right - rECT.left;
                int n5 = rECT.bottom - rECT.top;
                if (n4 != 0 && n5 != 0) {
                    int n6;
                    int n7 = this.parent.handle;
                    int n8 = OS.GetWindow(n7, 5);
                    OS.MapWindowPoints(0, n7, rECT, 2);
                    int n9 = OS.CreateRectRgn(rECT.left, rECT.top, rECT.right, rECT.bottom);
                    while (n8 != 0) {
                        if (n8 != this.handle) {
                            OS.GetWindowRect(n8, rECT);
                            OS.MapWindowPoints(0, n7, rECT, 2);
                            n6 = OS.CreateRectRgn(rECT.left, rECT.top, rECT.right, rECT.bottom);
                            OS.CombineRgn(n9, n9, n6, 4);
                            OS.DeleteObject(n6);
                        }
                        n8 = OS.GetWindow(n8, 2);
                    }
                    n6 = 1029;
                    OS.RedrawWindow(n7, null, n9, n6);
                    OS.DeleteObject(n9);
                }
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT wmChar(int n2, int n3, int n4) {
        if (this.ignoreCharacter) {
            return null;
        }
        LRESULT lRESULT = super.wmChar(n2, n3, n4);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch (n3) {
            case 9: {
                return LRESULT.ZERO;
            }
            case 13: {
                if (!this.ignoreDefaultSelection) {
                    this.sendSelectionEvent(14);
                }
                this.ignoreDefaultSelection = false;
                if (this.getSelectionIndex() == -1 && (this.style & 4) != 0 && (this.style & 8) == 0) {
                    if (OS.SendMessage(this.handle, 343, 0, 0) != 0) {
                        OS.SendMessage(this.handle, 335, 0, 0);
                    }
                    return LRESULT.ZERO;
                }
            }
            case 27: {
                if ((this.style & 4) != 0 && OS.SendMessage(this.handle, 343, 0, 0) == 0) {
                    return LRESULT.ZERO;
                }
            }
            case 127: {
                String string;
                Matcher matcher;
                if (OS.GetKeyState(17) >= 0) break;
                if (OS.WIN32_VERSION < OS.VERSION(6, 0) || (this.style & 8) != 0) {
                    return LRESULT.ZERO;
                }
                Point point = this.getSelection();
                int n5 = OS.GetDlgItem(this.handle, 1001);
                int n6 = point.x;
                int n7 = point.y;
                if (n6 == n7 && (matcher = CTRL_BS_PATTERN.matcher(string = this.getText().substring(0, n6))).find()) {
                    n6 = matcher.start();
                    n7 = matcher.end();
                    OS.SendMessage(n5, 177, n6, n7);
                }
                if (n6 < n7) {
                    OS.SendMessage(n5, 194, 1, 0);
                }
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    LRESULT wmClipboard(int n2, int n3, int n4, int n5) {
        Object object;
        if ((this.style & 8) != 0) {
            return null;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return null;
        }
        boolean bl2 = false;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        String string = null;
        switch (n3) {
            case 768: 
            case 771: {
                OS.SendMessage(n2, 176, nArray, nArray2);
                if (this.untranslateOffset(nArray[0]) == this.untranslateOffset(nArray2[0])) break;
                string = "";
                bl2 = true;
                break;
            }
            case 770: {
                OS.SendMessage(n2, 176, nArray, nArray2);
                string = this.getClipboardText();
                break;
            }
            case 199: 
            case 772: {
                if (OS.SendMessage(n2, 198, 0, 0) == 0) break;
                this.ignoreModify = true;
                OS.CallWindowProc(EditProc, n2, n3, n4, n5);
                int n6 = OS.GetWindowTextLength(n2);
                object = new int[1];
                int[] nArray3 = new int[1];
                OS.SendMessage(n2, 176, (int[])object, nArray3);
                if (n6 != 0 && object[0] != nArray3[0]) {
                    TCHAR tCHAR = new TCHAR(this.getCodePage(), n6 + 1);
                    OS.GetWindowText(n2, tCHAR, n6 + 1);
                    string = tCHAR.toString((int)object[0], nArray3[0] - object[0]);
                } else {
                    string = "";
                }
                OS.CallWindowProc(EditProc, n2, n3, n4, n5);
                OS.SendMessage(n2, 176, nArray, nArray2);
                this.ignoreModify = false;
                break;
            }
            case 12: {
                if (this.lockText) {
                    return null;
                }
                nArray2[0] = OS.GetWindowTextLength(n2);
                int n6 = OS.IsUnicode ? OS.wcslen(n5) : OS.strlen(n5);
                object = new TCHAR(this.getCodePage(), n6);
                int n7 = ((TCHAR)object).length() * TCHAR.sizeof;
                OS.MoveMemory((TCHAR)object, n5, n7);
                string = ((TCHAR)object).toString(0, n6);
            }
        }
        if (string != null) {
            String string2 = string;
            if ((string = this.verifyText(string, nArray[0], nArray2[0], null)) == null) {
                return LRESULT.ZERO;
            }
            if (!string.equals(string2)) {
                if (bl2) {
                    OS.CallWindowProc(EditProc, n2, n3, n4, n5);
                }
                object = new TCHAR(this.getCodePage(), string, true);
                if (n3 == 12) {
                    int n8 = OS.GetProcessHeap();
                    int n9 = ((TCHAR)object).length() * TCHAR.sizeof;
                    int n10 = OS.HeapAlloc(n8, 8, n9);
                    OS.MoveMemory(n10, (TCHAR)object, n9);
                    int n11 = OS.CallWindowProc(EditProc, n2, n3, n4, n10);
                    OS.HeapFree(n8, 0, n10);
                    return new LRESULT(n11);
                }
                OS.SendMessage(n2, 194, 0, (TCHAR)object);
                return LRESULT.ZERO;
            }
        }
        return null;
    }

    @Override
    LRESULT wmCommandChild(int n2, int n3) {
        int n4 = OS.HIWORD(n2);
        switch (n4) {
            case 5: {
                if (this.ignoreModify) break;
                this.noSelection = true;
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                this.noSelection = false;
                break;
            }
            case 1: {
                int n5 = OS.SendMessage(this.handle, 327, 0, 0);
                if (n5 != -1) {
                    OS.SendMessage(this.handle, 334, n5, 0);
                }
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                this.sendSelectionEvent(13);
                break;
            }
            case 3: {
                this.sendFocusEvent(15);
                if (!this.isDisposed()) break;
                return LRESULT.ZERO;
            }
            case 7: {
                this.setCursor();
                this.updateDropDownHeight();
                break;
            }
            case 4: {
                if ((this.style & 8) != 0) break;
                this.sendFocusEvent(16);
                if (!this.isDisposed()) break;
                return LRESULT.ZERO;
            }
            case 1792: 
            case 1793: {
                Event event = new Event();
                event.doit = true;
                this.sendEvent(44, event);
                if (!event.doit) {
                    int n6 = n3;
                    int n7 = OS.GetWindowLong(n6, -20);
                    int n8 = OS.GetWindowLong(n6, -16);
                    if (n4 == 1792) {
                        n7 |= 0x3000;
                        n8 |= 2;
                    } else {
                        n7 &= 0xFFFFCFFF;
                        n8 &= 0xFFFFFFFD;
                    }
                    OS.SetWindowLong(n6, -20, n7);
                    OS.SetWindowLong(n6, -16, n8);
                }
                if (!this.hooks(49) && !this.filters(49) && (this.state & 0x400000) == 0) break;
                this.clearSegments(true);
                this.state &= 0xFFBFFFFF;
                this.applyEditSegments();
            }
        }
        return super.wmCommandChild(n2, n3);
    }

    @Override
    LRESULT wmIMEChar(int n2, int n3, int n4) {
        Display display = this.display;
        display.lastKey = 0;
        display.lastAscii = n3;
        display.lastDead = false;
        display.lastNull = false;
        display.lastVirtual = false;
        if (!this.sendKeyEvent(1, 646, n3, n4)) {
            return LRESULT.ZERO;
        }
        this.ignoreCharacter = true;
        int n5 = this.callWindowProc(n2, 646, n3, n4);
        MSG mSG = new MSG();
        int n6 = 10420227;
        while (OS.PeekMessage(mSG, n2, 258, 258, n6)) {
            OS.TranslateMessage(mSG);
            OS.DispatchMessage(mSG);
        }
        this.ignoreCharacter = false;
        this.sendKeyEvent(2, 646, n3, n4);
        display.lastAscii = 0;
        display.lastKey = 0;
        return new LRESULT(n5);
    }

    @Override
    LRESULT wmKeyDown(int n2, int n3, int n4) {
        if (this.ignoreCharacter) {
            return null;
        }
        LRESULT lRESULT = super.wmKeyDown(n2, n3, n4);
        if (lRESULT != null) {
            return lRESULT;
        }
        this.ignoreDefaultSelection = false;
        switch (n3) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                if (this.segments == null) break;
                int n5 = 0;
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                int[] nArray3 = new int[1];
                int[] nArray4 = new int[1];
                OS.SendMessage(this.handle, 320, nArray, nArray2);
                while (true) {
                    n5 = this.callWindowProc(n2, 256, n3, n4);
                    OS.SendMessage(this.handle, 320, nArray3, nArray4);
                    if (nArray3[0] != nArray[0] ? this.untranslateOffset(nArray3[0]) != this.untranslateOffset(nArray[0]) : nArray4[0] == nArray2[0] || this.untranslateOffset(nArray4[0]) != this.untranslateOffset(nArray2[0])) break;
                    nArray[0] = nArray3[0];
                    nArray2[0] = nArray4[0];
                }
                lRESULT = n5 == 0 ? LRESULT.ZERO : new LRESULT(n5);
                break;
            }
            case 13: {
                if ((this.style & 4) == 0 || OS.SendMessage(this.handle, 343, 0, 0) == 0) break;
                this.ignoreDefaultSelection = true;
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT wmSysKeyDown(int n2, int n3, int n4) {
        int n5 = OS.SendMessage(this.handle, 327, 0, 0);
        LRESULT lRESULT = super.wmSysKeyDown(n2, n3, n4);
        if (lRESULT != null) {
            return lRESULT;
        }
        if ((this.style & 8) == 0 && n3 == 40) {
            int n6 = this.callWindowProc(n2, 260, n3, n4);
            int n7 = OS.SendMessage(this.handle, 327, 0, 0);
            if (n5 != n7) {
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                this.sendSelectionEvent(13, null, true);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
            }
            return new LRESULT(n6);
        }
        return lRESULT;
    }

    static {
        ComboClass = new TCHAR(0, "COMBOBOX", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, ComboClass, wNDCLASS);
        ComboProc = wNDCLASS.lpfnWndProc;
    }
}

