/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.MARGINS;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.REBARBANDINFO;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TypedListener;

public class CoolItem
extends Item {
    CoolBar parent;
    Control control;
    int id;
    boolean ideal;
    boolean minimum;

    public CoolItem(CoolBar coolBar, int n2) {
        super(coolBar, n2);
        this.parent = coolBar;
        coolBar.createItem(this, coolBar.getItemCount());
    }

    public CoolItem(CoolBar coolBar, int n2, int n3) {
        super(coolBar, n2);
        this.parent = coolBar;
        coolBar.createItem(this, n3);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n2, int n3) {
        this.checkWidget();
        n2 = n2 != -1 ? DPIUtil.autoScaleUp(n2) : n2;
        n3 = n3 != -1 ? DPIUtil.autoScaleUp(n3) : n3;
        return DPIUtil.autoScaleDown(this.computeSizeInPixels(n2, n3));
    }

    Point computeSizeInPixels(int n2, int n3) {
        int n4 = this.parent.indexOf(this);
        if (n4 == -1) {
            return new Point(0, 0);
        }
        int n5 = n2;
        int n6 = n3;
        if (n2 == -1) {
            n5 = 32;
        }
        if (n3 == -1) {
            n6 = 32;
        }
        if ((this.parent.style & 0x200) != 0) {
            n6 += this.parent.getMargin(n4);
        } else {
            n5 += this.parent.getMargin(n4);
        }
        return new Point(n5, n6);
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    Rectangle getBoundsInPixels() {
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n3 = this.parent.handle;
        RECT rECT = new RECT();
        OS.SendMessage(n3, 1033, n2, rECT);
        if (OS.COMCTL32_MAJOR >= 6) {
            MARGINS mARGINS = new MARGINS();
            OS.SendMessage(n3, 1064, 0, mARGINS);
            rECT.left -= mARGINS.cxLeftWidth;
            rECT.right += mARGINS.cxRightWidth;
        }
        if (!this.parent.isLastItemOfRow(n2)) {
            rECT.right = rECT.right + ((this.parent.style & 0x800000) == 0 ? 2 : 0);
        }
        int n4 = rECT.right - rECT.left;
        int n5 = rECT.bottom - rECT.top;
        if ((this.parent.style & 0x200) != 0) {
            return new Rectangle(rECT.top, rECT.left, n5, n4);
        }
        return new Rectangle(rECT.left, rECT.top, n4, n5);
    }

    Rectangle getClientArea() {
        this.checkWidget();
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n3 = this.parent.handle;
        RECT rECT = new RECT();
        OS.SendMessage(n3, 1058, n2, rECT);
        RECT rECT2 = new RECT();
        OS.SendMessage(n3, 1033, n2, rECT2);
        int n4 = rECT2.left + rECT.left;
        int n5 = rECT2.top;
        int n6 = rECT2.right - rECT2.left - rECT.left;
        int n7 = rECT2.bottom - rECT2.top;
        if ((this.parent.style & 0x800000) == 0) {
            n5 += rECT.top;
            n6 -= rECT.right;
            n7 -= rECT.top + rECT.bottom;
        }
        if (n2 == 0) {
            REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
            rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
            rEBARBANDINFO.fMask = 2048;
            OS.SendMessage(n3, OS.RB_GETBANDINFO, n2, rEBARBANDINFO);
            n6 = n6 - rEBARBANDINFO.cxHeader + 1;
        }
        return new Rectangle(n4, n5, Math.max(0, n6), Math.max(0, n7));
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public CoolBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
        this.id = -1;
        this.control = null;
    }

    public void setControl(Control control) {
        int n2;
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if ((n2 = this.parent.indexOf(this)) == -1) {
            return;
        }
        if (this.control != null && this.control.isDisposed()) {
            this.control = null;
        }
        Control control2 = this.control;
        Control control3 = control;
        int n3 = this.parent.handle;
        int n4 = control3 != null ? control.topHandle() : 0;
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 16;
        rEBARBANDINFO.hwndChild = n4;
        this.control = control3;
        int n5 = 0;
        if (control3 != null) {
            n5 = OS.GetWindow(n4, 3);
        }
        boolean bl2 = control3 != null && !control3.getVisible();
        boolean bl3 = control2 != null && control2.getVisible();
        OS.SendMessage(n3, OS.RB_SETBANDINFO, n2, rEBARBANDINFO);
        if (bl2) {
            control3.setVisible(false);
        }
        if (bl3) {
            control2.setVisible(true);
        }
        if (n5 != 0 && n5 != n4) {
            int n6 = 19;
            this.SetWindowPos(n4, n5, 0, 0, 0, 0, n6);
        }
    }

    public Point getPreferredSize() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getPreferredSizeInPixels());
    }

    Point getPreferredSizeInPixels() {
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return new Point(0, 0);
        }
        int n3 = this.parent.handle;
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 544;
        OS.SendMessage(n3, OS.RB_GETBANDINFO, n2, rEBARBANDINFO);
        int n4 = rEBARBANDINFO.cxIdeal + this.parent.getMargin(n2);
        if ((this.parent.style & 0x200) != 0) {
            return new Point(rEBARBANDINFO.cyMaxChild, n4);
        }
        return new Point(n4, rEBARBANDINFO.cyMaxChild);
    }

    public void setPreferredSize(int n2, int n3) {
        this.checkWidget();
        this.setPreferredSizeInPixels(DPIUtil.autoScaleUp(n2), DPIUtil.autoScaleUp(n3));
    }

    void setPreferredSizeInPixels(int n2, int n3) {
        int n4;
        int n5;
        int n6 = this.parent.indexOf(this);
        if (n6 == -1) {
            return;
        }
        n2 = Math.max(0, n2);
        n3 = Math.max(0, n3);
        this.ideal = true;
        int n7 = this.parent.handle;
        if ((this.parent.style & 0x200) != 0) {
            n5 = Math.max(0, n3 - this.parent.getMargin(n6));
            n4 = n2;
        } else {
            n5 = Math.max(0, n2 - this.parent.getMargin(n6));
            n4 = n3;
        }
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 32;
        OS.SendMessage(n7, OS.RB_GETBANDINFO, n6, rEBARBANDINFO);
        rEBARBANDINFO.fMask = 544;
        rEBARBANDINFO.cxIdeal = n5;
        rEBARBANDINFO.cyMaxChild = n4;
        if (!this.minimum) {
            rEBARBANDINFO.cyMinChild = n4;
        }
        OS.SendMessage(n7, OS.RB_SETBANDINFO, n6, rEBARBANDINFO);
    }

    public void setPreferredSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        point = DPIUtil.autoScaleUp(point);
        this.setPreferredSizeInPixels(point.x, point.y);
    }

    public Point getSize() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getSizeInPixels());
    }

    Point getSizeInPixels() {
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            new Point(0, 0);
        }
        int n3 = this.parent.handle;
        RECT rECT = new RECT();
        OS.SendMessage(n3, 1033, n2, rECT);
        if (OS.COMCTL32_MAJOR >= 6) {
            MARGINS mARGINS = new MARGINS();
            OS.SendMessage(n3, 1064, 0, mARGINS);
            rECT.left -= mARGINS.cxLeftWidth;
            rECT.right += mARGINS.cxRightWidth;
        }
        if (!this.parent.isLastItemOfRow(n2)) {
            rECT.right = rECT.right + ((this.parent.style & 0x800000) == 0 ? 2 : 0);
        }
        int n4 = rECT.right - rECT.left;
        int n5 = rECT.bottom - rECT.top;
        if ((this.parent.style & 0x200) != 0) {
            return new Point(n5, n4);
        }
        return new Point(n4, n5);
    }

    public void setSize(int n2, int n3) {
        this.checkWidget();
        this.setSizeInPixels(DPIUtil.autoScaleUp(n2), DPIUtil.autoScaleUp(n3));
    }

    void setSizeInPixels(int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = this.parent.indexOf(this);
        if (n7 == -1) {
            return;
        }
        n2 = Math.max(0, n2);
        n3 = Math.max(0, n3);
        int n8 = this.parent.handle;
        if ((this.parent.style & 0x200) != 0) {
            n6 = n3;
            n5 = n2;
            n4 = Math.max(0, n3 - this.parent.getMargin(n7));
        } else {
            n6 = n2;
            n5 = n3;
            n4 = Math.max(0, n2 - this.parent.getMargin(n7));
        }
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 544;
        OS.SendMessage(n8, OS.RB_GETBANDINFO, n7, rEBARBANDINFO);
        if (!this.ideal) {
            rEBARBANDINFO.cxIdeal = n4;
        }
        if (!this.minimum) {
            rEBARBANDINFO.cyMinChild = n5;
        }
        rEBARBANDINFO.cyChild = n5;
        if (!this.parent.isLastItemOfRow(n7)) {
            if (OS.COMCTL32_MAJOR >= 6) {
                MARGINS mARGINS = new MARGINS();
                OS.SendMessage(n8, 1064, 0, mARGINS);
                n6 -= mARGINS.cxLeftWidth + mARGINS.cxRightWidth;
            }
            int n9 = (this.parent.style & 0x800000) == 0 ? 2 : 0;
            rEBARBANDINFO.cx = n6 - n9;
            rEBARBANDINFO.fMask |= 0x40;
        }
        OS.SendMessage(n8, OS.RB_SETBANDINFO, n7, rEBARBANDINFO);
    }

    public void setSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        point = DPIUtil.autoScaleUp(point);
        this.setSizeInPixels(point.x, point.y);
    }

    public Point getMinimumSize() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getMinimumSizeInPixels());
    }

    Point getMinimumSizeInPixels() {
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return new Point(0, 0);
        }
        int n3 = this.parent.handle;
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 32;
        OS.SendMessage(n3, OS.RB_GETBANDINFO, n2, rEBARBANDINFO);
        if ((this.parent.style & 0x200) != 0) {
            return new Point(rEBARBANDINFO.cyMinChild, rEBARBANDINFO.cxMinChild);
        }
        return new Point(rEBARBANDINFO.cxMinChild, rEBARBANDINFO.cyMinChild);
    }

    public void setMinimumSize(int n2, int n3) {
        this.checkWidget();
        this.setMinimumSizeInPixels(DPIUtil.autoScaleUp(n2), DPIUtil.autoScaleUp(n3));
    }

    void setMinimumSizeInPixels(int n2, int n3) {
        int n4;
        int n5;
        int n6 = this.parent.indexOf(this);
        if (n6 == -1) {
            return;
        }
        n2 = Math.max(0, n2);
        n3 = Math.max(0, n3);
        this.minimum = true;
        int n7 = this.parent.handle;
        if ((this.parent.style & 0x200) != 0) {
            n5 = n3;
            n4 = n2;
        } else {
            n5 = n2;
            n4 = n3;
        }
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 32;
        OS.SendMessage(n7, OS.RB_GETBANDINFO, n6, rEBARBANDINFO);
        rEBARBANDINFO.cxMinChild = n5;
        rEBARBANDINFO.cyMinChild = n4;
        OS.SendMessage(n7, OS.RB_SETBANDINFO, n6, rEBARBANDINFO);
    }

    public void setMinimumSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        point = DPIUtil.autoScaleUp(point);
        this.setMinimumSizeInPixels(point.x, point.y);
    }

    boolean getWrap() {
        int n2 = this.parent.indexOf(this);
        int n3 = this.parent.handle;
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 1;
        OS.SendMessage(n3, OS.RB_GETBANDINFO, n2, rEBARBANDINFO);
        return (rEBARBANDINFO.fStyle & 1) != 0;
    }

    void setWrap(boolean bl2) {
        int n2 = this.parent.indexOf(this);
        int n3 = this.parent.handle;
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 1;
        OS.SendMessage(n3, OS.RB_GETBANDINFO, n2, rEBARBANDINFO);
        rEBARBANDINFO.fStyle = bl2 ? (rEBARBANDINFO.fStyle |= 1) : (rEBARBANDINFO.fStyle &= 0xFFFFFFFE);
        OS.SendMessage(n3, OS.RB_SETBANDINFO, n2, rEBARBANDINFO);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }
}

