/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.INITCOMMONCONTROLSEX;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MCHITTESTINFO;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SIZE;
import org.eclipse.swt.internal.win32.SYSTEMTIME;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TypedListener;

public class DateTime
extends Composite {
    static final int MIN_YEAR = 1752;
    static final int MAX_YEAR = 9999;
    boolean doubleClick;
    boolean ignoreSelection;
    SYSTEMTIME lastSystemTime;
    SYSTEMTIME time = new SYSTEMTIME();
    static final int DateTimeProc;
    static final TCHAR DateTimeClass;
    static final int CalendarProc;
    static final TCHAR CalendarClass;
    static final int MARGIN = 4;
    static final int MAX_DIGIT = 9;
    static final int MAX_DAY = 31;
    static final int MAX_12HOUR = 12;
    static final int MAX_24HOUR = 24;
    static final int MAX_MINUTE = 60;
    static final int MONTH_DAY_YEAR = 0;
    static final int DAY_MONTH_YEAR = 1;
    static final int YEAR_MONTH_DAY = 2;
    static final char SINGLE_QUOTE = '\'';
    static final char DAY_FORMAT_CONSTANT = 'd';
    static final char MONTH_FORMAT_CONSTANT = 'M';
    static final char YEAR_FORMAT_CONSTANT = 'y';
    static final char HOURS_FORMAT_CONSTANT = 'h';
    static final char MINUTES_FORMAT_CONSTANT = 'm';
    static final char SECONDS_FORMAT_CONSTANT = 's';
    static final char AMPM_FORMAT_CONSTANT = 't';
    static final int[] MONTH_NAMES;

    public DateTime(Composite composite, int n2) {
        super(composite, DateTime.checkStyle(n2));
        if ((this.style & 0x8000) != 0) {
            String string = (this.style & 0x20) != 0 ? this.getCustomShortDateFormat() : this.getCustomShortTimeFormat();
            TCHAR tCHAR = new TCHAR(0, string, true);
            OS.SendMessage(this.handle, OS.DTM_SETFORMAT, 0, tCHAR);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    int callWindowProc(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.CallWindowProc(this.windowProc(), n2, n3, n4, n5);
    }

    static int checkStyle(int n2) {
        n2 &= 0xFFFFFCFF;
        n2 = DateTime.checkBits(n2, 32, 128, 1024, 0, 0, 0);
        if (((n2 = DateTime.checkBits(n2, 65536, 32768, 0x10000000, 0, 0, 0)) & 0x20) == 0) {
            n2 &= 0xFFFFFFFB;
        }
        return n2;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    Point computeSizeInPixels(int n2, int n3, boolean bl2) {
        this.checkWidget();
        int n4 = 0;
        int n5 = 0;
        if (n2 == -1 || n3 == -1) {
            if ((this.style & 0x400) != 0) {
                RECT rECT = new RECT();
                OS.SendMessage(this.handle, 4105, 0, rECT);
                n4 = rECT.right;
                n5 = rECT.bottom;
            } else {
                if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                    SIZE sIZE = new SIZE();
                    OS.SendMessage(this.handle, 4111, 0, sIZE);
                    n4 = sIZE.cx;
                    n5 = sIZE.cy;
                } else {
                    int n6;
                    int n7 = 0;
                    int n8 = OS.GetDC(this.handle);
                    int n9 = OS.SendMessage(this.handle, 49, 0, 0);
                    if (n9 != 0) {
                        n7 = OS.SelectObject(n8, n9);
                    }
                    RECT rECT = new RECT();
                    if ((this.style & 0x20) != 0) {
                        n6 = 0;
                        TCHAR tCHAR = null;
                        if ((this.style & 0x8000) != 0) {
                            tCHAR = new TCHAR(0, this.getCustomShortDateFormat(), true);
                        } else {
                            n6 = (this.style & 0x10000) != 0 ? 1 : 2;
                        }
                        int n10 = OS.GetDateFormat(1024, n6, null, tCHAR, null, 0);
                        if (n10 > 0) {
                            TCHAR tCHAR2 = new TCHAR(this.getCodePage(), n10);
                            OS.GetDateFormat(1024, n6, null, tCHAR, tCHAR2, tCHAR2.length());
                            OS.DrawText(n8, tCHAR2, n10, rECT, 9216);
                        }
                    } else if ((this.style & 0x80) != 0) {
                        int n11;
                        n6 = 0;
                        TCHAR tCHAR = null;
                        if ((this.style & 0x8000) != 0) {
                            n6 = 2;
                            tCHAR = new TCHAR(0, this.getCustomShortTimeFormat(), true);
                        }
                        if ((n11 = OS.GetTimeFormat(1024, n6, null, tCHAR, null, 0)) > 0) {
                            TCHAR tCHAR3 = new TCHAR(this.getCodePage(), n11);
                            OS.GetTimeFormat(1024, n6, null, tCHAR, tCHAR3, tCHAR3.length());
                            OS.DrawText(n8, tCHAR3, n11, rECT, 9216);
                        }
                    }
                    n4 = rECT.right - rECT.left;
                    n5 = rECT.bottom - rECT.top;
                    if (n9 != 0) {
                        OS.SelectObject(n8, n7);
                    }
                    OS.ReleaseDC(this.handle, n8);
                    n6 = OS.GetSystemMetrics(2);
                    n4 += n6 + 4;
                }
                int n12 = OS.GetSystemMetrics(20);
                if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                    n12 += 7;
                }
                n5 = Math.max(n5, n12);
            }
        }
        if (n4 == 0) {
            n4 = 64;
        }
        if (n5 == 0) {
            n5 = 64;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        if (n3 != -1) {
            n5 = n3;
        }
        int n13 = this.getBorderWidthInPixels();
        return new Point(n4 += n13 * 2, n5 += n13 * 2);
    }

    @Override
    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFFEFD;
        if ((this.style & 0x800) == 0) {
            int n2 = OS.GetWindowLong(this.handle, -20);
            OS.SetWindowLong(this.handle, -20, n2 &= 0xFFFDFDFF);
        }
    }

    @Override
    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    String getCustomShortDateFormat() {
        TCHAR tCHAR = new TCHAR(this.getCodePage(), 80);
        int n2 = OS.GetLocaleInfo(1024, 4102, tCHAR, 80);
        return n2 != 0 ? tCHAR.toString(0, n2 - 1) : "M/yyyy";
    }

    String getCustomShortTimeFormat() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(this.getTimeFormat());
        int n3 = stringBuffer.length();
        boolean bl2 = false;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            char c2 = stringBuffer.charAt(n2);
            if (c2 == '\'') {
                bl2 = !bl2;
                continue;
            }
            if (c2 != 's' || bl2) continue;
            for (n4 = n2 + 1; n4 < n3 && stringBuffer.charAt(n4) == 's'; ++n4) {
            }
            while (n2 > 0 && stringBuffer.charAt(n2) != 'm') {
                --n2;
            }
            ++n2;
            break;
        }
        if (n2 < n4) {
            stringBuffer.delete(n2, n4);
        }
        return stringBuffer.toString();
    }

    String getTimeFormat() {
        TCHAR tCHAR = new TCHAR(this.getCodePage(), 80);
        int n2 = OS.GetLocaleInfo(1024, 4099, tCHAR, 80);
        return n2 > 0 ? tCHAR.toString(0, n2 - 1) : "h:mm:ss tt";
    }

    public int getDay() {
        this.checkWidget();
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n2 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n2, 0, sYSTEMTIME);
        return sYSTEMTIME.wDay;
    }

    public int getHours() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            return this.time.wHour;
        }
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n2 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n2, 0, sYSTEMTIME);
        return sYSTEMTIME.wHour;
    }

    public int getMinutes() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            return this.time.wMinute;
        }
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n2 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n2, 0, sYSTEMTIME);
        return sYSTEMTIME.wMinute;
    }

    public int getMonth() {
        this.checkWidget();
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n2 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n2, 0, sYSTEMTIME);
        return sYSTEMTIME.wMonth - 1;
    }

    @Override
    String getNameText() {
        return (this.style & 0x80) != 0 ? this.getHours() + ":" + this.getMinutes() + ":" + this.getSeconds() : this.getMonth() + 1 + "/" + this.getDay() + "/" + this.getYear();
    }

    public int getSeconds() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            return this.time.wSecond;
        }
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n2 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n2, 0, sYSTEMTIME);
        return sYSTEMTIME.wSecond;
    }

    public int getYear() {
        this.checkWidget();
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n2 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n2, 0, sYSTEMTIME);
        return sYSTEMTIME.wYear;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.lastSystemTime = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setDate(int n2, int n3, int n4) {
        this.checkWidget();
        if (n2 < 1752 || n2 > 9999) {
            return;
        }
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n5 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n5, 0, sYSTEMTIME);
        n5 = (this.style & 0x400) != 0 ? 4098 : 4098;
        sYSTEMTIME.wYear = (short)n2;
        sYSTEMTIME.wMonth = (short)(n3 + 1);
        sYSTEMTIME.wDay = (short)n4;
        OS.SendMessage(this.handle, n5, 0, sYSTEMTIME);
        this.lastSystemTime = null;
    }

    public void setDay(int n2) {
        this.checkWidget();
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n3 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n3, 0, sYSTEMTIME);
        n3 = (this.style & 0x400) != 0 ? 4098 : 4098;
        sYSTEMTIME.wDay = (short)n2;
        OS.SendMessage(this.handle, n3, 0, sYSTEMTIME);
        this.lastSystemTime = null;
    }

    public void setHours(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > 23) {
            return;
        }
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n3 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n3, 0, sYSTEMTIME);
        n3 = (this.style & 0x400) != 0 ? 4098 : 4098;
        sYSTEMTIME.wHour = (short)n2;
        OS.SendMessage(this.handle, n3, 0, sYSTEMTIME);
        if ((this.style & 0x400) != 0 && n2 >= 0 && n2 <= 23) {
            this.time.wHour = (short)n2;
        }
    }

    public void setMinutes(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > 59) {
            return;
        }
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n3 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n3, 0, sYSTEMTIME);
        n3 = (this.style & 0x400) != 0 ? 4098 : 4098;
        sYSTEMTIME.wMinute = (short)n2;
        OS.SendMessage(this.handle, n3, 0, sYSTEMTIME);
        if ((this.style & 0x400) != 0 && n2 >= 0 && n2 <= 59) {
            this.time.wMinute = (short)n2;
        }
    }

    public void setMonth(int n2) {
        this.checkWidget();
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n3 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n3, 0, sYSTEMTIME);
        n3 = (this.style & 0x400) != 0 ? 4098 : 4098;
        sYSTEMTIME.wMonth = (short)(n2 + 1);
        OS.SendMessage(this.handle, n3, 0, sYSTEMTIME);
        this.lastSystemTime = null;
    }

    @Override
    public void setOrientation(int n2) {
        if ((this.style & 0x400) != 0) {
            super.setOrientation(n2);
        }
    }

    public void setSeconds(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > 59) {
            return;
        }
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n3 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n3, 0, sYSTEMTIME);
        n3 = (this.style & 0x400) != 0 ? 4098 : 4098;
        sYSTEMTIME.wSecond = (short)n2;
        OS.SendMessage(this.handle, n3, 0, sYSTEMTIME);
        if ((this.style & 0x400) != 0 && n2 >= 0 && n2 <= 59) {
            this.time.wSecond = (short)n2;
        }
    }

    public void setTime(int n2, int n3, int n4) {
        this.checkWidget();
        if (n2 < 0 || n2 > 23 || n3 < 0 || n3 > 59 || n4 < 0 || n4 > 59) {
            return;
        }
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n5 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n5, 0, sYSTEMTIME);
        n5 = (this.style & 0x400) != 0 ? 4098 : 4098;
        sYSTEMTIME.wHour = (short)n2;
        sYSTEMTIME.wMinute = (short)n3;
        sYSTEMTIME.wSecond = (short)n4;
        OS.SendMessage(this.handle, n5, 0, sYSTEMTIME);
        if ((this.style & 0x400) != 0 && n2 >= 0 && n2 <= 23 && n3 >= 0 && n3 <= 59 && n4 >= 0 && n4 <= 59) {
            this.time.wHour = (short)n2;
            this.time.wMinute = (short)n3;
            this.time.wSecond = (short)n4;
        }
    }

    public void setYear(int n2) {
        this.checkWidget();
        if (n2 < 1752 || n2 > 9999) {
            return;
        }
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n3 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n3, 0, sYSTEMTIME);
        n3 = (this.style & 0x400) != 0 ? 4098 : 4098;
        sYSTEMTIME.wYear = (short)n2;
        OS.SendMessage(this.handle, n3, 0, sYSTEMTIME);
        this.lastSystemTime = null;
    }

    @Override
    int widgetStyle() {
        int n2 = super.widgetStyle() | 0x10000;
        if ((this.style & 0x400) != 0) {
            return n2 | 0x10;
        }
        n2 &= 0xFDFFFFFF;
        if ((this.style & 0x80) != 0) {
            n2 |= 9;
        }
        if ((this.style & 0x20) != 0) {
            n2 |= (this.style & 0x10000) != 0 ? 12 : 4;
            if ((this.style & 4) == 0) {
                n2 |= 1;
            }
        }
        return n2;
    }

    @Override
    TCHAR windowClass() {
        return (this.style & 0x400) != 0 ? CalendarClass : DateTimeClass;
    }

    @Override
    int windowProc() {
        return (this.style & 0x400) != 0 ? CalendarProc : DateTimeProc;
    }

    @Override
    LRESULT wmNotifyChild(NMHDR nMHDR, int n2, int n3) {
        switch (nMHDR.code) {
            case -753: {
                this.display.captureChanged = true;
                break;
            }
            case -749: {
                if (this.ignoreSelection) break;
                SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
                OS.SendMessage(this.handle, 4097, 0, sYSTEMTIME);
                this.sendSelectionEvent(13);
                break;
            }
            case -759: {
                SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
                OS.SendMessage(this.handle, 4097, 0, sYSTEMTIME);
                if (this.lastSystemTime != null && sYSTEMTIME.wDay == this.lastSystemTime.wDay && sYSTEMTIME.wMonth == this.lastSystemTime.wMonth && sYSTEMTIME.wYear == this.lastSystemTime.wYear) break;
                this.sendSelectionEvent(13);
                if ((this.style & 0x80) != 0) break;
                this.lastSystemTime = sYSTEMTIME;
                break;
            }
        }
        return super.wmNotifyChild(nMHDR, n2, n3);
    }

    @Override
    LRESULT WM_CHAR(int n2, int n3) {
        LRESULT lRESULT = super.WM_CHAR(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch (n2) {
            case 13: {
                this.sendSelectionEvent(14);
            }
            case 9: 
            case 27: {
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_LBUTTONDBLCLK(int n2, int n3) {
        LRESULT lRESULT = super.WM_LBUTTONDBLCLK(n2, n3);
        if (this.isDisposed()) {
            return LRESULT.ZERO;
        }
        if ((this.style & 0x400) != 0) {
            MCHITTESTINFO mCHITTESTINFO = new MCHITTESTINFO();
            mCHITTESTINFO.cbSize = MCHITTESTINFO.sizeof;
            POINT pOINT = new POINT();
            pOINT.x = OS.GET_X_LPARAM(n3);
            pOINT.y = OS.GET_Y_LPARAM(n3);
            mCHITTESTINFO.pt = pOINT;
            int n4 = OS.SendMessage(this.handle, 4110, 0, mCHITTESTINFO);
            if ((n4 & 0x20001) == 131073) {
                this.doubleClick = true;
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_LBUTTONDOWN(int n2, int n3) {
        LRESULT lRESULT = super.WM_LBUTTONDOWN(n2, n3);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        this.doubleClick = false;
        if ((this.style & 0x400) != 0 && (this.style & 0x80000) == 0) {
            OS.SetFocus(this.handle);
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_LBUTTONUP(int n2, int n3) {
        LRESULT lRESULT = super.WM_LBUTTONUP(n2, n3);
        if (this.isDisposed()) {
            return LRESULT.ZERO;
        }
        if (this.doubleClick) {
            this.sendSelectionEvent(14);
        }
        this.doubleClick = false;
        return lRESULT;
    }

    @Override
    LRESULT WM_TIMER(int n2, int n3) {
        LRESULT lRESULT = super.WM_TIMER(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        this.ignoreSelection = true;
        int n4 = this.callWindowProc(this.handle, 275, n2, n3);
        this.ignoreSelection = false;
        return n4 == 0 ? LRESULT.ZERO : new LRESULT(n4);
    }

    static {
        DateTimeClass = new TCHAR(0, "SysDateTimePick32", true);
        CalendarClass = new TCHAR(0, "SysMonthCal32", true);
        Object object = new INITCOMMONCONTROLSEX();
        ((INITCOMMONCONTROLSEX)object).dwSize = INITCOMMONCONTROLSEX.sizeof;
        ((INITCOMMONCONTROLSEX)object).dwICC = 256;
        OS.InitCommonControlsEx((INITCOMMONCONTROLSEX)object);
        object = new WNDCLASS();
        OS.GetClassInfo(0, DateTimeClass, (WNDCLASS)object);
        DateTimeProc = ((WNDCLASS)object).lpfnWndProc;
        int n2 = OS.GetModuleHandle(null);
        int n3 = OS.GetProcessHeap();
        ((WNDCLASS)object).hInstance = n2;
        ((WNDCLASS)object).style &= 0xFFFFBFFF;
        ((WNDCLASS)object).style |= 8;
        int n4 = DateTimeClass.length() * TCHAR.sizeof;
        int n5 = OS.HeapAlloc(n3, 8, n4);
        OS.MoveMemory(n5, DateTimeClass, n4);
        ((WNDCLASS)object).lpszClassName = n5;
        OS.RegisterClass((WNDCLASS)object);
        OS.HeapFree(n3, 0, n5);
        object = new WNDCLASS();
        OS.GetClassInfo(0, CalendarClass, (WNDCLASS)object);
        CalendarProc = ((WNDCLASS)object).lpfnWndProc;
        n2 = OS.GetModuleHandle(null);
        n3 = OS.GetProcessHeap();
        ((WNDCLASS)object).hInstance = n2;
        ((WNDCLASS)object).style &= 0xFFFFBFFF;
        ((WNDCLASS)object).style |= 8;
        n4 = CalendarClass.length() * TCHAR.sizeof;
        n5 = OS.HeapAlloc(n3, 8, n4);
        OS.MoveMemory(n5, CalendarClass, n4);
        ((WNDCLASS)object).lpszClassName = n5;
        OS.RegisterClass((WNDCLASS)object);
        OS.HeapFree(n3, 0, n5);
        MONTH_NAMES = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67};
    }
}

