/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.LITEM;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMLINK;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link$1;
import org.eclipse.swt.widgets.Link$2;
import org.eclipse.swt.widgets.TypedListener;

public class Link
extends Control {
    String text;
    TextLayout layout;
    Color disabledColor;
    int linkForeground = -1;
    Point[] offsets;
    Point selection;
    String[] ids;
    int[] mnemonics;
    int focusIndex;
    int mouseDownIndex;
    int font;
    static final RGB LAST_FALLBACK_LINK_FOREGROUND = new RGB(0, 51, 153);
    static final int LinkProc;
    static final TCHAR LinkClass;

    public Link(Composite composite, int n2) {
        super(composite, n2);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    int callWindowProc(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            return 0;
        }
        if (LinkProc != 0) {
            switch (n3) {
                case 15: {
                    if (n4 == 0) break;
                    OS.SendMessage(n2, 792, n4, 0);
                    return 0;
                }
            }
            return OS.CallWindowProc(LinkProc, n2, n3, n4, n5);
        }
        return OS.DefWindowProc(n2, n3, n4, n5);
    }

    @Override
    Point computeSizeInPixels(int n2, int n3, boolean bl2) {
        int n4;
        int n5;
        int n6;
        this.checkWidget();
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        if (n3 != -1 && n3 < 0) {
            n3 = 0;
        }
        if (this.useCommonControl()) {
            n6 = OS.GetDC(this.handle);
            int n7 = OS.SendMessage(this.handle, 49, 0, 0);
            int n8 = OS.SelectObject(n6, n7);
            if (this.text.length() > 0) {
                TCHAR tCHAR = new TCHAR(this.getCodePage(), this.parse(this.text), false);
                RECT rECT = new RECT();
                int n9 = 3072;
                if (n2 != -1) {
                    n9 |= 0x10;
                    rECT.right = n2;
                }
                OS.DrawText(n6, tCHAR, tCHAR.length(), rECT, n9);
                n5 = rECT.right - rECT.left;
                n4 = rECT.bottom;
            } else {
                TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                OS.GetTextMetrics(n6, tEXTMETRIC);
                n5 = 0;
                n4 = tEXTMETRIC.tmHeight;
            }
            if (n7 != 0) {
                OS.SelectObject(n6, n8);
            }
            OS.ReleaseDC(this.handle, n6);
        } else {
            n6 = this.layout.getWidth();
            if (n2 == 0) {
                this.layout.setWidth(1);
                Rectangle rectangle = DPIUtil.autoScaleUp(this.layout.getBounds());
                n5 = 0;
                n4 = rectangle.height;
            } else {
                this.layout.setWidth(DPIUtil.autoScaleDown(n2));
                Rectangle rectangle = DPIUtil.autoScaleUp(this.layout.getBounds());
                n5 = rectangle.width;
                n4 = rectangle.height;
            }
            this.layout.setWidth(n6);
        }
        if (n2 != -1) {
            n5 = n2;
        }
        if (n3 != -1) {
            n4 = n3;
        }
        n6 = this.getBorderWidthInPixels();
        return new Point(n5 += n6 * 2, n4 += n6 * 2);
    }

    @Override
    void createHandle() {
        super.createHandle();
        this.state |= 0x100;
        this.layout = new TextLayout(this.display);
        this.disabledColor = Color.win32_new(this.display, OS.GetSysColor(OS.COLOR_GRAYTEXT));
        this.offsets = new Point[0];
        this.ids = new String[0];
        this.mnemonics = new int[0];
        this.selection = new Point(-1, -1);
        this.mouseDownIndex = -1;
        this.focusIndex = -1;
    }

    @Override
    void createWidget() {
        super.createWidget();
        this.text = "";
        if ((this.style & 0x8000000) != 0) {
            this.layout.setOrientation(0x4000000);
        }
        this.initAccessible();
    }

    void drawWidget(GC gC, RECT rECT) {
        Rectangle[] rectangleArray;
        this.drawBackground(gC.handle, rECT);
        int n2 = this.selection.x;
        int n3 = this.selection.y;
        if (n2 > n3) {
            n2 = this.selection.y;
            n3 = this.selection.x;
        }
        n3 = -1;
        n2 = -1;
        if (!OS.IsWindowEnabled(this.handle)) {
            gC.setForeground(this.disabledColor);
        }
        this.layout.draw(gC, 0, 0, n2, n3, null, null);
        if (this.hasFocus() && this.focusIndex != -1) {
            rectangleArray = this.getRectanglesInPixels(this.focusIndex);
            for (int i2 = 0; i2 < rectangleArray.length; ++i2) {
                Rectangle rectangle = DPIUtil.autoScaleDown(rectangleArray[i2]);
                gC.drawFocus(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
        if (this.hooks(9) || this.filters(9)) {
            rectangleArray = new Event();
            rectangleArray.gc = gC;
            rectangleArray.setBoundsInPixels(new Rectangle(rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top));
            this.sendEvent(9, (Event)rectangleArray);
            rectangleArray.gc = null;
        }
    }

    @Override
    void enableWidget(boolean bl2) {
        if (this.useCommonControl(bl2)) {
            LITEM lITEM = new LITEM();
            lITEM.mask = 3;
            lITEM.stateMask = 2;
            int n2 = lITEM.state = bl2 ? 2 : 0;
            while (OS.SendMessage(this.handle, 1794, 0, lITEM) != 0) {
                ++lITEM.iLink;
            }
        }
        this.styleLinkParts(bl2);
        this.redraw();
        super.enableWidget(bl2);
    }

    void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new Link$1(this));
        accessible.addAccessibleControlListener(new Link$2(this));
    }

    public Color getLinkForeground() {
        this.checkWidget();
        return this.internalGetLinkForeground();
    }

    Color internalGetLinkForeground() {
        if (this.linkForeground != -1) {
            return Color.win32_new(this.display, this.linkForeground);
        }
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            return Color.win32_new(this.display, OS.GetSysColor(OS.COLOR_HOTLIGHT));
        }
        Color color = new Color((Device)this.display, LAST_FALLBACK_LINK_FOREGROUND);
        this.linkForeground = color.handle;
        return color;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    Rectangle[] getRectanglesInPixels(int n2) {
        int n3 = this.layout.getLineCount();
        Rectangle[] rectangleArray = new Rectangle[n3];
        int[] nArray = this.layout.getLineOffsets();
        Point point = this.offsets[n2];
        int n4 = 1;
        while (point.x > nArray[n4]) {
            ++n4;
        }
        int n5 = 1;
        while (point.y > nArray[n5]) {
            ++n5;
        }
        int n6 = 0;
        if (n4 == n5) {
            rectangleArray[n6++] = DPIUtil.autoScaleUp(this.layout.getBounds(point.x, point.y));
        } else {
            rectangleArray[n6++] = DPIUtil.autoScaleUp(this.layout.getBounds(point.x, nArray[n4] - 1));
            rectangleArray[n6++] = DPIUtil.autoScaleUp(this.layout.getBounds(nArray[n5 - 1], point.y));
            if (n5 - n4 > 1) {
                for (int i2 = n4; i2 < n5 - 1; ++i2) {
                    rectangleArray[n6++] = DPIUtil.autoScaleUp(this.layout.getLineBounds(i2));
                }
            }
        }
        if (rectangleArray.length != n6) {
            Rectangle[] rectangleArray2 = new Rectangle[n6];
            System.arraycopy(rectangleArray, 0, rectangleArray2, 0, n6);
            rectangleArray = rectangleArray2;
        }
        return rectangleArray;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    @Override
    boolean mnemonicHit(char c2) {
        if (this.mnemonics != null) {
            char c3 = Character.toUpperCase(c2);
            String string = this.parse(this.text);
            for (int i2 = 0; i2 < this.mnemonics.length - 1; ++i2) {
                char c4;
                if (this.mnemonics[i2] == -1 || c3 != Character.toUpperCase(c4 = string.charAt(this.mnemonics[i2]))) continue;
                if (!this.setFocus()) {
                    return false;
                }
                if (this.useCommonControl()) {
                    int n2 = OS.GetWindowLong(this.handle, -16);
                    LITEM lITEM = new LITEM();
                    lITEM.mask = 3;
                    lITEM.stateMask = 1;
                    while (lITEM.iLink < this.mnemonics.length) {
                        if (lITEM.iLink != i2) {
                            OS.SendMessage(this.handle, 1794, 0, lITEM);
                        }
                        ++lITEM.iLink;
                    }
                    lITEM.iLink = i2;
                    lITEM.state = 1;
                    OS.SendMessage(this.handle, 1794, 0, lITEM);
                    OS.SetWindowLong(this.handle, -16, n2);
                } else {
                    this.focusIndex = i2;
                    this.redraw();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    boolean mnemonicMatch(char c2) {
        if (this.mnemonics != null) {
            char c3 = Character.toUpperCase(c2);
            String string = this.parse(this.text);
            for (int i2 = 0; i2 < this.mnemonics.length - 1; ++i2) {
                char c4;
                if (this.mnemonics[i2] == -1 || c3 != Character.toUpperCase(c4 = string.charAt(this.mnemonics[i2]))) continue;
                return true;
            }
        }
        return false;
    }

    String parse(String string) {
        int n2;
        int n3;
        int n4 = string.length();
        this.offsets = new Point[n4 / 4];
        this.ids = new String[n4 / 4];
        this.mnemonics = new int[n4 / 4 + 1];
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[n4];
        string.getChars(0, string.length(), cArray, 0);
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        block22: for (int i2 = 0; i2 < n4; ++i2) {
            n3 = Character.toLowerCase(cArray[i2]);
            switch (n5) {
                case 0: {
                    if (n3 != 60) continue block22;
                    n8 = i2;
                    ++n5;
                    continue block22;
                }
                case 1: {
                    if (n3 != 97) continue block22;
                    ++n5;
                    continue block22;
                }
                case 2: {
                    switch (n3) {
                        case 104: {
                            n5 = 7;
                            continue block22;
                        }
                        case 62: {
                            n9 = i2 + 1;
                            ++n5;
                            continue block22;
                        }
                    }
                    if (Character.isWhitespace((char)n3)) continue block22;
                    n5 = 13;
                    continue block22;
                }
                case 3: {
                    if (n3 != 60) continue block22;
                    n10 = i2;
                    ++n5;
                    continue block22;
                }
                case 4: {
                    n5 = n3 == 47 ? n5 + 1 : 3;
                    continue block22;
                }
                case 5: {
                    n5 = n3 == 97 ? n5 + 1 : 3;
                    continue block22;
                }
                case 6: {
                    if (n3 == 62) {
                        this.mnemonics[n6] = this.parseMnemonics(cArray, n7, n8, stringBuffer);
                        n2 = stringBuffer.length();
                        this.parseMnemonics(cArray, n9, n10, stringBuffer);
                        this.offsets[n6] = new Point(n2, stringBuffer.length() - 1);
                        if (this.ids[n6] == null) {
                            this.ids[n6] = new String(cArray, n9, n10 - n9);
                        }
                        ++n6;
                        n10 = n11 = i2 + 1;
                        n9 = n11;
                        n8 = n11;
                        n7 = n11;
                        n5 = 0;
                        continue block22;
                    }
                    n5 = 3;
                    continue block22;
                }
                case 7: {
                    n5 = n3 == 114 ? n5 + 1 : 0;
                    continue block22;
                }
                case 8: {
                    n5 = n3 == 101 ? n5 + 1 : 0;
                    continue block22;
                }
                case 9: {
                    n5 = n3 == 102 ? n5 + 1 : 0;
                    continue block22;
                }
                case 10: {
                    n5 = n3 == 61 ? n5 + 1 : 0;
                    continue block22;
                }
                case 11: {
                    if (n3 == 34) {
                        ++n5;
                        n11 = i2 + 1;
                        continue block22;
                    }
                    n5 = 0;
                    continue block22;
                }
                case 12: {
                    if (n3 != 34) continue block22;
                    this.ids[n6] = new String(cArray, n11, i2 - n11);
                    n5 = 2;
                    continue block22;
                }
                case 13: {
                    if (Character.isWhitespace((char)n3)) {
                        n5 = 0;
                        continue block22;
                    }
                    if (n3 != 61) continue block22;
                    ++n5;
                    continue block22;
                }
                case 14: {
                    n5 = n3 == 34 ? n5 + 1 : 0;
                    continue block22;
                }
                case 15: {
                    if (n3 != 34) continue block22;
                    n5 = 2;
                    continue block22;
                }
                default: {
                    n5 = 0;
                }
            }
        }
        if (n7 < n4) {
            n3 = this.parseMnemonics(cArray, n7, n8, stringBuffer);
            n2 = this.parseMnemonics(cArray, Math.max(n8, n9), n4, stringBuffer);
            if (n2 == -1) {
                n2 = n3;
            }
            this.mnemonics[n6] = n2;
        } else {
            this.mnemonics[n6] = -1;
        }
        if (this.offsets.length != n6) {
            Point[] pointArray = new Point[n6];
            System.arraycopy(this.offsets, 0, pointArray, 0, n6);
            this.offsets = pointArray;
            String[] stringArray = new String[n6];
            System.arraycopy(this.ids, 0, stringArray, 0, n6);
            this.ids = stringArray;
            int[] nArray = new int[n6 + 1];
            System.arraycopy(this.mnemonics, 0, nArray, 0, n6 + 1);
            this.mnemonics = nArray;
        }
        return stringBuffer.toString();
    }

    int parseMnemonics(char[] cArray, int n2, int n3, StringBuffer stringBuffer) {
        int n4 = -1;
        for (int i2 = n2; i2 < n3; ++i2) {
            if (cArray[i2] == '&') {
                if (i2 + 1 < n3 && cArray[i2 + 1] == '&') {
                    stringBuffer.append(cArray[i2]);
                    ++i2;
                    continue;
                }
                n4 = stringBuffer.length();
                continue;
            }
            stringBuffer.append(cArray[i2]);
        }
        return n4;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.layout != null) {
            this.layout.dispose();
        }
        this.layout = null;
        this.disabledColor = null;
        this.offsets = null;
        this.ids = null;
        this.mnemonics = null;
        this.text = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setLinkForeground(Color color) {
        this.checkWidget();
        int n2 = -1;
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            n2 = color.handle;
        }
        if (n2 == this.linkForeground) {
            return;
        }
        this.linkForeground = n2;
        if (OS.IsWindowEnabled(this.handle)) {
            this.styleLinkParts(true);
        }
        OS.InvalidateRect(this.handle, null, true);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        if ((this.state & 0x400000) != 0) {
            this.updateTextDirection(0x6000000);
        }
        boolean bl2 = OS.IsWindowEnabled(this.handle);
        String string2 = this.parse(this.text);
        if (Link.isCommonControlAvailable()) {
            if (string.length() == 0) {
                string = " ";
            }
            TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
            OS.SetWindowText(this.handle, tCHAR);
        }
        this.layout.setText(string2);
        this.focusIndex = this.offsets.length > 0 ? 0 : -1;
        this.selection.y = -1;
        this.selection.x = -1;
        int n2 = OS.GetWindowLong(this.handle, -16);
        n2 = this.offsets.length > 0 ? (n2 |= 0x10000) : (n2 &= 0xFFFEFFFF);
        OS.SetWindowLong(this.handle, -16, n2);
        this.styleLinkParts(bl2);
        TextStyle textStyle = new TextStyle(null, null, null);
        textStyle.underline = true;
        for (int i2 = 0; i2 < this.mnemonics.length; ++i2) {
            int n3 = this.mnemonics[i2];
            if (n3 == -1) continue;
            this.layout.setStyle(textStyle, n3, n3);
        }
        if (this.useCommonControl()) {
            this.enableWidget(bl2);
        } else {
            this.redraw();
        }
    }

    @Override
    int resolveTextDirection() {
        return BidiUtil.resolveTextDirection(this.text);
    }

    void styleLinkParts(boolean bl2) {
        TextStyle textStyle = new TextStyle(null, bl2 ? this.internalGetLinkForeground() : this.disabledColor, null);
        textStyle.underline = true;
        for (int i2 = 0; i2 < this.offsets.length; ++i2) {
            Point point = this.offsets[i2];
            this.layout.setStyle(textStyle, point.x, point.y);
        }
    }

    @Override
    boolean updateTextDirection(int n2) {
        if (super.updateTextDirection(n2)) {
            int n3 = 0x6000000;
            this.style &= 0xF7FFFFFF;
            this.style &= ~n3;
            this.style |= n2 & n3;
            this.updateOrientation();
            this.checkMirrored();
            return true;
        }
        return false;
    }

    boolean useCommonControl() {
        return this.useCommonControl(OS.IsWindowEnabled(this.handle));
    }

    boolean useCommonControl(boolean bl2) {
        return this.linkForeground == -1 && !bl2 && Link.isCommonControlAvailable();
    }

    static boolean isCommonControlAvailable() {
        return OS.COMCTL32_MAJOR >= 6;
    }

    @Override
    int widgetStyle() {
        int n2 = super.widgetStyle();
        return n2 | 0x10000;
    }

    @Override
    TCHAR windowClass() {
        return Link.isCommonControlAvailable() ? LinkClass : this.display.windowClass;
    }

    @Override
    int windowProc() {
        return LinkProc != 0 ? LinkProc : this.display.windowProc;
    }

    @Override
    LRESULT WM_CHAR(int n2, int n3) {
        LRESULT lRESULT = super.WM_CHAR(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (!this.useCommonControl()) {
            if (this.focusIndex == -1) {
                return lRESULT;
            }
            switch (n2) {
                case 13: 
                case 32: {
                    Event event = new Event();
                    event.text = this.ids[this.focusIndex];
                    this.sendSelectionEvent(13, event, true);
                    break;
                }
                case 9: {
                    boolean bl2;
                    boolean bl3 = bl2 = OS.GetKeyState(16) >= 0;
                    if (bl2) {
                        if (this.focusIndex >= this.offsets.length - 1) break;
                        ++this.focusIndex;
                        this.redraw();
                        break;
                    }
                    if (this.focusIndex <= 0) break;
                    --this.focusIndex;
                    this.redraw();
                }
            }
        } else {
            switch (n2) {
                case 9: 
                case 13: 
                case 32: {
                    int n4 = this.callWindowProc(this.handle, 256, n2, n3);
                    return new LRESULT(n4);
                }
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_GETDLGCODE(int n2, int n3) {
        boolean bl2;
        int n4;
        int n5;
        LRESULT lRESULT = super.WM_GETDLGCODE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        int n6 = 0;
        if (this.useCommonControl()) {
            LITEM lITEM = new LITEM();
            lITEM.mask = 3;
            lITEM.stateMask = 1;
            n5 = 0;
            while (OS.SendMessage(this.handle, 1795, 0, lITEM) != 0) {
                if ((lITEM.state & 1) != 0) {
                    n5 = lITEM.iLink;
                }
                ++lITEM.iLink;
            }
            n4 = lITEM.iLink;
            n6 = this.callWindowProc(this.handle, 135, n2, n3);
        } else {
            n5 = this.focusIndex;
            n4 = this.offsets.length;
        }
        if (n4 == 0) {
            return new LRESULT(n6 | 0x100);
        }
        boolean bl3 = bl2 = OS.GetKeyState(16) >= 0;
        if (bl2 && n5 < n4 - 1) {
            return new LRESULT(n6 | 2);
        }
        if (!bl2 && n5 > 0) {
            return new LRESULT(n6 | 2);
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_GETFONT(int n2, int n3) {
        LRESULT lRESULT = super.WM_GETFONT(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        int n4 = this.callWindowProc(this.handle, 49, n2, n3);
        if (n4 != 0) {
            return new LRESULT(n4);
        }
        if (this.font == 0) {
            this.font = this.defaultFont();
        }
        return new LRESULT(this.font);
    }

    @Override
    LRESULT WM_KEYDOWN(int n2, int n3) {
        LRESULT lRESULT = super.WM_KEYDOWN(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.useCommonControl()) {
            switch (n2) {
                case 9: 
                case 13: 
                case 32: {
                    return LRESULT.ZERO;
                }
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_KILLFOCUS(int n2, int n3) {
        LRESULT lRESULT = super.WM_KILLFOCUS(n2, n3);
        if (!this.useCommonControl()) {
            this.redraw();
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_LBUTTONDOWN(int n2, int n3) {
        LRESULT lRESULT = super.WM_LBUTTONDOWN(n2, n3);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        if (!this.useCommonControl()) {
            if (this.focusIndex != -1) {
                this.setFocus();
            }
            int n4 = OS.GET_X_LPARAM(n3);
            int n5 = OS.GET_Y_LPARAM(n3);
            int n6 = this.layout.getOffset(DPIUtil.autoScaleDown(n4), DPIUtil.autoScaleDown(n5), null);
            int n7 = this.selection.x;
            int n8 = this.selection.y;
            this.selection.x = n6;
            this.selection.y = -1;
            if (n7 != -1 && n8 != -1) {
                if (n7 > n8) {
                    int n9 = n7;
                    n7 = n8;
                    n8 = n9;
                }
                Rectangle rectangle = DPIUtil.autoScaleUp(this.layout.getBounds(n7, n8));
                this.redrawInPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
            }
            for (int i2 = 0; i2 < this.offsets.length; ++i2) {
                Rectangle[] rectangleArray = this.getRectanglesInPixels(i2);
                for (int i3 = 0; i3 < rectangleArray.length; ++i3) {
                    Rectangle rectangle = rectangleArray[i3];
                    if (!rectangle.contains(n4, n5)) continue;
                    if (i2 != this.focusIndex) {
                        this.redraw();
                    }
                    this.focusIndex = this.mouseDownIndex = i2;
                    return lRESULT;
                }
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_LBUTTONUP(int n2, int n3) {
        LRESULT lRESULT = super.WM_LBUTTONUP(n2, n3);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        if (!this.useCommonControl()) {
            if (this.mouseDownIndex == -1) {
                return lRESULT;
            }
            int n4 = OS.GET_X_LPARAM(n3);
            int n5 = OS.GET_Y_LPARAM(n3);
            Rectangle[] rectangleArray = this.getRectanglesInPixels(this.mouseDownIndex);
            for (int i2 = 0; i2 < rectangleArray.length; ++i2) {
                Rectangle rectangle = rectangleArray[i2];
                if (!rectangle.contains(n4, n5)) continue;
                Event event = new Event();
                event.text = this.ids[this.mouseDownIndex];
                this.sendSelectionEvent(13, event, true);
                break;
            }
        }
        this.mouseDownIndex = -1;
        return lRESULT;
    }

    @Override
    LRESULT WM_NCHITTEST(int n2, int n3) {
        LRESULT lRESULT = super.WM_NCHITTEST(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        return new LRESULT(1);
    }

    @Override
    LRESULT WM_MOUSEMOVE(int n2, int n3) {
        LRESULT lRESULT = super.WM_MOUSEMOVE(n2, n3);
        if (!this.useCommonControl()) {
            int n4 = OS.GET_X_LPARAM(n3);
            int n5 = OS.GET_Y_LPARAM(n3);
            if (OS.GetKeyState(1) < 0) {
                int n6 = this.selection.y;
                this.selection.y = this.layout.getOffset(DPIUtil.autoScaleDown(n4), DPIUtil.autoScaleDown(n5), null);
                if (this.selection.y != n6) {
                    int n7 = this.selection.y;
                    if (n6 > n7) {
                        int n8 = n6;
                        n6 = n7;
                        n7 = n8;
                    }
                    Rectangle rectangle = DPIUtil.autoScaleUp(this.layout.getBounds(n6, n7));
                    this.redrawInPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
                }
            } else {
                for (int i2 = 0; i2 < this.offsets.length; ++i2) {
                    Rectangle[] rectangleArray = this.getRectanglesInPixels(i2);
                    for (int i3 = 0; i3 < rectangleArray.length; ++i3) {
                        Rectangle rectangle = rectangleArray[i3];
                        if (!rectangle.contains(n4, n5)) continue;
                        this.setCursor(this.display.getSystemCursor(21));
                        return lRESULT;
                    }
                }
                this.setCursor(null);
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_PAINT(int n2, int n3) {
        if ((this.state & 0x1000) != 0) {
            return LRESULT.ZERO;
        }
        if (this.useCommonControl()) {
            return super.WM_PAINT(n2, n3);
        }
        PAINTSTRUCT pAINTSTRUCT = new PAINTSTRUCT();
        GCData gCData = new GCData();
        gCData.ps = pAINTSTRUCT;
        gCData.hwnd = this.handle;
        GC gC = this.new_GC(gCData);
        if (gC != null) {
            int n4 = pAINTSTRUCT.right - pAINTSTRUCT.left;
            int n5 = pAINTSTRUCT.bottom - pAINTSTRUCT.top;
            if (n4 != 0 && n5 != 0) {
                RECT rECT = new RECT();
                OS.SetRect(rECT, pAINTSTRUCT.left, pAINTSTRUCT.top, pAINTSTRUCT.right, pAINTSTRUCT.bottom);
                this.drawWidget(gC, rECT);
            }
            gC.dispose();
        }
        return LRESULT.ZERO;
    }

    @Override
    LRESULT WM_PRINTCLIENT(int n2, int n3) {
        LRESULT lRESULT = super.WM_PRINTCLIENT(n2, n3);
        if (!this.useCommonControl()) {
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            GCData gCData = new GCData();
            gCData.device = this.display;
            gCData.foreground = this.getForegroundPixel();
            GC gC = GC.win32_new(n2, gCData);
            this.drawWidget(gC, rECT);
            gC.dispose();
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_SETFOCUS(int n2, int n3) {
        LRESULT lRESULT = super.WM_SETFOCUS(n2, n3);
        if (!this.useCommonControl()) {
            this.redraw();
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_SETFONT(int n2, int n3) {
        this.layout.setFont(Font.win32_new(this.display, n2));
        if (n3 != 0) {
            OS.InvalidateRect(this.handle, null, true);
        }
        this.font = n2;
        return super.WM_SETFONT(this.font, n3);
    }

    @Override
    LRESULT WM_SIZE(int n2, int n3) {
        LRESULT lRESULT = super.WM_SIZE(n2, n3);
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        this.layout.setWidth(DPIUtil.autoScaleDown(rECT.right > 0 ? rECT.right : -1));
        if (!this.useCommonControl()) {
            this.redraw();
        }
        return lRESULT;
    }

    @Override
    LRESULT wmColorChild(int n2, int n3) {
        LRESULT lRESULT = super.wmColorChild(n2, n3);
        if (this.useCommonControl() && !OS.IsWindowEnabled(this.handle)) {
            OS.SetTextColor(n2, OS.GetSysColor(OS.COLOR_GRAYTEXT));
            if (lRESULT == null) {
                int n4 = this.getBackgroundPixel();
                OS.SetBkColor(n2, n4);
                int n5 = this.findBrush(n4, 0);
                return new LRESULT(n5);
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT wmNotifyChild(NMHDR nMHDR, int n2, int n3) {
        if (this.useCommonControl()) {
            switch (nMHDR.code) {
                case -4: 
                case -2: {
                    NMLINK nMLINK = new NMLINK();
                    OS.MoveMemory(nMLINK, n3, NMLINK.sizeof);
                    Event event = new Event();
                    event.text = this.ids[nMLINK.iLink];
                    this.sendSelectionEvent(13, event, true);
                }
            }
        }
        return super.wmNotifyChild(nMHDR, n2, n3);
    }

    static {
        LinkClass = new TCHAR(0, "SysLink", true);
        if (Link.isCommonControlAvailable()) {
            WNDCLASS wNDCLASS = new WNDCLASS();
            OS.GetClassInfo(0, LinkClass, wNDCLASS);
            LinkProc = wNDCLASS.lpfnWndProc;
            int n2 = OS.GetModuleHandle(null);
            int n3 = OS.GetProcessHeap();
            wNDCLASS.hInstance = n2;
            wNDCLASS.style &= 0xFFFFBFFF;
            wNDCLASS.style |= 8;
            int n4 = LinkClass.length() * TCHAR.sizeof;
            int n5 = OS.HeapAlloc(n3, 8, n4);
            OS.MoveMemory(n5, LinkClass, n4);
            wNDCLASS.lpszClassName = n5;
            OS.RegisterClass(wNDCLASS);
            OS.HeapFree(n3, 0, n5);
        } else {
            LinkProc = 0;
        }
    }
}

