/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class List
extends Scrollable {
    static final int INSET = 3;
    static final int ListProc;
    static final TCHAR ListClass;
    boolean addedUCC = false;

    public List(Composite composite, int n2) {
        super(composite, List.checkStyle(n2));
    }

    public void add(String string) {
        TCHAR tCHAR;
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n2 = OS.SendMessage(this.handle, 384, 0, tCHAR = new TCHAR(this.getCodePage(), string, true))) == -1) {
            this.error(14);
        }
        if (n2 == -2) {
            this.error(14);
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(tCHAR, true);
        }
    }

    public void add(String string, int n2) {
        TCHAR tCHAR;
        int n3;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (n2 == -1) {
            this.error(6);
        }
        if ((n3 = OS.SendMessage(this.handle, 385, n2, tCHAR = new TCHAR(this.getCodePage(), string, true))) == -2) {
            this.error(14);
        }
        if (n3 == -1) {
            int n4 = OS.SendMessage(this.handle, 395, 0, 0);
            if (0 <= n2 && n2 <= n4) {
                this.error(14);
            } else {
                this.error(6);
            }
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(tCHAR, true);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    int callWindowProc(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            return 0;
        }
        boolean bl2 = false;
        switch (n3) {
            case 276: 
            case 277: {
                boolean bl3 = bl2 = this.findImageControl() != null && this.getDrawing() && OS.IsWindowVisible(this.handle);
                if (!bl2) break;
                OS.DefWindowProc(this.handle, 11, 0, 0);
            }
        }
        int n6 = OS.CallWindowProc(ListProc, n2, n3, n4, n5);
        switch (n3) {
            case 276: 
            case 277: {
                if (!bl2) break;
                OS.DefWindowProc(this.handle, 11, 1, 0);
                OS.InvalidateRect(this.handle, null, true);
            }
        }
        return n6;
    }

    static int checkStyle(int n2) {
        return List.checkBits(n2, 4, 2, 0, 0, 0, 0);
    }

    @Override
    Point computeSizeInPixels(int n2, int n3, boolean bl2) {
        int n4;
        int n5;
        this.checkWidget();
        int n6 = 0;
        int n7 = 0;
        if (n2 == -1) {
            if ((this.style & 0x100) != 0) {
                n6 = OS.SendMessage(this.handle, 403, 0, 0);
                n6 -= 3;
            } else {
                n5 = OS.SendMessage(this.handle, 395, 0, 0);
                int n8 = 0;
                int n9 = OS.GetDC(this.handle);
                n4 = OS.SendMessage(this.handle, 49, 0, 0);
                if (n4 != 0) {
                    n8 = OS.SelectObject(n9, n4);
                }
                RECT rECT = new RECT();
                int n10 = 3104;
                int n11 = this.getCodePage();
                TCHAR tCHAR = new TCHAR(n11, 65);
                for (int i2 = 0; i2 < n5; ++i2) {
                    int n12;
                    int n13 = OS.SendMessage(this.handle, 394, i2, 0);
                    if (n13 == -1) continue;
                    if (n13 + 1 > tCHAR.length()) {
                        tCHAR = new TCHAR(n11, n13 + 1);
                    }
                    if ((n12 = OS.SendMessage(this.handle, 393, i2, tCHAR)) == -1) continue;
                    OS.DrawText(n9, tCHAR, n13, rECT, n10);
                    n6 = Math.max(n6, rECT.right - rECT.left);
                }
                if (n4 != 0) {
                    OS.SelectObject(n9, n8);
                }
                OS.ReleaseDC(this.handle, n9);
            }
        }
        if (n3 == -1) {
            n5 = OS.SendMessage(this.handle, 395, 0, 0);
            n4 = OS.SendMessage(this.handle, 417, 0, 0);
            n7 = n5 * n4;
        }
        if (n6 == 0) {
            n6 = 64;
        }
        if (n7 == 0) {
            n7 = 64;
        }
        if (n2 != -1) {
            n6 = n2;
        }
        if (n3 != -1) {
            n7 = n3;
        }
        n5 = this.getBorderWidthInPixels();
        n6 += n5 * 2 + 3;
        n7 += n5 * 2;
        if ((this.style & 0x200) != 0) {
            n6 += OS.GetSystemMetrics(2);
        }
        if ((this.style & 0x100) != 0) {
            n7 += OS.GetSystemMetrics(3);
        }
        return new Point(n6, n7);
    }

    @Override
    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    public void deselect(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        if ((this.style & 4) != 0) {
            int n2 = OS.SendMessage(this.handle, 392, 0, 0);
            if (n2 == -1) {
                return;
            }
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (n2 != nArray[i2]) continue;
                OS.SendMessage(this.handle, 390, -1, 0);
                return;
            }
            return;
        }
        for (int i3 = 0; i3 < nArray.length; ++i3) {
            int n3 = nArray[i3];
            if (n3 == -1) continue;
            OS.SendMessage(this.handle, 389, 0, n3);
        }
    }

    public void deselect(int n2) {
        this.checkWidget();
        if (n2 == -1) {
            return;
        }
        if ((this.style & 4) != 0) {
            int n3 = OS.SendMessage(this.handle, 392, 0, 0);
            if (n3 == -1) {
                return;
            }
            if (n3 == n2) {
                OS.SendMessage(this.handle, 390, -1, 0);
            }
            return;
        }
        OS.SendMessage(this.handle, 389, 0, n2);
    }

    public void deselect(int n2, int n3) {
        this.checkWidget();
        if (n2 > n3) {
            return;
        }
        if ((this.style & 4) != 0) {
            int n4 = OS.SendMessage(this.handle, 392, 0, 0);
            if (n4 == -1) {
                return;
            }
            if (n2 <= n4 && n4 <= n3) {
                OS.SendMessage(this.handle, 390, -1, 0);
            }
            return;
        }
        int n5 = OS.SendMessage(this.handle, 395, 0, 0);
        if (n2 < 0 && n3 < 0) {
            return;
        }
        if (n2 >= n5 && n3 >= n5) {
            return;
        }
        n2 = Math.min(n5 - 1, Math.max(0, n2));
        n3 = Math.min(n5 - 1, Math.max(0, n3));
        OS.SendMessage(this.handle, 387, n3, n2);
    }

    public void deselectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.SendMessage(this.handle, 390, -1, 0);
        } else {
            OS.SendMessage(this.handle, 389, 0, -1);
        }
    }

    public int getFocusIndex() {
        int n2;
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 415, 0, 0);
        if (n3 == 0 && (n2 = OS.SendMessage(this.handle, 395, 0, 0)) == 0) {
            return -1;
        }
        return n3;
    }

    public String getItem(int n2) {
        TCHAR tCHAR;
        int n3;
        this.checkWidget();
        int n4 = OS.SendMessage(this.handle, 394, n2, 0);
        if (n4 != -1 && (n3 = OS.SendMessage(this.handle, 393, n2, tCHAR = new TCHAR(this.getCodePage(), n4 + 1))) != -1) {
            return (this.state & 0x400000) != 0 ? tCHAR.toString(1, n4 - 1) : tCHAR.toString(0, n4);
        }
        int n5 = OS.SendMessage(this.handle, 395, 0, 0);
        if (0 <= n2 && n2 < n5) {
            this.error(8);
        }
        this.error(6);
        return "";
    }

    public int getItemCount() {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 395, 0, 0);
        if (n2 == -1) {
            this.error(36);
        }
        return n2;
    }

    public int getItemHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getItemHeightInPixels());
    }

    int getItemHeightInPixels() {
        int n2 = OS.SendMessage(this.handle, 417, 0, 0);
        if (n2 == -1) {
            this.error(11);
        }
        return n2;
    }

    public String[] getItems() {
        this.checkWidget();
        int n2 = this.getItemCount();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = this.getItem(i2);
        }
        return stringArray;
    }

    public String[] getSelection() {
        this.checkWidget();
        int[] nArray = this.getSelectionIndices();
        String[] stringArray = new String[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            stringArray[i2] = this.getItem(nArray[i2]);
        }
        return stringArray;
    }

    public int getSelectionCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int n2 = OS.SendMessage(this.handle, 392, 0, 0);
            if (n2 == -1) {
                return 0;
            }
            return 1;
        }
        int n3 = OS.SendMessage(this.handle, 400, 0, 0);
        if (n3 == -1) {
            this.error(36);
        }
        return n3;
    }

    public int getSelectionIndex() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return OS.SendMessage(this.handle, 392, 0, 0);
        }
        int n2 = OS.SendMessage(this.handle, 400, 0, 0);
        if (n2 == -1) {
            this.error(9);
        }
        if (n2 == 0) {
            return -1;
        }
        int n3 = OS.SendMessage(this.handle, 415, 0, 0);
        int n4 = OS.SendMessage(this.handle, 391, n3, 0);
        if (n4 == -1) {
            this.error(9);
        }
        if (n4 != 0) {
            return n3;
        }
        int[] nArray = new int[1];
        n4 = OS.SendMessage(this.handle, 401, 1, nArray);
        if (n4 != 1) {
            this.error(9);
        }
        return nArray[0];
    }

    public int[] getSelectionIndices() {
        int[] nArray;
        int n2;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int n3 = OS.SendMessage(this.handle, 392, 0, 0);
            if (n3 == -1) {
                return new int[0];
            }
            return new int[]{n3};
        }
        int n4 = OS.SendMessage(this.handle, 400, 0, 0);
        if (n4 == -1) {
            this.error(9);
        }
        if ((n2 = OS.SendMessage(this.handle, 401, n4, nArray = new int[n4])) != n4) {
            this.error(9);
        }
        return nArray;
    }

    public int getTopIndex() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 398, 0, 0);
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n2) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.length() == 0) {
            int n3 = this.getItemCount();
            for (int i2 = n2; i2 < n3; ++i2) {
                if (!string.equals(this.getItem(i2))) continue;
                return i2;
            }
            return -1;
        }
        int n4 = OS.SendMessage(this.handle, 395, 0, 0);
        if (0 > n2 || n2 >= n4) {
            return -1;
        }
        int n5 = n2 - 1;
        TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
        do {
            int n6;
            if ((n5 = OS.SendMessage(this.handle, 418, n6 = n5, tCHAR)) != -1 && n5 > n6) continue;
            return -1;
        } while (!string.equals(this.getItem(n5)));
        return n5;
    }

    public boolean isSelected(int n2) {
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 391, n2, 0);
        return n3 != 0 && n3 != -1;
    }

    public void remove(int[] nArray) {
        int n2;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.sort(nArray2);
        int n3 = nArray2[nArray2.length - 1];
        int n4 = nArray2[0];
        int n5 = OS.SendMessage(this.handle, 395, 0, 0);
        if (0 > n3 || n3 > n4 || n4 >= n5) {
            this.error(6);
        }
        int n6 = OS.SendMessage(this.handle, 398, 0, 0);
        RECT rECT = null;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        if ((this.style & 0x100) != 0) {
            rECT = new RECT();
            n7 = OS.GetDC(this.handle);
            n9 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n9 != 0) {
                n8 = OS.SelectObject(n7, n9);
            }
        }
        int n11 = this.getCodePage();
        int n12 = 0;
        int n13 = -1;
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            int n14;
            int n15;
            int n16 = nArray2[n2];
            if (n16 == n13) continue;
            TCHAR tCHAR = null;
            if ((this.style & 0x100) != 0 && ((n15 = OS.SendMessage(this.handle, 394, n16, 0)) == -1 || (n14 = OS.SendMessage(this.handle, 393, n16, tCHAR = new TCHAR(n11, n15 + 1))) == -1) || (n15 = OS.SendMessage(this.handle, 386, n16, 0)) == -1) break;
            if ((this.style & 0x100) != 0) {
                n14 = 3104;
                OS.DrawText(n7, tCHAR, -1, rECT, n14);
                n10 = Math.max(n10, rECT.right - rECT.left);
            }
            if (n16 < n6) {
                ++n12;
            }
            n13 = n16;
        }
        if ((this.style & 0x100) != 0) {
            if (n9 != 0) {
                OS.SelectObject(n7, n8);
            }
            OS.ReleaseDC(this.handle, n7);
            this.setScrollWidth(n10, false);
        }
        if (n12 > 0) {
            n6 -= n12;
        }
        OS.SendMessage(this.handle, 407, n6, 0);
        if (n2 < nArray2.length) {
            this.error(15);
        }
    }

    public void remove(int n2) {
        int n3;
        int n4;
        int n5;
        this.checkWidget();
        TCHAR tCHAR = null;
        if ((this.style & 0x100) != 0) {
            n5 = OS.SendMessage(this.handle, 394, n2, 0);
            if (n5 == -1) {
                n4 = OS.SendMessage(this.handle, 395, 0, 0);
                if (0 <= n2 && n2 < n4) {
                    this.error(15);
                }
                this.error(6);
            }
            if ((n4 = OS.SendMessage(this.handle, 393, n2, tCHAR = new TCHAR(this.getCodePage(), n5 + 1))) == -1) {
                n3 = OS.SendMessage(this.handle, 395, 0, 0);
                if (0 <= n2 && n2 < n3) {
                    this.error(15);
                }
                this.error(6);
            }
        }
        n5 = OS.SendMessage(this.handle, 398, 0, 0);
        n4 = OS.SendMessage(this.handle, 386, n2, 0);
        if (n4 == -1) {
            n3 = OS.SendMessage(this.handle, 395, 0, 0);
            if (0 <= n2 && n2 < n3) {
                this.error(15);
            }
            this.error(6);
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(tCHAR, false);
        }
        if (n2 < n5) {
            --n5;
        }
        OS.SendMessage(this.handle, 407, n5, 0);
    }

    public void remove(int n2, int n3) {
        int n4;
        this.checkWidget();
        if (n2 > n3) {
            return;
        }
        int n5 = OS.SendMessage(this.handle, 395, 0, 0);
        if (0 > n2 || n2 > n3 || n3 >= n5) {
            this.error(6);
        }
        if (n2 == 0 && n3 == n5 - 1) {
            this.removeAll();
            return;
        }
        int n6 = OS.SendMessage(this.handle, 398, 0, 0);
        RECT rECT = null;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        if ((this.style & 0x100) != 0) {
            rECT = new RECT();
            n7 = OS.GetDC(this.handle);
            n9 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n9 != 0) {
                n8 = OS.SelectObject(n7, n9);
            }
        }
        int n11 = this.getCodePage();
        int n12 = 3104;
        for (n4 = n2; n4 <= n3; ++n4) {
            int n13;
            int n14;
            TCHAR tCHAR = null;
            if ((this.style & 0x100) != 0 && ((n14 = OS.SendMessage(this.handle, 394, n2, 0)) == -1 || (n13 = OS.SendMessage(this.handle, 393, n2, tCHAR = new TCHAR(n11, n14 + 1))) == -1) || (n14 = OS.SendMessage(this.handle, 386, n2, 0)) == -1) break;
            if ((this.style & 0x100) == 0) continue;
            OS.DrawText(n7, tCHAR, -1, rECT, n12);
            n10 = Math.max(n10, rECT.right - rECT.left);
        }
        if ((this.style & 0x100) != 0) {
            if (n9 != 0) {
                OS.SelectObject(n7, n8);
            }
            OS.ReleaseDC(this.handle, n7);
            this.setScrollWidth(n10, false);
        }
        if (n3 < n6) {
            n6 -= n3 - n2 + 1;
        }
        OS.SendMessage(this.handle, 407, n6, 0);
        if (n4 <= n3) {
            this.error(15);
        }
    }

    public void remove(String string) {
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n2 = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(n2);
    }

    public void removeAll() {
        this.checkWidget();
        OS.SendMessage(this.handle, 388, 0, 0);
        if ((this.style & 0x100) != 0) {
            OS.SendMessage(this.handle, 404, 0, 0);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void select(int[] nArray) {
        int n2;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if ((n2 = nArray.length) == 0 || (this.style & 4) != 0 && n2 > 1) {
            return;
        }
        this.select(nArray, false);
    }

    void select(int[] nArray, boolean bl2) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            if (n2 == -1) continue;
            this.select(n2, false);
        }
        if (bl2) {
            this.showSelection();
        }
    }

    public void select(int n2) {
        this.checkWidget();
        this.select(n2, false);
    }

    void select(int n2, boolean bl2) {
        boolean bl3;
        if (n2 < 0) {
            return;
        }
        int n3 = OS.SendMessage(this.handle, 395, 0, 0);
        if (n2 >= n3) {
            return;
        }
        if (bl2) {
            if ((this.style & 4) != 0) {
                OS.SendMessage(this.handle, 390, n2, 0);
            } else {
                OS.SendMessage(this.handle, 389, 1, n2);
            }
            return;
        }
        int n4 = OS.SendMessage(this.handle, 398, 0, 0);
        RECT rECT = new RECT();
        RECT rECT2 = null;
        OS.SendMessage(this.handle, 408, n2, rECT);
        boolean bl4 = bl3 = this.getDrawing() && OS.IsWindowVisible(this.handle);
        if (bl3) {
            OS.UpdateWindow(this.handle);
            OS.SendMessage(this.handle, 11, 0, 0);
        }
        int n5 = -1;
        if ((this.style & 4) != 0) {
            int n6 = OS.SendMessage(this.handle, 392, 0, 0);
            if (n6 != -1) {
                rECT2 = new RECT();
                OS.SendMessage(this.handle, 408, n6, rECT2);
            }
            OS.SendMessage(this.handle, 390, n2, 0);
        } else {
            n5 = OS.SendMessage(this.handle, 415, 0, 0);
            OS.SendMessage(this.handle, 389, 1, n2);
        }
        if ((this.style & 2) != 0 && n5 != -1) {
            OS.SendMessage(this.handle, 414, n5, 0);
        }
        OS.SendMessage(this.handle, 407, n4, 0);
        if (bl3) {
            OS.SendMessage(this.handle, 11, 1, 0);
            OS.ValidateRect(this.handle, null);
            OS.InvalidateRect(this.handle, rECT, true);
            if (rECT2 != null) {
                OS.InvalidateRect(this.handle, rECT2, true);
            }
        }
    }

    public void select(int n2, int n3) {
        this.checkWidget();
        if (n3 < 0 || n2 > n3 || (this.style & 4) != 0 && n2 != n3) {
            return;
        }
        int n4 = OS.SendMessage(this.handle, 395, 0, 0);
        if (n4 == 0 || n2 >= n4) {
            return;
        }
        n2 = Math.max(0, n2);
        n3 = Math.min(n3, n4 - 1);
        if ((this.style & 4) != 0) {
            this.select(n2, false);
        } else {
            this.select(n2, n3, false);
        }
    }

    void select(int n2, int n3, boolean bl2) {
        if (n2 == n3) {
            this.select(n2, bl2);
            return;
        }
        OS.SendMessage(this.handle, 387, n2, n3);
        if (bl2) {
            this.showSelection();
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        OS.SendMessage(this.handle, 389, 1, -1);
    }

    void setFocusIndex(int n2) {
        int n3 = OS.SendMessage(this.handle, 395, 0, 0);
        if (0 > n2 || n2 >= n3) {
            return;
        }
        OS.SendMessage(this.handle, 414, n2, 0);
    }

    @Override
    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth();
        }
    }

    public void setItem(int n2, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n3 = this.getTopIndex();
        boolean bl2 = this.isSelected(n2);
        this.remove(n2);
        this.add(string, n2);
        if (bl2) {
            this.select(n2, false);
        }
        this.setTopIndex(n3);
    }

    public void setItems(String ... stringArray) {
        String string;
        TCHAR tCHAR;
        int n2;
        int n3;
        boolean bl2;
        int n4;
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        for (n4 = 0; n4 < stringArray.length; ++n4) {
            if (stringArray[n4] != null) continue;
            this.error(5);
        }
        n4 = OS.GetWindowLongPtr(this.handle, -4);
        OS.SetWindowLongPtr(this.handle, -4, ListProc);
        boolean bl3 = bl2 = this.getDrawing() && OS.IsWindowVisible(this.handle);
        if (bl2) {
            OS.SendMessage(this.handle, 11, 0, 0);
        }
        RECT rECT = null;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if ((this.style & 0x100) != 0) {
            rECT = new RECT();
            n5 = OS.GetDC(this.handle);
            n7 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n7 != 0) {
                n6 = OS.SelectObject(n5, n7);
            }
            OS.SendMessage(this.handle, 404, 0, 0);
        }
        int n9 = stringArray.length;
        OS.SendMessage(this.handle, 388, 0, 0);
        OS.SendMessage(this.handle, 424, n9, n9 * 32);
        int n10 = this.getCodePage();
        for (n3 = 0; n3 < n9 && (n2 = OS.SendMessage(this.handle, 384, 0, tCHAR = new TCHAR(n10, string = stringArray[n3], true))) != -1 && n2 != -2; ++n3) {
            if ((this.style & 0x100) == 0) continue;
            int n11 = 3104;
            OS.DrawText(n5, tCHAR, -1, rECT, n11);
            n8 = Math.max(n8, rECT.right - rECT.left);
        }
        if ((this.style & 0x100) != 0) {
            if (n7 != 0) {
                OS.SelectObject(n5, n6);
            }
            OS.ReleaseDC(this.handle, n5);
            OS.SendMessage(this.handle, 404, n8 + 3, 0);
        }
        if (bl2) {
            OS.SendMessage(this.handle, 11, 1, 0);
        }
        OS.SetWindowLongPtr(this.handle, -4, n4);
        if (n3 < stringArray.length) {
            this.error(14);
        }
    }

    void setScrollWidth() {
        int n2 = 0;
        RECT rECT = new RECT();
        int n3 = 0;
        int n4 = OS.GetDC(this.handle);
        int n5 = OS.SendMessage(this.handle, 49, 0, 0);
        if (n5 != 0) {
            n3 = OS.SelectObject(n4, n5);
        }
        int n6 = this.getCodePage();
        int n7 = OS.SendMessage(this.handle, 395, 0, 0);
        int n8 = 3104;
        for (int i2 = 0; i2 < n7; ++i2) {
            TCHAR tCHAR;
            int n9;
            int n10 = OS.SendMessage(this.handle, 394, i2, 0);
            if (n10 == -1 || (n9 = OS.SendMessage(this.handle, 393, i2, tCHAR = new TCHAR(n6, n10 + 1))) == -1) continue;
            OS.DrawText(n4, tCHAR, -1, rECT, n8);
            n2 = Math.max(n2, rECT.right - rECT.left);
        }
        if (n5 != 0) {
            OS.SelectObject(n4, n3);
        }
        OS.ReleaseDC(this.handle, n4);
        OS.SendMessage(this.handle, 404, n2 + 3, 0);
    }

    void setScrollWidth(TCHAR tCHAR, boolean bl2) {
        RECT rECT = new RECT();
        int n2 = 0;
        int n3 = OS.GetDC(this.handle);
        int n4 = OS.SendMessage(this.handle, 49, 0, 0);
        if (n4 != 0) {
            n2 = OS.SelectObject(n3, n4);
        }
        int n5 = 3104;
        OS.DrawText(n3, tCHAR, -1, rECT, n5);
        if (n4 != 0) {
            OS.SelectObject(n3, n2);
        }
        OS.ReleaseDC(this.handle, n3);
        this.setScrollWidth(rECT.right - rECT.left, bl2);
    }

    void setScrollWidth(int n2, boolean bl2) {
        n2 += 3;
        int n3 = OS.SendMessage(this.handle, 403, 0, 0);
        if (bl2) {
            if (n2 <= n3) {
                return;
            }
            OS.SendMessage(this.handle, 404, n2, 0);
        } else {
            if (n2 < n3) {
                return;
            }
            this.setScrollWidth();
        }
    }

    public void setSelection(int[] nArray) {
        int n2;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n3 = nArray.length;
        if (n3 == 0 || (this.style & 4) != 0 && n3 > 1) {
            return;
        }
        this.select(nArray, true);
        if ((this.style & 2) != 0 && (n2 = nArray[0]) >= 0) {
            this.setFocusIndex(n2);
        }
    }

    public void setSelection(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n2 = stringArray.length;
        if (n2 == 0 || (this.style & 4) != 0 && n2 > 1) {
            return;
        }
        int n3 = -1;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            String string = stringArray[i2];
            int n4 = 0;
            if (string == null) continue;
            int n5 = -1;
            while ((n4 = this.indexOf(string, n4)) != -1) {
                if (n5 == -1) {
                    n5 = n4;
                }
                this.select(n4, false);
                if ((this.style & 4) != 0 && this.isSelected(n4)) {
                    this.showSelection();
                    return;
                }
                ++n4;
            }
            if (n5 == -1) continue;
            n3 = n5;
        }
        if ((this.style & 2) != 0 && n3 >= 0) {
            this.setFocusIndex(n3);
        }
    }

    public void setSelection(int n2) {
        this.checkWidget();
        this.deselectAll();
        this.select(n2, true);
        if ((this.style & 2) != 0 && n2 >= 0) {
            this.setFocusIndex(n2);
        }
    }

    public void setSelection(int n2, int n3) {
        this.checkWidget();
        this.deselectAll();
        if (n3 < 0 || n2 > n3 || (this.style & 4) != 0 && n2 != n3) {
            return;
        }
        int n4 = OS.SendMessage(this.handle, 395, 0, 0);
        if (n4 == 0 || n2 >= n4) {
            return;
        }
        n2 = Math.max(0, n2);
        n3 = Math.min(n3, n4 - 1);
        if ((this.style & 4) != 0) {
            this.select(n2, true);
        } else {
            this.select(n2, n3, true);
            this.setFocusIndex(n2);
        }
    }

    public void setTopIndex(int n2) {
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 407, n2, 0);
        if (n3 == -1) {
            int n4 = OS.SendMessage(this.handle, 395, 0, 0);
            n2 = Math.min(n4 - 1, Math.max(0, n2));
            OS.SendMessage(this.handle, 407, n2, 0);
        }
    }

    public void showSelection() {
        int n2;
        int n3;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            n3 = OS.SendMessage(this.handle, 392, 0, 0);
        } else {
            int[] nArray = new int[1];
            n2 = OS.SendMessage(this.handle, 401, 1, nArray);
            n3 = nArray[0];
            if (n2 != 1) {
                n3 = -1;
            }
        }
        if (n3 == -1) {
            return;
        }
        int n4 = OS.SendMessage(this.handle, 395, 0, 0);
        if (n4 == 0) {
            return;
        }
        n2 = OS.SendMessage(this.handle, 417, 0, 0);
        this.forceResize();
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        int n5 = OS.SendMessage(this.handle, 398, 0, 0);
        int n6 = Math.max(rECT.bottom / n2, 1);
        int n7 = Math.min(n5 + n6, n4) - 1;
        if (n5 <= n3 && n3 <= n7) {
            return;
        }
        int n8 = Math.min(Math.max(n3 - n6 / 2, 0), n4 - 1);
        OS.SendMessage(this.handle, 407, n8, 0);
    }

    @Override
    void updateMenuLocation(Event event) {
        Object object;
        Rectangle rectangle = this.getClientAreaInPixels();
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = this.getFocusIndex();
        if (n4 != -1) {
            object = new RECT();
            int n5 = 0;
            int n6 = OS.GetDC(this.handle);
            int n7 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n7 != 0) {
                n5 = OS.SelectObject(n6, n7);
            }
            int n8 = 3104;
            int n9 = this.getCodePage();
            TCHAR tCHAR = new TCHAR(n9, 65);
            int n10 = OS.SendMessage(this.handle, 394, n4, 0);
            if (n10 != -1) {
                int n11;
                if (n10 + 1 > tCHAR.length()) {
                    tCHAR = new TCHAR(n9, n10 + 1);
                }
                if ((n11 = OS.SendMessage(this.handle, 393, n4, tCHAR)) != -1) {
                    OS.DrawText(n6, tCHAR, n10, (RECT)object, n8);
                }
            }
            if (n7 != 0) {
                OS.SelectObject(n6, n5);
            }
            OS.ReleaseDC(this.handle, n6);
            n2 = Math.max(n2, ((RECT)object).right / 2);
            n2 = Math.min(n2, rectangle.x + rectangle.width);
            OS.SendMessage(this.handle, 408, n4, (RECT)object);
            n3 = Math.max(n3, ((RECT)object).bottom);
            n3 = Math.min(n3, rectangle.y + rectangle.height);
        }
        object = this.toDisplayInPixels(n2, n3);
        event.setLocationInPixels(((Point)object).x, ((Point)object).y);
    }

    @Override
    boolean updateTextDirection(int n2) {
        int n3;
        if (n2 == 0x6000000) {
            if (!OS.IsUnicode || (this.state & 0x400000) != 0) {
                return false;
            }
            this.state |= 0x400000;
        } else {
            this.state &= 0xFFBFFFFF;
            if (!this.addedUCC) {
                return super.updateTextDirection(n2);
            }
        }
        int n4 = OS.SendMessage(this.handle, 395, 0, 0);
        if (n4 == -1) {
            return false;
        }
        int n5 = OS.SendMessage(this.handle, 392, 0, 0);
        int n6 = this.getCodePage();
        this.addedUCC = false;
        while (n4-- > 0 && (n3 = OS.SendMessage(this.handle, 394, n4, 0)) != -1) {
            if (n3 == 0) continue;
            TCHAR tCHAR = new TCHAR(n6, n3 + 1);
            if (OS.SendMessage(this.handle, 393, n4, tCHAR) == -1 || OS.SendMessage(this.handle, 386, n4, 0) == -1) break;
            if ((this.state & 0x400000) == 0) {
                char[] cArray = new char[n3 - 1];
                System.arraycopy(tCHAR.chars, 1, cArray, 0, n3 - 1);
                tCHAR = new TCHAR(n6, cArray, true);
            }
            if (OS.SendMessage(this.handle, 385, n4, tCHAR) != -1) continue;
            break;
        }
        if (n5 != -1) {
            OS.SendMessage(this.handle, 390, n5, 0);
        }
        return n2 == 0x6000000 || super.updateTextDirection(n2);
    }

    @Override
    int widgetStyle() {
        int n2 = super.widgetStyle() | 1 | 0x100;
        if ((this.style & 4) != 0) {
            return n2;
        }
        if ((this.style & 2) != 0) {
            if ((this.style & 0x40) != 0) {
                return n2 | 8;
            }
            return n2 | 0x800;
        }
        return n2;
    }

    @Override
    TCHAR windowClass() {
        return ListClass;
    }

    @Override
    int windowProc() {
        return ListProc;
    }

    @Override
    int windowProc(int n2, int n3, int n4, int n5) {
        if (OS.IsUnicode && this.handle != 0 && n5 != 0 && (this.state & 0x400000) != 0) {
            switch (n3) {
                case 384: 
                case 385: 
                case 418: {
                    int n6 = OS.wcslen(n5);
                    int n7 = this.getCodePage();
                    TCHAR tCHAR = new TCHAR(n7, n6);
                    OS.MoveMemory(tCHAR, n5, tCHAR.length() * TCHAR.sizeof);
                    String string = tCHAR.toString(0, n6);
                    int n8 = BidiUtil.resolveTextDirection(string);
                    if (n8 == 0) {
                        n8 = (this.style & 0x4000000) != 0 ? 0x4000000 : 0x2000000;
                    }
                    string = (n8 == 0x4000000 ? (char)'\u202b' : '\u202a') + string;
                    tCHAR = new TCHAR(n7, string, true);
                    int n9 = OS.GetProcessHeap();
                    n6 = tCHAR.length() * TCHAR.sizeof;
                    int n10 = OS.HeapAlloc(n9, 8, n6);
                    OS.MoveMemory(n10, tCHAR, n6);
                    int n11 = super.windowProc(n2, n3, n4, n10);
                    OS.HeapFree(n9, 0, n10);
                    this.addedUCC = true;
                    return n11;
                }
            }
        }
        return super.windowProc(n2, n3, n4, n5);
    }

    @Override
    LRESULT WM_CHAR(int n2, int n3) {
        int n4;
        LRESULT lRESULT = super.WM_CHAR(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.GetKeyState(17) < 0 && OS.GetKeyState(16) >= 0 && ((n4 = OS.GetWindowLong(this.handle, -16)) & 0x800) != 0) {
            switch (n2) {
                case 32: {
                    int n5 = OS.SendMessage(this.handle, 415, 0, 0);
                    int n6 = OS.SendMessage(this.handle, 391, n5, 0);
                    if (n6 == -1) break;
                    OS.SendMessage(this.handle, 389, n6 != 0 ? 0 : 1, n5);
                    OS.SendMessage(this.handle, 61852, n5, 0);
                    this.sendSelectionEvent(13);
                    return LRESULT.ZERO;
                }
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_KEYDOWN(int n2, int n3) {
        int n4;
        LRESULT lRESULT = super.WM_KEYDOWN(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.GetKeyState(17) < 0 && OS.GetKeyState(16) >= 0 && ((n4 = OS.GetWindowLong(this.handle, -16)) & 0x800) != 0) {
            int n5;
            int n6 = -1;
            switch (n2) {
                case 32: {
                    return LRESULT.ZERO;
                }
                case 38: 
                case 40: {
                    n5 = OS.SendMessage(this.handle, 415, 0, 0);
                    n6 = Math.max(0, n5 + (n2 == 38 ? -1 : 1));
                    break;
                }
                case 33: {
                    n5 = OS.SendMessage(this.handle, 398, 0, 0);
                    int n7 = OS.SendMessage(this.handle, 415, 0, 0);
                    if (n7 != n5) {
                        n6 = n5;
                        break;
                    }
                    this.forceResize();
                    RECT rECT = new RECT();
                    OS.GetClientRect(this.handle, rECT);
                    int n8 = OS.SendMessage(this.handle, 417, 0, 0);
                    int n9 = Math.max(2, rECT.bottom / n8);
                    n6 = Math.max(0, n5 - (n9 - 1));
                    break;
                }
                case 34: {
                    n5 = OS.SendMessage(this.handle, 398, 0, 0);
                    int n7 = OS.SendMessage(this.handle, 415, 0, 0);
                    this.forceResize();
                    RECT rECT = new RECT();
                    OS.GetClientRect(this.handle, rECT);
                    int n10 = OS.SendMessage(this.handle, 417, 0, 0);
                    int n11 = Math.max(2, rECT.bottom / n10);
                    int n12 = n5 + n11 - 1;
                    n6 = n7 != n12 ? n12 : n12 + n11 - 1;
                    int n13 = OS.SendMessage(this.handle, 395, 0, 0);
                    if (n13 == -1) break;
                    n6 = Math.min(n13 - 1, n6);
                    break;
                }
                case 36: {
                    n6 = 0;
                    break;
                }
                case 35: {
                    n5 = OS.SendMessage(this.handle, 395, 0, 0);
                    if (n5 == -1) break;
                    n6 = n5 - 1;
                    break;
                }
            }
            if (n6 != -1) {
                n5 = OS.SendMessage(this.handle, 297, 0, 0);
                if ((n5 & 1) != 0) {
                    OS.SendMessage(this.handle, 295, 3, 0);
                    RECT rECT = new RECT();
                    int n14 = OS.SendMessage(this.handle, 415, 0, 0);
                    OS.SendMessage(this.handle, 408, n14, rECT);
                    OS.InvalidateRect(this.handle, rECT, true);
                }
                OS.SendMessage(this.handle, 414, n6, 0);
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_SETREDRAW(int n2, int n3) {
        LRESULT lRESULT = super.WM_SETREDRAW(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        OS.DefWindowProc(this.handle, 11, n2, n3);
        return lRESULT;
    }

    @Override
    LRESULT WM_SIZE(int n2, int n3) {
        int n4 = OS.SendMessage(this.handle, 398, 0, 0);
        LRESULT lRESULT = super.WM_SIZE(n2, n3);
        if (!this.isDisposed()) {
            int n5;
            SCROLLINFO sCROLLINFO = new SCROLLINFO();
            sCROLLINFO.cbSize = SCROLLINFO.sizeof;
            sCROLLINFO.fMask = 4;
            if (OS.GetScrollInfo(this.handle, 0, sCROLLINFO) && sCROLLINFO.nPos != 0) {
                OS.InvalidateRect(this.handle, null, true);
            }
            if (n4 != (n5 = OS.SendMessage(this.handle, 398, 0, 0))) {
                OS.InvalidateRect(this.handle, null, true);
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT wmCommandChild(int n2, int n3) {
        int n4 = OS.HIWORD(n2);
        switch (n4) {
            case 1: {
                this.sendSelectionEvent(13);
                break;
            }
            case 2: {
                this.sendSelectionEvent(14);
            }
        }
        return super.wmCommandChild(n2, n3);
    }

    static {
        ListClass = new TCHAR(0, "LISTBOX", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, ListClass, wNDCLASS);
        ListProc = wNDCLASS.lpfnWndProc;
    }
}

