/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.ACCEL;
import org.eclipse.swt.internal.win32.DRAWITEMSTRUCT;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MEASUREITEMSTRUCT;
import org.eclipse.swt.internal.win32.MENUBARINFO;
import org.eclipse.swt.internal.win32.MENUINFO;
import org.eclipse.swt.internal.win32.MENUITEMINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TBBUTTONINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem$MenuItemToolTip;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.TypedListener;

public class MenuItem
extends Item {
    Menu parent;
    Menu menu;
    int hBitmap;
    int id;
    int accelerator;
    int userId;
    int index;
    ToolTip itemToolTip;
    static final int MARGIN_WIDTH = OS.IsWin95 ? 2 : 1;
    static final int MARGIN_HEIGHT = OS.IsWin95 ? 2 : 1;

    public MenuItem(Menu menu, int n2) {
        super(menu, MenuItem.checkStyle(n2));
        this.parent = menu;
        this.index = menu.getItemCount();
        menu.createItem(this, this.index);
    }

    public MenuItem(Menu menu, int n2, int n3) {
        super(menu, MenuItem.checkStyle(n2));
        this.parent = menu;
        this.index = n3;
        menu.createItem(this, this.index);
    }

    MenuItem(Menu menu, Menu menu2, int n2, int n3) {
        super(menu, MenuItem.checkStyle(n2));
        this.parent = menu;
        this.menu = menu2;
        this.index = n3;
        if (menu2 != null) {
            menu2.cascade = this;
        }
        this.display.addMenuItem(this);
    }

    public void addArmListener(ArmListener armListener) {
        this.checkWidget();
        if (armListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(armListener);
        this.addListener(30, typedListener);
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int n2) {
        return MenuItem.checkBits(n2, 8, 32, 16, 2, 64, 0);
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    boolean fillAccel(ACCEL aCCEL) {
        aCCEL.fVirt = 0;
        aCCEL.cmd = aCCEL.key = (short)0;
        if (this.accelerator == 0 || !this.getEnabled()) {
            return false;
        }
        if ((this.accelerator & 0x400000) != 0) {
            return false;
        }
        boolean bl2 = true;
        int n2 = this.accelerator & 0x100FFFF;
        int n3 = Display.untranslateKey(n2);
        if (n3 != 0) {
            n2 = n3;
        } else {
            switch (n2) {
                case 27: {
                    n2 = 27;
                    break;
                }
                case 127: {
                    n2 = 46;
                    break;
                }
                default: {
                    n2 = Display.wcsToMbcs((char)n2);
                    if (n2 == 0) {
                        return false;
                    }
                    if (OS.IsWinCE) {
                        n2 = OS.CharUpper((short)n2);
                        break;
                    }
                    n3 = OS.VkKeyScan((short)n2);
                    if (n3 == -1) {
                        if (n2 == OS.CharUpper((short)n2)) break;
                        bl2 = false;
                        break;
                    }
                    n2 = n3 & 0xFF;
                }
            }
        }
        aCCEL.key = (short)n2;
        aCCEL.cmd = (short)this.id;
        aCCEL.fVirt = (byte)(bl2 ? 1 : 0);
        if ((this.accelerator & 0x10000) != 0) {
            aCCEL.fVirt = (byte)(aCCEL.fVirt | 0x10);
        }
        if ((this.accelerator & 0x20000) != 0) {
            aCCEL.fVirt = (byte)(aCCEL.fVirt | 4);
        }
        if ((this.accelerator & 0x40000) != 0) {
            aCCEL.fVirt = (byte)(aCCEL.fVirt | 8);
        }
        return true;
    }

    void fixMenus(Decorations decorations) {
        if (this.menu != null) {
            this.menu.fixMenus(decorations);
        }
    }

    public int getAccelerator() {
        this.checkWidget();
        return this.accelerator;
    }

    Rectangle getBounds() {
        this.checkWidget();
        if (OS.IsWinCE) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        if ((this.parent.style & 2) != 0) {
            Decorations decorations = this.parent.parent;
            if (decorations.menuBar != this.parent) {
                return new Rectangle(0, 0, 0, 0);
            }
            int n3 = decorations.handle;
            MENUBARINFO mENUBARINFO = new MENUBARINFO();
            mENUBARINFO.cbSize = MENUBARINFO.sizeof;
            if (!OS.GetMenuBarInfo(n3, -3, 1, mENUBARINFO)) {
                return new Rectangle(0, 0, 0, 0);
            }
            MENUBARINFO mENUBARINFO2 = new MENUBARINFO();
            mENUBARINFO2.cbSize = MENUBARINFO.sizeof;
            if (!OS.GetMenuBarInfo(n3, -3, n2 + 1, mENUBARINFO2)) {
                return new Rectangle(0, 0, 0, 0);
            }
            int n4 = mENUBARINFO2.left - mENUBARINFO.left;
            int n5 = mENUBARINFO2.top - mENUBARINFO.top;
            int n6 = mENUBARINFO2.right - mENUBARINFO2.left;
            int n7 = mENUBARINFO2.bottom - mENUBARINFO2.top;
            return new Rectangle(n4, n5, n6, n7);
        }
        int n8 = this.parent.handle;
        RECT rECT = new RECT();
        if (!OS.GetMenuItemRect(0, n8, 0, rECT)) {
            return new Rectangle(0, 0, 0, 0);
        }
        RECT rECT2 = new RECT();
        if (!OS.GetMenuItemRect(0, n8, n2, rECT2)) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n9 = rECT2.left - rECT.left + 2;
        int n10 = rECT2.top - rECT.top + 2;
        int n11 = rECT2.right - rECT2.left;
        int n12 = rECT2.bottom - rECT2.top;
        return new Rectangle(n9, n10, n11, n12);
    }

    public boolean getEnabled() {
        boolean bl2;
        this.checkWidget();
        if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0) {
            int n2 = this.parent.hwndCB;
            TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
            tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
            tBBUTTONINFO.dwMask = 4;
            OS.SendMessage(n2, OS.TB_GETBUTTONINFO, this.id, tBBUTTONINFO);
            return (tBBUTTONINFO.fsState & 4) != 0;
        }
        if ((this.style & 2) != 0) {
            return (this.state & 8) == 0;
        }
        int n3 = this.parent.handle;
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 1;
        if (OS.IsWinCE) {
            int n4 = this.parent.indexOf(this);
            if (n4 == -1) {
                this.error(31);
            }
            bl2 = OS.GetMenuItemInfo(n3, n4, true, mENUITEMINFO);
        } else {
            bl2 = OS.GetMenuItemInfo(n3, this.id, false, mENUITEMINFO);
        }
        if (!bl2) {
            this.error(31);
        }
        return (mENUITEMINFO.fState & 3) == 0;
    }

    public int getID() {
        this.checkWidget();
        return this.userId;
    }

    @Override
    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    @Override
    String getNameText() {
        if ((this.style & 2) != 0) {
            return "|";
        }
        return super.getNameText();
    }

    public Menu getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0) {
            return false;
        }
        int n2 = this.parent.handle;
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 1;
        boolean bl2 = OS.GetMenuItemInfo(n2, this.id, false, mENUITEMINFO);
        if (!bl2) {
            this.error(9);
        }
        return (mENUITEMINFO.fState & 8) != 0;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.itemToolTip == null ? null : this.itemToolTip.getMessage();
    }

    void hideToolTip() {
        if (this.itemToolTip == null) {
            return;
        }
        this.itemToolTip.setVisible(false);
    }

    public boolean isEnabled() {
        return this.getEnabled() && this.parent.isEnabled();
    }

    @Override
    void releaseChildren(boolean bl2) {
        if (this.menu != null) {
            this.menu.release(false);
            this.menu = null;
        }
        super.releaseChildren(bl2);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
        this.id = -1;
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.hBitmap != 0) {
            OS.DeleteObject(this.hBitmap);
        }
        this.hBitmap = 0;
        if (this.accelerator != 0) {
            this.parent.destroyAccelerators();
        }
        this.accelerator = 0;
        this.display.removeMenuItem(this);
    }

    public void removeArmListener(ArmListener armListener) {
        this.checkWidget();
        if (armListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(30, armListener);
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    @Override
    void reskinChildren(int n2) {
        if (this.menu != null) {
            this.menu.reskin(n2);
        }
        super.reskinChildren(n2);
    }

    void selectRadio() {
        MenuItem[] menuItemArray = this.parent.getItems();
        for (int i2 = 0; i2 < menuItemArray.length && menuItemArray[i2] != this; ++i2) {
        }
        for (int i3 = i2 - 1; i3 >= 0 && menuItemArray[i3].setRadioSelection(false); --i3) {
        }
        for (int i4 = i2 + 1; i4 < menuItemArray.length && menuItemArray[i4].setRadioSelection(false); ++i4) {
        }
        this.setSelection(true);
    }

    public void setAccelerator(int n2) {
        this.checkWidget();
        if (this.accelerator == n2) {
            return;
        }
        this.accelerator = n2;
        this.parent.destroyAccelerators();
    }

    public void setEnabled(boolean bl2) {
        this.checkWidget();
        if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0) {
            int n2 = this.parent.hwndCB;
            TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
            tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
            tBBUTTONINFO.dwMask = 4;
            OS.SendMessage(n2, OS.TB_GETBUTTONINFO, this.id, tBBUTTONINFO);
            tBBUTTONINFO.fsState = (byte)(tBBUTTONINFO.fsState & 0xFFFFFFFB);
            if (bl2) {
                tBBUTTONINFO.fsState = (byte)(tBBUTTONINFO.fsState | 4);
            }
            OS.SendMessage(n2, OS.TB_SETBUTTONINFO, this.id, tBBUTTONINFO);
        } else {
            if ((this.style & 2) != 0) {
                this.state = bl2 ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
            }
            int n3 = this.parent.handle;
            if (OS.IsWinCE) {
                int n4 = this.parent.indexOf(this);
                if (n4 == -1) {
                    return;
                }
                int n5 = 0x400 | (bl2 ? 0 : 1);
                OS.EnableMenuItem(n3, n4, n5);
            } else {
                int n6;
                MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
                mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
                mENUITEMINFO.fMask = 1;
                boolean bl3 = OS.GetMenuItemInfo(n3, this.id, false, mENUITEMINFO);
                if (!bl3) {
                    n6 = OS.GetLastError();
                    SWT.error(30, null, " [GetLastError=0x" + Integer.toHexString(n6) + "]");
                }
                n6 = 3;
                if (bl2) {
                    if ((mENUITEMINFO.fState & n6) == 0) {
                        return;
                    }
                    mENUITEMINFO.fState &= ~n6;
                } else {
                    if ((mENUITEMINFO.fState & n6) == n6) {
                        return;
                    }
                    mENUITEMINFO.fState |= n6;
                }
                bl3 = OS.SetMenuItemInfo(n3, this.id, false, mENUITEMINFO);
                if (!bl3) {
                    if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                        boolean bl4 = bl3 = this.id == OS.GetMenuDefaultItem(n3, 0, 1);
                    }
                    if (!bl3) {
                        int n7 = OS.GetLastError();
                        SWT.error(30, null, " [GetLastError=0x" + Integer.toHexString(n7) + "]");
                    }
                }
            }
        }
        this.parent.destroyAccelerators();
        this.parent.redraw();
    }

    public void setID(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            this.error(5);
        }
        this.userId = n2;
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        if (OS.IsWinCE) {
            if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0) {
                int n2 = this.parent.hwndCB;
                TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
                tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
                tBBUTTONINFO.dwMask = 1;
                tBBUTTONINFO.iImage = this.parent.imageIndex(image);
                OS.SendMessage(n2, OS.TB_SETBUTTONINFO, this.id, tBBUTTONINFO);
            }
            return;
        }
        if (OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return;
        }
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 128;
        if (this.parent.foreground != -1) {
            mENUITEMINFO.hbmpItem = -1;
        } else if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0) && OS.IsAppThemed()) {
            if (this.hBitmap != 0) {
                OS.DeleteObject(this.hBitmap);
            }
            this.hBitmap = image != null ? Display.create32bitDIB(image) : 0;
            mENUITEMINFO.hbmpItem = this.hBitmap;
        } else {
            mENUITEMINFO.hbmpItem = image != null ? -1 : 0;
        }
        int n3 = this.parent.handle;
        OS.SetMenuItemInfo(n3, this.id, false, mENUITEMINFO);
        this.parent.redraw();
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if ((this.style & 0x40) == 0) {
            this.error(27);
        }
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 4) == 0) {
                this.error(21);
            }
            if (menu.parent != this.parent.parent) {
                this.error(32);
            }
        }
        this.setMenu(menu, false);
    }

    void setMenu(Menu menu, boolean bl2) {
        Menu menu2 = this.menu;
        if (menu2 == menu) {
            return;
        }
        if (menu2 != null) {
            menu2.cascade = null;
        }
        this.menu = menu;
        if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0) {
            if (OS.IsPPC) {
                int n2 = this.parent.hwndCB;
                int n3 = menu == null ? 0 : menu.handle;
                OS.SendMessage(n2, 1424, this.id, n3);
            }
            if (OS.IsSP) {
                this.error(29);
            }
        } else {
            int n4;
            int n5 = this.parent.handle;
            MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
            mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
            mENUITEMINFO.fMask = 32;
            int n6 = 0;
            while (OS.GetMenuItemInfo(n5, n6, true, mENUITEMINFO) && mENUITEMINFO.dwItemData != this.id) {
                ++n6;
            }
            if (mENUITEMINFO.dwItemData != this.id) {
                return;
            }
            int n7 = 128;
            int n8 = OS.GetProcessHeap();
            int n9 = n7 * TCHAR.sizeof;
            int n10 = OS.HeapAlloc(n8, 8, n9);
            mENUITEMINFO.fMask = 35;
            mENUITEMINFO.fMask = !OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10) ? (mENUITEMINFO.fMask |= 0xC0) : (mENUITEMINFO.fMask |= 0x10);
            mENUITEMINFO.dwTypeData = n10;
            mENUITEMINFO.cch = n7;
            boolean bl3 = OS.GetMenuItemInfo(n5, n6, true, mENUITEMINFO);
            if (menu != null) {
                menu.cascade = this;
                mENUITEMINFO.fMask |= 4;
                mENUITEMINFO.hSubMenu = menu.handle;
            }
            if (OS.IsWinCE) {
                TCHAR tCHAR;
                OS.RemoveMenu(n5, n6, 1024);
                n4 = this.id;
                int n11 = 1024;
                if (menu != null) {
                    n11 |= 0x10;
                    n4 = menu.handle;
                }
                if (bl3 = OS.InsertMenu(n5, n6, n11, n4, tCHAR = new TCHAR(0, " ", true))) {
                    mENUITEMINFO.fMask = 48;
                    bl3 = OS.SetMenuItemInfo(n5, n6, true, mENUITEMINFO);
                    if ((mENUITEMINFO.fState & 3) != 0) {
                        OS.EnableMenuItem(n5, n6, 1025);
                    }
                    if ((mENUITEMINFO.fState & 8) != 0) {
                        OS.CheckMenuItem(n5, n6, 1032);
                    }
                }
            } else if (bl2 || menu2 == null) {
                bl3 = OS.SetMenuItemInfo(n5, n6, true, mENUITEMINFO);
            } else {
                OS.RemoveMenu(n5, n6, 1024);
                bl3 = OS.InsertMenuItem(n5, n6, true, mENUITEMINFO);
            }
            if (n10 != 0) {
                OS.HeapFree(n8, 0, n10);
            }
            if (!bl3) {
                n4 = OS.GetLastError();
                SWT.error(29, null, " [GetLastError=0x" + Integer.toHexString(n4) + "]");
            }
        }
        this.parent.destroyAccelerators();
    }

    boolean setRadioSelection(boolean bl2) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl2) {
            this.setSelection(bl2);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    void setOrientation(int n2) {
        int n3 = this.parent.handle;
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 256;
        mENUITEMINFO.fType = this.widgetStyle();
        OS.SetMenuItemInfo(n3, this.id, false, mENUITEMINFO);
        if (this.menu != null) {
            this.menu._setOrientation(n2);
        }
    }

    public void setSelection(boolean bl2) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0) {
            return;
        }
        int n2 = this.parent.handle;
        if (OS.IsWinCE) {
            int n3 = this.parent.indexOf(this);
            if (n3 == -1) {
                return;
            }
            int n4 = 0x400 | (bl2 ? 8 : 0);
            OS.CheckMenuItem(n2, n3, n4);
        } else {
            MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
            mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
            mENUITEMINFO.fMask = 1;
            boolean bl3 = OS.GetMenuItemInfo(n2, this.id, false, mENUITEMINFO);
            if (!bl3) {
                this.error(28);
            }
            mENUITEMINFO.fState &= 0xFFFFFFF7;
            if (bl2) {
                mENUITEMINFO.fState |= 8;
            }
            if (!(bl3 = OS.SetMenuItemInfo(n2, this.id, false, mENUITEMINFO))) {
                if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                    boolean bl4 = bl3 = this.id == OS.GetMenuDefaultItem(n2, 0, 1);
                }
                if (!bl3) {
                    int n5 = OS.GetLastError();
                    SWT.error(28, null, " [GetLastError=0x" + Integer.toHexString(n5) + "]");
                }
            }
        }
        this.parent.redraw();
    }

    @Override
    public void setText(String string) {
        Object object;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.text.equals(string)) {
            return;
        }
        super.setText(string);
        int n2 = OS.GetProcessHeap();
        int n3 = 0;
        boolean bl2 = false;
        if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0) {
            int n4;
            if (string.indexOf(38) != -1) {
                int n5 = string.length();
                char[] cArray = new char[n5];
                string.getChars(0, n5, cArray, 0);
                n4 = 0;
                int n6 = 0;
                for (n4 = 0; n4 < n5; ++n4) {
                    if (cArray[n4] == '&') continue;
                    cArray[n6++] = cArray[n4];
                }
                if (n6 < n4) {
                    string = new String(cArray, 0, n6);
                }
            }
            object = new TCHAR(0, string, true);
            int n7 = ((TCHAR)object).length() * TCHAR.sizeof;
            n3 = OS.HeapAlloc(n2, 8, n7);
            OS.MoveMemory(n3, (TCHAR)object, n7);
            n4 = this.parent.hwndCB;
            TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
            tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
            tBBUTTONINFO.dwMask = 2;
            tBBUTTONINFO.pszText = n3;
            bl2 = OS.SendMessage(n4, OS.TB_SETBUTTONINFO, this.id, tBBUTTONINFO) != 0;
        } else {
            object = new MENUITEMINFO();
            ((MENUITEMINFO)object).cbSize = MENUITEMINFO.sizeof;
            int n8 = this.parent.handle;
            TCHAR tCHAR = new TCHAR(0, string, true);
            int n9 = tCHAR.length() * TCHAR.sizeof;
            n3 = OS.HeapAlloc(n2, 8, n9);
            OS.MoveMemory(n3, tCHAR, n9);
            if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
                ((MENUITEMINFO)object).fMask = 64;
            } else {
                ((MENUITEMINFO)object).fMask = 16;
                ((MENUITEMINFO)object).fType = this.widgetStyle();
            }
            ((MENUITEMINFO)object).dwTypeData = n3;
            bl2 = OS.SetMenuItemInfo(n8, this.id, false, (MENUITEMINFO)object);
        }
        if (n3 != 0) {
            OS.HeapFree(n2, 0, n3);
        }
        if (!bl2) {
            int n10 = OS.GetLastError();
            SWT.error(13, null, " [GetLastError=0x" + Integer.toHexString(n10) + "]");
        }
        this.parent.redraw();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        if (string == null && this.itemToolTip != null) {
            this.itemToolTip.setVisible(false);
            this.itemToolTip = null;
        }
        if (string == null || string.trim().length() == 0 || this.itemToolTip != null && string.equals(this.itemToolTip.getMessage())) {
            return;
        }
        this.itemToolTip = new MenuItem$MenuItemToolTip(this.getParent().getShell());
        this.itemToolTip.setMessage(string);
        this.itemToolTip.setVisible(false);
    }

    void showTooltip(int n2, int n3) {
        if (this.itemToolTip == null) {
            return;
        }
        this.itemToolTip.setLocationInPixels(n2, n3);
        this.itemToolTip.setVisible(true);
    }

    int widgetStyle() {
        int n2 = 0;
        Decorations decorations = this.parent.parent;
        if ((decorations.style & 0x8000000) != 0) {
            if ((this.parent.style & 0x2000000) != 0) {
                n2 |= 0x6000;
            }
        } else if ((this.parent.style & 0x4000000) != 0) {
            n2 |= 0x6000;
        }
        if ((this.style & 2) != 0) {
            return n2 | 0x800;
        }
        if ((this.style & 0x10) != 0) {
            return n2 | 0x200;
        }
        return n2 | 0;
    }

    LRESULT wmCommandChild(int n2, int n3) {
        if ((this.style & 0x20) != 0) {
            this.setSelection(!this.getSelection());
        } else if ((this.style & 0x10) != 0) {
            if ((this.parent.getStyle() & 0x400000) != 0) {
                this.setSelection(!this.getSelection());
            } else {
                this.selectRadio();
            }
        }
        this.sendSelectionEvent(13);
        return null;
    }

    LRESULT wmDrawChild(int n2, int n3) {
        DRAWITEMSTRUCT dRAWITEMSTRUCT = new DRAWITEMSTRUCT();
        OS.MoveMemory(dRAWITEMSTRUCT, n3, DRAWITEMSTRUCT.sizeof);
        if (this.image != null) {
            GCData gCData = new GCData();
            gCData.device = this.display;
            GC gC = GC.win32_new(dRAWITEMSTRUCT.hDC, gCData);
            int n4 = (this.parent.style & 2) != 0 ? MARGIN_WIDTH * 2 : dRAWITEMSTRUCT.left;
            Image image = this.getEnabled() ? this.image : new Image((Device)this.display, this.image, 1);
            gC.drawImage(image, DPIUtil.autoScaleDown(n4), DPIUtil.autoScaleDown(dRAWITEMSTRUCT.top + MARGIN_HEIGHT));
            if (this.image != image) {
                image.dispose();
            }
            gC.dispose();
        }
        if (this.parent.foreground != -1) {
            OS.SetTextColor(dRAWITEMSTRUCT.hDC, this.parent.foreground);
        }
        return null;
    }

    LRESULT wmMeasureChild(int n2, int n3) {
        MEASUREITEMSTRUCT mEASUREITEMSTRUCT = new MEASUREITEMSTRUCT();
        OS.MoveMemory(mEASUREITEMSTRUCT, n3, MEASUREITEMSTRUCT.sizeof);
        int n4 = 0;
        int n5 = 0;
        if (this.image != null) {
            Rectangle rectangle = this.image.getBoundsInPixels();
            n4 = rectangle.width;
            n5 = rectangle.height;
        } else {
            MENUINFO mENUINFO = new MENUINFO();
            mENUINFO.cbSize = MENUINFO.sizeof;
            mENUINFO.fMask = 16;
            int n6 = this.parent.handle;
            OS.GetMenuInfo(n6, mENUINFO);
            if ((mENUINFO.dwStyle & 0x4000000) == 0) {
                MenuItem[] menuItemArray = this.parent.getItems();
                for (int i2 = 0; i2 < menuItemArray.length; ++i2) {
                    MenuItem menuItem = menuItemArray[i2];
                    if (menuItem.image == null) continue;
                    Rectangle rectangle = menuItem.image.getBoundsInPixels();
                    n4 = Math.max(n4, rectangle.width);
                }
            }
        }
        if (n4 != 0 || n5 != 0) {
            mEASUREITEMSTRUCT.itemWidth = n4 + MARGIN_WIDTH * 2;
            mEASUREITEMSTRUCT.itemHeight = n5 + MARGIN_HEIGHT * 2;
            OS.MoveMemory(n3, mEASUREITEMSTRUCT, MEASUREITEMSTRUCT.sizeof);
        }
        return null;
    }
}

