/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.HDHITTESTINFO;
import org.eclipse.swt.internal.win32.HDITEM;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.LVCOLUMN;
import org.eclipse.swt.internal.win32.LVHITTESTINFO;
import org.eclipse.swt.internal.win32.LVITEM;
import org.eclipse.swt.internal.win32.MEASUREITEMSTRUCT;
import org.eclipse.swt.internal.win32.NMCUSTOMDRAW;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMHEADER;
import org.eclipse.swt.internal.win32.NMLISTVIEW;
import org.eclipse.swt.internal.win32.NMLVCUSTOMDRAW;
import org.eclipse.swt.internal.win32.NMLVDISPINFO;
import org.eclipse.swt.internal.win32.NMLVODSTATECHANGE;
import org.eclipse.swt.internal.win32.NMRGINFO;
import org.eclipse.swt.internal.win32.NMTTCUSTOMDRAW;
import org.eclipse.swt.internal.win32.NMTTDISPINFO;
import org.eclipse.swt.internal.win32.NMTTDISPINFOA;
import org.eclipse.swt.internal.win32.NMTTDISPINFOW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.internal.win32.SHDRAGIMAGE;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.TOOLINFO;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class Table
extends Composite {
    TableItem[] items;
    int[] keys;
    TableColumn[] columns;
    int columnCount;
    int customCount;
    int keyCount;
    ImageList imageList;
    ImageList headerImageList;
    TableItem currentItem;
    TableColumn sortColumn;
    RECT focusRect;
    int headerToolTipHandle;
    int hwndHeader;
    boolean ignoreCustomDraw;
    boolean ignoreDrawForeground;
    boolean ignoreDrawBackground;
    boolean ignoreDrawFocus;
    boolean ignoreDrawSelection;
    boolean ignoreDrawHot;
    boolean customDraw;
    boolean dragStarted;
    boolean explorerTheme;
    boolean firstColumnImage;
    boolean fixScrollWidth;
    boolean tipRequested;
    boolean wasSelected;
    boolean wasResized;
    boolean painted;
    boolean ignoreActivate;
    boolean ignoreSelect;
    boolean ignoreShrink;
    boolean ignoreResize;
    boolean ignoreColumnMove;
    boolean ignoreColumnResize;
    boolean fullRowSelect;
    boolean settingItemHeight;
    boolean headerItemDragging;
    int itemHeight;
    int lastIndexOf;
    int lastWidth;
    int sortDirection;
    int resizeCount;
    int selectionForeground;
    int hotIndex;
    int headerBackground = -1;
    int headerForeground = -1;
    static int HeaderProc;
    static final int INSET = 4;
    static final int GRID_WIDTH = 1;
    static final int SORT_WIDTH = 10;
    static final int HEADER_MARGIN = 12;
    static final int HEADER_EXTRA = 3;
    static final int VISTA_EXTRA = 2;
    static final int EXPLORER_EXTRA = 2;
    static final int H_SCROLL_LIMIT = 32;
    static final int V_SCROLL_LIMIT = 16;
    static final int DRAG_IMAGE_SIZE = 301;
    static final boolean EXPLORER_THEME = true;
    static boolean COMPRESS_ITEMS;
    static final int TableProc;
    static final TCHAR TableClass;
    static final TCHAR HeaderClass;

    public Table(Composite composite, int n2) {
        super(composite, Table.checkStyle(n2));
    }

    @Override
    void _addListener(int n2, Listener listener) {
        super._addListener(n2, listener);
        switch (n2) {
            case 40: 
            case 41: 
            case 42: {
                this.setCustomDraw(true);
                this.setBackgroundTransparent(true);
                if (OS.COMCTL32_MAJOR < 6) {
                    this.style |= 0x20000000;
                }
                if (!OS.IsWinCE) break;
                OS.SendMessage(this.handle, 4150, 16384, 0);
            }
        }
    }

    boolean _checkGrow(int n2) {
        if (this.keys == null) {
            if (n2 == this.items.length) {
                boolean bl2 = this.getDrawing() && OS.IsWindowVisible(this.handle);
                int n3 = bl2 ? this.items.length + 4 : Math.max(4, this.items.length * 3 / 2);
                TableItem[] tableItemArray = new TableItem[n3];
                System.arraycopy(this.items, 0, tableItemArray, 0, this.items.length);
                this.items = tableItemArray;
            }
        } else {
            if (!this.ignoreShrink && this.keyCount > n2 / 2) {
                boolean bl3 = this.getDrawing() && OS.IsWindowVisible(this.handle);
                int n4 = bl3 ? n2 + 4 : Math.max(4, n2 * 3 / 2);
                TableItem[] tableItemArray = new TableItem[n4];
                for (int i2 = 0; i2 < this.keyCount; ++i2) {
                    tableItemArray[this.keys[i2]] = this.items[i2];
                }
                this.items = tableItemArray;
                this.keys = null;
                this.keyCount = 0;
                return true;
            }
            if (this.keyCount == this.keys.length) {
                boolean bl4 = this.getDrawing() && OS.IsWindowVisible(this.handle);
                int n5 = bl4 ? this.keys.length + 4 : Math.max(4, this.keys.length * 3 / 2);
                int[] nArray = new int[n5];
                System.arraycopy(this.keys, 0, nArray, 0, this.keys.length);
                this.keys = nArray;
                TableItem[] tableItemArray = new TableItem[n5];
                System.arraycopy(this.items, 0, tableItemArray, 0, this.items.length);
                this.items = tableItemArray;
            }
        }
        return false;
    }

    void _checkShrink() {
        if (this.keys == null) {
            if (!this.ignoreShrink) {
                int n2 = OS.SendMessage(this.handle, 4100, 0, 0);
                if (n2 == 0 && this.items.length > 4) {
                    while (n2 < this.items.length && this.items[n2] != null && !this.items[n2].isDisposed()) {
                        ++n2;
                    }
                }
                if (this.items.length > 4 && this.items.length - n2 > 3) {
                    int n3 = Math.max(4, (n2 + 3) / 4 * 4);
                    TableItem[] tableItemArray = new TableItem[n3];
                    System.arraycopy(this.items, 0, tableItemArray, 0, n2);
                    this.items = tableItemArray;
                }
            }
        } else if (!this.ignoreShrink && this.keys.length > 4 && this.keys.length - this.keyCount > 3) {
            int n4 = Math.max(4, (this.keyCount + 3) / 4 * 4);
            int[] nArray = new int[n4];
            System.arraycopy(this.keys, 0, nArray, 0, this.keyCount);
            this.keys = nArray;
            TableItem[] tableItemArray = new TableItem[n4];
            System.arraycopy(this.items, 0, tableItemArray, 0, this.keyCount);
            this.items = tableItemArray;
        }
    }

    void _clearItems() {
        this.items = null;
        this.keys = null;
        this.keyCount = 0;
    }

    TableItem _getItem(int n2) {
        return this._getItem(n2, true);
    }

    TableItem _getItem(int n2, boolean bl2) {
        return this._getItem(n2, bl2, -1);
    }

    TableItem _getItem(int n2, boolean bl2, int n3) {
        if (this.keys == null) {
            if (n2 >= this.items.length) {
                return null;
            }
            if ((this.style & 0x10000000) == 0 || !bl2) {
                return this.items[n2];
            }
            if (this.items[n2] != null) {
                return this.items[n2];
            }
            this.items[n2] = new TableItem(this, 0, -1, false);
            return this.items[n2];
        }
        if ((this.style & 0x10000000) == 0 || !bl2) {
            if (this.keyCount == 0) {
                return null;
            }
            if (n2 > this.keys[this.keyCount - 1]) {
                return null;
            }
        }
        int n4 = this.binarySearch(this.keys, 0, this.keyCount, n2);
        if ((this.style & 0x10000000) == 0 || !bl2) {
            return n4 < 0 ? null : this.items[n4];
        }
        if (n4 < 0) {
            if (n3 == -1) {
                n3 = OS.SendMessage(this.handle, 4100, 0, 0);
            }
            if (this._checkGrow(n3)) {
                if (this.items[n2] != null) {
                    return this.items[n2];
                }
                this.items[n2] = new TableItem(this, 0, -1, false);
                return this.items[n2];
            }
            if ((n4 = -n4 - 1) < this.keyCount) {
                System.arraycopy(this.keys, n4, this.keys, n4 + 1, this.keyCount - n4);
                System.arraycopy(this.items, n4, this.items, n4 + 1, this.keyCount - n4);
            }
            ++this.keyCount;
            this.keys[n4] = n2;
        } else if (this.items[n4] != null) {
            return this.items[n4];
        }
        this.items[n4] = new TableItem(this, 0, -1, false);
        return this.items[n4];
    }

    void _getItems(TableItem[] tableItemArray, int n2) {
        if (this.keys == null) {
            System.arraycopy(this.items, 0, tableItemArray, 0, n2);
        } else {
            for (int i2 = 0; i2 < this.keyCount && this.keys[i2] < n2; ++i2) {
                tableItemArray[this.keys[i2]] = this.items[this.keys[i2]];
            }
        }
    }

    boolean _hasItems() {
        return this.items != null;
    }

    void _initItems() {
        this.items = new TableItem[4];
        if (COMPRESS_ITEMS && (this.style & 0x10000000) != 0) {
            this.keyCount = 0;
            this.keys = new int[4];
        }
    }

    void _insertItem(int n2, TableItem tableItem, int n3) {
        if (this.keys == null) {
            System.arraycopy(this.items, n2, this.items, n2 + 1, n3 - n2);
            this.items[n2] = tableItem;
        } else {
            int n4 = this.binarySearch(this.keys, 0, this.keyCount, n2);
            if (n4 < 0) {
                n4 = -n4 - 1;
            }
            System.arraycopy(this.keys, n4, this.keys, n4 + 1, this.keyCount - n4);
            this.keys[n4] = n2;
            System.arraycopy(this.items, n4, this.items, n4 + 1, this.keyCount - n4);
            this.items[n4] = tableItem;
            ++this.keyCount;
            int n5 = n4 + 1;
            while (n5 < this.keyCount) {
                int n6 = n5++;
                this.keys[n6] = this.keys[n6] + 1;
            }
        }
    }

    void _removeItem(int n2, int n3) {
        if (this.keys == null) {
            System.arraycopy(this.items, n2 + 1, this.items, n2, --n3 - n2);
            this.items[n3] = null;
        } else {
            int n4 = this.binarySearch(this.keys, 0, this.keyCount, n2);
            if (n4 < 0) {
                n4 = -n4 - 1;
            } else {
                --this.keyCount;
                System.arraycopy(this.keys, n4 + 1, this.keys, n4, this.keyCount - n4);
                this.keys[this.keyCount] = 0;
                System.arraycopy(this.items, n4 + 1, this.items, n4, this.keyCount - n4);
                this.items[this.keyCount] = null;
            }
            int n5 = n4;
            while (n5 < this.keyCount) {
                int n6 = n5++;
                this.keys[n6] = this.keys[n6] - 1;
            }
        }
    }

    void _removeItems(int n2, int n3, int n4) {
        if (this.keys == null) {
            System.arraycopy(this.items, n3, this.items, n2, n4 - n3);
            for (int i2 = n4 - (n3 - n2); i2 < n4; ++i2) {
                this.items[i2] = null;
            }
        } else {
            int n5;
            int n6;
            int n7 = n3;
            int n8 = this.binarySearch(this.keys, 0, this.keyCount, n2);
            if (n8 < 0) {
                n8 = -n8 - 1;
            }
            if ((n6 = this.binarySearch(this.keys, n8, this.keyCount, n7)) < 0) {
                n6 = -n6 - 1;
            }
            System.arraycopy(this.keys, n6, this.keys, n8, this.keyCount - n6);
            for (n5 = this.keyCount - (n6 - n8); n5 < this.keyCount; ++n5) {
                this.keys[n5] = 0;
            }
            System.arraycopy(this.items, n6, this.items, n8, this.keyCount - n6);
            for (n5 = this.keyCount - (n6 - n8); n5 < this.keyCount; ++n5) {
                this.items[n5] = null;
            }
            this.keyCount -= n6 - n8;
            n5 = n8;
            while (n5 < this.keyCount) {
                int n9 = n5++;
                this.keys[n9] = this.keys[n9] - (n6 - n8);
            }
        }
    }

    void _setItemCount(int n2, int n3) {
        if (this.keys == null) {
            int n4 = Math.max(4, (n2 + 3) / 4 * 4);
            TableItem[] tableItemArray = new TableItem[n4];
            System.arraycopy(this.items, 0, tableItemArray, 0, Math.min(n2, n3));
            this.items = tableItemArray;
        } else {
            int n5 = Math.min(n2, n3);
            this.keyCount = this.binarySearch(this.keys, 0, this.keyCount, n5);
            if (this.keyCount < 0) {
                this.keyCount = -this.keyCount - 1;
            }
            int n6 = Math.max(4, (this.keyCount + 3) / 4 * 4);
            int[] nArray = new int[n6];
            System.arraycopy(this.keys, 0, nArray, 0, this.keyCount);
            this.keys = nArray;
            TableItem[] tableItemArray = new TableItem[n6];
            System.arraycopy(this.items, 0, tableItemArray, 0, this.keyCount);
            this.items = tableItemArray;
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    int callWindowProc(int n2, int n3, int n4, int n5) {
        return this.callWindowProc(n2, n3, n4, n5, false);
    }

    int callWindowProc(int n2, int n3, int n4, int n5, boolean bl2) {
        int n6;
        int n7;
        int n8;
        if (this.handle == 0) {
            return 0;
        }
        if (this.hwndHeader != 0 && n2 == this.hwndHeader) {
            return OS.CallWindowProc(HeaderProc, n2, n3, n4, n5);
        }
        int n9 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        switch (n3) {
            case 256: {
                bl4 = true;
            }
            case 71: 
            case 257: 
            case 258: 
            case 260: 
            case 261: 
            case 262: 
            case 276: 
            case 277: 
            case 646: {
                boolean bl6 = bl5 = this.findImageControl() != null && this.getDrawing() && OS.IsWindowVisible(this.handle);
                if (bl5) {
                    OS.DefWindowProc(this.handle, 11, 0, 0);
                    OS.SendMessage(this.handle, 4097, 0, 0xFFFFFF);
                }
            }
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 673: 
            case 675: {
                bl3 = true;
            }
            case 48: 
            case 275: {
                if (this.findImageControl() == null) break;
                n9 = OS.SendMessage(this.handle, 4135, 0, 0);
            }
        }
        boolean bl7 = this.wasSelected;
        if (bl3) {
            this.wasSelected = false;
        }
        if (bl4) {
            this.ignoreActivate = true;
        }
        boolean bl8 = false;
        if (n3 == 15 && ((n8 = OS.GetWindowLong(this.handle, -16)) & 0x4000) == 0) {
            n7 = OS.GetParent(this.handle);
            int n10 = 0;
            while (n7 != 0) {
                n6 = OS.GetWindowLong(n7, -20);
                if ((n6 & 0x2000000) != 0) {
                    bl8 = true;
                    break;
                }
                n10 = OS.GetWindow(n7, 4);
                if (n10 != 0) break;
                n7 = OS.GetParent(n7);
            }
        }
        n8 = 0;
        if ((this.style & 0x100) == 0 || (this.style & 0x200) == 0) {
            switch (n3) {
                case 15: 
                case 70: 
                case 133: {
                    n7 = OS.GetWindowLong(n2, -16);
                    if ((this.style & 0x100) == 0 && (n7 & 0x100000) != 0) {
                        n8 = 1;
                        n7 &= 0xFFEFFFFF;
                    }
                    if ((this.style & 0x200) == 0 && (n7 & 0x200000) != 0) {
                        n8 = 1;
                        n7 &= 0xFFDFFFFF;
                    }
                    if (n8 == 0) break;
                    OS.SetWindowLong(this.handle, -16, n7);
                }
            }
        }
        n7 = 0;
        if (bl8) {
            PAINTSTRUCT pAINTSTRUCT = new PAINTSTRUCT();
            n6 = OS.BeginPaint(n2, pAINTSTRUCT);
            n7 = OS.CallWindowProc(TableProc, n2, 15, n6, n5);
            OS.EndPaint(n2, pAINTSTRUCT);
        } else {
            n7 = OS.CallWindowProc(TableProc, n2, n3, n4, n5);
        }
        if (n8 != 0) {
            int n11 = 1025;
            OS.RedrawWindow(this.handle, null, 0, n11);
        }
        if (bl4) {
            this.ignoreActivate = false;
        }
        if (bl3) {
            if (this.wasSelected || bl2) {
                Event event = new Event();
                n6 = OS.SendMessage(this.handle, 4108, -1, 1);
                if (n6 != -1) {
                    event.item = this._getItem(n6);
                }
                this.sendSelectionEvent(13, event, false);
            }
            this.wasSelected = bl7;
        }
        switch (n3) {
            case 71: 
            case 256: 
            case 257: 
            case 258: 
            case 260: 
            case 261: 
            case 262: 
            case 276: 
            case 277: 
            case 646: {
                if (bl5) {
                    OS.SendMessage(this.handle, 4097, 0, -1);
                    OS.DefWindowProc(this.handle, 11, 1, 0);
                    OS.InvalidateRect(this.handle, null, true);
                    int n12 = OS.SendMessage(this.handle, 4127, 0, 0);
                    if (n12 != 0) {
                        OS.InvalidateRect(n12, null, true);
                    }
                }
            }
            case 48: 
            case 275: 
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 673: 
            case 675: {
                if (this.findImageControl() == null || n9 == OS.SendMessage(this.handle, 4135, 0, 0)) break;
                OS.InvalidateRect(this.handle, null, true);
                break;
            }
            case 15: {
                this.painted = true;
            }
        }
        return n7;
    }

    static int checkStyle(int n2) {
        if ((n2 & 0x10) == 0) {
            n2 |= 0x300;
        }
        return Table.checkBits(n2, 4, 2, 0, 0, 0, 0);
    }

    LRESULT CDDS_ITEMPOSTPAINT(NMLVCUSTOMDRAW nMLVCUSTOMDRAW, int n2, int n3) {
        int n4;
        int n5;
        int n6 = nMLVCUSTOMDRAW.hdc;
        if (this.explorerTheme && !this.ignoreCustomDraw) {
            this.hotIndex = -1;
            if (this.hooks(40) && nMLVCUSTOMDRAW.left != nMLVCUSTOMDRAW.right) {
                OS.RestoreDC(n6, -1);
            }
        }
        if (!this.ignoreCustomDraw && !this.ignoreDrawFocus && nMLVCUSTOMDRAW.left != nMLVCUSTOMDRAW.right && OS.IsWindowVisible(this.handle) && OS.IsWindowEnabled(this.handle) && !this.explorerTheme && (this.style & 0x10000) != 0 && OS.SendMessage(this.handle, 4096, 0, 0) == -1 && ((n5 = OS.SendMessage(this.handle, 4151, 0, 0)) & 0x20) == 0 && OS.SendMessage(this.handle, 4108, -1, 1) == nMLVCUSTOMDRAW.dwItemSpec && this.handle == OS.GetFocus() && ((n4 = OS.SendMessage(this.handle, 297, 0, 0)) & 1) == 0) {
            RECT rECT = new RECT();
            rECT.left = 0;
            boolean bl2 = this.ignoreCustomDraw;
            this.ignoreCustomDraw = true;
            OS.SendMessage(this.handle, 4110, nMLVCUSTOMDRAW.dwItemSpec, rECT);
            int n7 = OS.SendMessage(this.handle, 4127, 0, 0);
            int n8 = OS.SendMessage(n7, 4623, 0, 0);
            RECT rECT2 = new RECT();
            if (n8 == 0) {
                rECT2.left = 2;
                OS.SendMessage(this.handle, 4110, n8, rECT2);
            } else {
                rECT2.top = n8;
                rECT2.left = 1;
                OS.SendMessage(this.handle, 4152, nMLVCUSTOMDRAW.dwItemSpec, rECT2);
            }
            this.ignoreCustomDraw = bl2;
            rECT.left = rECT2.left;
            OS.DrawFocusRect(nMLVCUSTOMDRAW.hdc, rECT);
        }
        return null;
    }

    LRESULT CDDS_ITEMPREPAINT(NMLVCUSTOMDRAW nMLVCUSTOMDRAW, int n2, int n3) {
        int n4;
        if (!this.ignoreCustomDraw && OS.IsWindowVisible(this.handle) && OS.IsWindowEnabled(this.handle) && !this.explorerTheme && (this.style & 0x10000) != 0 && OS.SendMessage(this.handle, 4096, 0, 0) == -1 && ((n4 = OS.SendMessage(this.handle, 4151, 0, 0)) & 0x20) == 0 && (nMLVCUSTOMDRAW.uItemState & 0x10) != 0) {
            nMLVCUSTOMDRAW.uItemState &= 0xFFFFFFEF;
            OS.MoveMemory(n3, nMLVCUSTOMDRAW, NMLVCUSTOMDRAW.sizeof);
        }
        if (this.explorerTheme && !this.ignoreCustomDraw) {
            int n5 = this.hotIndex = (nMLVCUSTOMDRAW.uItemState & 0x40) != 0 ? nMLVCUSTOMDRAW.dwItemSpec : -1;
            if (this.hooks(40) && nMLVCUSTOMDRAW.left != nMLVCUSTOMDRAW.right) {
                OS.SaveDC(nMLVCUSTOMDRAW.hdc);
                n4 = OS.CreateRectRgn(0, 0, 0, 0);
                OS.SelectClipRgn(nMLVCUSTOMDRAW.hdc, n4);
                OS.DeleteObject(n4);
            }
        }
        return new LRESULT(48);
    }

    LRESULT CDDS_POSTPAINT(NMLVCUSTOMDRAW nMLVCUSTOMDRAW, int n2, int n3) {
        int n4;
        if (this.ignoreCustomDraw) {
            return null;
        }
        if (--this.customCount == 0 && OS.IsWindowVisible(this.handle) && !this.explorerTheme && (this.style & 0x10000) != 0 && OS.SendMessage(this.handle, 4096, 0, 0) == -1 && ((n4 = OS.SendMessage(this.handle, 4151, 0, 0)) & 0x20) == 0) {
            int n5 = 32;
            int n6 = OS.SendMessage(this.handle, 4170, 0, 0);
            if (OS.IsWinCE) {
                RECT rECT = new RECT();
                boolean bl2 = OS.GetUpdateRect(this.handle, rECT, true);
                OS.SendMessage(this.handle, 4150, n5, n5);
                OS.ValidateRect(this.handle, null);
                if (bl2) {
                    OS.InvalidateRect(this.handle, rECT, true);
                }
            } else {
                int n7 = OS.CreateRectRgn(0, 0, 0, 0);
                int n8 = OS.GetUpdateRgn(this.handle, n7, true);
                OS.SendMessage(this.handle, 4150, n5, n5);
                OS.ValidateRect(this.handle, null);
                if (n8 != 1) {
                    OS.InvalidateRgn(this.handle, n7, true);
                }
                OS.DeleteObject(n7);
            }
            n6 = OS.SendMessage(this.handle, 4170, n6, n6);
        }
        return null;
    }

    LRESULT CDDS_PREPAINT(NMLVCUSTOMDRAW nMLVCUSTOMDRAW, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        if (this.ignoreCustomDraw) {
            return new LRESULT(48);
        }
        if (this.customCount++ == 0 && OS.IsWindowVisible(this.handle) && !this.explorerTheme && (this.style & 0x10000) != 0 && OS.SendMessage(this.handle, 4096, 0, 0) == -1 && ((n6 = OS.SendMessage(this.handle, 4151, 0, 0)) & 0x20) != 0) {
            n5 = 32;
            int n7 = OS.SendMessage(this.handle, 4170, 0, 0);
            if (OS.IsWinCE) {
                RECT rECT = new RECT();
                n4 = OS.GetUpdateRect(this.handle, rECT, true);
                OS.SendMessage(this.handle, 4150, n5, 0);
                OS.ValidateRect(this.handle, null);
                if (n4 != 0) {
                    OS.InvalidateRect(this.handle, rECT, true);
                }
            } else {
                int n8 = OS.CreateRectRgn(0, 0, 0, 0);
                n4 = OS.GetUpdateRgn(this.handle, n8, true);
                OS.SendMessage(this.handle, 4150, n5, 0);
                OS.ValidateRect(this.handle, null);
                if (n4 != 1) {
                    OS.InvalidateRgn(this.handle, n8, true);
                }
                OS.DeleteObject(n8);
            }
            n7 = OS.SendMessage(this.handle, 4170, n7, n7);
        }
        if (OS.IsWindowVisible(this.handle)) {
            n6 = 1;
            if (this.explorerTheme && this.columnCount == 0) {
                n5 = nMLVCUSTOMDRAW.hdc;
                RECT rECT = new RECT();
                OS.SetRect(rECT, nMLVCUSTOMDRAW.left, nMLVCUSTOMDRAW.top, nMLVCUSTOMDRAW.right, nMLVCUSTOMDRAW.bottom);
                if (OS.IsWindowEnabled(this.handle) || this.findImageControl() != null) {
                    this.drawBackground(n5, rECT);
                } else {
                    this.fillBackground(n5, OS.GetSysColor(OS.COLOR_3DFACE), rECT);
                }
                n6 = 0;
            }
            if (n6 != 0) {
                Control control = this.findBackgroundControl();
                if (control != null && control.backgroundImage != null) {
                    RECT rECT = new RECT();
                    OS.SetRect(rECT, nMLVCUSTOMDRAW.left, nMLVCUSTOMDRAW.top, nMLVCUSTOMDRAW.right, nMLVCUSTOMDRAW.bottom);
                    this.fillImageBackground(nMLVCUSTOMDRAW.hdc, control, rECT, 0, 0);
                } else if (OS.SendMessage(this.handle, 4096, 0, 0) == -1 && OS.IsWindowEnabled(this.handle)) {
                    int n9;
                    RECT rECT = new RECT();
                    OS.SetRect(rECT, nMLVCUSTOMDRAW.left, nMLVCUSTOMDRAW.top, nMLVCUSTOMDRAW.right, nMLVCUSTOMDRAW.bottom);
                    if (control == null) {
                        control = this;
                    }
                    this.fillBackground(nMLVCUSTOMDRAW.hdc, control.getBackgroundPixel(), rECT);
                    if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && this.sortColumn != null && this.sortDirection != 0 && (n9 = this.indexOf(this.sortColumn)) != -1) {
                        this.parent.forceResize();
                        n4 = this.getSortColumnPixel();
                        RECT rECT2 = new RECT();
                        RECT rECT3 = new RECT();
                        OS.GetClientRect(this.handle, rECT2);
                        int n10 = OS.SendMessage(this.handle, 4127, 0, 0);
                        if (OS.SendMessage(n10, 4615, n9, rECT3) != 0) {
                            OS.MapWindowPoints(n10, this.handle, rECT3, 2);
                            rECT2.left = rECT3.left;
                            rECT2.right = rECT3.right;
                            if (OS.IntersectRect(rECT2, rECT2, rECT)) {
                                this.fillBackground(nMLVCUSTOMDRAW.hdc, n4, rECT2);
                            }
                        }
                    }
                }
            }
        }
        return new LRESULT(48);
    }

    LRESULT CDDS_SUBITEMPOSTPAINT(NMLVCUSTOMDRAW nMLVCUSTOMDRAW, int n2, int n3) {
        if (this.ignoreCustomDraw) {
            return null;
        }
        if (nMLVCUSTOMDRAW.left == nMLVCUSTOMDRAW.right) {
            return new LRESULT(0);
        }
        int n4 = nMLVCUSTOMDRAW.hdc;
        if (this.ignoreDrawForeground) {
            OS.RestoreDC(n4, -1);
        }
        if (OS.IsWindowVisible(this.handle)) {
            int n5;
            if (OS.SendMessage(this.handle, 4096, 0, 0) != -1 && (this.sortDirection & 0x480) != 0 && this.sortColumn != null && !this.sortColumn.isDisposed() && (n5 = OS.SendMessage(this.handle, 4270, 0, 0)) == -1) {
                int n6 = this.indexOf(this.sortColumn);
                int n7 = 0;
                int n8 = 0;
                if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                    n8 = OS.CreateRectRgn(0, 0, 0, 0);
                    n7 = OS.GetUpdateRgn(this.handle, n8, true);
                }
                OS.SendMessage(this.handle, 4236, n6, 0);
                if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                    OS.ValidateRect(this.handle, null);
                    if (n7 != 1) {
                        OS.InvalidateRgn(this.handle, n8, true);
                    }
                    OS.DeleteObject(n8);
                }
            }
            if (this.hooks(42)) {
                TableItem tableItem = this._getItem(nMLVCUSTOMDRAW.dwItemSpec);
                this.sendPaintItemEvent(tableItem, nMLVCUSTOMDRAW);
            }
            if (!this.ignoreDrawFocus && this.focusRect != null) {
                OS.SetTextColor(nMLVCUSTOMDRAW.hdc, 0);
                OS.SetBkColor(nMLVCUSTOMDRAW.hdc, 0xFFFFFF);
                OS.DrawFocusRect(nMLVCUSTOMDRAW.hdc, this.focusRect);
                this.focusRect = null;
            }
        }
        return null;
    }

    LRESULT CDDS_SUBITEMPREPAINT(NMLVCUSTOMDRAW nMLVCUSTOMDRAW, int n2, int n3) {
        int n4;
        Object object;
        int n5;
        int n6;
        int n7;
        TableItem tableItem;
        int n8 = nMLVCUSTOMDRAW.hdc;
        if (this.explorerTheme && !this.ignoreCustomDraw && this.hooks(40) && nMLVCUSTOMDRAW.left != nMLVCUSTOMDRAW.right) {
            OS.RestoreDC(n8, -1);
        }
        if ((tableItem = this._getItem(nMLVCUSTOMDRAW.dwItemSpec)) == null || tableItem.isDisposed()) {
            return null;
        }
        int n9 = tableItem.fontHandle(nMLVCUSTOMDRAW.iSubItem);
        if (n9 != -1) {
            OS.SelectObject(n8, n9);
        }
        if (this.ignoreCustomDraw || nMLVCUSTOMDRAW.left == nMLVCUSTOMDRAW.right) {
            return new LRESULT(n9 == -1 ? 0 : 2);
        }
        int n10 = 0;
        this.selectionForeground = -1;
        this.ignoreDrawBackground = false;
        this.ignoreDrawFocus = false;
        this.ignoreDrawSelection = false;
        this.ignoreDrawForeground = false;
        if (OS.IsWindowVisible(this.handle)) {
            Event event = null;
            if (this.hooks(41)) {
                event = this.sendMeasureItemEvent(tableItem, nMLVCUSTOMDRAW.dwItemSpec, nMLVCUSTOMDRAW.iSubItem, nMLVCUSTOMDRAW.hdc);
                if (this.isDisposed() || tableItem.isDisposed()) {
                    return null;
                }
            }
            if (this.hooks(40)) {
                this.sendEraseItemEvent(tableItem, nMLVCUSTOMDRAW, n3, event);
                if (this.isDisposed() || tableItem.isDisposed()) {
                    return null;
                }
                n10 |= 0x10;
            }
            if (this.ignoreDrawForeground || this.hooks(42)) {
                n10 |= 0x10;
            }
        }
        int n11 = n7 = tableItem.cellForeground != null ? tableItem.cellForeground[nMLVCUSTOMDRAW.iSubItem] : -1;
        if (n7 == -1) {
            n7 = tableItem.foreground;
        }
        int n12 = n6 = tableItem.cellBackground != null ? tableItem.cellBackground[nMLVCUSTOMDRAW.iSubItem] : -1;
        if (n6 == -1) {
            n6 = tableItem.background;
        }
        if (this.selectionForeground != -1) {
            n7 = this.selectionForeground;
        }
        if (OS.IsWindowVisible(this.handle) && OS.IsWindowEnabled(this.handle) && !this.explorerTheme && !this.ignoreDrawSelection && (this.style & 0x10000) != 0 && ((n5 = OS.SendMessage(this.handle, 4151, 0, 0)) & 0x20) == 0) {
            object = new LVITEM();
            ((LVITEM)object).mask = 8;
            ((LVITEM)object).stateMask = 2;
            ((LVITEM)object).iItem = nMLVCUSTOMDRAW.dwItemSpec;
            n4 = OS.SendMessage(this.handle, OS.LVM_GETITEM, 0, (LVITEM)object);
            if (n4 != 0 && (((LVITEM)object).state & 2) != 0) {
                int n13 = -1;
                if (nMLVCUSTOMDRAW.iSubItem == 0) {
                    if (OS.GetFocus() == this.handle || this.display.getHighContrast()) {
                        n13 = OS.GetSysColor(OS.COLOR_HIGHLIGHT);
                    } else if ((this.style & 0x8000) == 0) {
                        n13 = OS.GetSysColor(OS.COLOR_3DFACE);
                    }
                } else if (OS.GetFocus() == this.handle || this.display.getHighContrast()) {
                    n7 = OS.GetSysColor(OS.COLOR_HIGHLIGHTTEXT);
                    n6 = n13 = OS.GetSysColor(OS.COLOR_HIGHLIGHT);
                } else if ((this.style & 0x8000) == 0) {
                    n6 = n13 = OS.GetSysColor(OS.COLOR_3DFACE);
                }
                if (n13 != -1) {
                    RECT rECT = tableItem.getBounds(nMLVCUSTOMDRAW.dwItemSpec, nMLVCUSTOMDRAW.iSubItem, true, nMLVCUSTOMDRAW.iSubItem != 0, true, false, n8);
                    this.fillBackground(n8, n13, rECT);
                }
            }
        }
        if (!this.ignoreDrawForeground) {
            int n14;
            n5 = 1;
            if (n9 == -1 && n7 == -1 && n6 == -1 && tableItem.cellForeground == null && tableItem.cellBackground == null && tableItem.cellFont == null && (n14 = OS.SendMessage(this.hwndHeader, 4608, 0, 0)) == 1) {
                n5 = 0;
            }
            if (n5 != 0) {
                if (n9 == -1) {
                    n9 = OS.SendMessage(this.handle, 49, 0, 0);
                }
                OS.SelectObject(n8, n9);
                if (OS.IsWindowEnabled(this.handle)) {
                    int n15 = nMLVCUSTOMDRAW.clrText = n7 == -1 ? this.getForegroundPixel() : n7;
                    if (n6 == -1) {
                        nMLVCUSTOMDRAW.clrTextBk = -1;
                        if (this.selectionForeground == -1) {
                            object = this.findBackgroundControl();
                            if (object == null) {
                                object = this;
                            }
                            if (((Control)object).backgroundImage == null && OS.SendMessage(this.handle, 4096, 0, 0) != -1) {
                                nMLVCUSTOMDRAW.clrTextBk = ((Control)object).getBackgroundPixel();
                            }
                        }
                    } else {
                        nMLVCUSTOMDRAW.clrTextBk = this.selectionForeground != -1 ? -1 : n6;
                    }
                    OS.MoveMemory(n3, nMLVCUSTOMDRAW, NMLVCUSTOMDRAW.sizeof);
                }
                n10 |= 2;
            }
        }
        if (OS.IsWindowEnabled(this.handle)) {
            if (n6 != -1 && (n5 = OS.SendMessage(this.handle, 4270, 0, 0)) != -1 && n5 == nMLVCUSTOMDRAW.iSubItem) {
                int n16 = 0;
                n4 = 0;
                if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                    n4 = OS.CreateRectRgn(0, 0, 0, 0);
                    n16 = OS.GetUpdateRgn(this.handle, n4, true);
                }
                OS.SendMessage(this.handle, 4236, -1, 0);
                if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                    OS.ValidateRect(this.handle, null);
                    if (n16 != 1) {
                        OS.InvalidateRgn(this.handle, n4, true);
                    }
                    OS.DeleteObject(n4);
                }
                n10 |= 0x10;
            }
        } else {
            nMLVCUSTOMDRAW.clrText = OS.GetSysColor(OS.COLOR_GRAYTEXT);
            nMLVCUSTOMDRAW.clrTextBk = this.findImageControl() != null ? -1 : OS.GetSysColor(OS.COLOR_3DFACE);
            nMLVCUSTOMDRAW.uItemState &= 0xFFFFFFFE;
            OS.MoveMemory(n3, nMLVCUSTOMDRAW, NMLVCUSTOMDRAW.sizeof);
            n10 |= 2;
        }
        return new LRESULT(n10);
    }

    @Override
    void checkBuffered() {
        super.checkBuffered();
        if (OS.COMCTL32_MAJOR >= 6) {
            this.style |= 0x20000000;
        }
        if ((this.style & 0x10000000) != 0) {
            this.style |= 0x20000000;
        }
    }

    boolean checkData(TableItem tableItem, boolean bl2) {
        if ((this.style & 0x10000000) == 0) {
            return true;
        }
        return this.checkData(tableItem, this.indexOf(tableItem), bl2);
    }

    boolean checkData(TableItem tableItem, int n2, boolean bl2) {
        if ((this.style & 0x10000000) == 0) {
            return true;
        }
        if (!tableItem.cached) {
            tableItem.cached = true;
            Event event = new Event();
            event.item = tableItem;
            event.index = n2;
            this.currentItem = tableItem;
            this.sendEvent(36, event);
            this.currentItem = null;
            if (this.isDisposed() || tableItem.isDisposed()) {
                return false;
            }
            if (bl2 && !this.setScrollWidth(tableItem, false)) {
                tableItem.redraw();
            }
        }
        return true;
    }

    @Override
    boolean checkHandle(int n2) {
        if (n2 == this.handle) {
            return true;
        }
        return n2 == OS.SendMessage(this.handle, 4127, 0, 0);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clear(int n2) {
        TableItem tableItem;
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (0 > n2 || n2 >= n3) {
            this.error(6);
        }
        if ((tableItem = this._getItem(n2, false)) != null) {
            if (tableItem != this.currentItem) {
                tableItem.clear();
            }
            if ((this.style & 0x10000000) == 0 && tableItem.cached) {
                LVITEM lVITEM = new LVITEM();
                lVITEM.mask = 17;
                lVITEM.pszText = -1;
                lVITEM.iItem = n2;
                OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lVITEM);
                tableItem.cached = false;
            }
            if (this.currentItem == null && this.getDrawing() && OS.IsWindowVisible(this.handle)) {
                OS.SendMessage(this.handle, 4117, n2, n2);
            }
            this.setScrollWidth(tableItem, false);
        }
    }

    public void clear(int n2, int n3) {
        this.checkWidget();
        if (n2 > n3) {
            return;
        }
        int n4 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (0 > n2 || n2 > n3 || n3 >= n4) {
            this.error(6);
        }
        if (n2 == 0 && n3 == n4 - 1) {
            this.clearAll();
        } else {
            LVITEM lVITEM = null;
            boolean bl2 = false;
            for (int i2 = n2; i2 <= n3; ++i2) {
                TableItem tableItem = this._getItem(i2, false);
                if (tableItem == null) continue;
                if (tableItem != this.currentItem) {
                    bl2 = true;
                    tableItem.clear();
                }
                if ((this.style & 0x10000000) != 0 || !tableItem.cached) continue;
                if (lVITEM == null) {
                    lVITEM = new LVITEM();
                    lVITEM.mask = 17;
                    lVITEM.pszText = -1;
                }
                lVITEM.iItem = i2;
                OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lVITEM);
                tableItem.cached = false;
            }
            if (bl2) {
                if (this.currentItem == null && this.getDrawing() && OS.IsWindowVisible(this.handle)) {
                    OS.SendMessage(this.handle, 4117, n2, n3);
                }
                TableItem tableItem = n2 == n3 ? this._getItem(n2, false) : null;
                this.setScrollWidth(tableItem, false);
            }
        }
    }

    public void clear(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int n2 = OS.SendMessage(this.handle, 4100, 0, 0);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (0 <= nArray[i2] && nArray[i2] < n2) continue;
            this.error(6);
        }
        LVITEM lVITEM = null;
        boolean bl2 = false;
        for (int i3 = 0; i3 < nArray.length; ++i3) {
            int n3 = nArray[i3];
            TableItem tableItem = this._getItem(n3, false);
            if (tableItem == null) continue;
            if (tableItem != this.currentItem) {
                bl2 = true;
                tableItem.clear();
            }
            if ((this.style & 0x10000000) == 0 && tableItem.cached) {
                if (lVITEM == null) {
                    lVITEM = new LVITEM();
                    lVITEM.mask = 17;
                    lVITEM.pszText = -1;
                }
                lVITEM.iItem = i3;
                OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lVITEM);
                tableItem.cached = false;
            }
            if (this.currentItem != null || !this.getDrawing() || !OS.IsWindowVisible(this.handle)) continue;
            OS.SendMessage(this.handle, 4117, n3, n3);
        }
        if (bl2) {
            this.setScrollWidth(null, false);
        }
    }

    public void clearAll() {
        this.checkWidget();
        LVITEM lVITEM = null;
        boolean bl2 = false;
        int n2 = OS.SendMessage(this.handle, 4100, 0, 0);
        for (int i2 = 0; i2 < n2; ++i2) {
            TableItem tableItem = this._getItem(i2, false);
            if (tableItem == null) continue;
            if (tableItem != this.currentItem) {
                bl2 = true;
                tableItem.clear();
            }
            if ((this.style & 0x10000000) != 0 || !tableItem.cached) continue;
            if (lVITEM == null) {
                lVITEM = new LVITEM();
                lVITEM.mask = 17;
                lVITEM.pszText = -1;
            }
            lVITEM.iItem = i2;
            OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lVITEM);
            tableItem.cached = false;
        }
        if (bl2) {
            if (this.currentItem == null && this.getDrawing() && OS.IsWindowVisible(this.handle)) {
                OS.SendMessage(this.handle, 4117, 0, n2 - 1);
            }
            this.setScrollWidth(null, false);
        }
    }

    @Override
    Point computeSizeInPixels(int n2, int n3, boolean bl2) {
        int n4;
        int n5;
        int n6;
        if (this.fixScrollWidth) {
            this.setScrollWidth(null, true);
        }
        RECT rECT = new RECT();
        OS.GetWindowRect(this.hwndHeader, rECT);
        int n7 = rECT.bottom - rECT.top;
        int n8 = 0;
        if (n2 != -1) {
            n8 |= n2 & 0xFFFF;
        } else {
            n6 = 0;
            n5 = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
            for (n4 = 0; n4 < n5; ++n4) {
                n6 += OS.SendMessage(this.handle, 4125, n4, 0);
            }
            n8 |= n6 & 0xFFFF;
        }
        n6 = OS.SendMessage(this.handle, 4160, -1, OS.MAKELPARAM(n8, 65535));
        n5 = OS.LOWORD(n6);
        n4 = OS.SendMessage(this.handle, 4160, 0, 0);
        int n9 = OS.SendMessage(this.handle, 4160, 1, 0);
        int n10 = OS.HIWORD(n9) - OS.HIWORD(n4);
        n7 += OS.SendMessage(this.handle, 4100, 0, 0) * n10;
        if (n5 == 0) {
            n5 = 64;
        }
        if (n7 == 0) {
            n7 = 64;
        }
        if (n2 != -1) {
            n5 = n2;
        }
        if (n3 != -1) {
            n7 = n3;
        }
        int n11 = this.getBorderWidthInPixels();
        n5 += n11 * 2;
        n7 += n11 * 2;
        if ((this.style & 0x200) != 0) {
            n5 += OS.GetSystemMetrics(2);
        }
        if ((this.style & 0x100) != 0) {
            n7 += OS.GetSystemMetrics(3);
        }
        return new Point(n5, n7);
    }

    @Override
    void createHandle() {
        int n2;
        int n3;
        int n4;
        super.createHandle();
        this.state &= 0xFFFFFEFD;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0) && OS.IsAppThemed()) {
            this.explorerTheme = true;
            OS.SetWindowTheme(this.handle, Display.EXPLORER, null);
        }
        this.hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
        if (!OS.IsWinCE && OS.COMCTL32_MAJOR < 6) {
            OS.SendMessage(this.handle, 8199, 5, 0);
        }
        if ((this.style & 0x20) != 0) {
            n4 = OS.SendMessage(this.handle, 4160, 0, 0);
            int n5 = OS.SendMessage(this.handle, 4160, 1, 0);
            n2 = n3 = OS.HIWORD(n5) - OS.HIWORD(n4);
            this.setCheckboxImageList(n3, n2, false);
            OS.SendMessage(this.handle, 4107, 61440, 0);
        }
        n4 = OS.GetStockObject(13);
        OS.SendMessage(this.handle, 48, n4, 0);
        LVCOLUMN lVCOLUMN = new LVCOLUMN();
        lVCOLUMN.mask = 6;
        n3 = OS.GetProcessHeap();
        lVCOLUMN.pszText = n2 = OS.HeapAlloc(n3, 8, TCHAR.sizeof);
        OS.SendMessage(this.handle, OS.LVM_INSERTCOLUMN, 0, lVCOLUMN);
        OS.HeapFree(n3, 0, n2);
        int n6 = 16384;
        if ((this.style & 0x10000) != 0) {
            n6 |= 0x20;
        }
        if (OS.COMCTL32_MAJOR >= 6) {
            n6 |= 0x10000;
        }
        OS.SendMessage(this.handle, 4150, n6, n6);
        if (OS.WIN32_VERSION >= OS.VERSION(4, 10) && (this.style & 0x4000000) != 0) {
            int n7 = OS.GetWindowLong(this.hwndHeader, -20);
            OS.SetWindowLong(this.hwndHeader, -20, n7 | 0x400000);
            int n8 = OS.SendMessage(this.handle, 4174, 0, 0);
            int n9 = OS.GetWindowLong(n8, -20);
            OS.SetWindowLong(n8, -20, n9 | 0x400000);
        }
    }

    @Override
    int applyThemeBackground() {
        return -1;
    }

    void createHeaderToolTips() {
        if (OS.IsWinCE) {
            return;
        }
        if (this.headerToolTipHandle != 0) {
            return;
        }
        int n2 = 0;
        if (OS.WIN32_VERSION >= OS.VERSION(4, 10) && (this.style & 0x4000000) != 0) {
            n2 |= 0x400000;
        }
        this.headerToolTipHandle = OS.CreateWindowEx(n2, new TCHAR(0, "tooltips_class32", true), null, 2, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, this.handle, 0, OS.GetModuleHandle(null), null);
        if (this.headerToolTipHandle == 0) {
            this.error(2);
        }
        OS.SendMessage(this.headerToolTipHandle, 1048, 0, Short.MAX_VALUE);
    }

    void createItem(TableColumn tableColumn, int n2) {
        RECT rECT;
        Object object;
        int n3;
        int n4;
        if (0 > n2 || n2 > this.columnCount) {
            this.error(6);
        }
        if ((n4 = OS.SendMessage(this.handle, 4270, 0, 0)) >= n2) {
            OS.SendMessage(this.handle, 4236, n4 + 1, 0);
        }
        if (this.columnCount == this.columns.length) {
            TableColumn[] tableColumnArray = new TableColumn[this.columns.length + 4];
            System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columns.length);
            this.columns = tableColumnArray;
        }
        int n5 = OS.SendMessage(this.handle, 4100, 0, 0);
        for (n3 = 0; n3 < n5; ++n3) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3;
            object = this._getItem(n3, false);
            if (object == null) continue;
            String[] stringArray = ((TableItem)object).strings;
            if (stringArray != null) {
                objectArray3 = new String[this.columnCount + 1];
                System.arraycopy(stringArray, 0, objectArray3, 0, n2);
                System.arraycopy(stringArray, n2, objectArray3, n2 + 1, this.columnCount - n2);
                ((TableItem)object).strings = objectArray3;
            }
            if ((objectArray3 = ((TableItem)object).images) != null) {
                objectArray2 = new Image[this.columnCount + 1];
                System.arraycopy(objectArray3, 0, objectArray2, 0, n2);
                System.arraycopy(objectArray3, n2, objectArray2, n2 + 1, this.columnCount - n2);
                ((TableItem)object).images = objectArray2;
            }
            if (n2 == 0 && this.columnCount != 0) {
                if (stringArray == null) {
                    ((TableItem)object).strings = new String[this.columnCount + 1];
                    ((TableItem)object).strings[1] = ((TableItem)object).text;
                }
                ((TableItem)object).text = "";
                if (objectArray3 == null) {
                    ((TableItem)object).images = new Image[this.columnCount + 1];
                    ((TableItem)object).images[1] = ((TableItem)object).image;
                }
                ((TableItem)object).image = null;
            }
            if (((TableItem)object).cellBackground != null) {
                objectArray2 = ((TableItem)object).cellBackground;
                objectArray = new int[this.columnCount + 1];
                System.arraycopy(objectArray2, 0, objectArray, 0, n2);
                System.arraycopy(objectArray2, n2, objectArray, n2 + 1, this.columnCount - n2);
                objectArray[n2] = -1;
                ((TableItem)object).cellBackground = objectArray;
            }
            if (((TableItem)object).cellForeground != null) {
                objectArray2 = ((TableItem)object).cellForeground;
                objectArray = new int[this.columnCount + 1];
                System.arraycopy(objectArray2, 0, objectArray, 0, n2);
                System.arraycopy(objectArray2, n2, objectArray, n2 + 1, this.columnCount - n2);
                objectArray[n2] = -1;
                ((TableItem)object).cellForeground = objectArray;
            }
            if (((TableItem)object).cellFont == null) continue;
            objectArray2 = ((TableItem)object).cellFont;
            objectArray = new Font[this.columnCount + 1];
            System.arraycopy(objectArray2, 0, objectArray, 0, n2);
            System.arraycopy(objectArray2, n2, objectArray, n2 + 1, this.columnCount - n2);
            ((TableItem)object).cellFont = (Font[])objectArray;
        }
        System.arraycopy(this.columns, n2, this.columns, n2 + 1, this.columnCount++ - n2);
        this.columns[n2] = tableColumn;
        this.ignoreColumnResize = true;
        if (n2 == 0) {
            if (this.columnCount > 1) {
                LVCOLUMN lVCOLUMN = new LVCOLUMN();
                lVCOLUMN.mask = 2;
                OS.SendMessage(this.handle, OS.LVM_INSERTCOLUMN, 1, lVCOLUMN);
                OS.SendMessage(this.handle, OS.LVM_GETCOLUMN, 1, lVCOLUMN);
                int n6 = lVCOLUMN.cx;
                int n7 = 1024;
                int n8 = OS.GetProcessHeap();
                int n9 = n7 * TCHAR.sizeof;
                int n10 = OS.HeapAlloc(n8, 8, n9);
                lVCOLUMN.mask = 23;
                lVCOLUMN.pszText = n10;
                lVCOLUMN.cchTextMax = n7;
                OS.SendMessage(this.handle, OS.LVM_GETCOLUMN, 0, lVCOLUMN);
                OS.SendMessage(this.handle, OS.LVM_SETCOLUMN, 1, lVCOLUMN);
                lVCOLUMN.fmt = 2048;
                lVCOLUMN.cx = n6;
                lVCOLUMN.iImage = -2;
                lVCOLUMN.cchTextMax = 0;
                lVCOLUMN.pszText = 0;
                OS.SendMessage(this.handle, OS.LVM_SETCOLUMN, 0, lVCOLUMN);
                lVCOLUMN.mask = 1;
                lVCOLUMN.fmt = 0;
                OS.SendMessage(this.handle, OS.LVM_SETCOLUMN, 0, lVCOLUMN);
                if (n10 != 0) {
                    OS.HeapFree(n8, 0, n10);
                }
            } else {
                OS.SendMessage(this.handle, 4126, 0, 0);
            }
            if ((this.style & 0x10000000) == 0) {
                LVITEM lVITEM = new LVITEM();
                lVITEM.mask = 3;
                lVITEM.pszText = -1;
                lVITEM.iImage = -1;
                int n11 = 0;
                while (n11 < n5) {
                    lVITEM.iItem = n11++;
                    OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lVITEM);
                }
            }
        } else {
            n3 = 0;
            if ((tableColumn.style & 0x1000000) == 0x1000000) {
                n3 = 2;
            }
            if ((tableColumn.style & 0x20000) == 131072) {
                n3 = 1;
            }
            object = new LVCOLUMN();
            ((LVCOLUMN)object).mask = 3;
            ((LVCOLUMN)object).fmt = n3;
            OS.SendMessage(this.handle, OS.LVM_INSERTCOLUMN, n2, (LVCOLUMN)object);
        }
        this.ignoreColumnResize = false;
        if (this.headerToolTipHandle != 0 && OS.SendMessage(this.hwndHeader, 4615, n2, rECT = new RECT()) != 0) {
            TOOLINFO tOOLINFO = new TOOLINFO();
            tOOLINFO.cbSize = TOOLINFO.sizeof;
            tOOLINFO.uFlags = 16;
            tOOLINFO.hwnd = this.hwndHeader;
            tableColumn.id = this.display.nextToolTipId++;
            tOOLINFO.uId = tableColumn.id;
            tOOLINFO.left = rECT.left;
            tOOLINFO.top = rECT.top;
            tOOLINFO.right = rECT.right;
            tOOLINFO.bottom = rECT.bottom;
            tOOLINFO.lpszText = -1;
            OS.SendMessage(this.headerToolTipHandle, OS.TTM_ADDTOOL, 0, tOOLINFO);
        }
    }

    void createItem(TableItem tableItem, int n2) {
        int n3 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (0 > n2 || n2 > n3) {
            this.error(6);
        }
        this._checkGrow(n3);
        LVITEM lVITEM = new LVITEM();
        lVITEM.mask = 3;
        lVITEM.iItem = n2;
        lVITEM.pszText = -1;
        lVITEM.iImage = -1;
        this.setDeferResize(true);
        this.ignoreShrink = true;
        this.ignoreSelect = true;
        int n4 = OS.SendMessage(this.handle, OS.LVM_INSERTITEM, 0, lVITEM);
        this.ignoreShrink = false;
        this.ignoreSelect = false;
        if (n4 == -1) {
            this.error(14);
        }
        this._insertItem(n2, tableItem, n3);
        this.setDeferResize(false);
        if (n3 == 0) {
            this.setScrollWidth(tableItem, false);
        }
    }

    @Override
    void createWidget() {
        super.createWidget();
        this.hotIndex = -1;
        this.itemHeight = -1;
        this._initItems();
        this.columns = new TableColumn[4];
    }

    private boolean customHeaderDrawing() {
        return this.headerBackground != -1 || this.headerForeground != -1;
    }

    @Override
    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    @Override
    void deregister() {
        super.deregister();
        if (this.hwndHeader != 0) {
            this.display.removeControl(this.hwndHeader);
        }
    }

    public void deselect(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        LVITEM lVITEM = new LVITEM();
        lVITEM.stateMask = 2;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] < 0) continue;
            this.ignoreSelect = true;
            OS.SendMessage(this.handle, 4139, nArray[i2], lVITEM);
            this.ignoreSelect = false;
        }
    }

    public void deselect(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        LVITEM lVITEM = new LVITEM();
        lVITEM.stateMask = 2;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, n2, lVITEM);
        this.ignoreSelect = false;
    }

    public void deselect(int n2, int n3) {
        this.checkWidget();
        int n4 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (n2 == 0 && n3 == n4 - 1) {
            this.deselectAll();
        } else {
            LVITEM lVITEM = new LVITEM();
            lVITEM.stateMask = 2;
            for (int i2 = n2 = Math.max(0, n2); i2 <= n3; ++i2) {
                this.ignoreSelect = true;
                OS.SendMessage(this.handle, 4139, i2, lVITEM);
                this.ignoreSelect = false;
            }
        }
    }

    public void deselectAll() {
        this.checkWidget();
        LVITEM lVITEM = new LVITEM();
        lVITEM.mask = 8;
        lVITEM.stateMask = 2;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, -1, lVITEM);
        this.ignoreSelect = false;
    }

    void destroyItem(TableColumn tableColumn) {
        Object[] objectArray;
        int n2;
        int n3;
        int n4;
        int n5;
        for (n5 = 0; n5 < this.columnCount && this.columns[n5] != tableColumn; ++n5) {
        }
        int n6 = OS.SendMessage(this.handle, 4270, 0, 0);
        if (n6 == n5) {
            OS.SendMessage(this.handle, 4236, -1, 0);
        } else if (n6 > n5) {
            OS.SendMessage(this.handle, 4236, n6 - 1, 0);
        }
        int[] nArray = new int[this.columnCount];
        OS.SendMessage(this.handle, 4155, this.columnCount, nArray);
        for (n4 = 0; n4 < this.columnCount && nArray[n4] != n5; ++n4) {
        }
        this.ignoreColumnResize = true;
        boolean bl2 = false;
        if (n5 == 0) {
            int n7;
            bl2 = true;
            this.setRedraw(false);
            if (this.columnCount > 1) {
                n5 = 1;
                n7 = 1024;
                n3 = OS.GetProcessHeap();
                n2 = n7 * TCHAR.sizeof;
                int n8 = OS.HeapAlloc(n3, 8, n2);
                objectArray = new LVCOLUMN();
                objectArray.mask = 23;
                objectArray.pszText = n8;
                objectArray.cchTextMax = n7;
                OS.SendMessage(this.handle, OS.LVM_GETCOLUMN, 1, (LVCOLUMN)objectArray);
                objectArray.fmt &= 0xFFFFFFFC;
                objectArray.fmt |= 0;
                OS.SendMessage(this.handle, OS.LVM_SETCOLUMN, 0, (LVCOLUMN)objectArray);
                if (n8 != 0) {
                    OS.HeapFree(n3, 0, n8);
                }
            } else {
                n7 = OS.GetProcessHeap();
                n3 = OS.HeapAlloc(n7, 8, TCHAR.sizeof);
                LVCOLUMN lVCOLUMN = new LVCOLUMN();
                lVCOLUMN.mask = 23;
                lVCOLUMN.pszText = n3;
                lVCOLUMN.iImage = -2;
                lVCOLUMN.fmt = 0;
                OS.SendMessage(this.handle, OS.LVM_SETCOLUMN, 0, lVCOLUMN);
                if (n3 != 0) {
                    OS.HeapFree(n7, 0, n3);
                }
                if (OS.COMCTL32_MAJOR >= 6) {
                    HDITEM hDITEM = new HDITEM();
                    hDITEM.mask = 4;
                    hDITEM.fmt = 0;
                    int n9 = OS.SendMessage(this.handle, 4127, 0, 0);
                    OS.SendMessage(n9, OS.HDM_SETITEM, n5, hDITEM);
                }
            }
            this.setRedraw(true);
            if ((this.style & 0x10000000) == 0) {
                LVITEM lVITEM = new LVITEM();
                lVITEM.mask = 3;
                lVITEM.pszText = -1;
                lVITEM.iImage = -1;
                n3 = OS.SendMessage(this.handle, 4100, 0, 0);
                n2 = 0;
                while (n2 < n3) {
                    lVITEM.iItem = n2++;
                    OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lVITEM);
                }
            }
        }
        if (this.columnCount > 1 && OS.SendMessage(this.handle, 4124, n5, 0) == 0) {
            this.error(15);
        }
        if (bl2) {
            n5 = 0;
        }
        System.arraycopy(this.columns, n5 + 1, this.columns, n5, --this.columnCount - n5);
        this.columns[this.columnCount] = null;
        int n10 = OS.SendMessage(this.handle, 4100, 0, 0);
        for (n3 = 0; n3 < n10; ++n3) {
            TableItem tableItem = this._getItem(n3, false);
            if (tableItem == null) continue;
            if (this.columnCount == 0) {
                tableItem.strings = null;
                tableItem.images = null;
                tableItem.cellBackground = null;
                tableItem.cellForeground = null;
                tableItem.cellFont = null;
                continue;
            }
            if (tableItem.strings != null) {
                String[] stringArray = tableItem.strings;
                if (n5 == 0) {
                    tableItem.text = stringArray[1] != null ? stringArray[1] : "";
                }
                objectArray = new String[this.columnCount];
                System.arraycopy(stringArray, 0, objectArray, 0, n5);
                System.arraycopy(stringArray, n5 + 1, objectArray, n5, this.columnCount - n5);
                tableItem.strings = objectArray;
            } else if (n5 == 0) {
                tableItem.text = "";
            }
            if (tableItem.images != null) {
                Image[] imageArray = tableItem.images;
                if (n5 == 0) {
                    tableItem.image = imageArray[1];
                }
                objectArray = new Image[this.columnCount];
                System.arraycopy(imageArray, 0, objectArray, 0, n5);
                System.arraycopy(imageArray, n5 + 1, objectArray, n5, this.columnCount - n5);
                tableItem.images = objectArray;
            } else if (n5 == 0) {
                tableItem.image = null;
            }
            if (tableItem.cellBackground != null) {
                int[] nArray2 = tableItem.cellBackground;
                objectArray = new int[this.columnCount];
                System.arraycopy(nArray2, 0, objectArray, 0, n5);
                System.arraycopy(nArray2, n5 + 1, objectArray, n5, this.columnCount - n5);
                tableItem.cellBackground = (int[])objectArray;
            }
            if (tableItem.cellForeground != null) {
                int[] nArray3 = tableItem.cellForeground;
                objectArray = new int[this.columnCount];
                System.arraycopy(nArray3, 0, objectArray, 0, n5);
                System.arraycopy(nArray3, n5 + 1, objectArray, n5, this.columnCount - n5);
                tableItem.cellForeground = (int[])objectArray;
            }
            if (tableItem.cellFont == null) continue;
            Font[] fontArray = tableItem.cellFont;
            objectArray = new Font[this.columnCount];
            System.arraycopy(fontArray, 0, objectArray, 0, n5);
            System.arraycopy(fontArray, n5 + 1, objectArray, n5, this.columnCount - n5);
            tableItem.cellFont = objectArray;
        }
        if (this.columnCount == 0) {
            this.setScrollWidth(null, true);
        }
        this.updateMoveable();
        this.ignoreColumnResize = false;
        if (this.columnCount != 0) {
            int n11;
            int n12;
            n3 = 0;
            n2 = nArray[n4];
            int[] nArray4 = new int[this.columnCount];
            for (n12 = 0; n12 < nArray.length; ++n12) {
                if (nArray[n12] == n2) continue;
                int n13 = nArray[n12] <= n2 ? nArray[n12] : nArray[n12] - 1;
                nArray4[n3++] = n13;
            }
            OS.SendMessage(this.handle, 4155, this.columnCount, nArray);
            for (n12 = 0; n12 < nArray4.length && nArray[n12] == nArray4[n12]; ++n12) {
            }
            if (n12 != nArray4.length) {
                OS.SendMessage(this.handle, 4154, nArray4.length, nArray4);
                OS.InvalidateRect(this.handle, null, true);
            }
            TableColumn[] tableColumnArray = new TableColumn[this.columnCount - n4];
            for (n11 = n4; n11 < nArray4.length; ++n11) {
                tableColumnArray[n11 - n4] = this.columns[nArray4[n11]];
                tableColumnArray[n11 - n4].updateToolTip(nArray4[n11]);
            }
            for (n11 = 0; n11 < tableColumnArray.length; ++n11) {
                if (tableColumnArray[n11].isDisposed()) continue;
                tableColumnArray[n11].sendEvent(10);
            }
        }
        if (this.headerToolTipHandle != 0) {
            TOOLINFO tOOLINFO = new TOOLINFO();
            tOOLINFO.cbSize = TOOLINFO.sizeof;
            tOOLINFO.uId = tableColumn.id;
            tOOLINFO.hwnd = OS.SendMessage(this.handle, 4127, 0, 0);
            OS.SendMessage(this.headerToolTipHandle, OS.TTM_DELTOOL, 0, tOOLINFO);
        }
    }

    void destroyItem(TableItem tableItem) {
        int n2;
        int n3 = OS.SendMessage(this.handle, 4100, 0, 0);
        for (n2 = 0; n2 < n3 && this._getItem(n2, false) != tableItem; ++n2) {
        }
        if (n2 == n3) {
            return;
        }
        this.setDeferResize(true);
        this.ignoreShrink = true;
        this.ignoreSelect = true;
        int n4 = OS.SendMessage(this.handle, 4104, n2, 0);
        this.ignoreShrink = false;
        this.ignoreSelect = false;
        if (n4 == 0) {
            this.error(15);
        }
        this._removeItem(n2, n3);
        if (--n3 == 0) {
            this.setTableEmpty();
        }
        this.setDeferResize(false);
    }

    void fixCheckboxImageList(boolean bl2) {
        if ((this.style & 0x20) == 0) {
            return;
        }
        int n2 = OS.SendMessage(this.handle, 4098, 1, 0);
        if (n2 == 0) {
            return;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.ImageList_GetIconSize(n2, nArray, nArray2);
        nArray[0] = Math.min(20, nArray[0]);
        nArray2[0] = Math.min(20, nArray2[0]);
        int n3 = OS.SendMessage(this.handle, 4098, 2, 0);
        if (n3 == 0) {
            return;
        }
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        OS.ImageList_GetIconSize(n3, nArray3, nArray4);
        if (nArray[0] == nArray3[0] && nArray2[0] == nArray4[0]) {
            return;
        }
        this.setCheckboxImageList(nArray[0], nArray2[0], bl2);
    }

    void fixCheckboxImageListColor(boolean bl2) {
        if ((this.style & 0x20) == 0) {
            return;
        }
        int n2 = OS.SendMessage(this.handle, 4098, 2, 0);
        if (n2 == 0) {
            return;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.ImageList_GetIconSize(n2, nArray, nArray2);
        this.setCheckboxImageList(nArray[0], nArray2[0], bl2);
    }

    void fixItemHeight(boolean bl2) {
        int n2;
        if (this.itemHeight != -1) {
            return;
        }
        if (OS.COMCTL32_VERSION >= OS.VERSION(5, 80)) {
            return;
        }
        if (!this._getLinesVisible()) {
            return;
        }
        int n3 = OS.GetWindowLong(this.handle, -16);
        if ((n3 & 0x4000) != 0) {
            return;
        }
        int n4 = this.getTopIndex();
        if (bl2 && n4 != 0) {
            this.setRedraw(false);
            this.setTopIndex(0);
        }
        if ((n2 = OS.SendMessage(this.handle, 4098, 1, 0)) != 0) {
            return;
        }
        RECT rECT = new RECT();
        OS.GetWindowRect(this.hwndHeader, rECT);
        int n5 = rECT.bottom - rECT.top - 1;
        int n6 = OS.ImageList_Create(1, n5, 0, 0, 0);
        OS.SendMessage(this.handle, 4099, 1, n6);
        this.fixCheckboxImageList(false);
        OS.SendMessage(this.handle, 4099, 1, 0);
        if (this.headerImageList != null) {
            int n7 = this.headerImageList.getHandle();
            OS.SendMessage(this.hwndHeader, 4616, 0, n7);
        }
        OS.ImageList_Destroy(n6);
        if (bl2 && n4 != 0) {
            this.setTopIndex(n4);
            this.setRedraw(true);
        }
    }

    public TableColumn getColumn(int n2) {
        this.checkWidget();
        if (0 > n2 || n2 >= this.columnCount) {
            this.error(6);
        }
        return this.columns[n2];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        if (this.columnCount == 0) {
            return new int[0];
        }
        int[] nArray = new int[this.columnCount];
        OS.SendMessage(this.handle, 4155, this.columnCount, nArray);
        return nArray;
    }

    public TableColumn[] getColumns() {
        this.checkWidget();
        TableColumn[] tableColumnArray = new TableColumn[this.columnCount];
        System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columnCount);
        return tableColumnArray;
    }

    int getFocusIndex() {
        return OS.SendMessage(this.handle, 4108, -1, 1);
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getGridLineWidthInPixels());
    }

    int getGridLineWidthInPixels() {
        return 1;
    }

    public Color getHeaderBackground() {
        this.checkWidget();
        return Color.win32_new(this.display, this.getHeaderBackgroundPixel());
    }

    private int getHeaderBackgroundPixel() {
        return this.headerBackground != -1 ? this.headerBackground : this.defaultBackground();
    }

    public Color getHeaderForeground() {
        this.checkWidget();
        return Color.win32_new(this.display, this.getHeaderForegroundPixel());
    }

    private int getHeaderForegroundPixel() {
        return this.headerForeground != -1 ? this.headerForeground : this.defaultForeground();
    }

    public int getHeaderHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getHeaderHeightInPixels());
    }

    int getHeaderHeightInPixels() {
        if (this.hwndHeader == 0) {
            return 0;
        }
        RECT rECT = new RECT();
        OS.GetWindowRect(this.hwndHeader, rECT);
        return rECT.bottom - rECT.top;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        int n2 = OS.GetWindowLong(this.handle, -16);
        return (n2 & 0x4000) == 0;
    }

    public TableItem getItem(int n2) {
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (0 > n2 || n2 >= n3) {
            this.error(6);
        }
        return this._getItem(n2);
    }

    public TableItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.getItemInPixels(DPIUtil.autoScaleUp(point));
    }

    TableItem getItemInPixels(Point point) {
        int n2 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (n2 == 0) {
            return null;
        }
        LVHITTESTINFO lVHITTESTINFO = new LVHITTESTINFO();
        lVHITTESTINFO.x = point.x;
        lVHITTESTINFO.y = point.y;
        if ((this.style & 0x10000) == 0 && this.hooks(41)) {
            if (OS.SendMessage(this.handle, 4153, 0, lVHITTESTINFO) < 0) {
                RECT rECT = new RECT();
                rECT.left = 1;
                this.ignoreCustomDraw = true;
                int n3 = OS.SendMessage(this.handle, 4110, 0, rECT);
                this.ignoreCustomDraw = false;
                if (n3 != 0) {
                    lVHITTESTINFO.x = rECT.left;
                    OS.SendMessage(this.handle, 4153, 0, lVHITTESTINFO);
                    if (lVHITTESTINFO.iItem < 0) {
                        lVHITTESTINFO.iItem = -1;
                    }
                }
            }
            if (lVHITTESTINFO.iItem != -1 && lVHITTESTINFO.iSubItem == 0 && this.hitTestSelection(lVHITTESTINFO.iItem, lVHITTESTINFO.x, lVHITTESTINFO.y)) {
                return this._getItem(lVHITTESTINFO.iItem);
            }
            return null;
        }
        OS.SendMessage(this.handle, 4114, 0, lVHITTESTINFO);
        if (lVHITTESTINFO.iItem != -1) {
            int n4;
            if (lVHITTESTINFO.iItem == 0 && ((n4 = OS.GetWindowLong(this.handle, -16)) & 0x4000) == 0 && this.hwndHeader != 0) {
                RECT rECT = new RECT();
                OS.GetWindowRect(this.hwndHeader, rECT);
                POINT pOINT = new POINT();
                pOINT.x = lVHITTESTINFO.x;
                pOINT.y = lVHITTESTINFO.y;
                OS.MapWindowPoints(this.handle, 0, pOINT, 1);
                if (OS.PtInRect(rECT, pOINT)) {
                    return null;
                }
            }
            return this._getItem(lVHITTESTINFO.iItem);
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 4100, 0, 0);
    }

    public int getItemHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getItemHeightInPixels());
    }

    int getItemHeightInPixels() {
        if (!this.painted && this.hooks(41)) {
            this.hitTestSelection(0, 0, 0);
        }
        int n2 = OS.SendMessage(this.handle, 4160, 0, 0);
        int n3 = OS.SendMessage(this.handle, 4160, 1, 0);
        return OS.HIWORD(n3) - OS.HIWORD(n2);
    }

    public TableItem[] getItems() {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 4100, 0, 0);
        TableItem[] tableItemArray = new TableItem[n2];
        if ((this.style & 0x10000000) != 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                tableItemArray[i2] = this._getItem(i2);
            }
        } else {
            this._getItems(tableItemArray, n2);
        }
        return tableItemArray;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return this._getLinesVisible();
    }

    private boolean _getLinesVisible() {
        int n2 = OS.SendMessage(this.handle, 4151, 0, 0);
        return (n2 & 1) != 0;
    }

    public TableItem[] getSelection() {
        this.checkWidget();
        int n2 = -1;
        int n3 = 0;
        int n4 = OS.SendMessage(this.handle, 4146, 0, 0);
        TableItem[] tableItemArray = new TableItem[n4];
        while ((n2 = OS.SendMessage(this.handle, 4108, n2, 2)) != -1) {
            tableItemArray[n3++] = this._getItem(n2);
        }
        return tableItemArray;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 4146, 0, 0);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 4108, -1, 1);
        int n3 = OS.SendMessage(this.handle, 4108, -1, 2);
        if (n2 == n3) {
            return n3;
        }
        int n4 = -1;
        while ((n4 = OS.SendMessage(this.handle, 4108, n4, 2)) != -1) {
            if (n4 != n2) continue;
            return n4;
        }
        return n3;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        int n2 = -1;
        int n3 = 0;
        int n4 = OS.SendMessage(this.handle, 4146, 0, 0);
        int[] nArray = new int[n4];
        while ((n2 = OS.SendMessage(this.handle, 4108, n2, 2)) != -1) {
            nArray[n3++] = n2;
        }
        return nArray;
    }

    public TableColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    int getSortColumnPixel() {
        int n2 = OS.IsWindowEnabled(this.handle) ? this.getBackgroundPixel() : OS.GetSysColor(OS.COLOR_3DFACE);
        return this.getSlightlyDifferentColor(n2);
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    public int getTopIndex() {
        this.checkWidget();
        return Math.max(0, OS.SendMessage(this.handle, 4135, 0, 0));
    }

    boolean hasChildren() {
        int n2 = OS.GetWindow(this.handle, 5);
        while (n2 != 0) {
            if (n2 != this.hwndHeader) {
                return true;
            }
            n2 = OS.GetWindow(n2, 2);
        }
        return false;
    }

    boolean hitTestSelection(int n2, int n3, int n4) {
        int n5 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (n5 == 0) {
            return false;
        }
        if (!this.hooks(41)) {
            return false;
        }
        boolean bl2 = false;
        if (0 <= n2 && n2 < n5) {
            Event event;
            int n6;
            TableItem tableItem = this._getItem(n2);
            int n7 = OS.GetDC(this.handle);
            int n8 = 0;
            int n9 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n9 != 0) {
                n8 = OS.SelectObject(n7, n9);
            }
            if ((n6 = tableItem.fontHandle(0)) != -1) {
                n6 = OS.SelectObject(n7, n6);
            }
            if ((event = this.sendMeasureItemEvent(tableItem, n2, 0, n7)).getBoundsInPixels().contains(n3, n4)) {
                bl2 = true;
            }
            if (n6 != -1) {
                n6 = OS.SelectObject(n7, n6);
            }
            if (n9 != 0) {
                OS.SelectObject(n7, n8);
            }
            OS.ReleaseDC(this.handle, n7);
        }
        return bl2;
    }

    int imageIndex(Image image, int n2) {
        if (image == null) {
            return -2;
        }
        if (n2 == 0) {
            this.firstColumnImage = true;
        } else {
            this.setSubImagesVisible(true);
        }
        if (this.imageList == null) {
            Rectangle rectangle = image.getBoundsInPixels();
            this.imageList = this.display.getImageList(this.style & 0x4000000, rectangle.width, rectangle.height);
            int n3 = this.imageList.indexOf(image);
            if (n3 == -1) {
                n3 = this.imageList.add(image);
            }
            int n4 = this.imageList.getHandle();
            int n5 = this.getTopIndex();
            if (n5 != 0) {
                this.setRedraw(false);
                this.setTopIndex(0);
            }
            OS.SendMessage(this.handle, 4099, 1, n4);
            if (this.headerImageList != null) {
                int n6 = this.headerImageList.getHandle();
                OS.SendMessage(this.hwndHeader, 4616, 0, n6);
            }
            this.fixCheckboxImageList(false);
            this.setItemHeight(false);
            if (n5 != 0) {
                this.setTopIndex(n5);
                this.setRedraw(true);
            }
            return n3;
        }
        int n7 = this.imageList.indexOf(image);
        if (n7 != -1) {
            return n7;
        }
        return this.imageList.add(image);
    }

    int imageIndexHeader(Image image) {
        if (image == null) {
            return -2;
        }
        if (this.headerImageList == null) {
            Rectangle rectangle = image.getBoundsInPixels();
            this.headerImageList = this.display.getImageList(this.style & 0x4000000, rectangle.width, rectangle.height);
            int n2 = this.headerImageList.indexOf(image);
            if (n2 == -1) {
                n2 = this.headerImageList.add(image);
            }
            int n3 = this.headerImageList.getHandle();
            OS.SendMessage(this.hwndHeader, 4616, 0, n3);
            return n2;
        }
        int n4 = this.headerImageList.indexOf(image);
        if (n4 != -1) {
            return n4;
        }
        return this.headerImageList.add(image);
    }

    public int indexOf(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            if (this.columns[i2] != tableColumn) continue;
            return i2;
        }
        return -1;
    }

    public int indexOf(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        if (this.keys == null) {
            int n2 = OS.SendMessage(this.handle, 4100, 0, 0);
            if (1 <= this.lastIndexOf && this.lastIndexOf < n2 - 1) {
                if (this._getItem(this.lastIndexOf, false) == tableItem) {
                    return this.lastIndexOf;
                }
                if (this._getItem(this.lastIndexOf + 1, false) == tableItem) {
                    return ++this.lastIndexOf;
                }
                if (this._getItem(this.lastIndexOf - 1, false) == tableItem) {
                    return --this.lastIndexOf;
                }
            }
            if (this.lastIndexOf < n2 / 2) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this._getItem(i2, false) != tableItem) continue;
                    this.lastIndexOf = i2;
                    return this.lastIndexOf;
                }
            } else {
                for (int i3 = n2 - 1; i3 >= 0; --i3) {
                    if (this._getItem(i3, false) != tableItem) continue;
                    this.lastIndexOf = i3;
                    return this.lastIndexOf;
                }
            }
        } else {
            for (int i4 = 0; i4 < this.keyCount; ++i4) {
                if (this.items[i4] != tableItem) continue;
                return this.keys[i4];
            }
        }
        return -1;
    }

    boolean isCustomToolTip() {
        return this.hooks(41);
    }

    boolean isOptimizedRedraw() {
        if ((this.style & 0x100) == 0 || (this.style & 0x200) == 0) {
            return false;
        }
        return !this.hasChildren() && !this.hooks(9) && !this.filters(9);
    }

    public boolean isSelected(int n2) {
        this.checkWidget();
        LVITEM lVITEM = new LVITEM();
        lVITEM.mask = 8;
        lVITEM.stateMask = 2;
        lVITEM.iItem = n2;
        int n3 = OS.SendMessage(this.handle, OS.LVM_GETITEM, 0, lVITEM);
        return n3 != 0 && (lVITEM.state & 2) != 0;
    }

    @Override
    void register() {
        super.register();
        if (this.hwndHeader != 0) {
            this.display.addControl(this.hwndHeader, this);
        }
    }

    @Override
    void releaseChildren(boolean bl2) {
        int n2;
        if (this._hasItems()) {
            TableItem tableItem;
            int n3;
            n2 = OS.SendMessage(this.handle, 4100, 0, 0);
            if (OS.IsWin95 && this.columnCount > 1) {
                this.resizeCount = 1;
                OS.SendMessage(this.handle, 11, 0, 0);
                for (n3 = n2 - 1; n3 >= 0; --n3) {
                    tableItem = this._getItem(n3, false);
                    if (tableItem != null && !tableItem.isDisposed()) {
                        tableItem.release(false);
                    }
                    this.ignoreShrink = true;
                    this.ignoreSelect = true;
                    OS.SendMessage(this.handle, 4104, n3, 0);
                    this.ignoreShrink = false;
                    this.ignoreSelect = false;
                }
            } else if (this.keys == null) {
                for (n3 = 0; n3 < n2; ++n3) {
                    tableItem = this._getItem(n3, false);
                    if (tableItem == null || tableItem.isDisposed()) continue;
                    tableItem.release(false);
                }
            } else {
                for (n3 = 0; n3 < this.keyCount; ++n3) {
                    tableItem = this.items[n3];
                    if (tableItem == null || tableItem.isDisposed()) continue;
                    tableItem.release(false);
                }
            }
            this._clearItems();
        }
        if (this.columns != null) {
            for (n2 = 0; n2 < this.columnCount; ++n2) {
                TableColumn tableColumn = this.columns[n2];
                if (tableColumn.isDisposed()) continue;
                tableColumn.release(false);
            }
            this.columns = null;
        }
        super.releaseChildren(bl2);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.customDraw = false;
        this.currentItem = null;
        if (this.imageList != null) {
            OS.SendMessage(this.handle, 4099, 1, 0);
            this.display.releaseImageList(this.imageList);
        }
        if (this.headerImageList != null) {
            OS.SendMessage(this.hwndHeader, 4616, 0, 0);
            this.display.releaseImageList(this.headerImageList);
        }
        this.headerImageList = null;
        this.imageList = null;
        int n2 = OS.SendMessage(this.handle, 4098, 2, 0);
        OS.SendMessage(this.handle, 4099, 2, 0);
        if (n2 != 0) {
            OS.ImageList_Destroy(n2);
        }
        if (this.headerToolTipHandle != 0) {
            OS.DestroyWindow(this.headerToolTipHandle);
        }
        this.headerToolTipHandle = 0;
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.sort(nArray2);
        int n2 = nArray2[nArray2.length - 1];
        int n3 = nArray2[0];
        int n4 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (0 > n2 || n2 > n3 || n3 >= n4) {
            this.error(6);
        }
        this.setDeferResize(true);
        int n5 = -1;
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            int n6 = nArray2[i2];
            if (n6 == n5) continue;
            TableItem tableItem = this._getItem(n6, false);
            if (tableItem != null && !tableItem.isDisposed()) {
                tableItem.release(false);
            }
            this.ignoreShrink = true;
            this.ignoreSelect = true;
            int n7 = OS.SendMessage(this.handle, 4104, n6, 0);
            this.ignoreShrink = false;
            this.ignoreSelect = false;
            if (n7 == 0) {
                this.error(15);
            }
            this._removeItem(n6, n4);
            --n4;
            n5 = n6;
        }
        if (n4 == 0) {
            this.setTableEmpty();
        }
        this.setDeferResize(false);
    }

    public void remove(int n2) {
        TableItem tableItem;
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (0 > n2 || n2 >= n3) {
            this.error(6);
        }
        if ((tableItem = this._getItem(n2, false)) != null && !tableItem.isDisposed()) {
            tableItem.release(false);
        }
        this.setDeferResize(true);
        this.ignoreShrink = true;
        this.ignoreSelect = true;
        int n4 = OS.SendMessage(this.handle, 4104, n2, 0);
        this.ignoreShrink = false;
        this.ignoreSelect = false;
        if (n4 == 0) {
            this.error(15);
        }
        this._removeItem(n2, n3);
        if (--n3 == 0) {
            this.setTableEmpty();
        }
        this.setDeferResize(false);
    }

    public void remove(int n2, int n3) {
        this.checkWidget();
        if (n2 > n3) {
            return;
        }
        int n4 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (0 > n2 || n2 > n3 || n3 >= n4) {
            this.error(6);
        }
        if (n2 == 0 && n3 == n4 - 1) {
            this.removeAll();
        } else {
            int n5;
            this.setDeferResize(true);
            for (n5 = n2; n5 <= n3; ++n5) {
                TableItem tableItem = this._getItem(n5, false);
                if (tableItem != null && !tableItem.isDisposed()) {
                    tableItem.release(false);
                }
                this.ignoreShrink = true;
                this.ignoreSelect = true;
                int n6 = OS.SendMessage(this.handle, 4104, n2, 0);
                this.ignoreShrink = false;
                this.ignoreSelect = false;
                if (n6 == 0) break;
            }
            this._removeItems(n2, n5, n4);
            if (n5 <= n3) {
                this.error(15);
            }
            this.setDeferResize(false);
        }
    }

    public void removeAll() {
        int n2;
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 4100, 0, 0);
        for (n2 = 0; n2 < n3; ++n2) {
            TableItem tableItem = this._getItem(n2, false);
            if (tableItem == null || tableItem.isDisposed()) continue;
            tableItem.release(false);
        }
        this.setDeferResize(true);
        if (OS.IsWin95 && this.columnCount > 1) {
            int n4;
            int n5 = n2 = this.getDrawing() && OS.IsWindowVisible(this.handle) ? 1 : 0;
            if (n2 != 0) {
                OS.SendMessage(this.handle, 11, 0, 0);
            }
            for (n4 = n3 - 1; n4 >= 0; --n4) {
                this.ignoreShrink = true;
                this.ignoreSelect = true;
                int n6 = OS.SendMessage(this.handle, 4104, n4, 0);
                this.ignoreShrink = false;
                this.ignoreSelect = false;
                if (n6 == 0) break;
            }
            if (n2 != 0) {
                OS.SendMessage(this.handle, 11, 1, 0);
            }
            if (n4 != -1) {
                this.error(15);
            }
        } else {
            this.ignoreShrink = true;
            this.ignoreSelect = true;
            n2 = OS.SendMessage(this.handle, 4105, 0, 0);
            this.ignoreShrink = false;
            this.ignoreSelect = false;
            if (n2 == 0) {
                this.error(15);
            }
        }
        this.setTableEmpty();
        this.setDeferResize(false);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void select(int[] nArray) {
        int n2;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if ((n2 = nArray.length) == 0 || (this.style & 4) != 0 && n2 > 1) {
            return;
        }
        LVITEM lVITEM = new LVITEM();
        lVITEM.state = 2;
        lVITEM.stateMask = 2;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            if (nArray[i2] < 0) continue;
            this.ignoreSelect = true;
            OS.SendMessage(this.handle, 4139, nArray[i2], lVITEM);
            this.ignoreSelect = false;
        }
    }

    @Override
    void reskinChildren(int n2) {
        int n3;
        if (this._hasItems()) {
            n3 = OS.SendMessage(this.handle, 4100, 0, 0);
            for (int i2 = 0; i2 < n3; ++i2) {
                TableItem tableItem = this._getItem(i2, false);
                if (tableItem == null) continue;
                tableItem.reskin(n2);
            }
        }
        if (this.columns != null) {
            for (n3 = 0; n3 < this.columnCount; ++n3) {
                TableColumn tableColumn = this.columns[n3];
                if (tableColumn.isDisposed()) continue;
                tableColumn.reskin(n2);
            }
        }
        super.reskinChildren(n2);
    }

    public void select(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        LVITEM lVITEM = new LVITEM();
        lVITEM.state = 2;
        lVITEM.stateMask = 2;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, n2, lVITEM);
        this.ignoreSelect = false;
    }

    public void select(int n2, int n3) {
        this.checkWidget();
        if (n3 < 0 || n2 > n3 || (this.style & 4) != 0 && n2 != n3) {
            return;
        }
        int n4 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (n4 == 0 || n2 >= n4) {
            return;
        }
        n2 = Math.max(0, n2);
        n3 = Math.min(n3, n4 - 1);
        if (n2 == 0 && n3 == n4 - 1) {
            this.selectAll();
        } else {
            LVITEM lVITEM = new LVITEM();
            lVITEM.state = 2;
            lVITEM.stateMask = 2;
            for (int i2 = n2; i2 <= n3; ++i2) {
                this.ignoreSelect = true;
                OS.SendMessage(this.handle, 4139, i2, lVITEM);
                this.ignoreSelect = false;
            }
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        LVITEM lVITEM = new LVITEM();
        lVITEM.mask = 8;
        lVITEM.state = 2;
        lVITEM.stateMask = 2;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, -1, lVITEM);
        this.ignoreSelect = false;
    }

    void sendEraseItemEvent(TableItem tableItem, NMLVCUSTOMDRAW nMLVCUSTOMDRAW, int n2, Event event) {
        RECT rECT;
        boolean bl2;
        int n3;
        int n4;
        int n5 = nMLVCUSTOMDRAW.hdc;
        int n6 = n4 = tableItem.cellForeground != null ? tableItem.cellForeground[nMLVCUSTOMDRAW.iSubItem] : -1;
        if (n4 == -1) {
            n4 = tableItem.foreground;
        }
        int n7 = -1;
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && this.sortColumn != null && this.sortDirection != 0 && this.findImageControl() == null && this.indexOf(this.sortColumn) == nMLVCUSTOMDRAW.iSubItem) {
            n7 = this.getSortColumnPixel();
        }
        int n8 = n7 = tableItem.cellBackground != null ? tableItem.cellBackground[nMLVCUSTOMDRAW.iSubItem] : -1;
        if (n7 == -1) {
            n7 = tableItem.background;
        }
        LVITEM lVITEM = new LVITEM();
        lVITEM.mask = 8;
        lVITEM.stateMask = 2;
        lVITEM.iItem = nMLVCUSTOMDRAW.dwItemSpec;
        int n9 = OS.SendMessage(this.handle, OS.LVM_GETITEM, 0, lVITEM);
        boolean bl3 = n9 != 0 && (lVITEM.state & 2) != 0;
        GCData gCData = new GCData();
        gCData.device = this.display;
        int n10 = -1;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        if (nMLVCUSTOMDRAW.iSubItem == 0 || (this.style & 0x10000) != 0) {
            bl6 = this.hotIndex == nMLVCUSTOMDRAW.dwItemSpec;
            boolean bl8 = bl7 = (nMLVCUSTOMDRAW.uItemState & 0x1000) != 0;
        }
        if (OS.IsWindowEnabled(this.handle)) {
            if (bl3 && (nMLVCUSTOMDRAW.iSubItem == 0 || (this.style & 0x10000) != 0)) {
                if (OS.GetFocus() == this.handle || this.display.getHighContrast()) {
                    bl4 = true;
                    gCData.foreground = OS.GetSysColor(OS.COLOR_HIGHLIGHTTEXT);
                    gCData.background = n10 = OS.GetSysColor(OS.COLOR_HIGHLIGHT);
                } else {
                    bl4 = (this.style & 0x8000) == 0;
                    gCData.foreground = OS.GetTextColor(n5);
                    gCData.background = n10 = OS.GetSysColor(OS.COLOR_3DFACE);
                }
                if (this.explorerTheme) {
                    gCData.foreground = n4 != -1 ? n4 : this.getForegroundPixel();
                }
            } else {
                boolean bl9 = bl5 = n7 != -1;
                if (n4 == -1 || n7 == -1) {
                    Control control = this.findBackgroundControl();
                    if (control == null) {
                        control = this;
                    }
                    if (n4 == -1) {
                        n4 = control.getForegroundPixel();
                    }
                    if (n7 == -1) {
                        n7 = control.getBackgroundPixel();
                    }
                }
                gCData.foreground = n4 != -1 ? n4 : OS.GetTextColor(n5);
                gCData.background = n7 != -1 ? n7 : OS.GetBkColor(n5);
            }
        } else {
            gCData.foreground = OS.GetSysColor(OS.COLOR_GRAYTEXT);
            gCData.background = OS.GetSysColor(OS.COLOR_3DFACE);
            if (bl3) {
                n10 = gCData.background;
            }
        }
        gCData.font = tableItem.getFont(nMLVCUSTOMDRAW.iSubItem);
        gCData.uiState = OS.SendMessage(this.handle, 297, 0, 0);
        int n11 = OS.SaveDC(n5);
        GC gC = GC.win32_new(n5, gCData);
        RECT rECT2 = tableItem.getBounds(nMLVCUSTOMDRAW.dwItemSpec, nMLVCUSTOMDRAW.iSubItem, true, true, true, true, n5);
        Event event2 = new Event();
        event2.item = tableItem;
        event2.gc = gC;
        event2.index = nMLVCUSTOMDRAW.iSubItem;
        event2.detail |= 0x10;
        if (OS.SendMessage(this.handle, 4108, -1, 1) == nMLVCUSTOMDRAW.dwItemSpec && (nMLVCUSTOMDRAW.iSubItem == 0 || (this.style & 0x10000) != 0) && this.handle == OS.GetFocus() && ((n3 = OS.SendMessage(this.handle, 297, 0, 0)) & 1) == 0) {
            event2.detail |= 4;
        }
        int n12 = n3 = (event2.detail & 4) != 0 ? 1 : 0;
        if (bl6) {
            event2.detail |= 0x20;
        }
        if (bl4) {
            event2.detail |= 2;
        }
        if (bl5) {
            event2.detail |= 8;
        }
        Rectangle rectangle = new Rectangle(rECT2.left, rECT2.top, rECT2.right - rECT2.left, rECT2.bottom - rECT2.top);
        event2.setBoundsInPixels(rectangle);
        gC.setClipping(DPIUtil.autoScaleDown(rectangle));
        this.sendEvent(40, event2);
        event2.gc = null;
        int n13 = gCData.foreground;
        gC.dispose();
        OS.RestoreDC(n5, n11);
        if (this.isDisposed() || tableItem.isDisposed()) {
            return;
        }
        if (event2.doit) {
            this.ignoreDrawForeground = (event2.detail & 0x10) == 0;
            this.ignoreDrawBackground = (event2.detail & 8) == 0;
            this.ignoreDrawSelection = (event2.detail & 2) == 0;
            this.ignoreDrawFocus = (event2.detail & 4) == 0;
            this.ignoreDrawHot = (event2.detail & 0x20) == 0;
        } else {
            this.ignoreDrawHot = true;
            this.ignoreDrawFocus = true;
            this.ignoreDrawSelection = true;
            this.ignoreDrawBackground = true;
            this.ignoreDrawForeground = true;
        }
        if (bl4) {
            if (this.ignoreDrawSelection) {
                this.ignoreDrawHot = true;
                if (nMLVCUSTOMDRAW.iSubItem == 0 || (this.style & 0x10000) != 0) {
                    this.selectionForeground = n13;
                }
                nMLVCUSTOMDRAW.uItemState &= 0xFFFFFFFE;
                OS.MoveMemory(n2, nMLVCUSTOMDRAW, NMLVCUSTOMDRAW.sizeof);
            }
        } else if (this.ignoreDrawSelection) {
            nMLVCUSTOMDRAW.uItemState |= 1;
            OS.MoveMemory(n2, nMLVCUSTOMDRAW, NMLVCUSTOMDRAW.sizeof);
        }
        boolean bl10 = bl2 = nMLVCUSTOMDRAW.iSubItem == OS.SendMessage(this.hwndHeader, 4623, 0, 0);
        if (this.ignoreDrawForeground && this.ignoreDrawHot && !bl7 && !this.ignoreDrawBackground && bl5) {
            rECT = tableItem.getBounds(nMLVCUSTOMDRAW.dwItemSpec, nMLVCUSTOMDRAW.iSubItem, true, false, true, false, n5);
            this.fillBackground(n5, n7, rECT);
        }
        this.focusRect = null;
        if (!this.ignoreDrawHot || !this.ignoreDrawSelection || !this.ignoreDrawFocus || bl7) {
            Object object;
            boolean bl11 = (this.style & 0x10000) != 0 || !bl2;
            RECT rECT3 = tableItem.getBounds(nMLVCUSTOMDRAW.dwItemSpec, nMLVCUSTOMDRAW.iSubItem, true, false, bl11, false, n5);
            if ((this.style & 0x10000) == 0) {
                if (event != null) {
                    object = event.getBoundsInPixels();
                    rECT3.right = Math.min(rECT2.right, ((Rectangle)object).x + ((Rectangle)object).width);
                }
                if (!this.ignoreDrawFocus) {
                    nMLVCUSTOMDRAW.uItemState &= 0xFFFFFFEF;
                    OS.MoveMemory(n2, nMLVCUSTOMDRAW, NMLVCUSTOMDRAW.sizeof);
                    this.focusRect = rECT3;
                }
            }
            if (this.explorerTheme) {
                if (!this.ignoreDrawHot || bl7 || !this.ignoreDrawSelection && n10 != -1) {
                    int n14;
                    int n15;
                    object = new RECT();
                    OS.SetRect((RECT)object, nMLVCUSTOMDRAW.left, nMLVCUSTOMDRAW.top, nMLVCUSTOMDRAW.right, nMLVCUSTOMDRAW.bottom);
                    RECT rECT4 = new RECT();
                    OS.SetRect(rECT4, nMLVCUSTOMDRAW.left, nMLVCUSTOMDRAW.top, nMLVCUSTOMDRAW.right, nMLVCUSTOMDRAW.bottom);
                    if ((this.style & 0x10000) != 0) {
                        n15 = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
                        n14 = OS.SendMessage(this.hwndHeader, 4623, n15 - 1, 0);
                        RECT rECT5 = new RECT();
                        OS.SendMessage(this.hwndHeader, 4615, n14, rECT5);
                        OS.MapWindowPoints(this.hwndHeader, this.handle, rECT5, 2);
                        rECT4.right = rECT5.right;
                        n14 = OS.SendMessage(this.hwndHeader, 4623, 0, 0);
                        OS.SendMessage(this.hwndHeader, 4615, n14, rECT5);
                        OS.MapWindowPoints(this.hwndHeader, this.handle, rECT5, 2);
                        rECT4.left = rECT5.left;
                        ((RECT)object).left = rECT2.left;
                        ((RECT)object).right += 2;
                    } else {
                        rECT4.right += 2;
                        ((RECT)object).right += 2;
                    }
                    n15 = OS.OpenThemeData(this.handle, Display.LISTVIEW);
                    int n16 = n14 = bl3 ? 3 : 2;
                    if (OS.GetFocus() != this.handle && bl3 && !bl6) {
                        n14 = 5;
                    }
                    if (bl7) {
                        n14 = 3;
                    }
                    OS.DrawThemeBackground(n15, n5, 1, n14, rECT4, (RECT)object);
                    OS.CloseThemeData(n15);
                }
            } else if (!this.ignoreDrawSelection && n10 != -1) {
                this.fillBackground(n5, n10, rECT3);
            }
        }
        if (n3 != 0 && this.ignoreDrawFocus) {
            nMLVCUSTOMDRAW.uItemState &= 0xFFFFFFEF;
            OS.MoveMemory(n2, nMLVCUSTOMDRAW, NMLVCUSTOMDRAW.sizeof);
        }
        if (this.ignoreDrawForeground) {
            rECT = tableItem.getBounds(nMLVCUSTOMDRAW.dwItemSpec, nMLVCUSTOMDRAW.iSubItem, true, true, true, false, n5);
            OS.SaveDC(n5);
            OS.SelectClipRgn(n5, 0);
            OS.ExcludeClipRect(n5, rECT.left, rECT.top, rECT.right, rECT.bottom);
        }
    }

    Event sendEraseItemEvent(TableItem tableItem, NMTTCUSTOMDRAW nMTTCUSTOMDRAW, int n2, RECT rECT) {
        int n3 = OS.SaveDC(nMTTCUSTOMDRAW.hdc);
        RECT rECT2 = this.toolTipInset(rECT);
        OS.SetWindowOrgEx(nMTTCUSTOMDRAW.hdc, rECT2.left, rECT2.top, null);
        GCData gCData = new GCData();
        gCData.device = this.display;
        gCData.foreground = OS.GetTextColor(nMTTCUSTOMDRAW.hdc);
        gCData.background = OS.GetBkColor(nMTTCUSTOMDRAW.hdc);
        gCData.font = tableItem.getFont(n2);
        gCData.uiState = OS.SendMessage(this.handle, 297, 0, 0);
        GC gC = GC.win32_new(nMTTCUSTOMDRAW.hdc, gCData);
        Event event = new Event();
        event.item = tableItem;
        event.index = n2;
        event.gc = gC;
        event.detail |= 0x10;
        event.setBoundsInPixels(new Rectangle(rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top));
        this.sendEvent(40, event);
        event.gc = null;
        gC.dispose();
        OS.RestoreDC(nMTTCUSTOMDRAW.hdc, n3);
        return event;
    }

    Event sendMeasureItemEvent(TableItem tableItem, int n2, int n3, int n4) {
        int n5;
        int n6;
        Object object;
        GCData gCData = new GCData();
        gCData.device = this.display;
        gCData.font = tableItem.getFont(n3);
        int n7 = OS.SaveDC(n4);
        GC gC = GC.win32_new(n4, gCData);
        RECT rECT = tableItem.getBounds(n2, n3, true, true, false, false, n4);
        Event event = new Event();
        event.item = tableItem;
        event.gc = gC;
        event.index = n3;
        event.setBoundsInPixels(new Rectangle(rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top));
        boolean bl2 = false;
        if (OS.IsWindowEnabled(this.handle)) {
            object = new LVITEM();
            ((LVITEM)object).mask = 8;
            ((LVITEM)object).stateMask = 2;
            ((LVITEM)object).iItem = n2;
            n6 = OS.SendMessage(this.handle, OS.LVM_GETITEM, 0, (LVITEM)object);
            int n8 = n5 = n6 != 0 && (((LVITEM)object).state & 2) != 0 ? 1 : 0;
            if (n5 != 0 && (n3 == 0 || (this.style & 0x10000) != 0)) {
                if (OS.GetFocus() == this.handle || this.display.getHighContrast()) {
                    bl2 = true;
                } else {
                    boolean bl3 = bl2 = (this.style & 0x8000) == 0;
                }
            }
        }
        if (bl2) {
            event.detail |= 2;
        }
        this.sendEvent(41, event);
        event.gc = null;
        gC.dispose();
        OS.RestoreDC(n4, n7);
        if (!this.isDisposed() && !tableItem.isDisposed()) {
            object = event.getBoundsInPixels();
            if (this.columnCount == 0 && ((Rectangle)object).x + ((Rectangle)object).width > (n6 = OS.SendMessage(this.handle, 4125, 0, 0))) {
                this.setScrollWidth(((Rectangle)object).x + ((Rectangle)object).width);
            }
            n6 = OS.SendMessage(this.handle, 4160, 0, 0);
            n5 = OS.SendMessage(this.handle, 4160, 1, 0);
            int n9 = OS.HIWORD(n5) - OS.HIWORD(n6);
            if (!this.settingItemHeight && ((Rectangle)object).height > n9) {
                this.settingItemHeight = true;
                this.setItemHeight(((Rectangle)object).height);
                this.settingItemHeight = false;
            }
        }
        return event;
    }

    LRESULT sendMouseDownEvent(int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        int n9;
        Display display = this.display;
        display.captureChanged = false;
        if (!this.sendMouseEvent(n2, n3, this.handle, n4, n5, n6)) {
            if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            return LRESULT.ZERO;
        }
        LVHITTESTINFO lVHITTESTINFO = new LVHITTESTINFO();
        lVHITTESTINFO.x = OS.GET_X_LPARAM(n6);
        lVHITTESTINFO.y = OS.GET_Y_LPARAM(n6);
        OS.SendMessage(this.handle, 4114, 0, lVHITTESTINFO);
        if ((this.style & 0x10000) == 0 && this.hooks(41)) {
            if (OS.SendMessage(this.handle, 4153, 0, lVHITTESTINFO) < 0) {
                n9 = OS.SendMessage(this.handle, 4100, 0, 0);
                if (n9) {
                    RECT rECT = new RECT();
                    rECT.left = 1;
                    this.ignoreCustomDraw = true;
                    n8 = OS.SendMessage(this.handle, 4110, 0, rECT);
                    this.ignoreCustomDraw = false;
                    if (n8 != 0) {
                        lVHITTESTINFO.x = rECT.left;
                        OS.SendMessage(this.handle, 4153, 0, lVHITTESTINFO);
                        if (lVHITTESTINFO.iItem < 0) {
                            lVHITTESTINFO.iItem = -1;
                        }
                        lVHITTESTINFO.flags &= 0xFFFFFFF9;
                    }
                }
            } else if (lVHITTESTINFO.iSubItem != 0) {
                lVHITTESTINFO.iItem = -1;
            }
        }
        OS.SetFocus(this.handle);
        if (((this.style & 4) != 0 || this.hooks(3) || this.hooks(4)) && lVHITTESTINFO.iItem == -1) {
            if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            return LRESULT.ZERO;
        }
        n9 = 0;
        int n10 = OS.SendMessage(this.handle, 4146, 0, 0);
        if (n10 == 1 && lVHITTESTINFO.iItem != -1) {
            LVITEM lVITEM = new LVITEM();
            lVITEM.mask = 8;
            lVITEM.stateMask = 2;
            lVITEM.iItem = lVHITTESTINFO.iItem;
            OS.SendMessage(this.handle, OS.LVM_GETITEM, 0, lVITEM);
            if ((lVITEM.state & 2) != 0) {
                n9 = 1;
            }
        }
        this.fullRowSelect = false;
        if (lVHITTESTINFO.iItem != -1 && (this.style & 0x10000) == 0 && this.hooks(41)) {
            this.fullRowSelect = this.hitTestSelection(lVHITTESTINFO.iItem, lVHITTESTINFO.x, lVHITTESTINFO.y);
            if (this.fullRowSelect && (lVHITTESTINFO.flags & (n8 = 6)) != 0) {
                this.fullRowSelect = false;
            }
        }
        int n11 = n8 = (this.state & 0x8000) != 0 && this.hooks(29) ? 1 : 0;
        if (n8 == 0) {
            n7 = 6;
            int n12 = n8 = lVHITTESTINFO.iItem == -1 || (lVHITTESTINFO.flags & n7) == 0 ? 1 : 0;
            if (this.fullRowSelect) {
                n8 = 1;
            }
        }
        if (this.fullRowSelect) {
            OS.UpdateWindow(this.handle);
            OS.DefWindowProc(this.handle, 11, 0, 0);
            OS.SendMessage(this.handle, 4150, 32, 32);
        }
        this.dragStarted = false;
        display.dragCancelled = false;
        if (n8 == 0) {
            display.runDragDrop = false;
        }
        n7 = this.callWindowProc(this.handle, n4, n5, n6, n9 != 0);
        if (n8 == 0) {
            display.runDragDrop = true;
        }
        if (this.fullRowSelect) {
            this.fullRowSelect = false;
            OS.DefWindowProc(this.handle, 11, 1, 0);
            OS.SendMessage(this.handle, 4150, 32, 0);
        }
        if (this.dragStarted || display.dragCancelled) {
            if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
        } else {
            boolean bl2;
            int n13 = 6;
            boolean bl3 = bl2 = (lVHITTESTINFO.flags & n13) != 0;
            if (!bl2 && (this.style & 2) != 0) {
                boolean bl4 = bl2 = (lVHITTESTINFO.flags & 8) == 0;
            }
            if (bl2) {
                this.sendMouseEvent(4, n3, this.handle, n4, n5, n6);
            }
        }
        return new LRESULT(n7);
    }

    void sendPaintItemEvent(TableItem tableItem, NMLVCUSTOMDRAW nMLVCUSTOMDRAW) {
        int n2;
        Object object;
        int n3;
        int n4 = nMLVCUSTOMDRAW.hdc;
        GCData gCData = new GCData();
        gCData.device = this.display;
        gCData.font = tableItem.getFont(nMLVCUSTOMDRAW.iSubItem);
        LVITEM lVITEM = new LVITEM();
        lVITEM.mask = 8;
        lVITEM.stateMask = 2;
        lVITEM.iItem = nMLVCUSTOMDRAW.dwItemSpec;
        int n5 = OS.SendMessage(this.handle, OS.LVM_GETITEM, 0, lVITEM);
        boolean bl2 = n5 != 0 && (lVITEM.state & 2) != 0;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (nMLVCUSTOMDRAW.iSubItem == 0 || (this.style & 0x10000) != 0) {
            boolean bl6 = bl5 = this.hotIndex == nMLVCUSTOMDRAW.dwItemSpec;
        }
        if (OS.IsWindowEnabled(this.handle)) {
            if (bl2 && (nMLVCUSTOMDRAW.iSubItem == 0 || (this.style & 0x10000) != 0)) {
                if (OS.GetFocus() == this.handle || this.display.getHighContrast()) {
                    bl3 = true;
                    gCData.foreground = this.selectionForeground != -1 ? this.selectionForeground : OS.GetSysColor(OS.COLOR_HIGHLIGHTTEXT);
                    gCData.background = OS.GetSysColor(OS.COLOR_HIGHLIGHT);
                } else {
                    bl3 = (this.style & 0x8000) == 0;
                    gCData.foreground = OS.GetTextColor(n4);
                    gCData.background = OS.GetSysColor(OS.COLOR_3DFACE);
                }
                if (this.explorerTheme && this.selectionForeground == -1) {
                    int n6 = n3 = tableItem.cellForeground != null ? tableItem.cellForeground[nMLVCUSTOMDRAW.iSubItem] : -1;
                    if (n3 == -1) {
                        n3 = tableItem.foreground;
                    }
                    gCData.foreground = n3 != -1 ? n3 : this.getForegroundPixel();
                }
            } else {
                int n7;
                int n8 = n3 = tableItem.cellForeground != null ? tableItem.cellForeground[nMLVCUSTOMDRAW.iSubItem] : -1;
                if (n3 == -1) {
                    n3 = tableItem.foreground;
                }
                int n9 = n7 = tableItem.cellBackground != null ? tableItem.cellBackground[nMLVCUSTOMDRAW.iSubItem] : -1;
                if (n7 == -1) {
                    n7 = tableItem.background;
                }
                boolean bl7 = bl4 = n7 != -1;
                if (n3 == -1 || n7 == -1) {
                    object = this.findBackgroundControl();
                    if (object == null) {
                        object = this;
                    }
                    if (n3 == -1) {
                        n3 = ((Control)object).getForegroundPixel();
                    }
                    if (n7 == -1) {
                        n7 = ((Control)object).getBackgroundPixel();
                    }
                }
                gCData.foreground = n3 != -1 ? n3 : OS.GetTextColor(n4);
                gCData.background = n7 != -1 ? n7 : OS.GetBkColor(n4);
            }
        } else {
            gCData.foreground = OS.GetSysColor(OS.COLOR_GRAYTEXT);
            gCData.background = OS.GetSysColor(OS.COLOR_3DFACE);
        }
        gCData.uiState = OS.SendMessage(this.handle, 297, 0, 0);
        n3 = OS.SaveDC(n4);
        GC gC = GC.win32_new(n4, gCData);
        object = tableItem.getBounds(nMLVCUSTOMDRAW.dwItemSpec, nMLVCUSTOMDRAW.iSubItem, true, true, false, false, n4);
        Event event = new Event();
        event.item = tableItem;
        event.gc = gC;
        event.index = nMLVCUSTOMDRAW.iSubItem;
        event.detail |= 0x10;
        if (OS.SendMessage(this.handle, 4108, -1, 1) == nMLVCUSTOMDRAW.dwItemSpec && (nMLVCUSTOMDRAW.iSubItem == 0 || (this.style & 0x10000) != 0) && this.handle == OS.GetFocus() && ((n2 = OS.SendMessage(this.handle, 297, 0, 0)) & 1) == 0) {
            event.detail |= 4;
        }
        if (bl5) {
            event.detail |= 0x20;
        }
        if (bl3) {
            event.detail |= 2;
        }
        if (bl4) {
            event.detail |= 8;
        }
        event.setBoundsInPixels(new Rectangle(((RECT)object).left, ((RECT)object).top, ((RECT)object).right - ((RECT)object).left, ((RECT)object).bottom - ((RECT)object).top));
        RECT rECT = tableItem.getBounds(nMLVCUSTOMDRAW.dwItemSpec, nMLVCUSTOMDRAW.iSubItem, true, true, true, true, n4);
        int n10 = rECT.right - rECT.left;
        int n11 = rECT.bottom - rECT.top;
        gC.setClipping(DPIUtil.autoScaleDown(new Rectangle(rECT.left, rECT.top, n10, n11)));
        this.sendEvent(42, event);
        if (gCData.focusDrawn) {
            this.focusRect = null;
        }
        event.gc = null;
        gC.dispose();
        OS.RestoreDC(n4, n3);
    }

    Event sendPaintItemEvent(TableItem tableItem, NMTTCUSTOMDRAW nMTTCUSTOMDRAW, int n2, RECT rECT) {
        int n3 = OS.SaveDC(nMTTCUSTOMDRAW.hdc);
        RECT rECT2 = this.toolTipInset(rECT);
        OS.SetWindowOrgEx(nMTTCUSTOMDRAW.hdc, rECT2.left, rECT2.top, null);
        GCData gCData = new GCData();
        gCData.device = this.display;
        gCData.font = tableItem.getFont(n2);
        gCData.foreground = OS.GetTextColor(nMTTCUSTOMDRAW.hdc);
        gCData.background = OS.GetBkColor(nMTTCUSTOMDRAW.hdc);
        gCData.uiState = OS.SendMessage(this.handle, 297, 0, 0);
        GC gC = GC.win32_new(nMTTCUSTOMDRAW.hdc, gCData);
        Event event = new Event();
        event.item = tableItem;
        event.index = n2;
        event.gc = gC;
        event.detail |= 0x10;
        event.setBoundsInPixels(new Rectangle(rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top));
        this.sendEvent(42, event);
        event.gc = null;
        gC.dispose();
        OS.RestoreDC(nMTTCUSTOMDRAW.hdc, n3);
        return event;
    }

    @Override
    void setBackgroundImage(int n2) {
        super.setBackgroundImage(n2);
        if (n2 != 0) {
            this.setBackgroundTransparent(true);
        } else if (!(this.hooks(41) || this.hooks(40) || this.hooks(42))) {
            this.setBackgroundTransparent(false);
        }
    }

    @Override
    void setBackgroundPixel(int n2) {
        int n3 = OS.SendMessage(this.handle, 4096, 0, 0);
        if (n3 != -1) {
            if (this.findImageControl() != null) {
                return;
            }
            if (n2 == -1) {
                n2 = this.defaultBackground();
            }
            if (n3 != n2) {
                OS.SendMessage(this.handle, 4097, 0, n2);
                OS.SendMessage(this.handle, 4134, 0, n2);
                if ((this.style & 0x20) != 0) {
                    this.fixCheckboxImageListColor(true);
                }
            }
        }
        OS.InvalidateRect(this.handle, null, true);
    }

    void setBackgroundTransparent(boolean bl2) {
        int n2 = OS.SendMessage(this.handle, 4096, 0, 0);
        if (bl2) {
            if (n2 != -1) {
                OS.SendMessage(this.handle, 4097, 0, -1);
                OS.SendMessage(this.handle, 4134, 0, -1);
                OS.InvalidateRect(this.handle, null, true);
                if (!this.explorerTheme && (this.style & 0x10000) != 0) {
                    int n3 = 32;
                    OS.SendMessage(this.handle, 4150, n3, 0);
                }
                if ((this.sortDirection & 0x480) != 0 && this.sortColumn != null && !this.sortColumn.isDisposed()) {
                    OS.SendMessage(this.handle, 4236, -1, 0);
                    OS.InvalidateRect(this.handle, null, true);
                }
            }
        } else if (n2 == -1) {
            int n4;
            Control control = this.findBackgroundControl();
            if (control == null) {
                control = this;
            }
            if (control.backgroundImage == null) {
                n4 = control.getBackgroundPixel();
                OS.SendMessage(this.handle, 4097, 0, n4);
                OS.SendMessage(this.handle, 4134, 0, n4);
                if ((this.style & 0x20) != 0) {
                    this.fixCheckboxImageListColor(true);
                }
                OS.InvalidateRect(this.handle, null, true);
            }
            if (!(this.explorerTheme || (this.style & 0x10000) == 0 || this.hooks(40) || this.hooks(42))) {
                n4 = 32;
                OS.SendMessage(this.handle, 4150, n4, n4);
            }
            if ((this.sortDirection & 0x480) != 0 && this.sortColumn != null && !this.sortColumn.isDisposed() && (n4 = this.indexOf(this.sortColumn)) != -1) {
                OS.SendMessage(this.handle, 4236, n4, 0);
                OS.InvalidateRect(this.handle, null, true);
            }
        }
    }

    @Override
    void setBoundsInPixels(int n2, int n3, int n4, int n5, int n6, boolean bl2) {
        this.setDeferResize(true);
        super.setBoundsInPixels(n2, n3, n4, n5, n6, false);
        this.setDeferResize(false);
    }

    public void setColumnOrder(int[] nArray) {
        int n2;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (this.columnCount == 0) {
            if (nArray.length != 0) {
                this.error(5);
            }
            return;
        }
        if (nArray.length != this.columnCount) {
            this.error(5);
        }
        int[] nArray2 = new int[this.columnCount];
        OS.SendMessage(this.handle, 4155, this.columnCount, nArray2);
        boolean bl2 = false;
        boolean[] blArray = new boolean[this.columnCount];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            n2 = nArray[i2];
            if (n2 < 0 || n2 >= this.columnCount) {
                this.error(6);
            }
            if (blArray[n2]) {
                this.error(5);
            }
            blArray[n2] = true;
            if (n2 == nArray2[i2]) continue;
            bl2 = true;
        }
        if (bl2) {
            RECT[] rECTArray = new RECT[this.columnCount];
            for (n2 = 0; n2 < this.columnCount; ++n2) {
                rECTArray[n2] = new RECT();
                OS.SendMessage(this.hwndHeader, 4615, n2, rECTArray[n2]);
            }
            OS.SendMessage(this.handle, 4154, nArray.length, nArray);
            OS.InvalidateRect(this.handle, null, true);
            TableColumn[] tableColumnArray = new TableColumn[this.columnCount];
            System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columnCount);
            RECT rECT = new RECT();
            for (int i3 = 0; i3 < this.columnCount; ++i3) {
                TableColumn tableColumn = tableColumnArray[i3];
                if (tableColumn.isDisposed()) continue;
                OS.SendMessage(this.hwndHeader, 4615, i3, rECT);
                if (rECT.left == rECTArray[i3].left) continue;
                tableColumn.updateToolTip(i3);
                tableColumn.sendEvent(10);
            }
        }
    }

    void setCustomDraw(boolean bl2) {
        if (this.customDraw == bl2) {
            return;
        }
        if (!this.customDraw && bl2 && this.currentItem != null) {
            OS.InvalidateRect(this.handle, null, true);
        }
        this.customDraw = bl2;
    }

    void setDeferResize(boolean bl2) {
        if (bl2) {
            if (this.resizeCount++ == 0) {
                this.wasResized = false;
                if ((this.hooks(41) || this.hooks(40) || this.hooks(42)) && this.drawCount++ == 0 && OS.IsWindowVisible(this.handle)) {
                    OS.DefWindowProc(this.handle, 11, 0, 0);
                    OS.SendMessage(this.handle, 4097, 0, 0xFFFFFF);
                }
            }
        } else if (--this.resizeCount == 0) {
            if ((this.hooks(41) || this.hooks(40) || this.hooks(42)) && --this.drawCount == 0) {
                OS.SendMessage(this.handle, 4097, 0, -1);
                OS.DefWindowProc(this.handle, 11, 1, 0);
                if (OS.IsWinCE) {
                    if (this.hwndHeader != 0) {
                        OS.InvalidateRect(this.hwndHeader, null, true);
                    }
                    OS.InvalidateRect(this.handle, null, true);
                } else {
                    int n2 = 1157;
                    OS.RedrawWindow(this.handle, null, 0, n2);
                }
            }
            if (this.wasResized) {
                this.wasResized = false;
                this.setResizeChildren(false);
                this.sendEvent(11);
                if (this.isDisposed()) {
                    return;
                }
                if (this.layout != null) {
                    this.markLayout(false, false);
                    this.updateLayout(false, false);
                }
                this.setResizeChildren(true);
            }
        }
    }

    void setCheckboxImageList(int n2, int n3, boolean bl2) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        if ((this.style & 0x20) == 0) {
            return;
        }
        int n10 = 8;
        int n11 = 0;
        if (OS.IsWinCE) {
            n11 |= 0;
        } else {
            n9 = OS.GetDC(this.handle);
            n8 = OS.GetDeviceCaps(n9, 12);
            n7 = OS.GetDeviceCaps(n9, 14);
            OS.ReleaseDC(this.handle, n9);
            n6 = n8 * n7;
            switch (n6) {
                case 4: {
                    n11 |= 4;
                    break;
                }
                case 8: {
                    n11 |= 8;
                    break;
                }
                case 16: {
                    n11 |= 0x10;
                    break;
                }
                case 24: {
                    n11 |= 0x18;
                    break;
                }
                case 32: {
                    n11 |= 0x20;
                    break;
                }
                default: {
                    n11 |= 0;
                }
            }
        }
        if ((this.style & 0x4000000) != 0) {
            n11 |= 0x2000;
        }
        if (OS.COMCTL32_MAJOR < 6 || !OS.IsAppThemed()) {
            n11 |= 1;
        }
        n9 = OS.ImageList_Create(n2, n3, n11, n10, n10);
        n8 = OS.GetDC(this.handle);
        n7 = OS.CreateCompatibleDC(n8);
        n6 = OS.CreateCompatibleBitmap(n8, n2 * n10, n3);
        int n12 = OS.SelectObject(n7, n6);
        RECT rECT = new RECT();
        OS.SetRect(rECT, 0, 0, n2 * n10, n3);
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            Control control = this.findBackgroundControl();
            if (control == null) {
                control = this;
            }
            n5 = control.getBackgroundPixel();
        } else {
            n5 = 0x20000FF;
            if ((n5 & 0xFFFFFF) == OS.GetSysColor(OS.COLOR_WINDOW)) {
                n5 = 0x200FF00;
            }
        }
        int n13 = OS.CreateSolidBrush(n5);
        OS.FillRect(n7, rECT, n13);
        OS.DeleteObject(n13);
        int n14 = OS.SelectObject(n8, this.defaultFont());
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(n8, tEXTMETRIC);
        OS.SelectObject(n8, n14);
        int n15 = Math.min(tEXTMETRIC.tmHeight, n2);
        int n16 = Math.min(tEXTMETRIC.tmHeight, n3);
        int n17 = (n2 - n15) / 2;
        int n18 = (n3 - n16) / 2;
        OS.SetRect(rECT, n17, n18, n17 + n15, n18 + n16);
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            n4 = this.display.hButtonTheme();
            OS.DrawThemeBackground(n4, n7, 3, 1, rECT, null);
            rECT.left += n2;
            rECT.right += n2;
            OS.DrawThemeBackground(n4, n7, 3, 5, rECT, null);
            rECT.left += n2;
            rECT.right += n2;
            OS.DrawThemeBackground(n4, n7, 3, 1, rECT, null);
            rECT.left += n2;
            rECT.right += n2;
            OS.DrawThemeBackground(n4, n7, 3, 9, rECT, null);
            rECT.left += n2;
            rECT.right += n2;
            OS.DrawThemeBackground(n4, n7, 3, 4, rECT, null);
            rECT.left += n2;
            rECT.right += n2;
            OS.DrawThemeBackground(n4, n7, 3, 8, rECT, null);
            rECT.left += n2;
            rECT.right += n2;
            OS.DrawThemeBackground(n4, n7, 3, 4, rECT, null);
            rECT.left += n2;
            rECT.right += n2;
            OS.DrawThemeBackground(n4, n7, 3, 12, rECT, null);
        } else {
            OS.DrawFrameControl(n7, rECT, 4, 16384);
            rECT.left += n2;
            rECT.right += n2;
            OS.DrawFrameControl(n7, rECT, 4, 17408);
            rECT.left += n2;
            rECT.right += n2;
            OS.DrawFrameControl(n7, rECT, 4, 16640);
            rECT.left += n2;
            rECT.right += n2;
            OS.DrawFrameControl(n7, rECT, 4, 17664);
            rECT.left += n2;
            rECT.right += n2;
            OS.DrawFrameControl(n7, rECT, 4, 16384);
            rECT.left += n2;
            rECT.right += n2;
            OS.DrawFrameControl(n7, rECT, 4, 17408);
            rECT.left += n2;
            rECT.right += n2;
            OS.DrawFrameControl(n7, rECT, 4, 16640);
            rECT.left += n2;
            rECT.right += n2;
            OS.DrawFrameControl(n7, rECT, 4, 17664);
        }
        OS.SelectObject(n7, n12);
        OS.DeleteDC(n7);
        OS.ReleaseDC(this.handle, n8);
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            OS.ImageList_Add(n9, n6, 0);
        } else {
            OS.ImageList_AddMasked(n9, n6, n5);
        }
        OS.DeleteObject(n6);
        n4 = this.getTopIndex();
        if (bl2 && n4 != 0) {
            this.setRedraw(false);
            this.setTopIndex(0);
        }
        int n19 = OS.SendMessage(this.handle, 4098, 2, 0);
        OS.SendMessage(this.handle, 4099, 2, n9);
        if (n19 != 0) {
            OS.ImageList_Destroy(n19);
        }
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
            int n20 = OS.SendMessage(this.handle, 4098, 1, 0);
            OS.SendMessage(this.handle, 4099, 1, n20);
        }
        if (bl2 && n4 != 0) {
            this.setTopIndex(n4);
            this.setRedraw(true);
        }
    }

    void setFocusIndex(int n2) {
        if (n2 < 0) {
            return;
        }
        LVITEM lVITEM = new LVITEM();
        lVITEM.state = 1;
        lVITEM.stateMask = 1;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, n2, lVITEM);
        this.ignoreSelect = false;
        OS.SendMessage(this.handle, 4163, 0, n2);
    }

    @Override
    public void setFont(Font font) {
        int n2;
        this.checkWidget();
        int n3 = this.getTopIndex();
        if (n3 != 0) {
            this.setRedraw(false);
            this.setTopIndex(0);
        }
        if (this.itemHeight != -1) {
            n2 = OS.GetWindowLong(this.handle, -16);
            OS.SetWindowLong(this.handle, -16, n2 | 0x400);
        }
        super.setFont(font);
        if (this.itemHeight != -1) {
            n2 = OS.GetWindowLong(this.handle, -16);
            OS.SetWindowLong(this.handle, -16, n2 & 0xFFFFFBFF);
        }
        this.setScrollWidth(null, true);
        if (n3 != 0) {
            this.setTopIndex(n3);
            this.setRedraw(true);
        }
        OS.InvalidateRect(this.hwndHeader, null, true);
    }

    @Override
    void setForegroundPixel(int n2) {
        if (n2 == -1) {
            n2 = -16777216;
        }
        OS.SendMessage(this.handle, 4132, 0, n2);
        OS.InvalidateRect(this.handle, null, true);
        OS.InvalidateRect(this.hwndHeader, null, true);
    }

    public void setHeaderBackground(Color color) {
        this.checkWidget();
        int n2 = -1;
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            n2 = color.handle;
        }
        if (n2 == this.headerBackground) {
            return;
        }
        this.headerBackground = n2;
        if (this.getHeaderVisible()) {
            OS.InvalidateRect(this.hwndHeader, null, true);
        }
    }

    public void setHeaderForeground(Color color) {
        this.checkWidget();
        int n2 = -1;
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            n2 = color.handle;
        }
        if (n2 == this.headerForeground) {
            return;
        }
        this.headerForeground = n2;
        if (this.getHeaderVisible()) {
            OS.InvalidateRect(this.hwndHeader, null, true);
        }
    }

    public void setHeaderVisible(boolean bl2) {
        this.checkWidget();
        int n2 = OS.GetWindowLong(this.handle, -16);
        n2 &= 0xFFFFBFFF;
        if (!bl2) {
            n2 |= 0x4000;
        }
        int n3 = this.getTopIndex();
        OS.SetWindowLong(this.handle, -16, n2);
        int n4 = this.getTopIndex();
        if (n4 != 0) {
            this.setRedraw(false);
            this.setTopIndex(0);
        }
        if (bl2 && this._getLinesVisible()) {
            this.fixItemHeight(false);
        }
        this.setTopIndex(n3);
        if (n4 != 0) {
            this.setRedraw(true);
        }
        this.updateHeaderToolTips();
    }

    public void setItemCount(int n2) {
        int n3;
        boolean bl2;
        this.checkWidget();
        n2 = Math.max(0, n2);
        int n4 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (n2 == n4) {
            return;
        }
        this.setDeferResize(true);
        boolean bl3 = bl2 = (this.style & 0x10000000) != 0;
        if (!bl2) {
            this.setRedraw(false);
        }
        for (n3 = n2; n3 < n4; ++n3) {
            TableItem tableItem = this._getItem(n3, false);
            if (tableItem != null && !tableItem.isDisposed()) {
                tableItem.release(false);
            }
            if (bl2) continue;
            this.ignoreShrink = true;
            this.ignoreSelect = true;
            int n5 = OS.SendMessage(this.handle, 4104, n2, 0);
            this.ignoreShrink = false;
            this.ignoreSelect = false;
            if (n5 == 0) break;
        }
        if (n3 < n4) {
            this.error(15);
        }
        this._setItemCount(n2, n4);
        if (bl2) {
            int n6 = 3;
            OS.SendMessage(this.handle, 4143, n2, n6);
            if (n2 == 0 && n4 != 0) {
                OS.InvalidateRect(this.handle, null, true);
            }
        } else {
            for (int i2 = n4; i2 < n2; ++i2) {
                new TableItem(this, 0, i2, true);
            }
        }
        if (!bl2) {
            this.setRedraw(true);
        }
        if (n4 == 0) {
            this.setScrollWidth(null, false);
        }
        this.setDeferResize(false);
    }

    void setItemHeight(boolean bl2) {
        int n2 = this.getTopIndex();
        if (bl2 && n2 != 0) {
            this.setRedraw(false);
            this.setTopIndex(0);
        }
        if (this.itemHeight == -1) {
            int n3 = OS.SendMessage(this.handle, 49, 0, 0);
            OS.SendMessage(this.handle, 48, n3, 0);
        } else {
            this.forceResize();
            RECT rECT = new RECT();
            OS.GetWindowRect(this.handle, rECT);
            int n4 = rECT.right - rECT.left;
            int n5 = rECT.bottom - rECT.top;
            int n6 = OS.GetWindowLong(this.handle, -16);
            OS.SetWindowLong(this.handle, -16, n6 | 0x400);
            int n7 = 30;
            this.ignoreResize = true;
            this.SetWindowPos(this.handle, 0, 0, 0, n4, n5 + 1, n7);
            this.SetWindowPos(this.handle, 0, 0, 0, n4, n5, n7);
            this.ignoreResize = false;
            OS.SetWindowLong(this.handle, -16, n6);
        }
        if (bl2 && n2 != 0) {
            this.setTopIndex(n2);
            this.setRedraw(true);
        }
    }

    void setItemHeight(int n2) {
        this.checkWidget();
        if (n2 < -1) {
            this.error(5);
        }
        this.itemHeight = n2;
        this.setItemHeight(true);
        this.setScrollWidth(null, true);
    }

    public void setLinesVisible(boolean bl2) {
        int n2;
        this.checkWidget();
        int n3 = bl2 ? 1 : 0;
        OS.SendMessage(this.handle, 4150, 1, n3);
        if (bl2 && ((n2 = OS.GetWindowLong(this.handle, -16)) & 0x4000) == 0) {
            this.fixItemHeight(true);
        }
        OS.InvalidateRect(this.hwndHeader, null, true);
    }

    @Override
    public void setRedraw(boolean bl2) {
        int n2;
        this.checkWidget();
        if (this.drawCount == 0 && ((n2 = OS.GetWindowLong(this.handle, -16)) & 0x10000000) == 0) {
            this.state |= 0x10;
        }
        if (bl2) {
            if (--this.drawCount == 0) {
                this.setScrollWidth(null, true);
                this.setDeferResize(true);
                OS.SendMessage(this.handle, 11, 1, 0);
                if (this.hwndHeader != 0) {
                    OS.SendMessage(this.hwndHeader, 11, 1, 0);
                }
                if ((this.state & 0x10) != 0) {
                    this.state &= 0xFFFFFFEF;
                    OS.ShowWindow(this.handle, 0);
                } else if (OS.IsWinCE) {
                    OS.InvalidateRect(this.handle, null, false);
                    if (this.hwndHeader != 0) {
                        OS.InvalidateRect(this.hwndHeader, null, false);
                    }
                } else {
                    n2 = 1157;
                    OS.RedrawWindow(this.handle, null, 0, n2);
                }
                this.setDeferResize(false);
            }
        } else if (this.drawCount++ == 0) {
            OS.SendMessage(this.handle, 11, 0, 0);
            if (this.hwndHeader != 0) {
                OS.SendMessage(this.hwndHeader, 11, 0, 0);
            }
        }
    }

    void setScrollWidth(int n2) {
        if (n2 != OS.SendMessage(this.handle, 4125, 0, 0)) {
            boolean bl2 = false;
            if (this.hooks(41)) {
                boolean bl3 = bl2 = this.getDrawing() && OS.IsWindowVisible(this.handle);
            }
            if (bl2) {
                OS.DefWindowProc(this.handle, 11, 0, 0);
            }
            OS.SendMessage(this.handle, 4126, 0, n2);
            if (bl2) {
                OS.DefWindowProc(this.handle, 11, 1, 0);
                if (OS.IsWinCE) {
                    int n3 = OS.SendMessage(this.handle, 4127, 0, 0);
                    if (n3 != 0) {
                        OS.InvalidateRect(n3, null, true);
                    }
                    OS.InvalidateRect(this.handle, null, true);
                } else {
                    int n4 = 1157;
                    OS.RedrawWindow(this.handle, null, 0, n4);
                }
            }
        }
    }

    boolean setScrollWidth(TableItem tableItem, boolean bl2) {
        if (this.currentItem != null) {
            if (this.currentItem != tableItem) {
                this.fixScrollWidth = true;
            }
            return false;
        }
        if (!(bl2 || this.getDrawing() && OS.IsWindowVisible(this.handle))) {
            this.fixScrollWidth = true;
            return false;
        }
        this.fixScrollWidth = false;
        if (this.columnCount == 0) {
            int n2;
            int n3;
            Object object;
            Object object2;
            int n4 = 0;
            int n5 = 0;
            int n6 = OS.SendMessage(this.handle, 4100, 0, 0);
            for (int i2 = 0; i2 < n6; ++i2) {
                object2 = null;
                int n7 = -1;
                if (tableItem != null) {
                    object2 = tableItem.text;
                    n5 = Math.max(n5, tableItem.imageIndent);
                    n7 = tableItem.fontHandle(0);
                } else {
                    object = this._getItem(i2, false);
                    if (object != null) {
                        object2 = ((TableItem)object).text;
                        n5 = Math.max(n5, ((TableItem)object).imageIndent);
                        n7 = ((TableItem)object).fontHandle(0);
                    }
                }
                if (object2 != null && ((String)object2).length() != 0) {
                    if (n7 != -1) {
                        int n8 = OS.GetDC(this.handle);
                        int n9 = OS.SelectObject(n8, n7);
                        int n10 = 3104;
                        TCHAR tCHAR = new TCHAR(this.getCodePage(), (String)object2, false);
                        RECT rECT = new RECT();
                        OS.DrawText(n8, tCHAR, tCHAR.length(), rECT, n10);
                        OS.SelectObject(n8, n9);
                        OS.ReleaseDC(this.handle, n8);
                        n4 = Math.max(n4, rECT.right - rECT.left);
                    } else {
                        object = new TCHAR(this.getCodePage(), (String)object2, true);
                        n4 = Math.max(n4, OS.SendMessage(this.handle, OS.LVM_GETSTRINGWIDTH, 0, (TCHAR)object));
                    }
                }
                if (tableItem != null) break;
            }
            if (n4 == 0) {
                object2 = new TCHAR(this.getCodePage(), " ", true);
                n4 = Math.max(n4, OS.SendMessage(this.handle, OS.LVM_GETSTRINGWIDTH, 0, (TCHAR)object2));
            }
            if ((n3 = OS.SendMessage(this.handle, 4098, 2, 0)) != 0) {
                int[] nArray = new int[1];
                object = new int[1];
                OS.ImageList_GetIconSize(n3, nArray, (int[])object);
                n4 += nArray[0] + 4;
            }
            if ((n2 = OS.SendMessage(this.handle, 4098, 1, 0)) != 0) {
                object = new int[1];
                int[] nArray = new int[1];
                OS.ImageList_GetIconSize(n2, (int[])object, nArray);
                n4 += (n5 + 1) * object[0];
            } else {
                ++n4;
            }
            n4 += 8;
            int n11 = OS.SendMessage(this.handle, 4125, 0, 0);
            if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                n4 += 2;
            }
            if (n4 > n11) {
                this.setScrollWidth(n4);
                return true;
            }
        }
        return false;
    }

    public void setSelection(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n2 = nArray.length;
        if (n2 == 0 || (this.style & 4) != 0 && n2 > 1) {
            return;
        }
        this.select(nArray);
        int n3 = nArray[0];
        if (n3 != -1) {
            this.setFocusIndex(n3);
        }
        this.showSelection();
    }

    public void setSelection(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        this.setSelection(new TableItem[]{tableItem});
    }

    public void setSelection(TableItem[] tableItemArray) {
        this.checkWidget();
        if (tableItemArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n2 = tableItemArray.length;
        if (n2 == 0 || (this.style & 4) != 0 && n2 > 1) {
            return;
        }
        int n3 = -1;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            int n4 = this.indexOf(tableItemArray[i2]);
            if (n4 == -1) continue;
            n3 = n4;
            this.select(n3);
        }
        if (n3 != -1) {
            this.setFocusIndex(n3);
        }
        this.showSelection();
    }

    public void setSelection(int n2) {
        this.checkWidget();
        this.deselectAll();
        this.select(n2);
        if (n2 != -1) {
            this.setFocusIndex(n2);
        }
        this.showSelection();
    }

    public void setSelection(int n2, int n3) {
        this.checkWidget();
        this.deselectAll();
        if (n3 < 0 || n2 > n3 || (this.style & 4) != 0 && n2 != n3) {
            return;
        }
        int n4 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (n4 == 0 || n2 >= n4) {
            return;
        }
        n2 = Math.max(0, n2);
        n3 = Math.min(n3, n4 - 1);
        this.select(n2, n3);
        this.setFocusIndex(n2);
        this.showSelection();
    }

    public void setSortColumn(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn != null && tableColumn.isDisposed()) {
            this.error(5);
        }
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            this.sortColumn.setSortDirection(0);
        }
        this.sortColumn = tableColumn;
        if (this.sortColumn != null && this.sortDirection != 0) {
            this.sortColumn.setSortDirection(this.sortDirection);
        }
    }

    public void setSortDirection(int n2) {
        this.checkWidget();
        if ((n2 & 0x480) == 0 && n2 != 0) {
            return;
        }
        this.sortDirection = n2;
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            this.sortColumn.setSortDirection(n2);
        }
    }

    void setSubImagesVisible(boolean bl2) {
        int n2 = OS.SendMessage(this.handle, 4151, 0, 0);
        if ((n2 & 2) != 0 == bl2) {
            return;
        }
        int n3 = bl2 ? 2 : 0;
        OS.SendMessage(this.handle, 4150, 2, n3);
    }

    void setTableEmpty() {
        if (this.imageList != null) {
            int n2 = OS.ImageList_Create(1, 1, 0, 0, 0);
            OS.SendMessage(this.handle, 4099, 1, n2);
            OS.SendMessage(this.handle, 4099, 1, 0);
            if (this.headerImageList != null) {
                int n3 = this.headerImageList.getHandle();
                int n4 = OS.SendMessage(this.handle, 4127, 0, 0);
                OS.SendMessage(n4, 4616, 0, n3);
            }
            OS.ImageList_Destroy(n2);
            this.display.releaseImageList(this.imageList);
            this.imageList = null;
            if (this.itemHeight != -1) {
                this.setItemHeight(false);
            }
        }
        if (!(this.hooks(41) || this.hooks(40) || this.hooks(42))) {
            Control control = this.findBackgroundControl();
            if (control == null) {
                control = this;
            }
            if (control.backgroundImage == null) {
                this.setCustomDraw(false);
                this.setBackgroundTransparent(false);
                if (OS.COMCTL32_MAJOR < 6) {
                    this.style &= 0xDFFFFFFF;
                }
            }
        }
        this._initItems();
        if (this.columnCount == 0) {
            OS.SendMessage(this.handle, 4126, 0, 0);
            this.setScrollWidth(null, false);
        }
    }

    public void setTopIndex(int n2) {
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 4135, 0, 0);
        if (n2 == n3) {
            return;
        }
        if (!this.painted && this.hooks(41)) {
            this.hitTestSelection(n2, 0, 0);
        }
        if (OS.SendMessage(this.handle, 4136, 0, 0) <= 0) {
            OS.SendMessage(this.handle, 4115, n2, 1);
            if (n2 != OS.SendMessage(this.handle, 4135, 0, 0)) {
                OS.SendMessage(this.handle, 4115, n2, 1);
            }
            return;
        }
        RECT rECT = new RECT();
        rECT.left = 0;
        this.ignoreCustomDraw = true;
        OS.SendMessage(this.handle, 4110, 0, rECT);
        this.ignoreCustomDraw = false;
        int n4 = (n2 - n3) * (rECT.bottom - rECT.top);
        OS.SendMessage(this.handle, 4116, 0, n4);
    }

    public void showColumn(TableColumn tableColumn) {
        int n2;
        int n3;
        Object object;
        int n4;
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        if (tableColumn.isDisposed()) {
            this.error(5);
        }
        if (tableColumn.parent != this) {
            return;
        }
        int n5 = this.indexOf(tableColumn);
        if (0 > n5 || n5 >= this.columnCount) {
            return;
        }
        RECT rECT = new RECT();
        rECT.left = 0;
        if (n5 == 0) {
            rECT.top = 1;
            this.ignoreCustomDraw = true;
            OS.SendMessage(this.handle, 4152, -1, rECT);
            this.ignoreCustomDraw = false;
            rECT.right = rECT.left;
            n4 = OS.SendMessage(this.handle, 4125, 0, 0);
            rECT.left = rECT.right - n4;
        } else {
            rECT.top = n5;
            this.ignoreCustomDraw = true;
            OS.SendMessage(this.handle, 4152, -1, rECT);
            this.ignoreCustomDraw = false;
        }
        n4 = 0;
        if (this._getLinesVisible()) {
            object = new SCROLLINFO();
            ((SCROLLINFO)object).cbSize = SCROLLINFO.sizeof;
            ((SCROLLINFO)object).fMask = 4;
            OS.GetScrollInfo(this.handle, 0, (SCROLLINFO)object);
            n4 = ((SCROLLINFO)object).nPos;
        }
        object = new RECT();
        OS.GetClientRect(this.handle, (RECT)object);
        if (rECT.left < ((RECT)object).left) {
            n3 = rECT.left - ((RECT)object).left;
            OS.SendMessage(this.handle, 4116, n3, 0);
        } else {
            n3 = Math.min(((RECT)object).right - ((RECT)object).left, rECT.right - rECT.left);
            if (rECT.left + n3 > ((RECT)object).right) {
                n2 = rECT.left + n3 - ((RECT)object).right;
                OS.SendMessage(this.handle, 4116, n2, 0);
            }
        }
        if (this._getLinesVisible()) {
            SCROLLINFO sCROLLINFO = new SCROLLINFO();
            sCROLLINFO.cbSize = SCROLLINFO.sizeof;
            sCROLLINFO.fMask = 4;
            OS.GetScrollInfo(this.handle, 0, sCROLLINFO);
            n2 = sCROLLINFO.nPos;
            if (n2 < n4) {
                ((RECT)object).right = n4 - n2 + 1;
                OS.InvalidateRect(this.handle, (RECT)object, true);
            }
        }
    }

    void showItem(int n2) {
        int n3;
        if (!this.painted && this.hooks(41)) {
            this.hitTestSelection(n2, 0, 0);
        }
        if ((n3 = OS.SendMessage(this.handle, 4136, 0, 0)) <= 0) {
            OS.SendMessage(this.handle, 4115, n2, 1);
            if (n2 != OS.SendMessage(this.handle, 4135, 0, 0)) {
                OS.SendMessage(this.handle, 4115, n2, 1);
            }
        } else if (OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
            int n4 = OS.SendMessage(this.handle, 4135, 0, 0);
            if (n4 > n2 || n2 >= n4 + n3) {
                OS.SendMessage(this.handle, 4115, n2, 0);
            }
        } else {
            OS.SendMessage(this.handle, 4115, n2, 0);
        }
    }

    public void showItem(TableItem tableItem) {
        int n2;
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        if (tableItem.isDisposed()) {
            this.error(5);
        }
        if ((n2 = this.indexOf(tableItem)) != -1) {
            this.showItem(n2);
        }
    }

    public void showSelection() {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 4108, -1, 2);
        if (n2 != -1) {
            if (!(this.display.getActiveShell() != this.getShell() || (this.style & 0x10) != 0 || this.verticalBar != null && this.verticalBar.isVisible())) {
                this.showItem(0);
            } else {
                this.showItem(n2);
            }
        }
    }

    void sort() {
        this.checkWidget();
    }

    @Override
    void subclass() {
        super.subclass();
        if (HeaderProc != 0) {
            OS.SetWindowLongPtr(this.hwndHeader, -4, this.display.windowProc);
        }
    }

    RECT toolTipInset(RECT rECT) {
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
            RECT rECT2 = new RECT();
            OS.SetRect(rECT2, rECT.left - 1, rECT.top - 1, rECT.right + 1, rECT.bottom + 1);
            return rECT2;
        }
        return rECT;
    }

    RECT toolTipRect(RECT rECT) {
        RECT rECT2 = new RECT();
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
            OS.SetRect(rECT2, rECT.left - 1, rECT.top - 1, rECT.right + 1, rECT.bottom + 1);
        } else {
            int n2 = OS.SendMessage(this.handle, 4174, 0, 0);
            OS.SetRect(rECT2, rECT.left, rECT.top, rECT.right, rECT.bottom);
            int n3 = OS.GetWindowLong(n2, -16);
            int n4 = OS.GetWindowLong(n2, -20);
            OS.AdjustWindowRectEx(rECT2, n3, false, n4);
        }
        return rECT2;
    }

    @Override
    String toolTipText(NMTTDISPINFO nMTTDISPINFO) {
        int n2 = OS.SendMessage(this.handle, 4174, 0, 0);
        if (n2 == nMTTDISPINFO.hwndFrom && this.toolTipText != null) {
            return "";
        }
        if (this.headerToolTipHandle == nMTTDISPINFO.hwndFrom) {
            for (int i2 = 0; i2 < this.columnCount; ++i2) {
                TableColumn tableColumn = this.columns[i2];
                if (tableColumn.id != nMTTDISPINFO.idFrom) continue;
                return tableColumn.toolTipText;
            }
        }
        return super.toolTipText(nMTTDISPINFO);
    }

    @Override
    void unsubclass() {
        super.unsubclass();
        if (HeaderProc != 0) {
            OS.SetWindowLongPtr(this.hwndHeader, -4, HeaderProc);
        }
    }

    @Override
    void update(boolean bl2) {
        int n2 = 0;
        int n3 = 0;
        boolean bl3 = this.isOptimizedRedraw();
        if (bl3) {
            n3 = OS.SetWindowLongPtr(this.handle, -4, TableProc);
            n2 = OS.SetWindowLongPtr(this.hwndHeader, -4, HeaderProc);
        }
        super.update(bl2);
        if (bl3) {
            OS.SetWindowLongPtr(this.handle, -4, n3);
            OS.SetWindowLongPtr(this.hwndHeader, -4, n2);
        }
    }

    void updateHeaderToolTips() {
        if (this.headerToolTipHandle == 0) {
            return;
        }
        int n2 = OS.SendMessage(this.handle, 4127, 0, 0);
        RECT rECT = new RECT();
        TOOLINFO tOOLINFO = new TOOLINFO();
        tOOLINFO.cbSize = TOOLINFO.sizeof;
        tOOLINFO.uFlags = 16;
        tOOLINFO.hwnd = n2;
        tOOLINFO.lpszText = -1;
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            TableColumn tableColumn = this.columns[i2];
            if (OS.SendMessage(n2, 4615, i2, rECT) == 0) continue;
            ++this.display.nextToolTipId;
            tOOLINFO.uId = tableColumn.id = tableColumn.id;
            tOOLINFO.left = rECT.left;
            tOOLINFO.top = rECT.top;
            tOOLINFO.right = rECT.right;
            tOOLINFO.bottom = rECT.bottom;
            OS.SendMessage(this.headerToolTipHandle, OS.TTM_ADDTOOL, 0, tOOLINFO);
        }
    }

    @Override
    void updateImages() {
        if (this.sortColumn != null && !this.sortColumn.isDisposed() && OS.COMCTL32_MAJOR < 6) {
            switch (this.sortDirection) {
                case 128: 
                case 1024: {
                    this.sortColumn.setImage(this.display.getSortImage(this.sortDirection), true, true);
                }
            }
        }
    }

    @Override
    void updateMenuLocation(Event event) {
        Object object;
        Rectangle rectangle = this.getClientAreaInPixels();
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = this.getFocusIndex();
        if (n4 != -1) {
            object = this.getItem(n4);
            Rectangle rectangle2 = ((TableItem)object).getBoundsInPixels(0);
            if (((TableItem)object).text != null && ((TableItem)object).text.length() != 0) {
                rectangle2 = ((TableItem)object).getBoundsInPixels();
            }
            n2 = Math.max(n2, rectangle2.x + rectangle2.width / 2);
            n2 = Math.min(n2, rectangle.x + rectangle.width);
            n3 = Math.max(n3, rectangle2.y + rectangle2.height);
            n3 = Math.min(n3, rectangle.y + rectangle.height);
        }
        object = this.toDisplayInPixels(n2, n3);
        event.setLocationInPixels(((Point)object).x, ((Point)object).y);
    }

    void updateMoveable() {
        int n2;
        for (n2 = 0; n2 < this.columnCount && !this.columns[n2].moveable; ++n2) {
        }
        int n3 = n2 < this.columnCount ? 16 : 0;
        OS.SendMessage(this.handle, 4150, 16, n3);
    }

    @Override
    void updateOrientation() {
        int n2;
        Object object;
        int n3;
        super.updateOrientation();
        int n4 = OS.SendMessage(this.handle, 4127, 0, 0);
        if (n4 != 0) {
            int n5 = OS.GetWindowLong(n4, -20);
            n5 = (this.style & 0x4000000) != 0 ? (n5 |= 0x400000) : (n5 &= 0xFFBFFFFF);
            OS.SetWindowLong(n4, -20, n5 &= 0xFFFFDFFF);
            OS.InvalidateRect(n4, null, true);
            RECT rECT = new RECT();
            OS.GetWindowRect(this.handle, rECT);
            n3 = rECT.right - rECT.left;
            int n6 = rECT.bottom - rECT.top;
            OS.SetWindowPos(this.handle, 0, 0, 0, n3 - 1, n6 - 1, 6);
            OS.SetWindowPos(this.handle, 0, 0, 0, n3, n6, 6);
        }
        if ((this.style & 0x20) != 0) {
            this.fixCheckboxImageListColor(false);
        }
        if (this.imageList != null) {
            Point point = this.imageList.getImageSize();
            this.display.releaseImageList(this.imageList);
            this.imageList = this.display.getImageList(this.style & 0x4000000, point.x, point.y);
            int n7 = OS.SendMessage(this.handle, 4100, 0, 0);
            for (n3 = 0; n3 < n7; ++n3) {
                TableItem tableItem = this._getItem(n3, false);
                if (tableItem == null || (object = tableItem.image) == null || (n2 = this.imageList.indexOf((Image)object)) != -1) continue;
                this.imageList.add((Image)object);
            }
            n3 = this.imageList.getHandle();
            OS.SendMessage(this.handle, 4099, 1, n3);
        }
        if (n4 != 0 && this.headerImageList != null) {
            Point point = this.headerImageList.getImageSize();
            this.display.releaseImageList(this.headerImageList);
            this.headerImageList = this.display.getImageList(this.style & 0x4000000, point.x, point.y);
            if (this.columns != null) {
                for (int i2 = 0; i2 < this.columns.length; ++i2) {
                    Image image;
                    TableColumn tableColumn = this.columns[i2];
                    if (tableColumn == null || (image = tableColumn.image) == null) continue;
                    if (OS.COMCTL32_MAJOR < 6) {
                        object = new HDITEM();
                        ((HDITEM)object).mask = 4;
                        OS.SendMessage(n4, OS.HDM_GETITEM, i2, (HDITEM)object);
                        if ((((HDITEM)object).fmt & 0x800) == 0) continue;
                        n2 = this.headerImageList.indexOf(image);
                        if (n2 == -1) {
                            this.headerImageList.add(image);
                        }
                        ((HDITEM)object).mask = 32;
                        ((HDITEM)object).iImage = n2;
                        OS.SendMessage(n4, OS.HDM_SETITEM, i2, (HDITEM)object);
                        continue;
                    }
                    object = new LVCOLUMN();
                    ((LVCOLUMN)object).mask = 1;
                    OS.SendMessage(n4, OS.LVM_GETCOLUMN, i2, (LVCOLUMN)object);
                    if ((((LVCOLUMN)object).fmt & 0x800) == 0) continue;
                    n2 = this.headerImageList.indexOf(image);
                    if (n2 == -1) {
                        this.headerImageList.add(image);
                    }
                    ((LVCOLUMN)object).iImage = n2;
                    ((LVCOLUMN)object).mask = 16;
                    OS.SendMessage(n4, OS.LVM_SETCOLUMN, i2, (LVCOLUMN)object);
                }
            }
            int n8 = this.headerImageList.getHandle();
            OS.SendMessage(n4, 4616, 0, n8);
        }
    }

    @Override
    boolean updateTextDirection(int n2) {
        if (super.updateTextDirection(n2)) {
            if (n2 == 0x6000000 || (this.state & 0x400000) != 0) {
                int n3 = this.items.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (this.items[i2] == null) continue;
                    this.items[i2].updateTextDirection(n2 == 0x6000000 ? 0x6000000 : this.style & Integer.MIN_VALUE);
                }
            }
            OS.InvalidateRect(this.handle, null, true);
            return true;
        }
        return false;
    }

    @Override
    int widgetStyle() {
        int n2 = super.widgetStyle() | 0x40;
        if ((this.style & 0x8000) == 0) {
            n2 |= 8;
        }
        if ((this.style & 4) != 0) {
            n2 |= 4;
        }
        n2 |= 0x4001;
        if ((this.style & 0x10000000) != 0) {
            n2 |= 0x1000;
        }
        return n2;
    }

    @Override
    TCHAR windowClass() {
        return TableClass;
    }

    @Override
    int windowProc() {
        return TableProc;
    }

    @Override
    int windowProc(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            return 0;
        }
        if (n2 != this.handle) {
            switch (n3) {
                case 123: {
                    LRESULT lRESULT = this.wmContextMenu(n2, n4, n5);
                    if (lRESULT == null) break;
                    return lRESULT.value;
                }
                case 533: {
                    int n6;
                    if (OS.COMCTL32_MAJOR >= 6 || n5 == 0 || n5 == (n6 = OS.SendMessage(this.handle, 4127, 0, 0))) break;
                    OS.InvalidateRect(n6, null, true);
                    break;
                }
                case 675: {
                    if (OS.COMCTL32_MAJOR >= 6) {
                        this.updateHeaderToolTips();
                    }
                    this.updateHeaderToolTips();
                    break;
                }
                case 78: {
                    NMHDR nMHDR = new NMHDR();
                    OS.MoveMemory(nMHDR, n5, NMHDR.sizeof);
                    switch (nMHDR.code) {
                        case -530: 
                        case -522: 
                        case -521: 
                        case -520: {
                            return OS.SendMessage(this.handle, n3, n4, n5);
                        }
                    }
                    break;
                }
                case 32: {
                    short s2;
                    if (n4 != n2 || (s2 = (short)OS.LOWORD(n5)) != 1) break;
                    HDHITTESTINFO hDHITTESTINFO = new HDHITTESTINFO();
                    int n7 = OS.GetMessagePos();
                    POINT pOINT = new POINT();
                    OS.POINTSTOPOINT(pOINT, n7);
                    OS.ScreenToClient(n2, pOINT);
                    hDHITTESTINFO.x = pOINT.x;
                    hDHITTESTINFO.y = pOINT.y;
                    int n8 = OS.SendMessage(this.handle, 4127, 0, 0);
                    int n9 = OS.SendMessage(n8, 4614, 0, hDHITTESTINFO);
                    if (0 > n9 || n9 >= this.columnCount || this.columns[n9].resizable || (hDHITTESTINFO.flags & 0xC) == 0) break;
                    OS.SetCursor(OS.LoadCursor(0, 32512));
                    return 1;
                }
            }
            return this.callWindowProc(n2, n3, n4, n5);
        }
        if (n3 == Display.DI_GETDRAGIMAGE && (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0) || (this.style & 0x10000000) != 0 || this.hooks(40) || this.hooks(42))) {
            int n10;
            int n11;
            int n12 = OS.SendMessage(this.handle, 4135, 0, 0);
            int n13 = OS.SendMessage(this.handle, 4108, n12 - 1, 2);
            if (n13 == -1) {
                return 0;
            }
            POINT pOINT = new POINT();
            OS.POINTSTOPOINT(pOINT, OS.GetMessagePos());
            OS.MapWindowPoints(0, this.handle, pOINT, 1);
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            TableItem tableItem = this._getItem(n13);
            RECT rECT2 = tableItem.getBounds(n13, 0, true, true, true);
            if ((this.style & 0x10000) != 0) {
                n11 = 301;
                rECT2.left = Math.max(rECT.left, pOINT.x - n11 / 2);
                if (rECT.right > rECT2.left + n11) {
                    rECT2.right = rECT2.left + n11;
                } else {
                    rECT2.right = rECT.right;
                    rECT2.left = Math.max(rECT.left, rECT2.right - n11);
                }
            }
            n11 = OS.CreateRectRgn(rECT2.left, rECT2.top, rECT2.right, rECT2.bottom);
            while ((n13 = OS.SendMessage(this.handle, 4108, n13, 2)) != -1 && rECT2.bottom - rECT2.top <= 301 && rECT2.bottom <= rECT.bottom) {
                RECT rECT3 = tableItem.getBounds(n13, 0, true, true, true);
                n10 = OS.CreateRectRgn(rECT2.left, rECT3.top, rECT2.right, rECT3.bottom);
                OS.CombineRgn(n11, n11, n10, 2);
                OS.DeleteObject(n10);
                rECT2.bottom = rECT3.bottom;
            }
            OS.GetRgnBox(n11, rECT2);
            int n14 = OS.GetDC(this.handle);
            n10 = OS.CreateCompatibleDC(n14);
            BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
            bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
            bITMAPINFOHEADER.biWidth = rECT2.right - rECT2.left;
            bITMAPINFOHEADER.biHeight = -(rECT2.bottom - rECT2.top);
            bITMAPINFOHEADER.biPlanes = 1;
            bITMAPINFOHEADER.biBitCount = (short)32;
            bITMAPINFOHEADER.biCompression = 0;
            byte[] byArray = new byte[BITMAPINFOHEADER.sizeof];
            OS.MoveMemory(byArray, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
            int[] nArray = new int[1];
            int n15 = OS.CreateDIBSection(0, byArray, 0, nArray, 0, 0);
            if (n15 == 0) {
                this.error(2);
            }
            int n16 = OS.SelectObject(n10, n15);
            int n17 = 253;
            POINT pOINT2 = new POINT();
            OS.SetWindowOrgEx(n10, rECT2.left, rECT2.top, pOINT2);
            OS.FillRect(n10, rECT2, this.findBrush(n17, 0));
            OS.OffsetRgn(n11, -rECT2.left, -rECT2.top);
            OS.SelectClipRgn(n10, n11);
            OS.PrintWindow(this.handle, n10, 0);
            OS.SetWindowOrgEx(n10, pOINT2.x, pOINT2.y, null);
            OS.SelectObject(n10, n16);
            OS.DeleteDC(n10);
            OS.ReleaseDC(0, n14);
            OS.DeleteObject(n11);
            SHDRAGIMAGE sHDRAGIMAGE = new SHDRAGIMAGE();
            sHDRAGIMAGE.hbmpDragImage = n15;
            sHDRAGIMAGE.crColorKey = n17;
            sHDRAGIMAGE.sizeDragImage.cx = bITMAPINFOHEADER.biWidth;
            sHDRAGIMAGE.sizeDragImage.cy = -bITMAPINFOHEADER.biHeight;
            sHDRAGIMAGE.ptOffset.x = pOINT.x - rECT2.left;
            sHDRAGIMAGE.ptOffset.y = pOINT.y - rECT2.top;
            if ((this.style & 0x8000000) != 0) {
                sHDRAGIMAGE.ptOffset.x = sHDRAGIMAGE.sizeDragImage.cx - sHDRAGIMAGE.ptOffset.x;
            }
            OS.MoveMemory(n5, sHDRAGIMAGE, SHDRAGIMAGE.sizeof);
            return 1;
        }
        return super.windowProc(n2, n3, n4, n5);
    }

    @Override
    LRESULT WM_CHAR(int n2, int n3) {
        LRESULT lRESULT = super.WM_CHAR(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch (n2) {
            case 32: {
                int n4;
                if ((this.style & 0x20) != 0 && (n4 = OS.SendMessage(this.handle, 4108, -1, 1)) != -1) {
                    TableItem tableItem;
                    tableItem.setChecked(!(tableItem = this._getItem(n4)).getChecked(), true);
                    if (!OS.IsWinCE) {
                        OS.NotifyWinEvent(32773, this.handle, -4, n4 + 1);
                    }
                }
                n4 = this.callWindowProc(this.handle, 256, n2, n3);
                return new LRESULT(n4);
            }
            case 13: {
                int n5 = OS.SendMessage(this.handle, 4108, -1, 1);
                if (n5 != -1) {
                    Event event = new Event();
                    event.item = this._getItem(n5);
                    this.sendSelectionEvent(14, event, false);
                }
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_CONTEXTMENU(int n2, int n3) {
        if (!this.display.runDragDrop) {
            return LRESULT.ZERO;
        }
        return super.WM_CONTEXTMENU(n2, n3);
    }

    @Override
    LRESULT WM_ERASEBKGND(int n2, int n3) {
        int n4;
        LRESULT lRESULT = super.WM_ERASEBKGND(n2, n3);
        if (this.findImageControl() != null) {
            return LRESULT.ONE;
        }
        if (!OS.IsWinCE && OS.COMCTL32_MAJOR < 6 && (this.style & 0x20000000) != 0 && ((n4 = OS.SendMessage(this.handle, 4151, 0, 0)) & 0x10000) == 0) {
            return LRESULT.ONE;
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_GETOBJECT(int n2, int n3) {
        if ((this.style & 0x20) != 0 && this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return super.WM_GETOBJECT(n2, n3);
    }

    @Override
    LRESULT WM_KEYDOWN(int n2, int n3) {
        LRESULT lRESULT = super.WM_KEYDOWN(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch (n2) {
            case 32: {
                return LRESULT.ZERO;
            }
            case 107: {
                int n4;
                if (OS.GetKeyState(17) >= 0) break;
                for (n4 = 0; n4 < this.columnCount && this.columns[n4].getResizable(); ++n4) {
                }
                if (n4 == this.columnCount && !this.hooks(41)) break;
                TableColumn[] tableColumnArray = new TableColumn[this.columnCount];
                System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columnCount);
                for (int i2 = 0; i2 < tableColumnArray.length; ++i2) {
                    TableColumn tableColumn = tableColumnArray[i2];
                    if (tableColumn.isDisposed() || !tableColumn.getResizable()) continue;
                    tableColumn.pack();
                }
                return LRESULT.ZERO;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                int n5;
                int n6 = 0;
                int n7 = 0;
                int n8 = OS.SendMessage(this.handle, 4127, 0, 0);
                boolean bl2 = this.isOptimizedRedraw();
                if (bl2) {
                    n7 = OS.SetWindowLongPtr(this.handle, -4, TableProc);
                    n6 = OS.SetWindowLongPtr(n8, -4, HeaderProc);
                }
                LRESULT lRESULT2 = lRESULT = (n5 = this.callWindowProc(this.handle, 256, n2, n3)) == 0 ? LRESULT.ZERO : new LRESULT(n5);
                if (bl2) {
                    OS.SetWindowLongPtr(this.handle, -4, n7);
                    OS.SetWindowLongPtr(n8, -4, n6);
                }
            }
            case 38: 
            case 40: {
                OS.SendMessage(this.handle, 295, 3, 0);
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_KILLFOCUS(int n2, int n3) {
        LRESULT lRESULT = super.WM_KILLFOCUS(n2, n3);
        if (this.imageList != null || (this.style & 0x20) != 0) {
            OS.InvalidateRect(this.handle, null, false);
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_LBUTTONDBLCLK(int n2, int n3) {
        TableItem tableItem;
        LVHITTESTINFO lVHITTESTINFO = new LVHITTESTINFO();
        lVHITTESTINFO.x = OS.GET_X_LPARAM(n3);
        lVHITTESTINFO.y = OS.GET_Y_LPARAM(n3);
        int n4 = OS.SendMessage(this.handle, 4114, 0, lVHITTESTINFO);
        Display display = this.display;
        display.captureChanged = false;
        this.sendMouseEvent(3, 1, this.handle, 513, n2, n3);
        if (!this.sendMouseEvent(8, 1, this.handle, 515, n2, n3)) {
            if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            return LRESULT.ZERO;
        }
        if (lVHITTESTINFO.iItem != -1) {
            this.callWindowProc(this.handle, 515, n2, n3);
        }
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        if ((this.style & 0x20) != 0 && n4 != -1 && lVHITTESTINFO.flags == 8 && (tableItem = this._getItem(n4)) != null && !tableItem.isDisposed()) {
            tableItem.setChecked(!tableItem.getChecked(), true);
            if (!OS.IsWinCE) {
                OS.NotifyWinEvent(32773, this.handle, -4, n4 + 1);
            }
        }
        return LRESULT.ZERO;
    }

    @Override
    LRESULT WM_LBUTTONDOWN(int n2, int n3) {
        LRESULT lRESULT = this.sendMouseDownEvent(3, 1, 513, n2, n3);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        if ((this.style & 0x20) != 0) {
            TableItem tableItem;
            LVHITTESTINFO lVHITTESTINFO = new LVHITTESTINFO();
            lVHITTESTINFO.x = OS.GET_X_LPARAM(n3);
            lVHITTESTINFO.y = OS.GET_Y_LPARAM(n3);
            int n4 = OS.SendMessage(this.handle, 4114, 0, lVHITTESTINFO);
            if (n4 != -1 && lVHITTESTINFO.flags == 8 && (tableItem = this._getItem(n4)) != null && !tableItem.isDisposed()) {
                tableItem.setChecked(!tableItem.getChecked(), true);
                if (!OS.IsWinCE) {
                    OS.NotifyWinEvent(32773, this.handle, -4, n4 + 1);
                }
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_MOUSEHOVER(int n2, int n3) {
        int n4;
        LRESULT lRESULT = super.WM_MOUSEHOVER(n2, n3);
        int n5 = OS.SendMessage(this.handle, 4151, 0, 0);
        if ((n5 & (n4 = 200)) != 0) {
            return lRESULT;
        }
        return LRESULT.ZERO;
    }

    @Override
    LRESULT WM_PAINT(int n2, int n3) {
        int n4;
        if ((this.state & 0x1000) != 0) {
            return LRESULT.ZERO;
        }
        this._checkShrink();
        if (this.fixScrollWidth) {
            this.setScrollWidth(null, true);
        }
        if (!(OS.IsWinCE || OS.COMCTL32_MAJOR >= 6 || (this.style & 0x20000000) == 0 && this.findImageControl() == null || ((n4 = OS.SendMessage(this.handle, 4151, 0, 0)) & 0x10000) != 0)) {
            boolean bl2;
            GC gC = null;
            int n5 = 0;
            PAINTSTRUCT pAINTSTRUCT = new PAINTSTRUCT();
            boolean bl3 = bl2 = this.hooks(9) || this.filters(9);
            if (bl2) {
                GCData gCData = new GCData();
                gCData.ps = pAINTSTRUCT;
                gCData.hwnd = this.handle;
                gC = GC.win32_new(this, gCData);
                n5 = gC.handle;
            } else {
                n5 = OS.BeginPaint(this.handle, pAINTSTRUCT);
            }
            int n6 = pAINTSTRUCT.right - pAINTSTRUCT.left;
            int n7 = pAINTSTRUCT.bottom - pAINTSTRUCT.top;
            if (n6 != 0 && n7 != 0) {
                Object object;
                int n8 = OS.CreateCompatibleDC(n5);
                POINT pOINT = new POINT();
                POINT pOINT2 = new POINT();
                OS.SetWindowOrgEx(n8, pAINTSTRUCT.left, pAINTSTRUCT.top, pOINT);
                OS.SetBrushOrgEx(n8, pAINTSTRUCT.left, pAINTSTRUCT.top, pOINT2);
                int n9 = OS.CreateCompatibleBitmap(n5, n6, n7);
                int n10 = OS.SelectObject(n8, n9);
                if (OS.SendMessage(this.handle, 4096, 0, 0) != -1) {
                    object = new RECT();
                    OS.SetRect((RECT)object, pAINTSTRUCT.left, pAINTSTRUCT.top, pAINTSTRUCT.right, pAINTSTRUCT.bottom);
                    this.drawBackground(n8, (RECT)object);
                }
                this.callWindowProc(this.handle, 15, n8, 0);
                OS.SetWindowOrgEx(n8, pOINT.x, pOINT.y, null);
                OS.SetBrushOrgEx(n8, pOINT2.x, pOINT2.y, null);
                OS.BitBlt(n5, pAINTSTRUCT.left, pAINTSTRUCT.top, n6, n7, n8, 0, 0, 0xCC0020);
                OS.SelectObject(n8, n10);
                OS.DeleteObject(n9);
                OS.DeleteObject(n8);
                if (bl2) {
                    object = new Event();
                    ((Event)object).gc = gC;
                    ((Event)object).setBoundsInPixels(new Rectangle(pAINTSTRUCT.left, pAINTSTRUCT.top, pAINTSTRUCT.right - pAINTSTRUCT.left, pAINTSTRUCT.bottom - pAINTSTRUCT.top));
                    this.sendEvent(9, (Event)object);
                    ((Event)object).gc = null;
                }
            }
            if (bl2) {
                gC.dispose();
            } else {
                OS.EndPaint(this.handle, pAINTSTRUCT);
            }
            return LRESULT.ZERO;
        }
        return super.WM_PAINT(n2, n3);
    }

    @Override
    LRESULT WM_RBUTTONDBLCLK(int n2, int n3) {
        LVHITTESTINFO lVHITTESTINFO = new LVHITTESTINFO();
        lVHITTESTINFO.x = OS.GET_X_LPARAM(n3);
        lVHITTESTINFO.y = OS.GET_Y_LPARAM(n3);
        OS.SendMessage(this.handle, 4114, 0, lVHITTESTINFO);
        Display display = this.display;
        display.captureChanged = false;
        this.sendMouseEvent(3, 3, this.handle, 516, n2, n3);
        if (this.sendMouseEvent(8, 3, this.handle, 518, n2, n3) && lVHITTESTINFO.iItem != -1) {
            this.callWindowProc(this.handle, 518, n2, n3);
        }
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        return LRESULT.ZERO;
    }

    @Override
    LRESULT WM_RBUTTONDOWN(int n2, int n3) {
        return this.sendMouseDownEvent(3, 3, 516, n2, n3);
    }

    @Override
    LRESULT WM_SETFOCUS(int n2, int n3) {
        int n4;
        LRESULT lRESULT = super.WM_SETFOCUS(n2, n3);
        if (this.imageList != null || (this.style & 0x20) != 0) {
            OS.InvalidateRect(this.handle, null, false);
        }
        if ((n4 = OS.SendMessage(this.handle, 4100, 0, 0)) == 0) {
            return lRESULT;
        }
        int n5 = OS.SendMessage(this.handle, 4108, -1, 1);
        if (n5 == -1) {
            LVITEM lVITEM = new LVITEM();
            lVITEM.state = 1;
            lVITEM.stateMask = 1;
            this.ignoreSelect = true;
            OS.SendMessage(this.handle, 4139, 0, lVITEM);
            this.ignoreSelect = false;
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_SETFONT(int n2, int n3) {
        LRESULT lRESULT = super.WM_SETFONT(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        OS.SendMessage(this.hwndHeader, 48, 0, n3);
        if (this.headerToolTipHandle != 0) {
            OS.SendMessage(this.headerToolTipHandle, 48, n2, n3);
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_SETREDRAW(int n2, int n3) {
        LRESULT lRESULT = super.WM_SETREDRAW(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (n2 == 1 && OS.SendMessage(this.handle, 4096, 0, 0) != -1 && (this.hooks(41) || this.hooks(40) || this.hooks(42))) {
            OS.SendMessage(this.handle, 4097, 0, -1);
        }
        OS.DefWindowProc(this.handle, 11, n2, n3);
        int n4 = this.callWindowProc(this.handle, 11, n2, n3);
        if (n2 == 0 && OS.SendMessage(this.handle, 4096, 0, 0) == -1) {
            OS.SendMessage(this.handle, 4097, 0, 0xFFFFFF);
        }
        return n4 == 0 ? LRESULT.ZERO : new LRESULT(n4);
    }

    @Override
    LRESULT WM_SIZE(int n2, int n3) {
        if (this.ignoreResize) {
            return null;
        }
        if (this.hooks(40) || this.hooks(42)) {
            OS.InvalidateRect(this.handle, null, true);
        }
        if (this.resizeCount != 0) {
            this.wasResized = true;
            return null;
        }
        return super.WM_SIZE(n2, n3);
    }

    @Override
    LRESULT WM_SYSCOLORCHANGE(int n2, int n3) {
        LRESULT lRESULT = super.WM_SYSCOLORCHANGE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.findBackgroundControl() == null) {
            this.setBackgroundPixel(this.defaultBackground());
        } else {
            int n4 = OS.SendMessage(this.handle, 4096, 0, 0);
            if (n4 != -1 && this.findImageControl() == null && (this.style & 0x20) != 0) {
                this.fixCheckboxImageListColor(true);
            }
        }
        return lRESULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    LRESULT WM_HSCROLL(int n2, int n3) {
        RECT rECT;
        int n4;
        int n5 = 0;
        if (this._getLinesVisible()) {
            SCROLLINFO sCROLLINFO = new SCROLLINFO();
            sCROLLINFO.cbSize = SCROLLINFO.sizeof;
            sCROLLINFO.fMask = 4;
            OS.GetScrollInfo(this.handle, 0, sCROLLINFO);
            n5 = sCROLLINFO.nPos;
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = OS.SendMessage(this.handle, 4127, 0, 0);
        boolean bl2 = this.isOptimizedRedraw();
        if (bl2) {
            n7 = OS.SetWindowLongPtr(this.handle, -4, TableProc);
            n6 = OS.SetWindowLongPtr(n8, -4, HeaderProc);
        }
        boolean bl3 = false;
        if (OS.LOWORD(n2) != 8 && OS.COMCTL32_MAJOR >= 6 && this.columnCount > 32 && (n4 = OS.SendMessage(this.handle, 4136, 0, 0)) > 16) {
            boolean bl4 = bl3 = this.getDrawing() && OS.IsWindowVisible(this.handle);
        }
        if (bl3) {
            OS.DefWindowProc(this.handle, 11, 0, 0);
        }
        LRESULT lRESULT = super.WM_HSCROLL(n2, n3);
        if (bl3) {
            OS.DefWindowProc(this.handle, 11, 1, 0);
            int n9 = 1157;
            OS.RedrawWindow(this.handle, null, 0, n9);
            if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                RECT rECT2 = new RECT();
                rECT = new RECT();
                OS.GetClientRect(this.handle, rECT);
                boolean[] blArray = new boolean[this.columnCount];
                for (int i2 = 0; i2 < this.columnCount; ++i2) {
                    blArray[i2] = true;
                    rECT2.top = i2;
                    rECT2.left = 0;
                    if (OS.SendMessage(this.handle, 4152, 0, rECT2) == 0) continue;
                    rECT2.top = rECT.top;
                    rECT2.bottom = rECT.bottom;
                    blArray[i2] = OS.IntersectRect(rECT2, rECT, rECT2);
                }
                try {
                    this.display.hwndParent = OS.GetParent(this.handle);
                    this.display.columnVisible = blArray;
                    OS.UpdateWindow(this.handle);
                }
                finally {
                    this.display.columnVisible = null;
                }
            }
        }
        if (bl2) {
            OS.SetWindowLongPtr(this.handle, -4, n7);
            OS.SetWindowLongPtr(n8, -4, n6);
        }
        if (this._getLinesVisible()) {
            SCROLLINFO sCROLLINFO = new SCROLLINFO();
            sCROLLINFO.cbSize = SCROLLINFO.sizeof;
            sCROLLINFO.fMask = 4;
            OS.GetScrollInfo(this.handle, 0, sCROLLINFO);
            int n10 = sCROLLINFO.nPos;
            if (n10 < n5) {
                rECT = new RECT();
                OS.GetClientRect(this.handle, rECT);
                rECT.right = n5 - n10 + 1;
                OS.InvalidateRect(this.handle, rECT, true);
            }
        }
        return lRESULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    LRESULT WM_VSCROLL(int n2, int n3) {
        int n4;
        Object object;
        RECT rECT;
        int n5;
        int n6;
        int n7 = 0;
        int n8 = 0;
        int n9 = OS.SendMessage(this.handle, 4127, 0, 0);
        boolean bl2 = this.isOptimizedRedraw();
        if (bl2) {
            n8 = OS.SetWindowLongPtr(this.handle, -4, TableProc);
            n7 = OS.SetWindowLongPtr(n9, -4, HeaderProc);
        }
        boolean bl3 = false;
        if (OS.LOWORD(n2) != 8 && OS.COMCTL32_MAJOR >= 6 && this.columnCount > 32 && (n6 = OS.SendMessage(this.handle, 4136, 0, 0)) > 16) {
            boolean bl4 = bl3 = this.getDrawing() && OS.IsWindowVisible(this.handle);
        }
        if (bl3) {
            OS.DefWindowProc(this.handle, 11, 0, 0);
        }
        LRESULT lRESULT = super.WM_VSCROLL(n2, n3);
        if (bl3) {
            OS.DefWindowProc(this.handle, 11, 1, 0);
            n5 = 1157;
            OS.RedrawWindow(this.handle, null, 0, n5);
            if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                rECT = new RECT();
                RECT rECT2 = new RECT();
                OS.GetClientRect(this.handle, rECT2);
                object = new boolean[this.columnCount];
                for (n4 = 0; n4 < this.columnCount; ++n4) {
                    object[n4] = true;
                    rECT.top = n4;
                    rECT.left = 0;
                    if (OS.SendMessage(this.handle, 4152, 0, rECT) == 0) continue;
                    rECT.top = rECT2.top;
                    rECT.bottom = rECT2.bottom;
                    object[n4] = OS.IntersectRect(rECT, rECT2, rECT);
                }
                try {
                    this.display.hwndParent = OS.GetParent(this.handle);
                    this.display.columnVisible = (boolean[])object;
                    OS.UpdateWindow(this.handle);
                }
                finally {
                    this.display.columnVisible = null;
                }
            }
        }
        if (bl2) {
            OS.SetWindowLongPtr(this.handle, -4, n8);
            OS.SetWindowLongPtr(n9, -4, n7);
        }
        if (this._getLinesVisible()) {
            n5 = OS.LOWORD(n2);
            switch (n5) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 0: 
                case 1: {
                    rECT = new RECT();
                    OS.GetWindowRect(n9, rECT);
                    int n10 = rECT.bottom - rECT.top;
                    object = new RECT();
                    OS.GetClientRect(this.handle, (RECT)object);
                    ((RECT)object).top += n10;
                    n4 = OS.SendMessage(this.handle, 4160, 0, 0);
                    int n11 = OS.SendMessage(this.handle, 4160, 1, 0);
                    int n12 = OS.HIWORD(n11) - OS.HIWORD(n4);
                    if (n5 == 1) {
                        ((RECT)object).top = ((RECT)object).bottom - n12 - 1;
                    } else {
                        ((RECT)object).bottom = ((RECT)object).top + n12 + 1;
                    }
                    OS.InvalidateRect(this.handle, (RECT)object, true);
                    break;
                }
                case 2: 
                case 3: {
                    OS.InvalidateRect(this.handle, null, true);
                }
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT wmMeasureChild(int n2, int n3) {
        MEASUREITEMSTRUCT mEASUREITEMSTRUCT = new MEASUREITEMSTRUCT();
        OS.MoveMemory(mEASUREITEMSTRUCT, n3, MEASUREITEMSTRUCT.sizeof);
        if (this.itemHeight == -1) {
            int n4 = OS.SendMessage(this.handle, 4160, 0, 0);
            int n5 = OS.SendMessage(this.handle, 4160, 1, 0);
            mEASUREITEMSTRUCT.itemHeight = OS.HIWORD(n5) - OS.HIWORD(n4);
        } else {
            mEASUREITEMSTRUCT.itemHeight = this.itemHeight;
        }
        OS.MoveMemory(n3, mEASUREITEMSTRUCT, MEASUREITEMSTRUCT.sizeof);
        return null;
    }

    @Override
    LRESULT wmNotify(NMHDR nMHDR, int n2, int n3) {
        LRESULT lRESULT;
        int n4 = OS.SendMessage(this.handle, 4174, 0, 0);
        if (nMHDR.hwndFrom == n4 && (lRESULT = this.wmNotifyToolTip(nMHDR, n2, n3)) != null) {
            return lRESULT;
        }
        if (nMHDR.hwndFrom == this.hwndHeader && (lRESULT = this.wmNotifyHeader(nMHDR, n2, n3)) != null) {
            return lRESULT;
        }
        return super.wmNotify(nMHDR, n2, n3);
    }

    @Override
    LRESULT wmNotifyChild(NMHDR nMHDR, int n2, int n3) {
        switch (nMHDR.code) {
            case -179: 
            case -152: {
                if ((this.style & 0x10000000) == 0) break;
                return new LRESULT(-1);
            }
            case -115: {
                boolean bl2;
                if ((this.style & 0x10000000) == 0 || this.ignoreSelect) break;
                NMLVODSTATECHANGE nMLVODSTATECHANGE = new NMLVODSTATECHANGE();
                OS.MoveMemory(nMLVODSTATECHANGE, n3, NMLVODSTATECHANGE.sizeof);
                boolean bl3 = (nMLVODSTATECHANGE.uOldState & 2) != 0;
                boolean bl4 = bl2 = (nMLVODSTATECHANGE.uNewState & 2) != 0;
                if (bl3 == bl2) break;
                this.wasSelected = true;
                break;
            }
            case -177: 
            case -150: {
                Object[] objectArray;
                Object object;
                TableItem tableItem;
                NMLVDISPINFO nMLVDISPINFO = new NMLVDISPINFO();
                OS.MoveMemory(nMLVDISPINFO, n3, NMLVDISPINFO.sizeof);
                boolean[] blArray = this.display.columnVisible;
                if (blArray != null && !blArray[nMLVDISPINFO.iSubItem] || (tableItem = this._getItem(nMLVDISPINFO.iItem)) == null) break;
                if (this.ignoreShrink) {
                    if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                        RECT rECT = new RECT();
                        rECT.left = 0;
                        this.ignoreCustomDraw = true;
                        int n4 = OS.SendMessage(this.handle, 4110, nMLVDISPINFO.iItem, rECT);
                        this.ignoreCustomDraw = false;
                        if (n4 == 0) break;
                        OS.InvalidateRect(this.handle, rECT, true);
                        break;
                    }
                    if ((this.style & 0x10000000) != 0 && !tableItem.cached) {
                        OS.SendMessage(this.handle, 4117, nMLVDISPINFO.iItem, nMLVDISPINFO.iItem);
                        break;
                    }
                }
                if (!tableItem.cached) {
                    if ((this.style & 0x10000000) != 0) {
                        this.lastIndexOf = nMLVDISPINFO.iItem;
                        if (!this.checkData(tableItem, this.lastIndexOf, false)) break;
                        Object object2 = object = this.fixScrollWidth ? null : tableItem;
                        if (this.setScrollWidth((TableItem)object, true)) {
                            OS.InvalidateRect(this.handle, null, true);
                        }
                    }
                    tableItem.cached = true;
                }
                if ((nMLVDISPINFO.mask & 1) != 0) {
                    object = null;
                    if (nMLVDISPINFO.iSubItem == 0) {
                        object = tableItem.text;
                    } else {
                        String[] stringArray = tableItem.strings;
                        if (stringArray != null && nMLVDISPINFO.iSubItem < stringArray.length) {
                            object = stringArray[nMLVDISPINFO.iSubItem];
                        }
                    }
                    if (object != null) {
                        int n5 = Math.min(((String)object).length(), nMLVDISPINFO.cchTextMax - 1);
                        if (!this.tipRequested && nMLVDISPINFO.iSubItem == 0 && n5 == 0) {
                            object = " ";
                            n5 = 1;
                        }
                        if (n5 > 1 && (this.state & 0x400000) != 0) {
                            switch (BidiUtil.resolveTextDirection((String)object)) {
                                case 0x2000000: {
                                    object = '\u202a' + (String)object;
                                    ++n5;
                                    break;
                                }
                                case 0x4000000: {
                                    object = '\u202b' + (String)object;
                                    ++n5;
                                }
                            }
                        }
                        if ((objectArray = (Object[])this.display.tableBuffer) == null || nMLVDISPINFO.cchTextMax > objectArray.length) {
                            this.display.tableBuffer = new char[nMLVDISPINFO.cchTextMax];
                            objectArray = this.display.tableBuffer;
                        }
                        ((String)object).getChars(0, n5, (char[])objectArray, 0);
                        if (this.tipRequested) {
                            int n6 = 0;
                            block28: for (int i2 = 0; i2 < n5; ++i2) {
                                switch (objectArray[i2]) {
                                    case 10: 
                                    case 13: {
                                        ++n6;
                                        continue block28;
                                    }
                                    default: {
                                        if (n6 == 0) continue block28;
                                        objectArray[i2 - n6] = objectArray[i2];
                                    }
                                }
                            }
                            n5 -= n6;
                        }
                        objectArray[n5++] = (Image)false;
                        if (OS.IsUnicode) {
                            OS.MoveMemory(nMLVDISPINFO.pszText, (char[])objectArray, n5 * 2);
                        } else {
                            OS.WideCharToMultiByte(this.getCodePage(), 0, (char[])objectArray, n5, nMLVDISPINFO.pszText, nMLVDISPINFO.cchTextMax, null, null);
                            OS.MoveMemory(nMLVDISPINFO.pszText + nMLVDISPINFO.cchTextMax - 1, new byte[1], 1);
                        }
                    }
                }
                boolean bl5 = false;
                if ((nMLVDISPINFO.mask & 2) != 0) {
                    Image image = null;
                    if (nMLVDISPINFO.iSubItem == 0) {
                        image = tableItem.image;
                    } else {
                        objectArray = tableItem.images;
                        if (objectArray != null && nMLVDISPINFO.iSubItem < objectArray.length) {
                            image = objectArray[nMLVDISPINFO.iSubItem];
                        }
                    }
                    if (image != null) {
                        nMLVDISPINFO.iImage = this.imageIndex(image, nMLVDISPINFO.iSubItem);
                        bl5 = true;
                    }
                }
                if ((nMLVDISPINFO.mask & 8) != 0 && nMLVDISPINFO.iSubItem == 0) {
                    int n7 = 1;
                    if (tableItem.checked) {
                        ++n7;
                    }
                    if (tableItem.grayed) {
                        n7 += 2;
                    }
                    if (!OS.IsWindowEnabled(this.handle)) {
                        n7 += 4;
                    }
                    nMLVDISPINFO.state = n7 << 12;
                    nMLVDISPINFO.stateMask = 61440;
                    bl5 = true;
                }
                if ((nMLVDISPINFO.mask & 0x10) != 0 && nMLVDISPINFO.iSubItem == 0) {
                    nMLVDISPINFO.iIndent = tableItem.imageIndent;
                    bl5 = true;
                }
                if (!bl5) break;
                OS.MoveMemory(n3, nMLVDISPINFO, NMLVDISPINFO.sizeof);
                break;
            }
            case -12: {
                int n8 = OS.SendMessage(this.handle, 4127, 0, 0);
                if (nMHDR.hwndFrom == n8 || !this.customDraw && this.findImageControl() == null && OS.IsWindowEnabled(this.handle) && (!this.explorerTheme || this.columnCount != 0)) break;
                NMLVCUSTOMDRAW nMLVCUSTOMDRAW = new NMLVCUSTOMDRAW();
                OS.MoveMemory(nMLVCUSTOMDRAW, n3, NMLVCUSTOMDRAW.sizeof);
                switch (nMLVCUSTOMDRAW.dwDrawStage) {
                    case 1: {
                        return this.CDDS_PREPAINT(nMLVCUSTOMDRAW, n2, n3);
                    }
                    case 65537: {
                        return this.CDDS_ITEMPREPAINT(nMLVCUSTOMDRAW, n2, n3);
                    }
                    case 65538: {
                        return this.CDDS_ITEMPOSTPAINT(nMLVCUSTOMDRAW, n2, n3);
                    }
                    case 196609: {
                        return this.CDDS_SUBITEMPREPAINT(nMLVCUSTOMDRAW, n2, n3);
                    }
                    case 196610: {
                        return this.CDDS_SUBITEMPOSTPAINT(nMLVCUSTOMDRAW, n2, n3);
                    }
                    case 2: {
                        return this.CDDS_POSTPAINT(nMLVCUSTOMDRAW, n2, n3);
                    }
                }
                break;
            }
            case -156: {
                if ((this.style & 4) != 0) {
                    return LRESULT.ONE;
                }
                if (this.hooks(3) || this.hooks(4)) {
                    return LRESULT.ONE;
                }
                if ((this.style & 0x4000000) == 0 || this.findImageControl() == null) break;
                return LRESULT.ONE;
            }
            case -111: 
            case -109: {
                if (OS.GetKeyState(1) >= 0) break;
                this.dragStarted = true;
                if (nMHDR.code != -109) break;
                int n9 = OS.GetMessagePos();
                POINT pOINT = new POINT();
                OS.POINTSTOPOINT(pOINT, n9);
                OS.ScreenToClient(this.handle, pOINT);
                this.sendDragEvent(1, pOINT.x, pOINT.y);
                break;
            }
            case -108: {
                NMLISTVIEW nMLISTVIEW = new NMLISTVIEW();
                OS.MoveMemory(nMLISTVIEW, n3, NMLISTVIEW.sizeof);
                TableColumn tableColumn = this.columns[nMLISTVIEW.iSubItem];
                if (tableColumn == null) break;
                tableColumn.sendSelectionEvent(13);
                break;
            }
            case -114: {
                if (this.ignoreActivate) break;
                NMLISTVIEW nMLISTVIEW = new NMLISTVIEW();
                OS.MoveMemory(nMLISTVIEW, n3, NMLISTVIEW.sizeof);
                if (nMLISTVIEW.iItem == -1) break;
                Event event = new Event();
                event.item = this._getItem(nMLISTVIEW.iItem);
                this.sendSelectionEvent(14, event, false);
                break;
            }
            case -101: {
                int n10;
                int n11;
                if (this.fullRowSelect) {
                    this.fullRowSelect = false;
                    OS.DefWindowProc(this.handle, 11, 1, 0);
                    OS.SendMessage(this.handle, 4150, 32, 0);
                }
                if (!this.ignoreSelect) {
                    NMLISTVIEW nMLISTVIEW = new NMLISTVIEW();
                    OS.MoveMemory(nMLISTVIEW, n3, NMLISTVIEW.sizeof);
                    if ((nMLISTVIEW.uChanged & 8) != 0) {
                        if (nMLISTVIEW.iItem == -1) {
                            this.wasSelected = true;
                        } else {
                            int n12;
                            n11 = (nMLISTVIEW.uOldState & 2) != 0 ? 1 : 0;
                            int n13 = n12 = (nMLISTVIEW.uNewState & 2) != 0 ? 1 : 0;
                            if (n11 != n12) {
                                this.wasSelected = true;
                            }
                        }
                    }
                }
                if (!this.hooks(40) && !this.hooks(42) || (n11 = OS.SendMessage(n10 = OS.SendMessage(this.handle, 4127, 0, 0), 4608, 0, 0)) == 0) break;
                this.forceResize();
                RECT rECT = new RECT();
                OS.GetClientRect(this.handle, rECT);
                NMLISTVIEW nMLISTVIEW = new NMLISTVIEW();
                OS.MoveMemory(nMLISTVIEW, n3, NMLISTVIEW.sizeof);
                if (nMLISTVIEW.iItem == -1) break;
                RECT rECT2 = new RECT();
                rECT2.left = 0;
                this.ignoreCustomDraw = true;
                OS.SendMessage(this.handle, 4110, nMLISTVIEW.iItem, rECT2);
                this.ignoreCustomDraw = false;
                RECT rECT3 = new RECT();
                int n14 = OS.SendMessage(n10, 4623, n11 - 1, 0);
                OS.SendMessage(n10, 4615, n14, rECT3);
                OS.MapWindowPoints(n10, this.handle, rECT3, 2);
                rECT.left = rECT3.right;
                rECT.top = rECT2.top;
                rECT.bottom = rECT2.bottom;
                OS.InvalidateRect(this.handle, rECT, true);
                break;
            }
            case -16: {
                boolean bl6;
                if (!OS.IsPPC) break;
                boolean bl7 = bl6 = this.menu != null && !this.menu.isDisposed();
                if (bl6 || this.hooks(35)) break;
                return LRESULT.ONE;
            }
            case 1000: {
                boolean bl8;
                if (!OS.IsPPC) break;
                boolean bl9 = bl8 = this.menu != null && !this.menu.isDisposed();
                if (!bl8 && !this.hooks(35)) break;
                NMRGINFO nMRGINFO = new NMRGINFO();
                OS.MoveMemory(nMRGINFO, n3, NMRGINFO.sizeof);
                this.showMenu(nMRGINFO.x, nMRGINFO.y);
                return LRESULT.ONE;
            }
        }
        return super.wmNotifyChild(nMHDR, n2, n3);
    }

    LRESULT wmNotifyHeader(NMHDR nMHDR, int n2, int n3) {
        switch (nMHDR.code) {
            case -326: 
            case -325: 
            case -306: 
            case -305: {
                if (this.columnCount == 0) {
                    return LRESULT.ONE;
                }
                NMHEADER nMHEADER = new NMHEADER();
                OS.MoveMemory(nMHEADER, n3, NMHEADER.sizeof);
                TableColumn tableColumn = this.columns[nMHEADER.iItem];
                if (tableColumn != null && !tableColumn.getResizable()) {
                    return LRESULT.ONE;
                }
                this.ignoreColumnMove = true;
                switch (nMHDR.code) {
                    case -325: 
                    case -305: {
                        boolean bl2 = false;
                        if (!OS.IsWinCE && OS.WIN32_VERSION < OS.VERSION(6, 0)) {
                            boolean bl3 = bl2 = nMHEADER.iItem == 0 && !this.firstColumnImage;
                        }
                        if (tableColumn == null || !bl2 && !this.hooks(41)) break;
                        tableColumn.pack();
                        return LRESULT.ONE;
                    }
                }
                break;
            }
            case -12: {
                NMCUSTOMDRAW nMCUSTOMDRAW = new NMCUSTOMDRAW();
                OS.MoveMemory(nMCUSTOMDRAW, n3, NMCUSTOMDRAW.sizeof);
                switch (nMCUSTOMDRAW.dwDrawStage) {
                    case 1: {
                        return new LRESULT(this.customHeaderDrawing() ? 48 : 0);
                    }
                    case 65537: {
                        RECT rECT = new RECT();
                        OS.SetRect(rECT, nMCUSTOMDRAW.left, nMCUSTOMDRAW.top, nMCUSTOMDRAW.right, nMCUSTOMDRAW.bottom);
                        int n4 = this.getHeaderBackgroundPixel();
                        if ((nMCUSTOMDRAW.uItemState & 1) != 0) {
                            n4 = this.getDifferentColor(n4);
                        } else if (this.columns[nMCUSTOMDRAW.dwItemSpec] == this.sortColumn && this.sortDirection != 0) {
                            n4 = this.getSlightlyDifferentColor(n4);
                        }
                        int n5 = OS.CreateSolidBrush(n4);
                        OS.FillRect(nMCUSTOMDRAW.hdc, rECT, n5);
                        OS.DeleteObject(n5);
                        return new LRESULT(4);
                    }
                    case 2: {
                        int n6;
                        int n7;
                        POINT pOINT = new POINT();
                        OS.GetCursorPos(pOINT);
                        OS.MapWindowPoints(0, this.hwndHeader, pOINT, 1);
                        int n8 = -1;
                        int n9 = -1;
                        RECT[] rECTArray = new RECT[this.columnCount];
                        for (n7 = 0; n7 < this.columnCount; ++n7) {
                            Object object;
                            int n10;
                            int n11;
                            int n12;
                            rECTArray[n7] = new RECT();
                            OS.SendMessage(this.hwndHeader, 4615, n7, rECTArray[n7]);
                            if (rECTArray[n7].right > n9) {
                                n9 = rECTArray[n7].right;
                            }
                            if (this.columns[n7] == this.sortColumn && this.sortDirection != 0) {
                                n6 = OS.CreatePen(0, 1, OS.GetSysColor(OS.COLOR_3DDKSHADOW));
                                n12 = OS.SelectObject(nMCUSTOMDRAW.hdc, n6);
                                n11 = rECTArray[n7].left + (rECTArray[n7].right - rECTArray[n7].left) / 2;
                                n10 = 3;
                                if (this.sortDirection == 128) {
                                    OS.Polyline(nMCUSTOMDRAW.hdc, new int[]{n11 - n10, 1 + n10, n11 + 1, 0}, 2);
                                    OS.Polyline(nMCUSTOMDRAW.hdc, new int[]{n11 + n10, 1 + n10, n11 - 1, 0}, 2);
                                } else if (this.sortDirection == 1024) {
                                    OS.Polyline(nMCUSTOMDRAW.hdc, new int[]{n11 - n10, 1, n11 + 1, 1 + n10 + 1}, 2);
                                    OS.Polyline(nMCUSTOMDRAW.hdc, new int[]{n11 + n10, 1, n11 - 1, 1 + n10 + 1}, 2);
                                }
                                OS.SelectObject(nMCUSTOMDRAW.hdc, n12);
                                OS.DeleteObject(n6);
                            }
                            n6 = OS.CreatePen(0, this.getGridLineWidthInPixels(), this.getSlightlyDifferentColor(this.getHeaderBackgroundPixel()));
                            n12 = OS.SelectObject(nMCUSTOMDRAW.hdc, n6);
                            OS.Polyline(nMCUSTOMDRAW.hdc, new int[]{rECTArray[n7].right - 1, rECTArray[n7].top, rECTArray[n7].right - 1, rECTArray[n7].bottom}, 2);
                            OS.SelectObject(nMCUSTOMDRAW.hdc, n12);
                            OS.DeleteObject(n6);
                            if (this._getLinesVisible()) {
                                n6 = OS.CreatePen(0, this.getGridLineWidthInPixels(), OS.GetSysColor(OS.COLOR_3DFACE));
                                n12 = OS.SelectObject(nMCUSTOMDRAW.hdc, n6);
                                OS.Polyline(nMCUSTOMDRAW.hdc, new int[]{rECTArray[n7].right, rECTArray[n7].top, rECTArray[n7].right, rECTArray[n7].bottom}, 2);
                                OS.SelectObject(nMCUSTOMDRAW.hdc, n12);
                                OS.DeleteObject(n6);
                            }
                            if (this.headerItemDragging && n8 == -1) {
                                n11 = pOINT.x - rECTArray[n7].left;
                                n10 = rECTArray[n7].right - pOINT.x;
                                if (n11 >= 0 && n10 >= 0) {
                                    n8 = n11 <= n10 ? rECTArray[n7].left - 1 : rECTArray[n7].right;
                                }
                            }
                            n11 = rECTArray[n7].left + 4 + 2;
                            if (this.columns[n7].image != null) {
                                GCData gCData = new GCData();
                                gCData.device = this.display;
                                object = GC.win32_new(nMCUSTOMDRAW.hdc, gCData);
                                int n13 = Math.max(0, (nMCUSTOMDRAW.bottom - this.columns[n7].image.getBoundsInPixels().height) / 2);
                                ((GC)object).drawImage(this.columns[n7].image, DPIUtil.autoScaleDown(n11), DPIUtil.autoScaleDown(n13));
                                n11 += this.columns[n7].image.getBoundsInPixels().width + 12;
                                ((Resource)object).dispose();
                            }
                            if (this.columns[n7].text == null) continue;
                            int n14 = 2084;
                            if ((this.columns[n7].style & 0x1000000) != 0) {
                                n14 |= 1;
                            }
                            if ((this.columns[n7].style & 0x20000) != 0) {
                                n14 |= 2;
                            }
                            object = new TCHAR(this.getCodePage(), this.columns[n7].text, false);
                            OS.SetBkMode(nMCUSTOMDRAW.hdc, 1);
                            OS.SetTextColor(nMCUSTOMDRAW.hdc, this.getHeaderForegroundPixel());
                            RECT rECT = new RECT();
                            rECT.left = n11;
                            rECT.top = rECTArray[n7].top;
                            rECT.right = rECTArray[n7].right;
                            rECT.bottom = rECTArray[n7].bottom;
                            OS.DrawText(nMCUSTOMDRAW.hdc, (TCHAR)object, ((TCHAR)object).length(), rECT, n14);
                        }
                        if (n9 < nMCUSTOMDRAW.right) {
                            RECT rECT = new RECT();
                            OS.SetRect(rECT, n9 += this._getLinesVisible() ? 1 : 0, nMCUSTOMDRAW.top, nMCUSTOMDRAW.right, nMCUSTOMDRAW.bottom);
                            n6 = OS.CreateSolidBrush(this.getHeaderBackgroundPixel());
                            OS.FillRect(nMCUSTOMDRAW.hdc, rECT, n6);
                            OS.DeleteObject(n6);
                        }
                        if (n8 != -1) {
                            n7 = OS.CreatePen(0, 4, OS.GetSysColor(OS.COLOR_HIGHLIGHT));
                            n6 = OS.SelectObject(nMCUSTOMDRAW.hdc, n7);
                            OS.Polyline(nMCUSTOMDRAW.hdc, new int[]{n8, nMCUSTOMDRAW.top, n8, nMCUSTOMDRAW.bottom}, 2);
                            OS.SelectObject(nMCUSTOMDRAW.hdc, n6);
                            OS.DeleteObject(n7);
                        }
                        return new LRESULT(0);
                    }
                }
                break;
            }
            case -16: {
                if (!this.ignoreColumnMove) {
                    for (int i2 = 0; i2 < this.columnCount; ++i2) {
                        TableColumn tableColumn = this.columns[i2];
                        tableColumn.updateToolTip(i2);
                    }
                }
                this.ignoreColumnMove = false;
                break;
            }
            case -310: {
                TableColumn tableColumn;
                if (this.ignoreColumnMove) {
                    return LRESULT.ONE;
                }
                int n15 = OS.SendMessage(this.handle, 4151, 0, 0);
                if ((n15 & 0x10) == 0) break;
                if (this.columnCount == 0) {
                    return LRESULT.ONE;
                }
                NMHEADER nMHEADER = new NMHEADER();
                OS.MoveMemory(nMHEADER, n3, NMHEADER.sizeof);
                if (nMHEADER.iItem != -1 && (tableColumn = this.columns[nMHEADER.iItem]) != null && !tableColumn.getMoveable()) {
                    this.ignoreColumnMove = true;
                    return LRESULT.ONE;
                }
                this.headerItemDragging = true;
                break;
            }
            case -311: {
                int n16;
                this.headerItemDragging = false;
                int n17 = OS.SendMessage(this.handle, 4151, 0, 0);
                if ((n17 & 0x10) == 0) break;
                NMHEADER nMHEADER = new NMHEADER();
                OS.MoveMemory(nMHEADER, n3, NMHEADER.sizeof);
                if (nMHEADER.iItem == -1 || nMHEADER.pitem == 0) break;
                HDITEM hDITEM = new HDITEM();
                OS.MoveMemory(hDITEM, nMHEADER.pitem, HDITEM.sizeof);
                if ((hDITEM.mask & 0x80) == 0 || hDITEM.iOrder == -1 || this.columnCount == 0) break;
                int[] nArray = new int[this.columnCount];
                OS.SendMessage(this.handle, 4155, this.columnCount, nArray);
                for (n16 = 0; n16 < nArray.length && nArray[n16] != nMHEADER.iItem; ++n16) {
                }
                if (n16 == nArray.length) {
                    n16 = 0;
                }
                if (n16 == hDITEM.iOrder) break;
                int n18 = Math.min(n16, hDITEM.iOrder);
                int n19 = Math.max(n16, hDITEM.iOrder);
                this.ignoreColumnMove = false;
                for (int i3 = n18; i3 <= n19; ++i3) {
                    TableColumn tableColumn = this.columns[nArray[i3]];
                    if (tableColumn.isDisposed()) continue;
                    tableColumn.postEvent(10);
                }
                break;
            }
            case -321: 
            case -301: {
                TableColumn tableColumn;
                Object object;
                int n20 = OS.SendMessage(this.handle, 4125, 0, 0);
                if (this.lastWidth == 0 && n20 > 0 && this._getLinesVisible()) {
                    object = new RECT();
                    OS.GetClientRect(this.handle, (RECT)object);
                    ((RECT)object).right = ((RECT)object).left + n20;
                    OS.InvalidateRect(this.handle, (RECT)object, true);
                }
                this.lastWidth = n20;
                if (this.ignoreColumnResize) break;
                object = new NMHEADER();
                OS.MoveMemory((NMHEADER)object, n3, NMHEADER.sizeof);
                if (((NMHEADER)object).pitem == 0) break;
                HDITEM hDITEM = new HDITEM();
                OS.MoveMemory(hDITEM, ((NMHEADER)object).pitem, HDITEM.sizeof);
                if ((hDITEM.mask & 1) == 0 || (tableColumn = this.columns[((NMHEADER)object).iItem]) == null) break;
                tableColumn.updateToolTip(((NMHEADER)object).iItem);
                tableColumn.sendEvent(11);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                TableColumn[] tableColumnArray = new TableColumn[this.columnCount];
                System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columnCount);
                int[] nArray = new int[this.columnCount];
                OS.SendMessage(this.handle, 4155, this.columnCount, nArray);
                boolean bl4 = false;
                for (int i4 = 0; i4 < this.columnCount; ++i4) {
                    TableColumn tableColumn2 = tableColumnArray[nArray[i4]];
                    if (bl4 && !tableColumn2.isDisposed()) {
                        tableColumn2.updateToolTip(nArray[i4]);
                        tableColumn2.sendEvent(10);
                    }
                    if (tableColumn2 != tableColumn) continue;
                    bl4 = true;
                }
                break;
            }
            case -323: 
            case -303: {
                NMHEADER nMHEADER = new NMHEADER();
                OS.MoveMemory(nMHEADER, n3, NMHEADER.sizeof);
                TableColumn tableColumn = this.columns[nMHEADER.iItem];
                if (tableColumn == null) break;
                tableColumn.sendSelectionEvent(14);
                break;
            }
        }
        return null;
    }

    LRESULT wmNotifyToolTip(NMHDR nMHDR, int n2, int n3) {
        if (OS.IsWinCE) {
            return null;
        }
        switch (nMHDR.code) {
            case -12: {
                if (this.toolTipText != null || !this.isCustomToolTip()) break;
                NMTTCUSTOMDRAW nMTTCUSTOMDRAW = new NMTTCUSTOMDRAW();
                OS.MoveMemory(nMTTCUSTOMDRAW, n3, NMTTCUSTOMDRAW.sizeof);
                return this.wmNotifyToolTip(nMTTCUSTOMDRAW, n3);
            }
            case -530: 
            case -521: 
            case -520: {
                LRESULT lRESULT = super.wmNotify(nMHDR, n2, n3);
                if (lRESULT != null) {
                    return lRESULT;
                }
                if (nMHDR.code != -521) {
                    this.tipRequested = true;
                }
                int n4 = this.callWindowProc(this.handle, 78, n2, n3);
                if (nMHDR.code != -521) {
                    this.tipRequested = false;
                }
                if (this.toolTipText != null) break;
                if (this.isCustomToolTip()) {
                    LVHITTESTINFO lVHITTESTINFO = new LVHITTESTINFO();
                    int n5 = OS.GetMessagePos();
                    POINT pOINT = new POINT();
                    OS.POINTSTOPOINT(pOINT, n5);
                    OS.ScreenToClient(this.handle, pOINT);
                    lVHITTESTINFO.x = pOINT.x;
                    lVHITTESTINFO.y = pOINT.y;
                    if (OS.SendMessage(this.handle, 4153, 0, lVHITTESTINFO) >= 0) {
                        int n6;
                        TableItem tableItem = this._getItem(lVHITTESTINFO.iItem);
                        int n7 = OS.GetDC(this.handle);
                        int n8 = 0;
                        int n9 = OS.SendMessage(this.handle, 49, 0, 0);
                        if (n9 != 0) {
                            n8 = OS.SelectObject(n7, n9);
                        }
                        if ((n6 = tableItem.fontHandle(lVHITTESTINFO.iSubItem)) != -1) {
                            n6 = OS.SelectObject(n7, n6);
                        }
                        Event event = this.sendMeasureItemEvent(tableItem, lVHITTESTINFO.iItem, lVHITTESTINFO.iSubItem, n7);
                        if (!this.isDisposed() && !tableItem.isDisposed()) {
                            RECT rECT = new RECT();
                            Rectangle rectangle = event.getBoundsInPixels();
                            OS.SetRect(rECT, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                            if (nMHDR.code == -521) {
                                RECT rECT2 = this.toolTipRect(rECT);
                                OS.MapWindowPoints(this.handle, 0, rECT2, 2);
                                int n10 = OS.SendMessage(this.handle, 4174, 0, 0);
                                int n11 = 20;
                                int n12 = rECT2.right - rECT2.left;
                                int n13 = rECT2.bottom - rECT2.top;
                                this.SetWindowPos(n10, 0, rECT2.left, rECT2.top, n12, n13, n11);
                            } else {
                                String string;
                                NMTTDISPINFO nMTTDISPINFO = null;
                                if (nMHDR.code == -520) {
                                    nMTTDISPINFO = new NMTTDISPINFOA();
                                    OS.MoveMemory(nMTTDISPINFO, n3, NMTTDISPINFOA.sizeof);
                                    if (nMTTDISPINFO.lpszText != 0) {
                                        OS.MoveMemory(nMTTDISPINFO.lpszText, new byte[1], 1);
                                        OS.MoveMemory(n3, nMTTDISPINFO, NMTTDISPINFOA.sizeof);
                                    }
                                } else {
                                    nMTTDISPINFO = new NMTTDISPINFOW();
                                    OS.MoveMemory((NMTTDISPINFOW)nMTTDISPINFO, n3, NMTTDISPINFOW.sizeof);
                                    if (nMTTDISPINFO.lpszText != 0) {
                                        OS.MoveMemory(nMTTDISPINFO.lpszText, new char[1], 2);
                                        OS.MoveMemory(n3, (NMTTDISPINFOW)nMTTDISPINFO, NMTTDISPINFOW.sizeof);
                                    }
                                }
                                RECT rECT3 = tableItem.getBounds(lVHITTESTINFO.iItem, lVHITTESTINFO.iSubItem, true, true, true, true, n7);
                                RECT rECT4 = new RECT();
                                OS.GetClientRect(this.handle, rECT4);
                                if ((rECT.right > rECT3.right || rECT.right > rECT4.right) && (string = " ") != null) {
                                    Shell shell = this.getShell();
                                    char[] cArray = new char[string.length() + 1];
                                    string.getChars(0, string.length(), cArray, 0);
                                    if (nMHDR.code == -520) {
                                        byte[] byArray = new byte[cArray.length * 2];
                                        OS.WideCharToMultiByte(this.getCodePage(), 0, cArray, cArray.length, byArray, byArray.length, null, null);
                                        shell.setToolTipText(nMTTDISPINFO, byArray);
                                        OS.MoveMemory(n3, nMTTDISPINFO, NMTTDISPINFOA.sizeof);
                                    } else {
                                        shell.setToolTipText(nMTTDISPINFO, cArray);
                                        OS.MoveMemory(n3, (NMTTDISPINFOW)nMTTDISPINFO, NMTTDISPINFOW.sizeof);
                                    }
                                }
                            }
                        }
                        if (n6 != -1) {
                            n6 = OS.SelectObject(n7, n6);
                        }
                        if (n9 != 0) {
                            OS.SelectObject(n7, n8);
                        }
                        OS.ReleaseDC(this.handle, n7);
                    }
                }
                return new LRESULT(n4);
            }
        }
        return null;
    }

    LRESULT wmNotifyToolTip(NMTTCUSTOMDRAW nMTTCUSTOMDRAW, int n2) {
        if (OS.IsWinCE) {
            return null;
        }
        switch (nMTTCUSTOMDRAW.dwDrawStage) {
            case 1: {
                if (!this.isCustomToolTip()) break;
                return new LRESULT(18);
            }
            case 2: {
                Object object;
                LVHITTESTINFO lVHITTESTINFO = new LVHITTESTINFO();
                int n3 = OS.GetMessagePos();
                POINT pOINT = new POINT();
                OS.POINTSTOPOINT(pOINT, n3);
                OS.ScreenToClient(this.handle, pOINT);
                lVHITTESTINFO.x = pOINT.x;
                lVHITTESTINFO.y = pOINT.y;
                if (OS.SendMessage(this.handle, 4153, 0, lVHITTESTINFO) < 0) break;
                TableItem tableItem = this._getItem(lVHITTESTINFO.iItem);
                int n4 = OS.GetDC(this.handle);
                int n5 = tableItem.fontHandle(lVHITTESTINFO.iSubItem);
                if (n5 == -1) {
                    n5 = OS.SendMessage(this.handle, 49, 0, 0);
                }
                int n6 = OS.SelectObject(n4, n5);
                boolean bl2 = true;
                RECT rECT = tableItem.getBounds(lVHITTESTINFO.iItem, lVHITTESTINFO.iSubItem, true, true, false, false, n4);
                if (this.hooks(40)) {
                    object = this.sendEraseItemEvent(tableItem, nMTTCUSTOMDRAW, lVHITTESTINFO.iSubItem, rECT);
                    if (this.isDisposed() || tableItem.isDisposed()) break;
                    bl2 = ((Event)object).doit ? (((Event)object).detail & 0x10) != 0 : false;
                }
                if (bl2) {
                    Object object2;
                    Object object3;
                    Image image;
                    int n7 = OS.SaveDC(nMTTCUSTOMDRAW.hdc);
                    int n8 = this.getLinesVisible() ? 1 : 0;
                    RECT rECT2 = this.toolTipInset(rECT);
                    OS.SetWindowOrgEx(nMTTCUSTOMDRAW.hdc, rECT2.left, rECT2.top, null);
                    GCData gCData = new GCData();
                    gCData.device = this.display;
                    gCData.foreground = OS.GetTextColor(nMTTCUSTOMDRAW.hdc);
                    gCData.background = OS.GetBkColor(nMTTCUSTOMDRAW.hdc);
                    gCData.font = Font.win32_new(this.display, n5);
                    GC gC = GC.win32_new(nMTTCUSTOMDRAW.hdc, gCData);
                    int n9 = rECT.left;
                    if (lVHITTESTINFO.iSubItem != 0) {
                        n9 -= n8;
                    }
                    if ((image = tableItem.getImage(lVHITTESTINFO.iSubItem)) != null) {
                        object3 = image.getBoundsInPixels();
                        RECT rECT3 = tableItem.getBounds(lVHITTESTINFO.iItem, lVHITTESTINFO.iSubItem, false, true, false, false, n4);
                        object2 = this.imageList == null ? new Point(((Rectangle)object3).width, ((Rectangle)object3).height) : this.imageList.getImageSize();
                        int n10 = rECT3.top;
                        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                            n10 += Math.max(0, (rECT3.bottom - rECT3.top - ((Point)object2).y) / 2);
                        }
                        object3 = DPIUtil.autoScaleDown((Rectangle)object3);
                        gC.drawImage(image, ((Rectangle)object3).x, ((Rectangle)object3).y, ((Rectangle)object3).width, ((Rectangle)object3).height, DPIUtil.autoScaleDown(n9), DPIUtil.autoScaleDown(n10), DPIUtil.autoScaleDown(((Point)object2).x), DPIUtil.autoScaleDown(((Point)object2).y));
                        n9 += ((Point)object2).x + 4 + (lVHITTESTINFO.iSubItem == 0 ? -2 : 4);
                    } else {
                        n9 += 6;
                    }
                    object3 = tableItem.getText(lVHITTESTINFO.iSubItem);
                    if (object3 != null) {
                        int n11 = 2084;
                        Object object4 = object2 = this.columns != null ? this.columns[lVHITTESTINFO.iSubItem] : null;
                        if (object2 != null) {
                            if ((((TableColumn)object2).style & 0x1000000) != 0) {
                                n11 |= 1;
                            }
                            if ((((TableColumn)object2).style & 0x20000) != 0) {
                                n11 |= 2;
                            }
                        }
                        TCHAR tCHAR = new TCHAR(this.getCodePage(), (String)object3, false);
                        RECT rECT4 = new RECT();
                        OS.SetRect(rECT4, n9, rECT.top, rECT.right, rECT.bottom);
                        OS.DrawText(nMTTCUSTOMDRAW.hdc, tCHAR, tCHAR.length(), rECT4, n11);
                    }
                    gC.dispose();
                    OS.RestoreDC(nMTTCUSTOMDRAW.hdc, n7);
                }
                if (this.hooks(42)) {
                    object = tableItem.getBounds(lVHITTESTINFO.iItem, lVHITTESTINFO.iSubItem, true, true, false, false, n4);
                    this.sendPaintItemEvent(tableItem, nMTTCUSTOMDRAW, lVHITTESTINFO.iSubItem, (RECT)object);
                }
                OS.SelectObject(n4, n6);
                OS.ReleaseDC(this.handle, n4);
            }
        }
        return null;
    }

    static {
        COMPRESS_ITEMS = true;
        TableClass = new TCHAR(0, "SysListView32", true);
        HeaderClass = new TCHAR(0, "SysHeader32", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, TableClass, wNDCLASS);
        TableProc = wNDCLASS.lpfnWndProc;
        OS.GetClassInfo(0, HeaderClass, wNDCLASS);
        HeaderProc = wNDCLASS.lpfnWndProc;
    }
}

