/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.EpollData;
import org.lwjgl.system.linux.EpollEvent$Buffer;

public class EpollEvent
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int EVENTS;
    public static final int DATA;

    protected EpollEvent(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected EpollEvent create(long l2, ByteBuffer byteBuffer) {
        return new EpollEvent(l2, byteBuffer);
    }

    public EpollEvent(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), EpollEvent.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int events() {
        return EpollEvent.nevents(this.address());
    }

    public EpollData data() {
        return EpollEvent.ndata(this.address());
    }

    public EpollEvent events(int n2) {
        EpollEvent.nevents(this.address(), n2);
        return this;
    }

    public EpollEvent data(EpollData epollData) {
        EpollEvent.ndata(this.address(), epollData);
        return this;
    }

    public EpollEvent data(Consumer consumer) {
        consumer.accept(this.data());
        return this;
    }

    public EpollEvent set(int n2, EpollData epollData) {
        this.events(n2);
        this.data(epollData);
        return this;
    }

    public EpollEvent set(EpollEvent epollEvent) {
        MemoryUtil.memCopy(epollEvent.address(), this.address(), SIZEOF);
        return this;
    }

    public static EpollEvent malloc() {
        return new EpollEvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static EpollEvent calloc() {
        return new EpollEvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static EpollEvent create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new EpollEvent(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static EpollEvent create(long l2) {
        return new EpollEvent(l2, null);
    }

    public static EpollEvent createSafe(long l2) {
        return l2 == 0L ? null : new EpollEvent(l2, null);
    }

    public static EpollEvent$Buffer malloc(int n2) {
        return new EpollEvent$Buffer(MemoryUtil.nmemAllocChecked(EpollEvent.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static EpollEvent$Buffer calloc(int n2) {
        return new EpollEvent$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static EpollEvent$Buffer create(int n2) {
        ByteBuffer byteBuffer = EpollEvent.__create(n2, SIZEOF);
        return new EpollEvent$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static EpollEvent$Buffer create(long l2, int n2) {
        return new EpollEvent$Buffer(l2, n2);
    }

    public static EpollEvent$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new EpollEvent$Buffer(l2, n2);
    }

    public static EpollEvent malloc(MemoryStack memoryStack) {
        return new EpollEvent(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static EpollEvent calloc(MemoryStack memoryStack) {
        return new EpollEvent(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static EpollEvent$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new EpollEvent$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static EpollEvent$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new EpollEvent$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int nevents(long l2) {
        return UNSAFE.getInt(null, l2 + (long)EVENTS);
    }

    public static EpollData ndata(long l2) {
        return EpollData.create(l2 + (long)DATA);
    }

    public static void nevents(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)EVENTS, n2);
    }

    public static void ndata(long l2, EpollData epollData) {
        MemoryUtil.memCopy(epollData.address(), l2 + (long)DATA, EpollData.SIZEOF);
    }

    static {
        Struct$Layout struct$Layout = EpollEvent.__struct(EpollEvent.__member(4), EpollEvent.__member(EpollData.SIZEOF, EpollData.ALIGNOF));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        EVENTS = struct$Layout.offsetof(0);
        DATA = struct$Layout.offsetof(1);
    }
}

