/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.embedded.fullscreen.exclusivemode;

import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import uk.co.caprica.vlcj.player.embedded.fullscreen.FullScreenStrategy;

public class ExclusiveModeFullScreenStrategy
implements FullScreenStrategy {
    private final Window a;

    public ExclusiveModeFullScreenStrategy(Window window) {
        if (window == null) {
            throw new IllegalArgumentException("Window must not be null");
        }
        this.a = window;
    }

    @Override
    public void enterFullScreenMode() {
        GraphicsDevice graphicsDevice = this.getScreenDevice();
        if (graphicsDevice.isFullScreenSupported()) {
            this.onBeforeEnterFullScreenMode();
            graphicsDevice.setFullScreenWindow(this.a);
            DisplayMode displayMode = this.getDisplayMode(graphicsDevice.getDisplayModes());
            if (displayMode != null) {
                graphicsDevice.setDisplayMode(displayMode);
            }
        }
    }

    @Override
    public void exitFullScreenMode() {
        this.getScreenDevice().setFullScreenWindow(null);
        this.onAfterExitFullScreenMode();
    }

    @Override
    public boolean isFullScreenMode() {
        return this.getScreenDevice().getFullScreenWindow() != null;
    }

    protected GraphicsDevice getScreenDevice() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    }

    protected DisplayMode getDisplayMode(DisplayMode[] displayModeArray) {
        return null;
    }

    protected void onBeforeEnterFullScreenMode() {
    }

    protected void onAfterExitFullScreenMode() {
    }
}

