/*
 * Decompiled with CFR 0.152.
 */
package ru.woesss.micro3d;

import java.awt.image.DataBufferInt;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.microedition.lcdui.Graphics;
import org.recompile.mobile.PlatformGraphics;

public class PlatformHelper {
    public static final String RESOURCE_CLASS_NAME_KE103 = "emulator.custom.b";
    public static final String RESOURCE_CLASS_NAME_KE098 = "emulator.custom.h";
    public static final String RESOURCE_CLASS_NAME_FREEJ2ME = "org.recompile.mobile.Mobile";
    public static final String RESOURCE_METHOD_NAME_KE = "a";
    public static final String RESOURCE_METHOD_NAME_FREEJ2ME = "getMIDletResourceAsStream";
    public static final int PLATFORM_FREEJ2ME = 1;
    public static final int PLATFORM_KE103 = 2;
    public static final int PLATFORM_KE098 = 3;
    private static Method getResourceMethod;
    private static int platform;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        platform = -1;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(RESOURCE_CLASS_NAME_KE103);
            platform = 2;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (clazz == null) {
            try {
                clazz = Class.forName(RESOURCE_CLASS_NAME_KE098);
                platform = 3;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (clazz == null) {
            try {
                clazz = Class.forName(RESOURCE_CLASS_NAME_FREEJ2ME);
                platform = 1;
                Class[] classArray = new Class[1];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                Method method = clazz.getDeclaredMethod(RESOURCE_METHOD_NAME_FREEJ2ME, classArray);
                method.setAccessible(true);
                getResourceMethod = method;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        } else {
            Method[] methods = clazz.getDeclaredMethods();
            int i = 0;
            while (i < methods.length) {
                Method method = methods[i];
                if (method.getName().equals(RESOURCE_METHOD_NAME_KE)) {
                    Class<?>[] parameterTypes;
                    Class<?> clazz3 = method.getReturnType();
                    Class<?> clazz4 = class$1;
                    if (clazz4 == null) {
                        try {
                            clazz4 = Class.forName("java.io.InputStream");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz3.equals(clazz4) && (parameterTypes = method.getParameterTypes()).length == 1) {
                        Class<?> clazz5 = parameterTypes[0];
                        Class<?> clazz6 = class$0;
                        if (clazz6 == null) {
                            try {
                                clazz6 = Class.forName("java.lang.String");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz5 == clazz6) {
                            method.setAccessible(true);
                            getResourceMethod = method;
                        }
                    }
                }
                ++i;
            }
        }
        if (platform == -1) {
            System.err.println("Micro3D: unknown platform - You must add support it in this class!!!");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getResourceBytes(String name) {
        if (getResourceMethod == null) {
            return null;
        }
        try {
            InputStream is = (InputStream)getResourceMethod.invoke(null, (Object[])new String[]{name});
            if (is == null) {
                return null;
            }
            byte[] b = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                while (true) {
                    int r;
                    if ((r = is.read(b)) == -1) {
                        byte[] bytes = baos.toByteArray();
                        if (bytes.length <= 0) return null;
                        byte[] byArray = bytes;
                        return byArray;
                    }
                    baos.write(b, 0, r);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static int[] getBuffer(Graphics graphics) {
        switch (platform) {
            case 1: {
                PlatformGraphics g = (PlatformGraphics)graphics;
                DataBufferInt dataBufferInt = (DataBufferInt)g.platformImage.getCanvas().getRaster().getDataBuffer();
                return dataBufferInt.getData();
            }
            case 2: 
            case 3: {
                return graphics.getImage().getData();
            }
        }
        return null;
    }

    public static int getWidth(Graphics graphics) {
        switch (platform) {
            case 1: {
                PlatformGraphics g = (PlatformGraphics)graphics;
                return g.platformImage.getWidth();
            }
            case 2: 
            case 3: {
                return graphics.getImage().getWidth();
            }
        }
        return -1;
    }

    public static int getHeight(Graphics graphics) {
        switch (platform) {
            case 1: {
                PlatformGraphics g = (PlatformGraphics)graphics;
                return g.platformImage.getHeight();
            }
            case 2: 
            case 3: {
                return graphics.getImage().getHeight();
            }
        }
        return -1;
    }

    public static void onReleased(Graphics graphics) {
        switch (platform) {
            case 1: {
                PlatformGraphics g = (PlatformGraphics)graphics;
                DataBufferInt dataBufferInt = (DataBufferInt)g.platformImage.getCanvas().getRaster().getDataBuffer();
                int[] pixels = dataBufferInt.getData();
                int i = 0;
                while (i < pixels.length) {
                    int n = i++;
                    pixels[n] = pixels[n] | 0xFF000000;
                }
                break;
            }
        }
    }
}

