/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.io;

import com.siemens.mp.NotAllowedException;
import com.siemens.mp.io.ConnectionListener;
import com.siemens.mp.misc.NativeMem;
import com.siemens.mp.misc.Security;
import com.siemens.mp.ui.Constraints;

public class Connection {
    static final int UNDEFINED = 0;
    static final int SMS = 1;
    static final int INTERNAL = 2;
    static final int SIZE_CONNECTIONQUEUE = 5;
    private int connectType = 0;
    private String dest;
    private int appId;
    private ConnectionListener listener;
    private static Object mutex = new Object();
    private static Object connectionQueue = new Object[5];

    public Connection(String connectTo) {
        boolean sms = false;
        int numberStart = 0;
        if (connectTo.startsWith("SMS://")) {
            sms = true;
            numberStart = 6;
        } else if (connectTo.startsWith("SMS:")) {
            sms = true;
            numberStart = 4;
        }
        if (sms) {
            this.connectType = 1;
            int lastColon = connectTo.lastIndexOf(58);
            if (lastColon == 3) {
                this.dest = connectTo.substring(numberStart);
                this.appId = 0;
            } else {
                this.dest = connectTo.substring(numberStart, lastColon);
                this.appId = this.parseAppId(connectTo.substring(lastColon + 1));
            }
            if (!Constraints.isPhoneNumber((String)this.dest)) {
                throw new IllegalArgumentException("Phonenumber not valid");
            }
        } else if (connectTo.startsWith("INTERNAL:")) {
            this.connectType = 2;
            this.appId = -1;
        }
    }

    public void send(byte[] data) throws NotAllowedException {
        NativeMem mem = new NativeMem();
        if (this.connectType == 1 || this.connectType == 2) {
            if (Security.ConfirmationRequest((String)this.dest, (int)2, (Object)mem)) {
                Object object = mutex;
                synchronized (object) {
                    this.send0(data, this.appId);
                }
            }
            throw new NotAllowedException("NotAllowedException");
        }
        Object object = mutex;
        synchronized (object) {
            this.send0(data, this.appId);
        }
    }

    public void setListener(ConnectionListener listener) {
        this.listener = listener;
        this.setListener0();
    }

    public ConnectionListener getListener() {
        return this.listener;
    }

    private int parseAppId(String id) {
        long appId = Long.parseLong(id);
        if (appId <= 0L || appId > 0xFFFFFFFEL) {
            throw new IllegalArgumentException("Application id out of range");
        }
        return (int)appId;
    }

    private native void send0(byte[] var1, int var2);

    private native void setListener0();
}

