/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.i;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Engine;
import javax.microedition.m3g.Helpers;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.Object3D;

public class Loader {
    int swerveHandle;
    static final int ERROR_NONE = -1;
    static final int ERROR_ABORT = -2;
    static final int ERROR_NOTFOUND = -3;
    static final int ERROR_READ = -4;
    static final int ERROR_UNABLETOCREATE = -5;
    static final int ERROR_UNABLETOFREE = -6;
    static final int ERROR_INVALIDHEADER = -7;
    static final int ERROR_INVALIDBODY = -8;
    static final int ERROR_INVALIDCHECKSUM = -9;
    static final int ERROR_UNKNOWN = -10;
    static final int ERROR_DATAPASTEOF = -11;
    static byte[] pngIdentifier;
    static int m3gIdentifierLength;
    static int BLOCK_SIZE;

    protected native void finalize();

    Loader() {
    }

    Loader(int swerveHandle) {
        this.swerveHandle = swerveHandle;
    }

    private static native int createImpl();

    native boolean getbContainsExtensions();

    native int onDataStart(boolean var1);

    native int onDataEnd();

    native int onData(byte[] var1, int var2, int var3);

    native void onError(int var1);

    native int getRootCount();

    private native int getRootImpl(int var1);

    native int getXREFName(byte[] var1);

    native void resolveXREF(Object3D var1);

    private static native int getImage2DEncoding(Image var0);

    native int getAuthoringField(byte[] var1);

    public static Object3D[] load(byte[] array, int n) throws IOException {
        if (n < 0 || n >= array.length) {
            throw new IndexOutOfBoundsException();
        }
        return Loader.loadHelper(array, n, true);
    }

    private static Object3D[] loadHelper(byte[] array, int n, boolean b) throws IOException {
        try {
            int n3;
            Loader loader = (Loader)Engine.instantiateJavaPeer(Loader.createImpl());
            int n2 = n;
            byte[] array2 = new byte[m3gIdentifierLength];
            try {
                n3 = loader.onDataStart(b);
                int n4 = array.length - n;
                if (n3 == -1 && n4 > m3gIdentifierLength) {
                    n3 = loader.onData(array, n, m3gIdentifierLength);
                    if (n3 == -1) {
                        System.arraycopy(array, n, array2, 0, m3gIdentifierLength);
                    }
                    n4 -= m3gIdentifierLength;
                    n += m3gIdentifierLength;
                }
                if (n3 == -1) {
                    n3 = loader.onData(array, n, n4);
                }
                if (n3 >= 0) {
                    loader.processXREFs(null);
                    n += n3;
                    n3 = loader.onData(array, n, n4 - n3);
                }
                if (n3 == -11) {
                    n3 = -1;
                }
                if (n3 == -1) {
                    n3 = loader.onDataEnd();
                }
            }
            catch (SecurityException ex) {
                loader.onError(-10);
                if (ex.getMessage() != null) {
                    throw new SecurityException(ex.getMessage());
                }
                throw new SecurityException();
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
                loader.onError(-10);
                if (ex2.getMessage() != null) {
                    throw new IOException(ex2.getMessage());
                }
                throw new IOException();
            }
            if (n3 == -1) {
                Object3D[] roots = loader.createRoots();
                if (roots != null) {
                    Loader.adjustUserObject(roots[0], "javax.microedition.m3g.Loader.Header", array2);
                }
                return roots;
            }
            Image2D image2D = Loader.createPNGImage2D(array, n2, array.length);
            if (image2D == null) {
                image2D = Loader.createImage2D(array, n2, array.length);
            }
            if (image2D != null) {
                return new Object3D[]{image2D};
            }
            return null;
        }
        catch (SecurityException ex4) {
            SecurityException ex3 = ex4;
            if (ex4.getMessage() != null) {
                throw new SecurityException(ex3.getMessage());
            }
            throw new SecurityException();
        }
        catch (Exception ex6) {
            ex6.printStackTrace();
            Exception ex5 = ex6;
            if (ex6.getMessage() != null) {
                throw new IOException(ex5.getMessage());
            }
            throw new IOException();
        }
    }

    public static Object3D[] load(String s) throws IOException {
        if (s == null) {
            throw new NullPointerException();
        }
        return Loader.loadHelper(s, true);
    }

    private static Object3D[] loadHelper(String s, boolean b) throws IOException {
        try (InputStream inputStream = null;){
            Image2D image2D;
            int n;
            Loader loader = (Loader)Engine.instantiateJavaPeer(Loader.createImpl());
            byte[] array = new byte[m3gIdentifierLength];
            try {
                int read2;
                int read;
                inputStream = loader.getClass().getResourceAsStream(s);
                if (inputStream == null) {
                    inputStream = Loader.openInputStream(s);
                }
                n = loader.onDataStart(b);
                byte[] array2 = new byte[BLOCK_SIZE];
                if (n == -1 && (read = inputStream.read(array2, 0, m3gIdentifierLength)) != -1 && (n = loader.onData(array2, 0, read)) == -1) {
                    System.arraycopy(array2, 0, array, 0, m3gIdentifierLength);
                }
                while (n == -1 && (read2 = inputStream.read(array2, 0, BLOCK_SIZE)) != -1) {
                    n = loader.onData(array2, 0, read2);
                    if (n < 0) continue;
                    loader.processXREFs(s);
                    n = loader.onData(array2, n, read2 - n);
                }
                if (n == -1) {
                    n = loader.onDataEnd();
                }
            }
            catch (SecurityException ex) {
                loader.onError(-10);
                if (ex.getMessage() != null) {
                    throw new SecurityException(ex.getMessage());
                }
                throw new SecurityException();
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
                loader.onError(-10);
                ex2.printStackTrace();
                if (ex2.getMessage() != null) {
                    throw new IOException(ex2.getMessage());
                }
                throw new IOException();
            }
            if (n == -1) {
                Object3D[] roots = loader.createRoots();
                if (roots != null) {
                    Loader.adjustUserObject(roots[0], "javax.microedition.m3g.Loader.Header", array);
                }
                Object3D[] object3DArray = roots;
                return object3DArray;
            }
            if (inputStream != null) {
                inputStream.close();
                inputStream = null;
            }
            if ((image2D = Loader.createPNGImage2D(s)) == null) {
                image2D = Loader.createImage2D(s);
            }
            if (image2D != null) {
                Object3D[] object3DArray = new Object3D[]{image2D};
                return object3DArray;
            }
            Object3D[] object3DArray = null;
            return object3DArray;
        }
    }

    private void processXREFs(String s) throws IOException {
        int i2;
        byte[] array = null;
        do {
            Object3D[] loadHelper;
            if ((i2 = this.getXREFName(null)) == -1) continue;
            if (array == null || array.length != i2) {
                array = new byte[i2];
            }
            this.getXREFName(array);
            String resolveURI = new String(array, "UTF-8");
            if (Loader.isRelative(resolveURI)) {
                if (s == null) {
                    throw new IOException("XREF resource [" + resolveURI + "] has relative URI.");
                }
                resolveURI = Loader.resolveURI(s, resolveURI);
            }
            if ((loadHelper = Loader.loadHelper(resolveURI, this.getbContainsExtensions())) == null) {
                throw new IOException("XREF resource [" + resolveURI + "] contained no roots.");
            }
            Loader.adjustUserObject(loadHelper[0], "javax.microedition.m3g.Loader.ExternalReference.URI", array);
            this.resolveXREF(loadHelper[0]);
        } while (i2 != -1);
    }

    private static boolean isRelative(String s) {
        char char1;
        int length = s.length();
        if (length == 0 || s.startsWith("//")) {
            return true;
        }
        if (s.startsWith("/")) {
            return false;
        }
        int n = 0;
        while ((char1 = s.charAt(n)) != ':' && char1 != '/' && char1 != '?' && char1 != '#' && ++n != length) {
        }
        return char1 != ':';
    }

    private static String resolveURI(String s, String s2) {
        int length;
        for (length = s.length(); length > 0 && s.charAt(length - 1) != '/'; --length) {
        }
        if (length > 0) {
            return s.substring(0, length) + s2;
        }
        return '/' + s2;
    }

    private Object3D[] createRoots() {
        int rootCount = this.getRootCount();
        if (rootCount == 0) {
            return null;
        }
        Object3D[] array = new Object3D[rootCount];
        while (rootCount-- > 0) {
            array[rootCount] = (Object3D)Engine.instantiateJavaPeer(this.getRootImpl(rootCount));
        }
        byte[] array2 = new byte[this.getAuthoringField(null)];
        this.getAuthoringField(array2);
        Loader.adjustUserObject(array[0], "javax.microedition.m3g.Loader.HeaderObject.AuthoringField", array2);
        return array;
    }

    static void adjustUserObject(Object3D object3D, String s, Object o) {
        Hashtable userObject = object3D.getUserObject();
        if (userObject == null) {
            userObject = new Hashtable();
            object3D.setUserObject(userObject);
        }
        ((Hashtable)userObject).put(s, o);
    }

    static InputStream openInputStream(String s) throws IOException {
        return Helpers.openInputStream(s);
    }

    private static boolean hasPNGIdentifier(byte[] array, int n, int n2) {
        if (pngIdentifier.length > n2) {
            return false;
        }
        for (int i2 = 0; i2 < pngIdentifier.length; ++i2) {
            if (pngIdentifier[i2] == array[n + i2]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Image2D createPNGImage2D(String s) throws IOException {
        try (InputStream inputStream = null;){
            int read2;
            byte[] array;
            int read;
            inputStream = Loader.class.getResourceAsStream(s);
            if (inputStream == null) {
                inputStream = Loader.openInputStream(s);
            }
            if ((read = inputStream.read(array = new byte[BLOCK_SIZE], 0, pngIdentifier.length)) != -1 && !Loader.hasPNGIdentifier(array, 0, read)) {
                Image2D image2D = null;
                return image2D;
            }
            byte[] array2 = new byte[read];
            System.arraycopy(array, 0, array2, 0, read);
            while ((read2 = inputStream.read(array, 0, BLOCK_SIZE)) != -1) {
                byte[] array3 = new byte[array2.length + read2];
                System.arraycopy(array2, 0, array3, 0, array2.length);
                System.arraycopy(array, 0, array3, array2.length, read2);
                array2 = array3;
            }
            Image2D image2D = new Image2D(array2, 0, array2.length);
            return image2D;
        }
    }

    static Image2D createPNGImage2D(byte[] array, int n, int n2) {
        if (!Loader.hasPNGIdentifier(array, n, n2)) {
            return null;
        }
        return new Image2D(array, n, n2);
    }

    static Image2D createImage2D(String s) throws IOException {
        Image image = Helpers.createImage(s);
        if (image != null) {
            return Loader.createImage2D(image);
        }
        return null;
    }

    static Image2D createImage2D(byte[] array, int n, int n2) throws IOException {
        Image image = Helpers.createImage(array, n, n2);
        if (image != null) {
            return Loader.createImage2D(image);
        }
        return null;
    }

    static Image2D createImage2D(Image image) {
        return new Image2D(Loader.getImage2DEncoding(image), image);
    }

    static {
        i.a((String)"jsr184client");
        Engine.cacheFID(Loader.class, 2);
        pngIdentifier = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        m3gIdentifierLength = 12;
        BLOCK_SIZE = 4096;
    }
}

