/*
 * Decompiled with CFR 0.152.
 */
package org.openintents.tools.sensorsimulator;

import java.io.File;
import java.util.Scanner;

public class WiiMoteData {
    private String dataFilePath;
    private String status;
    private int roll;
    private int pitch;
    private double x;
    private double y;
    private double z;

    public void setDataFilePath(String newPath) {
        this.dataFilePath = newPath;
    }

    private boolean inCutOff(double value) {
        return -0.05 <= value && value <= 0.05;
    }

    public boolean updateData() {
        try {
            double xzResultant;
            File f = new File(this.dataFilePath);
            if (!f.canRead()) {
                this.status = "Can't read file";
                return false;
            }
            Scanner scanner = new Scanner(f).useDelimiter(",|$");
            this.x = scanner.nextDouble();
            this.y = scanner.nextDouble();
            this.z = scanner.nextDouble();
            scanner.close();
            this.status = "x: " + this.x + ", y: " + this.y + ", z: " + this.z;
            int newRoll = this.roll;
            int newPitch = this.pitch;
            double yzResultant = Math.sqrt(this.y * this.y + this.z * this.z);
            if (!this.inCutOff(yzResultant)) {
                newRoll = (int)(180.0 * Math.atan(this.x / yzResultant) / Math.PI);
            }
            if (!this.inCutOff(xzResultant = Math.sqrt(this.x * this.x + this.z * this.z))) {
                newPitch = (int)(-180.0 * Math.atan(this.y / xzResultant) / Math.PI);
            }
            if (this.z < 0.0) {
                newPitch = this.y < 0.0 ? 180 - newPitch : -180 - newPitch;
                newRoll = -newRoll;
            }
            this.roll = newRoll;
            this.pitch = newPitch;
            return true;
        }
        catch (Exception ex) {
            this.status = "Exception: " + ex.getMessage();
            ex.printStackTrace();
            return false;
        }
    }

    public String getStatus() {
        return this.status;
    }

    public int getRoll() {
        return this.roll;
    }

    public int getPitch() {
        return this.pitch;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }
}

