/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics3D.Quaternion;
import javax.microedition.m3g.Object3D;

public class KeyframeSequence
extends Object3D {
    public static final int CONSTANT = 192;
    public static final int LOOP = 193;
    public static final int LINEAR = 176;
    public static final int SLERP = 177;
    public static final int SPLINE = 178;
    public static final int SQUAD = 179;
    public static final int STEP = 180;
    private int keyframeCount;
    private int componentCount;
    private int interpolationType;
    private float[][] aFloatArrayArray144;
    private int[] keyframes;
    private int validRangeFirst;
    private int validRangeLast;
    private int duration;
    private int repeatMode;
    private boolean dirty;
    private float[][] inTangent;
    private float[][] outTangent;
    private Quaternion[] a;
    private Quaternion[] b;

    @Override
    protected Object3D duplicateObject() {
        KeyframeSequence var1;
        block4: {
            block3: {
                int var2;
                var1 = (KeyframeSequence)super.duplicateObject();
                ((KeyframeSequence)super.duplicateObject()).keyframes = (int[])this.keyframes.clone();
                var1.aFloatArrayArray144 = new float[this.keyframeCount][this.componentCount];
                if (this.interpolationType != 179) break block3;
                for (var2 = 0; var2 < this.a.length; ++var2) {
                    var1.a[var2] = new Quaternion(this.a[var2]);
                    var1.b[var2] = new Quaternion(this.b[var2]);
                }
                for (var2 = 0; var2 < this.keyframeCount; ++var2) {
                    var1.aFloatArrayArray144[var2] = (float[])this.aFloatArrayArray144[var2].clone();
                }
                break block4;
            }
            if (this.interpolationType != 178) break block4;
            var1.inTangent = new float[this.keyframeCount][this.componentCount];
            var1.outTangent = new float[this.keyframeCount][this.componentCount];
            for (int var2 = 0; var2 < this.keyframeCount; ++var2) {
                var1.inTangent[var2] = (float[])this.inTangent[var2].clone();
                var1.outTangent[var2] = (float[])this.outTangent[var2].clone();
                var1.aFloatArrayArray144[var2] = (float[])this.aFloatArrayArray144[var2].clone();
            }
        }
        return var1;
    }

    public KeyframeSequence(int numKeyframes, int numComponents, int interpolation) {
        if (numKeyframes >= 1 && numComponents >= 1 && KeyframeSequence.checkInterpolation(interpolation)) {
            if ((interpolation == 177 || interpolation == 179) && numComponents != 4) {
                throw new IllegalArgumentException();
            }
            this.keyframeCount = numKeyframes;
            this.componentCount = numComponents;
            this.interpolationType = interpolation;
            this.aFloatArrayArray144 = new float[numKeyframes][numComponents];
            this.keyframes = new int[numKeyframes];
            this.repeatMode = 192;
            this.validRangeFirst = 0;
            this.validRangeLast = this.keyframeCount - 1;
            this.duration = 0;
            this.dirty = false;
            if (this.interpolationType == 178) {
                this.inTangent = new float[numKeyframes][numComponents];
                this.outTangent = new float[numKeyframes][numComponents];
            } else if (this.interpolationType == 179) {
                this.a = new Quaternion[numKeyframes];
                this.b = new Quaternion[numKeyframes];
                for (int var4 = 0; var4 < numKeyframes; ++var4) {
                    this.a[var4] = new Quaternion();
                    this.b[var4] = new Quaternion();
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    private static boolean checkInterpolation(int var0) {
        return var0 >= 176 && var0 <= 180;
    }

    public int getComponentCount() {
        return this.componentCount;
    }

    public int getKeyframeCount() {
        return this.keyframeCount;
    }

    public int getInterpolationType() {
        return this.interpolationType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setKeyframe(int var1, int var2, float[] var3) {
        if (var3 == null) {
            throw new NullPointerException();
        }
        if (var1 < 0 || var1 >= this.keyframeCount) throw new IndexOutOfBoundsException();
        if (var2 < 0 || var3.length < this.componentCount) throw new IllegalArgumentException();
        this.keyframes[var1] = var2;
        float[] var4 = this.aFloatArrayArray144[var1];
        if (this.interpolationType != 177 && this.interpolationType != 179) {
            System.arraycopy(var3, 0, var4, 0, var4.length);
        } else {
            Quaternion var5 = new Quaternion(var3[0], var3[1], var3[2], var3[3]);
            var5.normalize();
            var4[0] = var5.x;
            var4[1] = var5.y;
            var4[2] = var5.z;
            var4[3] = var5.w;
        }
        this.dirty = false;
    }

    public int getKeyframe(int var1, float[] var2) {
        if (var1 >= 0 && var1 < this.keyframeCount) {
            if (var2 != null && var2.length < this.componentCount) {
                throw new IllegalArgumentException();
            }
            if (var2 != null) {
                System.arraycopy(this.aFloatArrayArray144[var1], 0, var2, 0, this.componentCount);
            }
            return this.keyframes[var1];
        }
        throw new IndexOutOfBoundsException();
    }

    public void setValidRange(int var1, int var2) {
        if (var1 < 0 || var1 >= this.keyframeCount || var2 < 0 || var2 >= this.keyframeCount) {
            throw new IndexOutOfBoundsException();
        }
        this.validRangeFirst = var1;
        this.validRangeLast = var2;
        this.dirty = false;
    }

    public int getValidRangeFirst() {
        return this.validRangeFirst;
    }

    public int getValidRangeLast() {
        return this.validRangeLast;
    }

    public void setDuration(int var1) {
        this.duration = var1;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setRepeatMode(int var1) {
        if (var1 != 192 && var1 != 193) {
            throw new IllegalArgumentException();
        }
        this.repeatMode = var1;
        if (this.dirty) {
            this.updateTangents();
        }
    }

    public int getRepeatMode() {
        return this.repeatMode;
    }

    protected int getSampleFrame(float var1, float[] var2) {
        if (!this.dirty) {
            this.validate();
        }
        if (this.repeatMode == 193) {
            float f = var1 = var1 < 0.0f ? var1 % (float)this.duration + (float)this.duration : var1 % (float)this.duration;
            if (f < (float)this.keyframes[this.validRangeFirst]) {
                var1 += (float)this.duration;
            }
        } else {
            if (var1 < (float)this.keyframes[this.validRangeFirst]) {
                float f;
                float[] var6 = this.aFloatArrayArray144[this.validRangeFirst];
                System.arraycopy(var6, 0, var2, 0, var6.length);
                float var4 = (float)this.keyframes[this.validRangeFirst] - var1;
                if (f <= 2.1474836E9f) {
                    return (int)var4;
                }
                return Integer.MAX_VALUE;
            }
            if (var1 >= (float)this.keyframes[this.validRangeLast]) {
                float[] var6 = this.aFloatArrayArray144[this.validRangeLast];
                System.arraycopy(var6, 0, var2, 0, var6.length);
                return Integer.MAX_VALUE;
            }
        }
        int var10000 = this.validRangeFirst;
        while (true) {
            int var3 = var10000;
            if (var10000 == this.validRangeLast || (float)this.keyframes[this.keyframeAfter(var3)] > var1) {
                if (var1 - (float)this.keyframes[var3] >= 1.0E-5f && this.interpolationType != 180) {
                    float var4 = (var1 - (float)this.keyframes[var3]) / (float)this.timeDelta(var3);
                    int var5 = this.keyframeAfter(var3);
                    switch (this.interpolationType) {
                        case 176: {
                            this.linearInterp(var2, var4, var3, var5);
                            break;
                        }
                        case 177: {
                            this.slerpInterp(var2, var4, var3, var5);
                            break;
                        }
                        case 178: {
                            this.splineInterp(var2, var4, var3, var5);
                            break;
                        }
                        case 179: {
                            this.squadInterp(var2, var4, var3, var5);
                            break;
                        }
                        default: {
                            throw new Error("Invalid type for interpolation!");
                        }
                    }
                    return 1;
                }
                System.arraycopy(this.aFloatArrayArray144[var3], 0, var2, 0, this.componentCount);
                return this.interpolationType != 180 ? 1 : (int)((float)this.timeDelta(var3) - (var1 - (float)this.keyframes[var3]));
            }
            var10000 = this.keyframeAfter(var3);
        }
    }

    private void validate() {
        if (this.duration <= 0) {
            throw new IllegalStateException();
        }
        int var10000 = this.validRangeFirst;
        while (true) {
            int var2;
            int var1 = var10000;
            if (var10000 == this.validRangeLast) {
                this.dirty = true;
                this.updateTangents();
                return;
            }
            int n = var2 = var1 >= this.keyframes.length - 1 ? 0 : var1 + 1;
            if (this.keyframes[var2] < this.keyframes[var1] || this.keyframes[var2] > this.duration) {
                throw new IllegalStateException();
            }
            var10000 = var2;
        }
    }

    private final void linearInterp(float[] out, float weight, int var3, int var4) {
        float[] frameA = this.aFloatArrayArray144[var3];
        float[] frameB = this.aFloatArrayArray144[var4];
        for (int i = 0; i < out.length; ++i) {
            out[i] = frameA[i] + weight * (frameB[i] - frameA[i]);
        }
    }

    private final void splineInterp(float[] out, float weight, int var3, int var4) {
        float[] frameA = this.aFloatArrayArray144[var3];
        float[] frameB = this.aFloatArrayArray144[var4];
        for (int i = 0; i < out.length; ++i) {
            float a = this.outTangent[var3][i];
            float b = this.inTangent[var4][i];
            out[i] = KeyframeSequence.spline(weight, frameA[i], frameB[i], a, b);
        }
    }

    private static float spline(float weight, float a, float b, float var3, float var4) {
        float weight2 = weight * weight;
        float weight3 = weight2 * weight;
        return (2.0f * weight3 - 3.0f * weight2 + 1.0f) * a + (-2.0f * weight3 + 3.0f * weight2) * b + (weight3 - 2.0f * weight2 + weight) * var3 + (weight3 - weight2) * var4;
    }

    private final void precalculateTangents() {
        int var1 = this.validRangeFirst;
        do {
            float[] var2 = this.aFloatArrayArray144[this.keyframeBefore(var1)];
            float[] var3 = this.aFloatArrayArray144[this.keyframeAfter(var1)];
            float var4 = this.incomingTangentScale(var1);
            float var5 = this.outgoingTangentScale(var1);
            for (int var6 = 0; var6 < this.componentCount; ++var6) {
                this.inTangent[var1][var6] = 0.5f * (var3[var6] - var2[var6]) * var4;
                this.outTangent[var1][var6] = 0.5f * (var3[var6] - var2[var6]) * var5;
            }
        } while ((var1 = this.keyframeAfter(var1)) != this.validRangeFirst);
    }

    private final void slerpInterp(float[] var1, float var2, int var3, int var4) {
        if (var1.length != 4) {
            throw new Error("Invalid keyframe type");
        }
        Quaternion var5 = new Quaternion(this.aFloatArrayArray144[var3]);
        Quaternion var6 = new Quaternion(this.aFloatArrayArray144[var4]);
        Quaternion var7 = new Quaternion();
        var7.slerp(var2, var5, var6);
        var1[0] = var7.x;
        var1[1] = var7.y;
        var1[2] = var7.z;
        var1[3] = var7.w;
    }

    private final void squadInterp(float[] var1, float var2, int var3, int var4) {
        if (var1.length != 4) {
            throw new Error("Invalid keyframe type");
        }
        Quaternion var5 = new Quaternion(this.aFloatArrayArray144[var3]);
        Quaternion var6 = new Quaternion(this.aFloatArrayArray144[var4]);
        Quaternion var7 = new Quaternion();
        var7.squad(var2, var5, this.a[var3], this.b[var4], var6);
        var1[0] = var7.x;
        var1[1] = var7.y;
        var1[2] = var7.z;
        var1[3] = var7.w;
    }

    private final void precalculateAB() {
        Quaternion var1 = new Quaternion();
        Quaternion var2 = new Quaternion();
        Quaternion var3 = new Quaternion();
        Quaternion var4 = new Quaternion();
        Quaternion var5 = new Quaternion();
        Quaternion var6 = new Quaternion();
        Quaternion var7 = new Quaternion();
        int var8 = this.validRangeFirst;
        do {
            var3.set(this.aFloatArrayArray144[this.keyframeBefore(var8)]);
            var1.set(this.aFloatArrayArray144[var8]);
            var2.set(this.aFloatArrayArray144[this.keyframeAfter(var8)]);
            var4.set(this.aFloatArrayArray144[this.keyframeAfter(this.keyframeAfter(var8))]);
            var7.logDiff(var1, var2);
            var6.logDiff(var3, var1);
            var7.add(var6);
            var7.mul(0.5f);
            var5.set(var7);
            var5.mul(this.outgoingTangentScale(var8));
            var6.logDiff(var1, var2);
            var5.sub(var6);
            var5.mul(0.5f);
            var6.exp(var5);
            this.a[var8].set(var1);
            this.a[var8].mul(var6);
            var5.set(var7);
            var5.mul(this.incomingTangentScale(var8));
            var6.logDiff(var3, var1);
            var6.sub(var5);
            var6.mul(0.5f);
            var6.exp(var6);
            this.b[var8].set(var1);
            this.b[var8].mul(var6);
        } while ((var8 = this.keyframeAfter(var8)) != this.validRangeFirst);
    }

    private float incomingTangentScale(int var1) {
        if (this.repeatMode != 192 || var1 != this.validRangeFirst && var1 != this.validRangeLast) {
            int var2 = this.keyframeBefore(var1);
            return 2.0f * (float)this.timeDelta(var2) / (float)(this.timeDelta(var1) + this.timeDelta(var2));
        }
        return 0.0f;
    }

    private float outgoingTangentScale(int var1) {
        if (this.repeatMode != 192 || var1 != this.validRangeFirst && var1 != this.validRangeLast) {
            int var2 = this.keyframeBefore(var1);
            return 2.0f * (float)this.timeDelta(var1) / (float)(this.timeDelta(var2) + this.timeDelta(var1));
        }
        return 0.0f;
    }

    private void updateTangents() {
        if (!this.dirty) {
            throw new Error();
        }
        if (this.interpolationType == 178) {
            this.precalculateTangents();
        } else if (this.interpolationType == 179) {
            this.precalculateAB();
        }
    }

    private int keyframeAfter(int var1) {
        return var1 == this.validRangeLast ? this.validRangeFirst : (var1 == this.keyframes.length - 1 ? 0 : var1 + 1);
    }

    private int keyframeBefore(int var1) {
        return var1 == this.validRangeFirst ? this.validRangeLast : (var1 == 0 ? this.keyframes.length - 1 : var1 - 1);
    }

    private int timeDelta(int var1) {
        return var1 == this.validRangeLast ? this.duration - this.keyframes[this.validRangeLast] + this.keyframes[this.validRangeFirst] : this.keyframes[this.keyframeAfter(var1)] - this.keyframes[var1];
    }
}

