/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Object3D;

public class TriangleStripArray
extends IndexBuffer {
    private int[] stripLengths;
    private IntBuffer buffer;

    public TriangleStripArray(int firstIndex, int[] stripLengths) {
        int i;
        if (stripLengths == null) {
            throw new NullPointerException();
        }
        if (stripLengths.length == 0) {
            throw new IllegalArgumentException();
        }
        int sumStripLengths = 0;
        for (i = stripLengths.length - 1; i >= 0; --i) {
            if (stripLengths[i] < 3) {
                throw new IllegalArgumentException();
            }
            sumStripLengths += stripLengths[i];
        }
        if (firstIndex + sumStripLengths > 65535) {
            throw new IllegalArgumentException();
        }
        this.indices = new int[sumStripLengths];
        for (i = 0; i < sumStripLengths; ++i) {
            this.indices[i] = firstIndex + i;
        }
        this.stripLengths = new int[stripLengths.length];
        System.arraycopy(stripLengths, 0, this.stripLengths, 0, stripLengths.length);
        this.copyToNative();
    }

    public TriangleStripArray(int[] indices, int[] stripLengths) {
        int i;
        if (indices == null || stripLengths == null) {
            throw new NullPointerException();
        }
        if (stripLengths.length == 0) {
            throw new IllegalArgumentException();
        }
        int sumStripLengths = 0;
        for (i = stripLengths.length - 1; i >= 0; --i) {
            if (stripLengths[i] < 3) {
                throw new IllegalArgumentException();
            }
            sumStripLengths += stripLengths[i];
        }
        if (indices.length < sumStripLengths) {
            throw new IllegalArgumentException();
        }
        for (i = sumStripLengths - 1; i >= 0; --i) {
            if (indices[i] >= 0 && indices[i] <= 65535) continue;
            throw new IllegalArgumentException();
        }
        this.indices = new int[sumStripLengths];
        System.arraycopy(indices, 0, this.indices, 0, sumStripLengths);
        this.stripLengths = new int[stripLengths.length];
        System.arraycopy(stripLengths, 0, this.stripLengths, 0, stripLengths.length);
        this.copyToNative();
    }

    @Override
    protected Object3D duplicateObject() {
        TriangleStripArray clone = (TriangleStripArray)super.duplicateObject();
        clone.indices = (int[])this.indices.clone();
        clone.stripLengths = (int[])this.stripLengths.clone();
        return clone;
    }

    public int getStripCount() {
        return this.stripLengths.length;
    }

    public int[] getIndexStrip(int index) {
        if (index >= 0 && index < this.stripLengths.length) {
            int sumStripLengths = 0;
            for (int i = 0; i < index; ++i) {
                sumStripLengths += this.stripLengths[i];
            }
            int[] resIndexStrip = new int[this.stripLengths[index]];
            if (this.stripLengths != null) {
                System.arraycopy(this.indices, sumStripLengths, resIndexStrip, 0, this.stripLengths[index]);
            }
            return resIndexStrip;
        }
        return null;
    }

    public IntBuffer getBuffer() {
        this.buffer.position(0);
        return this.buffer;
    }

    protected boolean getIndices(int index, int[] indices) {
        int index2 = 0;
        for (int i = 0; i < this.stripLengths.length; ++i) {
            if (index < this.stripLengths[i] - 2) {
                indices[0] = this.indices[index2 + index + 0];
                indices[1] = this.indices[index2 + index + 1];
                indices[2] = this.indices[index2 + index + 2];
                indices[3] = index & 1;
                return true;
            }
            index -= this.stripLengths[i] - 2;
            index2 += this.stripLengths[i];
        }
        return false;
    }

    private void copyToNative() {
        int strip;
        int joinedIndexCount = 0;
        int stripCount = this.stripLengths.length;
        for (strip = 0; strip < stripCount; ++strip) {
            if (strip != 0) {
                joinedIndexCount += (joinedIndexCount & 1) != 0 ? 3 : 2;
            }
            joinedIndexCount += this.stripLengths[strip];
        }
        this.allocateBuffer(joinedIndexCount);
        int src = 0;
        for (strip = 0; strip < stripCount; ++strip) {
            if (strip != 0) {
                this.buffer.put(this.indices[src - 1]);
                this.buffer.put(this.indices[src]);
                if ((this.stripLengths[strip - 1] & 1) != 0) {
                    this.buffer.put(this.indices[src]);
                }
            }
            for (int i = 0; i < this.stripLengths[strip]; ++i) {
                this.buffer.put(this.indices[src++]);
            }
        }
    }

    private IntBuffer allocateBuffer(int size) {
        this.buffer = ByteBuffer.allocateDirect(size << 2).order(ByteOrder.nativeOrder()).asIntBuffer();
        this.buffer.position(0);
        return this.buffer;
    }

    public int profilerCount() {
        return this.indices.length - this.stripLengths.length * 2;
    }
}

