/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.iden.micro3d;

import com.motorola.iden.micro3d.Line;
import com.motorola.iden.micro3d.Point;
import com.motorola.iden.micro3d.PointSprite;
import com.motorola.iden.micro3d.Primitive;
import com.motorola.iden.micro3d.Quadrangle;
import com.motorola.iden.micro3d.RenderProxy;
import com.motorola.iden.micro3d.RenderProxy$RenderNode;
import com.motorola.iden.micro3d.Texture;
import com.motorola.iden.micro3d.Triangle;
import com.motorola.iden.micro3d.Vector3D;
import ru.woesss.j2me.micro3d.Render;

class RenderProxy$PrimitiveNode
extends RenderProxy$RenderNode {
    int command = 0;
    int[] data;
    int normOffset = 0;
    int texOffset = 0;
    int colorOffset = 0;

    RenderProxy$PrimitiveNode(Primitive primitive, int n2, int n3) {
        super(primitive, n2, n3);
        if (primitive instanceof Point) {
            Point point = (Point)primitive;
            this.command = 0x1010000;
            this.command |= 0x400;
            this.command |= point.blendingType - 200 << 5;
            this.command |= 3;
            Vector3D vector3D = point.vertices[0];
            this.data = new int[]{vector3D.x, vector3D.y, vector3D.z, point.color};
            this.colorOffset = 3;
        } else if (primitive instanceof Line) {
            Line line = (Line)primitive;
            this.command = 0x2010000;
            this.command |= 0x400;
            this.command |= line.blendingType - 200 << 5;
            this.command |= 3;
            Vector3D vector3D = line.vertices[0];
            Vector3D vector3D2 = line.vertices[1];
            this.data = new int[]{vector3D.x, vector3D.y, vector3D.z, vector3D2.x, vector3D2.y, vector3D2.z, line.color};
            this.colorOffset = 6;
        } else if (primitive instanceof Triangle) {
            Triangle triangle = (Triangle)primitive;
            int n4 = 9;
            this.command = 0x3010000;
            this.command |= 2;
            Vector3D[] vector3DArray = triangle.normals;
            if (triangle.hasFaceNormal) {
                this.command |= 0x201;
                n4 += 3;
            } else if (RenderProxy.checkNormals(vector3DArray)) {
                this.command |= 0x301;
                n4 += 9;
            }
            Texture texture = RenderProxy.getTexture(triangle);
            if (texture != null) {
                this.texture = texture.impl;
                this.command |= 0x3000;
                n4 += 6;
            } else {
                this.command |= 0x400;
                ++n4;
            }
            this.command |= triangle.blendingType - 200 << 5;
            if (triangle.isColorKey) {
                this.command |= 0x10;
            }
            this.data = new int[n4];
            Vector3D[] vector3DArray2 = triangle.vertices;
            this.texOffset = this.normOffset = RenderProxy$PrimitiveNode.addVertices(this.data, 0, vector3DArray2, 3);
            if ((this.command & 0x200) != 0) {
                this.texOffset = RenderProxy$PrimitiveNode.addVertices(this.data, this.normOffset, vector3DArray, 1);
            } else if ((this.command & 0x300) != 0) {
                this.texOffset = RenderProxy$PrimitiveNode.addVertices(this.data, this.normOffset, vector3DArray, 3);
            }
            this.colorOffset = this.texOffset;
            if ((this.command & 0x3000) != 0) {
                System.arraycopy(triangle.textureCoords, 0, this.data, this.texOffset, 6);
                this.colorOffset += 6;
            }
        } else if (primitive instanceof Quadrangle) {
            Quadrangle quadrangle = (Quadrangle)primitive;
            int n5 = 12;
            this.command = 0x4010000;
            this.command |= 2;
            Vector3D[] vector3DArray = quadrangle.normals;
            if (quadrangle.hasFaceNormal) {
                this.command |= 0x201;
                n5 += 3;
            } else if (RenderProxy.checkNormals(vector3DArray)) {
                this.command |= 0x301;
                n5 += 12;
            }
            Texture texture = RenderProxy.getTexture(quadrangle);
            if (texture != null) {
                this.texture = texture.impl;
                this.command |= 0x3000;
                n5 += 8;
            } else {
                this.command |= 0x400;
                ++n5;
            }
            this.command |= quadrangle.blendingType - 200 << 5;
            if (quadrangle.isColorKey) {
                this.command |= 0x10;
            }
            this.data = new int[n5];
            Vector3D[] vector3DArray3 = quadrangle.vertices;
            this.texOffset = this.normOffset = RenderProxy$PrimitiveNode.addVertices(this.data, 0, vector3DArray3, 4);
            if ((this.command & 0x200) != 0) {
                this.texOffset = RenderProxy$PrimitiveNode.addVertices(this.data, this.normOffset, vector3DArray, 1);
            } else if ((this.command & 0x300) != 0) {
                this.texOffset = RenderProxy$PrimitiveNode.addVertices(this.data, this.normOffset, vector3DArray, 4);
            }
            this.colorOffset = this.texOffset;
            if ((this.command & 0x3000) != 0) {
                System.arraycopy(quadrangle.textureCoords, 0, this.data, this.texOffset, 8);
                this.colorOffset += 8;
            }
        } else if (primitive instanceof PointSprite) {
            PointSprite pointSprite = (PointSprite)primitive;
            Texture texture = RenderProxy.getTexture(pointSprite);
            if (texture == null) {
                return;
            }
            this.command = 83963904;
            if (pointSprite.isColorKey) {
                this.command |= 0x10;
            }
            this.data = new int[11];
            Vector3D vector3D = pointSprite.vertices[0];
            this.data[0] = vector3D.x;
            this.data[1] = vector3D.y;
            this.data[2] = vector3D.z;
            System.arraycopy(pointSprite.params, 0, this.data, 3, 8);
            this.texOffset = 3;
        }
    }

    @Override
    void push(Render render) {
        render.postPrimitives(this.command, this.data, 0, this.data, this.normOffset, this.data, this.texOffset, this.data, this.colorOffset);
    }

    private static int addVertices(int[] nArray, int n2, Vector3D[] vector3DArray, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            Vector3D vector3D = vector3DArray[i2];
            nArray[n2++] = vector3D.x;
            nArray[n2++] = vector3D.y;
            nArray[n2++] = vector3D.z;
        }
        return n2;
    }
}

