/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.color_game;

import com.siemens.mp.color_game.Layer;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Sprite
extends Layer {
    private static final int INVERTED_AXES = 4;
    private static final int X_FLIP = 2;
    private static final int Y_FLIP = 1;
    private static final int ALPHA_BITMASK = -16777216;
    private static final int FULLY_OPAQUE_ALPHA = -16777216;
    Image sourceImage;
    int numberFrames;
    int[] frameCoordsX;
    int[] frameCoordsY;
    int srcFrameWidth;
    int srcFrameHeight;
    int[] frameSequence;
    private int sequenceIndex;
    private boolean customSequenceDefined;
    int collisionRectX;
    int collisionRectY;
    int collisionRectWidth;
    int collisionRectHeight;

    public Sprite(Image image) {
        super(image.getWidth(), image.getHeight());
        this.initializeFrames(image, image.getWidth(), image.getHeight(), false);
        this.initCollisionRectBounds();
    }

    public Sprite(Image image, int n2, int n3) {
        super(n2, n3);
        if (n2 < 1 || n3 < 1 || image.getWidth() % n2 != 0 || image.getHeight() % n3 != 0) {
            throw new IllegalArgumentException();
        }
        this.initializeFrames(image, n2, n3, false);
        this.initCollisionRectBounds();
    }

    public Sprite(Sprite sprite) {
        super(sprite != null ? sprite.getWidth() : 0, sprite != null ? sprite.getHeight() : 0);
        if (sprite == null) {
            throw new NullPointerException();
        }
        this.sourceImage = Image.createImage(sprite.sourceImage);
        this.numberFrames = sprite.numberFrames;
        this.frameCoordsX = new int[this.numberFrames];
        this.frameCoordsY = new int[this.numberFrames];
        System.arraycopy(sprite.frameCoordsX, 0, this.frameCoordsX, 0, sprite.getRawFrameCount());
        System.arraycopy(sprite.frameCoordsY, 0, this.frameCoordsY, 0, sprite.getRawFrameCount());
        this.x = sprite.getX();
        this.y = sprite.getY();
        this.collisionRectX = sprite.collisionRectX;
        this.collisionRectY = sprite.collisionRectY;
        this.collisionRectWidth = sprite.collisionRectWidth;
        this.collisionRectHeight = sprite.collisionRectHeight;
        this.srcFrameWidth = sprite.srcFrameWidth;
        this.srcFrameHeight = sprite.srcFrameHeight;
        this.setVisible(sprite.isVisible());
        this.frameSequence = new int[sprite.getFrameSequenceLength()];
        this.setFrameSequence(sprite.frameSequence);
        this.setFrame(sprite.getFrame());
    }

    public void setFrame(int n2) {
        if (n2 < 0 || n2 >= this.frameSequence.length) {
            throw new IndexOutOfBoundsException();
        }
        this.sequenceIndex = n2;
    }

    public final int getFrame() {
        return this.sequenceIndex;
    }

    public int getRawFrameCount() {
        return this.numberFrames;
    }

    public int getFrameSequenceLength() {
        return this.frameSequence.length;
    }

    public void nextFrame() {
        this.sequenceIndex = (this.sequenceIndex + 1) % this.frameSequence.length;
    }

    public void prevFrame() {
        this.sequenceIndex = this.sequenceIndex == 0 ? this.frameSequence.length - 1 : --this.sequenceIndex;
    }

    @Override
    public final void paint(Graphics graphics) {
        if (graphics == null) {
            throw new NullPointerException();
        }
        if (this.visible) {
            graphics.drawRegion(this.sourceImage, this.frameCoordsX[this.frameSequence[this.sequenceIndex]], this.frameCoordsY[this.frameSequence[this.sequenceIndex]], this.srcFrameWidth, this.srcFrameHeight, 0, this.x, this.y, 20);
        }
    }

    public void setFrameSequence(int[] nArray) {
        if (nArray == null) {
            this.sequenceIndex = 0;
            this.customSequenceDefined = false;
            this.frameSequence = new int[this.numberFrames];
            for (int i2 = 0; i2 < this.numberFrames; ++i2) {
                this.frameSequence[i2] = i2;
            }
            return;
        }
        if (nArray.length < 1) {
            throw new IllegalArgumentException();
        }
        for (int n2 : nArray) {
            if (n2 >= 0 && n2 < this.numberFrames) continue;
            throw new ArrayIndexOutOfBoundsException();
        }
        this.customSequenceDefined = true;
        this.frameSequence = new int[nArray.length];
        System.arraycopy(nArray, 0, this.frameSequence, 0, nArray.length);
        this.sequenceIndex = 0;
    }

    public void setImage(Image image, int n2, int n3) {
        if (n2 < 1 || n3 < 1 || image.getWidth() % n2 != 0 || image.getHeight() % n3 != 0) {
            throw new IllegalArgumentException();
        }
        int n4 = image.getWidth() / n2 * (image.getHeight() / n3);
        boolean bl2 = true;
        if (n4 < this.numberFrames) {
            bl2 = false;
            this.customSequenceDefined = false;
        }
        if (this.srcFrameWidth != n2 || this.srcFrameHeight != n3) {
            this.setWidth(n2);
            this.setHeight(n3);
            this.initializeFrames(image, n2, n3, bl2);
            this.initCollisionRectBounds();
        } else {
            this.initializeFrames(image, n2, n3, bl2);
        }
    }

    public final boolean collidesWith(Sprite sprite, boolean bl2) {
        if (!sprite.visible || !this.visible) {
            return false;
        }
        int n2 = sprite.x + sprite.collisionRectX;
        int n3 = sprite.y + sprite.collisionRectY;
        int n4 = n2 + sprite.collisionRectWidth;
        int n5 = n3 + sprite.collisionRectHeight;
        int n6 = this.x + this.collisionRectX;
        int n7 = this.y + this.collisionRectY;
        int n8 = n6 + this.collisionRectWidth;
        int n9 = n7 + this.collisionRectHeight;
        if (this.intersectRect(n2, n3, n4, n5, n6, n7, n8, n9)) {
            if (bl2) {
                if (this.collisionRectX < 0) {
                    n6 = this.x;
                }
                if (this.collisionRectY < 0) {
                    n7 = this.y;
                }
                if (this.collisionRectX + this.collisionRectWidth > this.width) {
                    n8 = this.x + this.width;
                }
                if (this.collisionRectY + this.collisionRectHeight > this.height) {
                    n9 = this.y + this.height;
                }
                if (sprite.collisionRectX < 0) {
                    n2 = sprite.x;
                }
                if (sprite.collisionRectY < 0) {
                    n3 = sprite.y;
                }
                if (sprite.collisionRectX + sprite.collisionRectWidth > sprite.width) {
                    n4 = sprite.x + sprite.width;
                }
                if (sprite.collisionRectY + sprite.collisionRectHeight > sprite.height) {
                    n5 = sprite.y + sprite.height;
                }
                if (!this.intersectRect(n2, n3, n4, n5, n6, n7, n8, n9)) {
                    return false;
                }
                int n10 = n6 < n2 ? n2 : n6;
                int n11 = n7 < n3 ? n3 : n7;
                int n12 = n8 < n4 ? n8 : n4;
                int n13 = n9 < n5 ? n9 : n5;
                int n14 = Math.abs(n12 - n10);
                int n15 = Math.abs(n13 - n11);
                int n16 = this.getImageTopLeftX(n10);
                int n17 = this.getImageTopLeftY(n11);
                int n18 = sprite.getImageTopLeftX(n10);
                int n19 = sprite.getImageTopLeftY(n11);
                return Sprite.doPixelCollision(n16, n17, n18, n19, this.sourceImage, sprite.sourceImage, n14, n15);
            }
            return true;
        }
        return false;
    }

    public final boolean collidesWith(Image image, int n2, int n3, boolean bl2) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (!this.visible) {
            return false;
        }
        int n9 = n2;
        int n10 = n3;
        int n11 = n2 + image.getWidth();
        if (this.intersectRect(n9, n10, n11, n8 = n3 + image.getHeight(), n7 = this.x + this.collisionRectX, n6 = this.y + this.collisionRectY, n5 = n7 + this.collisionRectWidth, n4 = n6 + this.collisionRectHeight)) {
            if (bl2) {
                if (this.collisionRectX < 0) {
                    n7 = this.x;
                }
                if (this.collisionRectY < 0) {
                    n6 = this.y;
                }
                if (this.collisionRectX + this.collisionRectWidth > this.width) {
                    n5 = this.x + this.width;
                }
                if (this.collisionRectY + this.collisionRectHeight > this.height) {
                    n4 = this.y + this.height;
                }
                if (!this.intersectRect(n9, n10, n11, n8, n7, n6, n5, n4)) {
                    return false;
                }
                int n12 = n7 < n9 ? n9 : n7;
                int n13 = n6 < n10 ? n10 : n6;
                int n14 = n5 < n11 ? n5 : n11;
                int n15 = n4 < n8 ? n4 : n8;
                int n16 = Math.abs(n14 - n12);
                int n17 = Math.abs(n15 - n13);
                int n18 = this.getImageTopLeftX(n12);
                int n19 = this.getImageTopLeftY(n13);
                int n20 = n12 - n2;
                int n21 = n13 - n3;
                return Sprite.doPixelCollision(n18, n19, n20, n21, this.sourceImage, image, n16, n17);
            }
            return true;
        }
        return false;
    }

    public void setCollisionRectangle(int n2, int n3, int n4, int n5) {
        if (n4 < 0 || n5 < 0) {
            throw new IllegalArgumentException();
        }
        this.collisionRectX = n2;
        this.collisionRectY = n3;
        this.collisionRectWidth = n4;
        this.collisionRectHeight = n5;
    }

    private void initializeFrames(Image image, int n2, int n3, boolean bl2) {
        int n4 = image.getWidth();
        int n5 = image.getHeight();
        int n6 = n4 / n2;
        int n7 = n5 / n3;
        this.sourceImage = image;
        this.srcFrameWidth = n2;
        this.srcFrameHeight = n3;
        this.numberFrames = n6 * n7;
        this.frameCoordsX = new int[this.numberFrames];
        this.frameCoordsY = new int[this.numberFrames];
        if (!bl2) {
            this.sequenceIndex = 0;
        }
        if (!this.customSequenceDefined) {
            this.frameSequence = new int[this.numberFrames];
        }
        int n8 = 0;
        for (int i2 = 0; i2 < n5; i2 += n3) {
            for (int i3 = 0; i3 < n4; i3 += n2) {
                this.frameCoordsX[n8] = i3;
                this.frameCoordsY[n8] = i2;
                if (!this.customSequenceDefined) {
                    this.frameSequence[n8] = n8;
                }
                ++n8;
            }
        }
    }

    private void initCollisionRectBounds() {
        this.collisionRectX = 0;
        this.collisionRectY = 0;
        this.collisionRectWidth = this.width;
        this.collisionRectHeight = this.height;
    }

    private boolean intersectRect(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return n6 < n4 && n7 < n5 && n8 > n2 && n9 > n3;
    }

    private static boolean doPixelCollision(int n2, int n3, int n4, int n5, Image image, Image image2, int n6, int n7) {
        int n8 = n7 * n6;
        int[] nArray = new int[n8];
        int[] nArray2 = new int[n8];
        image.getRGB(nArray, 0, n6, n2, n3, n6, n7);
        image2.getRGB(nArray2, 0, n6, n4, n5, n6, n7);
        int n9 = 0;
        int n10 = 0;
        for (int i2 = 0; i2 < n7; ++i2) {
            int n11 = n9;
            int n12 = n10;
            for (int i3 = 0; i3 < n6; ++i3) {
                if ((nArray[n11] & 0xFF000000) == -16777216 && (nArray2[n12] & 0xFF000000) == -16777216) {
                    return true;
                }
                ++n11;
                ++n12;
            }
            n9 += n6;
            n10 += n6;
        }
        return false;
    }

    private int getImageTopLeftX(int n2) {
        int n3 = n2 - this.x;
        return n3 += this.frameCoordsX[this.frameSequence[this.sequenceIndex]];
    }

    private int getImageTopLeftY(int n2) {
        int n3 = n2 - this.y;
        return n3 += this.frameCoordsY[this.frameSequence[this.sequenceIndex]];
    }
}

