/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.RasterRangesUtils;
import com.sun.jna.platform.WindowUtils$1;
import com.sun.jna.platform.WindowUtils$NativeWindowUtils;
import com.sun.jna.platform.WindowUtils$W32WindowUtils$1;
import com.sun.jna.platform.WindowUtils$W32WindowUtils$2;
import com.sun.jna.platform.WindowUtils$W32WindowUtils$3;
import com.sun.jna.platform.WindowUtils$W32WindowUtils$4;
import com.sun.jna.platform.WindowUtils$W32WindowUtils$5;
import com.sun.jna.platform.win32.GDI32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Psapi;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinDef$DWORDByReference;
import com.sun.jna.platform.win32.WinDef$HICON;
import com.sun.jna.platform.win32.WinDef$HRGN;
import com.sun.jna.platform.win32.WinDef$HWND;
import com.sun.jna.platform.win32.WinDef$LPARAM;
import com.sun.jna.platform.win32.WinDef$LRESULT;
import com.sun.jna.platform.win32.WinDef$POINT;
import com.sun.jna.platform.win32.WinDef$RECT;
import com.sun.jna.platform.win32.WinDef$WPARAM;
import com.sun.jna.platform.win32.WinGDI$BITMAP;
import com.sun.jna.platform.win32.WinGDI$BITMAPINFO;
import com.sun.jna.platform.win32.WinGDI$BITMAPINFOHEADER;
import com.sun.jna.platform.win32.WinGDI$ICONINFO;
import com.sun.jna.platform.win32.WinNT$HANDLE;
import com.sun.jna.ptr.IntByReference;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;

class WindowUtils$W32WindowUtils
extends WindowUtils$NativeWindowUtils {
    private WindowUtils$W32WindowUtils() {
    }

    private WinDef$HWND getHWnd(Component component) {
        WinDef$HWND winDef$HWND = new WinDef$HWND();
        winDef$HWND.setPointer(Native.getComponentPointer(component));
        return winDef$HWND;
    }

    @Override
    public boolean isWindowAlphaSupported() {
        return Boolean.getBoolean("sun.java2d.noddraw");
    }

    private boolean usingUpdateLayeredWindow(Window window) {
        if (window instanceof RootPaneContainer) {
            JRootPane jRootPane = ((RootPaneContainer)((Object)window)).getRootPane();
            return jRootPane.getClientProperty("transparent-old-bg") != null;
        }
        return false;
    }

    private void storeAlpha(Window window, byte by2) {
        if (window instanceof RootPaneContainer) {
            JRootPane jRootPane = ((RootPaneContainer)((Object)window)).getRootPane();
            Byte by3 = by2 == -1 ? null : Byte.valueOf(by2);
            jRootPane.putClientProperty("transparent-alpha", by3);
        }
    }

    private byte getAlpha(Window window) {
        JRootPane jRootPane;
        Byte by2;
        if (window instanceof RootPaneContainer && (by2 = (Byte)(jRootPane = ((RootPaneContainer)((Object)window)).getRootPane()).getClientProperty("transparent-alpha")) != null) {
            return by2;
        }
        return -1;
    }

    @Override
    public void setWindowAlpha(Window window, float f2) {
        if (!this.isWindowAlphaSupported()) {
            throw new UnsupportedOperationException("Set sun.java2d.noddraw=true to enable transparent windows");
        }
        this.whenDisplayable(window, new WindowUtils$W32WindowUtils$1(this, window, f2));
    }

    @Override
    public void setWindowTransparent(Window window, boolean bl2) {
        boolean bl3;
        if (!(window instanceof RootPaneContainer)) {
            throw new IllegalArgumentException("Window must be a RootPaneContainer");
        }
        if (!this.isWindowAlphaSupported()) {
            throw new UnsupportedOperationException("Set sun.java2d.noddraw=true to enable transparent windows");
        }
        boolean bl4 = bl3 = window.getBackground() != null && window.getBackground().getAlpha() == 0;
        if (bl2 == bl3) {
            return;
        }
        this.whenDisplayable(window, new WindowUtils$W32WindowUtils$2(this, window, bl2));
    }

    @Override
    public void setWindowMask(Component component, Shape shape) {
        if (shape instanceof Area && ((Area)shape).isPolygonal()) {
            this.setMask(component, (Area)shape);
        } else {
            super.setWindowMask(component, shape);
        }
    }

    private void setWindowRegion(Component component, WinDef$HRGN winDef$HRGN) {
        this.whenDisplayable(component, new WindowUtils$W32WindowUtils$3(this, component, winDef$HRGN));
    }

    private void setMask(Component component, Area area) {
        GDI32 gDI32 = GDI32.INSTANCE;
        PathIterator pathIterator = area.getPathIterator(null);
        int n2 = pathIterator.getWindingRule() == 1 ? 2 : 1;
        float[] fArray = new float[6];
        ArrayList<WinDef$POINT> arrayList = new ArrayList<WinDef$POINT>();
        int n3 = 0;
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        while (!pathIterator.isDone()) {
            int n4 = pathIterator.currentSegment(fArray);
            if (n4 == 0) {
                n3 = 1;
                arrayList.add(new WinDef$POINT((int)fArray[0], (int)fArray[1]));
            } else if (n4 == 1) {
                ++n3;
                arrayList.add(new WinDef$POINT((int)fArray[0], (int)fArray[1]));
            } else if (n4 == 4) {
                arrayList2.add(n3);
            } else {
                throw new RuntimeException("Area is not polygonal: " + area);
            }
            pathIterator.next();
        }
        WinDef$POINT[] winDef$POINTArray = (WinDef$POINT[])new WinDef$POINT().toArray(arrayList.size());
        WinDef$POINT[] winDef$POINTArray2 = arrayList.toArray(new WinDef$POINT[arrayList.size()]);
        for (int i2 = 0; i2 < winDef$POINTArray.length; ++i2) {
            winDef$POINTArray[i2].x = winDef$POINTArray2[i2].x;
            winDef$POINTArray[i2].y = winDef$POINTArray2[i2].y;
        }
        int[] nArray = new int[arrayList2.size()];
        for (int i3 = 0; i3 < nArray.length; ++i3) {
            nArray[i3] = (Integer)arrayList2.get(i3);
        }
        WinDef$HRGN winDef$HRGN = gDI32.CreatePolyPolygonRgn(winDef$POINTArray, nArray, nArray.length, n2);
        this.setWindowRegion(component, winDef$HRGN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setMask(Component component, Raster raster) {
        WinDef$HRGN winDef$HRGN;
        GDI32 gDI32 = GDI32.INSTANCE;
        WinDef$HRGN winDef$HRGN2 = winDef$HRGN = raster != null ? gDI32.CreateRectRgn(0, 0, 0, 0) : null;
        if (winDef$HRGN != null) {
            WinDef$HRGN winDef$HRGN3 = gDI32.CreateRectRgn(0, 0, 0, 0);
            try {
                RasterRangesUtils.outputOccupiedRanges(raster, new WindowUtils$W32WindowUtils$4(this, winDef$HRGN3, winDef$HRGN));
            }
            finally {
                gDI32.DeleteObject(winDef$HRGN3);
            }
        }
        this.setWindowRegion(component, winDef$HRGN);
    }

    @Override
    public BufferedImage getWindowIcon(WinDef$HWND winDef$HWND) {
        WinGDI$BITMAPINFOHEADER winGDI$BITMAPINFOHEADER;
        WinDef$DWORDByReference winDef$DWORDByReference = new WinDef$DWORDByReference();
        WinDef$LRESULT winDef$LRESULT = User32.INSTANCE.SendMessageTimeout(winDef$HWND, 127, new WinDef$WPARAM(1L), new WinDef$LPARAM(0L), 2, 500, winDef$DWORDByReference);
        if (winDef$LRESULT.intValue() == 0) {
            winDef$LRESULT = User32.INSTANCE.SendMessageTimeout(winDef$HWND, 127, new WinDef$WPARAM(0L), new WinDef$LPARAM(0L), 2, 500, winDef$DWORDByReference);
        }
        if (winDef$LRESULT.intValue() == 0) {
            winDef$LRESULT = User32.INSTANCE.SendMessageTimeout(winDef$HWND, 127, new WinDef$WPARAM(2L), new WinDef$LPARAM(0L), 2, 500, winDef$DWORDByReference);
        }
        if (winDef$LRESULT.intValue() == 0) {
            winDef$LRESULT = new WinDef$LRESULT((long)User32.INSTANCE.GetClassLongPtr(winDef$HWND, -14).intValue());
            winDef$DWORDByReference.getValue().setValue(winDef$LRESULT.intValue());
        }
        if (winDef$LRESULT.intValue() == 0) {
            winDef$LRESULT = new WinDef$LRESULT((long)User32.INSTANCE.GetClassLongPtr(winDef$HWND, -34).intValue());
            winDef$DWORDByReference.getValue().setValue(winDef$LRESULT.intValue());
        }
        if (winDef$LRESULT.intValue() == 0) {
            return null;
        }
        WinDef$HICON winDef$HICON = new WinDef$HICON(new Pointer(winDef$DWORDByReference.getValue().longValue()));
        Dimension dimension = this.getIconSize(winDef$HICON);
        if (dimension.width == 0 || dimension.height == 0) {
            return null;
        }
        int n2 = dimension.width;
        int n3 = dimension.height;
        int n4 = 24;
        byte[] byArray = new byte[n2 * n3 * 24 / 8];
        Memory memory = new Memory(byArray.length);
        byte[] byArray2 = new byte[n2 * n3 * 24 / 8];
        Memory memory2 = new Memory(byArray2.length);
        WinGDI$BITMAPINFO winGDI$BITMAPINFO = new WinGDI$BITMAPINFO();
        winGDI$BITMAPINFO.bmiHeader = winGDI$BITMAPINFOHEADER = new WinGDI$BITMAPINFOHEADER();
        winGDI$BITMAPINFOHEADER.biWidth = n2;
        winGDI$BITMAPINFOHEADER.biHeight = n3;
        winGDI$BITMAPINFOHEADER.biPlanes = 1;
        winGDI$BITMAPINFOHEADER.biBitCount = (short)24;
        winGDI$BITMAPINFOHEADER.biCompression = 0;
        winGDI$BITMAPINFOHEADER.write();
        winGDI$BITMAPINFO.write();
        WinDef.HDC hDC = User32.INSTANCE.GetDC(null);
        WinGDI$ICONINFO winGDI$ICONINFO = new WinGDI$ICONINFO();
        User32.INSTANCE.GetIconInfo(winDef$HICON, winGDI$ICONINFO);
        winGDI$ICONINFO.read();
        GDI32.INSTANCE.GetDIBits(hDC, winGDI$ICONINFO.hbmColor, 0, n3, memory, winGDI$BITMAPINFO, 0);
        ((Pointer)memory).read(0L, byArray, 0, byArray.length);
        GDI32.INSTANCE.GetDIBits(hDC, winGDI$ICONINFO.hbmMask, 0, n3, memory2, winGDI$BITMAPINFO, 0);
        ((Pointer)memory2).read(0L, byArray2, 0, byArray2.length);
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        int n5 = 0;
        int n6 = n3 - 1;
        for (int i2 = 0; i2 < byArray.length; i2 += 3) {
            int n7 = byArray[i2] & 0xFF;
            int n8 = byArray[i2 + 1] & 0xFF;
            int n9 = byArray[i2 + 2] & 0xFF;
            int n10 = 255 - byArray2[i2] & 0xFF;
            int n11 = n10 << 24 | n9 << 16 | n8 << 8 | n7;
            bufferedImage.setRGB(n5, n6, n11);
            n5 = (n5 + 1) % n2;
            if (n5 != 0) continue;
            --n6;
        }
        User32.INSTANCE.ReleaseDC(null, hDC);
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getIconSize(WinDef$HICON winDef$HICON) {
        WinGDI$ICONINFO winGDI$ICONINFO = new WinGDI$ICONINFO();
        try {
            if (!User32.INSTANCE.GetIconInfo(winDef$HICON, winGDI$ICONINFO)) {
                Dimension dimension = new Dimension();
                return dimension;
            }
            winGDI$ICONINFO.read();
            WinGDI$BITMAP winGDI$BITMAP = new WinGDI$BITMAP();
            if (winGDI$ICONINFO.hbmColor != null && winGDI$ICONINFO.hbmColor.getPointer() != Pointer.NULL) {
                int n2 = GDI32.INSTANCE.GetObject(winGDI$ICONINFO.hbmColor, winGDI$BITMAP.size(), winGDI$BITMAP.getPointer());
                winGDI$BITMAP.read();
                if (n2 > 0) {
                    Dimension dimension = new Dimension(winGDI$BITMAP.bmWidth.intValue(), winGDI$BITMAP.bmHeight.intValue());
                    return dimension;
                }
            } else if (winGDI$ICONINFO.hbmMask != null && winGDI$ICONINFO.hbmMask.getPointer() != Pointer.NULL) {
                int n3 = GDI32.INSTANCE.GetObject(winGDI$ICONINFO.hbmMask, winGDI$BITMAP.size(), winGDI$BITMAP.getPointer());
                winGDI$BITMAP.read();
                if (n3 > 0) {
                    Dimension dimension = new Dimension(winGDI$BITMAP.bmWidth.intValue(), winGDI$BITMAP.bmHeight.intValue() / 2);
                    return dimension;
                }
            }
        }
        finally {
            if (winGDI$ICONINFO.hbmColor != null && winGDI$ICONINFO.hbmColor.getPointer() != Pointer.NULL) {
                GDI32.INSTANCE.DeleteObject(winGDI$ICONINFO.hbmColor);
            }
            if (winGDI$ICONINFO.hbmMask != null && winGDI$ICONINFO.hbmMask.getPointer() != Pointer.NULL) {
                GDI32.INSTANCE.DeleteObject(winGDI$ICONINFO.hbmMask);
            }
        }
        return new Dimension();
    }

    @Override
    public List getAllWindows(boolean bl2) {
        LinkedList linkedList = new LinkedList();
        WindowUtils$W32WindowUtils$5 windowUtils$W32WindowUtils$5 = new WindowUtils$W32WindowUtils$5(this, bl2, linkedList);
        if (!User32.INSTANCE.EnumWindows(windowUtils$W32WindowUtils$5, null)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return linkedList;
    }

    @Override
    public String getWindowTitle(WinDef$HWND winDef$HWND) {
        int n2 = User32.INSTANCE.GetWindowTextLength(winDef$HWND) + 1;
        char[] cArray = new char[n2];
        int n3 = User32.INSTANCE.GetWindowText(winDef$HWND, cArray, cArray.length);
        return Native.toString(Arrays.copyOfRange(cArray, 0, n3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProcessFilePath(WinDef$HWND winDef$HWND) {
        char[] cArray = new char[2048];
        IntByReference intByReference = new IntByReference();
        User32.INSTANCE.GetWindowThreadProcessId(winDef$HWND, intByReference);
        WinNT$HANDLE winNT$HANDLE = Kernel32.INSTANCE.OpenProcess(1040, false, intByReference.getValue());
        if (winNT$HANDLE == null) {
            if (Kernel32.INSTANCE.GetLastError() != 5) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            return "";
        }
        try {
            int n2 = Psapi.INSTANCE.GetModuleFileNameExW(winNT$HANDLE, null, cArray, cArray.length);
            if (n2 == 0) {
                if (Kernel32.INSTANCE.GetLastError() != 6) {
                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                }
                String string = "";
                return string;
            }
            String string = Native.toString(cArray).trim();
            return string;
        }
        finally {
            Kernel32.INSTANCE.CloseHandle(winNT$HANDLE);
        }
    }

    @Override
    public Rectangle getWindowLocationAndSize(WinDef$HWND winDef$HWND) {
        WinDef$RECT winDef$RECT = new WinDef$RECT();
        if (!User32.INSTANCE.GetWindowRect(winDef$HWND, winDef$RECT)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return new Rectangle(winDef$RECT.left, winDef$RECT.top, Math.abs(winDef$RECT.right - winDef$RECT.left), Math.abs(winDef$RECT.bottom - winDef$RECT.top));
    }

    /* synthetic */ WindowUtils$W32WindowUtils(WindowUtils$1 windowUtils$1) {
        this();
    }

    static /* synthetic */ WinDef$HWND access$400(WindowUtils$W32WindowUtils windowUtils$W32WindowUtils, Component component) {
        return windowUtils$W32WindowUtils.getHWnd(component);
    }

    static /* synthetic */ boolean access$500(WindowUtils$W32WindowUtils windowUtils$W32WindowUtils, Window window) {
        return windowUtils$W32WindowUtils.usingUpdateLayeredWindow(window);
    }

    static /* synthetic */ void access$600(WindowUtils$W32WindowUtils windowUtils$W32WindowUtils, Window window, byte by2) {
        windowUtils$W32WindowUtils.storeAlpha(window, by2);
    }

    static /* synthetic */ byte access$700(WindowUtils$W32WindowUtils windowUtils$W32WindowUtils, Window window) {
        return windowUtils$W32WindowUtils.getAlpha(window);
    }
}

