/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef$DWORD;
import com.sun.jna.platform.win32.WinNT$HANDLE;
import com.sun.jna.platform.win32.WinNT$HANDLEByReference;
import com.sun.jna.platform.win32.WinNT$LUID;
import com.sun.jna.platform.win32.WinNT$LUID_AND_ATTRIBUTES;
import com.sun.jna.platform.win32.WinNT$TOKEN_PRIVILEGES;
import java.io.Closeable;

public class Advapi32Util$Privilege
implements Closeable {
    private boolean currentlyImpersonating = false;
    private boolean privilegesEnabled = false;
    private final WinNT$LUID[] pLuids;

    public Advapi32Util$Privilege(String ... stringArray) {
        this.pLuids = new WinNT$LUID[stringArray.length];
        int n2 = 0;
        for (String string : stringArray) {
            this.pLuids[n2] = new WinNT$LUID();
            if (!Advapi32.INSTANCE.LookupPrivilegeValue(null, string, this.pLuids[n2])) {
                throw new IllegalArgumentException("Failed to find privilege \"" + stringArray[n2] + "\" - " + Kernel32.INSTANCE.GetLastError());
            }
            ++n2;
        }
    }

    @Override
    public void close() {
        this.disable();
    }

    public Advapi32Util$Privilege enable() {
        if (this.privilegesEnabled) {
            return this;
        }
        WinNT$HANDLEByReference winNT$HANDLEByReference = new WinNT$HANDLEByReference();
        try {
            winNT$HANDLEByReference.setValue(this.getThreadToken());
            WinNT$TOKEN_PRIVILEGES winNT$TOKEN_PRIVILEGES = new WinNT$TOKEN_PRIVILEGES(this.pLuids.length);
            for (int i2 = 0; i2 < this.pLuids.length; ++i2) {
                winNT$TOKEN_PRIVILEGES.Privileges[i2] = new WinNT$LUID_AND_ATTRIBUTES(this.pLuids[i2], new WinDef$DWORD(2L));
            }
            if (!Advapi32.INSTANCE.AdjustTokenPrivileges(winNT$HANDLEByReference.getValue(), false, winNT$TOKEN_PRIVILEGES, 0, null, null)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            this.privilegesEnabled = true;
        }
        catch (Win32Exception win32Exception) {
            if (this.currentlyImpersonating) {
                Advapi32.INSTANCE.SetThreadToken(null, null);
                this.currentlyImpersonating = false;
            } else if (this.privilegesEnabled) {
                WinNT$TOKEN_PRIVILEGES winNT$TOKEN_PRIVILEGES = new WinNT$TOKEN_PRIVILEGES(this.pLuids.length);
                for (int i3 = 0; i3 < this.pLuids.length; ++i3) {
                    winNT$TOKEN_PRIVILEGES.Privileges[i3] = new WinNT$LUID_AND_ATTRIBUTES(this.pLuids[i3], new WinDef$DWORD(0L));
                }
                Advapi32.INSTANCE.AdjustTokenPrivileges(winNT$HANDLEByReference.getValue(), false, winNT$TOKEN_PRIVILEGES, 0, null, null);
                this.privilegesEnabled = false;
            }
            throw win32Exception;
        }
        finally {
            if (winNT$HANDLEByReference.getValue() != WinBase.INVALID_HANDLE_VALUE && winNT$HANDLEByReference.getValue() != null) {
                Kernel32.INSTANCE.CloseHandle(winNT$HANDLEByReference.getValue());
                winNT$HANDLEByReference.setValue(null);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        WinNT$HANDLEByReference winNT$HANDLEByReference = new WinNT$HANDLEByReference();
        try {
            winNT$HANDLEByReference.setValue(this.getThreadToken());
            if (this.currentlyImpersonating) {
                Advapi32.INSTANCE.SetThreadToken(null, null);
            } else if (this.privilegesEnabled) {
                WinNT$TOKEN_PRIVILEGES winNT$TOKEN_PRIVILEGES = new WinNT$TOKEN_PRIVILEGES(this.pLuids.length);
                for (int i2 = 0; i2 < this.pLuids.length; ++i2) {
                    winNT$TOKEN_PRIVILEGES.Privileges[i2] = new WinNT$LUID_AND_ATTRIBUTES(this.pLuids[i2], new WinDef$DWORD(0L));
                }
                Advapi32.INSTANCE.AdjustTokenPrivileges(winNT$HANDLEByReference.getValue(), false, winNT$TOKEN_PRIVILEGES, 0, null, null);
                this.privilegesEnabled = false;
            }
        }
        finally {
            if (winNT$HANDLEByReference.getValue() != WinBase.INVALID_HANDLE_VALUE && winNT$HANDLEByReference.getValue() != null) {
                Kernel32.INSTANCE.CloseHandle(winNT$HANDLEByReference.getValue());
                winNT$HANDLEByReference.setValue(null);
            }
        }
    }

    private WinNT$HANDLE getThreadToken() {
        WinNT$HANDLEByReference winNT$HANDLEByReference = new WinNT$HANDLEByReference();
        WinNT$HANDLEByReference winNT$HANDLEByReference2 = new WinNT$HANDLEByReference();
        try {
            if (!Advapi32.INSTANCE.OpenThreadToken(Kernel32.INSTANCE.GetCurrentThread(), 32, false, winNT$HANDLEByReference)) {
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (1008 != n2) {
                    throw new Win32Exception(n2);
                }
                if (!Advapi32.INSTANCE.OpenProcessToken(Kernel32.INSTANCE.GetCurrentProcess(), 2, winNT$HANDLEByReference2)) {
                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                }
                if (!Advapi32.INSTANCE.DuplicateTokenEx(winNT$HANDLEByReference2.getValue(), 36, null, 2, 2, winNT$HANDLEByReference)) {
                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                }
                if (!Advapi32.INSTANCE.SetThreadToken(null, winNT$HANDLEByReference.getValue())) {
                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                }
                this.currentlyImpersonating = true;
            }
        }
        catch (Win32Exception win32Exception) {
            if (winNT$HANDLEByReference.getValue() != WinBase.INVALID_HANDLE_VALUE && winNT$HANDLEByReference.getValue() != null) {
                Kernel32.INSTANCE.CloseHandle(winNT$HANDLEByReference.getValue());
                winNT$HANDLEByReference.setValue(null);
            }
            throw win32Exception;
        }
        finally {
            if (winNT$HANDLEByReference2.getValue() != WinBase.INVALID_HANDLE_VALUE && winNT$HANDLEByReference2.getValue() != null) {
                Kernel32.INSTANCE.CloseHandle(winNT$HANDLEByReference2.getValue());
                winNT$HANDLEByReference2.setValue(null);
            }
        }
        return winNT$HANDLEByReference.getValue();
    }
}

