/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM.util;

import com.sun.jna.platform.win32.COM.util.ComThread$1;
import com.sun.jna.platform.win32.COM.util.ComThread$2;
import com.sun.jna.platform.win32.COM.util.ComThread$3;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ComThread {
    private static ThreadLocal isCOMThread = new ThreadLocal();
    ExecutorService executor;
    Runnable firstTask;
    boolean requiresInitialisation = true;
    long timeoutMilliseconds;
    Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    public ComThread(String string, long l2, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this(string, l2, uncaughtExceptionHandler, 0);
    }

    public ComThread(String string, long l2, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, int n2) {
        this.timeoutMilliseconds = l2;
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        this.firstTask = new ComThread$1(this, n2);
        this.executor = Executors.newSingleThreadExecutor(new ComThread$2(this, string));
    }

    public void terminate(long l2) {
        try {
            this.executor.submit(new ComThread$3(this)).get(l2, TimeUnit.MILLISECONDS);
            this.executor.shutdown();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (TimeoutException timeoutException) {
            this.executor.shutdownNow();
        }
    }

    protected void finalize() {
        if (!this.executor.isShutdown()) {
            this.terminate(100L);
        }
    }

    static void setComThread(boolean bl2) {
        isCOMThread.set(bl2);
    }

    public Object execute(Callable callable) {
        Boolean bl2 = (Boolean)isCOMThread.get();
        if (bl2 == null) {
            bl2 = false;
        }
        if (bl2.booleanValue()) {
            try {
                return callable.call();
            }
            catch (Exception exception) {
                throw new ExecutionException(exception);
            }
        }
        if (this.requiresInitialisation) {
            this.executor.execute(this.firstTask);
        }
        return this.executor.submit(callable).get(this.timeoutMilliseconds, TimeUnit.MILLISECONDS);
    }

    static /* synthetic */ ThreadLocal access$000() {
        return isCOMThread;
    }
}

