/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.concurrent.ConcurrentHashMap;
import org.bridj.CLong;
import org.bridj.Callback;
import org.bridj.CommonPointerIOs;
import org.bridj.CommonPointerIOs$CallbackPointerIO;
import org.bridj.CommonPointerIOs$IntValuedEnumPointerIO;
import org.bridj.CommonPointerIOs$NativeObjectPointerIO;
import org.bridj.CommonPointerIOs$PointerArrayIO;
import org.bridj.CommonPointerIOs$PointerPointerIO;
import org.bridj.CommonPointerIOs$StructPointerIO;
import org.bridj.CommonPointerIOs$TypedPointerPointerIO;
import org.bridj.IntValuedEnum;
import org.bridj.NativeObject;
import org.bridj.Pointer;
import org.bridj.SizeT;
import org.bridj.StructIO;
import org.bridj.StructObject;
import org.bridj.TimeT;
import org.bridj.TypedPointer;
import org.bridj.util.Utils;

public abstract class PointerIO {
    final Type targetType;
    final Class typedPointerClass;
    final int targetSize;
    final int targetAlignment = -1;
    private static final PointerIO PointerIO = org.bridj.PointerIO.getPointerInstance((PointerIO)null);
    private static final ConcurrentHashMap structIOs = new ConcurrentHashMap();
    private static final ConcurrentHashMap ios = new ConcurrentHashMap();

    public PointerIO(Type type, int n2, Class clazz) {
        this.targetType = type;
        this.targetSize = n2;
        this.typedPointerClass = clazz;
    }

    abstract Object get(Pointer var1, long var2);

    abstract void set(Pointer var1, long var2, Object var4);

    public Object getArray(Pointer pointer, long l2, int n2) {
        return pointer.offset(l2).toArray(n2);
    }

    public Buffer getBuffer(Pointer pointer, long l2, int n2) {
        throw new UnsupportedOperationException("Cannot create a Buffer instance of elements of type " + this.getTargetType());
    }

    public void setArray(Pointer pointer, long l2, Object object) {
        Object[] objectArray = (Object[])object;
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.set(pointer, i2, objectArray[i2]);
        }
    }

    public Object castTarget(long l2) {
        throw new UnsupportedOperationException("Cannot cast pointer to " + this.targetType);
    }

    PointerIO getReferenceIO() {
        return new CommonPointerIOs$PointerPointerIO(this);
    }

    public long getTargetSize() {
        return this.targetSize;
    }

    public long getTargetAlignment() {
        return this.getTargetSize();
    }

    public boolean isTypedPointer() {
        return this.typedPointerClass != null;
    }

    public Class getTypedPointerClass() {
        return this.typedPointerClass;
    }

    public Type getTargetType() {
        return this.targetType;
    }

    static Class getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return org.bridj.PointerIO.getClass(((ParameterizedType)type).getRawType());
        }
        return null;
    }

    public static PointerIO getPointerInstance(Type type) {
        return org.bridj.PointerIO.getPointerInstance(org.bridj.PointerIO.getInstance(type));
    }

    public static PointerIO getPointerInstance(PointerIO pointerIO) {
        return new CommonPointerIOs$PointerPointerIO(pointerIO);
    }

    public static PointerIO getArrayInstance(PointerIO pointerIO, long[] lArray, int n2) {
        return new CommonPointerIOs$PointerArrayIO(pointerIO, lArray, n2);
    }

    static PointerIO getArrayIO(Object object) {
        if (object instanceof int[]) {
            return CommonPointerIOs.intIO;
        }
        if (object instanceof long[]) {
            return CommonPointerIOs.longIO;
        }
        if (object instanceof short[]) {
            return CommonPointerIOs.shortIO;
        }
        if (object instanceof byte[]) {
            return CommonPointerIOs.byteIO;
        }
        if (object instanceof char[]) {
            return CommonPointerIOs.charIO;
        }
        if (object instanceof float[]) {
            return CommonPointerIOs.floatIO;
        }
        if (object instanceof double[]) {
            return CommonPointerIOs.doubleIO;
        }
        if (object instanceof boolean[]) {
            return CommonPointerIOs.booleanIO;
        }
        return org.bridj.PointerIO.getInstance(object.getClass().getComponentType());
    }

    public static PointerIO getInstance(StructIO structIO) {
        PointerIO pointerIO;
        PointerIO pointerIO2 = (PointerIO)structIOs.get(structIO);
        if (pointerIO2 == null && (pointerIO = structIOs.putIfAbsent(structIO, pointerIO2 = new CommonPointerIOs$StructPointerIO(structIO))) != null) {
            pointerIO2 = pointerIO;
        }
        return pointerIO2;
    }

    public static PointerIO getInstance(Type type) {
        if (type == null) {
            return null;
        }
        PointerIO pointerIO = (PointerIO)ios.get(type);
        if (pointerIO == null) {
            Object object;
            Class clazz = Utils.getClass(type);
            if (clazz != null) {
                if (clazz == Pointer.class) {
                    pointerIO = org.bridj.PointerIO.getPointerInstance(((ParameterizedType)type).getActualTypeArguments()[0]);
                } else if (StructObject.class.isAssignableFrom(clazz)) {
                    pointerIO = org.bridj.PointerIO.getInstance(StructIO.getInstance(clazz, type));
                } else if (Callback.class.isAssignableFrom(clazz)) {
                    pointerIO = new CommonPointerIOs$CallbackPointerIO(clazz);
                } else if (NativeObject.class.isAssignableFrom(clazz)) {
                    pointerIO = new CommonPointerIOs$NativeObjectPointerIO(type);
                } else if (IntValuedEnum.class.isAssignableFrom(clazz)) {
                    if (type instanceof ParameterizedType && (object = ((ParameterizedType)type).getActualTypeArguments()[0]) instanceof Class) {
                        pointerIO = new CommonPointerIOs$IntValuedEnumPointerIO((Class)object);
                    }
                } else if (TypedPointer.class.isAssignableFrom(clazz)) {
                    pointerIO = new CommonPointerIOs$TypedPointerPointerIO(clazz);
                }
            }
            if (pointerIO != null && (object = ios.putIfAbsent(type, pointerIO)) != null) {
                pointerIO = object;
            }
        }
        return pointerIO;
    }

    public static PointerIO getIntInstance() {
        return CommonPointerIOs.intIO;
    }

    public static PointerIO getLongInstance() {
        return CommonPointerIOs.longIO;
    }

    public static PointerIO getShortInstance() {
        return CommonPointerIOs.shortIO;
    }

    public static PointerIO getByteInstance() {
        return CommonPointerIOs.byteIO;
    }

    public static PointerIO getCharInstance() {
        return CommonPointerIOs.charIO;
    }

    public static PointerIO getFloatInstance() {
        return CommonPointerIOs.floatIO;
    }

    public static PointerIO getDoubleInstance() {
        return CommonPointerIOs.doubleIO;
    }

    public static PointerIO getBooleanInstance() {
        return CommonPointerIOs.booleanIO;
    }

    public static PointerIO getCLongInstance() {
        return CommonPointerIOs.CLongIO;
    }

    public static PointerIO getSizeTInstance() {
        return CommonPointerIOs.SizeTIO;
    }

    public static PointerIO getPointerInstance() {
        return PointerIO;
    }

    public static PointerIO getTimeTInstance() {
        return CommonPointerIOs.TimeTIO;
    }

    public static PointerIO getBufferPrimitiveInstance(Buffer buffer) {
        if (buffer instanceof IntBuffer) {
            return CommonPointerIOs.intIO;
        }
        if (buffer instanceof LongBuffer) {
            return CommonPointerIOs.longIO;
        }
        if (buffer instanceof ShortBuffer) {
            return CommonPointerIOs.shortIO;
        }
        if (buffer instanceof ByteBuffer) {
            return CommonPointerIOs.byteIO;
        }
        if (buffer instanceof CharBuffer) {
            return CommonPointerIOs.charIO;
        }
        if (buffer instanceof FloatBuffer) {
            return CommonPointerIOs.floatIO;
        }
        if (buffer instanceof DoubleBuffer) {
            return CommonPointerIOs.doubleIO;
        }
        throw new UnsupportedOperationException();
    }

    static {
        ios.put(Pointer.class, PointerIO);
        ios.put(SizeT.class, CommonPointerIOs.SizeTIO);
        ios.put(TimeT.class, CommonPointerIOs.TimeTIO);
        ios.put(CLong.class, CommonPointerIOs.CLongIO);
        PointerIO pointerIO = CommonPointerIOs.intIO;
        ios.put(Integer.TYPE, pointerIO);
        ios.put(Integer.class, pointerIO);
        pointerIO = CommonPointerIOs.longIO;
        ios.put(Long.TYPE, pointerIO);
        ios.put(Long.class, pointerIO);
        pointerIO = CommonPointerIOs.shortIO;
        ios.put(Short.TYPE, pointerIO);
        ios.put(Short.class, pointerIO);
        pointerIO = CommonPointerIOs.byteIO;
        ios.put(Byte.TYPE, pointerIO);
        ios.put(Byte.class, pointerIO);
        pointerIO = CommonPointerIOs.charIO;
        ios.put(Character.TYPE, pointerIO);
        ios.put(Character.class, pointerIO);
        pointerIO = CommonPointerIOs.floatIO;
        ios.put(Float.TYPE, pointerIO);
        ios.put(Float.class, pointerIO);
        pointerIO = CommonPointerIOs.doubleIO;
        ios.put(Double.TYPE, pointerIO);
        ios.put(Double.class, pointerIO);
        pointerIO = CommonPointerIOs.booleanIO;
        ios.put(Boolean.TYPE, pointerIO);
        ios.put(Boolean.class, pointerIO);
    }
}

