/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.util;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import org.bridj.BridJ;
import org.bridj.util.JNIUtils$NativeMethodsCache;
import org.bridj.util.StringUtils;

public class JNIUtils {
    private static Map nativeMethodsCache = new WeakHashMap();
    private static final String bridjPackage = BridJ.class.getPackage() == null ? "org.bridj" : BridJ.class.getPackage().getName();
    private static final String bridjNormalPackagePrefix = bridjPackage.endsWith("v0_7_0") ? bridjPackage.substring(0, bridjPackage.length() - "v0_7_0".length()) : bridjPackage + ".";
    private static final String bridjVersionSpecificPackagePrefix = bridjPackage + ".";

    private static synchronized JNIUtils$NativeMethodsCache getNativeMethodsCache(String string) {
        JNIUtils$NativeMethodsCache jNIUtils$NativeMethodsCache = (JNIUtils$NativeMethodsCache)nativeMethodsCache.get(string);
        if (jNIUtils$NativeMethodsCache == null) {
            jNIUtils$NativeMethodsCache = new JNIUtils$NativeMethodsCache(string);
            nativeMethodsCache.put(string, jNIUtils$NativeMethodsCache);
        }
        return jNIUtils$NativeMethodsCache;
    }

    static int findLastNonEscapeUnderscore(String string) {
        int n2;
        int n3 = n2 = string.length();
        do {
            if ((n3 = string.lastIndexOf("_", n3 - 1)) < 0 || n3 != n2 - 1 && Character.isDigit(string.charAt(n3 + 1))) continue;
            return n3;
        } while (n3 > 0);
        return -1;
    }

    public static String decodeVersionSpecificMethodNameClassAndSignature(String string, Object[] objectArray) {
        return JNIUtils.decodeMethodNameClassAndSignature(string, objectArray, bridjNormalPackagePrefix, bridjVersionSpecificPackagePrefix);
    }

    static String decodeMethodNameClassAndSignature(String string, Object[] objectArray, String string2, String string3) {
        if (string.startsWith("_")) {
            string = string.substring(1);
        }
        if (string.startsWith("Java_")) {
            string = string.substring("Java_".length());
        }
        int n2 = JNIUtils.findLastNonEscapeUnderscore(string);
        String string4 = string.substring(0, n2).replace('_', '.');
        if (string2 != null && string4.startsWith(string2) && !string4.startsWith(string3)) {
            string4 = string3 + string4.substring(string2.length());
        }
        String string5 = string.substring(n2 + 1).replaceAll("_1", "_");
        JNIUtils$NativeMethodsCache jNIUtils$NativeMethodsCache = JNIUtils.getNativeMethodsCache(string4.replace('.', '/'));
        String string6 = jNIUtils$NativeMethodsCache.get(string5);
        if (string6 == null) {
            throw new NoSuchMethodException("Method " + string5 + " not found in class " + string4 + " : known method names = " + StringUtils.implode(jNIUtils$NativeMethodsCache.getNames(), (Object)", "));
        }
        objectArray[0] = string5;
        objectArray[1] = string6;
        String string7 = string4.replace('.', '/');
        return string7;
    }

    public static String getNativeName(Class clazz) {
        return clazz.getName().replace('.', '/');
    }

    public static String getNativeSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        for (Class<?> clazz : method.getParameterTypes()) {
            stringBuffer.append(JNIUtils.getNativeSignature(clazz));
        }
        stringBuffer.append(')');
        stringBuffer.append(JNIUtils.getNativeSignature(method.getReturnType()));
        return stringBuffer.toString();
    }

    public static String getNativeSignature(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("unexpected case");
        }
        if (clazz.isArray()) {
            return "[" + JNIUtils.getNativeSignature(clazz.getComponentType());
        }
        return "L" + JNIUtils.getNativeName(clazz) + ";";
    }
}

