/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.browser.InputStream$1;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.mozilla.IIDStore;
import org.eclipse.swt.internal.mozilla.MozillaVersion;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIInputStream;

class InputStream {
    XPCOMObject inputStream;
    int refCount = 0;
    byte[] buffer;
    int index = 0;

    InputStream(byte[] byArray) {
        this.buffer = byArray;
        this.index = 0;
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        this.inputStream = new InputStream$1(this, new int[]{2, 0, 0, 0, 1, 3, 4, 1});
    }

    void disposeCOMInterfaces() {
        if (this.inputStream != null) {
            this.inputStream.dispose();
            this.inputStream = null;
        }
    }

    int getAddress() {
        return this.inputStream.getAddress();
    }

    int QueryInterface(int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            return -2147467262;
        }
        nsID nsID2 = new nsID();
        XPCOM.memmove(nsID2, n2, 16);
        if (nsID2.Equals(XPCOM.NS_ISUPPORTS_IID)) {
            XPCOM.memmove(n3, new int[]{this.inputStream.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (nsID2.Equals(IIDStore.GetIID(nsIInputStream.class))) {
            XPCOM.memmove(n3, new int[]{this.inputStream.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        XPCOM.memmove(n3, new int[]{0}, C.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int Close() {
        this.buffer = null;
        this.index = 0;
        return 0;
    }

    int Available(int n2) {
        int n3;
        int n4 = n3 = this.buffer == null ? 0 : this.buffer.length - this.index;
        if (MozillaVersion.CheckVersion(6)) {
            XPCOM.memmove(n2, new long[]{n3}, 8);
        } else {
            XPCOM.memmove(n2, new int[]{n3}, 4);
        }
        return 0;
    }

    int Read(int n2, int n3, int n4) {
        int n5 = Math.min(n3, this.buffer == null ? 0 : this.buffer.length - this.index);
        if (n5 > 0) {
            byte[] byArray = new byte[n5];
            System.arraycopy(this.buffer, this.index, byArray, 0, n5);
            XPCOM.memmove(n2, byArray, n5);
            this.index += n5;
        }
        XPCOM.memmove(n4, new int[]{n5}, 4);
        return 0;
    }

    int ReadSegments(int n2, int n3, int n4, int n5) {
        int n6;
        int[] nArray;
        int n7;
        int n8 = n7 = this.buffer == null ? 0 : this.buffer.length - this.index;
        if (n4 != -1) {
            n7 = Math.min(n7, n4);
        }
        for (n6 = n7; n6 > 0; n6 -= nArray[0]) {
            nArray = new int[1];
            int n9 = XPCOM.Call(n2, this.getAddress(), n3, this.buffer, this.index, n6, nArray);
            if (n9 != 0) break;
            this.index += nArray[0];
        }
        XPCOM.memmove(n5, new int[]{n7 - n6}, 4);
        return 0;
    }

    int IsNonBlocking(int n2) {
        XPCOM.memmove(n2, new boolean[]{false});
        return 0;
    }
}

