/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledText$TextWriter;
import org.eclipse.swt.custom.StyledTextEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

class StyledText$RTFWriter
extends StyledText$TextWriter {
    static final int DEFAULT_FOREGROUND = 0;
    static final int DEFAULT_BACKGROUND = 1;
    List colorTable;
    List fontTable;
    boolean WriteUnicode;
    final /* synthetic */ StyledText this$0;

    public StyledText$RTFWriter(StyledText styledText, int n2, int n3) {
        this.this$0 = styledText;
        super(styledText, n2, n3);
        this.colorTable = new ArrayList();
        this.fontTable = new ArrayList();
        this.colorTable.add(styledText.getForeground());
        this.colorTable.add(styledText.getBackground());
        this.fontTable.add(styledText.getFont());
        this.setUnicode();
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.writeHeader();
            this.write("\n}}\u0000");
            super.close();
        }
    }

    int getColorIndex(Color color, int n2) {
        if (color == null) {
            return n2;
        }
        int n3 = this.colorTable.indexOf(color);
        if (n3 == -1) {
            n3 = this.colorTable.size();
            this.colorTable.add(color);
        }
        return n3;
    }

    int getFontIndex(Font font) {
        int n2 = this.fontTable.indexOf(font);
        if (n2 == -1) {
            n2 = this.fontTable.size();
            this.fontTable.add(font);
        }
        return n2;
    }

    void setUnicode() {
        int n2;
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("os.version");
        int n3 = 0;
        if (string.startsWith("windows nt") && string2 != null && (n2 = string2.indexOf(46)) != -1) {
            string2 = string2.substring(0, n2);
            try {
                n3 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.WriteUnicode = !string.startsWith("windows 95") && !string.startsWith("windows 98") && !string.startsWith("windows me") && (!string.startsWith("windows nt") || n3 > 4);
    }

    void write(String string, int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 > '\u007f' && this.WriteUnicode) {
                if (i2 > n2) {
                    this.write(string.substring(n2, i2));
                }
                this.write("\\u");
                this.write(Integer.toString((short)c2));
                this.write('?');
                n2 = i2 + 1;
                continue;
            }
            if (c2 != '}' && c2 != '{' && c2 != '\\') continue;
            if (i2 > n2) {
                this.write(string.substring(n2, i2));
            }
            this.write('\\');
            this.write(c2);
            n2 = i2 + 1;
        }
        if (n2 < n3) {
            this.write(string.substring(n2, n3));
        }
    }

    void writeHeader() {
        Object object;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        FontData fontData = this.this$0.getFont().getFontData()[0];
        stringBuffer.append("{\\rtf1\\ansi");
        String string = System.getProperty("file.encoding").toLowerCase();
        if (string.startsWith("cp") || string.startsWith("ms")) {
            string = string.substring(2, string.length());
            stringBuffer.append("\\ansicpg");
            stringBuffer.append(string);
        }
        stringBuffer.append("\\uc1\\deff0{\\fonttbl{\\f0\\fnil ");
        stringBuffer.append(fontData.getName());
        stringBuffer.append(";");
        for (n2 = 1; n2 < this.fontTable.size(); ++n2) {
            stringBuffer.append("\\f");
            stringBuffer.append(n2);
            stringBuffer.append(" ");
            object = ((Font)this.fontTable.get(n2)).getFontData()[0];
            stringBuffer.append(((FontData)object).getName());
            stringBuffer.append(";");
        }
        stringBuffer.append("}}\n{\\colortbl");
        for (n2 = 0; n2 < this.colorTable.size(); ++n2) {
            object = (Color)this.colorTable.get(n2);
            stringBuffer.append("\\red");
            stringBuffer.append(((Color)object).getRed());
            stringBuffer.append("\\green");
            stringBuffer.append(((Color)object).getGreen());
            stringBuffer.append("\\blue");
            stringBuffer.append(((Color)object).getBlue());
            stringBuffer.append(";");
        }
        stringBuffer.append("}\n{\\f0\\fs");
        stringBuffer.append(fontData.getHeight() * 2);
        stringBuffer.append(" ");
        this.write(stringBuffer.toString(), 0);
    }

    @Override
    public void writeLine(String string, int n2) {
        StyleRange[] styleRangeArray;
        int[] nArray;
        boolean bl2;
        int n3;
        int n4;
        if (this.isClosed()) {
            SWT.error(39);
        }
        int n5 = this.this$0.content.getLineAtOffset(n2);
        StyledTextEvent styledTextEvent = this.this$0.getLineStyleData(n2, string);
        if (styledTextEvent != null) {
            n4 = styledTextEvent.alignment;
            n3 = styledTextEvent.indent;
            bl2 = styledTextEvent.justify;
            nArray = styledTextEvent.ranges;
            styleRangeArray = styledTextEvent.styles;
        } else {
            n4 = this.this$0.renderer.getLineAlignment(n5, this.this$0.alignment);
            n3 = this.this$0.renderer.getLineIndent(n5, this.this$0.indent);
            bl2 = this.this$0.renderer.getLineJustify(n5, this.this$0.justify);
            nArray = this.this$0.renderer.getRanges(n2, string.length());
            styleRangeArray = this.this$0.renderer.getStyleRanges(n2, string.length(), false);
        }
        if (styleRangeArray == null) {
            styleRangeArray = new StyleRange[]{};
        }
        Color color = this.this$0.renderer.getLineBackground(n5, null);
        styledTextEvent = this.this$0.getLineBackgroundData(n2, string);
        if (styledTextEvent != null && styledTextEvent.lineBackground != null) {
            color = styledTextEvent.lineBackground;
        }
        this.writeStyledLine(string, n2, nArray, styleRangeArray, color, n3, n4, bl2);
    }

    @Override
    public void writeLineDelimiter(String string) {
        if (this.isClosed()) {
            SWT.error(39);
        }
        this.write(string, 0, string.length());
        this.write("\\par ");
    }

    void writeStyledLine(String string, int n2, int[] nArray, StyleRange[] styleRangeArray, Color color, int n3, int n4, boolean bl2) {
        int n5 = string.length();
        int n6 = this.getStart();
        int n7 = n6 - n2;
        if (n7 >= n5) {
            return;
        }
        int n8 = Math.max(0, n7);
        this.write("\\fi");
        this.write(n3);
        switch (n4) {
            case 16384: {
                this.write("\\ql");
                break;
            }
            case 0x1000000: {
                this.write("\\qc");
                break;
            }
            case 131072: {
                this.write("\\qr");
            }
        }
        if (bl2) {
            this.write("\\qj");
        }
        this.write(" ");
        if (color != null) {
            this.write("{\\highlight");
            this.write(this.getColorIndex(color, 1));
            this.write(" ");
        }
        int n9 = n6 + super.getCharCount();
        int n10 = Math.min(n5, n9 - n2);
        for (int i2 = 0; i2 < styleRangeArray.length; ++i2) {
            int n11;
            int n12;
            int n13;
            StyleRange styleRange = styleRangeArray[i2];
            if (nArray != null) {
                n13 = nArray[i2 << 1] - n2;
                n12 = n13 + nArray[(i2 << 1) + 1];
            } else {
                n13 = styleRange.start - n2;
                n12 = n13 + styleRange.length;
            }
            if (n12 < n7) continue;
            if (n13 >= n10) break;
            if (n8 < n13) {
                this.write(string, n8, n13);
                n8 = n13;
            }
            this.write("{\\cf");
            this.write(this.getColorIndex(styleRange.foreground, 0));
            int n14 = this.getColorIndex(styleRange.background, 1);
            if (n14 != 1) {
                this.write("\\highlight");
                this.write(n14);
            }
            int n15 = styleRange.fontStyle;
            Font font = styleRange.font;
            if (font != null) {
                n11 = this.getFontIndex(font);
                this.write("\\f");
                this.write(n11);
                FontData fontData = font.getFontData()[0];
                this.write("\\fs");
                this.write(fontData.getHeight() * 2);
                n15 = fontData.getStyle();
            }
            if ((n15 & 1) != 0) {
                this.write("\\b");
            }
            if ((n15 & 2) != 0) {
                this.write("\\i");
            }
            if (styleRange.underline) {
                this.write("\\ul");
            }
            if (styleRange.strikeout) {
                this.write("\\strike");
            }
            this.write(" ");
            n11 = Math.min(n12, n10);
            n11 = Math.max(n11, n8);
            this.write(string, n8, n11);
            if ((n15 & 1) != 0) {
                this.write("\\b0");
            }
            if ((styleRange.fontStyle & 2) != 0) {
                this.write("\\i0");
            }
            if (styleRange.underline) {
                this.write("\\ul0");
            }
            if (styleRange.strikeout) {
                this.write("\\strike0");
            }
            this.write("}");
            n8 = n11;
        }
        if (n8 < n10) {
            this.write(string, n8, n10);
        }
        if (color != null) {
            this.write("}");
        }
    }
}

