/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageDataLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.DPIUtil;

public final class ImageData
implements Cloneable {
    public int width;
    public int height;
    public int depth;
    public int scanlinePad;
    public int bytesPerLine;
    public byte[] data;
    public PaletteData palette;
    public int transparentPixel;
    public byte[] maskData;
    public int maskPad;
    public byte[] alphaData;
    public int alpha;
    public int type;
    public int x;
    public int y;
    public int disposalMethod;
    public int delayTime;
    static final byte[][] ANY_TO_EIGHT = new byte[9][];
    static final byte[] ONE_TO_ONE_MAPPING;
    static final int[][] DITHER_MATRIX;
    static final int BLIT_SRC = 1;
    static final int BLIT_ALPHA = 2;
    static final int BLIT_DITHER = 4;
    static final int ALPHA_OPAQUE = 255;
    static final int ALPHA_TRANSPARENT = 0;
    static final int ALPHA_CHANNEL_SEPARATE = -1;
    static final int ALPHA_CHANNEL_SOURCE = -2;
    static final int ALPHA_MASK_UNPACKED = -3;
    static final int ALPHA_MASK_PACKED = -4;
    static final int ALPHA_MASK_INDEX = -5;
    static final int ALPHA_MASK_RGB = -6;
    static final int LSB_FIRST = 0;
    static final int MSB_FIRST = 1;
    private static final int TYPE_GENERIC_8 = 0;
    private static final int TYPE_GENERIC_16_MSB = 1;
    private static final int TYPE_GENERIC_16_LSB = 2;
    private static final int TYPE_GENERIC_24 = 3;
    private static final int TYPE_GENERIC_32_MSB = 4;
    private static final int TYPE_GENERIC_32_LSB = 5;
    private static final int TYPE_INDEX_8 = 6;
    private static final int TYPE_INDEX_4 = 7;
    private static final int TYPE_INDEX_2 = 8;
    private static final int TYPE_INDEX_1_MSB = 9;
    private static final int TYPE_INDEX_1_LSB = 10;

    public ImageData(int n2, int n3, int n4, PaletteData paletteData) {
        this(n2, n3, n4, paletteData, 4, null, 0, null, null, -1, -1, -1, 0, 0, 0, 0);
    }

    public ImageData(int n2, int n3, int n4, PaletteData paletteData, int n5, byte[] byArray) {
        this(n2, n3, n4, paletteData, n5, ImageData.checkData(byArray), 0, null, null, -1, -1, -1, 0, 0, 0, 0);
    }

    public ImageData(InputStream inputStream) {
        ImageData[] imageDataArray = ImageDataLoader.load(inputStream);
        if (imageDataArray.length < 1) {
            SWT.error(40);
        }
        ImageData imageData = imageDataArray[0];
        this.setAllFields(imageData.width, imageData.height, imageData.depth, imageData.scanlinePad, imageData.bytesPerLine, imageData.data, imageData.palette, imageData.transparentPixel, imageData.maskData, imageData.maskPad, imageData.alphaData, imageData.alpha, imageData.type, imageData.x, imageData.y, imageData.disposalMethod, imageData.delayTime);
    }

    public ImageData(String string) {
        ImageData[] imageDataArray = ImageDataLoader.load(string);
        if (imageDataArray.length < 1) {
            SWT.error(40);
        }
        ImageData imageData = imageDataArray[0];
        this.setAllFields(imageData.width, imageData.height, imageData.depth, imageData.scanlinePad, imageData.bytesPerLine, imageData.data, imageData.palette, imageData.transparentPixel, imageData.maskData, imageData.maskPad, imageData.alphaData, imageData.alpha, imageData.type, imageData.x, imageData.y, imageData.disposalMethod, imageData.delayTime);
    }

    ImageData() {
    }

    ImageData(int n2, int n3, int n4, PaletteData paletteData, int n5, byte[] byArray, int n6, byte[] byArray2, byte[] byArray3, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        int n14;
        if (paletteData == null) {
            SWT.error(4);
        }
        if (n4 != 1 && n4 != 2 && n4 != 4 && n4 != 8 && n4 != 16 && n4 != 24 && n4 != 32) {
            SWT.error(5);
        }
        if (n2 <= 0 || n3 <= 0) {
            SWT.error(5);
        }
        if (n5 == 0) {
            SWT.error(7);
        }
        int n15 = ((n2 * n4 + 7) / 8 + (n5 - 1)) / n5 * n5;
        int n16 = n14 = n9 == 5 ? ((n2 + 7) / 8 + 3) / 4 * 4 : n15;
        if (byArray != null && byArray.length < n14 * n3) {
            SWT.error(5);
        }
        this.setAllFields(n2, n3, n4, n5, n15, byArray != null ? byArray : new byte[n15 * n3], paletteData, n8, byArray2, n6, byArray3, n7, n9, n10, n11, n12, n13);
    }

    void setAllFields(int n2, int n3, int n4, int n5, int n6, byte[] byArray, PaletteData paletteData, int n7, byte[] byArray2, int n8, byte[] byArray3, int n9, int n10, int n11, int n12, int n13, int n14) {
        this.width = n2;
        this.height = n3;
        this.depth = n4;
        this.scanlinePad = n5;
        this.bytesPerLine = n6;
        this.data = byArray;
        this.palette = paletteData;
        this.transparentPixel = n7;
        this.maskData = byArray2;
        this.maskPad = n8;
        this.alphaData = byArray3;
        this.alpha = n9;
        this.type = n10;
        this.x = n11;
        this.y = n12;
        this.disposalMethod = n13;
        this.delayTime = n14;
    }

    public static ImageData internal_new(int n2, int n3, int n4, PaletteData paletteData, int n5, byte[] byArray, int n6, byte[] byArray2, byte[] byArray3, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        return new ImageData(n2, n3, n4, paletteData, n5, byArray, n6, byArray2, byArray3, n7, n8, n9, n10, n11, n12, n13);
    }

    ImageData colorMaskImage(int n2) {
        ImageData imageData = new ImageData(this.width, this.height, 1, ImageData.bwPalette(), 2, null, 0, null, null, -1, -1, -1, 0, 0, 0, 0);
        int[] nArray = new int[this.width];
        for (int i2 = 0; i2 < this.height; ++i2) {
            this.getPixels(0, i2, this.width, nArray, 0);
            for (int i3 = 0; i3 < this.width; ++i3) {
                nArray[i3] = n2 != -1 && nArray[i3] == n2 ? 0 : 1;
            }
            imageData.setPixels(0, i2, this.width, nArray, 0);
        }
        return imageData;
    }

    static byte[] checkData(byte[] byArray) {
        if (byArray == null) {
            SWT.error(4);
        }
        return byArray;
    }

    public Object clone() {
        byte[] byArray = new byte[this.data.length];
        System.arraycopy(this.data, 0, byArray, 0, this.data.length);
        byte[] byArray2 = null;
        if (this.maskData != null) {
            byArray2 = new byte[this.maskData.length];
            System.arraycopy(this.maskData, 0, byArray2, 0, this.maskData.length);
        }
        byte[] byArray3 = null;
        if (this.alphaData != null) {
            byArray3 = new byte[this.alphaData.length];
            System.arraycopy(this.alphaData, 0, byArray3, 0, this.alphaData.length);
        }
        return new ImageData(this.width, this.height, this.depth, this.palette, this.scanlinePad, byArray, this.maskPad, byArray2, byArray3, this.alpha, this.transparentPixel, this.type, this.x, this.y, this.disposalMethod, this.delayTime);
    }

    public int getAlpha(int n2, int n3) {
        if (n2 >= this.width || n3 >= this.height || n2 < 0 || n3 < 0) {
            SWT.error(5);
        }
        if (this.alphaData == null) {
            return 255;
        }
        return this.alphaData[n3 * this.width + n2] & 0xFF;
    }

    public void getAlphas(int n2, int n3, int n4, byte[] byArray, int n5) {
        if (byArray == null) {
            SWT.error(4);
        }
        if (n4 < 0 || n2 >= this.width || n3 >= this.height || n2 < 0 || n3 < 0) {
            SWT.error(5);
        }
        if (n4 == 0) {
            return;
        }
        if (this.alphaData == null) {
            int n6 = n5 + n4;
            for (int i2 = n5; i2 < n6; ++i2) {
                byArray[i2] = -1;
            }
            return;
        }
        System.arraycopy(this.alphaData, n3 * this.width + n2, byArray, n5, n4);
    }

    public int getPixel(int n2, int n3) {
        if (n2 >= this.width || n3 >= this.height || n2 < 0 || n3 < 0) {
            SWT.error(5);
        }
        switch (this.depth) {
            case 32: {
                int n4 = n3 * this.bytesPerLine + n2 * 4;
                return ((this.data[n4] & 0xFF) << 24) + ((this.data[n4 + 1] & 0xFF) << 16) + ((this.data[n4 + 2] & 0xFF) << 8) + (this.data[n4 + 3] & 0xFF);
            }
            case 24: {
                int n5 = n3 * this.bytesPerLine + n2 * 3;
                return ((this.data[n5] & 0xFF) << 16) + ((this.data[n5 + 1] & 0xFF) << 8) + (this.data[n5 + 2] & 0xFF);
            }
            case 16: {
                int n6 = n3 * this.bytesPerLine + n2 * 2;
                return ((this.data[n6 + 1] & 0xFF) << 8) + (this.data[n6] & 0xFF);
            }
            case 8: {
                int n7 = n3 * this.bytesPerLine + n2;
                return this.data[n7] & 0xFF;
            }
            case 4: {
                int n8 = n3 * this.bytesPerLine + (n2 >> 1);
                int n9 = this.data[n8] & 0xFF;
                if ((n2 & 1) == 0) {
                    return n9 >> 4;
                }
                return n9 & 0xF;
            }
            case 2: {
                int n10 = n3 * this.bytesPerLine + (n2 >> 2);
                int n11 = this.data[n10] & 0xFF;
                int n12 = 3 - n2 % 4;
                int n13 = 3 << n12 * 2;
                return (n11 & n13) >> n12 * 2;
            }
            case 1: {
                int n14 = n3 * this.bytesPerLine + (n2 >> 3);
                int n15 = this.data[n14] & 0xFF;
                int n16 = 1 << 7 - (n2 & 7);
                if ((n15 & n16) == 0) {
                    return 0;
                }
                return 1;
            }
        }
        SWT.error(38);
        return 0;
    }

    public void getPixels(int n2, int n3, int n4, byte[] byArray, int n5) {
        if (byArray == null) {
            SWT.error(4);
        }
        if (n4 < 0 || n2 >= this.width || n3 >= this.height || n2 < 0 || n3 < 0) {
            SWT.error(5);
        }
        if (n4 == 0) {
            return;
        }
        int n6 = 0;
        int n7 = n4;
        int n8 = n5;
        int n9 = n2;
        int n10 = n3;
        switch (this.depth) {
            case 8: {
                int n11 = n3 * this.bytesPerLine + n2;
                for (int i2 = 0; i2 < n4; ++i2) {
                    byArray[n8] = this.data[n11];
                    ++n8;
                    if (++n9 >= this.width) {
                        n11 = ++n10 * this.bytesPerLine;
                        n9 = 0;
                        continue;
                    }
                    ++n11;
                }
                return;
            }
            case 4: {
                int n12;
                int n13 = n3 * this.bytesPerLine + (n2 >> 1);
                if ((n2 & 1) == 1) {
                    n12 = this.data[n13] & 0xFF;
                    byArray[n8] = (byte)(n12 & 0xF);
                    ++n8;
                    --n7;
                    if (++n9 >= this.width) {
                        n13 = ++n10 * this.bytesPerLine;
                        n9 = 0;
                    } else {
                        ++n13;
                    }
                }
                while (n7 > 1) {
                    n12 = this.data[n13] & 0xFF;
                    byArray[n8] = (byte)(n12 >> 4);
                    ++n8;
                    --n7;
                    if (++n9 >= this.width) {
                        n13 = ++n10 * this.bytesPerLine;
                        n9 = 0;
                        continue;
                    }
                    byArray[n8] = (byte)(n12 & 0xF);
                    ++n8;
                    --n7;
                    if (++n9 >= this.width) {
                        n13 = ++n10 * this.bytesPerLine;
                        n9 = 0;
                        continue;
                    }
                    ++n13;
                }
                if (n7 > 0) {
                    n12 = this.data[n13] & 0xFF;
                    byArray[n8] = (byte)(n12 >> 4);
                }
                return;
            }
            case 2: {
                int n14 = n3 * this.bytesPerLine + (n2 >> 2);
                int n15 = this.data[n14] & 0xFF;
                while (n7 > 0) {
                    int n16 = 3 - n9 % 4;
                    n6 = 3 << n16 * 2;
                    byArray[n8] = (byte)((n15 & n6) >> n16 * 2);
                    ++n8;
                    --n7;
                    if (++n9 >= this.width) {
                        n14 = ++n10 * this.bytesPerLine;
                        if (n7 > 0) {
                            n15 = this.data[n14] & 0xFF;
                        }
                        n9 = 0;
                        continue;
                    }
                    if (n16 != 0) continue;
                    n15 = this.data[++n14] & 0xFF;
                }
                return;
            }
            case 1: {
                int n17 = n3 * this.bytesPerLine + (n2 >> 3);
                int n18 = this.data[n17] & 0xFF;
                while (n7 > 0) {
                    n6 = 1 << 7 - (n9 & 7);
                    byArray[n8] = (n18 & n6) == 0 ? (byte)0 : 1;
                    ++n8;
                    --n7;
                    if (++n9 >= this.width) {
                        n17 = ++n10 * this.bytesPerLine;
                        if (n7 > 0) {
                            n18 = this.data[n17] & 0xFF;
                        }
                        n9 = 0;
                        continue;
                    }
                    if (n6 != 1) continue;
                    ++n17;
                    if (n7 <= 0) continue;
                    n18 = this.data[n17] & 0xFF;
                }
                return;
            }
        }
        SWT.error(38);
    }

    public void getPixels(int n2, int n3, int n4, int[] nArray, int n5) {
        if (nArray == null) {
            SWT.error(4);
        }
        if (n4 < 0 || n2 >= this.width || n3 >= this.height || n2 < 0 || n3 < 0) {
            SWT.error(5);
        }
        if (n4 == 0) {
            return;
        }
        int n6 = n4;
        int n7 = n5;
        int n8 = n2;
        int n9 = n3;
        switch (this.depth) {
            case 32: {
                int n10 = n3 * this.bytesPerLine + n2 * 4;
                n7 = n5;
                for (int i2 = 0; i2 < n4; ++i2) {
                    nArray[n7] = (this.data[n10] & 0xFF) << 24 | (this.data[n10 + 1] & 0xFF) << 16 | (this.data[n10 + 2] & 0xFF) << 8 | this.data[n10 + 3] & 0xFF;
                    ++n7;
                    if (++n8 >= this.width) {
                        n10 = ++n9 * this.bytesPerLine;
                        n8 = 0;
                        continue;
                    }
                    n10 += 4;
                }
                return;
            }
            case 24: {
                int n11 = n3 * this.bytesPerLine + n2 * 3;
                for (int i3 = 0; i3 < n4; ++i3) {
                    nArray[n7] = (this.data[n11] & 0xFF) << 16 | (this.data[n11 + 1] & 0xFF) << 8 | this.data[n11 + 2] & 0xFF;
                    ++n7;
                    if (++n8 >= this.width) {
                        n11 = ++n9 * this.bytesPerLine;
                        n8 = 0;
                        continue;
                    }
                    n11 += 3;
                }
                return;
            }
            case 16: {
                int n12 = n3 * this.bytesPerLine + n2 * 2;
                for (int i4 = 0; i4 < n4; ++i4) {
                    nArray[n7] = ((this.data[n12 + 1] & 0xFF) << 8) + (this.data[n12] & 0xFF);
                    ++n7;
                    if (++n8 >= this.width) {
                        n12 = ++n9 * this.bytesPerLine;
                        n8 = 0;
                        continue;
                    }
                    n12 += 2;
                }
                return;
            }
            case 8: {
                int n13 = n3 * this.bytesPerLine + n2;
                for (int i5 = 0; i5 < n4; ++i5) {
                    nArray[n7] = this.data[n13] & 0xFF;
                    ++n7;
                    if (++n8 >= this.width) {
                        n13 = ++n9 * this.bytesPerLine;
                        n8 = 0;
                        continue;
                    }
                    ++n13;
                }
                return;
            }
            case 4: {
                int n14;
                int n15 = n3 * this.bytesPerLine + (n2 >> 1);
                if ((n2 & 1) == 1) {
                    n14 = this.data[n15] & 0xFF;
                    nArray[n7] = n14 & 0xF;
                    ++n7;
                    --n6;
                    if (++n8 >= this.width) {
                        n15 = ++n9 * this.bytesPerLine;
                        n8 = 0;
                    } else {
                        ++n15;
                    }
                }
                while (n6 > 1) {
                    n14 = this.data[n15] & 0xFF;
                    nArray[n7] = n14 >> 4;
                    ++n7;
                    --n6;
                    if (++n8 >= this.width) {
                        n15 = ++n9 * this.bytesPerLine;
                        n8 = 0;
                        continue;
                    }
                    nArray[n7] = n14 & 0xF;
                    ++n7;
                    --n6;
                    if (++n8 >= this.width) {
                        n15 = ++n9 * this.bytesPerLine;
                        n8 = 0;
                        continue;
                    }
                    ++n15;
                }
                if (n6 > 0) {
                    n14 = this.data[n15] & 0xFF;
                    nArray[n7] = n14 >> 4;
                }
                return;
            }
            case 2: {
                int n16 = n3 * this.bytesPerLine + (n2 >> 2);
                int n17 = this.data[n16] & 0xFF;
                while (n6 > 0) {
                    int n18 = 3 - n8 % 4;
                    int n19 = 3 << n18 * 2;
                    nArray[n7] = (byte)((n17 & n19) >> n18 * 2);
                    ++n7;
                    --n6;
                    if (++n8 >= this.width) {
                        n16 = ++n9 * this.bytesPerLine;
                        if (n6 > 0) {
                            n17 = this.data[n16] & 0xFF;
                        }
                        n8 = 0;
                        continue;
                    }
                    if (n18 != 0) continue;
                    n17 = this.data[++n16] & 0xFF;
                }
                return;
            }
            case 1: {
                int n20 = n3 * this.bytesPerLine + (n2 >> 3);
                int n21 = this.data[n20] & 0xFF;
                while (n6 > 0) {
                    int n22 = 1 << 7 - (n8 & 7);
                    nArray[n7] = (n21 & n22) == 0 ? 0 : 1;
                    ++n7;
                    --n6;
                    if (++n8 >= this.width) {
                        n20 = ++n9 * this.bytesPerLine;
                        if (n6 > 0) {
                            n21 = this.data[n20] & 0xFF;
                        }
                        n8 = 0;
                        continue;
                    }
                    if (n22 != 1) continue;
                    ++n20;
                    if (n6 <= 0) continue;
                    n21 = this.data[n20] & 0xFF;
                }
                return;
            }
        }
        SWT.error(38);
    }

    public RGB[] getRGBs() {
        return this.palette.getRGBs();
    }

    public ImageData getTransparencyMask() {
        if (this.getTransparencyType() == 2) {
            return new ImageData(this.width, this.height, 1, ImageData.bwPalette(), this.maskPad, this.maskData);
        }
        return this.colorMaskImage(this.transparentPixel);
    }

    public int getTransparencyType() {
        if (this.maskData != null) {
            return 2;
        }
        if (this.transparentPixel != -1) {
            return 4;
        }
        if (this.alphaData != null) {
            return 1;
        }
        return 0;
    }

    int getByteOrder() {
        return this.depth != 16 ? 1 : 0;
    }

    public ImageData scaledTo(int n2, int n3) {
        boolean bl2;
        boolean bl3;
        boolean bl4 = bl3 = n2 < 0;
        if (bl3) {
            n2 = -n2;
        }
        boolean bl5 = bl2 = n3 < 0;
        if (bl2) {
            n3 = -n3;
        }
        ImageData imageData = new ImageData(n2, n3, this.depth, this.palette, this.scanlinePad, null, 0, null, null, -1, this.transparentPixel, this.type, this.x, this.y, this.disposalMethod, this.delayTime);
        if (this.palette.isDirect) {
            ImageData.blit(1, this.data, this.depth, this.bytesPerLine, this.getByteOrder(), 0, 0, this.width, this.height, 0, 0, 0, 255, null, 0, 0, 0, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, imageData.width, imageData.height, 0, 0, 0, bl3, bl2);
        } else {
            ImageData.blit(1, this.data, this.depth, this.bytesPerLine, this.getByteOrder(), 0, 0, this.width, this.height, null, null, null, 255, null, 0, 0, 0, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, imageData.width, imageData.height, null, null, null, bl3, bl2);
        }
        if (this.maskData != null) {
            imageData.maskPad = this.maskPad;
            int n4 = (imageData.width + 7) / 8;
            n4 = (n4 + (imageData.maskPad - 1)) / imageData.maskPad * imageData.maskPad;
            imageData.maskData = new byte[n4 * imageData.height];
            int n5 = (this.width + 7) / 8;
            n5 = (n5 + (this.maskPad - 1)) / this.maskPad * this.maskPad;
            ImageData.blit(1, this.maskData, 1, n5, 1, 0, 0, this.width, this.height, null, null, null, 255, null, 0, 0, 0, imageData.maskData, 1, n4, 1, 0, 0, imageData.width, imageData.height, null, null, null, bl3, bl2);
        } else if (this.alpha != -1) {
            imageData.alpha = this.alpha;
        } else if (this.alphaData != null) {
            imageData.alphaData = new byte[imageData.width * imageData.height];
            ImageData.blit(1, this.alphaData, 8, this.width, 1, 0, 0, this.width, this.height, null, null, null, 255, null, 0, 0, 0, imageData.alphaData, 8, imageData.width, 1, 0, 0, imageData.width, imageData.height, null, null, null, bl3, bl2);
        }
        return imageData;
    }

    public void setAlpha(int n2, int n3, int n4) {
        if (n2 >= this.width || n3 >= this.height || n2 < 0 || n3 < 0 || n4 < 0 || n4 > 255) {
            SWT.error(5);
        }
        if (this.alphaData == null) {
            this.alphaData = new byte[this.width * this.height];
        }
        this.alphaData[n3 * this.width + n2] = (byte)n4;
    }

    public void setAlphas(int n2, int n3, int n4, byte[] byArray, int n5) {
        if (byArray == null) {
            SWT.error(4);
        }
        if (n4 < 0 || n2 >= this.width || n3 >= this.height || n2 < 0 || n3 < 0) {
            SWT.error(5);
        }
        if (n4 == 0) {
            return;
        }
        if (this.alphaData == null) {
            this.alphaData = new byte[this.width * this.height];
        }
        System.arraycopy(byArray, n5, this.alphaData, n3 * this.width + n2, n4);
    }

    public void setPixel(int n2, int n3, int n4) {
        if (n2 >= this.width || n3 >= this.height || n2 < 0 || n3 < 0) {
            SWT.error(5);
        }
        switch (this.depth) {
            case 32: {
                int n5 = n3 * this.bytesPerLine + n2 * 4;
                this.data[n5] = (byte)(n4 >> 24 & 0xFF);
                this.data[n5 + 1] = (byte)(n4 >> 16 & 0xFF);
                this.data[n5 + 2] = (byte)(n4 >> 8 & 0xFF);
                this.data[n5 + 3] = (byte)(n4 & 0xFF);
                return;
            }
            case 24: {
                int n6 = n3 * this.bytesPerLine + n2 * 3;
                this.data[n6] = (byte)(n4 >> 16 & 0xFF);
                this.data[n6 + 1] = (byte)(n4 >> 8 & 0xFF);
                this.data[n6 + 2] = (byte)(n4 & 0xFF);
                return;
            }
            case 16: {
                int n7 = n3 * this.bytesPerLine + n2 * 2;
                this.data[n7 + 1] = (byte)(n4 >> 8 & 0xFF);
                this.data[n7] = (byte)(n4 & 0xFF);
                return;
            }
            case 8: {
                int n8 = n3 * this.bytesPerLine + n2;
                this.data[n8] = (byte)(n4 & 0xFF);
                return;
            }
            case 4: {
                int n9 = n3 * this.bytesPerLine + (n2 >> 1);
                this.data[n9] = (n2 & 1) == 0 ? (byte)(this.data[n9] & 0xF | (n4 & 0xF) << 4) : (byte)(this.data[n9] & 0xF0 | n4 & 0xF);
                return;
            }
            case 2: {
                int n10 = n3 * this.bytesPerLine + (n2 >> 2);
                byte by2 = this.data[n10];
                int n11 = 3 - n2 % 4;
                int n12 = 0xFF ^ 3 << n11 * 2;
                this.data[n10] = (byte)(this.data[n10] & n12 | n4 << n11 * 2);
                return;
            }
            case 1: {
                int n13 = n3 * this.bytesPerLine + (n2 >> 3);
                byte by3 = this.data[n13];
                int n14 = 1 << 7 - (n2 & 7);
                this.data[n13] = (n4 & 1) == 1 ? (byte)(by3 | n14) : (byte)(by3 & ~n14);
                return;
            }
        }
        SWT.error(38);
    }

    public void setPixels(int n2, int n3, int n4, byte[] byArray, int n5) {
        if (byArray == null) {
            SWT.error(4);
        }
        if (n4 < 0 || n2 >= this.width || n3 >= this.height || n2 < 0 || n3 < 0) {
            SWT.error(5);
        }
        if (n4 == 0) {
            return;
        }
        int n6 = n5;
        int n7 = n2;
        int n8 = n3;
        switch (this.depth) {
            case 8: {
                int n9 = n3 * this.bytesPerLine + n2;
                for (int i2 = 0; i2 < n4; ++i2) {
                    this.data[n9] = (byte)(byArray[n6] & 0xFF);
                    ++n6;
                    if (++n7 >= this.width) {
                        n9 = ++n8 * this.bytesPerLine;
                        n7 = 0;
                        continue;
                    }
                    ++n9;
                }
                return;
            }
            case 4: {
                int n10;
                boolean bl2;
                int n11 = n3 * this.bytesPerLine + (n2 >> 1);
                boolean bl3 = bl2 = (n2 & 1) == 0;
                while (n10 > 0) {
                    int n12 = byArray[n6] & 0xF;
                    this.data[n11] = bl2 ? (byte)(this.data[n11] & 0xF | n12 << 4) : (byte)(this.data[n11] & 0xF0 | n12);
                    ++n6;
                    --n10;
                    if (++n7 >= this.width) {
                        n11 = ++n8 * this.bytesPerLine;
                        bl2 = true;
                        n7 = 0;
                        continue;
                    }
                    if (!bl2) {
                        ++n11;
                    }
                    bl2 = !bl2;
                }
                return;
            }
            case 2: {
                int n10;
                byte[] byArray2 = new byte[]{-4, -13, -49, 63};
                int n13 = n3 * this.bytesPerLine + (n2 >> 2);
                int n14 = 3 - n2 % 4;
                for (n10 = n4; n10 > 0; --n10) {
                    int n15 = byArray[n6] & 3;
                    this.data[n13] = (byte)(this.data[n13] & byArray2[n14] | n15 << n14 * 2);
                    ++n6;
                    if (++n7 >= this.width) {
                        n13 = ++n8 * this.bytesPerLine;
                        n14 = 0;
                        n7 = 0;
                        continue;
                    }
                    if (n14 == 0) {
                        ++n13;
                        n14 = 3;
                        continue;
                    }
                    --n14;
                }
                return;
            }
            case 1: {
                int n10;
                int n16 = n3 * this.bytesPerLine + (n2 >> 3);
                while (n10 > 0) {
                    int n17 = 1 << 7 - (n7 & 7);
                    this.data[n16] = (byArray[n6] & 1) == 1 ? (byte)(this.data[n16] & 0xFF | n17) : (byte)(this.data[n16] & 0xFF & ~n17);
                    ++n6;
                    --n10;
                    if (++n7 >= this.width) {
                        n16 = ++n8 * this.bytesPerLine;
                        n7 = 0;
                        continue;
                    }
                    if (n17 != 1) continue;
                    ++n16;
                }
                return;
            }
        }
        SWT.error(38);
    }

    public void setPixels(int n2, int n3, int n4, int[] nArray, int n5) {
        if (nArray == null) {
            SWT.error(4);
        }
        if (n4 < 0 || n2 >= this.width || n3 >= this.height || n2 < 0 || n3 < 0) {
            SWT.error(5);
        }
        if (n4 == 0) {
            return;
        }
        int n6 = n5;
        int n7 = n2;
        int n8 = n3;
        switch (this.depth) {
            case 32: {
                int n9 = n3 * this.bytesPerLine + n2 * 4;
                for (int i2 = 0; i2 < n4; ++i2) {
                    int n10 = nArray[n6];
                    this.data[n9] = (byte)(n10 >> 24 & 0xFF);
                    this.data[n9 + 1] = (byte)(n10 >> 16 & 0xFF);
                    this.data[n9 + 2] = (byte)(n10 >> 8 & 0xFF);
                    this.data[n9 + 3] = (byte)(n10 & 0xFF);
                    ++n6;
                    if (++n7 >= this.width) {
                        n9 = ++n8 * this.bytesPerLine;
                        n7 = 0;
                        continue;
                    }
                    n9 += 4;
                }
                return;
            }
            case 24: {
                int n11 = n3 * this.bytesPerLine + n2 * 3;
                for (int i3 = 0; i3 < n4; ++i3) {
                    int n12 = nArray[n6];
                    this.data[n11] = (byte)(n12 >> 16 & 0xFF);
                    this.data[n11 + 1] = (byte)(n12 >> 8 & 0xFF);
                    this.data[n11 + 2] = (byte)(n12 & 0xFF);
                    ++n6;
                    if (++n7 >= this.width) {
                        n11 = ++n8 * this.bytesPerLine;
                        n7 = 0;
                        continue;
                    }
                    n11 += 3;
                }
                return;
            }
            case 16: {
                int n13 = n3 * this.bytesPerLine + n2 * 2;
                for (int i4 = 0; i4 < n4; ++i4) {
                    int n14 = nArray[n6];
                    this.data[n13] = (byte)(n14 & 0xFF);
                    this.data[n13 + 1] = (byte)(n14 >> 8 & 0xFF);
                    ++n6;
                    if (++n7 >= this.width) {
                        n13 = ++n8 * this.bytesPerLine;
                        n7 = 0;
                        continue;
                    }
                    n13 += 2;
                }
                return;
            }
            case 8: {
                int n15 = n3 * this.bytesPerLine + n2;
                for (int i5 = 0; i5 < n4; ++i5) {
                    this.data[n15] = (byte)(nArray[n6] & 0xFF);
                    ++n6;
                    if (++n7 >= this.width) {
                        n15 = ++n8 * this.bytesPerLine;
                        n7 = 0;
                        continue;
                    }
                    ++n15;
                }
                return;
            }
            case 4: {
                int n16;
                boolean bl2;
                int n17 = n3 * this.bytesPerLine + (n2 >> 1);
                boolean bl3 = bl2 = (n2 & 1) == 0;
                while (n16 > 0) {
                    int n18 = nArray[n6] & 0xF;
                    this.data[n17] = bl2 ? (byte)(this.data[n17] & 0xF | n18 << 4) : (byte)(this.data[n17] & 0xF0 | n18);
                    ++n6;
                    --n16;
                    if (++n7 >= this.width) {
                        n17 = ++n8 * this.bytesPerLine;
                        bl2 = true;
                        n7 = 0;
                        continue;
                    }
                    if (!bl2) {
                        ++n17;
                    }
                    bl2 = !bl2;
                }
                return;
            }
            case 2: {
                int n16;
                byte[] byArray = new byte[]{-4, -13, -49, 63};
                int n19 = n3 * this.bytesPerLine + (n2 >> 2);
                int n20 = 3 - n2 % 4;
                for (n16 = n4; n16 > 0; --n16) {
                    int n21 = nArray[n6] & 3;
                    this.data[n19] = (byte)(this.data[n19] & byArray[n20] | n21 << n20 * 2);
                    ++n6;
                    if (++n7 >= this.width) {
                        n19 = ++n8 * this.bytesPerLine;
                        n20 = 3;
                        n7 = 0;
                        continue;
                    }
                    if (n20 == 0) {
                        ++n19;
                        n20 = 3;
                        continue;
                    }
                    --n20;
                }
                return;
            }
            case 1: {
                int n16;
                int n22 = n3 * this.bytesPerLine + (n2 >> 3);
                while (n16 > 0) {
                    int n23 = 1 << 7 - (n7 & 7);
                    this.data[n22] = (nArray[n6] & 1) == 1 ? (byte)(this.data[n22] & 0xFF | n23) : (byte)(this.data[n22] & 0xFF & ~n23);
                    ++n6;
                    --n16;
                    if (++n7 >= this.width) {
                        n22 = ++n8 * this.bytesPerLine;
                        n7 = 0;
                        continue;
                    }
                    if (n23 != 1) continue;
                    ++n22;
                }
                return;
            }
        }
        SWT.error(38);
    }

    static PaletteData bwPalette() {
        return new PaletteData(new RGB(0, 0, 0), new RGB(255, 255, 255));
    }

    static int getMSBOffset(int n2) {
        for (int i2 = 31; i2 >= 0; --i2) {
            if ((n2 >> i2 & 1) == 0) continue;
            return i2 + 1;
        }
        return 0;
    }

    static int closestMatch(int n2, byte by2, byte by3, byte by4, int n3, int n4, int n5, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (n2 > 8) {
            int n6 = 32 - ImageData.getMSBOffset(n3);
            int n7 = 32 - ImageData.getMSBOffset(n4);
            int n8 = 32 - ImageData.getMSBOffset(n5);
            return by2 << 24 >>> n6 & n3 | by3 << 24 >>> n7 & n4 | by4 << 24 >>> n8 & n5;
        }
        int n9 = Integer.MAX_VALUE;
        int n10 = 0;
        int n11 = byArray.length;
        for (int i2 = 0; i2 < n11; ++i2) {
            int n12 = (byArray[i2] & 0xFF) - (by2 & 0xFF);
            int n13 = (byArray2[i2] & 0xFF) - (by3 & 0xFF);
            int n14 = (byArray3[i2] & 0xFF) - (by4 & 0xFF);
            int n15 = n12 * n12 + n13 * n13 + n14 * n14;
            if (n15 >= n9) continue;
            n10 = i2;
            if (n15 == 0) break;
            n9 = n15;
        }
        return n10;
    }

    static final ImageData convertMask(ImageData imageData) {
        int n2;
        if (imageData.depth == 1) {
            return imageData;
        }
        PaletteData paletteData = new PaletteData(new RGB(0, 0, 0), new RGB(255, 255, 255));
        ImageData imageData2 = new ImageData(imageData.width, imageData.height, 1, paletteData);
        RGB[] rGBArray = imageData.getRGBs();
        if (rGBArray != null) {
            for (n2 = 0; n2 < rGBArray.length && !rGBArray[n2].equals(paletteData.colors[0]); ++n2) {
            }
        }
        int[] nArray = new int[imageData.width];
        for (int i2 = 0; i2 < imageData.height; ++i2) {
            imageData.getPixels(0, i2, imageData.width, nArray, 0);
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                nArray[i3] = nArray[i3] == n2 ? 0 : 1;
            }
            imageData2.setPixels(0, i2, imageData.width, nArray, 0);
        }
        return imageData2;
    }

    static final byte[] convertPad(byte[] byArray, int n2, int n3, int n4, int n5, int n6) {
        if (n5 == n6) {
            return byArray;
        }
        int n7 = (n2 * n4 + 7) / 8;
        int n8 = (n7 + (n5 - 1)) / n5 * n5;
        int n9 = (n7 + (n6 - 1)) / n6 * n6;
        byte[] byArray2 = new byte[n3 * n9];
        int n10 = 0;
        int n11 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            System.arraycopy(byArray, n10, byArray2, n11, n7);
            n10 += n8;
            n11 += n9;
        }
        return byArray2;
    }

    static void blit(int n2, byte[] byArray, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, byte[] byArray2, int n14, int n15, int n16, byte[] byArray3, int n17, int n18, int n19, int n20, int n21, int n22, int n23, int n24, int n25, int n26, boolean bl2, boolean bl3) {
        int n27;
        int n28;
        int n29;
        int n30;
        int n31;
        int n32;
        if (n22 <= 0 || n23 <= 0 || n13 == 0) {
            return;
        }
        int n33 = 0;
        int n34 = 0;
        int n35 = n22 - 1;
        int n36 = n35 != 0 ? (int)((((long)n8 << 16) - 1L) / (long)n35) : 0;
        int n37 = n23 - 1;
        int n38 = n37 != 0 ? (int)((((long)n9 << 16) - 1L) / (long)n37) : 0;
        switch (n3) {
            case 8: {
                n32 = 1;
                n31 = 0;
                break;
            }
            case 16: {
                n32 = 2;
                n31 = n5 == 1 ? 1 : 2;
                break;
            }
            case 24: {
                n32 = 3;
                n31 = 3;
                break;
            }
            case 32: {
                n32 = 4;
                n31 = n5 == 1 ? 4 : 5;
                break;
            }
            default: {
                return;
            }
        }
        int n39 = n7 * n4 + n6 * n32;
        switch (n17) {
            case 8: {
                n30 = 1;
                n29 = 0;
                break;
            }
            case 16: {
                n30 = 2;
                n29 = n19 == 1 ? 1 : 2;
                break;
            }
            case 24: {
                n30 = 3;
                n29 = 3;
                break;
            }
            case 32: {
                n30 = 4;
                n29 = n19 == 1 ? 4 : 5;
                break;
            }
            default: {
                return;
            }
        }
        int n40 = (bl3 ? n21 + n37 : n21) * n18 + (bl2 ? n20 + n35 : n20) * n30;
        int n41 = bl2 ? -n30 : n30;
        int n42 = n28 = bl3 ? -n18 : n18;
        if ((n2 & 2) != 0) {
            switch (n13) {
                case -3: 
                case -1: {
                    if (byArray2 == null) {
                        n13 = 65536;
                    }
                    n27 = n16 * n14 + n15;
                    break;
                }
                case -4: {
                    if (byArray2 == null) {
                        n13 = 65536;
                    }
                    n27 = n16 * (n14 <<= 3) + n15;
                    break;
                }
                case -5: {
                    return;
                }
                case -6: {
                    if (byArray2 == null) {
                        n13 = 65536;
                    }
                    n27 = 0;
                    break;
                }
                default: {
                    n13 = (n13 << 16) / 255;
                }
                case -2: {
                    n27 = 0;
                    break;
                }
            }
        } else {
            n13 = 65536;
            n27 = 0;
        }
        int n43 = n40;
        int n44 = n39;
        if (n13 == 65536 && n31 == n29 && n10 == n24 && n11 == n25 && n12 == n26 && n33 == n34) {
            switch (n32) {
                case 1: {
                    int n45 = n38;
                    for (int i2 = n23; i2 > 0; --i2) {
                        int n46 = n22;
                        int n47 = n36;
                        while (n46 > 0) {
                            byArray3[n43] = byArray[n44];
                            n44 += n47 >>> 16;
                            --n46;
                            n43 += n41;
                            n47 = (n47 & 0xFFFF) + n36;
                        }
                        n44 = n39 += (n45 >>> 16) * n4;
                        n45 = (n45 & 0xFFFF) + n38;
                        n43 = n40 += n28;
                    }
                    break;
                }
                case 2: {
                    int n48 = n38;
                    for (int i3 = n23; i3 > 0; --i3) {
                        int n49 = n22;
                        int n50 = n36;
                        while (n49 > 0) {
                            byArray3[n43] = byArray[n44];
                            byArray3[n43 + 1] = byArray[n44 + 1];
                            n44 += (n50 >>> 16) * 2;
                            --n49;
                            n43 += n41;
                            n50 = (n50 & 0xFFFF) + n36;
                        }
                        n44 = n39 += (n48 >>> 16) * n4;
                        n48 = (n48 & 0xFFFF) + n38;
                        n43 = n40 += n28;
                    }
                    break;
                }
                case 3: {
                    int n51 = n38;
                    for (int i4 = n23; i4 > 0; --i4) {
                        int n52 = n22;
                        int n53 = n36;
                        while (n52 > 0) {
                            byArray3[n43] = byArray[n44];
                            byArray3[n43 + 1] = byArray[n44 + 1];
                            byArray3[n43 + 2] = byArray[n44 + 2];
                            n44 += (n53 >>> 16) * 3;
                            --n52;
                            n43 += n41;
                            n53 = (n53 & 0xFFFF) + n36;
                        }
                        n44 = n39 += (n51 >>> 16) * n4;
                        n51 = (n51 & 0xFFFF) + n38;
                        n43 = n40 += n28;
                    }
                    break;
                }
                case 4: {
                    int n54 = n38;
                    for (int i5 = n23; i5 > 0; --i5) {
                        int n55 = n22;
                        int n56 = n36;
                        while (n55 > 0) {
                            byArray3[n43] = byArray[n44];
                            byArray3[n43 + 1] = byArray[n44 + 1];
                            byArray3[n43 + 2] = byArray[n44 + 2];
                            byArray3[n43 + 3] = byArray[n44 + 3];
                            n44 += (n56 >>> 16) * 4;
                            --n55;
                            n43 += n41;
                            n56 = (n56 & 0xFFFF) + n36;
                        }
                        n44 = n39 += (n54 >>> 16) * n4;
                        n54 = (n54 & 0xFFFF) + n38;
                        n43 = n40 += n28;
                    }
                    break;
                }
            }
            return;
        }
        if (n13 == 65536 && n31 == 4 && n29 == 4 && n10 == 65280 && n11 == 0xFF0000 && n12 == -16777216 && n24 == 0xFF0000 && n25 == 65280 && n26 == 255) {
            int n57 = n38;
            for (int i6 = n23; i6 > 0; --i6) {
                int n58 = n22;
                int n59 = n36;
                while (n58 > 0) {
                    byArray3[n43] = byArray[n44 + 3];
                    byArray3[n43 + 1] = byArray[n44 + 2];
                    byArray3[n43 + 2] = byArray[n44 + 1];
                    byArray3[n43 + 3] = byArray[n44];
                    n44 += (n59 >>> 16) * 4;
                    --n58;
                    n43 += n41;
                    n59 = (n59 & 0xFFFF) + n36;
                }
                n44 = n39 += (n57 >>> 16) * n4;
                n57 = (n57 & 0xFFFF) + n38;
                n43 = n40 += n28;
            }
            return;
        }
        if (n13 == 65536 && n31 == 3 && n29 == 4 && n10 == 255 && n11 == 65280 && n12 == 0xFF0000 && n24 == 0xFF0000 && n25 == 65280 && n26 == 255) {
            int n60 = n38;
            for (int i7 = n23; i7 > 0; --i7) {
                int n61 = n22;
                int n62 = n36;
                while (n61 > 0) {
                    byArray3[n43] = 0;
                    byArray3[n43 + 1] = byArray[n44 + 2];
                    byArray3[n43 + 2] = byArray[n44 + 1];
                    byArray3[n43 + 3] = byArray[n44];
                    n44 += (n62 >>> 16) * 3;
                    --n61;
                    n43 += n41;
                    n62 = (n62 & 0xFFFF) + n36;
                }
                n44 = n39 += (n60 >>> 16) * n4;
                n60 = (n60 & 0xFFFF) + n38;
                n43 = n40 += n28;
            }
            return;
        }
        int n63 = ImageData.getChannelShift(n10);
        byte[] byArray4 = ANY_TO_EIGHT[ImageData.getChannelWidth(n10, n63)];
        int n64 = ImageData.getChannelShift(n11);
        byte[] byArray5 = ANY_TO_EIGHT[ImageData.getChannelWidth(n11, n64)];
        int n65 = ImageData.getChannelShift(n12);
        byte[] byArray6 = ANY_TO_EIGHT[ImageData.getChannelWidth(n12, n65)];
        int n66 = ImageData.getChannelShift(n33);
        byte[] byArray7 = ANY_TO_EIGHT[ImageData.getChannelWidth(n33, n66)];
        int n67 = ImageData.getChannelShift(n24);
        int n68 = ImageData.getChannelWidth(n24, n67);
        byte[] byArray8 = ANY_TO_EIGHT[n68];
        int n69 = 8 - n68;
        int n70 = ImageData.getChannelShift(n25);
        int n71 = ImageData.getChannelWidth(n25, n70);
        byte[] byArray9 = ANY_TO_EIGHT[n71];
        int n72 = 8 - n71;
        int n73 = ImageData.getChannelShift(n26);
        int n74 = ImageData.getChannelWidth(n26, n73);
        byte[] byArray10 = ANY_TO_EIGHT[n74];
        int n75 = 8 - n74;
        int n76 = ImageData.getChannelShift(n34);
        int n77 = ImageData.getChannelWidth(n34, n76);
        byte[] byArray11 = ANY_TO_EIGHT[n77];
        int n78 = 8 - n77;
        int n79 = n27;
        int n80 = n13;
        int n81 = 0;
        int n82 = 0;
        int n83 = 0;
        int n84 = 0;
        int n85 = 0;
        int n86 = 0;
        int n87 = 0;
        int n88 = 0;
        int n89 = n38;
        for (int i8 = n23; i8 > 0; --i8) {
            int n90 = n22;
            int n91 = n36;
            while (n90 > 0) {
                block84: {
                    int n92;
                    block83: {
                        switch (n31) {
                            case 0: {
                                n92 = byArray[n44] & 0xFF;
                                n44 += n91 >>> 16;
                                n81 = byArray4[(n92 & n10) >>> n63] & 0xFF;
                                n82 = byArray5[(n92 & n11) >>> n64] & 0xFF;
                                n83 = byArray6[(n92 & n12) >>> n65] & 0xFF;
                                n84 = byArray7[(n92 & n33) >>> n66] & 0xFF;
                                break;
                            }
                            case 1: {
                                n92 = (byArray[n44] & 0xFF) << 8 | byArray[n44 + 1] & 0xFF;
                                n44 += (n91 >>> 16) * 2;
                                n81 = byArray4[(n92 & n10) >>> n63] & 0xFF;
                                n82 = byArray5[(n92 & n11) >>> n64] & 0xFF;
                                n83 = byArray6[(n92 & n12) >>> n65] & 0xFF;
                                n84 = byArray7[(n92 & n33) >>> n66] & 0xFF;
                                break;
                            }
                            case 2: {
                                n92 = (byArray[n44 + 1] & 0xFF) << 8 | byArray[n44] & 0xFF;
                                n44 += (n91 >>> 16) * 2;
                                n81 = byArray4[(n92 & n10) >>> n63] & 0xFF;
                                n82 = byArray5[(n92 & n11) >>> n64] & 0xFF;
                                n83 = byArray6[(n92 & n12) >>> n65] & 0xFF;
                                n84 = byArray7[(n92 & n33) >>> n66] & 0xFF;
                                break;
                            }
                            case 3: {
                                n92 = ((byArray[n44] & 0xFF) << 8 | byArray[n44 + 1] & 0xFF) << 8 | byArray[n44 + 2] & 0xFF;
                                n44 += (n91 >>> 16) * 3;
                                n81 = byArray4[(n92 & n10) >>> n63] & 0xFF;
                                n82 = byArray5[(n92 & n11) >>> n64] & 0xFF;
                                n83 = byArray6[(n92 & n12) >>> n65] & 0xFF;
                                n84 = byArray7[(n92 & n33) >>> n66] & 0xFF;
                                break;
                            }
                            case 4: {
                                n92 = (((byArray[n44] & 0xFF) << 8 | byArray[n44 + 1] & 0xFF) << 8 | byArray[n44 + 2] & 0xFF) << 8 | byArray[n44 + 3] & 0xFF;
                                n44 += (n91 >>> 16) * 4;
                                n81 = byArray4[(n92 & n10) >>> n63] & 0xFF;
                                n82 = byArray5[(n92 & n11) >>> n64] & 0xFF;
                                n83 = byArray6[(n92 & n12) >>> n65] & 0xFF;
                                n84 = byArray7[(n92 & n33) >>> n66] & 0xFF;
                                break;
                            }
                            case 5: {
                                n92 = (((byArray[n44 + 3] & 0xFF) << 8 | byArray[n44 + 2] & 0xFF) << 8 | byArray[n44 + 1] & 0xFF) << 8 | byArray[n44] & 0xFF;
                                n44 += (n91 >>> 16) * 4;
                                n81 = byArray4[(n92 & n10) >>> n63] & 0xFF;
                                n82 = byArray5[(n92 & n11) >>> n64] & 0xFF;
                                n83 = byArray6[(n92 & n12) >>> n65] & 0xFF;
                                n84 = byArray7[(n92 & n33) >>> n66] & 0xFF;
                            }
                        }
                        block33 : switch (n13) {
                            case -1: {
                                n80 = ((byArray2[n79] & 0xFF) << 16) / 255;
                                n79 += n91 >> 16;
                                break;
                            }
                            case -2: {
                                n80 = (n84 << 16) / 255;
                                break;
                            }
                            case -3: {
                                n80 = byArray2[n79] != 0 ? 65536 : 0;
                                n79 += n91 >> 16;
                                break;
                            }
                            case -4: {
                                n80 = byArray2[n79 >> 3] << (n79 & 7) + 9 & 0x10000;
                                n79 += n91 >> 16;
                                break;
                            }
                            case -6: {
                                n80 = 65536;
                                for (n92 = 0; n92 < byArray2.length; n92 += 3) {
                                    if (n81 != byArray2[n92] || n82 != byArray2[n92 + 1] || n83 != byArray2[n92 + 2]) continue;
                                    n80 = 0;
                                    break block33;
                                }
                                break;
                            }
                        }
                        if (n80 == 65536) break block83;
                        if (n80 == 0) break block84;
                        switch (n29) {
                            case 0: {
                                n92 = byArray3[n43] & 0xFF;
                                n85 = byArray8[(n92 & n24) >>> n67] & 0xFF;
                                n86 = byArray9[(n92 & n25) >>> n70] & 0xFF;
                                n87 = byArray10[(n92 & n26) >>> n73] & 0xFF;
                                n88 = byArray11[(n92 & n34) >>> n76] & 0xFF;
                                break;
                            }
                            case 1: {
                                n92 = (byArray3[n43] & 0xFF) << 8 | byArray3[n43 + 1] & 0xFF;
                                n85 = byArray8[(n92 & n24) >>> n67] & 0xFF;
                                n86 = byArray9[(n92 & n25) >>> n70] & 0xFF;
                                n87 = byArray10[(n92 & n26) >>> n73] & 0xFF;
                                n88 = byArray11[(n92 & n34) >>> n76] & 0xFF;
                                break;
                            }
                            case 2: {
                                n92 = (byArray3[n43 + 1] & 0xFF) << 8 | byArray3[n43] & 0xFF;
                                n85 = byArray8[(n92 & n24) >>> n67] & 0xFF;
                                n86 = byArray9[(n92 & n25) >>> n70] & 0xFF;
                                n87 = byArray10[(n92 & n26) >>> n73] & 0xFF;
                                n88 = byArray11[(n92 & n34) >>> n76] & 0xFF;
                                break;
                            }
                            case 3: {
                                n92 = ((byArray3[n43] & 0xFF) << 8 | byArray3[n43 + 1] & 0xFF) << 8 | byArray3[n43 + 2] & 0xFF;
                                n85 = byArray8[(n92 & n24) >>> n67] & 0xFF;
                                n86 = byArray9[(n92 & n25) >>> n70] & 0xFF;
                                n87 = byArray10[(n92 & n26) >>> n73] & 0xFF;
                                n88 = byArray11[(n92 & n34) >>> n76] & 0xFF;
                                break;
                            }
                            case 4: {
                                n92 = (((byArray3[n43] & 0xFF) << 8 | byArray3[n43 + 1] & 0xFF) << 8 | byArray3[n43 + 2] & 0xFF) << 8 | byArray3[n43 + 3] & 0xFF;
                                n85 = byArray8[(n92 & n24) >>> n67] & 0xFF;
                                n86 = byArray9[(n92 & n25) >>> n70] & 0xFF;
                                n87 = byArray10[(n92 & n26) >>> n73] & 0xFF;
                                n88 = byArray11[(n92 & n34) >>> n76] & 0xFF;
                                break;
                            }
                            case 5: {
                                n92 = (((byArray3[n43 + 3] & 0xFF) << 8 | byArray3[n43 + 2] & 0xFF) << 8 | byArray3[n43 + 1] & 0xFF) << 8 | byArray3[n43] & 0xFF;
                                n85 = byArray8[(n92 & n24) >>> n67] & 0xFF;
                                n86 = byArray9[(n92 & n25) >>> n70] & 0xFF;
                                n87 = byArray10[(n92 & n26) >>> n73] & 0xFF;
                                n88 = byArray11[(n92 & n34) >>> n76] & 0xFF;
                            }
                        }
                        n84 = n88 + ((n84 - n88) * n80 >> 16);
                        n81 = n85 + ((n81 - n85) * n80 >> 16);
                        n82 = n86 + ((n82 - n86) * n80 >> 16);
                        n83 = n87 + ((n83 - n87) * n80 >> 16);
                    }
                    n92 = n81 >>> n69 << n67 | n82 >>> n72 << n70 | n83 >>> n75 << n73 | n84 >>> n78 << n76;
                    switch (n29) {
                        case 0: {
                            byArray3[n43] = (byte)n92;
                            break;
                        }
                        case 1: {
                            byArray3[n43] = (byte)(n92 >>> 8);
                            byArray3[n43 + 1] = (byte)(n92 & 0xFF);
                            break;
                        }
                        case 2: {
                            byArray3[n43] = (byte)(n92 & 0xFF);
                            byArray3[n43 + 1] = (byte)(n92 >>> 8);
                            break;
                        }
                        case 3: {
                            byArray3[n43] = (byte)(n92 >>> 16);
                            byArray3[n43 + 1] = (byte)(n92 >>> 8);
                            byArray3[n43 + 2] = (byte)(n92 & 0xFF);
                            break;
                        }
                        case 4: {
                            byArray3[n43] = (byte)(n92 >>> 24);
                            byArray3[n43 + 1] = (byte)(n92 >>> 16);
                            byArray3[n43 + 2] = (byte)(n92 >>> 8);
                            byArray3[n43 + 3] = (byte)(n92 & 0xFF);
                            break;
                        }
                        case 5: {
                            byArray3[n43] = (byte)(n92 & 0xFF);
                            byArray3[n43 + 1] = (byte)(n92 >>> 8);
                            byArray3[n43 + 2] = (byte)(n92 >>> 16);
                            byArray3[n43 + 3] = (byte)(n92 >>> 24);
                        }
                    }
                }
                --n90;
                n43 += n41;
                n91 = (n91 & 0xFFFF) + n36;
            }
            n44 = n39 += (n89 >>> 16) * n4;
            n79 = n27 += (n89 >>> 16) * n14;
            n89 = (n89 & 0xFFFF) + n38;
            n43 = n40 += n28;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static void blit(int n2, byte[] byArray, int n3, int n4, int n5, int n6, int n7, int n8, int n9, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n10, byte[] byArray5, int n11, int n12, int n13, byte[] byArray6, int n14, int n15, int n16, int n17, int n18, int n19, int n20, byte[] byArray7, byte[] byArray8, byte[] byArray9, boolean bl2, boolean bl3) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int n21;
        int n22;
        int n23;
        int n24;
        int n25;
        int n26;
        int n27;
        int n28;
        int n29;
        int n30;
        int n31;
        int n32;
        int n33;
        boolean bl4;
        int n34;
        int n35;
        int n36;
        int n37;
        int n38;
        int n39;
        block132: {
            int n40;
            int n41;
            byte[] byArray10;
            block133: {
                int n42;
                if (n19 <= 0) return;
                if (n20 <= 0) return;
                if (n10 == 0) {
                    return;
                }
                int n43 = n19 - 1;
                n39 = n43 != 0 ? (int)((((long)n8 << 16) - 1L) / (long)n43) : 0;
                int n44 = n20 - 1;
                n38 = n44 != 0 ? (int)((((long)n9 << 16) - 1L) / (long)n44) : 0;
                switch (n3) {
                    case 8: {
                        n37 = 6;
                        break;
                    }
                    case 4: {
                        n4 <<= 1;
                        n37 = 7;
                        break;
                    }
                    case 2: {
                        n4 <<= 2;
                        n37 = 8;
                        break;
                    }
                    case 1: {
                        n4 <<= 3;
                        n37 = n5 == 1 ? 9 : 10;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                int n45 = n7 * n4 + n6;
                switch (n14) {
                    case 8: {
                        n36 = 6;
                        break;
                    }
                    case 4: {
                        n15 <<= 1;
                        n36 = 7;
                        break;
                    }
                    case 2: {
                        n15 <<= 2;
                        n36 = 8;
                        break;
                    }
                    case 1: {
                        n15 <<= 3;
                        n36 = n16 == 1 ? 9 : 10;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                int n46 = (bl3 ? n18 + n44 : n18) * n15 + (bl2 ? n17 + n43 : n17);
                n35 = bl2 ? -1 : 1;
                int n47 = n34 = bl3 ? -n15 : n15;
                if ((n2 & 2) != 0) {
                    switch (n10) {
                        case -3: 
                        case -1: {
                            if (byArray5 == null) {
                                n10 = 65536;
                            }
                            n42 = n13 * n11 + n12;
                            break;
                        }
                        case -4: {
                            if (byArray5 == null) {
                                n10 = 65536;
                            }
                            n42 = n13 * (n11 <<= 3) + n12;
                            break;
                        }
                        case -6: 
                        case -5: {
                            if (byArray5 == null) {
                                n10 = 65536;
                            }
                            n42 = 0;
                            break;
                        }
                        default: {
                            n10 = (n10 << 16) / 255;
                        }
                        case -2: {
                            n42 = 0;
                            break;
                        }
                    }
                } else {
                    n10 = 65536;
                    n42 = 0;
                }
                bl4 = (n2 & 4) != 0;
                n33 = n46;
                n32 = n45;
                n31 = n42;
                n30 = 1 << n14;
                if (byArray7 != null && byArray7.length < n30) {
                    n30 = byArray7.length;
                }
                byArray10 = null;
                boolean bl5 = true;
                switch (n10) {
                    case 65536: {
                        if (n37 == n36 && byArray2 == byArray7 && byArray3 == byArray8 && byArray4 == byArray9) {
                            byArray10 = ONE_TO_ONE_MAPPING;
                            break;
                        }
                        if (byArray2 == null || byArray7 == null) {
                            if (n3 <= n14) {
                                byArray10 = ONE_TO_ONE_MAPPING;
                                break;
                            }
                            byArray10 = new byte[1 << n3];
                            n29 = 255 << n14 >>> 8;
                            for (n28 = 0; n28 < byArray10.length; ++n28) {
                                byArray10[n28] = (byte)(n28 & n29);
                            }
                            break;
                        }
                    }
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: {
                        n29 = 1 << n3;
                        byArray10 = new byte[n29];
                        if (byArray2 != null && byArray2.length < n29) {
                            n29 = byArray2.length;
                        }
                        for (n28 = 0; n28 < n29; ++n28) {
                            n27 = byArray2[n28] & 0xFF;
                            n26 = byArray3[n28] & 0xFF;
                            n25 = byArray4[n28] & 0xFF;
                            n24 = 0;
                            n23 = Integer.MAX_VALUE;
                            for (n41 = 0; n41 < n30; ++n41) {
                                n40 = (byArray7[n41] & 0xFF) - n27;
                                int n48 = (byArray8[n41] & 0xFF) - n26;
                                n22 = (byArray9[n41] & 0xFF) - n25;
                                n21 = n40 * n40 + n48 * n48 + n22 * n22;
                                if (n21 >= n23) continue;
                                n24 = n41;
                                if (n21 == 0) break;
                                n23 = n21;
                            }
                            byArray10[n28] = (byte)n24;
                            if (n23 == 0) continue;
                            bl5 = false;
                        }
                        break;
                    }
                }
                if (byArray10 != null && (bl5 || !bl4)) break block133;
                n29 = n10;
                n28 = 0;
                n27 = 0;
                n26 = 0;
                n25 = -1;
                n24 = -1;
                n23 = -1;
                if (bl4) {
                    nArray3 = new int[n19 + 2];
                    nArray2 = new int[n19 + 2];
                    nArray = new int[n19 + 2];
                    break block132;
                } else {
                    nArray3 = null;
                    nArray2 = null;
                    nArray = null;
                }
                break block132;
            }
            if (n37 == n36 && n10 == 65536) {
                switch (n37) {
                    case 6: {
                        n29 = n20;
                        n28 = n38;
                        while (n29 > 0) {
                            n26 = n39;
                            for (n27 = n19; n27 > 0; n32 += n26 >>> 16, --n27, n33 += n35) {
                                byArray6[n33] = byArray10[byArray[n32] & 0xFF];
                                n26 = (n26 & 0xFFFF) + n39;
                            }
                            --n29;
                            n32 = n45 += (n28 >>> 16) * n4;
                            n28 = (n28 & 0xFFFF) + n38;
                            n33 = n46 += n34;
                        }
                        return;
                    }
                    case 7: {
                        n29 = n20;
                        n28 = n38;
                        while (n29 > 0) {
                            n26 = n39;
                            for (n27 = n19; n27 > 0; n32 += n26 >>> 16, --n27, n33 += n35) {
                                n25 = (n32 & 1) != 0 ? byArray10[byArray[n32 >> 1] & 0xF] : byArray[n32 >> 1] >>> 4 & 0xF;
                                byArray6[n33 >> 1] = (n33 & 1) != 0 ? (byte)(byArray6[n33 >> 1] & 0xF0 | n25) : (byte)(byArray6[n33 >> 1] & 0xF | n25 << 4);
                                n26 = (n26 & 0xFFFF) + n39;
                            }
                            --n29;
                            n32 = n45 += (n28 >>> 16) * n4;
                            n28 = (n28 & 0xFFFF) + n38;
                            n33 = n46 += n34;
                        }
                        return;
                    }
                    case 8: {
                        n29 = n20;
                        n28 = n38;
                        while (n29 > 0) {
                            n26 = n39;
                            for (n27 = n19; n27 > 0; n32 += n26 >>> 16, --n27, n33 += n35) {
                                n25 = byArray10[byArray[n32 >> 2] >>> 6 - (n32 & 3) * 2 & 3];
                                n24 = 6 - (n33 & 3) * 2;
                                byArray6[n33 >> 2] = (byte)(byArray6[n33 >> 2] & ~(3 << n24) | n25 << n24);
                                n26 = (n26 & 0xFFFF) + n39;
                            }
                            --n29;
                            n32 = n45 += (n28 >>> 16) * n4;
                            n28 = (n28 & 0xFFFF) + n38;
                            n33 = n46 += n34;
                        }
                        return;
                    }
                    case 9: {
                        n29 = n20;
                        n28 = n38;
                        while (n29 > 0) {
                            n26 = n39;
                            for (n27 = n19; n27 > 0; n32 += n26 >>> 16, --n27, n33 += n35) {
                                n25 = byArray10[byArray[n32 >> 3] >>> 7 - (n32 & 7) & 1];
                                n24 = 7 - (n33 & 7);
                                byArray6[n33 >> 3] = (byte)(byArray6[n33 >> 3] & ~(1 << n24) | n25 << n24);
                                n26 = (n26 & 0xFFFF) + n39;
                            }
                            --n29;
                            n32 = n45 += (n28 >>> 16) * n4;
                            n28 = (n28 & 0xFFFF) + n38;
                            n33 = n46 += n34;
                        }
                        return;
                    }
                    case 10: {
                        n29 = n20;
                        n28 = n38;
                        while (n29 > 0) {
                            n26 = n39;
                            for (n27 = n19; n27 > 0; n32 += n26 >>> 16, --n27, n33 += n35) {
                                n25 = byArray10[byArray[n32 >> 3] >>> (n32 & 7) & 1];
                                n24 = n33 & 7;
                                byArray6[n33 >> 3] = (byte)(byArray6[n33 >> 3] & ~(1 << n24) | n25 << n24);
                                n26 = (n26 & 0xFFFF) + n39;
                            }
                            --n29;
                            n32 = n45 += (n28 >>> 16) * n4;
                            n28 = (n28 & 0xFFFF) + n38;
                            n33 = n46 += n34;
                        }
                        return;
                    }
                }
                return;
            }
            n29 = n20;
            n28 = n38;
            while (n29 > 0) {
                n26 = n39;
                for (n27 = n19; n27 > 0; --n27, n33 += n35) {
                    block134: {
                        switch (n37) {
                            case 6: {
                                n25 = byArray[n32] & 0xFF;
                                n32 += n26 >>> 16;
                                break;
                            }
                            case 7: {
                                n25 = (n32 & 1) != 0 ? byArray[n32 >> 1] & 0xF : byArray[n32 >> 1] >>> 4 & 0xF;
                                n32 += n26 >>> 16;
                                break;
                            }
                            case 8: {
                                n25 = byArray[n32 >> 2] >>> 6 - (n32 & 3) * 2 & 3;
                                n32 += n26 >>> 16;
                                break;
                            }
                            case 9: {
                                n25 = byArray[n32 >> 3] >>> 7 - (n32 & 7) & 1;
                                n32 += n26 >>> 16;
                                break;
                            }
                            case 10: {
                                n25 = byArray[n32 >> 3] >>> (n32 & 7) & 1;
                                n32 += n26 >>> 16;
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                        switch (n10) {
                            case -3: {
                                n24 = byArray5[n31];
                                n31 += n26 >> 16;
                                if (n24 != 0) break;
                                break block134;
                            }
                            case -4: {
                                n24 = byArray5[n31 >> 3] & 1 << (n31 & 7);
                                n31 += n26 >> 16;
                                if (n24 != 0) break;
                                break block134;
                            }
                            case -5: {
                                n24 = 0;
                                while (n24 < byArray5.length && n25 != (byArray5[n24] & 0xFF)) {
                                }
                                if (n24 >= byArray5.length) break;
                                break block134;
                            }
                            case -6: {
                                n24 = byArray2[n25];
                                n23 = byArray3[n25];
                                n41 = byArray4[n25];
                                for (n40 = 0; n40 < byArray5.length && (n24 != byArray5[n40] || n23 != byArray5[n40 + 1] || n41 != byArray5[n40 + 2]); n40 += 3) {
                                }
                                if (n40 < byArray5.length) break block134;
                            }
                        }
                        n25 = byArray10[n25] & 0xFF;
                        switch (n36) {
                            case 6: {
                                byArray6[n33] = (byte)n25;
                                break;
                            }
                            case 7: {
                                if ((n33 & 1) != 0) {
                                    byArray6[n33 >> 1] = (byte)(byArray6[n33 >> 1] & 0xF0 | n25);
                                    break;
                                }
                                byArray6[n33 >> 1] = (byte)(byArray6[n33 >> 1] & 0xF | n25 << 4);
                                break;
                            }
                            case 8: {
                                n24 = 6 - (n33 & 3) * 2;
                                byArray6[n33 >> 2] = (byte)(byArray6[n33 >> 2] & ~(3 << n24) | n25 << n24);
                                break;
                            }
                            case 9: {
                                n24 = 7 - (n33 & 7);
                                byArray6[n33 >> 3] = (byte)(byArray6[n33 >> 3] & ~(1 << n24) | n25 << n24);
                                break;
                            }
                            case 10: {
                                n24 = n33 & 7;
                                byArray6[n33 >> 3] = (byte)(byArray6[n33 >> 3] & ~(1 << n24) | n25 << n24);
                                break;
                            }
                        }
                    }
                    n26 = (n26 & 0xFFFF) + n39;
                }
                --n29;
                n32 = n45 += (n28 >>> 16) * n4;
                n28 = (n28 & 0xFFFF) + n38;
                n33 = n46 += n34;
            }
            return;
        }
        n22 = n20;
        n21 = n38;
        while (n22 > 0) {
            int n49 = 0;
            int n50 = 0;
            int n51 = 0;
            int n52 = n39;
            for (int i2 = n19; i2 > 0; --i2, n33 += n35) {
                block135: {
                    int n53;
                    int n54;
                    int n55;
                    int n56;
                    int n57;
                    int n58;
                    block136: {
                        switch (n37) {
                            case 6: {
                                n28 = byArray[n32] & 0xFF;
                                n32 += n52 >>> 16;
                                break;
                            }
                            case 7: {
                                n28 = (n32 & 1) != 0 ? byArray[n32 >> 1] & 0xF : byArray[n32 >> 1] >>> 4 & 0xF;
                                n32 += n52 >>> 16;
                                break;
                            }
                            case 8: {
                                n28 = byArray[n32 >> 2] >>> 6 - (n32 & 3) * 2 & 3;
                                n32 += n52 >>> 16;
                                break;
                            }
                            case 9: {
                                n28 = byArray[n32 >> 3] >>> 7 - (n32 & 7) & 1;
                                n32 += n52 >>> 16;
                                break;
                            }
                            case 10: {
                                n28 = byArray[n32 >> 3] >>> (n32 & 7) & 1;
                                n32 += n52 >>> 16;
                                break;
                            }
                        }
                        n58 = byArray2[n28] & 0xFF;
                        n57 = byArray3[n28] & 0xFF;
                        n56 = byArray4[n28] & 0xFF;
                        switch (n10) {
                            case -1: {
                                n29 = ((byArray5[n31] & 0xFF) << 16) / 255;
                                n31 += n52 >> 16;
                                break;
                            }
                            case -3: {
                                n29 = byArray5[n31] != 0 ? 65536 : 0;
                                n31 += n52 >> 16;
                                break;
                            }
                            case -4: {
                                n29 = byArray5[n31 >> 3] << (n31 & 7) + 9 & 0x10000;
                                n31 += n52 >> 16;
                                break;
                            }
                            case -5: {
                                n55 = 0;
                                while (n55 < byArray5.length && n28 != (byArray5[n55] & 0xFF)) {
                                }
                                if (n55 >= byArray5.length) break;
                                break block135;
                            }
                            case -6: {
                                for (n55 = 0; n55 < byArray5.length && (n58 != (byArray5[n55] & 0xFF) || n57 != (byArray5[n55 + 1] & 0xFF) || n56 != (byArray5[n55 + 2] & 0xFF)); n55 += 3) {
                                }
                                if (n55 < byArray5.length) break block135;
                            }
                        }
                        if (n29 == 65536) break block136;
                        if (n29 == 0) break block135;
                        switch (n36) {
                            case 6: {
                                n27 = byArray6[n33] & 0xFF;
                                break;
                            }
                            case 7: {
                                if ((n33 & 1) != 0) {
                                    n27 = byArray6[n33 >> 1] & 0xF;
                                    break;
                                }
                                n27 = byArray6[n33 >> 1] >>> 4 & 0xF;
                                break;
                            }
                            case 8: {
                                n27 = byArray6[n33 >> 2] >>> 6 - (n33 & 3) * 2 & 3;
                                break;
                            }
                            case 9: {
                                n27 = byArray6[n33 >> 3] >>> 7 - (n33 & 7) & 1;
                                break;
                            }
                            case 10: {
                                n27 = byArray6[n33 >> 3] >>> (n33 & 7) & 1;
                                break;
                            }
                        }
                        n55 = byArray7[n27] & 0xFF;
                        n54 = byArray8[n27] & 0xFF;
                        n53 = byArray9[n27] & 0xFF;
                        n58 = n55 + ((n58 - n55) * n29 >> 16);
                        n57 = n54 + ((n57 - n54) * n29 >> 16);
                        n56 = n53 + ((n56 - n53) * n29 >> 16);
                    }
                    if (bl4) {
                        if ((n58 += nArray3[i2] >> 4) < 0) {
                            n58 = 0;
                        } else if (n58 > 255) {
                            n58 = 255;
                        }
                        if ((n57 += nArray2[i2] >> 4) < 0) {
                            n57 = 0;
                        } else if (n57 > 255) {
                            n57 = 255;
                        }
                        if ((n56 += nArray[i2] >> 4) < 0) {
                            n56 = 0;
                        } else if (n56 > 255) {
                            n56 = 255;
                        }
                        nArray3[i2] = n49;
                        nArray2[i2] = n50;
                        nArray[i2] = n51;
                    }
                    if (n58 != n25 || n57 != n24 || n56 != n23) {
                        int n59 = Integer.MAX_VALUE;
                        for (n55 = 0; n55 < n30; ++n55) {
                            n54 = (byArray7[n55] & 0xFF) - n58;
                            n53 = (byArray8[n55] & 0xFF) - n57;
                            int n60 = (byArray9[n55] & 0xFF) - n56;
                            int n61 = n54 * n54 + n53 * n53 + n60 * n60;
                            if (n61 >= n59) continue;
                            n26 = n55;
                            if (n61 == 0) break;
                            n59 = n61;
                        }
                        n25 = n58;
                        n24 = n57;
                        n23 = n56;
                    }
                    if (bl4) {
                        n55 = i2 - 1;
                        int n62 = n54 = i2 + 1;
                        n49 = n58 - (byArray7[n26] & 0xFF);
                        n53 = n49 + n49 + n49;
                        nArray3[n62] = nArray3[n62] + n53;
                        int n63 = i2;
                        nArray3[n63] = nArray3[n63] + (n53 += n49 + n49);
                        int n64 = n55;
                        nArray3[n64] = nArray3[n64] + (n53 + n49 + n49);
                        int n65 = n54;
                        n50 = n57 - (byArray8[n26] & 0xFF);
                        n53 = n50 + n50 + n50;
                        nArray2[n65] = nArray2[n65] + n53;
                        int n66 = i2;
                        nArray2[n66] = nArray2[n66] + (n53 += n50 + n50);
                        int n67 = n55;
                        nArray2[n67] = nArray2[n67] + (n53 + n50 + n50);
                        int n68 = n54;
                        n51 = n56 - (byArray9[n26] & 0xFF);
                        n53 = n51 + n51 + n51;
                        nArray[n68] = nArray[n68] + n53;
                        int n69 = i2;
                        nArray[n69] = nArray[n69] + (n53 += n51 + n51);
                        int n70 = n55;
                        nArray[n70] = nArray[n70] + (n53 + n51 + n51);
                    }
                    switch (n36) {
                        case 6: {
                            byArray6[n33] = (byte)n26;
                            break;
                        }
                        case 7: {
                            if ((n33 & 1) != 0) {
                                byArray6[n33 >> 1] = (byte)(byArray6[n33 >> 1] & 0xF0 | n26);
                                break;
                            }
                            byArray6[n33 >> 1] = (byte)(byArray6[n33 >> 1] & 0xF | n26 << 4);
                            break;
                        }
                        case 8: {
                            n55 = 6 - (n33 & 3) * 2;
                            byArray6[n33 >> 2] = (byte)(byArray6[n33 >> 2] & ~(3 << n55) | n26 << n55);
                            break;
                        }
                        case 9: {
                            n55 = 7 - (n33 & 7);
                            byArray6[n33 >> 3] = (byte)(byArray6[n33 >> 3] & ~(1 << n55) | n26 << n55);
                            break;
                        }
                        case 10: {
                            n55 = n33 & 7;
                            byArray6[n33 >> 3] = (byte)(byArray6[n33 >> 3] & ~(1 << n55) | n26 << n55);
                            break;
                        }
                    }
                }
                n52 = (n52 & 0xFFFF) + n39;
            }
            --n22;
            n32 = n45 += (n21 >>> 16) * n4;
            n31 = n42 += (n21 >>> 16) * n11;
            n21 = (n21 & 0xFFFF) + n38;
            n33 = n46 += n34;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static void blit(int n2, byte[] byArray, int n3, int n4, int n5, int n6, int n7, int n8, int n9, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n10, byte[] byArray5, int n11, int n12, int n13, byte[] byArray6, int n14, int n15, int n16, int n17, int n18, int n19, int n20, int n21, int n22, int n23, boolean bl2, boolean bl3) {
        int n24;
        int n25;
        int n26;
        int n27;
        int n28;
        int n29;
        int n30;
        int n31;
        int n32;
        block68: {
            block71: {
                block70: {
                    int n33;
                    int n34;
                    block69: {
                        if (n19 <= 0 || n20 <= 0 || n10 == 0) {
                            return;
                        }
                        if (n6 != 0 || n7 != 0 || n17 != 0 || n18 != 0 || n19 != n8 || n20 != n9) break block69;
                        if (n14 == 24 && n3 == 8 && (n2 & 2) == 0 && n21 == 0xFF0000 && n22 == 65280 && n23 == 255) break block70;
                        if (n14 == 32 && n16 == 1 && n3 == 8 && (n2 & 2) == 0 && n21 == 0xFF0000 && n22 == 65280 && n23 == 255) break block71;
                    }
                    n32 = (n34 = n19 - 1) != 0 ? (int)((((long)n8 << 16) - 1L) / (long)n34) : 0;
                    int n35 = n20 - 1;
                    n31 = n35 != 0 ? (int)((((long)n9 << 16) - 1L) / (long)n35) : 0;
                    switch (n3) {
                        case 8: {
                            n30 = 6;
                            break;
                        }
                        case 4: {
                            n4 <<= 1;
                            n30 = 7;
                            break;
                        }
                        case 2: {
                            n4 <<= 2;
                            n30 = 8;
                            break;
                        }
                        case 1: {
                            n4 <<= 3;
                            n30 = n5 == 1 ? 9 : 10;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    n29 = n7 * n4 + n6;
                    switch (n14) {
                        case 8: {
                            n33 = 1;
                            n28 = 0;
                            break;
                        }
                        case 16: {
                            n33 = 2;
                            n28 = n16 == 1 ? 1 : 2;
                            break;
                        }
                        case 24: {
                            n33 = 3;
                            n28 = 3;
                            break;
                        }
                        case 32: {
                            n33 = 4;
                            n28 = n16 == 1 ? 4 : 5;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    n27 = (bl3 ? n18 + n35 : n18) * n15 + (bl2 ? n17 + n34 : n17) * n33;
                    n26 = bl2 ? -n33 : n33;
                    int n36 = n25 = bl3 ? -n15 : n15;
                    if ((n2 & 2) != 0) {
                        switch (n10) {
                            case -3: 
                            case -1: {
                                if (byArray5 == null) {
                                    n10 = 65536;
                                }
                                n24 = n13 * n11 + n12;
                                break;
                            }
                            case -4: {
                                if (byArray5 == null) {
                                    n10 = 65536;
                                }
                                n24 = n13 * (n11 <<= 3) + n12;
                                break;
                            }
                            case -6: 
                            case -5: {
                                if (byArray5 == null) {
                                    n10 = 65536;
                                }
                                n24 = 0;
                                break;
                            }
                            default: {
                                n10 = (n10 << 16) / 255;
                            }
                            case -2: {
                                n24 = 0;
                                break;
                            }
                        }
                        break block68;
                    } else {
                        n10 = 65536;
                        n24 = 0;
                    }
                    break block68;
                }
                int n37 = 0;
                int n38 = 0;
                int n39 = 0;
                int n40 = n4 - n8;
                int n41 = n15 - n19 * 3;
                while (true) {
                    if (n37 >= n20) {
                        return;
                    }
                    for (int i2 = 0; i2 < n19; ++i2) {
                        int n42 = byArray[n38++] & 0xFF;
                        byArray6[n39++] = byArray2[n42];
                        byArray6[n39++] = byArray3[n42];
                        byArray6[n39++] = byArray4[n42];
                    }
                    ++n37;
                    n38 += n40;
                    n39 += n41;
                }
            }
            int n43 = 0;
            int n44 = 0;
            int n45 = 0;
            int n46 = n4 - n8;
            int n47 = n15 - n19 * 4;
            while (true) {
                if (n43 >= n20) {
                    return;
                }
                for (int i3 = 0; i3 < n19; ++n45, ++i3) {
                    int n48 = byArray[n44++] & 0xFF;
                    int n49 = ++n45;
                    byArray6[n49] = byArray2[n48];
                    int n50 = ++n45;
                    byArray6[n50] = byArray3[n48];
                    int n51 = ++n45;
                    byArray6[n51] = byArray4[n48];
                }
                ++n43;
                n44 += n46;
                n45 += n47;
            }
        }
        int n52 = ImageData.getChannelShift(n21);
        int n53 = ImageData.getChannelWidth(n21, n52);
        byte[] byArray7 = ANY_TO_EIGHT[n53];
        int n54 = 8 - n53;
        int n55 = ImageData.getChannelShift(n22);
        int n56 = ImageData.getChannelWidth(n22, n55);
        byte[] byArray8 = ANY_TO_EIGHT[n56];
        int n57 = 8 - n56;
        int n58 = ImageData.getChannelShift(n23);
        int n59 = ImageData.getChannelWidth(n23, n58);
        byte[] byArray9 = ANY_TO_EIGHT[n59];
        int n60 = 8 - n59;
        int n61 = ImageData.getChannelShift(0);
        int n62 = ImageData.getChannelWidth(0, n61);
        byte[] byArray10 = ANY_TO_EIGHT[n62];
        int n63 = 8 - n62;
        int n64 = n27;
        int n65 = n29;
        int n66 = n24;
        int n67 = n10;
        int n68 = 0;
        int n69 = 0;
        int n70 = 0;
        int n71 = 0;
        int n72 = 0;
        int n73 = 0;
        int n74 = 0;
        int n75 = 0;
        int n76 = 0;
        int n77 = n20;
        int n78 = n31;
        while (n77 > 0) {
            int n79 = n32;
            for (int i4 = n19; i4 > 0; --i4, n64 += n26) {
                block72: {
                    int n80;
                    block73: {
                        switch (n30) {
                            case 6: {
                                n72 = byArray[n65] & 0xFF;
                                n65 += n79 >>> 16;
                                break;
                            }
                            case 7: {
                                n72 = (n65 & 1) != 0 ? byArray[n65 >> 1] & 0xF : byArray[n65 >> 1] >>> 4 & 0xF;
                                n65 += n79 >>> 16;
                                break;
                            }
                            case 8: {
                                n72 = byArray[n65 >> 2] >>> 6 - (n65 & 3) * 2 & 3;
                                n65 += n79 >>> 16;
                                break;
                            }
                            case 9: {
                                n72 = byArray[n65 >> 3] >>> 7 - (n65 & 7) & 1;
                                n65 += n79 >>> 16;
                                break;
                            }
                            case 10: {
                                n72 = byArray[n65 >> 3] >>> (n65 & 7) & 1;
                                n65 += n79 >>> 16;
                                break;
                            }
                        }
                        n68 = byArray2[n72] & 0xFF;
                        n69 = byArray3[n72] & 0xFF;
                        n70 = byArray4[n72] & 0xFF;
                        switch (n10) {
                            case -1: {
                                n67 = ((byArray5[n66] & 0xFF) << 16) / 255;
                                n66 += n79 >> 16;
                                break;
                            }
                            case -3: {
                                n67 = byArray5[n66] != 0 ? 65536 : 0;
                                n66 += n79 >> 16;
                                break;
                            }
                            case -4: {
                                n67 = byArray5[n66 >> 3] << (n66 & 7) + 9 & 0x10000;
                                n66 += n79 >> 16;
                                break;
                            }
                            case -5: {
                                n80 = 0;
                                while (n80 < byArray5.length && n72 != (byArray5[n80] & 0xFF)) {
                                }
                                if (n80 >= byArray5.length) break;
                                break block72;
                            }
                            case -6: {
                                for (n80 = 0; n80 < byArray5.length && (n68 != (byArray5[n80] & 0xFF) || n69 != (byArray5[n80 + 1] & 0xFF) || n70 != (byArray5[n80 + 2] & 0xFF)); n80 += 3) {
                                }
                                if (n80 < byArray5.length) break block72;
                            }
                        }
                        if (n67 == 65536) break block73;
                        if (n67 == 0) break block72;
                        switch (n28) {
                            case 0: {
                                n80 = byArray6[n64] & 0xFF;
                                n73 = byArray7[(n80 & n21) >>> n52] & 0xFF;
                                n74 = byArray8[(n80 & n22) >>> n55] & 0xFF;
                                n75 = byArray9[(n80 & n23) >>> n58] & 0xFF;
                                n76 = byArray10[(n80 & 0) >>> n61] & 0xFF;
                                break;
                            }
                            case 1: {
                                n80 = (byArray6[n64] & 0xFF) << 8 | byArray6[n64 + 1] & 0xFF;
                                n73 = byArray7[(n80 & n21) >>> n52] & 0xFF;
                                n74 = byArray8[(n80 & n22) >>> n55] & 0xFF;
                                n75 = byArray9[(n80 & n23) >>> n58] & 0xFF;
                                n76 = byArray10[(n80 & 0) >>> n61] & 0xFF;
                                break;
                            }
                            case 2: {
                                n80 = (byArray6[n64 + 1] & 0xFF) << 8 | byArray6[n64] & 0xFF;
                                n73 = byArray7[(n80 & n21) >>> n52] & 0xFF;
                                n74 = byArray8[(n80 & n22) >>> n55] & 0xFF;
                                n75 = byArray9[(n80 & n23) >>> n58] & 0xFF;
                                n76 = byArray10[(n80 & 0) >>> n61] & 0xFF;
                                break;
                            }
                            case 3: {
                                n80 = ((byArray6[n64] & 0xFF) << 8 | byArray6[n64 + 1] & 0xFF) << 8 | byArray6[n64 + 2] & 0xFF;
                                n73 = byArray7[(n80 & n21) >>> n52] & 0xFF;
                                n74 = byArray8[(n80 & n22) >>> n55] & 0xFF;
                                n75 = byArray9[(n80 & n23) >>> n58] & 0xFF;
                                n76 = byArray10[(n80 & 0) >>> n61] & 0xFF;
                                break;
                            }
                            case 4: {
                                n80 = (((byArray6[n64] & 0xFF) << 8 | byArray6[n64 + 1] & 0xFF) << 8 | byArray6[n64 + 2] & 0xFF) << 8 | byArray6[n64 + 3] & 0xFF;
                                n73 = byArray7[(n80 & n21) >>> n52] & 0xFF;
                                n74 = byArray8[(n80 & n22) >>> n55] & 0xFF;
                                n75 = byArray9[(n80 & n23) >>> n58] & 0xFF;
                                n76 = byArray10[(n80 & 0) >>> n61] & 0xFF;
                                break;
                            }
                            case 5: {
                                n80 = (((byArray6[n64 + 3] & 0xFF) << 8 | byArray6[n64 + 2] & 0xFF) << 8 | byArray6[n64 + 1] & 0xFF) << 8 | byArray6[n64] & 0xFF;
                                n73 = byArray7[(n80 & n21) >>> n52] & 0xFF;
                                n74 = byArray8[(n80 & n22) >>> n55] & 0xFF;
                                n75 = byArray9[(n80 & n23) >>> n58] & 0xFF;
                                n76 = byArray10[(n80 & 0) >>> n61] & 0xFF;
                                break;
                            }
                        }
                        n71 = n76 + ((n71 - n76) * n67 >> 16);
                        n68 = n73 + ((n68 - n73) * n67 >> 16);
                        n69 = n74 + ((n69 - n74) * n67 >> 16);
                        n70 = n75 + ((n70 - n75) * n67 >> 16);
                    }
                    n80 = n68 >>> n54 << n52 | n69 >>> n57 << n55 | n70 >>> n60 << n58 | n71 >>> n63 << n61;
                    switch (n28) {
                        case 0: {
                            byArray6[n64] = (byte)n80;
                            break;
                        }
                        case 1: {
                            byArray6[n64] = (byte)(n80 >>> 8);
                            byArray6[n64 + 1] = (byte)(n80 & 0xFF);
                            break;
                        }
                        case 2: {
                            byArray6[n64] = (byte)(n80 & 0xFF);
                            byArray6[n64 + 1] = (byte)(n80 >>> 8);
                            break;
                        }
                        case 3: {
                            byArray6[n64] = (byte)(n80 >>> 16);
                            byArray6[n64 + 1] = (byte)(n80 >>> 8);
                            byArray6[n64 + 2] = (byte)(n80 & 0xFF);
                            break;
                        }
                        case 4: {
                            byArray6[n64] = (byte)(n80 >>> 24);
                            byArray6[n64 + 1] = (byte)(n80 >>> 16);
                            byArray6[n64 + 2] = (byte)(n80 >>> 8);
                            byArray6[n64 + 3] = (byte)(n80 & 0xFF);
                            break;
                        }
                        case 5: {
                            byArray6[n64] = (byte)(n80 & 0xFF);
                            byArray6[n64 + 1] = (byte)(n80 >>> 8);
                            byArray6[n64 + 2] = (byte)(n80 >>> 16);
                            byArray6[n64 + 3] = (byte)(n80 >>> 24);
                            break;
                        }
                    }
                }
                n79 = (n79 & 0xFFFF) + n32;
            }
            --n77;
            n65 = n29 += (n78 >>> 16) * n4;
            n66 = n24 += (n78 >>> 16) * n11;
            n78 = (n78 & 0xFFFF) + n31;
            n64 = n27 += n25;
        }
        return;
    }

    static void blit(int n2, byte[] byArray, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, byte[] byArray2, int n14, int n15, int n16, byte[] byArray3, int n17, int n18, int n19, int n20, int n21, int n22, int n23, byte[] byArray4, byte[] byArray5, byte[] byArray6, boolean bl2, boolean bl3) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int n24;
        int n25;
        int n26;
        int n27;
        int n28;
        if (n22 <= 0 || n23 <= 0 || n13 == 0) {
            return;
        }
        int n29 = n22 - 1;
        int n30 = n29 != 0 ? (int)((((long)n8 << 16) - 1L) / (long)n29) : 0;
        int n31 = n23 - 1;
        int n32 = n31 != 0 ? (int)((((long)n9 << 16) - 1L) / (long)n31) : 0;
        switch (n3) {
            case 8: {
                n28 = 1;
                n27 = 0;
                break;
            }
            case 16: {
                n28 = 2;
                n27 = n5 == 1 ? 1 : 2;
                break;
            }
            case 24: {
                n28 = 3;
                n27 = 3;
                break;
            }
            case 32: {
                n28 = 4;
                n27 = n5 == 1 ? 4 : 5;
                break;
            }
            default: {
                return;
            }
        }
        int n33 = n7 * n4 + n6 * n28;
        switch (n17) {
            case 8: {
                n26 = 6;
                break;
            }
            case 4: {
                n18 <<= 1;
                n26 = 7;
                break;
            }
            case 2: {
                n18 <<= 2;
                n26 = 8;
                break;
            }
            case 1: {
                n18 <<= 3;
                n26 = n19 == 1 ? 9 : 10;
                break;
            }
            default: {
                return;
            }
        }
        int n34 = (bl3 ? n21 + n31 : n21) * n18 + (bl2 ? n20 + n29 : n20);
        int n35 = bl2 ? -1 : 1;
        int n36 = n25 = bl3 ? -n18 : n18;
        if ((n2 & 2) != 0) {
            switch (n13) {
                case -3: 
                case -1: {
                    if (byArray2 == null) {
                        n13 = 65536;
                    }
                    n24 = n16 * n14 + n15;
                    break;
                }
                case -4: {
                    if (byArray2 == null) {
                        n13 = 65536;
                    }
                    n24 = n16 * (n14 <<= 3) + n15;
                    break;
                }
                case -5: {
                    return;
                }
                case -6: {
                    if (byArray2 == null) {
                        n13 = 65536;
                    }
                    n24 = 0;
                    break;
                }
                default: {
                    n13 = (n13 << 16) / 255;
                }
                case -2: {
                    n24 = 0;
                    break;
                }
            }
        } else {
            n13 = 65536;
            n24 = 0;
        }
        boolean bl4 = (n2 & 4) != 0;
        int n37 = ImageData.getChannelShift(n10);
        byte[] byArray7 = ANY_TO_EIGHT[ImageData.getChannelWidth(n10, n37)];
        int n38 = ImageData.getChannelShift(n11);
        byte[] byArray8 = ANY_TO_EIGHT[ImageData.getChannelWidth(n11, n38)];
        int n39 = ImageData.getChannelShift(n12);
        byte[] byArray9 = ANY_TO_EIGHT[ImageData.getChannelWidth(n12, n39)];
        int n40 = ImageData.getChannelShift(0);
        byte[] byArray10 = ANY_TO_EIGHT[ImageData.getChannelWidth(0, n40)];
        int n41 = n34;
        int n42 = n33;
        int n43 = n24;
        int n44 = n13;
        int n45 = 0;
        int n46 = 0;
        int n47 = 0;
        int n48 = 0;
        int n49 = 0;
        int n50 = 0;
        int n51 = -1;
        int n52 = -1;
        int n53 = -1;
        int n54 = 1 << n17;
        if (byArray4 != null && byArray4.length < n54) {
            n54 = byArray4.length;
        }
        if (bl4) {
            nArray3 = new int[n22 + 2];
            nArray2 = new int[n22 + 2];
            nArray = new int[n22 + 2];
        } else {
            nArray3 = null;
            nArray2 = null;
            nArray = null;
        }
        int n55 = n32;
        for (int i2 = n23; i2 > 0; --i2) {
            int n56 = 0;
            int n57 = 0;
            int n58 = 0;
            int n59 = n22;
            int n60 = n30;
            while (n59 > 0) {
                block79: {
                    int n61;
                    int n62;
                    int n63;
                    block78: {
                        switch (n27) {
                            case 0: {
                                n63 = byArray[n42] & 0xFF;
                                n42 += n60 >>> 16;
                                n45 = byArray7[(n63 & n10) >>> n37] & 0xFF;
                                n46 = byArray8[(n63 & n11) >>> n38] & 0xFF;
                                n47 = byArray9[(n63 & n12) >>> n39] & 0xFF;
                                n48 = byArray10[(n63 & 0) >>> n40] & 0xFF;
                                break;
                            }
                            case 1: {
                                n63 = (byArray[n42] & 0xFF) << 8 | byArray[n42 + 1] & 0xFF;
                                n42 += (n60 >>> 16) * 2;
                                n45 = byArray7[(n63 & n10) >>> n37] & 0xFF;
                                n46 = byArray8[(n63 & n11) >>> n38] & 0xFF;
                                n47 = byArray9[(n63 & n12) >>> n39] & 0xFF;
                                n48 = byArray10[(n63 & 0) >>> n40] & 0xFF;
                                break;
                            }
                            case 2: {
                                n63 = (byArray[n42 + 1] & 0xFF) << 8 | byArray[n42] & 0xFF;
                                n42 += (n60 >>> 16) * 2;
                                n45 = byArray7[(n63 & n10) >>> n37] & 0xFF;
                                n46 = byArray8[(n63 & n11) >>> n38] & 0xFF;
                                n47 = byArray9[(n63 & n12) >>> n39] & 0xFF;
                                n48 = byArray10[(n63 & 0) >>> n40] & 0xFF;
                                break;
                            }
                            case 3: {
                                n63 = ((byArray[n42] & 0xFF) << 8 | byArray[n42 + 1] & 0xFF) << 8 | byArray[n42 + 2] & 0xFF;
                                n42 += (n60 >>> 16) * 3;
                                n45 = byArray7[(n63 & n10) >>> n37] & 0xFF;
                                n46 = byArray8[(n63 & n11) >>> n38] & 0xFF;
                                n47 = byArray9[(n63 & n12) >>> n39] & 0xFF;
                                n48 = byArray10[(n63 & 0) >>> n40] & 0xFF;
                                break;
                            }
                            case 4: {
                                n63 = (((byArray[n42] & 0xFF) << 8 | byArray[n42 + 1] & 0xFF) << 8 | byArray[n42 + 2] & 0xFF) << 8 | byArray[n42 + 3] & 0xFF;
                                n42 += (n60 >>> 16) * 4;
                                n45 = byArray7[(n63 & n10) >>> n37] & 0xFF;
                                n46 = byArray8[(n63 & n11) >>> n38] & 0xFF;
                                n47 = byArray9[(n63 & n12) >>> n39] & 0xFF;
                                n48 = byArray10[(n63 & 0) >>> n40] & 0xFF;
                                break;
                            }
                            case 5: {
                                n63 = (((byArray[n42 + 3] & 0xFF) << 8 | byArray[n42 + 2] & 0xFF) << 8 | byArray[n42 + 1] & 0xFF) << 8 | byArray[n42] & 0xFF;
                                n42 += (n60 >>> 16) * 4;
                                n45 = byArray7[(n63 & n10) >>> n37] & 0xFF;
                                n46 = byArray8[(n63 & n11) >>> n38] & 0xFF;
                                n47 = byArray9[(n63 & n12) >>> n39] & 0xFF;
                                n48 = byArray10[(n63 & 0) >>> n40] & 0xFF;
                            }
                        }
                        block27 : switch (n13) {
                            case -1: {
                                n44 = ((byArray2[n43] & 0xFF) << 16) / 255;
                                n43 += n60 >> 16;
                                break;
                            }
                            case -2: {
                                n44 = (n48 << 16) / 255;
                                break;
                            }
                            case -3: {
                                n44 = byArray2[n43] != 0 ? 65536 : 0;
                                n43 += n60 >> 16;
                                break;
                            }
                            case -4: {
                                n44 = byArray2[n43 >> 3] << (n43 & 7) + 9 & 0x10000;
                                n43 += n60 >> 16;
                                break;
                            }
                            case -6: {
                                n44 = 65536;
                                for (n63 = 0; n63 < byArray2.length; n63 += 3) {
                                    if (n45 != byArray2[n63] || n46 != byArray2[n63 + 1] || n47 != byArray2[n63 + 2]) continue;
                                    n44 = 0;
                                    break block27;
                                }
                                break;
                            }
                        }
                        if (n44 == 65536) break block78;
                        if (n44 == 0) break block79;
                        switch (n26) {
                            case 6: {
                                n49 = byArray3[n41] & 0xFF;
                                break;
                            }
                            case 7: {
                                if ((n41 & 1) != 0) {
                                    n49 = byArray3[n41 >> 1] & 0xF;
                                    break;
                                }
                                n49 = byArray3[n41 >> 1] >>> 4 & 0xF;
                                break;
                            }
                            case 8: {
                                n49 = byArray3[n41 >> 2] >>> 6 - (n41 & 3) * 2 & 3;
                                break;
                            }
                            case 9: {
                                n49 = byArray3[n41 >> 3] >>> 7 - (n41 & 7) & 1;
                                break;
                            }
                            case 10: {
                                n49 = byArray3[n41 >> 3] >>> (n41 & 7) & 1;
                            }
                        }
                        n63 = byArray4[n49] & 0xFF;
                        n62 = byArray5[n49] & 0xFF;
                        n61 = byArray6[n49] & 0xFF;
                        n45 = n63 + ((n45 - n63) * n44 >> 16);
                        n46 = n62 + ((n46 - n62) * n44 >> 16);
                        n47 = n61 + ((n47 - n61) * n44 >> 16);
                    }
                    if (bl4) {
                        if ((n45 += nArray3[n59] >> 4) < 0) {
                            n45 = 0;
                        } else if (n45 > 255) {
                            n45 = 255;
                        }
                        if ((n46 += nArray2[n59] >> 4) < 0) {
                            n46 = 0;
                        } else if (n46 > 255) {
                            n46 = 255;
                        }
                        if ((n47 += nArray[n59] >> 4) < 0) {
                            n47 = 0;
                        } else if (n47 > 255) {
                            n47 = 255;
                        }
                        nArray3[n59] = n56;
                        nArray2[n59] = n57;
                        nArray[n59] = n58;
                    }
                    if (n45 != n51 || n46 != n52 || n47 != n53) {
                        int n64 = Integer.MAX_VALUE;
                        for (n63 = 0; n63 < n54; ++n63) {
                            n62 = (byArray4[n63] & 0xFF) - n45;
                            n61 = (byArray5[n63] & 0xFF) - n46;
                            int n65 = (byArray6[n63] & 0xFF) - n47;
                            int n66 = n62 * n62 + n61 * n61 + n65 * n65;
                            if (n66 >= n64) continue;
                            n50 = n63;
                            if (n66 == 0) break;
                            n64 = n66;
                        }
                        n51 = n45;
                        n52 = n46;
                        n53 = n47;
                    }
                    if (bl4) {
                        n63 = n59 - 1;
                        int n67 = n62 = n59 + 1;
                        n56 = n45 - (byArray4[n50] & 0xFF);
                        n61 = n56 + n56 + n56;
                        nArray3[n67] = nArray3[n67] + n61;
                        int n68 = n59;
                        nArray3[n68] = nArray3[n68] + (n61 += n56 + n56);
                        int n69 = n63;
                        nArray3[n69] = nArray3[n69] + (n61 + n56 + n56);
                        int n70 = n62;
                        n57 = n46 - (byArray5[n50] & 0xFF);
                        n61 = n57 + n57 + n57;
                        nArray2[n70] = nArray2[n70] + n61;
                        int n71 = n59;
                        nArray2[n71] = nArray2[n71] + (n61 += n57 + n57);
                        int n72 = n63;
                        nArray2[n72] = nArray2[n72] + (n61 + n57 + n57);
                        int n73 = n62;
                        n58 = n47 - (byArray6[n50] & 0xFF);
                        n61 = n58 + n58 + n58;
                        nArray[n73] = nArray[n73] + n61;
                        int n74 = n59;
                        nArray[n74] = nArray[n74] + (n61 += n58 + n58);
                        int n75 = n63;
                        nArray[n75] = nArray[n75] + (n61 + n58 + n58);
                    }
                    switch (n26) {
                        case 6: {
                            byArray3[n41] = (byte)n50;
                            break;
                        }
                        case 7: {
                            if ((n41 & 1) != 0) {
                                byArray3[n41 >> 1] = (byte)(byArray3[n41 >> 1] & 0xF0 | n50);
                                break;
                            }
                            byArray3[n41 >> 1] = (byte)(byArray3[n41 >> 1] & 0xF | n50 << 4);
                            break;
                        }
                        case 8: {
                            n63 = 6 - (n41 & 3) * 2;
                            byArray3[n41 >> 2] = (byte)(byArray3[n41 >> 2] & ~(3 << n63) | n50 << n63);
                            break;
                        }
                        case 9: {
                            n63 = 7 - (n41 & 7);
                            byArray3[n41 >> 3] = (byte)(byArray3[n41 >> 3] & ~(1 << n63) | n50 << n63);
                            break;
                        }
                        case 10: {
                            n63 = n41 & 7;
                            byArray3[n41 >> 3] = (byte)(byArray3[n41 >> 3] & ~(1 << n63) | n50 << n63);
                        }
                    }
                }
                --n59;
                n41 += n35;
                n60 = (n60 & 0xFFFF) + n30;
            }
            n42 = n33 += (n55 >>> 16) * n4;
            n43 = n24 += (n55 >>> 16) * n14;
            n55 = (n55 & 0xFFFF) + n32;
            n41 = n34 += n25;
        }
    }

    static int getChannelShift(int n2) {
        int n3;
        if (n2 == 0) {
            return 0;
        }
        for (n3 = 0; (n2 & 1) == 0 && n3 < 32; ++n3) {
            n2 >>>= 1;
        }
        return n3;
    }

    static int getChannelWidth(int n2, int n3) {
        int n4;
        if (n2 == 0) {
            return 0;
        }
        n2 >>>= n3;
        for (n4 = n3; (n2 & 1) != 0 && n4 < 32; ++n4) {
            n2 >>>= 1;
        }
        return n4 - n3;
    }

    static byte getChannelField(int n2, int n3) {
        int n4 = ImageData.getChannelShift(n3);
        return ANY_TO_EIGHT[ImageData.getChannelWidth(n3, n4)][(n2 & n3) >>> n4];
    }

    static ImageData createGradientBand(int n2, int n3, boolean bl2, RGB rGB, RGB rGB2, int n4, int n5, int n6) {
        byte[] byArray;
        int n7;
        int n8;
        int n9;
        PaletteData paletteData;
        if (n4 != 0 && n5 != 0 && n6 != 0) {
            paletteData = new PaletteData(65280, 0xFF0000, -16777216);
            n9 = 32;
            if (n4 >= 8 && n5 >= 8 && n6 >= 8) {
                int n10;
                if (bl2) {
                    n8 = 1;
                    n7 = n3;
                    n10 = n7 > 1 ? n7 - 1 : 1;
                } else {
                    n8 = n2;
                    n7 = 1;
                    n10 = n8 > 1 ? n8 - 1 : 1;
                }
                int n11 = n8 * 4;
                byArray = new byte[n7 * n11];
                ImageData.buildPreciseGradientChannel(rGB.blue, rGB2.blue, n10, n8, n7, bl2, byArray, 0, n11);
                ImageData.buildPreciseGradientChannel(rGB.green, rGB2.green, n10, n8, n7, bl2, byArray, 1, n11);
                ImageData.buildPreciseGradientChannel(rGB.red, rGB2.red, n10, n8, n7, bl2, byArray, 2, n11);
            } else {
                int n12;
                if (bl2) {
                    n8 = n2 < 8 ? n2 : 8;
                    n7 = n3;
                    n12 = n7 > 1 ? n7 - 1 : 1;
                } else {
                    n8 = n2;
                    n7 = n3 < 8 ? n3 : 8;
                    n12 = n8 > 1 ? n8 - 1 : 1;
                }
                int n13 = n8 * 4;
                byArray = new byte[n7 * n13];
                ImageData.buildDitheredGradientChannel(rGB.blue, rGB2.blue, n12, n8, n7, bl2, byArray, 0, n13, n6);
                ImageData.buildDitheredGradientChannel(rGB.green, rGB2.green, n12, n8, n7, bl2, byArray, 1, n13, n5);
                ImageData.buildDitheredGradientChannel(rGB.red, rGB2.red, n12, n8, n7, bl2, byArray, 2, n13, n4);
            }
        } else {
            int n14;
            paletteData = new PaletteData(rGB, rGB2);
            n9 = 8;
            if (bl2) {
                n8 = n2 < 8 ? n2 : 8;
                n7 = n3;
                n14 = n7 > 1 ? 0x1040000 / (n7 - 1) + 1 : 1;
            } else {
                n8 = n2;
                n7 = n3 < 8 ? n3 : 8;
                n14 = n8 > 1 ? 0x1040000 / (n8 - 1) + 1 : 1;
            }
            int n15 = n8 + 3 & 0xFFFFFFFC;
            byArray = new byte[n7 * n15];
            if (bl2) {
                int n16 = 0;
                int n17 = 0;
                int n18 = 0;
                while (n16 < n7) {
                    for (int i2 = 0; i2 < n8; ++i2) {
                        byArray[n18 + i2] = n17 + DITHER_MATRIX[n16 & 7][i2] < 0x1000000 ? (byte)0 : 1;
                    }
                    ++n16;
                    n17 += n14;
                    n18 += n15;
                }
            } else {
                int n19 = 0;
                int n20 = 0;
                while (n19 < n8) {
                    int n21 = 0;
                    int n22 = n19;
                    while (n21 < n7) {
                        byArray[n22] = n20 + DITHER_MATRIX[n21][n19 & 7] < 0x1000000 ? (byte)0 : 1;
                        ++n21;
                        n22 += n15;
                    }
                    ++n19;
                    n20 += n14;
                }
            }
        }
        return new ImageData(n8, n7, n9, paletteData, 4, byArray);
    }

    static final void buildPreciseGradientChannel(int n2, int n3, int n4, int n5, int n6, boolean bl2, byte[] byArray, int n7, int n8) {
        int n9 = n2 << 16;
        int n10 = ((n3 << 16) - n9) / n4 + 1;
        if (bl2) {
            int n11 = 0;
            while (n11 < n6) {
                byArray[n7] = (byte)(n9 >>> 16);
                n9 += n10;
                ++n11;
                n7 += n8;
            }
        } else {
            int n12 = 0;
            while (n12 < n5) {
                byArray[n7] = (byte)(n9 >>> 16);
                n9 += n10;
                ++n12;
                n7 += 4;
            }
        }
    }

    static final void buildDitheredGradientChannel(int n2, int n3, int n4, int n5, int n6, boolean bl2, byte[] byArray, int n7, int n8, int n9) {
        int n10 = 65280 >>> n9;
        int n11 = n2 << 16;
        int n12 = ((n3 << 16) - n11) / n4 + 1;
        if (bl2) {
            int n13 = 0;
            while (n13 < n6) {
                int n14 = 0;
                int n15 = n7;
                while (n14 < n5) {
                    int n16 = DITHER_MATRIX[n13 & 7][n14] >>> n9;
                    int n17 = n11 + n16;
                    byArray[n15] = n17 > 0xFFFFFF ? -1 : (byte)(n17 >>> 16 & n10);
                    ++n14;
                    n15 += 4;
                }
                n11 += n12;
                ++n13;
                n7 += n8;
            }
        } else {
            int n18 = 0;
            while (n18 < n5) {
                int n19 = 0;
                int n20 = n7;
                while (n19 < n6) {
                    int n21 = DITHER_MATRIX[n19][n18 & 7] >>> n9;
                    int n22 = n11 + n21;
                    byArray[n20] = n22 > 0xFFFFFF ? -1 : (byte)(n22 >>> 16 & n10);
                    ++n19;
                    n20 += n8;
                }
                n11 += n12;
                ++n18;
                n7 += 4;
            }
        }
    }

    static void fillGradientRectangle(GC gC, Device device, int n2, int n3, int n4, int n5, boolean bl2, RGB rGB, RGB rGB2, int n6, int n7, int n8) {
        ImageData imageData = ImageData.createGradientBand(n4, n5, bl2, rGB, rGB2, n6, n7, n8);
        Image image = new Image(device, imageData);
        if (imageData.width == 1 || imageData.height == 1) {
            gC.drawImage(image, 0, 0, DPIUtil.autoScaleDown(imageData.width), DPIUtil.autoScaleDown(imageData.height), DPIUtil.autoScaleDown(n2), DPIUtil.autoScaleDown(n3), DPIUtil.autoScaleDown(n4), DPIUtil.autoScaleDown(n5));
        } else if (bl2) {
            for (int i2 = 0; i2 < n4; i2 += imageData.width) {
                int n9 = n4 - i2;
                if (n9 > imageData.width) {
                    n9 = imageData.width;
                }
                gC.drawImage(image, 0, 0, DPIUtil.autoScaleDown(n9), DPIUtil.autoScaleDown(imageData.height), DPIUtil.autoScaleDown(i2 + n2), DPIUtil.autoScaleDown(n3), DPIUtil.autoScaleDown(n9), DPIUtil.autoScaleDown(imageData.height));
            }
        } else {
            for (int i3 = 0; i3 < n5; i3 += imageData.height) {
                int n10 = n5 - i3;
                if (n10 > imageData.height) {
                    n10 = imageData.height;
                }
                gC.drawImage(image, 0, 0, DPIUtil.autoScaleDown(imageData.width), DPIUtil.autoScaleDown(n10), DPIUtil.autoScaleDown(n2), DPIUtil.autoScaleDown(i3 + n3), DPIUtil.autoScaleDown(imageData.width), DPIUtil.autoScaleDown(n10));
            }
        }
        image.dispose();
    }

    static {
        for (int i2 = 0; i2 < 9; ++i2) {
            ImageData.ANY_TO_EIGHT[i2] = new byte[1 << i2];
            byte[] byArray = ImageData.ANY_TO_EIGHT[i2];
            if (i2 == 0) continue;
            int n2 = 0;
            int n3 = 65536;
            while ((n3 >>= i2) != 0) {
                n2 |= n3;
            }
            int n4 = 0;
            for (n3 = 0; n3 < 65536; n3 += n2) {
                byArray[n4++] = (byte)(n3 >> 8);
            }
        }
        ONE_TO_ONE_MAPPING = ANY_TO_EIGHT[8];
        DITHER_MATRIX = new int[][]{{0xFC0000, 0x7C0000, 0xDC0000, 0x5C0000, 0xF40000, 0x740000, 0xD40000, 0x540000}, {0x3C0000, 0xBC0000, 0x1C0000, 0x9C0000, 0x340000, 0xB40000, 0x140000, 0x940000}, {0xCC0000, 0x4C0000, 0xEC0000, 0x6C0000, 0xC40000, 0x440000, 0xE40000, 0x640000}, {786432, 0x8C0000, 0x2C0000, 0xAC0000, 262144, 0x840000, 0x240000, 0xA40000}, {0xF00000, 0x700000, 0xD00000, 0x500000, 0xF80000, 0x780000, 0xD80000, 0x580000}, {0x300000, 0xB00000, 0x100000, 0x900000, 0x380000, 0xB80000, 0x180000, 0x980000}, {0xC00000, 0x400000, 0xE00000, 0x600000, 0xC80000, 0x480000, 0xE80000, 0x680000}, {0, 0x800000, 0x200000, 0xA00000, 524288, 0x880000, 0x280000, 0xA80000}};
    }
}

