/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.image.JPEGVariableSizeSegment;
import org.eclipse.swt.internal.image.LEDataInputStream;

final class JPEGFrameHeader
extends JPEGVariableSizeSegment {
    int maxVFactor;
    int maxHFactor;
    public int[] componentIdentifiers;
    public int[][] componentParameters;

    public JPEGFrameHeader(byte[] byArray) {
        super(byArray);
    }

    public JPEGFrameHeader(LEDataInputStream lEDataInputStream) {
        super(lEDataInputStream);
        this.initializeComponentParameters();
    }

    public int getSamplePrecision() {
        return this.reference[4] & 0xFF;
    }

    public int getNumberOfLines() {
        return (this.reference[5] & 0xFF) << 8 | this.reference[6] & 0xFF;
    }

    public int getSamplesPerLine() {
        return (this.reference[7] & 0xFF) << 8 | this.reference[8] & 0xFF;
    }

    public int getNumberOfImageComponents() {
        return this.reference[9] & 0xFF;
    }

    public void setSamplePrecision(int n2) {
        this.reference[4] = (byte)(n2 & 0xFF);
    }

    public void setNumberOfLines(int n2) {
        this.reference[5] = (byte)((n2 & 0xFF00) >> 8);
        this.reference[6] = (byte)(n2 & 0xFF);
    }

    public void setSamplesPerLine(int n2) {
        this.reference[7] = (byte)((n2 & 0xFF00) >> 8);
        this.reference[8] = (byte)(n2 & 0xFF);
    }

    public void setNumberOfImageComponents(int n2) {
        this.reference[9] = (byte)(n2 & 0xFF);
    }

    public int getMaxHFactor() {
        return this.maxHFactor;
    }

    public int getMaxVFactor() {
        return this.maxVFactor;
    }

    public void setMaxHFactor(int n2) {
        this.maxHFactor = n2;
    }

    public void setMaxVFactor(int n2) {
        this.maxVFactor = n2;
    }

    void initializeComponentParameters() {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.getNumberOfImageComponents();
        this.componentIdentifiers = new int[n6];
        int[][] nArrayArray = new int[][]{};
        int n7 = 1;
        int n8 = 1;
        for (n5 = 0; n5 < n6; ++n5) {
            int n9;
            n4 = n5 * 3 + 10;
            this.componentIdentifiers[n5] = n9 = this.reference[n4] & 0xFF;
            n3 = (this.reference[n4 + 1] & 0xFF) >> 4;
            int n10 = this.reference[n4 + 1] & 0xF;
            n2 = this.reference[n4 + 2] & 0xFF;
            if (n3 > n7) {
                n7 = n3;
            }
            if (n10 > n8) {
                n8 = n10;
            }
            int[] nArray = new int[5];
            nArray[0] = n2;
            nArray[1] = n3;
            nArray[2] = n10;
            if (nArrayArray.length <= n9) {
                int[][] nArrayArray2 = new int[n9 + 1][];
                System.arraycopy(nArrayArray, 0, nArrayArray2, 0, nArrayArray.length);
                nArrayArray = nArrayArray2;
            }
            nArrayArray[n9] = nArray;
        }
        n5 = this.getSamplesPerLine();
        n4 = this.getNumberOfLines();
        int[] nArray = new int[]{8, 16, 24, 32};
        for (n3 = 0; n3 < n6; ++n3) {
            int[] nArray2 = nArrayArray[this.componentIdentifiers[n3]];
            n2 = nArray2[1];
            int n11 = nArray2[2];
            int n12 = (n5 * n2 + n7 - 1) / n7;
            int n13 = (n4 * n11 + n8 - 1) / n8;
            int n14 = this.roundUpToMultiple(n12, nArray[n2 - 1]);
            int n15 = this.roundUpToMultiple(n13, nArray[n11 - 1]);
            nArray2[3] = n14;
            nArray2[4] = n15;
        }
        this.setMaxHFactor(n7);
        this.setMaxVFactor(n8);
        this.componentParameters = nArrayArray;
    }

    public void initializeContents() {
        int n2;
        int[] nArray;
        int n3;
        int n4;
        int n5 = this.getNumberOfImageComponents();
        if (n5 == 0 || n5 != this.componentParameters.length) {
            SWT.error(40);
        }
        int n6 = 0;
        int n7 = 0;
        int[][] nArray2 = this.componentParameters;
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = n4 * 3 + 10;
            nArray = nArray2[this.componentIdentifiers[n4]];
            n2 = nArray[1];
            int n8 = nArray[2];
            if (n2 * n8 > 4) {
                SWT.error(40);
            }
            this.reference[n3] = (byte)(n4 + 1);
            this.reference[n3 + 1] = (byte)(n2 * 16 + n8);
            this.reference[n3 + 2] = (byte)nArray[0];
            if (n2 > n6) {
                n6 = n2;
            }
            if (n8 <= n7) continue;
            n7 = n8;
        }
        n4 = this.getSamplesPerLine();
        n3 = this.getNumberOfLines();
        nArray = new int[]{8, 16, 24, 32};
        for (n2 = 0; n2 < n5; ++n2) {
            int[] nArray3 = nArray2[this.componentIdentifiers[n2]];
            int n9 = nArray3[1];
            int n10 = nArray3[2];
            int n11 = (n4 * n9 + n6 - 1) / n6;
            int n12 = (n3 * n10 + n7 - 1) / n7;
            int n13 = this.roundUpToMultiple(n11, nArray[n9 - 1]);
            int n14 = this.roundUpToMultiple(n12, nArray[n10 - 1]);
            nArray3[3] = n13;
            nArray3[4] = n14;
        }
        this.setMaxHFactor(n6);
        this.setMaxVFactor(n7);
    }

    int roundUpToMultiple(int n2, int n3) {
        int n4 = n2 + n3 - 1;
        return n4 - n4 % n3;
    }

    @Override
    public boolean verify() {
        int n2 = this.getSegmentMarker();
        return n2 >= 65472 && n2 <= 65475 || n2 >= 65477 && n2 <= 65479 || n2 >= 65481 && n2 <= 65483 || n2 >= 65485 && n2 <= 65487;
    }

    public boolean isProgressive() {
        int n2 = this.getSegmentMarker();
        return n2 == 65474 || n2 == 65478 || n2 == 65482 || n2 == 65486;
    }

    public boolean isArithmeticCoding() {
        return this.getSegmentMarker() >= 65481;
    }
}

