/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.ole.win32;

import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.DISPPARAMS;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IConnectionPoint;
import org.eclipse.swt.internal.ole.win32.IConnectionPointContainer;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.ole.win32.VARIANT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.OleEventSink$1;
import org.eclipse.swt.ole.win32.OleEventTable;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.ole.win32.Variant;

final class OleEventSink {
    private OleControlSite widget;
    private COMObject iDispatch;
    private int refCount;
    private IUnknown objIUnknown;
    private int eventCookie;
    private GUID eventGuid;
    private OleEventTable eventTable;

    OleEventSink(OleControlSite oleControlSite, int n2, GUID gUID) {
        this.widget = oleControlSite;
        this.eventGuid = gUID;
        this.objIUnknown = new IUnknown(n2);
        this.createCOMInterfaces();
    }

    void connect() {
        int[] nArray = new int[1];
        if (this.objIUnknown.QueryInterface(COM.IIDIConnectionPointContainer, nArray) == 0) {
            IConnectionPointContainer iConnectionPointContainer = new IConnectionPointContainer(nArray[0]);
            int[] nArray2 = new int[1];
            if (iConnectionPointContainer.FindConnectionPoint(this.eventGuid, nArray2) == 0) {
                IConnectionPoint iConnectionPoint = new IConnectionPoint(nArray2[0]);
                int[] nArray3 = new int[1];
                if (iConnectionPoint.Advise(this.iDispatch.getAddress(), nArray3) == 0) {
                    this.eventCookie = nArray3[0];
                }
                iConnectionPoint.Release();
            }
            iConnectionPointContainer.Release();
        }
    }

    void addListener(int n2, OleListener oleListener) {
        if (oleListener == null) {
            OLE.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new OleEventTable();
        }
        this.eventTable.hook(n2, oleListener);
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    private void createCOMInterfaces() {
        this.iDispatch = new OleEventSink$1(this, new int[]{2, 0, 0, 1, 3, 4, 8});
    }

    void disconnect() {
        int[] nArray;
        if (this.eventCookie != 0 && this.objIUnknown != null && this.objIUnknown.QueryInterface(COM.IIDIConnectionPointContainer, nArray = new int[1]) == 0) {
            IConnectionPointContainer iConnectionPointContainer = new IConnectionPointContainer(nArray[0]);
            if (iConnectionPointContainer.FindConnectionPoint(this.eventGuid, nArray) == 0) {
                IConnectionPoint iConnectionPoint = new IConnectionPoint(nArray[0]);
                if (iConnectionPoint.Unadvise(this.eventCookie) == 0) {
                    this.eventCookie = 0;
                }
                iConnectionPoint.Release();
            }
            iConnectionPointContainer.Release();
        }
    }

    private void disposeCOMInterfaces() {
        if (this.iDispatch != null) {
            this.iDispatch.dispose();
        }
        this.iDispatch = null;
    }

    private int Invoke(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10;
        Object object;
        if (this.eventTable == null || !this.eventTable.hooks(n2)) {
            return 0;
        }
        Variant[] variantArray = null;
        if (n6 != 0) {
            object = new DISPPARAMS();
            COM.MoveMemory((DISPPARAMS)object, n6, DISPPARAMS.sizeof);
            variantArray = new Variant[((DISPPARAMS)object).cArgs];
            n10 = VARIANT.sizeof;
            int n11 = (((DISPPARAMS)object).cArgs - 1) * n10;
            for (int i2 = 0; i2 < ((DISPPARAMS)object).cArgs; ++i2) {
                variantArray[i2] = new Variant();
                variantArray[i2].setData(((DISPPARAMS)object).rgvarg + n11);
                n11 -= n10;
            }
        }
        object = new OleEvent();
        ((OleEvent)object).arguments = variantArray;
        this.notifyListener(n2, (OleEvent)object);
        if (variantArray != null) {
            for (n10 = 0; n10 < variantArray.length; ++n10) {
                variantArray[n10].dispose();
            }
        }
        return 0;
    }

    private void notifyListener(int n2, OleEvent oleEvent) {
        if (oleEvent == null) {
            OLE.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        oleEvent.type = n2;
        oleEvent.widget = this.widget;
        this.eventTable.sendEvent(oleEvent);
    }

    private int QueryInterface(int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            return -2147024809;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, n2, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown) || COM.IsEqualGUID(gUID, COM.IIDIDispatch) || COM.IsEqualGUID(gUID, this.eventGuid)) {
            COM.MoveMemory(n3, new int[]{this.iDispatch.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        COM.MoveMemory(n3, new int[]{0}, OS.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    void removeListener(int n2, OleListener oleListener) {
        if (oleListener == null) {
            OLE.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n2, oleListener);
    }

    boolean hasListeners() {
        return this.eventTable.hasEntries();
    }

    static /* synthetic */ int access$000(OleEventSink oleEventSink, int n2, int n3) {
        return oleEventSink.QueryInterface(n2, n3);
    }

    static /* synthetic */ int access$100(OleEventSink oleEventSink, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return oleEventSink.Invoke(n2, n3, n4, n5, n6, n7, n8, n9);
    }
}

