/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.CANDIDATEFORM;
import org.eclipse.swt.internal.win32.COMPOSITIONFORM;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.widgets.Widget;

public class Caret
extends Widget {
    Canvas parent;
    int x;
    int y;
    int width;
    int height;
    boolean moved;
    boolean resized;
    boolean isVisible;
    Image image;
    Font font;
    LOGFONT oldFont;

    public Caret(Canvas canvas, int n2) {
        super(canvas, n2);
        this.parent = canvas;
        this.createWidget();
    }

    void createWidget() {
        this.isVisible = true;
        if (this.parent.getCaret() == null) {
            this.parent.setCaret(this);
        }
    }

    int defaultFont() {
        int n2 = this.parent.handle;
        int n3 = OS.ImmGetDefaultIMEWnd(n2);
        int n4 = 0;
        if (n3 != 0) {
            n4 = OS.SendMessage(n3, 49, 0, 0);
        }
        if (n4 == 0) {
            n4 = OS.SendMessage(n2, 49, 0, 0);
        }
        if (n4 == 0) {
            return this.parent.defaultFont();
        }
        return n4;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    Rectangle getBoundsInPixels() {
        int[] nArray;
        if (this.image != null) {
            Rectangle rectangle = this.image.getBoundsInPixels();
            return new Rectangle(this.x, this.y, rectangle.width, rectangle.height);
        }
        if (!OS.IsWinCE && this.width == 0 && OS.SystemParametersInfo(8198, 0, nArray = new int[1], 0)) {
            return new Rectangle(this.x, this.y, nArray[0], this.height);
        }
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Font getFont() {
        this.checkWidget();
        if (this.font == null) {
            int n2 = this.defaultFont();
            return Font.win32_new(this.display, n2);
        }
        return this.font;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Point getLocation() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getLocationInPixels());
    }

    Point getLocationInPixels() {
        return new Point(this.x, this.y);
    }

    public Canvas getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Point getSize() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getSizeInPixels());
    }

    Point getSizeInPixels() {
        int[] nArray;
        if (this.image != null) {
            Rectangle rectangle = this.image.getBoundsInPixels();
            return new Point(rectangle.width, rectangle.height);
        }
        if (!OS.IsWinCE && this.width == 0 && OS.SystemParametersInfo(8198, 0, nArray = new int[1], 0)) {
            return new Point(nArray[0], this.height);
        }
        return new Point(this.width, this.height);
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.isVisible;
    }

    boolean hasFocus() {
        return this.parent.handle == OS.GetFocus();
    }

    boolean isFocusCaret() {
        return this.parent.caret == this && this.hasFocus();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.isVisible && this.parent.isVisible() && this.hasFocus();
    }

    void killFocus() {
        OS.DestroyCaret();
        this.restoreIMEFont();
    }

    void move() {
        this.moved = false;
        if (!OS.SetCaretPos(this.x, this.y)) {
            return;
        }
        this.resizeIME();
    }

    void resizeIME() {
        if (!OS.IsDBLocale) {
            return;
        }
        POINT pOINT = new POINT();
        if (!OS.GetCaretPos(pOINT)) {
            return;
        }
        int n2 = this.parent.handle;
        int n3 = OS.ImmGetContext(n2);
        IME iME = this.parent.getIME();
        if (iME != null && iME.isInlineEnabled()) {
            Point point = this.getSizeInPixels();
            CANDIDATEFORM cANDIDATEFORM = new CANDIDATEFORM();
            cANDIDATEFORM.dwStyle = 128;
            cANDIDATEFORM.ptCurrentPos = pOINT;
            cANDIDATEFORM.rcArea = new RECT();
            OS.SetRect(cANDIDATEFORM.rcArea, pOINT.x, pOINT.y, pOINT.x + point.x, pOINT.y + point.y);
            OS.ImmSetCandidateWindow(n3, cANDIDATEFORM);
        } else {
            RECT rECT = new RECT();
            OS.GetClientRect(n2, rECT);
            COMPOSITIONFORM cOMPOSITIONFORM = new COMPOSITIONFORM();
            cOMPOSITIONFORM.dwStyle = 1;
            cOMPOSITIONFORM.x = pOINT.x;
            cOMPOSITIONFORM.y = pOINT.y;
            cOMPOSITIONFORM.left = rECT.left;
            cOMPOSITIONFORM.right = rECT.right;
            cOMPOSITIONFORM.top = rECT.top;
            cOMPOSITIONFORM.bottom = rECT.bottom;
            OS.ImmSetCompositionWindow(n3, cOMPOSITIONFORM);
        }
        OS.ImmReleaseContext(n2, n3);
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this == this.parent.getCaret()) {
            this.parent.setCaret(null);
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.image = null;
        this.font = null;
        this.oldFont = null;
    }

    void resize() {
        int[] nArray;
        this.resized = false;
        int n2 = this.parent.handle;
        OS.DestroyCaret();
        int n3 = this.image != null ? this.image.handle : 0;
        int n4 = this.width;
        if (!OS.IsWinCE && this.image == null && n4 == 0 && OS.SystemParametersInfo(8198, 0, nArray = new int[1], 0)) {
            n4 = nArray[0];
        }
        OS.CreateCaret(n2, n3, n4, this.height);
        OS.SetCaretPos(this.x, this.y);
        OS.ShowCaret(n2);
        this.move();
    }

    void restoreIMEFont() {
        if (!OS.IsDBLocale) {
            return;
        }
        if (this.oldFont == null) {
            return;
        }
        int n2 = this.parent.handle;
        int n3 = OS.ImmGetContext(n2);
        OS.ImmSetCompositionFont(n3, this.oldFont);
        OS.ImmReleaseContext(n2, n3);
        this.oldFont = null;
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        this.checkWidget();
        this.setBoundsInPixels(DPIUtil.autoScaleUp(n2), DPIUtil.autoScaleUp(n3), DPIUtil.autoScaleUp(n4), DPIUtil.autoScaleUp(n5));
    }

    void setBoundsInPixels(int n2, int n3, int n4, int n5) {
        boolean bl2;
        boolean bl3 = this.x == n2 && this.y == n3;
        boolean bl4 = bl2 = this.width == n4 && this.height == n5;
        if (bl3 && bl2) {
            return;
        }
        this.x = n2;
        this.y = n3;
        this.width = n4;
        this.height = n5;
        if (bl2) {
            this.moved = true;
            if (this.isVisible && this.hasFocus()) {
                this.move();
            }
        } else {
            this.resized = true;
            if (this.isVisible && this.hasFocus()) {
                this.resize();
            }
        }
    }

    public void setBounds(Rectangle rectangle) {
        if (rectangle == null) {
            this.error(4);
        }
        this.setBoundsInPixels(DPIUtil.autoScaleUp(rectangle));
    }

    void setBoundsInPixels(Rectangle rectangle) {
        this.setBoundsInPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    void setFocus() {
        int[] nArray;
        int n2 = this.parent.handle;
        int n3 = 0;
        if (this.image != null) {
            n3 = this.image.handle;
        }
        int n4 = this.width;
        if (!OS.IsWinCE && this.image == null && n4 == 0 && OS.SystemParametersInfo(8198, 0, nArray = new int[1], 0)) {
            n4 = nArray[0];
        }
        OS.CreateCaret(n2, n3, n4, this.height);
        this.move();
        this.setIMEFont();
        if (this.isVisible) {
            OS.ShowCaret(n2);
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        this.font = font;
        if (this.hasFocus()) {
            this.setIMEFont();
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        if (this.isVisible && this.hasFocus()) {
            this.resize();
        }
    }

    void setIMEFont() {
        LOGFONT lOGFONT;
        if (!OS.IsDBLocale) {
            return;
        }
        int n2 = 0;
        if (this.font != null) {
            n2 = this.font.handle;
        }
        if (n2 == 0) {
            n2 = this.defaultFont();
        }
        int n3 = this.parent.handle;
        int n4 = OS.ImmGetContext(n3);
        if (this.oldFont == null) {
            LOGFONT lOGFONT2 = this.oldFont = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
            if (!OS.ImmGetCompositionFont(n4, this.oldFont)) {
                this.oldFont = null;
            }
        }
        LOGFONT lOGFONT3 = lOGFONT = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
        if (OS.GetObject(n2, LOGFONT.sizeof, lOGFONT) != 0) {
            OS.ImmSetCompositionFont(n4, lOGFONT);
        }
        OS.ImmReleaseContext(n3, n4);
    }

    public void setLocation(int n2, int n3) {
        this.checkWidget();
        this.setLocationInPixels(DPIUtil.autoScaleUp(n2), DPIUtil.autoScaleUp(n3));
    }

    void setLocationInPixels(int n2, int n3) {
        if (this.x == n2 && this.y == n3) {
            return;
        }
        this.x = n2;
        this.y = n3;
        this.moved = true;
        if (this.isVisible && this.hasFocus()) {
            this.move();
        }
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        point = DPIUtil.autoScaleUp(point);
        this.setLocationInPixels(point.x, point.y);
    }

    public void setSize(int n2, int n3) {
        this.checkWidget();
        this.setSizeInPixels(DPIUtil.autoScaleUp(n2), DPIUtil.autoScaleUp(n3));
    }

    void setSizeInPixels(int n2, int n3) {
        if (this.width == n2 && this.height == n3) {
            return;
        }
        this.width = n2;
        this.height = n3;
        this.resized = true;
        if (this.isVisible && this.hasFocus()) {
            this.resize();
        }
    }

    public void setSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        point = DPIUtil.autoScaleUp(point);
        this.setSizeInPixels(point.x, point.y);
    }

    public void setVisible(boolean bl2) {
        this.checkWidget();
        if (bl2 == this.isVisible) {
            return;
        }
        this.isVisible = bl2;
        int n2 = this.parent.handle;
        if (OS.GetFocus() != n2) {
            return;
        }
        if (!this.isVisible) {
            OS.HideCaret(n2);
        } else {
            if (this.resized) {
                this.resize();
            } else if (this.moved) {
                this.move();
            }
            OS.ShowCaret(n2);
        }
    }
}

