/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.Item;

public class ExpandItem
extends Item {
    ExpandBar parent;
    Control control;
    boolean expanded;
    boolean hover;
    int x;
    int y;
    int width;
    int height;
    int imageHeight;
    int imageWidth;
    static final int TEXT_INSET = 6;
    static final int BORDER = 1;
    static final int CHEVRON_SIZE = 24;

    public ExpandItem(ExpandBar expandBar, int n2) {
        this(expandBar, n2, ExpandItem.checkNull(expandBar).getItemCount());
    }

    public ExpandItem(ExpandBar expandBar, int n2, int n3) {
        super(expandBar, n2);
        this.parent = expandBar;
        expandBar.createItem(this, n2, n3);
    }

    static ExpandBar checkNull(ExpandBar expandBar) {
        if (expandBar == null) {
            SWT.error(4);
        }
        return expandBar;
    }

    private void drawChevron(int n2, RECT rECT) {
        int[] nArray;
        int[] nArray2;
        int n3;
        int n4;
        int n5 = OS.SelectObject(n2, OS.GetSysColorBrush(OS.COLOR_BTNFACE));
        OS.PatBlt(n2, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top, 15728673);
        OS.SelectObject(n2, n5);
        rECT.left += 4;
        rECT.top += 4;
        rECT.right -= 4;
        rECT.bottom -= 4;
        int n6 = OS.CreatePen(0, 1, this.parent.getForegroundPixel());
        int n7 = OS.SelectObject(n2, n6);
        if (this.expanded) {
            n4 = rECT.left + 5;
            n3 = rECT.top + 7;
            nArray2 = new int[]{n4, n3, n4 + 1, n3, n4 + 1, n3 - 1, n4 + 2, n3 - 1, n4 + 2, n3 - 2, n4 + 3, n3 - 2, n4 + 3, n3 - 3, n4 + 3, n3 - 2, n4 + 4, n3 - 2, n4 + 4, n3 - 1, n4 + 5, n3 - 1, n4 + 5, n3, n4 + 7, n3};
            nArray = new int[]{n4, n3 += 4, n4 + 1, n3, n4 + 1, n3 - 1, n4 + 2, n3 - 1, n4 + 2, n3 - 2, n4 + 3, n3 - 2, n4 + 3, n3 - 3, n4 + 3, n3 - 2, n4 + 4, n3 - 2, n4 + 4, n3 - 1, n4 + 5, n3 - 1, n4 + 5, n3, n4 + 7, n3};
        } else {
            n4 = rECT.left + 5;
            n3 = rECT.top + 4;
            nArray2 = new int[]{n4, n3, n4 + 1, n3, n4 + 1, n3 + 1, n4 + 2, n3 + 1, n4 + 2, n3 + 2, n4 + 3, n3 + 2, n4 + 3, n3 + 3, n4 + 3, n3 + 2, n4 + 4, n3 + 2, n4 + 4, n3 + 1, n4 + 5, n3 + 1, n4 + 5, n3, n4 + 7, n3};
            nArray = new int[]{n4, n3 += 4, n4 + 1, n3, n4 + 1, n3 + 1, n4 + 2, n3 + 1, n4 + 2, n3 + 2, n4 + 3, n3 + 2, n4 + 3, n3 + 3, n4 + 3, n3 + 2, n4 + 4, n3 + 2, n4 + 4, n3 + 1, n4 + 5, n3 + 1, n4 + 5, n3, n4 + 7, n3};
        }
        OS.Polyline(n2, nArray2, nArray2.length / 2);
        OS.Polyline(n2, nArray, nArray.length / 2);
        if (this.hover) {
            n4 = OS.CreatePen(0, 1, OS.GetSysColor(OS.COLOR_3DHILIGHT));
            n3 = OS.CreatePen(0, 1, OS.GetSysColor(OS.COLOR_3DSHADOW));
            OS.SelectObject(n2, n4);
            int[] nArray3 = new int[]{rECT.left, rECT.bottom, rECT.left, rECT.top, rECT.right, rECT.top};
            OS.Polyline(n2, nArray3, nArray3.length / 2);
            OS.SelectObject(n2, n3);
            int[] nArray4 = new int[]{rECT.right, rECT.top, rECT.right, rECT.bottom, rECT.left, rECT.bottom};
            OS.Polyline(n2, nArray4, nArray4.length / 2);
            OS.SelectObject(n2, n7);
            OS.DeleteObject(n4);
            OS.DeleteObject(n3);
        } else {
            OS.SelectObject(n2, n7);
        }
        OS.DeleteObject(n6);
    }

    void drawItem(GC gC, int n2, RECT rECT, boolean bl2) {
        int n3;
        int n4;
        int n5;
        int n6 = gC.handle;
        int n7 = this.parent.getBandHeight();
        RECT rECT2 = new RECT();
        OS.SetRect(rECT2, this.x, this.y, this.x + this.width, this.y + n7);
        if (n2 != 0) {
            OS.DrawThemeBackground(n2, n6, 8, 0, rECT2, rECT);
        } else {
            n5 = OS.SelectObject(n6, OS.GetSysColorBrush(OS.COLOR_BTNFACE));
            OS.PatBlt(n6, rECT2.left, rECT2.top, rECT2.right - rECT2.left, rECT2.bottom - rECT2.top, 15728673);
            OS.SelectObject(n6, n5);
        }
        if (this.image != null) {
            rECT2.left += 6;
            if (this.imageHeight > n7) {
                gC.drawImage(this.image, DPIUtil.autoScaleDown(rECT2.left), DPIUtil.autoScaleDown(rECT2.top + n7 - this.imageHeight));
            } else {
                gC.drawImage(this.image, DPIUtil.autoScaleDown(rECT2.left), DPIUtil.autoScaleDown(rECT2.top + (n7 - this.imageHeight) / 2));
            }
            rECT2.left += this.imageWidth;
        }
        if (this.text.length() > 0) {
            rECT2.left += 6;
            TCHAR tCHAR = OS.IsUnicode && (this.style & Integer.MIN_VALUE) != 0 ? (((n4 = OS.GetWindowLong(this.parent.handle, -20)) & 0x400000) != 0 ? new TCHAR(this.parent.getCodePage(), '\u202a' + this.text, false) : new TCHAR(this.parent.getCodePage(), '\u202b' + this.text, false)) : new TCHAR(this.parent.getCodePage(), this.text, false);
            if (n2 != 0) {
                OS.DrawThemeText(n2, n6, 8, 0, tCHAR.chars, tCHAR.length(), 36, 0, rECT2);
            } else {
                n4 = OS.SetBkMode(n6, 1);
                OS.DrawText(n6, tCHAR, tCHAR.length(), rECT2, 36);
                OS.SetBkMode(n6, n4);
            }
        }
        n5 = 24;
        rECT2.left = rECT2.right - n5;
        rECT2.top = this.y + (n7 - n5) / 2;
        rECT2.bottom = rECT2.top + n5;
        if (n2 != 0) {
            n4 = this.expanded ? 6 : 7;
            n3 = this.hover ? 2 : 1;
            OS.DrawThemeBackground(n2, n6, n4, n3, rECT2, rECT);
        } else {
            this.drawChevron(n6, rECT2);
        }
        if (bl2) {
            OS.SetRect(rECT2, this.x + 1, this.y + 1, this.x + this.width - 2, this.y + n7 - 2);
            OS.DrawFocusRect(n6, rECT2);
        }
        if (this.expanded && !this.parent.isAppThemed()) {
            n4 = OS.CreatePen(0, 1, OS.GetSysColor(OS.COLOR_BTNFACE));
            n3 = OS.SelectObject(n6, n4);
            int[] nArray = new int[]{this.x, this.y + n7, this.x, this.y + n7 + this.height, this.x + this.width - 1, this.y + n7 + this.height, this.x + this.width - 1, this.y + n7 - 1};
            OS.Polyline(n6, nArray, nArray.length / 2);
            OS.SelectObject(n6, n3);
            OS.DeleteObject(n4);
        }
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public boolean getExpanded() {
        this.checkWidget();
        return this.expanded;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getHeaderHeightInPixels());
    }

    int getHeaderHeightInPixels() {
        return Math.max(this.parent.getBandHeight(), this.imageHeight);
    }

    public int getHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getHeightInPixels());
    }

    int getHeightInPixels() {
        return this.height;
    }

    public ExpandBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    int getPreferredWidth(int n2, int n3) {
        int n4 = 36;
        if (this.image != null) {
            n4 += 6 + this.imageWidth;
        }
        if (this.text.length() > 0) {
            RECT rECT = new RECT();
            TCHAR tCHAR = new TCHAR(this.parent.getCodePage(), this.text, false);
            if (n2 != 0) {
                OS.GetThemeTextExtent(n2, n3, 8, 0, tCHAR.chars, tCHAR.length(), 32, null, rECT);
            } else {
                OS.DrawText(n3, tCHAR, tCHAR.length(), rECT, 1024);
            }
            n4 += rECT.right - rECT.left;
        }
        return n4;
    }

    boolean isHover(int n2, int n3) {
        int n4 = this.parent.getBandHeight();
        return this.x < n2 && n2 < this.x + this.width && this.y < n3 && n3 < this.y + n4;
    }

    void redraw(boolean bl2) {
        int n2 = this.parent.handle;
        int n3 = this.parent.getBandHeight();
        RECT rECT = new RECT();
        int n4 = bl2 ? this.x : this.x + this.width - n3;
        OS.SetRect(rECT, n4, this.y, this.x + this.width, this.y + n3);
        OS.InvalidateRect(n2, rECT, true);
        if (this.imageHeight > n3) {
            OS.SetRect(rECT, this.x + 6, this.y + n3 - this.imageHeight, this.x + 6 + this.imageWidth, this.y);
            OS.InvalidateRect(n2, rECT, true);
        }
        if (!this.parent.isAppThemed()) {
            OS.SetRect(rECT, this.x, this.y + n3, this.x + this.width, this.y + n3 + this.height + 1);
            OS.InvalidateRect(n2, rECT, true);
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.control = null;
    }

    void setBoundsInPixels(int n2, int n3, int n4, int n5, boolean bl2, boolean bl3) {
        this.redraw(true);
        int n6 = this.parent.getBandHeight();
        if (bl2) {
            if (this.imageHeight > n6) {
                n3 += this.imageHeight - n6;
            }
            this.x = n2;
            this.y = n3;
            this.redraw(true);
        }
        if (bl3) {
            this.width = n4;
            this.height = n5;
            this.redraw(true);
        }
        if (this.control != null && !this.control.isDisposed()) {
            if (!this.parent.isAppThemed()) {
                ++n2;
                n4 = Math.max(0, n4 - 2);
                n5 = Math.max(0, n5 - 1);
            }
            if (bl2 && bl3) {
                this.control.setBoundsInPixels(n2, n3 + n6, n4, n5);
            }
            if (bl2 && !bl3) {
                this.control.setLocationInPixels(n2, n3 + n6);
            }
            if (!bl2 && bl3) {
                this.control.setSizeInPixels(n4, n5);
            }
        }
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        this.control = control;
        if (control != null) {
            int n2 = this.parent.getBandHeight();
            control.setVisible(this.expanded);
            if (!this.parent.isAppThemed()) {
                int n3 = Math.max(0, this.width - 2);
                int n4 = Math.max(0, this.height - 1);
                control.setBoundsInPixels(this.x + 1, this.y + n2, n3, n4);
            } else {
                control.setBoundsInPixels(this.x, this.y + n2, this.width, this.height);
            }
        }
    }

    public void setExpanded(boolean bl2) {
        this.checkWidget();
        this.expanded = bl2;
        this.parent.showItem(this);
    }

    public void setHeight(int n2) {
        this.checkWidget();
        this.setHeightInPixels(DPIUtil.autoScaleUp(n2));
    }

    void setHeightInPixels(int n2) {
        if (n2 < 0) {
            return;
        }
        this.setBoundsInPixels(0, 0, this.width, n2, false, true);
        if (this.expanded) {
            this.parent.layoutItems(this.parent.indexOf(this) + 1, true);
        }
    }

    @Override
    public void setImage(Image image) {
        super.setImage(image);
        int n2 = this.imageHeight;
        if (image != null) {
            Rectangle rectangle = image.getBoundsInPixels();
            this.imageHeight = rectangle.height;
            this.imageWidth = rectangle.width;
        } else {
            this.imageWidth = 0;
            this.imageHeight = 0;
        }
        if (n2 != this.imageHeight) {
            this.parent.layoutItems(this.parent.indexOf(this), true);
        } else {
            this.redraw(true);
        }
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        if ((this.state & 0x400000) != 0) {
            this.updateTextDirection(0x6000000);
        }
        this.redraw(true);
    }
}

