/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TF_DISPLAYATTRIBUTE;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public class IME
extends Widget {
    Canvas parent;
    int caretOffset;
    int startOffset;
    int commitCount;
    String text;
    int[] ranges;
    TextStyle[] styles;
    static final int WM_MSIME_MOUSE = OS.RegisterWindowMessage(new TCHAR(0, "MSIMEMouseOperation", true));
    static final byte[] IID_ITfInputProcessorProfiles = new byte[16];
    static final byte[] IID_ITfDisplayAttributeProvider = new byte[16];
    static final byte[] CLSID_TF_InputProcessorProfiles = new byte[16];
    static final byte[] GUID_TFCAT_TIP_KEYBOARD = new byte[16];
    static final int UNDERLINE_IME_DOT = 65536;
    static final int UNDERLINE_IME_DASH = 131072;
    static final int UNDERLINE_IME_THICK = 196608;

    IME() {
    }

    public IME(Canvas canvas, int n2) {
        super(canvas, n2);
        this.parent = canvas;
        this.createWidget();
    }

    void createWidget() {
        this.text = "";
        this.startOffset = -1;
        if (this.parent.getIME() == null) {
            this.parent.setIME(this);
        }
    }

    public int getCaretOffset() {
        this.checkWidget();
        return this.startOffset + this.caretOffset;
    }

    public int getCommitCount() {
        this.checkWidget();
        return this.commitCount;
    }

    public int getCompositionOffset() {
        this.checkWidget();
        return this.startOffset;
    }

    TF_DISPLAYATTRIBUTE getDisplayAttribute(short s2, int n2) {
        int[] nArray = new int[1];
        int n3 = OS.CoCreateInstance(CLSID_TF_InputProcessorProfiles, 0, 1, IID_ITfInputProcessorProfiles, nArray);
        TF_DISPLAYATTRIBUTE tF_DISPLAYATTRIBUTE = null;
        if (n3 == 0) {
            int[] nArray2;
            byte[] byArray = new byte[16];
            byte[] byArray2 = new byte[16];
            n3 = OS.VtblCall(8, nArray[0], s2, GUID_TFCAT_TIP_KEYBOARD, byArray, byArray2);
            if (n3 == 0 && (n3 = OS.CoCreateInstance(byArray, 0, 1, IID_ITfDisplayAttributeProvider, nArray2 = new int[1])) == 0) {
                int[] nArray3 = new int[1];
                n3 = OS.VtblCall(3, nArray2[0], nArray3);
                if (n3 == 0) {
                    int[] nArray4 = new int[1];
                    TF_DISPLAYATTRIBUTE tF_DISPLAYATTRIBUTE2 = new TF_DISPLAYATTRIBUTE();
                    while ((n3 = OS.VtblCall(4, nArray3[0], 1, nArray4, (int[])null)) == 0) {
                        OS.VtblCall(5, nArray4[0], tF_DISPLAYATTRIBUTE2);
                        OS.VtblCall(2, nArray4[0]);
                        if (tF_DISPLAYATTRIBUTE2.bAttr != n2) continue;
                        tF_DISPLAYATTRIBUTE = tF_DISPLAYATTRIBUTE2;
                        break;
                    }
                    n3 = OS.VtblCall(2, nArray3[0]);
                }
                n3 = OS.VtblCall(2, nArray2[0]);
            }
            n3 = OS.VtblCall(2, nArray[0]);
        }
        if (tF_DISPLAYATTRIBUTE == null) {
            tF_DISPLAYATTRIBUTE = new TF_DISPLAYATTRIBUTE();
            switch (n2) {
                case 0: {
                    tF_DISPLAYATTRIBUTE.lsStyle = 4;
                    break;
                }
                case 1: 
                case 2: {
                    tF_DISPLAYATTRIBUTE.lsStyle = 1;
                    tF_DISPLAYATTRIBUTE.fBoldLine = n2 == 1;
                }
            }
        }
        return tF_DISPLAYATTRIBUTE;
    }

    public int[] getRanges() {
        this.checkWidget();
        if (this.ranges == null) {
            return new int[0];
        }
        int[] nArray = new int[this.ranges.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = this.ranges[i2] + this.startOffset;
        }
        return nArray;
    }

    public TextStyle[] getStyles() {
        this.checkWidget();
        if (this.styles == null) {
            return new TextStyle[0];
        }
        TextStyle[] textStyleArray = new TextStyle[this.styles.length];
        System.arraycopy(this.styles, 0, textStyleArray, 0, this.styles.length);
        return textStyleArray;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean getWideCaret() {
        this.checkWidget();
        int n2 = OS.GetKeyboardLayout(0);
        short s2 = (short)OS.LOWORD(n2);
        return OS.PRIMARYLANGID(s2) == 18;
    }

    boolean isInlineEnabled() {
        if (OS.IsWinCE || OS.WIN32_VERSION < OS.VERSION(5, 1)) {
            return false;
        }
        return OS.IsDBLocale && this.hooks(43);
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this == this.parent.getIME()) {
            this.parent.setIME(null);
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.text = null;
        this.styles = null;
        this.ranges = null;
    }

    public void setCompositionOffset(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        if (this.startOffset != -1) {
            this.startOffset = n2;
        }
    }

    LRESULT WM_IME_COMPOSITION(int n2, int n3) {
        if (!this.isInlineEnabled()) {
            return null;
        }
        this.ranges = null;
        this.styles = null;
        this.commitCount = 0;
        this.caretOffset = 0;
        int n4 = this.parent.handle;
        int n5 = OS.ImmGetContext(n4);
        int n6 = this.parent.getCodePage();
        if (n5 != 0) {
            short s2;
            Object object;
            Object object2;
            int n7;
            TCHAR tCHAR = null;
            if ((n3 & 0x800) != 0) {
                n7 = OS.ImmGetCompositionString(n5, 2048, (TCHAR)null, 0);
                if (n7 > 0) {
                    tCHAR = new TCHAR(n6, n7 / TCHAR.sizeof);
                    OS.ImmGetCompositionString(n5, 2048, tCHAR, n7);
                    if (this.startOffset == -1) {
                        object2 = new Event();
                        ((Event)object2).detail = 3;
                        this.sendEvent(43, (Event)object2);
                        this.startOffset = ((Event)object2).start;
                    }
                    object2 = new Event();
                    ((Event)object2).detail = 1;
                    ((Event)object2).start = this.startOffset;
                    ((Event)object2).end = this.startOffset + this.text.length();
                    this.text = tCHAR != null ? tCHAR.toString() : "";
                    ((Event)object2).text = this.text;
                    this.commitCount = this.text.length();
                    this.sendEvent(43, (Event)object2);
                    object = this.text;
                    this.text = "";
                    this.startOffset = -1;
                    this.commitCount = 0;
                    if (((Event)object2).doit) {
                        Display display = this.display;
                        display.lastKey = 0;
                        display.lastDead = false;
                        display.lastNull = false;
                        display.lastVirtual = false;
                        n7 = ((String)object).length();
                        for (s2 = 0; s2 < n7; ++s2) {
                            char c2 = ((String)object).charAt(s2);
                            display.lastAscii = c2;
                            object2 = new Event();
                            ((Event)object2).character = c2;
                            this.parent.sendEvent(1, (Event)object2);
                        }
                    }
                }
                if ((n3 & 8) == 0) {
                    return LRESULT.ONE;
                }
            }
            tCHAR = null;
            if ((n3 & 8) != 0) {
                n7 = OS.ImmGetCompositionString(n5, 8, (TCHAR)null, 0);
                if (n7 > 0) {
                    tCHAR = new TCHAR(n6, n7 / TCHAR.sizeof);
                    OS.ImmGetCompositionString(n5, 8, tCHAR, n7);
                    if ((n3 & 0x80) != 0) {
                        this.caretOffset = OS.ImmGetCompositionString(n5, 128, (TCHAR)null, 0);
                    }
                    object2 = null;
                    if ((n3 & 0x20) != 0 && (n7 = OS.ImmGetCompositionString(n5, 32, (int[])null, 0)) > 0) {
                        object2 = new int[n7 / 4];
                        OS.ImmGetCompositionString(n5, 32, (int[])object2, n7);
                    }
                    if ((n3 & 0x10) != 0 && object2 != null && (n7 = OS.ImmGetCompositionString(n5, 16, (byte[])null, 0)) > 0) {
                        object = new byte[n7];
                        OS.ImmGetCompositionString(n5, 16, (byte[])object, n7);
                        n7 = ((Object)object2).length - 1;
                        this.ranges = new int[n7 * 2];
                        this.styles = new TextStyle[n7];
                        int n8 = OS.GetKeyboardLayout(0);
                        s2 = (short)OS.LOWORD(n8);
                        TF_DISPLAYATTRIBUTE tF_DISPLAYATTRIBUTE = null;
                        TextStyle textStyle = null;
                        block19: for (int i2 = 0; i2 < n7; ++i2) {
                            int n9;
                            this.ranges[i2 * 2] = (int)object2[i2];
                            this.ranges[i2 * 2 + 1] = (int)(object2[i2 + 1] - true);
                            this.styles[i2] = textStyle = new TextStyle();
                            if (object2[i2] < 0 || object2[i2] >= ((Object)object).length || (tF_DISPLAYATTRIBUTE = this.getDisplayAttribute(s2, (int)object[object2[i2]])) == null) continue;
                            switch (tF_DISPLAYATTRIBUTE.crText.type) {
                                case 2: {
                                    textStyle.foreground = Color.win32_new(this.display, tF_DISPLAYATTRIBUTE.crText.cr);
                                    break;
                                }
                                case 1: {
                                    n9 = OS.GetSysColor(tF_DISPLAYATTRIBUTE.crText.cr);
                                    textStyle.foreground = Color.win32_new(this.display, n9);
                                }
                            }
                            switch (tF_DISPLAYATTRIBUTE.crBk.type) {
                                case 2: {
                                    textStyle.background = Color.win32_new(this.display, tF_DISPLAYATTRIBUTE.crBk.cr);
                                    break;
                                }
                                case 1: {
                                    n9 = OS.GetSysColor(tF_DISPLAYATTRIBUTE.crBk.cr);
                                    textStyle.background = Color.win32_new(this.display, n9);
                                }
                            }
                            switch (tF_DISPLAYATTRIBUTE.crLine.type) {
                                case 2: {
                                    textStyle.underlineColor = Color.win32_new(this.display, tF_DISPLAYATTRIBUTE.crLine.cr);
                                    break;
                                }
                                case 1: {
                                    n9 = OS.GetSysColor(tF_DISPLAYATTRIBUTE.crLine.cr);
                                    textStyle.underlineColor = Color.win32_new(this.display, n9);
                                }
                            }
                            textStyle.underline = tF_DISPLAYATTRIBUTE.lsStyle != 0;
                            switch (tF_DISPLAYATTRIBUTE.lsStyle) {
                                case 4: {
                                    textStyle.underlineStyle = 3;
                                    continue block19;
                                }
                                case 3: {
                                    textStyle.underlineStyle = 131072;
                                    continue block19;
                                }
                                case 2: {
                                    textStyle.underlineStyle = 65536;
                                    continue block19;
                                }
                                case 1: {
                                    textStyle.underlineStyle = tF_DISPLAYATTRIBUTE.fBoldLine ? 196608 : 0;
                                }
                            }
                        }
                    }
                }
                OS.ImmReleaseContext(n4, n5);
            }
            n7 = this.startOffset + this.text.length();
            if (this.startOffset == -1) {
                object2 = new Event();
                ((Event)object2).detail = 3;
                this.sendEvent(43, (Event)object2);
                this.startOffset = ((Event)object2).start;
                n7 = ((Event)object2).end;
            }
            object2 = new Event();
            ((Event)object2).detail = 1;
            ((Event)object2).start = this.startOffset;
            ((Event)object2).end = n7;
            this.text = tCHAR != null ? tCHAR.toString() : "";
            ((Event)object2).text = this.text;
            this.sendEvent(43, (Event)object2);
            if (this.text.length() == 0) {
                this.startOffset = -1;
                this.ranges = null;
                this.styles = null;
            }
        }
        return LRESULT.ONE;
    }

    LRESULT WM_IME_COMPOSITION_START(int n2, int n3) {
        return this.isInlineEnabled() ? LRESULT.ONE : null;
    }

    LRESULT WM_IME_ENDCOMPOSITION(int n2, int n3) {
        return this.isInlineEnabled() ? LRESULT.ONE : null;
    }

    LRESULT WM_KEYDOWN(int n2, int n3) {
        int n4;
        short s2;
        if (n2 == 25 && OS.PRIMARYLANGID(s2 = (short)OS.LOWORD(n4 = OS.GetKeyboardLayout(0))) == 18) {
            Event event = new Event();
            event.detail = 3;
            this.sendEvent(43, event);
            if (event.start == event.end) {
                event.text = null;
                event.end = event.start + 1;
                this.sendEvent(43, event);
            }
            if (event.text != null && event.text.length() > 0) {
                TCHAR tCHAR;
                int n5;
                int n6;
                int n7;
                int n8 = event.text.length();
                if (n8 > 1) {
                    event.end = event.start + 1;
                }
                if ((n7 = OS.ImmEscape(n4, n6 = OS.ImmGetContext(n5 = this.parent.handle), 4104, tCHAR = new TCHAR(0, event.text, true))) != 0) {
                    this.sendEvent(43, event);
                }
            }
        }
        return null;
    }

    LRESULT WM_KILLFOCUS(int n2, int n3) {
        if (!this.isInlineEnabled()) {
            return null;
        }
        int n4 = this.parent.handle;
        int n5 = OS.ImmGetContext(n4);
        if (n5 != 0) {
            if (OS.ImmGetOpenStatus(n5)) {
                OS.ImmNotifyIME(n5, 21, 1, 0);
            }
            OS.ImmReleaseContext(n4, n5);
        }
        return null;
    }

    LRESULT WM_LBUTTONDOWN(int n2, int n3) {
        if (!this.isInlineEnabled()) {
            return null;
        }
        int n4 = this.parent.handle;
        int n5 = OS.ImmGetContext(n4);
        if (n5 != 0) {
            if (OS.ImmGetOpenStatus(n5) && OS.ImmGetCompositionString(n5, 8, (TCHAR)null, 0) > 0) {
                Event event = new Event();
                event.detail = 2;
                event.setLocationInPixels(OS.GET_X_LPARAM(n3), OS.GET_Y_LPARAM(n3));
                this.sendEvent(43, event);
                int n6 = event.index;
                int n7 = this.text.length();
                if (n6 != -1 && this.startOffset != -1 && this.startOffset <= n6 && n6 < this.startOffset + n7) {
                    int n8 = OS.ImmGetDefaultIMEWnd(n4);
                    n6 = event.index + event.count - this.startOffset;
                    int n9 = event.count > 0 ? 1 : 2;
                    int n10 = OS.MAKEWPARAM(OS.MAKEWORD(1, n9), n6);
                    OS.SendMessage(n8, WM_MSIME_MOUSE, n10, n5);
                } else {
                    OS.ImmNotifyIME(n5, 21, 1, 0);
                }
            }
            OS.ImmReleaseContext(n4, n5);
        }
        return null;
    }

    static {
        OS.IIDFromString("{1F02B6C5-7842-4EE6-8A0B-9A24183A95CA}\u0000".toCharArray(), IID_ITfInputProcessorProfiles);
        OS.IIDFromString("{fee47777-163c-4769-996a-6e9c50ad8f54}\u0000".toCharArray(), IID_ITfDisplayAttributeProvider);
        OS.IIDFromString("{33C53A50-F456-4884-B049-85FD643ECFED}\u0000".toCharArray(), CLSID_TF_InputProcessorProfiles);
        OS.IIDFromString("{34745C63-B2F0-4784-8B67-5E12C8701A31}\u0000".toCharArray(), GUID_TFCAT_TIP_KEYBOARD);
    }
}

