/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.CREATESTRUCT;
import org.eclipse.swt.internal.win32.LOGBRUSH;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MINMAXINFO;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.NMTTDISPINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SHACTIVATEINFO;
import org.eclipse.swt.internal.win32.SIPINFO;
import org.eclipse.swt.internal.win32.STARTUPINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TOOLINFO;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Shell
extends Decorations {
    Menu activeMenu;
    ToolTip[] toolTips;
    int hIMC;
    int hwndMDIClient;
    int lpstrTip;
    int toolTipHandle;
    int balloonTipHandle;
    int menuItemToolTipHandle;
    int minWidth = -1;
    int minHeight = -1;
    int[] brushes;
    boolean showWithParent;
    boolean fullScreen;
    boolean wasMaximized;
    boolean modified;
    boolean center;
    String toolTitle;
    String balloonTitle;
    int toolIcon;
    int balloonIcon;
    int windowProc;
    Control lastActive;
    SHACTIVATEINFO psai;
    static int ToolTipProc;
    static final int DialogProc;
    static final TCHAR DialogClass;
    static final int[] SYSTEM_COLORS;
    static final int BRUSHES_SIZE = 32;

    public Shell() {
        this((Display)null);
    }

    public Shell(int n2) {
        this((Display)null, n2);
    }

    public Shell(Display display) {
        this(display, OS.IsWinCE ? 0 : 1264);
    }

    public Shell(Display display, int n2) {
        this(display, null, n2, 0, false);
    }

    Shell(Display display, Shell shell, int n2, int n3, boolean bl2) {
        this.checkSubclass();
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        if (shell != null && shell.isDisposed()) {
            this.error(5);
        }
        this.center = shell != null && (n2 & 0x10000000) != 0;
        this.style = Shell.checkStyle(shell, n2);
        this.parent = shell;
        this.display = display;
        this.handle = n3;
        if (n3 != 0 && !bl2) {
            this.state |= 0x4000;
        }
        this.reskinWidget();
        this.createWidget();
    }

    public Shell(Shell shell) {
        this(shell, OS.IsWinCE ? 0 : 2144);
    }

    public Shell(Shell shell, int n2) {
        this(shell != null ? shell.display : null, shell, n2, 0, false);
    }

    public static Shell win32_new(Display display, int n2) {
        return new Shell(display, null, 8, n2, true);
    }

    public static Shell internal_new(Display display, int n2) {
        return new Shell(display, null, 8, n2, false);
    }

    static int checkStyle(Shell shell, int n2) {
        n2 = Decorations.checkStyle(n2);
        int n3 = 229376;
        if (((n2 &= 0xBFFFFFFF) & 0x10000000) != 0) {
            n2 &= 0xEFFFFFFF;
            if (((n2 |= shell == null ? 1264 : 2144) & n3) == 0) {
                n2 |= shell == null ? 65536 : 32768;
            }
        }
        int n4 = n2 & ~n3;
        if ((n2 & 0x20000) != 0) {
            return n4 | 0x20000;
        }
        if ((n2 & 0x10000) != 0) {
            return n4 | 0x10000;
        }
        if ((n2 & 0x8000) != 0) {
            return n4 | 0x8000;
        }
        return n4;
    }

    public void addShellListener(ShellListener shellListener) {
        this.checkWidget();
        if (shellListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(shellListener);
        this.addListener(21, typedListener);
        this.addListener(19, typedListener);
        this.addListener(20, typedListener);
        this.addListener(26, typedListener);
        this.addListener(27, typedListener);
    }

    int balloonTipHandle() {
        if (this.balloonTipHandle == 0) {
            this.createBalloonTipHandle();
        }
        return this.balloonTipHandle;
    }

    @Override
    int callWindowProc(int n2, int n3, int n4, int n5) {
        int n6;
        if (this.handle == 0) {
            return 0;
        }
        if (n2 == this.toolTipHandle || n2 == this.balloonTipHandle || n2 == this.menuItemToolTipHandle) {
            return OS.CallWindowProc(ToolTipProc, n2, n3, n4, n5);
        }
        if (this.hwndMDIClient != 0) {
            return OS.DefFrameProc(n2, this.hwndMDIClient, n3, n4, n5);
        }
        if (this.windowProc != 0) {
            return OS.CallWindowProc(this.windowProc, n2, n3, n4, n5);
        }
        if ((this.style & 4) != 0 && (this.style & (n6 = 3312)) == 0) {
            return OS.DefWindowProc(n2, n3, n4, n5);
        }
        if ((this.style & 0x800000) != 0) {
            this.setItemEnabled(61456, false);
        }
        if (this.parent != null) {
            switch (n3) {
                case 7: 
                case 8: {
                    return OS.DefWindowProc(n2, n3, n4, n5);
                }
            }
            return OS.CallWindowProc(DialogProc, n2, n3, n4, n5);
        }
        return OS.DefWindowProc(n2, n3, n4, n5);
    }

    void center() {
        if (this.parent == null) {
            return;
        }
        Rectangle rectangle = this.getBoundsInPixels();
        Rectangle rectangle2 = this.display.mapInPixels((Control)this.parent, null, this.parent.getClientAreaInPixels());
        int n2 = Math.max(rectangle2.x, rectangle2.x + (rectangle2.width - rectangle.width) / 2);
        int n3 = Math.max(rectangle2.y, rectangle2.y + (rectangle2.height - rectangle.height) / 2);
        Rectangle rectangle3 = this.parent.getMonitor().getClientArea();
        n2 = n2 + rectangle.width > rectangle3.x + rectangle3.width ? Math.max(rectangle3.x, rectangle3.x + rectangle3.width - rectangle.width) : Math.max(n2, rectangle3.x);
        n3 = n3 + rectangle.height > rectangle3.y + rectangle3.height ? Math.max(rectangle3.y, rectangle3.y + rectangle3.height - rectangle.height) : Math.max(n3, rectangle3.y);
        this.setLocationInPixels(n2, n3);
    }

    public void close() {
        this.checkWidget();
        this.closeWidget();
    }

    void createBalloonTipHandle() {
        this.balloonTipHandle = OS.CreateWindowEx(0, new TCHAR(0, "tooltips_class32", true), null, 67, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, this.handle, 0, OS.GetModuleHandle(null), null);
        if (this.balloonTipHandle == 0) {
            this.error(2);
        }
        if (ToolTipProc == 0) {
            ToolTipProc = OS.GetWindowLongPtr(this.balloonTipHandle, -4);
        }
        OS.SendMessage(this.balloonTipHandle, 1048, 0, Short.MAX_VALUE);
        this.display.addControl(this.balloonTipHandle, this);
        OS.SetWindowLongPtr(this.balloonTipHandle, -4, this.display.windowProc);
    }

    @Override
    void createHandle() {
        boolean bl2;
        boolean bl3 = bl2 = this.handle != 0 && (this.state & 0x4000) == 0;
        if (this.handle == 0 || bl2) {
            super.createHandle();
        } else {
            this.state |= 2;
            if ((this.style & 0x300) == 0) {
                this.state |= 0x100;
            }
            this.windowProc = OS.GetWindowLongPtr(this.handle, -4);
        }
        if (!bl2) {
            int n2 = OS.GetWindowLong(this.handle, -16);
            n2 &= ~(OS.WS_OVERLAPPED | 0xC00000);
            if (!OS.IsWinCE) {
                n2 |= Integer.MIN_VALUE;
            }
            if ((this.style & 0x20) != 0) {
                n2 |= 0xC00000;
            }
            if ((this.style & 8) == 0 && (this.style & 0x810) == 0) {
                n2 |= 0x800000;
            }
            OS.SetWindowLong(this.handle, -16, n2);
            int n3 = 55;
            this.SetWindowPos(this.handle, 0, 0, 0, 0, 0, n3);
            if (OS.IsWinCE) {
                this._setMaximized(true);
            }
            if (OS.IsPPC) {
                this.psai = new SHACTIVATEINFO();
                this.psai.cbSize = SHACTIVATEINFO.sizeof;
            }
        }
        if (OS.IsDBLocale) {
            this.hIMC = OS.ImmCreateContext();
            if (this.hIMC != 0) {
                OS.ImmAssociateContext(this.handle, this.hIMC);
            }
        }
    }

    void createMenuItemToolTipHandle() {
        this.menuItemToolTipHandle = this.createToolTipHandle(0);
    }

    void createToolTip(ToolTip toolTip) {
        Object object;
        int n2 = 0;
        if (this.toolTips == null) {
            this.toolTips = new ToolTip[4];
        }
        while (n2 < this.toolTips.length && this.toolTips[n2] != null) {
            ++n2;
        }
        if (n2 == this.toolTips.length) {
            object = new ToolTip[this.toolTips.length + 4];
            System.arraycopy(this.toolTips, 0, object, 0, this.toolTips.length);
            this.toolTips = object;
        }
        this.toolTips[n2] = toolTip;
        toolTip.id = n2 + 108;
        if (OS.IsWinCE) {
            return;
        }
        object = new TOOLINFO();
        object.cbSize = TOOLINFO.sizeof;
        object.hwnd = this.handle;
        object.uId = toolTip.id;
        object.uFlags = 32;
        object.lpszText = -1;
        OS.SendMessage(toolTip.hwndToolTip(), OS.TTM_ADDTOOL, 0, (TOOLINFO)object);
    }

    void createToolTipHandle() {
        this.toolTipHandle = this.createToolTipHandle(this.handle);
    }

    int createToolTipHandle(int n2) {
        int n3 = OS.CreateWindowEx(0, new TCHAR(0, "tooltips_class32", true), null, 3, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, n2, 0, OS.GetModuleHandle(null), null);
        if (n3 == 0) {
            this.error(2);
        }
        if (ToolTipProc == 0) {
            ToolTipProc = OS.GetWindowLongPtr(n3, -4);
        }
        OS.SendMessage(n3, 1048, 0, Short.MAX_VALUE);
        this.display.addControl(n3, this);
        OS.SetWindowLongPtr(n3, -4, this.display.windowProc);
        return n3;
    }

    @Override
    void deregister() {
        super.deregister();
        if (this.toolTipHandle != 0) {
            this.display.removeControl(this.toolTipHandle);
        }
        if (this.balloonTipHandle != 0) {
            this.display.removeControl(this.balloonTipHandle);
        }
        if (this.menuItemToolTipHandle != 0) {
            this.display.removeControl(this.menuItemToolTipHandle);
        }
    }

    void destroyToolTip(ToolTip toolTip) {
        if (this.toolTips == null) {
            return;
        }
        this.toolTips[toolTip.id - 108] = null;
        if (OS.IsWinCE) {
            return;
        }
        if (this.balloonTipHandle != 0) {
            TOOLINFO tOOLINFO = new TOOLINFO();
            tOOLINFO.cbSize = TOOLINFO.sizeof;
            tOOLINFO.uId = toolTip.id;
            tOOLINFO.hwnd = this.handle;
            OS.SendMessage(this.balloonTipHandle, OS.TTM_DELTOOL, 0, tOOLINFO);
        }
        toolTip.id = -1;
    }

    @Override
    void destroyWidget() {
        this.fixActiveShell();
        super.destroyWidget();
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    void enableWidget(boolean bl2) {
        this.state = bl2 ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
        if (Display.TrimEnabled) {
            if (this.isActive()) {
                this.setItemEnabled(61536, bl2);
            }
        } else {
            OS.EnableWindow(this.handle, bl2);
        }
    }

    @Override
    int findBrush(int n2, int n3) {
        int n4;
        int n5;
        if (n3 == 0) {
            for (int i2 = 0; i2 < SYSTEM_COLORS.length; ++i2) {
                if (n2 != OS.GetSysColor(SYSTEM_COLORS[i2])) continue;
                return OS.GetSysColorBrush(SYSTEM_COLORS[i2]);
            }
        }
        if (this.brushes == null) {
            this.brushes = new int[32];
        }
        LOGBRUSH lOGBRUSH = new LOGBRUSH();
        block9: for (n5 = 0; n5 < this.brushes.length && (n4 = this.brushes[n5]) != 0; ++n5) {
            OS.GetObject(n4, LOGBRUSH.sizeof, lOGBRUSH);
            switch (lOGBRUSH.lbStyle) {
                case 0: {
                    if (n3 != 0 || lOGBRUSH.lbColor != n2) continue block9;
                    return n4;
                }
                case 3: {
                    if (n3 != 3 || lOGBRUSH.lbHatch != n2) continue block9;
                    return n4;
                }
            }
        }
        n5 = this.brushes.length;
        if ((n4 = this.brushes[--n5]) != 0) {
            OS.DeleteObject(n4);
        }
        System.arraycopy(this.brushes, 0, this.brushes, 1, n5);
        switch (n3) {
            case 0: {
                n4 = OS.CreateSolidBrush(n2);
                break;
            }
            case 3: {
                n4 = OS.CreatePatternBrush(n2);
            }
        }
        this.brushes[0] = n4;
        return this.brushes[0];
    }

    @Override
    Control findBackgroundControl() {
        return this.background != -1 || this.backgroundImage != null ? this : null;
    }

    @Override
    Cursor findCursor() {
        return this.cursor;
    }

    @Override
    Control findThemeControl() {
        return null;
    }

    ToolTip findToolTip(int n2) {
        if (this.toolTips == null) {
            return null;
        }
        return 0 <= (n2 -= 108) && n2 < this.toolTips.length ? this.toolTips[n2] : null;
    }

    void fixActiveShell() {
        int n2 = OS.GetParent(this.handle);
        if (n2 != 0 && this.handle == OS.GetActiveWindow() && !OS.IsWindowEnabled(n2) && OS.IsWindowVisible(n2)) {
            OS.SetActiveWindow(n2);
        }
    }

    void fixShell(Shell shell, Control control) {
        String string;
        if (this == shell) {
            return;
        }
        if (control == this.lastActive) {
            this.setActiveControl(null);
        }
        if ((string = control.toolTipText) != null) {
            control.setToolTipText(this, null);
            control.setToolTipText(shell, string);
        }
    }

    void fixToolTip() {
        if (OS.COMCTL32_MAJOR >= 6) {
            if (this.toolTipHandle == 0) {
                return;
            }
            TOOLINFO tOOLINFO = new TOOLINFO();
            tOOLINFO.cbSize = TOOLINFO.sizeof;
            if (OS.SendMessage(this.toolTipHandle, OS.TTM_GETCURRENTTOOL, 0, tOOLINFO) != 0 && (tOOLINFO.uFlags & 1) != 0) {
                OS.SendMessage(this.toolTipHandle, OS.TTM_DELTOOL, 0, tOOLINFO);
                OS.SendMessage(this.toolTipHandle, OS.TTM_ADDTOOL, 0, tOOLINFO);
            }
            TOOLINFO tOOLINFO2 = new TOOLINFO();
            tOOLINFO2.cbSize = TOOLINFO.sizeof;
            if (OS.SendMessage(this.menuItemToolTipHandle, OS.TTM_GETCURRENTTOOL, 0, tOOLINFO2) != 0 && (tOOLINFO2.uFlags & 1) != 0) {
                OS.SendMessage(this.menuItemToolTipHandle, OS.TTM_DELTOOL, 0, tOOLINFO2);
                OS.SendMessage(this.menuItemToolTipHandle, OS.TTM_ADDTOOL, 0, tOOLINFO2);
            }
        }
    }

    public void forceActive() {
        this.checkWidget();
        if (!this.isVisible()) {
            return;
        }
        OS.SetForegroundWindow(this.handle);
    }

    @Override
    void forceResize() {
    }

    public int getAlpha() {
        byte[] byArray;
        this.checkWidget();
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1) && OS.GetLayeredWindowAttributes(this.handle, null, byArray = new byte[1], null)) {
            return byArray[0] & 0xFF;
        }
        return 255;
    }

    @Override
    Rectangle getBoundsInPixels() {
        if (!OS.IsWinCE && OS.IsIconic(this.handle)) {
            return super.getBoundsInPixels();
        }
        RECT rECT = new RECT();
        OS.GetWindowRect(this.handle, rECT);
        int n2 = rECT.right - rECT.left;
        int n3 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n2, n3);
    }

    ToolTip getCurrentToolTip() {
        ToolTip toolTip;
        if (this.toolTipHandle != 0 && (toolTip = this.getCurrentToolTip(this.toolTipHandle)) != null) {
            return toolTip;
        }
        if (this.balloonTipHandle != 0 && (toolTip = this.getCurrentToolTip(this.balloonTipHandle)) != null) {
            return toolTip;
        }
        if (this.menuItemToolTipHandle != 0 && (toolTip = this.getCurrentToolTip(this.menuItemToolTipHandle)) != null) {
            return toolTip;
        }
        return null;
    }

    ToolTip getCurrentToolTip(int n2) {
        if (n2 == 0) {
            return null;
        }
        if (OS.SendMessage(n2, OS.TTM_GETCURRENTTOOL, 0, 0) != 0) {
            TOOLINFO tOOLINFO = new TOOLINFO();
            tOOLINFO.cbSize = TOOLINFO.sizeof;
            if (OS.SendMessage(n2, OS.TTM_GETCURRENTTOOL, 0, tOOLINFO) != 0 && (tOOLINFO.uFlags & 1) == 0) {
                return this.findToolTip(tOOLINFO.uId);
            }
        }
        return null;
    }

    @Override
    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public boolean getFullScreen() {
        this.checkWidget();
        return this.fullScreen;
    }

    public int getImeInputMode() {
        this.checkWidget();
        if (!OS.IsDBLocale) {
            return 0;
        }
        int n2 = OS.ImmGetContext(this.handle);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        boolean bl2 = OS.ImmGetOpenStatus(n2);
        if (bl2) {
            bl2 = OS.ImmGetConversionStatus(n2, nArray, nArray2);
        }
        OS.ImmReleaseContext(this.handle, n2);
        if (!bl2) {
            return 0;
        }
        int n3 = 0;
        if ((nArray[0] & 0x10) != 0) {
            n3 |= 0x20;
        }
        if ((nArray[0] & 8) != 0) {
            n3 |= 2;
        }
        if ((nArray[0] & 2) != 0) {
            return n3 | 0x10;
        }
        if ((nArray[0] & 1) != 0) {
            return n3 | 8;
        }
        return n3 | 4;
    }

    @Override
    Point getLocationInPixels() {
        if (!OS.IsWinCE && OS.IsIconic(this.handle)) {
            return super.getLocationInPixels();
        }
        RECT rECT = new RECT();
        OS.GetWindowRect(this.handle, rECT);
        return new Point(rECT.left, rECT.top);
    }

    @Override
    public boolean getMaximized() {
        this.checkWidget();
        return !this.fullScreen && super.getMaximized();
    }

    public Point getMinimumSize() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getMinimumSizeInPixels());
    }

    Point getMinimumSizeInPixels() {
        int n2 = Math.max(0, this.minWidth);
        int n3 = 1248;
        if ((this.style & 8) == 0 && (this.style & n3) != 0) {
            n2 = Math.max(n2, OS.GetSystemMetrics(34));
        }
        int n4 = Math.max(0, this.minHeight);
        if ((this.style & 8) == 0 && (this.style & n3) != 0) {
            if ((this.style & 0x10) != 0) {
                n4 = Math.max(n4, OS.GetSystemMetrics(35));
            } else {
                RECT rECT = new RECT();
                int n5 = OS.GetWindowLong(this.handle, -16);
                int n6 = OS.GetWindowLong(this.handle, -20);
                OS.AdjustWindowRectEx(rECT, n5, false, n6);
                n4 = Math.max(n4, rECT.bottom - rECT.top);
            }
        }
        return new Point(n2, n4);
    }

    public boolean getModified() {
        this.checkWidget();
        return this.modified;
    }

    @Override
    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    @Override
    public Shell getShell() {
        this.checkWidget();
        return this;
    }

    @Override
    Point getSizeInPixels() {
        if (!OS.IsWinCE && OS.IsIconic(this.handle)) {
            return super.getSizeInPixels();
        }
        RECT rECT = new RECT();
        OS.GetWindowRect(this.handle, rECT);
        int n2 = rECT.right - rECT.left;
        int n3 = rECT.bottom - rECT.top;
        return new Point(n2, n3);
    }

    public Shell[] getShells() {
        Shell[] shellArray;
        int n2;
        this.checkWidget();
        int n3 = 0;
        Shell[] shellArray2 = this.display.getShells();
        for (n2 = 0; n2 < shellArray2.length; ++n2) {
            shellArray = shellArray2[n2];
            while ((shellArray = shellArray.parent) != null && shellArray != this) {
            }
            if (shellArray != this) continue;
            ++n3;
        }
        n2 = 0;
        shellArray = new Shell[n3];
        for (int i2 = 0; i2 < shellArray2.length; ++i2) {
            Composite composite = shellArray2[i2];
            while ((composite = composite.parent) != null && composite != this) {
            }
            if (composite != this) continue;
            shellArray[n2++] = shellArray2[i2];
        }
        return shellArray;
    }

    public ToolBar getToolBar() {
        this.checkWidget();
        return null;
    }

    @Override
    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : null;
    }

    @Override
    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled();
    }

    @Override
    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    int hwndMDIClient() {
        if (this.hwndMDIClient == 0) {
            int n2 = 1174405121;
            this.hwndMDIClient = OS.CreateWindowEx(0, new TCHAR(0, "MDICLIENT", true), null, n2, 0, 0, 0, 0, this.handle, 0, OS.GetModuleHandle(null), new CREATESTRUCT());
        }
        return this.hwndMDIClient;
    }

    int menuItemToolTipHandle() {
        if (this.menuItemToolTipHandle == 0) {
            this.createMenuItemToolTipHandle();
        }
        return this.menuItemToolTipHandle;
    }

    public void open() {
        Control control;
        this.checkWidget();
        STARTUPINFO sTARTUPINFO = Display.lpStartupInfo;
        if (sTARTUPINFO == null || (sTARTUPINFO.dwFlags & 1) == 0) {
            this.bringToTop();
            if (this.isDisposed()) {
                return;
            }
        }
        if (OS.IsWinCE) {
            OS.SetForegroundWindow(this.handle);
        }
        OS.SendMessage(this.handle, 295, 3, 0);
        this.setVisible(true);
        if (this.isDisposed()) {
            return;
        }
        MSG mSG = new MSG();
        int n2 = 0x400002;
        OS.PeekMessage(mSG, 0, 0, 0, n2);
        boolean bl2 = this.restoreFocus();
        if (!bl2) {
            bl2 = this.traverseGroup(true);
        }
        if (bl2 && (control = this.display.getFocusControl()) instanceof Button && (control.style & 8) != 0) {
            bl2 = false;
        }
        if (!bl2) {
            if (this.saveDefault != null && !this.saveDefault.isDisposed()) {
                this.saveDefault.setFocus();
            } else {
                this.setFocus();
            }
        }
    }

    @Override
    public boolean print(GC gC) {
        this.checkWidget();
        if (gC == null) {
            this.error(4);
        }
        if (gC.isDisposed()) {
            this.error(5);
        }
        return false;
    }

    @Override
    void register() {
        super.register();
        if (this.toolTipHandle != 0) {
            this.display.addControl(this.toolTipHandle, this);
        }
        if (this.balloonTipHandle != 0) {
            this.display.addControl(this.balloonTipHandle, this);
        }
        if (this.menuItemToolTipHandle != 0) {
            this.display.addControl(this.menuItemToolTipHandle, this);
        }
    }

    void releaseBrushes() {
        if (this.brushes != null) {
            for (int i2 = 0; i2 < this.brushes.length; ++i2) {
                if (this.brushes[i2] == 0) continue;
                OS.DeleteObject(this.brushes[i2]);
            }
        }
        this.brushes = null;
    }

    @Override
    void releaseChildren(boolean bl2) {
        Widget widget;
        int n2;
        Shell[] shellArray = this.getShells();
        for (n2 = 0; n2 < shellArray.length; ++n2) {
            widget = shellArray[n2];
            if (widget == null || widget.isDisposed()) continue;
            widget.release(false);
        }
        if (this.toolTips != null) {
            for (n2 = 0; n2 < this.toolTips.length; ++n2) {
                widget = this.toolTips[n2];
                if (widget == null || widget.isDisposed()) continue;
                widget.release(false);
            }
        }
        this.toolTips = null;
        super.releaseChildren(bl2);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.hwndMDIClient = 0;
    }

    @Override
    void releaseParent() {
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.releaseBrushes();
        this.activeMenu = null;
        this.display.clearModal(this);
        if (this.lpstrTip != 0) {
            int n2 = OS.GetProcessHeap();
            OS.HeapFree(n2, 0, this.lpstrTip);
        }
        this.lpstrTip = 0;
        this.menuItemToolTipHandle = 0;
        this.balloonTipHandle = 0;
        this.toolTipHandle = 0;
        if (OS.IsDBLocale && this.hIMC != 0) {
            OS.ImmDestroyContext(this.hIMC);
        }
        this.lastActive = null;
        this.balloonTitle = null;
        this.toolTitle = null;
    }

    @Override
    void removeMenu(Menu menu) {
        super.removeMenu(menu);
        if (menu == this.activeMenu) {
            this.activeMenu = null;
        }
    }

    public void removeShellListener(ShellListener shellListener) {
        this.checkWidget();
        if (shellListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(21, shellListener);
        this.eventTable.unhook(19, shellListener);
        this.eventTable.unhook(20, shellListener);
        this.eventTable.unhook(26, shellListener);
        this.eventTable.unhook(27, shellListener);
    }

    @Override
    public void requestLayout() {
        this.layout(null, 4);
    }

    @Override
    void reskinChildren(int n2) {
        Widget widget;
        int n3;
        Shell[] shellArray = this.getShells();
        for (n3 = 0; n3 < shellArray.length; ++n3) {
            widget = shellArray[n3];
            if (widget == null) continue;
            widget.reskin(n2);
        }
        if (this.toolTips != null) {
            for (n3 = 0; n3 < this.toolTips.length; ++n3) {
                widget = this.toolTips[n3];
                if (widget == null) continue;
                widget.reskin(n2);
            }
        }
        super.reskinChildren(n2);
    }

    LRESULT selectPalette(int n2) {
        int n3 = OS.GetDC(this.handle);
        int n4 = OS.SelectPalette(n3, n2, false);
        int n5 = OS.RealizePalette(n3);
        if (n5 > 0) {
            OS.InvalidateRect(this.handle, null, true);
        } else {
            OS.SelectPalette(n3, n4, true);
            OS.RealizePalette(n3);
        }
        OS.ReleaseDC(this.handle, n3);
        return n5 > 0 ? LRESULT.ONE : LRESULT.ZERO;
    }

    @Override
    boolean sendKeyEvent(int n2, int n3, int n4, int n5, Event event) {
        if (!this.isEnabled() || !this.isActive()) {
            return false;
        }
        return super.sendKeyEvent(n2, n3, n4, n5, event);
    }

    public void setActive() {
        this.checkWidget();
        if (!this.isVisible()) {
            return;
        }
        this.bringToTop();
    }

    void setActiveControl(Control control) {
        this.setActiveControl(control, 0);
    }

    void setActiveControl(Control control, int n2) {
        int n3;
        int n4;
        if (control != null && control.isDisposed()) {
            control = null;
        }
        if (this.lastActive != null && this.lastActive.isDisposed()) {
            this.lastActive = null;
        }
        if (this.lastActive == control) {
            return;
        }
        Control[] controlArray = control == null ? new Control[]{} : control.getPath();
        Control[] controlArray2 = this.lastActive == null ? new Control[]{} : this.lastActive.getPath();
        this.lastActive = control;
        int n5 = Math.min(controlArray.length, controlArray2.length);
        for (n4 = 0; n4 < n5 && controlArray[n4] == controlArray2[n4]; ++n4) {
        }
        for (n3 = controlArray2.length - 1; n3 >= n4; --n3) {
            if (controlArray2[n3].isDisposed()) continue;
            controlArray2[n3].sendEvent(27);
        }
        for (n3 = controlArray.length - 1; n3 >= n4; --n3) {
            if (controlArray[n3].isDisposed()) continue;
            Event event = new Event();
            event.detail = n2;
            controlArray[n3].sendEvent(26, event);
        }
    }

    public void setAlpha(int n2) {
        this.checkWidget();
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1)) {
            int n3 = OS.GetWindowLong(this.handle, -20);
            if ((n2 &= 0xFF) == 255) {
                OS.SetWindowLong(this.handle, -20, n3 & 0xFFF7FFFF);
                int n4 = 1157;
                OS.RedrawWindow(this.handle, null, 0, n4);
            } else {
                OS.SetWindowLong(this.handle, -20, n3 | 0x80000);
                OS.SetLayeredWindowAttributes(this.handle, 0, (byte)n2, 2);
            }
        }
    }

    @Override
    void setBoundsInPixels(int n2, int n3, int n4, int n5, int n6, boolean bl2) {
        int n7;
        if (this.fullScreen) {
            this.setFullScreen(false);
        }
        if (((n7 = OS.GetWindowLong(this.handle, -20)) & 0x80000) != 0) {
            n6 &= 0xFFFFFFDF;
        }
        super.setBoundsInPixels(n2, n3, n4, n5, n6, false);
    }

    @Override
    public void setEnabled(boolean bl2) {
        this.checkWidget();
        if ((this.state & 8) == 0 == bl2) {
            return;
        }
        super.setEnabled(bl2);
        if (bl2 && this.handle == OS.GetActiveWindow() && !this.restoreFocus()) {
            this.traverseGroup(true);
        }
    }

    public void setFullScreen(boolean bl2) {
        this.checkWidget();
        if (this.fullScreen == bl2) {
            return;
        }
        int n2 = bl2 ? OS.SW_SHOWMAXIMIZED : OS.SW_RESTORE;
        int n3 = OS.GetWindowLong(this.handle, -16);
        int n4 = 1248;
        if ((this.style & n4) != 0) {
            if (bl2) {
                n3 &= ~(0xC00000 | OS.WS_MAXIMIZEBOX | OS.WS_MINIMIZEBOX);
            } else {
                n3 |= 0xC00000;
                if ((this.style & 0x400) != 0) {
                    n3 |= OS.WS_MAXIMIZEBOX;
                }
                if ((this.style & 0x80) != 0) {
                    n3 |= OS.WS_MINIMIZEBOX;
                }
            }
        }
        if (bl2) {
            this.wasMaximized = this.getMaximized();
        }
        boolean bl3 = this.isVisible();
        OS.SetWindowLong(this.handle, -16, n3);
        if (this.wasMaximized) {
            OS.ShowWindow(this.handle, 0);
            n2 = OS.SW_SHOWMAXIMIZED;
        }
        if (bl3) {
            OS.ShowWindow(this.handle, n2);
        }
        OS.UpdateWindow(this.handle);
        this.fullScreen = bl2;
    }

    public void setImeInputMode(int n2) {
        int[] nArray;
        int[] nArray2;
        this.checkWidget();
        if (!OS.IsDBLocale) {
            return;
        }
        boolean bl2 = n2 != 0;
        int n3 = OS.ImmGetContext(this.handle);
        OS.ImmSetOpenStatus(n3, bl2);
        if (bl2 && OS.ImmGetConversionStatus(n3, nArray2 = new int[1], nArray = new int[1])) {
            int n4;
            short s2;
            boolean bl3;
            int n5 = 0;
            int n6 = 3;
            if ((n2 & 0x10) != 0) {
                n5 = 3;
                n6 = 0;
            } else if ((n2 & 8) != 0) {
                n5 = 1;
                n6 = 2;
            }
            boolean bl4 = bl3 = (n2 & 2) != 0;
            if ((n2 & 8) != 0 && (s2 = OS.PRIMARYLANGID(OS.LOWORD(n4 = OS.GetKeyboardLayout(0)))) == 17) {
                bl3 = true;
            }
            if (bl3) {
                n5 |= 8;
            } else {
                n6 |= 8;
            }
            if ((n2 & 0x20) != 0) {
                n5 |= 0x10;
            } else {
                n6 |= 0x10;
            }
            nArray2[0] = nArray2[0] | n5;
            nArray2[0] = nArray2[0] & ~n6;
            OS.ImmSetConversionStatus(n3, nArray2[0], nArray[0]);
        }
        OS.ImmReleaseContext(this.handle, n3);
    }

    public void setMinimumSize(int n2, int n3) {
        this.checkWidget();
        this.setMinimumSizeInPixels(DPIUtil.autoScaleUp(n2), DPIUtil.autoScaleUp(n3));
    }

    void setMinimumSizeInPixels(int n2, int n3) {
        int n4;
        int n5;
        Object object;
        int n6 = 0;
        int n7 = 0;
        int n8 = 1248;
        if ((this.style & 8) == 0 && (this.style & n8) != 0) {
            n6 = OS.GetSystemMetrics(34);
            if ((this.style & 0x10) != 0) {
                n7 = OS.GetSystemMetrics(35);
            } else {
                object = new RECT();
                n5 = OS.GetWindowLong(this.handle, -16);
                n4 = OS.GetWindowLong(this.handle, -20);
                OS.AdjustWindowRectEx((RECT)object, n5, false, n4);
                n7 = ((RECT)object).bottom - ((RECT)object).top;
            }
        }
        this.minWidth = Math.max(n6, n2);
        this.minHeight = Math.max(n7, n3);
        object = this.getSizeInPixels();
        n5 = Math.max(((Point)object).x, this.minWidth);
        n4 = Math.max(((Point)object).y, this.minHeight);
        if (this.minWidth <= n6) {
            this.minWidth = -1;
        }
        if (this.minHeight <= n7) {
            this.minHeight = -1;
        }
        if (n5 != ((Point)object).x || n4 != ((Point)object).y) {
            this.setSizeInPixels(n5, n4);
        }
    }

    public void setMinimumSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        point = DPIUtil.autoScaleUp(point);
        this.setMinimumSizeInPixels(point.x, point.y);
    }

    public void setModified(boolean bl2) {
        this.checkWidget();
        this.modified = bl2;
    }

    void setItemEnabled(int n2, boolean bl2) {
        int n3 = OS.GetSystemMenu(this.handle, false);
        if (n3 == 0) {
            return;
        }
        int n4 = 0;
        if (!bl2) {
            n4 = 3;
        }
        OS.EnableMenuItem(n3, n2, 0 | n4);
    }

    @Override
    void setParent() {
    }

    @Override
    public void setRegion(Region region) {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            return;
        }
        if (region != null) {
            Rectangle rectangle = region.getBounds();
            this.setSize(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        }
        super.setRegion(region);
    }

    void setToolTipText(int n2, String string) {
        if (OS.IsWinCE) {
            return;
        }
        TOOLINFO tOOLINFO = new TOOLINFO();
        tOOLINFO.cbSize = TOOLINFO.sizeof;
        tOOLINFO.hwnd = this.handle;
        tOOLINFO.uId = n2;
        int n3 = this.toolTipHandle();
        if (string == null) {
            OS.SendMessage(n3, OS.TTM_DELTOOL, 0, tOOLINFO);
        } else if (OS.SendMessage(n3, OS.TTM_GETTOOLINFO, 0, tOOLINFO) != 0) {
            OS.SendMessage(n3, 1053, 0, 0);
        } else {
            tOOLINFO.uFlags = 17;
            tOOLINFO.lpszText = -1;
            OS.SendMessage(n3, OS.TTM_ADDTOOL, 0, tOOLINFO);
        }
    }

    void setToolTipText(NMTTDISPINFO nMTTDISPINFO, byte[] byArray) {
        if (!this.hasCursor()) {
            return;
        }
        int n2 = OS.GetProcessHeap();
        if (this.lpstrTip != 0) {
            OS.HeapFree(n2, 0, this.lpstrTip);
        }
        int n3 = byArray.length;
        this.lpstrTip = OS.HeapAlloc(n2, 8, n3);
        OS.MoveMemory(this.lpstrTip, byArray, n3);
        nMTTDISPINFO.lpszText = this.lpstrTip;
    }

    void setToolTipText(NMTTDISPINFO nMTTDISPINFO, char[] cArray) {
        if (!this.hasCursor()) {
            return;
        }
        int n2 = OS.GetProcessHeap();
        if (this.lpstrTip != 0) {
            OS.HeapFree(n2, 0, this.lpstrTip);
        }
        int n3 = cArray.length * 2;
        this.lpstrTip = OS.HeapAlloc(n2, 8, n3);
        OS.MoveMemory(this.lpstrTip, cArray, n3);
        nMTTDISPINFO.lpszText = this.lpstrTip;
    }

    void setToolTipTitle(int n2, String string, int n3) {
        if (n2 != this.toolTipHandle && n2 != this.balloonTipHandle && n2 != this.menuItemToolTipHandle) {
            return;
        }
        if (n2 == this.toolTipHandle || n2 == this.menuItemToolTipHandle) {
            if ((string == this.toolTitle || this.toolTitle != null && this.toolTitle.equals(string)) && n3 == this.toolIcon) {
                return;
            }
            this.toolTitle = string;
            this.toolIcon = n3;
        } else if (n2 == this.balloonTipHandle) {
            if ((string == this.balloonTitle || this.balloonTitle != null && this.balloonTitle.equals(string)) && n3 == this.toolIcon) {
                return;
            }
            this.balloonTitle = string;
            this.balloonIcon = n3;
        }
        if (string != null) {
            if (string.length() > 99) {
                string = string.substring(0, 99);
            }
            TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
            OS.SendMessage(n2, OS.TTM_SETTITLE, n3, tCHAR);
        } else {
            OS.SendMessage(n2, OS.TTM_SETTITLE, 0, 0);
        }
    }

    @Override
    public void setVisible(boolean bl2) {
        int n2;
        int n3;
        this.checkWidget();
        int n4 = 229376;
        if ((this.style & n4) != 0) {
            if (bl2) {
                Control control;
                this.display.setModalShell(this);
                if ((this.style & 0x30000) != 0) {
                    this.display.setModalDialog(null);
                }
                if ((control = this.display._getFocusControl()) != null && !control.isActive()) {
                    this.bringToTop();
                    if (this.isDisposed()) {
                        return;
                    }
                }
                if ((n3 = OS.GetActiveWindow()) == 0 && this.parent != null) {
                    n3 = this.parent.handle;
                }
                if (n3 != 0) {
                    OS.SendMessage(n3, 31, 0, 0);
                }
                OS.ReleaseCapture();
            } else {
                this.display.clearModal(this);
            }
        } else {
            this.updateModal();
        }
        if (this.showWithParent && !bl2 && !OS.IsWinCE) {
            OS.ShowOwnedPopups(this.handle, false);
        }
        if (!bl2) {
            this.fixActiveShell();
        }
        if (bl2 && this.center && !this.moved) {
            this.center();
            if (this.isDisposed()) {
                return;
            }
        }
        super.setVisible(bl2);
        if (this.isDisposed()) {
            return;
        }
        if (this.showWithParent != bl2) {
            this.showWithParent = bl2;
            if (bl2 && !OS.IsWinCE) {
                OS.ShowOwnedPopups(this.handle, true);
            }
        }
        if (bl2 && this.parent != null && (this.parent.state & 0x4000) != 0 && ((n3 = OS.GetWindowLong(n2 = this.parent.handle, -20)) & 0x80) != 0) {
            OS.SetWindowLong(n2, -20, n3 & 0xFFFFFF7F);
            OS.ShowWindow(n2, 0);
            OS.ShowWindow(n2, OS.SW_RESTORE);
        }
    }

    @Override
    void subclass() {
        super.subclass();
        if (ToolTipProc != 0) {
            int n2 = this.display.windowProc;
            if (this.toolTipHandle != 0) {
                OS.SetWindowLongPtr(this.toolTipHandle, -4, n2);
            }
            if (this.balloonTipHandle != 0) {
                OS.SetWindowLongPtr(this.balloonTipHandle, -4, n2);
            }
            if (this.menuItemToolTipHandle != 0) {
                OS.SetWindowLongPtr(this.menuItemToolTipHandle, -4, n2);
            }
        }
    }

    int toolTipHandle() {
        if (this.toolTipHandle == 0) {
            this.createToolTipHandle();
        }
        return this.toolTipHandle;
    }

    @Override
    boolean translateAccelerator(MSG mSG) {
        if (!this.isEnabled() || !this.isActive()) {
            return false;
        }
        if (this.menuBar != null && !this.menuBar.isEnabled()) {
            return false;
        }
        return this.translateMDIAccelerator(mSG) || this.translateMenuAccelerator(mSG);
    }

    @Override
    boolean traverseEscape() {
        if (this.parent == null) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        this.close();
        return true;
    }

    @Override
    void unsubclass() {
        super.unsubclass();
        if (ToolTipProc != 0) {
            if (this.toolTipHandle != 0) {
                OS.SetWindowLongPtr(this.toolTipHandle, -4, ToolTipProc);
            }
            if (this.toolTipHandle != 0) {
                OS.SetWindowLongPtr(this.toolTipHandle, -4, ToolTipProc);
            }
            if (this.menuItemToolTipHandle != 0) {
                OS.SetWindowLongPtr(this.menuItemToolTipHandle, -4, ToolTipProc);
            }
        }
    }

    void updateModal() {
        if (Display.TrimEnabled) {
            this.setItemEnabled(61536, this.isActive());
        } else {
            OS.EnableWindow(this.handle, this.isActive());
        }
    }

    @Override
    CREATESTRUCT widgetCreateStruct() {
        return null;
    }

    @Override
    int widgetParent() {
        if (this.handle != 0) {
            return this.handle;
        }
        return this.parent != null ? this.parent.handle : 0;
    }

    @Override
    int widgetExtStyle() {
        int n2 = super.widgetExtStyle() & 0xFFFFFFBF;
        if ((this.style & 4) != 0) {
            n2 |= 0x80;
        }
        if (!OS.IsWinCE && this.parent == null && (this.style & 0x4000) != 0) {
            int n3 = 1248;
            if ((this.style & 8) != 0 || (this.style & n3) == 0) {
                n2 |= 0x80;
            }
        }
        if (this.parent != null) {
            if (OS.IsWin95) {
                return n2;
            }
            if (OS.WIN32_VERSION < OS.VERSION(4, 10)) {
                return n2;
            }
        }
        if ((this.style & 0x4000) != 0) {
            n2 |= 8;
        }
        return n2;
    }

    @Override
    TCHAR windowClass() {
        int n2;
        if (OS.IsSP) {
            return DialogClass;
        }
        if ((this.style & 4) != 0 && (this.style & (n2 = 3312)) == 0) {
            return this.display.windowShadowClass;
        }
        return this.parent != null ? DialogClass : super.windowClass();
    }

    @Override
    int windowProc() {
        int n2;
        if (this.windowProc != 0) {
            return this.windowProc;
        }
        if (OS.IsSP) {
            return DialogProc;
        }
        if ((this.style & 4) != 0 && (this.style & (n2 = 3312)) == 0) {
            return super.windowProc();
        }
        return this.parent != null ? DialogProc : super.windowProc();
    }

    @Override
    int windowProc(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            return 0;
        }
        if ((this.style & 0x800000) != 0 && n3 == 161 && n4 == 2) {
            return 0;
        }
        if (n2 == this.toolTipHandle || n2 == this.balloonTipHandle || n2 == this.menuItemToolTipHandle) {
            switch (n3) {
                case 275: {
                    ToolTip toolTip;
                    if (n4 != 100 || (toolTip = this.getCurrentToolTip(n2)) == null || !toolTip.autoHide) break;
                    toolTip.setVisible(false);
                    break;
                }
                case 513: {
                    ToolTip toolTip = this.getCurrentToolTip(n2);
                    if (toolTip == null) break;
                    toolTip.setVisible(false);
                    toolTip.sendSelectionEvent(13);
                    break;
                }
            }
            return this.callWindowProc(n2, n3, n4, n5);
        }
        return super.windowProc(n2, n3, n4, n5);
    }

    @Override
    int widgetStyle() {
        int n2 = super.widgetStyle();
        if (this.handle != 0) {
            return n2 | 0x40000000;
        }
        n2 &= 0xBFFFFFFF;
        if (OS.IsWinCE) {
            if (OS.IsSP) {
                return n2 | Integer.MIN_VALUE;
            }
            return this.parent == null ? n2 : n2 | Integer.MIN_VALUE;
        }
        return n2 | OS.WS_OVERLAPPED | 0xC00000;
    }

    @Override
    LRESULT WM_ACTIVATE(int n2, int n3) {
        ToolTip toolTip;
        if (OS.IsPPC) {
            if (this.hooks(33) || this.hooks(34)) {
                int n4 = OS.LOWORD(n2);
                int n5 = n4 != 0 ? this.handle : 0;
                for (int i2 = 193; i2 <= 198; ++i2) {
                    OS.SHSetAppKeyWndAssoc((byte)i2, n5);
                }
            }
            if (OS.LOWORD(n2) != 0) {
                OS.SHSipPreference(this.handle, this.psai.fSipUp == 0 ? 1 : 0);
            }
        }
        if (OS.WIN32_VERSION >= OS.VERSION(5, 1) && OS.LOWORD(n2) == 0 && OS.IsDBLocale && this.hIMC != 0 && OS.ImmGetOpenStatus(this.hIMC)) {
            OS.ImmNotifyIME(this.hIMC, 21, 1, 0);
        }
        LRESULT lRESULT = super.WM_ACTIVATE(n2, n3);
        if (OS.LOWORD(n2) == 0 && (n3 == 0 || n3 != this.toolTipHandle && n3 != this.balloonTipHandle && n3 != this.menuItemToolTipHandle) && (toolTip = this.getCurrentToolTip()) != null) {
            toolTip.setVisible(false);
        }
        return this.parent != null ? LRESULT.ZERO : lRESULT;
    }

    @Override
    LRESULT WM_COMMAND(int n2, int n3) {
        int n4;
        if (OS.IsPPC && (n4 = OS.LOWORD(n2)) == 1 && (n3 == 0 || n3 == this.handle)) {
            OS.PostMessage(this.handle, 16, 0, 0);
            return LRESULT.ZERO;
        }
        if ((OS.IsPPC || OS.IsSP) && this.menuBar != null) {
            n4 = this.menuBar.hwndCB;
            if (n3 != 0 && n4 != 0) {
                if (n3 == n4) {
                    return super.WM_COMMAND(n2, 0);
                }
                int n5 = OS.GetWindow(n4, 5);
                if (n3 == n5) {
                    return super.WM_COMMAND(n2, 0);
                }
            }
        }
        return super.WM_COMMAND(n2, n3);
    }

    @Override
    LRESULT WM_DESTROY(int n2, int n3) {
        LRESULT lRESULT = super.WM_DESTROY(n2, n3);
        int n4 = OS.GetWindowLong(this.handle, -16);
        if ((n4 & 0x40000000) != 0) {
            this.releaseParent();
            this.release(false);
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_ERASEBKGND(int n2, int n3) {
        LRESULT lRESULT = super.WM_ERASEBKGND(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (!OS.IsWinCE && OS.WIN32_VERSION == OS.VERSION(6, 0)) {
            this.drawBackground(n2);
            return LRESULT.ONE;
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_ENTERIDLE(int n2, int n3) {
        LRESULT lRESULT = super.WM_ENTERIDLE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        Display display = this.display;
        if (display.runMessages && display.runAsyncMessages(false)) {
            display.wakeThread();
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_GETMINMAXINFO(int n2, int n3) {
        LRESULT lRESULT = super.WM_GETMINMAXINFO(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.minWidth != -1 || this.minHeight != -1) {
            MINMAXINFO mINMAXINFO = new MINMAXINFO();
            OS.MoveMemory(mINMAXINFO, n3, MINMAXINFO.sizeof);
            if (this.minWidth != -1) {
                mINMAXINFO.ptMinTrackSize_x = this.minWidth;
            }
            if (this.minHeight != -1) {
                mINMAXINFO.ptMinTrackSize_y = this.minHeight;
            }
            OS.MoveMemory(n3, mINMAXINFO, MINMAXINFO.sizeof);
            return LRESULT.ZERO;
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_MOUSEACTIVATE(int n2, int n3) {
        int n4;
        int n5;
        Object object;
        LRESULT lRESULT = super.WM_MOUSEACTIVATE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        short s2 = (short)OS.LOWORD(n3);
        switch (s2) {
            case -2: 
            case -1: 
            case 0: {
                break;
            }
            default: {
                Decorations decorations;
                object = this.display._getFocusControl();
                if (object == null || (decorations = ((Control)object).menuShell()).getShell() != this || decorations == this) break;
                this.display.ignoreRestoreFocus = true;
                this.display.lastHittest = s2;
                this.display.lastHittestControl = null;
                if (s2 == 5 || s2 == 3) {
                    this.display.lastHittestControl = object;
                    return null;
                }
                if (OS.IsWin95 && s2 == 2) {
                    this.display.lastHittestControl = object;
                }
                return new LRESULT(3);
            }
        }
        if (s2 == 5) {
            return null;
        }
        object = new POINT();
        if (!OS.GetCursorPos((POINT)object)) {
            int n6 = OS.GetMessagePos();
            OS.POINTSTOPOINT((POINT)object, n6);
        }
        if ((n5 = OS.WindowFromPoint((POINT)object)) == 0) {
            return null;
        }
        Control control = this.display.findControl(n5);
        if (control != null && (control.state & 2) != 0 && (control.style & 0x80000) != 0 && (this.style & (n4 = 540672)) == n4 && (s2 == 18 || s2 == 1)) {
            return new LRESULT(3);
        }
        n4 = this.callWindowProc(this.handle, 33, n2, n3);
        this.setActiveControl(control, 3);
        return new LRESULT(n4);
    }

    @Override
    LRESULT WM_MOVE(int n2, int n3) {
        LRESULT lRESULT = super.WM_MOVE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        ToolTip toolTip = this.getCurrentToolTip();
        if (toolTip != null) {
            toolTip.setVisible(false);
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_NCHITTEST(int n2, int n3) {
        if (!OS.IsWindowEnabled(this.handle)) {
            return null;
        }
        if (!this.isEnabled() || !this.isActive()) {
            if (!Display.TrimEnabled) {
                return new LRESULT(0);
            }
            int n4 = this.callWindowProc(this.handle, 132, n2, n3);
            if (n4 == 1 || n4 == 5) {
                n4 = 18;
            }
            return new LRESULT(n4);
        }
        if (this.menuBar != null && !this.menuBar.getEnabled()) {
            int n5 = this.callWindowProc(this.handle, 132, n2, n3);
            if (n5 == 5) {
                n5 = 18;
            }
            return new LRESULT(n5);
        }
        return null;
    }

    @Override
    LRESULT WM_NCLBUTTONDOWN(int n2, int n3) {
        Control control;
        boolean bl2;
        LRESULT lRESULT = super.WM_NCLBUTTONDOWN(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (!this.display.ignoreRestoreFocus) {
            return lRESULT;
        }
        Display display = this.display;
        int n4 = 0;
        boolean bl3 = bl2 = OS.IsWin95 && display.lastHittest == 2;
        if (bl2) {
            n4 = OS.SetActiveWindow(this.handle);
        }
        display.lockActiveWindow = true;
        int n5 = this.callWindowProc(this.handle, 161, n2, n3);
        display.lockActiveWindow = false;
        if (bl2) {
            OS.SetActiveWindow(n4);
        }
        if ((control = display.lastHittestControl) != null && !control.isDisposed()) {
            control.setFocus();
        }
        display.lastHittestControl = null;
        display.ignoreRestoreFocus = false;
        return new LRESULT(n5);
    }

    @Override
    LRESULT WM_PALETTECHANGED(int n2, int n3) {
        int n4;
        if (n2 != this.handle && (n4 = this.display.hPalette) != 0) {
            return this.selectPalette(n4);
        }
        return super.WM_PALETTECHANGED(n2, n3);
    }

    @Override
    LRESULT WM_QUERYNEWPALETTE(int n2, int n3) {
        int n4 = this.display.hPalette;
        if (n4 != 0) {
            return this.selectPalette(n4);
        }
        return super.WM_QUERYNEWPALETTE(n2, n3);
    }

    @Override
    LRESULT WM_SETCURSOR(int n2, int n3) {
        Control control;
        short s2;
        int n4 = OS.HIWORD(n3);
        if (n4 == 513) {
            int n5;
            int n6;
            Shell shell;
            if (!Display.TrimEnabled && (shell = this.display.getModalShell()) != null && !this.isActive() && OS.IsWindowEnabled(n6 = shell.handle)) {
                OS.SetActiveWindow(n6);
            }
            if (!OS.IsWindowEnabled(this.handle) && !OS.IsWinCE && (n5 = OS.GetLastActivePopup(this.handle)) != 0 && n5 != this.handle && this.display.getControl(n5) == null && OS.IsWindowEnabled(n5)) {
                OS.SetActiveWindow(n5);
            }
        }
        if ((s2 = (short)OS.LOWORD(n3)) == -2 && !this.getEnabled() && (control = this.display.getControl(n2)) == this && this.cursor != null) {
            POINT pOINT = new POINT();
            int n7 = OS.GetMessagePos();
            OS.POINTSTOPOINT(pOINT, n7);
            OS.ScreenToClient(this.handle, pOINT);
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            if (OS.PtInRect(rECT, pOINT)) {
                OS.SetCursor(this.cursor.handle);
                switch (n4) {
                    case 513: 
                    case 516: 
                    case 519: 
                    case 523: {
                        OS.MessageBeep(0);
                    }
                }
                return LRESULT.ONE;
            }
        }
        return super.WM_SETCURSOR(n2, n3);
    }

    @Override
    LRESULT WM_SETTINGCHANGE(int n2, int n3) {
        LRESULT lRESULT = super.WM_SETTINGCHANGE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.IsPPC && n2 == 224) {
            if ((this.style & 0x10) != 0) {
                OS.SHHandleWMSettingChange(this.handle, n2, n3, this.psai);
                return LRESULT.ZERO;
            }
            SIPINFO sIPINFO = new SIPINFO();
            sIPINFO.cbSize = SIPINFO.sizeof;
            OS.SipGetInfo(sIPINFO);
            this.psai.fSipUp = sIPINFO.fdwFlags & 1;
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_SHOWWINDOW(int n2, int n3) {
        LRESULT lRESULT = super.WM_SHOWWINDOW(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (n3 == 3) {
            Composite composite = this;
            while (composite != null) {
                Shell shell = ((Control)composite).getShell();
                if (!shell.showWithParent) {
                    return LRESULT.ZERO;
                }
                composite = composite.parent;
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_SYSCOMMAND(int n2, int n3) {
        LRESULT lRESULT = super.WM_SYSCOMMAND(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.IsWinNT && OS.WIN32_VERSION < OS.VERSION(6, 0)) {
            int n4 = n2 & 0xFFF0;
            switch (n4) {
                case 61472: {
                    long l2;
                    Shell[] shellArray = this.display.getShells();
                    int n5 = 0;
                    for (int i2 = 0; i2 < shellArray.length; ++i2) {
                        Shell shell = shellArray[i2];
                        if (shell == null || !shell.getVisible() || shell.getMinimized()) continue;
                        ++n5;
                    }
                    if (n5 > 1 || (l2 = Runtime.getRuntime().totalMemory()) < 0x2000000L) break;
                    OS.ShowWindow(this.handle, 2);
                    return LRESULT.ZERO;
                }
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_WINDOWPOSCHANGING(int n2, int n3) {
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGING(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        WINDOWPOS wINDOWPOS = new WINDOWPOS();
        OS.MoveMemory(wINDOWPOS, n3, WINDOWPOS.sizeof);
        if ((wINDOWPOS.flags & 1) == 0) {
            wINDOWPOS.cx = Math.max(wINDOWPOS.cx, this.minWidth);
            int n4 = 1248;
            if ((this.style & 8) == 0 && (this.style & n4) != 0) {
                wINDOWPOS.cx = Math.max(wINDOWPOS.cx, OS.GetSystemMetrics(34));
            }
            wINDOWPOS.cy = Math.max(wINDOWPOS.cy, this.minHeight);
            if ((this.style & 8) == 0 && (this.style & n4) != 0) {
                if ((this.style & 0x10) != 0) {
                    wINDOWPOS.cy = Math.max(wINDOWPOS.cy, OS.GetSystemMetrics(35));
                } else {
                    RECT rECT = new RECT();
                    int n5 = OS.GetWindowLong(this.handle, -16);
                    int n6 = OS.GetWindowLong(this.handle, -20);
                    OS.AdjustWindowRectEx(rECT, n5, false, n6);
                    wINDOWPOS.cy = Math.max(wINDOWPOS.cy, rECT.bottom - rECT.top);
                }
            }
            OS.MoveMemory(n3, wINDOWPOS, WINDOWPOS.sizeof);
        }
        return lRESULT;
    }

    static {
        DialogClass = new TCHAR(0, OS.IsWinCE ? "Dialog" : "#32770", true);
        SYSTEM_COLORS = new int[]{OS.COLOR_BTNFACE, OS.COLOR_WINDOW, OS.COLOR_BTNTEXT, OS.COLOR_WINDOWTEXT, OS.COLOR_HIGHLIGHT, OS.COLOR_SCROLLBAR};
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, DialogClass, wNDCLASS);
        DialogProc = wNDCLASS.lpfnWndProc;
    }
}

