/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import sun.misc.Unsafe;

public abstract class Pointer$Default
implements Pointer {
    protected static final Unsafe UNSAFE = MemoryUtil.UNSAFE;
    protected static final long ADDRESS;
    protected static final long BUFFER_CONTAINER;
    protected static final long BUFFER_MARK;
    protected static final long BUFFER_POSITION;
    protected static final long BUFFER_LIMIT;
    protected static final long BUFFER_CAPACITY;
    protected long address;

    protected Pointer$Default(long l2) {
        if (Checks.CHECKS && l2 == 0L) {
            throw new NullPointerException();
        }
        this.address = l2;
    }

    @Override
    public long address() {
        return this.address;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Pointer)) {
            return false;
        }
        Pointer pointer = (Pointer)object;
        return this.address == pointer.address();
    }

    public int hashCode() {
        return (int)(this.address ^ this.address >>> 32);
    }

    public String toString() {
        return String.format("%s pointer [0x%X]", this.getClass().getSimpleName(), this.address);
    }

    static {
        try {
            ADDRESS = UNSAFE.objectFieldOffset(Pointer$Default.class.getDeclaredField("address"));
            BUFFER_CONTAINER = UNSAFE.objectFieldOffset(CustomBuffer.class.getDeclaredField("container"));
            BUFFER_MARK = UNSAFE.objectFieldOffset(CustomBuffer.class.getDeclaredField("mark"));
            BUFFER_POSITION = UNSAFE.objectFieldOffset(CustomBuffer.class.getDeclaredField("position"));
            BUFFER_LIMIT = UNSAFE.objectFieldOffset(CustomBuffer.class.getDeclaredField("limit"));
            BUFFER_CAPACITY = UNSAFE.objectFieldOffset(CustomBuffer.class.getDeclaredField("capacity"));
        }
        catch (Throwable throwable) {
            throw new UnsupportedOperationException(throwable);
        }
    }
}

